-- Clinic Pro V3 Database Backup
-- Created: 2025-10-14T10:15:37.307Z
-- Tables: 51

SET FOREIGN_KEY_CHECKS=0;

-- Table: tbl_alert
DROP TABLE IF EXISTS `tbl_alert`;
CREATE TABLE `tbl_alert` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_appointment
DROP TABLE IF EXISTS `tbl_appointment`;
CREATE TABLE `tbl_appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `case_` varchar(50) DEFAULT NULL,
  `dr_name` varchar(50) DEFAULT NULL,
  `token_number` varchar(50) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_case
DROP TABLE IF EXISTS `tbl_case`;
CREATE TABLE `tbl_case` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_case
INSERT INTO `tbl_case` (`id`, `name`) VALUES
(1, 'Fever'),
(2, 'Cold & Flu'),
(3, 'Headache'),
(4, 'Stomach Pain'),
(5, 'Injury'),
(6, 'Diabetes'),
(7, 'Hypertension'),
(8, 'Check-up'),
(9, 'Follow-up'),
(10, 'Vaccination'),
(11, 'Fever'),
(12, 'Cold & Flu'),
(13, 'Headache'),
(14, 'Stomach Pain'),
(15, 'Injury'),
(16, 'Diabetes'),
(17, 'Hypertension'),
(18, 'Check-up'),
(19, 'Follow-up'),
(20, 'Vaccination'),
(21, 'Fever'),
(22, 'Cold & Flu'),
(23, 'Headache'),
(24, 'Stomach Pain'),
(25, 'Injury'),
(26, 'Diabetes'),
(27, 'Hypertension'),
(28, 'Check-up'),
(29, 'Follow-up'),
(30, 'Vaccination');

-- Table: tbl_cat_expenses
DROP TABLE IF EXISTS `tbl_cat_expenses`;
CREATE TABLE `tbl_cat_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_cat_expenses
INSERT INTO `tbl_cat_expenses` (`id`, `name`) VALUES
(1, 'Salary'),
(2, 'Utilities'),
(3, 'Rent'),
(4, 'Maintenance'),
(5, 'Office Supplies'),
(6, 'Transportation'),
(7, 'Salary'),
(8, 'Utilities'),
(9, 'Rent'),
(10, 'Maintenance'),
(11, 'Office Supplies'),
(12, 'Transportation'),
(13, 'Salary'),
(14, 'Utilities'),
(15, 'Rent'),
(16, 'Maintenance'),
(17, 'Office Supplies'),
(18, 'Transportation');

-- Table: tbl_catalog
DROP TABLE IF EXISTS `tbl_catalog`;
CREATE TABLE `tbl_catalog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_catalog
INSERT INTO `tbl_catalog` (`id`, `name`) VALUES
(1, 'Tablets'),
(2, 'Capsules'),
(3, 'Syrup'),
(4, 'Injection'),
(5, 'Medical Equipment'),
(6, 'First Aid'),
(7, 'Vitamins & Supplements'),
(8, 'Tablets'),
(9, 'Capsules'),
(10, 'Syrup'),
(11, 'Injection'),
(12, 'Medical Equipment'),
(13, 'First Aid'),
(14, 'Vitamins & Supplements'),
(15, 'Tablets'),
(16, 'Capsules'),
(17, 'Syrup'),
(18, 'Injection'),
(19, 'Medical Equipment'),
(20, 'First Aid'),
(21, 'Vitamins & Supplements');

-- Table: tbl_catalog_2
DROP TABLE IF EXISTS `tbl_catalog_2`;
CREATE TABLE `tbl_catalog_2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_customer
DROP TABLE IF EXISTS `tbl_customer`;
CREATE TABLE `tbl_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `shop` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `remark` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_customer
INSERT INTO `tbl_customer` (`id`, `name`, `ph_no`, `nrc_no`, `shop`, `address`, `date`, `remark`) VALUES
(1, 'Aung Aung', '09-111111111', '12/YKNXXX', 'Aung Aung Pharmacy', 'Downtown, Yangon', '2025-10-13 00:00:00', 'Regular customer'),
(2, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-13 00:00:00', 'VIP customer'),
(3, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-13 00:00:00', 'Good credit'),
(4, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-13 00:00:00', 'Monthly payment'),
(5, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-13 00:00:00', 'Wholesale buyer'),
(6, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-13 00:00:00', 'Retail customer'),
(7, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-13 00:00:00', 'Regional customer'),
(8, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-13 00:00:00', 'Cash only'),
(9, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-13 00:00:00', 'Credit customer'),
(10, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-13 00:00:00', 'New customer'),
(11, 'Aung Aung', '09-111111111', '12/YKNXXX', 'Aung Aung Pharmacy', 'Downtown, Yangon', '2025-10-14 00:00:00', 'Regular customer'),
(12, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-14 00:00:00', 'VIP customer'),
(13, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-14 00:00:00', 'Good credit'),
(14, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-14 00:00:00', 'Monthly payment'),
(15, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-14 00:00:00', 'Wholesale buyer'),
(16, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-14 00:00:00', 'Retail customer'),
(17, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-14 00:00:00', 'Regional customer'),
(18, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-14 00:00:00', 'Cash only'),
(19, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-14 00:00:00', 'Credit customer'),
(20, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-14 00:00:00', 'New customer'),
(21, 'Aung Aung', '09-111111111', '12/YKNXXX', 'Aung Aung Pharmacy', 'Downtown, Yangon', '2025-10-14 00:00:00', 'Regular customer'),
(22, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-14 00:00:00', 'VIP customer'),
(23, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-14 00:00:00', 'Good credit'),
(24, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-14 00:00:00', 'Monthly payment'),
(25, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-14 00:00:00', 'Wholesale buyer'),
(26, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-14 00:00:00', 'Retail customer'),
(27, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-14 00:00:00', 'Regional customer'),
(28, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-14 00:00:00', 'Cash only'),
(29, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-14 00:00:00', 'Credit customer'),
(30, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-14 00:00:00', 'New customer');

-- Table: tbl_customer_debt
DROP TABLE IF EXISTS `tbl_customer_debt`;
CREATE TABLE `tbl_customer_debt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_doctor
DROP TABLE IF EXISTS `tbl_doctor`;
CREATE TABLE `tbl_doctor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `education` varchar(250) DEFAULT NULL,
  `specialist` varchar(250) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_doctor
INSERT INTO `tbl_doctor` (`id`, `name`, `phone`, `education`, `specialist`, `photo`, `remark`) VALUES
(2, 'Dr. Su Su', '09-222222222', 'MBBS, MD (Peds)', 'Pediatrician', NULL, 'Available Mon-Sat'),
(4, 'asdasd', '141', 'asd', 'asd', '/uploads/MSI_MEG_GODLIKE-1760344259113-965122969.jpg', 'asd'),
(6, 'Dr. Su Su', '09-222222222', 'MBBS, MD (Peds)', 'Pediatrician', NULL, 'Available Mon-Sat'),
(7, 'Dr. Kyaw Kyaw', '09-333333333', 'MBBS, MS (Ortho)', 'Orthopedic Surgeon', NULL, 'Available on appointment'),
(9, 'Dr. Su Su', '09-222222222', 'MBBS, MD (Peds)', 'Pediatrician', NULL, 'Available Mon-Sat'),
(10, 'Dr. Kyaw Kyaw', '09-333333333', 'MBBS, MS (Ortho)', 'Orthopedic Surgeon', NULL, 'Available on appointment');

-- Table: tbl_expenses
DROP TABLE IF EXISTS `tbl_expenses`;
CREATE TABLE `tbl_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_exp_id` varchar(50) NOT NULL,
  `amount` double NOT NULL,
  `user_name` varchar(50) NOT NULL,
  `reason` varchar(50) NOT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date NOT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_form
DROP TABLE IF EXISTS `tbl_form`;
CREATE TABLE `tbl_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` varchar(50) NOT NULL,
  `sale` varchar(50) NOT NULL,
  `buy` varchar(50) NOT NULL,
  `product` varchar(50) NOT NULL,
  `change_item_price` varchar(50) NOT NULL,
  `cashier` varchar(50) NOT NULL,
  `login_user` varchar(50) NOT NULL,
  `customer` varchar(50) NOT NULL,
  `supplier` varchar(50) NOT NULL,
  `barcode` varchar(50) NOT NULL,
  `expenses` varchar(50) NOT NULL,
  `report` varchar(50) NOT NULL,
  `setting` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_images
DROP TABLE IF EXISTS `tbl_images`;
CREATE TABLE `tbl_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) DEFAULT NULL,
  `treatment_id` int(11) DEFAULT NULL,
  `image` longblob DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `upload_date` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_images
INSERT INTO `tbl_images` (`id`, `patient_id`, `treatment_id`, `image`, `image_path`, `upload_date`) VALUES
(1, 'OPD-002', 166, NULL, '/uploads/medical/medical-1760425881780-357614226.jpg', '2025-10-14 13:41:21'),
(2, 'OPD-002', 166, NULL, '/uploads/medical/medical-1760425881793-593704708.jpg', '2025-10-14 13:41:21'),
(3, 'OPD-002', 166, NULL, '/uploads/medical/medical-1760425881798-291870776.jpg', '2025-10-14 13:41:21'),
(4, 'OPD-001', 171, NULL, '/uploads/medical/medical-1760431356335-207051746.jpg', '2025-10-14 15:12:36'),
(5, 'OPD-001', 56, NULL, '/uploads/medical/medical-1760432005772-466757307.png', '2025-10-14 15:23:25'),
(6, 'OPD-001', 56, NULL, '/uploads/medical/medical-1760432005796-485716106.jpg', '2025-10-14 15:23:25'),
(7, 'OPD-001', 56, NULL, '/uploads/medical/medical-1760432005812-90595735.jpg', '2025-10-14 15:23:25'),
(8, 'OPD-001', 56, NULL, '/uploads/medical/medical-1760432005830-332046299.jpg', '2025-10-14 15:23:25'),
(9, 'OPD-001', 56, NULL, '/uploads/medical/medical-1760432005836-227641877.jpg', '2025-10-14 15:23:25'),
(10, 'OPD-001', 56, NULL, '/uploads/medical/medical-1760432005860-152178083.jpg', '2025-10-14 15:23:25');

-- Table: tbl_inpatient
DROP TABLE IF EXISTS `tbl_inpatient`;
CREATE TABLE `tbl_inpatient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `case_` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `dr_name` varchar(250) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  `room_no` varchar(250) DEFAULT NULL,
  `deposit` int(11) DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_inpatient
INSERT INTO `tbl_inpatient` (`id`, `name`, `age`, `phone`, `address`, `case_`, `remark`, `start_date`, `dr_name`, `patient_id`, `room_no`, `deposit`, `end_date`) VALUES
(1, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, NULL),
(2, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-08 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, NULL),
(3, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-11 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, NULL),
(4, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 1000000, NULL),
(5, 'U Kyaw Soe', '62', '09-565656565', 'Hlaing, Yangon', 'Stroke', 'Stable condition, physiotherapy started', '2025-10-06 00:00:00', 'Dr. Aung Aung', 'IPD-005', 'R-104', 1500000, NULL),
(6, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, NULL),
(7, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-09 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, NULL),
(8, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, NULL),
(9, 'U Win Htun', '55', '09-909090909', 'Botataung, Yangon', 'Gastric Ulcer', 'Medical management', '2025-10-11 00:00:00', 'Dr. Aung Aung', 'IPD-009', 'R-107', 450000, NULL),
(10, 'Daw Yin', '43', '09-101010101', 'Insein, Yangon', 'Gallbladder Surgery', 'Post-op day 3', '2025-10-10 00:00:00', 'Dr. Myo Myo', 'IPD-010', 'R-203', 900000, NULL),
(11, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-11 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, NULL),
(12, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-09 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, NULL),
(13, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, NULL),
(14, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 1000000, NULL),
(15, 'U Kyaw Soe', '62', '09-565656565', 'Hlaing, Yangon', 'Stroke', 'Stable condition, physiotherapy started', '2025-10-07 00:00:00', 'Dr. Aung Aung', 'IPD-005', 'R-104', 1500000, NULL),
(16, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, NULL),
(17, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, NULL),
(18, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, NULL),
(19, 'U Win Htun', '55', '09-909090909', 'Botataung, Yangon', 'Gastric Ulcer', 'Medical management', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-009', 'R-107', 450000, NULL),
(20, 'Daw Yin', '43', '09-101010101', 'Insein, Yangon', 'Gallbladder Surgery', 'Post-op day 3', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-010', 'R-203', 900000, NULL),
(21, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-11 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, NULL),
(22, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-09 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, NULL),
(23, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, NULL),
(24, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 1000000, NULL),
(25, 'U Kyaw Soe', '62', '09-565656565', 'Hlaing, Yangon', 'Stroke', 'Stable condition, physiotherapy started', '2025-10-07 00:00:00', 'Dr. Aung Aung', 'IPD-005', 'R-104', 1500000, NULL),
(26, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, NULL),
(27, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, NULL),
(28, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, NULL),
(29, 'U Win Htun', '55', '09-909090909', 'Botataung, Yangon', 'Gastric Ulcer', 'Medical management', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-009', 'R-107', 450000, NULL),
(30, 'Daw Yin', '43', '09-101010101', 'Insein, Yangon', 'Gallbladder Surgery', 'Post-op day 3', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-010', 'R-203', 900000, NULL),
(31, 'U Thura', '47', '09-123456716', 'Sanchaung Township, Yangon', 'Acute Myocardial Infarction', 'STEMI, emergency PCI done', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-011', 'R-301', 2000000, NULL),
(32, 'Daw Mya Thandar', '35', '09-123456717', 'Kamayut Township, Yangon', 'Severe Preeclampsia', 'Emergency C-section, ICU monitoring', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-012', 'R-302', 1800000, NULL),
(33, 'Ko Aung Myo', '29', '09-123456718', 'Bahan Township, Yangon', 'Acute Pancreatitis', 'Alcohol-induced, severe pain', '2025-10-11 00:00:00', 'Dr. Aung Aung', 'IPD-013', 'R-303', 1200000, NULL),
(34, 'Ma Khin Myo', '24', '09-123456719', 'Yankin Township, Yangon', 'Diabetic Ketoacidosis', 'Type 1 diabetes, new diagnosis', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-014', 'R-304', 800000, NULL),
(35, 'U San Tun', '68', '09-123456720', 'Hlaing Township, Yangon', 'Acute Respiratory Failure', 'COPD exacerbation, ventilator support', '2025-10-10 00:00:00', 'Dr. Myo Myo', 'IPD-015', 'R-305', 1500000, NULL),
(36, 'Daw Nyo Nyo', '53', '09-123456721', 'Thingangyun Township, Yangon', 'Acute Cholangitis', 'CBD stone, ERCP scheduled', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-016', 'R-306', 1000000, NULL),
(37, 'Ko Yan Naing', '31', '09-123456722', 'Mayangone Township, Yangon', 'Spinal Cord Injury', 'T12 complete injury, MVA', '2025-10-09 00:00:00', 'Dr. Myo Myo', 'IPD-017', 'R-307', 2500000, NULL),
(38, 'Ma Thaw Dar', '27', '09-123456723', 'Dagon Township, Yangon', 'Postpartum Hemorrhage', 'Emergency hysterectomy done', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-018', 'R-308', 1600000, NULL),
(39, 'U Zaw Min', '56', '09-123456724', 'Botataung Township, Yangon', 'Acute Kidney Injury', 'Contrast-induced nephropathy', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-019', 'R-309', 900000, NULL),
(40, 'Daw Than Than', '42', '09-123456725', 'Insein Township, Yangon', 'Status Epilepticus', 'Breakthrough seizures, ICU', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'IPD-020', 'R-310', 1300000, NULL),
(41, 'Ko Thant Zin', '38', '09-123456726', 'Thaketa Township, Yangon', 'Acute Hepatitis', 'Drug-induced liver injury', '2025-10-11 00:00:00', 'Dr. Thida', 'IPD-021', 'R-311', 700000, NULL),
(42, 'Ma Yamin', '33', '09-123456727', 'Mingalar Taung Nyunt Township, Yangon', 'Pulmonary Embolism', 'High-risk PE, thrombolysis', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-022', 'R-312', 1100000, NULL),
(43, 'U Thein Zaw', '49', '09-123456728', 'Pazundaung Township, Yangon', 'Gastrointestinal Bleeding', 'Upper GI bleed, endoscopy done', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'IPD-023', 'R-313', 800000, NULL),
(44, 'Daw Ei Ei', '37', '09-123456729', 'Dawbon Township, Yangon', 'Severe Asthma Exacerbation', 'Status asthmaticus, ICU', '2025-10-14 00:00:00', 'Dr. Thida', 'IPD-024', 'R-314', 1400000, NULL),
(45, 'Ko Naing Oo', '44', '09-123456730', 'Tamwe Township, Yangon', 'Intracranial Hemorrhage', 'Hypertensive hemorrhage, surgery', '2025-10-10 00:00:00', 'Dr. Myo Myo', 'IPD-025', 'R-315', 3000000, NULL);

-- Table: tbl_inpatient_sale
DROP TABLE IF EXISTS `tbl_inpatient_sale`;
CREATE TABLE `tbl_inpatient_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_inpatient_saledebit
DROP TABLE IF EXISTS `tbl_inpatient_saledebit`;
CREATE TABLE `tbl_inpatient_saledebit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(250) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_lab_report
DROP TABLE IF EXISTS `tbl_lab_report`;
CREATE TABLE `tbl_lab_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_no` varchar(50) DEFAULT NULL,
  `patient_id` varchar(50) NOT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `report_type` varchar(100) DEFAULT NULL,
  `collected_at` datetime DEFAULT NULL,
  `reported_at` datetime DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_lab_patient` (`patient_id`),
  KEY `idx_lab_doctor` (`doctor_id`),
  KEY `idx_lab_report_no` (`report_no`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_lab_report
INSERT INTO `tbl_lab_report` (`id`, `report_no`, `patient_id`, `doctor_id`, `report_type`, `collected_at`, `reported_at`, `notes`, `created_at`) VALUES
(1, NULL, 'OPD-005', 5, 'KFT', '2025-10-13 12:48:00', '2025-10-06 12:48:00', 'sdf', '2025-10-14 12:48:25'),
(2, 'qq', 'OPD-003', 5, 'Thyroid', '2025-10-13 12:48:00', '2025-10-06 12:48:00', 'sdf', '2025-10-14 12:49:15');

-- Table: tbl_lab_report_item
DROP TABLE IF EXISTS `tbl_lab_report_item`;
CREATE TABLE `tbl_lab_report_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `test_name` varchar(150) NOT NULL,
  `result_value` varchar(100) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `reference_range` varchar(100) DEFAULT NULL,
  `flag` varchar(10) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_lab_report_item_report` (`report_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_lab_report_item
INSERT INTO `tbl_lab_report_item` (`id`, `report_id`, `test_name`, `result_value`, `unit`, `reference_range`, `flag`, `remark`) VALUES
(1, 1, 'Hemoglobin', NULL, 'g/dL', '12 - 16', NULL, NULL),
(2, 1, 'WBC', NULL, '/mm³', '4,000 - 11,000', NULL, NULL),
(3, 2, 'Hemoglobin', '33', 'g/dL', '12 - 16', 'L', NULL),
(4, 2, 'WBC', '33', '/mm³', '4,000 - 11,000', 'H', NULL);

-- Table: tbl_labour
DROP TABLE IF EXISTS `tbl_labour`;
CREATE TABLE `tbl_labour` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level_name` varchar(50) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `sex` varchar(10) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `nrc` varchar(250) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `work_in` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_labour_balance
DROP TABLE IF EXISTS `tbl_labour_balance`;
CREATE TABLE `tbl_labour_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labour_name` varchar(50) NOT NULL,
  `InMoney` int(11) DEFAULT NULL,
  `OutMoney` int(11) DEFAULT NULL,
  `About` text DEFAULT NULL,
  `Remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_labour_level
DROP TABLE IF EXISTS `tbl_labour_level`;
CREATE TABLE `tbl_labour_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `salary` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_loss
DROP TABLE IF EXISTS `tbl_loss`;
CREATE TABLE `tbl_loss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_patient
DROP TABLE IF EXISTS `tbl_patient`;
CREATE TABLE `tbl_patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `case_` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `dr_name` varchar(250) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  `room_no` varchar(250) DEFAULT NULL,
  `deposit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_patient_patient_id` (`patient_id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_patient
INSERT INTO `tbl_patient` (`id`, `name`, `age`, `phone`, `address`, `case_`, `remark`, `date`, `dr_name`, `patient_id`, `room_no`, `deposit`) VALUES
(1, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', 'Common Cold', 'Follow-up in 3 days', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'OPD-001', NULL, NULL),
(2, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL),
(3, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL),
(4, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL),
(5, 'Ko Zaw', '42', '09-555666777', 'Thingangyun Township, Yangon', 'Gastritis', 'Dietary advice given', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'OPD-005', NULL, NULL),
(6, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL),
(7, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL),
(8, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL),
(9, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL),
(10, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL),
(11, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL),
(12, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL),
(13, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL),
(14, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL),
(15, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL),
(16, 'U Soe Win', '72', '09-256749311', 'No. 357, Garden Street, Mandalay', 'Ear infection', 'Regular OPD patient - throat infection treatment', '2025-10-04 00:00:00', 'Dr. Su Mon', 'OPD-016', NULL, 15000),
(17, 'Ko Zaw Zaw', '25', '09-756929641', 'No. 997, Hospital Road, Meiktila', 'Fever', 'Regular OPD patient - cough treatment', '2025-07-24 00:00:00', 'Dr. Aye Aye', 'OPD-017', NULL, 15000),
(18, 'Ma Htwe Zaw', '54', '09-921767357', 'No. 512, Garden Street, Pathein', 'Allergies', 'Regular OPD patient - migraine treatment', '2025-07-28 00:00:00', 'Dr. Zaw Lin', 'OPD-018', NULL, 15000),
(19, 'Ko Kaung Min', '50', '09-177935698', 'No. 999, Station Road, Bago', 'General check-up', 'Regular OPD patient - allergies treatment', '2025-09-15 00:00:00', 'Dr. Zaw Lin', 'OPD-019', NULL, 15000),
(21, 'Ko Win Lwin', '42', '09-520395456', 'No. 679, Market Street, Lashio', 'Dizziness', 'Regular OPD patient - fatigue treatment', '2025-07-26 00:00:00', 'Dr. Htun Myint', 'OPD-021', NULL, 10000),
(22, 'Ko Zaw Tun', '22', '09-103036954', 'No. 681, Garden Street, Lashio', 'Muscle strain', 'Regular OPD patient - fever treatment', '2025-07-31 00:00:00', 'Dr. Su Mon', 'OPD-022', NULL, 50000),
(23, 'U Naing Than', '32', '09-170770298', 'No. 501, Hill Top, Pathein', 'Wound dressing', 'Regular OPD patient - asthma treatment', '2025-10-03 00:00:00', 'Dr. Kyaw Min', 'OPD-023', NULL, 0),
(24, 'Ko Win Naing', '31', '09-994624357', 'No. 532, Main Street, Taungoo', 'Dizziness', 'Regular OPD patient - diabetes check-up treatment', '2025-08-13 00:00:00', 'Dr. Win Htut', 'OPD-024', NULL, 5000),
(25, 'U Than Htet', '16', '09-290101871', 'No. 541, Temple Street, Bago', 'Eye irritation', 'Regular OPD patient - stomach pain treatment', '2025-10-06 00:00:00', 'Dr. Htun Myint', 'OPD-025', NULL, 15000),
(26, 'Ma Thida Moe', '18', '09-933438380', 'No. 894, Main Street, Sittwe', 'Bronchitis', 'Regular OPD patient - wound dressing treatment', '2025-10-09 00:00:00', 'Dr. Thida Oo', 'OPD-026', NULL, 20000),
(27, 'Daw Pwint Min', '24', '09-412038389', 'No. 805, Main Street, Sittwe', 'Joint pain', 'Regular OPD patient - arthritis treatment', '2025-10-05 00:00:00', 'Dr. Ni Ni', 'OPD-027', NULL, 15000),
(28, 'Ma Thet Soe', '12', '09-916815183', 'No. 489, Central Avenue, Taunggyi', 'Back pain', 'Regular OPD patient - joint pain treatment', '2025-08-30 00:00:00', 'Dr. Thida Oo', 'OPD-028', NULL, 0),
(29, 'U Sein Win', '69', '09-484074405', 'No. 49, Garden Street, Dawei', 'Fever', 'Regular OPD patient - diabetes check-up treatment', '2025-08-25 00:00:00', 'Dr. Aye Aye', 'OPD-029', NULL, 25000),
(30, 'Ma Htwe Moe', '44', '09-737805958', 'No. 625, Hospital Road, Yangon', 'Diabetes check-up', 'Regular OPD patient - fever treatment', '2025-07-28 00:00:00', 'Dr. Su Mon', 'OPD-030', NULL, 0),
(31, 'Daw Khin Aung', '72', '09-442584466', 'No. 10, Station Road, Mawlamyine', 'Bronchitis', 'Regular OPD patient - fatigue treatment', '2025-07-31 00:00:00', 'Dr. Kyaw Min', 'OPD-031', NULL, 5000),
(32, 'U Soe Aung', '49', '09-704843727', 'No. 256, Hospital Road, Yangon', 'Dizziness', 'Regular OPD patient - acid reflux treatment', '2025-10-12 00:00:00', 'Dr. Aung Naing', 'OPD-032', NULL, 20000),
(33, 'U Myint Phyo', '43', '09-903404635', 'No. 87, Station Road, Sittwe', 'Ear infection', 'Regular OPD patient - migraine treatment', '2025-09-29 00:00:00', 'Dr. Win Htut', 'OPD-033', NULL, 5000),
(34, 'Ko Min Zaw', '50', '09-954979155', 'No. 582, Main Street, Yangon', 'Asthma', 'Regular OPD patient - diabetes check-up treatment', '2025-09-26 00:00:00', 'Dr. Zaw Lin', 'OPD-034', NULL, 50000),
(35, 'Ma Thet Naing', '73', '09-212502545', 'No. 980, Temple Street, Yangon', 'Cold', 'Regular OPD patient - fever treatment', '2025-08-11 00:00:00', 'Dr. Thida Oo', 'OPD-035', NULL, 25000),
(36, 'U Tin Htun', '23', '09-943142910', 'No. 510, Temple Street, Mawlamyine', 'Cough', 'Regular OPD patient - joint pain treatment', '2025-08-01 00:00:00', 'Dr. Aye Aye', 'OPD-036', NULL, 25000),
(37, 'Ko Zaw Htun', '26', '09-493510013', 'No. 362, Central Avenue, Pyay', 'Muscle strain', 'Regular OPD patient - fever treatment', '2025-08-02 00:00:00', 'Dr. Ni Ni', 'OPD-037', NULL, 0),
(38, 'Daw Thant Tun', '70', '09-154902261', 'No. 399, River View, Hinthada', 'Arthritis', 'Regular OPD patient - throat infection treatment', '2025-10-02 00:00:00', 'Dr. Htun Myint', 'OPD-038', NULL, 50000),
(39, 'Ko Ye Naing', '41', '09-930715999', 'No. 815, Hill Top, Pathein', 'Arthritis', 'Regular OPD patient - asthma treatment', '2025-09-21 00:00:00', 'Dr. Su Mon', 'OPD-039', NULL, 20000),
(40, 'U Moe Lwin', '49', '09-239015064', 'No. 998, Station Road, Hinthada', 'Fever', 'Regular OPD patient - chest pain treatment', '2025-08-31 00:00:00', 'Dr. Htun Myint', 'OPD-040', NULL, 50000),
(41, 'Ma Cho Tin', '78', '09-725034380', 'No. 383, Garden Street, Sittwe', 'Joint pain', 'Regular OPD patient - fatigue treatment', '2025-09-29 00:00:00', 'Dr. Aung Naing', 'OPD-041', NULL, 20000),
(42, 'Ko Tun Zaw', '61', '09-952844640', 'No. 63, Hill Top, Hinthada', 'Muscle strain', 'Regular OPD patient - skin rash treatment', '2025-07-19 00:00:00', 'Dr. Aung Naing', 'OPD-042', NULL, 30000),
(43, 'Ko Kaung Sein', '13', '09-523177166', 'No. 563, River View, Yangon', 'Muscle strain', 'Regular OPD patient - headache treatment', '2025-08-15 00:00:00', 'Dr. Ni Ni', 'OPD-043', NULL, 5000),
(44, 'Ko Ye Moe', '23', '09-257777236', 'No. 754, River View, Meiktila', 'Wound dressing', 'Regular OPD patient - back pain treatment', '2025-09-03 00:00:00', 'Dr. Htun Myint', 'OPD-044', NULL, 20000),
(45, 'Daw Kyi Soe', '31', '09-933763799', 'No. 192, Station Road, Taunggyi', 'Hypertension', 'Regular OPD patient - hypertension treatment', '2025-07-29 00:00:00', 'Dr. Win Htut', 'OPD-045', NULL, 50000),
(46, 'asasd', '2', '3', '323as', 'asd', 'asdasd', '2025-10-13 00:00:00', '', 'P000046', '33', 33),
(47, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', 'Common Cold', 'Follow-up in 3 days', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-001', NULL, NULL),
(48, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL),
(49, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL),
(50, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL),
(51, 'Ko Zaw', '42', '09-555666777', 'Thingangyun Township, Yangon', 'Gastritis', 'Dietary advice given', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-005', NULL, NULL),
(52, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL),
(53, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL),
(54, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL),
(55, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL),
(56, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL),
(57, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL),
(58, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL),
(59, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL),
(60, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL),
(61, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL),
(62, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', 'Common Cold', 'Follow-up in 3 days', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-001', NULL, NULL),
(63, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL),
(64, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL),
(65, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL),
(66, 'Ko Zaw', '42', '09-555666777', 'Thingangyun Township, Yangon', 'Gastritis', 'Dietary advice given', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-005', NULL, NULL),
(67, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL),
(68, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL),
(69, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL),
(70, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL),
(71, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL),
(72, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL),
(73, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL),
(74, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL),
(75, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL),
(76, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL),
(77, 'Ma Nwe Nwe', '34', '09-123456701', 'Thuwanna Township, Yangon', 'Type 2 Diabetes', 'Newly diagnosed, needs education', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-016', NULL, NULL),
(78, 'U Maung Htun', '67', '09-123456702', 'Pazundaung Township, Yangon', 'COPD Exacerbation', 'Chronic smoker, oxygen therapy', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-017', NULL, NULL),
(79, 'Daw Kyi Kyi', '29', '09-123456703', 'Lanmadaw Township, Yangon', 'Postpartum Depression', 'Delivered 3 months ago', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-018', NULL, NULL),
(80, 'Ko Thant Sin', '41', '09-123456704', 'Latha Township, Yangon', 'Chronic Kidney Disease', 'Stage 3 CKD', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-019', NULL, NULL),
(81, 'Ma Phyo Wai', '26', '09-123456705', 'Seikgyi Khanaungto Township, Yangon', 'Iron Deficiency Anemia', 'Heavy menstrual bleeding', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-020', NULL, NULL),
(82, 'U Kyaw Min', '58', '09-123456706', 'Ahlone Township, Yangon', 'Atrial Fibrillation', 'Irregular heartbeat', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-021', NULL, NULL),
(83, 'Daw Thin Thin', '45', '09-123456707', 'Kyauktada Township, Yangon', 'Cervical Spondylosis', 'Neck pain and stiffness', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-022', NULL, NULL),
(84, 'Ko Naing Win', '33', '09-123456708', 'Pabedan Township, Yangon', 'Peptic Ulcer Disease', 'H. pylori positive', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-023', NULL, NULL),
(85, 'Ma Swe Zin', '22', '09-123456709', 'Kyimyindaing Township, Yangon', 'Polycystic Ovary Syndrome', 'Irregular periods', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-024', NULL, NULL),
(86, 'U Htun Lwin', '52', '09-123456710', 'Tamwe Township, Yangon', 'Gout', 'Acute attack, right big toe', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-025', NULL, NULL),
(87, 'Daw Moe Moe', '39', '09-123456711', 'Dawbon Township, Yangon', 'Fibromyalgia', 'Chronic widespread pain', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-026', NULL, NULL),
(88, 'Ko Zin Min', '28', '09-123456712', 'Mingalar Taung Nyunt Township, Yangon', 'Anxiety Disorder', 'Panic attacks', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-027', NULL, NULL),
(89, 'Ma Htet Htet', '36', '09-123456713', 'Thaketa Township, Yangon', 'Gestational Diabetes', '32 weeks pregnant', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-028', NULL, NULL),
(90, 'U Win Maung', '61', '09-123456714', 'Botataung Township, Yangon', 'Benign Prostatic Hyperplasia', 'Urinary retention', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-029', NULL, NULL),
(91, 'Daw Aye Aye', '43', '09-123456715', 'Dagon Township, Yangon', 'Rheumatoid Arthritis', 'Joint swelling and pain', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-030', NULL, NULL),
(92, 'U Thura', '47', '09-123456716', 'Sanchaung Township, Yangon', 'Acute Myocardial Infarction', 'STEMI, emergency PCI', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-011', NULL, NULL),
(93, 'Daw Mya Thandar', '35', '09-123456717', 'Kamayut Township, Yangon', 'Severe Preeclampsia', '36 weeks, emergency C-section', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-012', NULL, NULL),
(94, 'Ko Aung Myo', '29', '09-123456718', 'Bahan Township, Yangon', 'Acute Pancreatitis', 'Alcohol-induced', '2025-10-11 00:00:00', 'Dr. Aung Aung', 'IPD-013', NULL, NULL),
(95, 'Ma Khin Myo', '24', '09-123456719', 'Yankin Township, Yangon', 'Diabetic Ketoacidosis', 'Type 1 diabetes', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-014', NULL, NULL),
(96, 'U San Tun', '68', '09-123456720', 'Hlaing Township, Yangon', 'Acute Respiratory Failure', 'COPD exacerbation', '2025-10-10 00:00:00', 'Dr. Myo Myo', 'IPD-015', NULL, NULL),
(97, 'Daw Nyo Nyo', '53', '09-123456721', 'Thingangyun Township, Yangon', 'Acute Cholangitis', 'CBD stone', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-016', NULL, NULL),
(98, 'Ko Yan Naing', '31', '09-123456722', 'Mayangone Township, Yangon', 'Spinal Cord Injury', 'Motor vehicle accident', '2025-10-09 00:00:00', 'Dr. Myo Myo', 'IPD-017', NULL, NULL),
(99, 'Ma Thaw Dar', '27', '09-123456723', 'Dagon Township, Yangon', 'Postpartum Hemorrhage', 'Emergency hysterectomy', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-018', NULL, NULL),
(100, 'U Zaw Min', '56', '09-123456724', 'Botataung Township, Yangon', 'Acute Kidney Injury', 'Contrast-induced', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-019', NULL, NULL),
(101, 'Daw Than Than', '42', '09-123456725', 'Insein Township, Yangon', 'Status Epilepticus', 'Breakthrough seizures', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'IPD-020', NULL, NULL);

INSERT INTO `tbl_patient` (`id`, `name`, `age`, `phone`, `address`, `case_`, `remark`, `date`, `dr_name`, `patient_id`, `room_no`, `deposit`) VALUES
(102, 'Ko Thant Zin', '38', '09-123456726', 'Thaketa Township, Yangon', 'Acute Hepatitis', 'Drug-induced liver injury', '2025-10-11 00:00:00', 'Dr. Thida', 'IPD-021', NULL, NULL),
(103, 'Ma Yamin', '33', '09-123456727', 'Mingalar Taung Nyunt Township, Yangon', 'Pulmonary Embolism', 'High-risk PE', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-022', NULL, NULL),
(104, 'U Thein Zaw', '49', '09-123456728', 'Pazundaung Township, Yangon', 'Gastrointestinal Bleeding', 'Upper GI bleed', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'IPD-023', NULL, NULL),
(105, 'Daw Ei Ei', '37', '09-123456729', 'Dawbon Township, Yangon', 'Severe Asthma Exacerbation', 'Status asthmaticus', '2025-10-14 00:00:00', 'Dr. Thida', 'IPD-024', NULL, NULL),
(106, 'Ko Naing Oo', '44', '09-123456730', 'Tamwe Township, Yangon', 'Intracranial Hemorrhage', 'Hypertensive hemorrhage', '2025-10-10 00:00:00', 'Dr. Myo Myo', 'IPD-025', NULL, NULL),
(107, 'Ma Nwe Nwe', '34', '09-123456701', 'Thuwanna Township, Yangon', 'Type 2 Diabetes', 'Newly diagnosed, needs education', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-016', NULL, NULL),
(108, 'U Maung Htun', '67', '09-123456702', 'Pazundaung Township, Yangon', 'COPD Exacerbation', 'Chronic smoker, oxygen therapy', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-017', NULL, NULL),
(109, 'Daw Kyi Kyi', '29', '09-123456703', 'Lanmadaw Township, Yangon', 'Postpartum Depression', 'Delivered 3 months ago', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-018', NULL, NULL),
(110, 'Ko Thant Sin', '41', '09-123456704', 'Latha Township, Yangon', 'Chronic Kidney Disease', 'Stage 3 CKD', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-019', NULL, NULL),
(111, 'Ma Phyo Wai', '26', '09-123456705', 'Seikgyi Khanaungto Township, Yangon', 'Iron Deficiency Anemia', 'Heavy menstrual bleeding', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-020', NULL, NULL),
(112, 'U Kyaw Min', '58', '09-123456706', 'Ahlone Township, Yangon', 'Atrial Fibrillation', 'Irregular heartbeat', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-021', NULL, NULL),
(113, 'Daw Thin Thin', '45', '09-123456707', 'Kyauktada Township, Yangon', 'Cervical Spondylosis', 'Neck pain and stiffness', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-022', NULL, NULL),
(114, 'Ko Naing Win', '33', '09-123456708', 'Pabedan Township, Yangon', 'Peptic Ulcer Disease', 'H. pylori positive', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-023', NULL, NULL),
(115, 'Ma Swe Zin', '22', '09-123456709', 'Kyimyindaing Township, Yangon', 'Polycystic Ovary Syndrome', 'Irregular periods', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-024', NULL, NULL),
(116, 'U Htun Lwin', '52', '09-123456710', 'Tamwe Township, Yangon', 'Gout', 'Acute attack, right big toe', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-025', NULL, NULL),
(117, 'Daw Moe Moe', '39', '09-123456711', 'Dawbon Township, Yangon', 'Fibromyalgia', 'Chronic widespread pain', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-026', NULL, NULL),
(118, 'Ko Zin Min', '28', '09-123456712', 'Mingalar Taung Nyunt Township, Yangon', 'Anxiety Disorder', 'Panic attacks', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-027', NULL, NULL),
(119, 'Ma Htet Htet', '36', '09-123456713', 'Thaketa Township, Yangon', 'Gestational Diabetes', '32 weeks pregnant', '2025-10-14 00:00:00', 'Dr. Thida', 'OPD-028', NULL, NULL),
(120, 'U Win Maung', '61', '09-123456714', 'Botataung Township, Yangon', 'Benign Prostatic Hyperplasia', 'Urinary retention', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-029', NULL, NULL),
(121, 'Daw Aye Aye', '43', '09-123456715', 'Dagon Township, Yangon', 'Rheumatoid Arthritis', 'Joint swelling and pain', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-030', NULL, NULL),
(122, 'U Thura', '47', '09-123456716', 'Sanchaung Township, Yangon', 'Acute Myocardial Infarction', 'STEMI, emergency PCI', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-011', NULL, NULL),
(123, 'Daw Mya Thandar', '35', '09-123456717', 'Kamayut Township, Yangon', 'Severe Preeclampsia', '36 weeks, emergency C-section', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-012', NULL, NULL),
(124, 'Ko Aung Myo', '29', '09-123456718', 'Bahan Township, Yangon', 'Acute Pancreatitis', 'Alcohol-induced', '2025-10-11 00:00:00', 'Dr. Aung Aung', 'IPD-013', NULL, NULL),
(125, 'Ma Khin Myo', '24', '09-123456719', 'Yankin Township, Yangon', 'Diabetic Ketoacidosis', 'Type 1 diabetes', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-014', NULL, NULL),
(126, 'U San Tun', '68', '09-123456720', 'Hlaing Township, Yangon', 'Acute Respiratory Failure', 'COPD exacerbation', '2025-10-10 00:00:00', 'Dr. Myo Myo', 'IPD-015', NULL, NULL),
(127, 'Daw Nyo Nyo', '53', '09-123456721', 'Thingangyun Township, Yangon', 'Acute Cholangitis', 'CBD stone', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-016', NULL, NULL),
(128, 'Ko Yan Naing', '31', '09-123456722', 'Mayangone Township, Yangon', 'Spinal Cord Injury', 'Motor vehicle accident', '2025-10-09 00:00:00', 'Dr. Myo Myo', 'IPD-017', NULL, NULL),
(129, 'Ma Thaw Dar', '27', '09-123456723', 'Dagon Township, Yangon', 'Postpartum Hemorrhage', 'Emergency hysterectomy', '2025-10-13 00:00:00', 'Dr. Thida', 'IPD-018', NULL, NULL),
(130, 'U Zaw Min', '56', '09-123456724', 'Botataung Township, Yangon', 'Acute Kidney Injury', 'Contrast-induced', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-019', NULL, NULL),
(131, 'Daw Than Than', '42', '09-123456725', 'Insein Township, Yangon', 'Status Epilepticus', 'Breakthrough seizures', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'IPD-020', NULL, NULL),
(132, 'Ko Thant Zin', '38', '09-123456726', 'Thaketa Township, Yangon', 'Acute Hepatitis', 'Drug-induced liver injury', '2025-10-11 00:00:00', 'Dr. Thida', 'IPD-021', NULL, NULL),
(133, 'Ma Yamin', '33', '09-123456727', 'Mingalar Taung Nyunt Township, Yangon', 'Pulmonary Embolism', 'High-risk PE', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-022', NULL, NULL),
(134, 'U Thein Zaw', '49', '09-123456728', 'Pazundaung Township, Yangon', 'Gastrointestinal Bleeding', 'Upper GI bleed', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'IPD-023', NULL, NULL),
(135, 'Daw Ei Ei', '37', '09-123456729', 'Dawbon Township, Yangon', 'Severe Asthma Exacerbation', 'Status asthmaticus', '2025-10-14 00:00:00', 'Dr. Thida', 'IPD-024', NULL, NULL),
(136, 'Ko Naing Oo', '44', '09-123456730', 'Tamwe Township, Yangon', 'Intracranial Hemorrhage', 'Hypertensive hemorrhage', '2025-10-10 00:00:00', 'Dr. Myo Myo', 'IPD-025', NULL, NULL);

-- Table: tbl_patient_sale
DROP TABLE IF EXISTS `tbl_patient_sale`;
CREATE TABLE `tbl_patient_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_payment_method
DROP TABLE IF EXISTS `tbl_payment_method`;
CREATE TABLE `tbl_payment_method` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_payment_method
INSERT INTO `tbl_payment_method` (`id`, `name`) VALUES
(1, 'Cash'),
(2, 'KBZ Pay'),
(3, 'CB Pay'),
(4, 'Aya Pay'),
(5, 'Wave Money'),
(6, 'Bank Transfer');

-- Table: tbl_purchase
DROP TABLE IF EXISTS `tbl_purchase`;
CREATE TABLE `tbl_purchase` (
  `id` int(11) NOT NULL,
  `purchase_voucher_id` int(11) DEFAULT NULL,
  `cat_id` varchar(255) DEFAULT NULL,
  `cat_id_2` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  `total_cost_price` int(11) DEFAULT NULL,
  `sale_price_latli` int(11) DEFAULT NULL,
  `sale_price_latkar` int(11) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `alert_month` int(11) DEFAULT NULL,
  `alert_date` date DEFAULT NULL,
  `margin` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_purchase_return
DROP TABLE IF EXISTS `tbl_purchase_return`;
CREATE TABLE `tbl_purchase_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_purchase_voucher
DROP TABLE IF EXISTS `tbl_purchase_voucher`;
CREATE TABLE `tbl_purchase_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `total_cost` double NOT NULL,
  `supplier_name` varchar(50) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_role
DROP TABLE IF EXISTS `tbl_role`;
CREATE TABLE `tbl_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_role
INSERT INTO `tbl_role` (`id`, `name`) VALUES
(1, 'Admin'),
(2, 'Manager'),
(3, 'Cashier'),
(4, 'Doctor');

-- Table: tbl_sale
DROP TABLE IF EXISTS `tbl_sale`;
CREATE TABLE `tbl_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_sale_vno` (`VNo`),
  KEY `idx_sale_date` (`Date`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_sale
INSERT INTO `tbl_sale` (`id`, `cat_id`, `Barcode`, `Name`, `SaleType`, `SalePrice`, `dis`, `Qty`, `Total`, `Profit`, `VNo`, `Date`, `Cashier`, `Refer`, `cost_price`) VALUES
(1, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 1, 350, 150, 1, '2025-10-13 00:00:00', 'Current User', NULL, 200),
(2, '1', '8850987180001', 'Paracetamol 500mg', 'Retail', 100, 0, 1, 100, 50, 1, '2025-10-13 00:00:00', 'Current User', NULL, 50),
(3, '1', '8850987180003', 'Vitamin C 1000mg', 'Retail', 200, 0, 1, 200, 100, 1, '2025-10-13 00:00:00', 'Current User', NULL, 100),
(4, '2', '886973746949', 'Tetracycline 250mg', 'Retail', 340, 0, 1, 340, 124, 2, '2025-10-13 00:00:00', 'Current User', NULL, 216),
(5, '6', '890772468164', 'Medical Tape', 'Retail', 187, 0, 1, 187, 57, 2, '2025-10-13 00:00:00', 'Current User', NULL, 130),
(6, '3', '887034919932', 'Iron Syrup 100mg/5ml', 'Retail', 326, 0, 1, 326, -165, 2, '2025-10-13 00:00:00', 'Current User', NULL, 491),
(7, '6', '890575534454', 'Instant Cold Pack', 'Retail', 157, 0, 1, 157, 95, 2, '2025-10-13 00:00:00', 'Current User', NULL, 62),
(8, '6', '890104462077', 'Gauze Pad 4x4', 'Retail', 336, 0, 1, 336, 149, 2, '2025-10-13 00:00:00', 'Current User', NULL, 187),
(9, '1', '885298390177', 'Paracetamol 500mg', 'Retail', 170, 0, 1, 170, 100, 2, '2025-10-13 00:00:00', 'Current User', NULL, 70),
(10, '4', '888946766068', 'Pethidine 100mg', 'Retail', 1477, 0, 2, 2954, 886, 2, '2025-10-13 00:00:00', 'Current User', NULL, 1034),
(11, '2', '886824603607', 'Nitrofurantoin 100mg', 'Retail', 413, 0, 1, 413, 21, 2, '2025-10-13 00:00:00', 'Current User', NULL, 392),
(12, '1', '885125337161', 'Loratadine 10mg', 'Retail', 224, 0, 1, 224, 7, 2, '2025-10-13 00:00:00', 'Current User', NULL, 217),
(13, '3', '887576582507', 'Paracetamol Syrup 120mg/5ml', 'Retail', 366, 0, 1, 366, 178, 2, '2025-10-13 00:00:00', 'Current User', NULL, 188),
(14, '7', '891931672494', 'Multivitamin for Adults', 'Retail', 422, 0, 1, 422, 196, 2, '2025-10-13 00:00:00', 'Current User', NULL, 226),
(15, '3', '887609133188', 'Multivitamin Syrup', 'Retail', 396, 0, 1, 396, 51, 2, '2025-10-13 00:00:00', 'Current User', NULL, 345),
(16, '1', '885942844875', 'Amlodipine 5mg', 'Retail', 392, 0, 2, 784, 662, 3, '2025-10-14 00:00:00', 'Current User', NULL, 61),
(17, '6', '890744393416', 'Adhesive Bandage', 'Retail', 202, 0, 1, 202, 3, 3, '2025-10-14 00:00:00', 'Current User', NULL, 199),
(18, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 1, 350, 150, 3, '2025-10-14 00:00:00', 'Current User', NULL, 200),
(19, '3', '887565207581', 'Amoxicillin Syrup 125mg/5ml', 'Retail', 659, 0, 1, 659, 120, 4, '2025-10-14 00:00:00', 'Current User', NULL, 539),
(20, '3', '887429325142', 'Antacid Syrup', 'Retail', 459, 0, 1, 459, -74, 4, '2025-10-14 00:00:00', 'Current User', NULL, 533),
(21, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 2, 700, 300, 4, '2025-10-14 00:00:00', 'Current User', NULL, 200),
(22, '2', '886728465468', 'Amoxicillin 500mg', 'Retail', 432, 0, 1, 432, 83, 4, '2025-10-14 00:00:00', 'Current User', NULL, 349),
(23, '1', '885098859304', 'Azithromycin 500mg', 'Retail', 205, 0, 1, 205, 35, 4, '2025-10-14 00:00:00', 'Current User', NULL, 170),
(24, '9', 'S9005678901', 'Drug Interaction Check', 'Service', 4000, 0, 1, 4000, 3000, 5, '2025-10-14 00:00:00', 'Current User', NULL, 1000),
(25, '7', 'S7007890123', 'Ear Cleaning', 'Service', 3500, 0, 1, 3500, 2700, 5, '2025-10-14 00:00:00', 'Current User', NULL, 800),
(26, '1', 'S1004567890', 'Emergency Consultation', 'Service', 35000, 0, 1, 35000, 25000, 5, '2025-10-14 00:00:00', 'Current User', NULL, 10000),
(27, '8', 'S8001234567', 'Emergency Treatment', 'Service', 40000, 0, 1, 40000, 30000, 5, '2025-10-14 00:00:00', 'Current User', NULL, 10000),
(28, '3', 'S3001234567', 'Chest X-Ray', 'Service', 15000, 0, 1, 15000, 12000, 5, '2025-10-14 00:00:00', 'Current User', NULL, 3000),
(29, '4', 'S4005678901', 'Cardiac Ultrasound', 'Service', 40000, 0, 1, 40000, 32000, 5, '2025-10-14 00:00:00', 'Current User', NULL, 8000),
(30, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 2, 32000, 25600, 5, '2025-10-14 00:00:00', 'Current User', NULL, 3200),
(31, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 5, '2025-10-14 00:00:00', 'Current User', NULL, 3500),
(32, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 5, '2025-10-14 00:00:00', 'Current User', NULL, 5000),
(33, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 5, '2025-10-14 00:00:00', 'Current User', NULL, 1000);

-- Table: tbl_sale_archive
DROP TABLE IF EXISTS `tbl_sale_archive`;
CREATE TABLE `tbl_sale_archive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_draft
DROP TABLE IF EXISTS `tbl_sale_draft`;
CREATE TABLE `tbl_sale_draft` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_draft_no
DROP TABLE IF EXISTS `tbl_sale_draft_no`;
CREATE TABLE `tbl_sale_draft_no` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_package
DROP TABLE IF EXISTS `tbl_sale_package`;
CREATE TABLE `tbl_sale_package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_package_no
DROP TABLE IF EXISTS `tbl_sale_package_no`;
CREATE TABLE `tbl_sale_package_no` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_return
DROP TABLE IF EXISTS `tbl_sale_return`;
CREATE TABLE `tbl_sale_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `sale_price` double DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `total` double DEFAULT NULL,
  `profit` double DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `voucher_return_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_return_item
DROP TABLE IF EXISTS `tbl_sale_return_item`;
CREATE TABLE `tbl_sale_return_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `sale_price` double DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `total` double DEFAULT NULL,
  `profit` double DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `vno` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_service
DROP TABLE IF EXISTS `tbl_service`;
CREATE TABLE `tbl_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `barcode` varchar(50) NOT NULL,
  `service_name` varchar(50) NOT NULL,
  `cat_id` varchar(50) NOT NULL,
  `buy_price` int(11) NOT NULL,
  `sale_price` int(11) NOT NULL,
  `remark` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_service
INSERT INTO `tbl_service` (`id`, `barcode`, `service_name`, `cat_id`, `buy_price`, `sale_price`, `remark`) VALUES
(1, 'S1001234567', 'General Doctor Consultation', '1', 5000, 15000, 'Basic medical consultation and examination'),
(2, 'S1002345678', 'Specialist Consultation', '1', 8000, 25000, 'Consultation with medical specialist'),
(3, 'S1003456789', 'Follow-up Consultation', '1', 3000, 10000, 'Follow-up appointment after treatment'),
(4, 'S1004567890', 'Emergency Consultation', '1', 10000, 35000, '24/7 emergency medical consultation'),
(5, 'S1005678901', 'Pediatric Consultation', '1', 6000, 20000, 'Specialized consultation for children'),
(6, 'S2001234567', 'Complete Blood Count (CBC)', '2', 2000, 8000, 'Full blood analysis and cell count'),
(7, 'S2002345678', 'Blood Sugar Test', '2', 1000, 5000, 'Glucose level measurement'),
(8, 'S2003456789', 'Lipid Profile', '2', 2500, 10000, 'Cholesterol and triglyceride test'),
(9, 'S2004567890', 'Liver Function Test', '2', 3000, 12000, 'Liver enzyme and function analysis'),
(10, 'S2005678901', 'Kidney Function Test', '2', 2800, 11000, 'Creatinine and BUN test'),
(11, 'S2006789012', 'Thyroid Function Test', '2', 3500, 15000, 'TSH, T3, T4 hormone levels'),
(12, 'S2007890123', 'Urine Analysis', '2', 800, 3000, 'Complete urine examination'),
(13, 'S2008901234', 'Hepatitis B Test', '2', 4000, 18000, 'Hepatitis B surface antigen test'),
(14, 'S2009012345', 'HIV Test', '2', 5000, 20000, 'HIV antibody screening test'),
(15, 'S2010123456', 'Pregnancy Test', '2', 1500, 6000, 'Beta HCG pregnancy test'),
(16, 'S3001234567', 'Chest X-Ray', '3', 3000, 15000, 'Standard chest radiography'),
(17, 'S3002345678', 'Abdominal X-Ray', '3', 3500, 18000, 'Abdominal region X-ray imaging'),
(18, 'S3003456789', 'Spine X-Ray', '3', 4000, 20000, 'Spinal column X-ray examination'),
(19, 'S3004567890', 'Dental X-Ray', '3', 2500, 12000, 'Dental and jaw X-ray imaging'),
(20, 'S3005678901', 'Bone X-Ray', '3', 3200, 16000, 'Bone fracture and joint X-ray'),
(21, 'S4001234567', 'Abdominal Ultrasound', '4', 5000, 25000, 'Ultrasound scan of abdominal organs'),
(22, 'S4002345678', 'Pregnancy Ultrasound', '4', 6000, 30000, 'Prenatal ultrasound examination'),
(23, 'S4003456789', 'Pelvic Ultrasound', '4', 5500, 28000, 'Pelvic region ultrasound scan'),
(24, 'S4004567890', 'Thyroid Ultrasound', '4', 4500, 22000, 'Thyroid gland ultrasound'),
(25, 'S4005678901', 'Cardiac Ultrasound', '4', 8000, 40000, 'Heart ultrasound examination'),
(26, 'S5001234567', 'Resting ECG', '5', 2000, 8000, '12-lead electrocardiogram at rest'),
(27, 'S5002345678', 'Exercise Stress Test', '5', 8000, 35000, 'ECG during physical exercise'),
(28, 'S5003456789', 'Holter Monitor (24hr)', '5', 15000, 60000, '24-hour continuous ECG monitoring'),
(29, 'S6001234567', 'Hepatitis B Vaccine', '6', 8000, 20000, 'Hepatitis B immunization shot'),
(30, 'S6002345678', 'Flu Vaccine', '6', 5000, 15000, 'Annual influenza vaccination'),
(31, 'S6003456789', 'COVID-19 Vaccine', '6', 0, 5000, 'COVID-19 immunization'),
(32, 'S6004567890', 'Tetanus Vaccine', '6', 3000, 10000, 'Tetanus immunization shot'),
(33, 'S6005678901', 'Pneumonia Vaccine', '6', 12000, 30000, 'Pneumococcal vaccination'),
(34, 'S7001234567', 'Blood Pressure Monitoring', '7', 500, 2000, 'Blood pressure measurement and monitoring'),
(35, 'S7002345678', 'Wound Dressing', '7', 1000, 5000, 'Professional wound cleaning and dressing'),
(36, 'S7003456789', 'Injection Administration', '7', 800, 3000, 'Intramuscular or intravenous injection'),
(37, 'S7004567890', 'Suture Removal', '7', 1200, 5000, 'Safe removal of surgical sutures'),
(38, 'S7005678901', 'IV Drip Administration', '7', 2000, 8000, 'Intravenous fluid administration'),
(39, 'S7006789012', 'Minor Surgery', '7', 15000, 50000, 'Minor surgical procedures'),
(40, 'S7007890123', 'Ear Cleaning', '7', 800, 3500, 'Professional ear wax removal'),
(41, 'S7008901234', 'Physical Examination', '7', 2000, 8000, 'Complete physical health examination'),
(42, 'S8001234567', 'Emergency Treatment', '8', 10000, 40000, '24/7 emergency medical care'),
(43, 'S8002345678', 'Trauma Care', '8', 15000, 60000, 'Emergency trauma treatment'),
(44, 'S8003456789', 'CPR Service', '8', 5000, 25000, 'Cardiopulmonary resuscitation'),
(45, 'S8004567890', 'First Aid Treatment', '8', 2000, 8000, 'Basic first aid medical treatment'),
(46, 'S9001234567', 'Medicine Home Delivery', '9', 1000, 3000, 'Free home delivery for medicines'),
(47, 'S9002345678', 'Medication Counseling', '9', 2000, 8000, 'Professional medication guidance'),
(48, 'S9003456789', 'Prescription Review', '9', 1500, 5000, 'Pharmacist prescription review'),
(49, 'S9004567890', 'Medicine Packaging', '9', 500, 2000, 'Weekly/monthly medicine packaging'),
(50, 'S9005678901', 'Drug Interaction Check', '9', 1000, 4000, 'Check for medication interactions'),
(51, 'S0001234567', 'Medical Certificate', '10', 500, 3000, 'Official medical fitness certificate'),
(52, 'S0002345678', 'Health Record Copy', '10', 200, 1000, 'Copy of patient medical records'),
(53, 'S0003456789', 'Insurance Form Processing', '10', 800, 3500, 'Medical insurance form completion'),
(54, 'S0004567890', 'Referral Letter', '10', 300, 1500, 'Medical referral to specialist'),
(55, 'S0005678901', 'Medical Report', '10', 1000, 5000, 'Detailed medical examination report'),
(56, 'S0006789012', 'Prescription Copy', '10', 200, 800, 'Copy of medical prescription'),
(57, 'S0007890123', 'Vaccination Certificate', '10', 300, 1500, 'Official vaccination record certificate'),
(58, 'S1001234567', 'General Doctor Consultation', '1', 5000, 15000, 'Basic medical consultation and examination'),
(59, 'S1002345678', 'Specialist Consultation', '1', 8000, 25000, 'Consultation with medical specialist'),
(60, 'S1003456789', 'Follow-up Consultation', '1', 3000, 10000, 'Follow-up appointment after treatment'),
(61, 'S1004567890', 'Emergency Consultation', '1', 10000, 35000, '24/7 emergency medical consultation'),
(62, 'S1005678901', 'Pediatric Consultation', '1', 6000, 20000, 'Specialized consultation for children'),
(63, 'S2001234567', 'Complete Blood Count (CBC)', '2', 2000, 8000, 'Full blood analysis and cell count'),
(64, 'S2002345678', 'Blood Sugar Test', '2', 1000, 5000, 'Glucose level measurement'),
(65, 'S2003456789', 'Lipid Profile', '2', 2500, 10000, 'Cholesterol and triglyceride test'),
(66, 'S2004567890', 'Liver Function Test', '2', 3000, 12000, 'Liver enzyme and function analysis'),
(67, 'S2005678901', 'Kidney Function Test', '2', 2800, 11000, 'Creatinine and BUN test'),
(68, 'S2006789012', 'Thyroid Function Test', '2', 3500, 15000, 'TSH, T3, T4 hormone levels'),
(69, 'S2007890123', 'Urine Analysis', '2', 800, 3000, 'Complete urine examination'),
(70, 'S2008901234', 'Hepatitis B Test', '2', 4000, 18000, 'Hepatitis B surface antigen test'),
(71, 'S2009012345', 'HIV Test', '2', 5000, 20000, 'HIV antibody screening test'),
(72, 'S2010123456', 'Pregnancy Test', '2', 1500, 6000, 'Beta HCG pregnancy test'),
(73, 'S3001234567', 'Chest X-Ray', '3', 3000, 15000, 'Standard chest radiography'),
(74, 'S3002345678', 'Abdominal X-Ray', '3', 3500, 18000, 'Abdominal region X-ray imaging'),
(75, 'S3003456789', 'Spine X-Ray', '3', 4000, 20000, 'Spinal column X-ray examination'),
(76, 'S3004567890', 'Dental X-Ray', '3', 2500, 12000, 'Dental and jaw X-ray imaging'),
(77, 'S3005678901', 'Bone X-Ray', '3', 3200, 16000, 'Bone fracture and joint X-ray'),
(78, 'S4001234567', 'Abdominal Ultrasound', '4', 5000, 25000, 'Ultrasound scan of abdominal organs'),
(79, 'S4002345678', 'Pregnancy Ultrasound', '4', 6000, 30000, 'Prenatal ultrasound examination'),
(80, 'S4003456789', 'Pelvic Ultrasound', '4', 5500, 28000, 'Pelvic region ultrasound scan'),
(81, 'S4004567890', 'Thyroid Ultrasound', '4', 4500, 22000, 'Thyroid gland ultrasound'),
(82, 'S4005678901', 'Cardiac Ultrasound', '4', 8000, 40000, 'Heart ultrasound examination'),
(83, 'S5001234567', 'Resting ECG', '5', 2000, 8000, '12-lead electrocardiogram at rest'),
(84, 'S5002345678', 'Exercise Stress Test', '5', 8000, 35000, 'ECG during physical exercise'),
(85, 'S5003456789', 'Holter Monitor (24hr)', '5', 15000, 60000, '24-hour continuous ECG monitoring'),
(86, 'S6001234567', 'Hepatitis B Vaccine', '6', 8000, 20000, 'Hepatitis B immunization shot'),
(87, 'S6002345678', 'Flu Vaccine', '6', 5000, 15000, 'Annual influenza vaccination'),
(88, 'S6003456789', 'COVID-19 Vaccine', '6', 0, 5000, 'COVID-19 immunization'),
(89, 'S6004567890', 'Tetanus Vaccine', '6', 3000, 10000, 'Tetanus immunization shot'),
(90, 'S6005678901', 'Pneumonia Vaccine', '6', 12000, 30000, 'Pneumococcal vaccination'),
(91, 'S7001234567', 'Blood Pressure Monitoring', '7', 500, 2000, 'Blood pressure measurement and monitoring'),
(92, 'S7002345678', 'Wound Dressing', '7', 1000, 5000, 'Professional wound cleaning and dressing'),
(93, 'S7003456789', 'Injection Administration', '7', 800, 3000, 'Intramuscular or intravenous injection'),
(94, 'S7004567890', 'Suture Removal', '7', 1200, 5000, 'Safe removal of surgical sutures'),
(95, 'S7005678901', 'IV Drip Administration', '7', 2000, 8000, 'Intravenous fluid administration'),
(96, 'S7006789012', 'Minor Surgery', '7', 15000, 50000, 'Minor surgical procedures'),
(97, 'S7007890123', 'Ear Cleaning', '7', 800, 3500, 'Professional ear wax removal'),
(98, 'S7008901234', 'Physical Examination', '7', 2000, 8000, 'Complete physical health examination'),
(99, 'S8001234567', 'Emergency Treatment', '8', 10000, 40000, '24/7 emergency medical care'),
(100, 'S8002345678', 'Trauma Care', '8', 15000, 60000, 'Emergency trauma treatment');

INSERT INTO `tbl_service` (`id`, `barcode`, `service_name`, `cat_id`, `buy_price`, `sale_price`, `remark`) VALUES
(101, 'S8003456789', 'CPR Service', '8', 5000, 25000, 'Cardiopulmonary resuscitation'),
(102, 'S8004567890', 'First Aid Treatment', '8', 2000, 8000, 'Basic first aid medical treatment'),
(103, 'S9001234567', 'Medicine Home Delivery', '9', 1000, 3000, 'Free home delivery for medicines'),
(104, 'S9002345678', 'Medication Counseling', '9', 2000, 8000, 'Professional medication guidance'),
(105, 'S9003456789', 'Prescription Review', '9', 1500, 5000, 'Pharmacist prescription review'),
(106, 'S9004567890', 'Medicine Packaging', '9', 500, 2000, 'Weekly/monthly medicine packaging'),
(107, 'S9005678901', 'Drug Interaction Check', '9', 1000, 4000, 'Check for medication interactions'),
(108, 'S0001234567', 'Medical Certificate', '10', 500, 3000, 'Official medical fitness certificate'),
(109, 'S0002345678', 'Health Record Copy', '10', 200, 1000, 'Copy of patient medical records'),
(110, 'S0003456789', 'Insurance Form Processing', '10', 800, 3500, 'Medical insurance form completion'),
(111, 'S0004567890', 'Referral Letter', '10', 300, 1500, 'Medical referral to specialist'),
(112, 'S0005678901', 'Medical Report', '10', 1000, 5000, 'Detailed medical examination report'),
(113, 'S0006789012', 'Prescription Copy', '10', 200, 800, 'Copy of medical prescription'),
(114, 'S0007890123', 'Vaccination Certificate', '10', 300, 1500, 'Official vaccination record certificate');

-- Table: tbl_service_catalog
DROP TABLE IF EXISTS `tbl_service_catalog`;
CREATE TABLE `tbl_service_catalog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_service_catalog
INSERT INTO `tbl_service_catalog` (`id`, `name`) VALUES
(1, 'Consultation'),
(2, 'Laboratory'),
(3, 'X-Ray'),
(4, 'Ultrasound'),
(5, 'ECG'),
(6, 'Vaccination'),
(7, 'Consultation'),
(8, 'Laboratory'),
(9, 'X-Ray'),
(10, 'Ultrasound'),
(11, 'ECG'),
(12, 'Vaccination'),
(13, 'Medical Procedures'),
(14, 'Emergency Care'),
(15, 'Pharmacy Services'),
(16, 'Administrative'),
(17, 'Consultation'),
(18, 'Laboratory'),
(19, 'X-Ray'),
(20, 'Ultrasound'),
(21, 'ECG'),
(22, 'Vaccination'),
(23, 'Medical Procedures'),
(24, 'Emergency Care'),
(25, 'Pharmacy Services'),
(26, 'Administrative');

-- Table: tbl_shopinfo
DROP TABLE IF EXISTS `tbl_shopinfo`;
CREATE TABLE `tbl_shopinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `address` varchar(500) DEFAULT NULL,
  `remark` varchar(250) DEFAULT NULL,
  `thanks` varchar(250) DEFAULT NULL,
  `photo` longblob DEFAULT NULL,
  `photo_path` varchar(255) DEFAULT NULL,
  `user_code` varchar(250) DEFAULT NULL,
  `product_code` varchar(250) DEFAULT NULL,
  `software_code` varchar(250) DEFAULT NULL,
  `printer_voucher_count` int(11) DEFAULT NULL,
  `printer` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_shopinfo
INSERT INTO `tbl_shopinfo` (`id`, `name`, `type`, `ph_no`, `email`, `address`, `remark`, `thanks`, `photo`, `photo_path`, `user_code`, `product_code`, `software_code`, `printer_voucher_count`, `printer`) VALUES
(1, 'Clinic Pro Medical Center', 'Clinic & Pharmacy', '09-999999999', 'info@clinicpro.com', 'No. 123, Main Street, Yangon', 'Open 24/7', 'Thank you for choosing Clinic Pro! Stay healthy!', NULL, NULL, NULL, NULL, NULL, NULL, '80mm');

-- Table: tbl_stock
DROP TABLE IF EXISTS `tbl_stock`;
CREATE TABLE `tbl_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` varchar(255) DEFAULT NULL,
  `cat_id_2` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  `sale_price_latli` int(11) DEFAULT NULL,
  `sale_price_latkar` int(11) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `alert_month` int(11) DEFAULT NULL,
  `alert_date` date DEFAULT NULL,
  `margin` double DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_stock_barcode` (`barcode`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_stock
INSERT INTO `tbl_stock` (`id`, `cat_id`, `cat_id_2`, `barcode`, `name`, `qty`, `qty_alert`, `unit_name`, `cost_price`, `sale_price_latli`, `sale_price_latkar`, `remark`, `expire_date`, `alert_month`, `alert_date`, `margin`, `image_path`) VALUES
(1, '1', NULL, '8850987180001', 'Paracetamol 500mg', 999, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(2, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 496, 30, 'Capsule', 200, 350, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(3, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 799, 40, 'Tablet', 100, 200, 180, 'Immune support', NULL, NULL, NULL, NULL, NULL),
(4, '1', NULL, '885298390177', 'Paracetamol 500mg', 542, 21, 'Tablet', 70, 170, 232, 'Pain relief and fever reducer', '2026-01-03 00:00:00', NULL, NULL, 58, NULL),
(5, '1', NULL, '885315743650', 'Aspirin 325mg', 482, 51, 'Tablet', 219, 256, 204, 'Anti-inflammatory pain reliever', '2026-03-17 00:00:00', NULL, NULL, 56, NULL),
(6, '1', NULL, '885004054519', 'Ibuprofen 400mg', 270, 41, 'Tablet', 91, 239, 352, 'NSAID for pain and inflammation', '2026-10-04 00:00:00', NULL, NULL, 54, NULL),
(7, '1', NULL, '885194110109', 'Diclofenac 50mg', 541, 34, 'Tablet', 237, 193, 119, 'Anti-inflammatory medication', '2026-04-15 00:00:00', NULL, NULL, 22, NULL),
(8, '1', NULL, '885453341038', 'Cetirizine 10mg', 297, 42, 'Tablet', 95, 366, 353, 'Antihistamine for allergies', '2027-04-01 00:00:00', NULL, NULL, 51, NULL),
(9, '1', NULL, '885125337161', 'Loratadine 10mg', 484, 29, 'Tablet', 217, 224, 326, 'Allergy relief medication', '2026-07-14 00:00:00', NULL, NULL, 36, NULL),
(10, '1', NULL, '885160159480', 'Omeprazole 20mg', 639, 47, 'Tablet', 131, 380, 342, 'Proton pump inhibitor for acid reflux', '2027-03-08 00:00:00', NULL, NULL, 40, NULL),
(11, '1', NULL, '885567416756', 'Metformin 500mg', 332, 27, 'Tablet', 167, 151, 329, 'Diabetes medication', '2026-10-08 00:00:00', NULL, NULL, 52, NULL),
(12, '1', NULL, '885900767953', 'Atorvastatin 20mg', 637, 69, 'Tablet', 141, 362, 233, 'Cholesterol-lowering statin', '2025-12-17 00:00:00', NULL, NULL, 57, NULL),
(13, '1', NULL, '885942844875', 'Amlodipine 5mg', 856, 67, 'Tablet', 61, 392, 352, 'Blood pressure medication', '2027-03-17 00:00:00', NULL, NULL, 43, NULL),
(14, '1', NULL, '885686283892', 'Lisinopril 10mg', 819, 69, 'Tablet', 92, 377, 217, 'ACE inhibitor for hypertension', '2026-12-24 00:00:00', NULL, NULL, 32, NULL),
(15, '1', NULL, '885586852469', 'Simvastatin 40mg', 836, 65, 'Tablet', 153, 348, 140, 'Cholesterol management', '2025-12-09 00:00:00', NULL, NULL, 28, NULL),
(16, '1', NULL, '885427146830', 'Clopidogrel 75mg', 891, 53, 'Tablet', 95, 280, 170, 'Antiplatelet medication', '2026-04-06 00:00:00', NULL, NULL, 54, NULL),
(17, '1', NULL, '885502257873', 'Warfarin 5mg', 329, 52, 'Tablet', 84, 368, 200, 'Blood thinner anticoagulant', '2027-05-27 00:00:00', NULL, NULL, 55, NULL),
(18, '1', NULL, '885962508424', 'Digoxin 0.25mg', 634, 41, 'Tablet', 90, 241, 283, 'Heart rhythm medication', '2027-06-28 00:00:00', NULL, NULL, 25, NULL),
(19, '1', NULL, '885995898844', 'Furosemide 40mg', 331, 33, 'Tablet', 64, 344, 343, 'Diuretic for fluid retention', '2025-12-29 00:00:00', NULL, NULL, 36, NULL),
(20, '1', NULL, '885470143832', 'Spironolactone 25mg', 813, 26, 'Tablet', 220, 379, 143, 'Potassium-sparing diuretic', '2026-10-23 00:00:00', NULL, NULL, 46, NULL),
(21, '1', NULL, '885699222016', 'Prednisolone 5mg', 629, 61, 'Tablet', 122, 382, 152, 'Corticosteroid anti-inflammatory', '2027-03-18 00:00:00', NULL, NULL, 49, NULL),
(22, '1', NULL, '885821643812', 'Dexamethasone 0.5mg', 999, 35, 'Tablet', 152, 346, 352, 'Steroid for inflammation', '2026-02-01 00:00:00', NULL, NULL, 25, NULL),
(23, '1', NULL, '885408424176', 'Hydrocortisone 20mg', 263, 69, 'Tablet', 233, 111, 195, 'Mild corticosteroid', '2027-05-24 00:00:00', NULL, NULL, 49, NULL),
(24, '1', NULL, '885997235957', 'Ciprofloxacin 500mg', 213, 52, 'Tablet', 193, 367, 103, 'Broad-spectrum antibiotic', '2026-07-10 00:00:00', NULL, NULL, 49, NULL),
(25, '1', NULL, '885098859304', 'Azithromycin 500mg', 803, 44, 'Tablet', 170, 205, 290, 'Macrolide antibiotic', '2027-01-26 00:00:00', NULL, NULL, 27, NULL),
(26, '1', NULL, '885955995248', 'Doxycycline 100mg', 948, 25, 'Tablet', 69, 236, 147, 'Tetracycline antibiotic', '2026-01-13 00:00:00', NULL, NULL, 49, NULL),
(27, '1', NULL, '885639147881', 'Clarithromycin 500mg', 579, 64, 'Tablet', 142, 182, 326, 'Macrolide antibiotic', '2027-01-02 00:00:00', NULL, NULL, 27, NULL),
(28, '1', NULL, '885552178201', 'Levofloxacin 750mg', 271, 26, 'Tablet', 113, 104, 285, 'Fluoroquinolone antibiotic', '2027-06-15 00:00:00', NULL, NULL, 27, NULL),
(29, '2', NULL, '886728465468', 'Amoxicillin 500mg', 648, 30, 'Capsule', 349, 432, 450, 'Penicillin antibiotic', '2027-02-13 00:00:00', NULL, NULL, 45, NULL),
(30, '2', NULL, '886891922332', 'Flucloxacillin 250mg', 342, 20, 'Capsule', 171, 657, 596, 'Anti-staphylococcal penicillin', '2026-12-27 00:00:00', NULL, NULL, 42, NULL),
(31, '2', NULL, '886897642857', 'Erythromycin 250mg', 201, 16, 'Capsule', 286, 602, 626, 'Macrolide antibiotic', '2026-10-26 00:00:00', NULL, NULL, 58, NULL),
(32, '2', NULL, '886973746949', 'Tetracycline 250mg', 573, 26, 'Capsule', 216, 340, 476, 'Broad-spectrum antibiotic', '2026-12-15 00:00:00', NULL, NULL, 29, NULL),
(33, '2', NULL, '886571828620', 'Cephalexin 500mg', 437, 22, 'Capsule', 142, 458, 357, 'Cephalosporin antibiotic', '2027-07-10 00:00:00', NULL, NULL, 49, NULL),
(34, '2', NULL, '886880914751', 'Trimethoprim 200mg', 628, 45, 'Capsule', 346, 384, 374, 'Antibacterial for UTI', '2026-02-09 00:00:00', NULL, NULL, 46, NULL),
(35, '2', NULL, '886824603607', 'Nitrofurantoin 100mg', 237, 17, 'Capsule', 392, 413, 421, 'Urinary tract antibiotic', '2025-11-20 00:00:00', NULL, NULL, 32, NULL),
(36, '2', NULL, '886311862651', 'Pregabalin 150mg', 181, 19, 'Capsule', 151, 633, 424, 'Neuropathic pain medication', '2027-03-14 00:00:00', NULL, NULL, 41, NULL),
(37, '2', NULL, '886334865875', 'Gabapentin 300mg', 216, 49, 'Capsule', 235, 257, 287, 'Anticonvulsant for nerve pain', '2026-11-03 00:00:00', NULL, NULL, 36, NULL),
(38, '2', NULL, '886716135071', 'Duloxetine 60mg', 611, 17, 'Capsule', 164, 612, 182, 'Antidepressant SNRI', '2027-06-13 00:00:00', NULL, NULL, 53, NULL),
(39, '2', NULL, '886002231479', 'Sertraline 50mg', 676, 48, 'Capsule', 136, 387, 397, 'SSRI antidepressant', '2025-12-22 00:00:00', NULL, NULL, 35, NULL),
(40, '2', NULL, '886819804498', 'Fluoxetine 20mg', 680, 29, 'Capsule', 191, 343, 595, 'SSRI for depression', '2025-12-08 00:00:00', NULL, NULL, 38, NULL),
(41, '2', NULL, '886989431699', 'Venlafaxine 75mg', 425, 16, 'Capsule', 112, 303, 216, 'SNRI antidepressant', '2026-11-11 00:00:00', NULL, NULL, 44, NULL),
(42, '2', NULL, '886019170649', 'Mirtazapine 30mg', 257, 31, 'Capsule', 296, 529, 612, 'Tetracyclic antidepressant', '2027-06-07 00:00:00', NULL, NULL, 27, NULL),
(43, '2', NULL, '886637653993', 'Quetiapine 100mg', 595, 39, 'Capsule', 263, 341, 385, 'Atypical antipsychotic', '2027-02-04 00:00:00', NULL, NULL, 36, NULL),
(44, '2', NULL, '886554490321', 'Olanzapine 10mg', 659, 33, 'Capsule', 284, 409, 478, 'Antipsychotic medication', '2027-02-15 00:00:00', NULL, NULL, 56, NULL),
(45, '2', NULL, '886725131626', 'Risperidone 2mg', 540, 29, 'Capsule', 159, 674, 482, 'Atypical antipsychotic', '2027-07-16 00:00:00', NULL, NULL, 39, NULL),
(46, '2', NULL, '886441097472', 'Aripiprazole 15mg', 643, 31, 'Capsule', 195, 322, 586, 'Atypical antipsychotic', '2025-12-23 00:00:00', NULL, NULL, 26, NULL),
(47, '2', NULL, '886479310452', 'Lansoprazole 30mg', 191, 48, 'Capsule', 320, 667, 233, 'Proton pump inhibitor', '2027-09-23 00:00:00', NULL, NULL, 48, NULL),
(48, '2', NULL, '886061908527', 'Esomeprazole 40mg', 697, 42, 'Capsule', 343, 512, 314, 'PPI for GERD', '2027-07-29 00:00:00', NULL, NULL, 53, NULL),
(49, '3', NULL, '887576582507', 'Paracetamol Syrup 120mg/5ml', 180, 12, 'Bottle', 188, 366, 510, 'Pediatric fever reducer', '2026-09-02 00:00:00', NULL, NULL, 39, NULL),
(50, '3', NULL, '887951984087', 'Ibuprofen Syrup 100mg/5ml', 185, 19, 'Bottle', 176, 671, 552, 'Anti-inflammatory for children', '2026-04-12 00:00:00', NULL, NULL, 46, NULL),
(51, '3', NULL, '887621021204', 'Cetirizine Syrup 5mg/5ml', 210, 26, 'Bottle', 191, 453, 538, 'Antihistamine syrup', '2026-01-14 00:00:00', NULL, NULL, 48, NULL),
(52, '3', NULL, '887968233849', 'Salbutamol Syrup 2mg/5ml', 76, 14, 'Bottle', 329, 831, 410, 'Bronchodilator syrup', '2026-04-08 00:00:00', NULL, NULL, 27, NULL),
(53, '3', NULL, '887565207581', 'Amoxicillin Syrup 125mg/5ml', 54, 23, 'Bottle', 539, 659, 672, 'Pediatric antibiotic', '2026-05-02 00:00:00', NULL, NULL, 54, NULL),
(54, '3', NULL, '887949276021', 'Erythromycin Syrup 125mg/5ml', 101, 28, 'Bottle', 180, 300, 421, 'Macrolide antibiotic syrup', '2026-06-27 00:00:00', NULL, NULL, 26, NULL),
(55, '3', NULL, '887034919932', 'Iron Syrup 100mg/5ml', 333, 17, 'Bottle', 491, 326, 734, 'Iron supplement syrup', '2026-01-16 00:00:00', NULL, NULL, 27, NULL),
(56, '3', NULL, '887609133188', 'Multivitamin Syrup', 54, 26, 'Bottle', 345, 396, 474, 'Vitamin supplement', '2026-03-16 00:00:00', NULL, NULL, 48, NULL),
(57, '3', NULL, '887524449761', 'Cough Syrup with Codeine', 63, 26, 'Bottle', 266, 839, 659, 'Cough suppressant with codeine', '2026-10-10 00:00:00', NULL, NULL, 47, NULL),
(58, '3', NULL, '887429325142', 'Antacid Syrup', 279, 12, 'Bottle', 533, 459, 640, 'Stomach acid neutralizer', '2026-01-18 00:00:00', NULL, NULL, 40, NULL),
(59, '3', NULL, '887889270352', 'Lactulose Syrup', 261, 15, 'Bottle', 526, 864, 382, 'Laxative syrup', '2026-06-29 00:00:00', NULL, NULL, 51, NULL),
(60, '3', NULL, '887006396162', 'Domperidone Syrup 5mg/5ml', 104, 17, 'Bottle', 254, 334, 750, 'Antiemetic syrup', '2026-08-04 00:00:00', NULL, NULL, 36, NULL),
(61, '3', NULL, '887081025220', 'Chlorpheniramine Syrup 2mg/5ml', 185, 18, 'Bottle', 540, 703, 738, 'Antihistamine for allergies', '2026-03-16 00:00:00', NULL, NULL, 34, NULL),
(62, '3', NULL, '887146281874', 'Dextromethorphan Syrup 15mg/5ml', 209, 18, 'Bottle', 345, 839, 435, 'Cough suppressant', '2026-02-13 00:00:00', NULL, NULL, 42, NULL),
(63, '3', NULL, '887632529518', 'Zinc Syrup 20mg/5ml', 210, 13, 'Bottle', 546, 386, 711, 'Zinc supplement syrup', '2026-09-16 00:00:00', NULL, NULL, 52, NULL),
(64, '4', NULL, '888875810019', 'Benzylpenicillin 1MU', 186, 17, 'Vial', 328, 1029, 1402, 'Penicillin injection', '2027-12-15 00:00:00', NULL, NULL, 34, NULL),
(65, '4', NULL, '888551568683', 'Ceftriaxone 1g', 171, 14, 'Vial', 946, 1396, 1394, 'Cephalosporin antibiotic', '2027-02-12 00:00:00', NULL, NULL, 45, NULL),
(66, '4', NULL, '888048771618', 'Gentamicin 80mg', 118, 7, 'Vial', 632, 1547, 691, 'Aminoglycoside antibiotic', '2026-09-18 00:00:00', NULL, NULL, 45, NULL),
(67, '4', NULL, '888328410022', 'Morphine 10mg/ml', 104, 12, 'Vial', 588, 866, 1069, 'Opioid analgesic', '2027-08-24 00:00:00', NULL, NULL, 40, NULL),
(68, '4', NULL, '888946766068', 'Pethidine 100mg', 193, 10, 'Vial', 1034, 1477, 1600, 'Opioid pain relief', '2026-11-28 00:00:00', NULL, NULL, 50, NULL),
(69, '4', NULL, '888410119170', 'Diclofenac 75mg/3ml', 195, 7, 'Vial', 445, 752, 1179, 'NSAID injection', '2026-09-25 00:00:00', NULL, NULL, 35, NULL),
(70, '4', NULL, '888101468215', 'Dexamethasone 4mg/ml', 185, 9, 'Vial', 817, 1182, 1149, 'Corticosteroid injection', '2027-02-19 00:00:00', NULL, NULL, 38, NULL),
(71, '4', NULL, '888337268761', 'Furosemide 20mg/2ml', 145, 19, 'Vial', 331, 756, 1099, 'Diuretic injection', '2027-02-09 00:00:00', NULL, NULL, 53, NULL),
(72, '4', NULL, '888235977976', 'Insulin Glargine 100U/ml', 107, 10, 'Vial', 810, 1635, 1215, 'Long-acting insulin', '2027-09-03 00:00:00', NULL, NULL, 32, NULL),
(73, '4', NULL, '888045346816', 'Heparin 5000U/ml', 229, 18, 'Vial', 969, 903, 1609, 'Anticoagulant injection', '2027-10-08 00:00:00', NULL, NULL, 51, NULL),
(74, '5', NULL, '889792468167', 'Digital Thermometer', 43, 9, 'Piece', 5815, 9909, 4944, 'Digital fever thermometer', '2029-04-04 00:00:00', NULL, NULL, 53, NULL),
(75, '5', NULL, '889336504629', 'Blood Pressure Monitor', 61, 6, 'Piece', 5145, 4481, 7481, 'Automatic BP monitor', '2029-07-23 00:00:00', NULL, NULL, 35, NULL),
(76, '5', NULL, '889683232072', 'Stethoscope', 103, 5, 'Piece', 2644, 9928, 2071, 'Medical stethoscope', '2028-04-14 00:00:00', NULL, NULL, 42, NULL),
(77, '5', NULL, '889146231028', 'Pulse Oximeter', 80, 6, 'Piece', 2421, 6463, 8670, 'SpO2 finger monitor', '2029-09-24 00:00:00', NULL, NULL, 36, NULL),
(78, '5', NULL, '889957739365', 'Glucometer', 24, 11, 'Piece', 1730, 7539, 4297, 'Blood glucose meter', '2027-01-05 00:00:00', NULL, NULL, 38, NULL),
(79, '5', NULL, '889534797637', 'Nebulizer Machine', 58, 9, 'Piece', 2139, 2903, 7483, 'Respiratory nebulizer', '2028-12-21 00:00:00', NULL, NULL, 41, NULL),
(80, '5', NULL, '889853873397', 'Wheelchair', 98, 6, 'Piece', 5747, 2986, 7125, 'Patient mobility chair', '2027-03-08 00:00:00', NULL, NULL, 40, NULL),
(81, '5', NULL, '889772078952', 'Walking Stick', 61, 5, 'Piece', 1081, 3591, 3597, 'Mobility walking aid', '2028-04-08 00:00:00', NULL, NULL, 48, NULL),
(82, '5', NULL, '889925911573', 'Surgical Scissors', 93, 5, 'Piece', 5774, 7539, 8532, 'Stainless steel scissors', '2028-07-18 00:00:00', NULL, NULL, 47, NULL),
(83, '5', NULL, '889343731803', 'Forceps', 36, 11, 'Piece', 5532, 7949, 8330, 'Medical forceps', '2029-04-29 00:00:00', NULL, NULL, 40, NULL),
(84, '5', NULL, '889926456207', 'Syringe 10ml', 68, 8, 'Piece', 1637, 9083, 5336, 'Disposable syringe', '2028-06-28 00:00:00', NULL, NULL, 38, NULL),
(85, '5', NULL, '889216961329', 'IV Cannula 18G', 26, 10, 'Piece', 3627, 3687, 4313, 'Intravenous cannula', '2029-08-28 00:00:00', NULL, NULL, 50, NULL),
(86, '5', NULL, '889950610134', 'Urinary Catheter', 108, 11, 'Piece', 4492, 4586, 7803, 'Foley catheter', '2029-05-14 00:00:00', NULL, NULL, 39, NULL),
(87, '5', NULL, '889192626338', 'Surgical Gloves', 105, 5, 'Piece', 4504, 9044, 9210, 'Sterile examination gloves', '2028-07-22 00:00:00', NULL, NULL, 44, NULL),
(88, '5', NULL, '889980505118', 'Face Mask N95', 108, 13, 'Piece', 3715, 2569, 4691, 'N95 protective mask', '2029-09-30 00:00:00', NULL, NULL, 51, NULL),
(89, '6', NULL, '890744393416', 'Adhesive Bandage', 504, 19, 'Pack', 199, 202, 251, 'Sterile adhesive bandage', '2026-06-02 00:00:00', NULL, NULL, 34, NULL),
(90, '6', NULL, '890104462077', 'Gauze Pad 4x4', 182, 19, 'Pack', 187, 336, 166, 'Sterile gauze dressing', '2026-07-06 00:00:00', NULL, NULL, 30, NULL),
(91, '6', NULL, '890772468164', 'Medical Tape', 138, 31, 'Pack', 130, 187, 154, 'Medical adhesive tape', '2027-06-28 00:00:00', NULL, NULL, 33, NULL),
(92, '6', NULL, '890449553812', 'Antiseptic Solution', 222, 41, 'Pack', 146, 240, 303, 'Wound antiseptic', '2027-02-02 00:00:00', NULL, NULL, 54, NULL),
(93, '6', NULL, '890683629615', 'Hydrogen Peroxide 3%', 388, 15, 'Pack', 72, 402, 380, 'Disinfectant solution', '2027-09-15 00:00:00', NULL, NULL, 30, NULL),
(94, '6', NULL, '890669501314', 'Cotton Swabs', 179, 27, 'Pack', 234, 397, 259, 'Sterile cotton applicators', '2027-06-20 00:00:00', NULL, NULL, 39, NULL),
(95, '6', NULL, '890534447884', 'Elastic Bandage', 104, 21, 'Pack', 96, 419, 335, 'Compression bandage', '2027-06-10 00:00:00', NULL, NULL, 45, NULL),
(96, '6', NULL, '890575534454', 'Instant Cold Pack', 394, 23, 'Pack', 62, 157, 113, 'Emergency cold compress', '2027-01-28 00:00:00', NULL, NULL, 34, NULL),
(97, '6', NULL, '890529907991', 'Burn Gel', 250, 37, 'Pack', 94, 276, 259, 'Burn treatment gel', '2026-10-17 00:00:00', NULL, NULL, 29, NULL),
(98, '6', NULL, '890641303509', 'Antiseptic Cream', 396, 25, 'Pack', 141, 254, 395, 'Topical antiseptic', '2027-09-13 00:00:00', NULL, NULL, 54, NULL),
(99, '7', NULL, '891113337526', 'Vitamin C 1000mg', 281, 14, 'Bottle', 388, 248, 246, 'Immune system support', '2028-10-10 00:00:00', NULL, NULL, 52, NULL),
(100, '7', NULL, '891409588407', 'Vitamin D3 2000IU', 461, 13, 'Bottle', 183, 251, 394, 'Bone health vitamin', '2027-10-09 00:00:00', NULL, NULL, 38, NULL);

INSERT INTO `tbl_stock` (`id`, `cat_id`, `cat_id_2`, `barcode`, `name`, `qty`, `qty_alert`, `unit_name`, `cost_price`, `sale_price_latli`, `sale_price_latkar`, `remark`, `expire_date`, `alert_month`, `alert_date`, `margin`, `image_path`) VALUES
(101, '7', NULL, '891974824422', 'Vitamin B Complex', 400, 18, 'Bottle', 379, 302, 325, 'Energy metabolism support', '2027-01-29 00:00:00', NULL, NULL, 31, NULL),
(102, '7', NULL, '891968073475', 'Folic Acid 5mg', 462, 16, 'Bottle', 203, 605, 257, 'Folate supplement', '2027-11-30 00:00:00', NULL, NULL, 43, NULL),
(103, '7', NULL, '891712858286', 'Iron Tablets 65mg', 309, 17, 'Bottle', 336, 504, 381, 'Iron deficiency supplement', '2027-04-28 00:00:00', NULL, NULL, 27, NULL),
(104, '7', NULL, '891720298638', 'Calcium 500mg + D3', 391, 26, 'Bottle', 102, 274, 409, 'Bone and teeth health', '2028-08-29 00:00:00', NULL, NULL, 35, NULL),
(105, '7', NULL, '891382503721', 'Magnesium 400mg', 148, 14, 'Bottle', 325, 422, 281, 'Muscle and nerve function', '2028-04-11 00:00:00', NULL, NULL, 52, NULL),
(106, '7', NULL, '891283083923', 'Zinc 15mg', 436, 30, 'Bottle', 184, 452, 320, 'Immune support mineral', '2028-02-08 00:00:00', NULL, NULL, 49, NULL),
(107, '7', NULL, '891649112553', 'Omega-3 Fish Oil', 369, 32, 'Bottle', 378, 204, 394, 'Heart health supplement', '2028-04-02 00:00:00', NULL, NULL, 39, NULL),
(108, '7', NULL, '891157808835', 'Probiotics 10B CFU', 453, 33, 'Bottle', 261, 391, 180, 'Digestive health support', '2027-03-07 00:00:00', NULL, NULL, 41, NULL),
(109, '7', NULL, '891931672494', 'Multivitamin for Adults', 273, 34, 'Bottle', 226, 422, 220, 'Complete vitamin formula', '2028-08-28 00:00:00', NULL, NULL, 37, NULL),
(110, '7', NULL, '891447300305', 'Vitamin E 400IU', 430, 33, 'Bottle', 166, 485, 396, 'Antioxidant vitamin', '2028-07-04 00:00:00', NULL, NULL, 33, NULL),
(111, '7', NULL, '891513399374', 'Biotin 10mg', 177, 33, 'Bottle', 163, 330, 211, 'Hair and nail support', '2027-03-18 00:00:00', NULL, NULL, 51, NULL),
(112, '7', NULL, '891488256166', 'Coenzyme Q10 100mg', 81, 24, 'Bottle', 125, 515, 223, 'Cellular energy production', '2027-04-11 00:00:00', NULL, NULL, 42, NULL),
(113, '7', NULL, '891515129822', 'Cranberry Extract 500mg', 120, 19, 'Bottle', 280, 252, 468, 'Urinary tract health', '2028-05-23 00:00:00', NULL, NULL, 30, NULL),
(114, '1', NULL, '8850987180001', 'Paracetamol 500mg', 1000, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(115, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 497, 30, 'Capsule', 200, 350, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(116, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 800, 40, 'Tablet', 100, 200, 180, 'Immune support', NULL, NULL, NULL, NULL, NULL),
(117, '1', NULL, '8850987180001', 'Paracetamol 500mg', 1000, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(118, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 497, 30, 'Capsule', 200, 350, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(119, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 800, 40, 'Tablet', 100, 200, 180, 'Immune support', NULL, NULL, NULL, NULL, NULL);

-- Table: tbl_stock_expense
DROP TABLE IF EXISTS `tbl_stock_expense`;
CREATE TABLE `tbl_stock_expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `reason` varchar(250) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_supplier
DROP TABLE IF EXISTS `tbl_supplier`;
CREATE TABLE `tbl_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `shop` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `remark` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_supplier
INSERT INTO `tbl_supplier` (`id`, `name`, `ph_no`, `nrc_no`, `shop`, `address`, `date`, `remark`) VALUES
(1, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-13 00:00:00', 'Main pharmaceutical supplier'),
(2, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-13 00:00:00', 'Import medicines'),
(3, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-13 00:00:00', 'International supplier'),
(4, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-13 00:00:00', 'Local distributor'),
(5, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-13 00:00:00', 'National distributor'),
(6, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-13 00:00:00', 'Medical equipment'),
(7, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-13 00:00:00', 'Bulk supplier'),
(8, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-13 00:00:00', 'Generic medicines'),
(9, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-13 00:00:00', 'Fast delivery'),
(10, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-13 00:00:00', 'Competitive prices'),
(11, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-14 00:00:00', 'Main pharmaceutical supplier'),
(12, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-14 00:00:00', 'Import medicines'),
(13, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-14 00:00:00', 'International supplier'),
(14, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-14 00:00:00', 'Local distributor'),
(15, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-14 00:00:00', 'National distributor'),
(16, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-14 00:00:00', 'Medical equipment'),
(17, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-14 00:00:00', 'Bulk supplier'),
(18, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-14 00:00:00', 'Generic medicines'),
(19, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-14 00:00:00', 'Fast delivery'),
(20, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-14 00:00:00', 'Competitive prices'),
(21, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-14 00:00:00', 'Main pharmaceutical supplier'),
(22, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-14 00:00:00', 'Import medicines'),
(23, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-14 00:00:00', 'International supplier'),
(24, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-14 00:00:00', 'Local distributor'),
(25, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-14 00:00:00', 'National distributor'),
(26, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-14 00:00:00', 'Medical equipment'),
(27, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-14 00:00:00', 'Bulk supplier'),
(28, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-14 00:00:00', 'Generic medicines'),
(29, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-14 00:00:00', 'Fast delivery'),
(30, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-14 00:00:00', 'Competitive prices');

-- Table: tbl_supplier_debt
DROP TABLE IF EXISTS `tbl_supplier_debt`;
CREATE TABLE `tbl_supplier_debt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_township
DROP TABLE IF EXISTS `tbl_township`;
CREATE TABLE `tbl_township` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_treatment
DROP TABLE IF EXISTS `tbl_treatment`;
CREATE TABLE `tbl_treatment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `chief_complaint` text DEFAULT NULL,
  `present_illness` text DEFAULT NULL,
  `Past_Diagnoses` text DEFAULT NULL,
  `Surgeries_Procedures` text DEFAULT NULL,
  `Hospitalizations` text DEFAULT NULL,
  `Current_Medications` text DEFAULT NULL,
  `Dosages` text DEFAULT NULL,
  `Allergen` text DEFAULT NULL,
  `Treatment_Type` text DEFAULT NULL,
  `diagnosis` text DEFAULT NULL,
  `prescription` text DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Voucher_id` varchar(50) DEFAULT NULL,
  `Recommendation` text DEFAULT NULL,
  `vital_signs` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_treatment_patient` (`patient_id`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_treatment
INSERT INTO `tbl_treatment` (`id`, `patient_id`, `doctor_id`, `chief_complaint`, `present_illness`, `Past_Diagnoses`, `Surgeries_Procedures`, `Hospitalizations`, `Current_Medications`, `Dosages`, `Allergen`, `Treatment_Type`, `diagnosis`, `prescription`, `Date`, `Voucher_id`, `Recommendation`, `vital_signs`, `notes`) VALUES
(1, 'OPD-001', NULL, NULL, NULL, 'Seasonal Allergies', 'None', 'None', 'Paracetamol, Vitamin C', '500mg TID, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', NULL, NULL),
(2, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(3, 'OPD-003', NULL, NULL, NULL, 'Diabetes Type 2 (10 years)', 'None', 'None', 'Metformin, Glimepiride', '500mg BD, 2mg OD', 'Sulfa drugs', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', NULL, NULL),
(4, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(5, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(6, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(7, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(8, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(9, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(10, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(11, 'OPD-011', NULL, NULL, NULL, 'Hyperlipidemia', 'None', 'None', 'Atorvastatin, Omega-3', '20mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1011', 'Low fat diet, regular exercise, follow-up in 3 months', NULL, NULL),
(12, 'OPD-012', NULL, NULL, NULL, 'Hypothyroidism', 'None', 'None', 'Levothyroxine', '100mcg OD (morning)', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1012', 'Take on empty stomach, thyroid function test in 6 weeks', NULL, NULL),
(13, 'OPD-013', NULL, NULL, NULL, 'Ankle Sprain', 'None', 'None', 'Diclofenac, Ice therapy', '75mg BD, Apply 4x/day', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1013', 'RICE protocol, avoid weight bearing, follow-up in 1 week', NULL, NULL),
(14, 'OPD-014', NULL, NULL, NULL, 'Prenatal Care - 24 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium', '5mg OD, 60mg OD, 500mg BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1014', 'Regular antenatal checkups, balanced diet, adequate rest', NULL, NULL),
(15, 'OPD-015', NULL, NULL, NULL, 'Coronary Artery Disease', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin', '100mg OD, 75mg OD, 50mg BD, 20mg OD', 'NSAIDs', 'Outpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-1015', 'Cardiac rehab, stress test in 3 months, low cholesterol diet', NULL, NULL),
(16, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(17, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-08 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(18, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(19, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(20, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-06 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(21, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(22, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(23, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(24, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(25, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(26, 'OPD-001', NULL, NULL, NULL, 'URI resolved, mild cough persists', 'None', 'None', 'Dextromethorphan Syrup', '10ml TID', 'None Known', 'Follow-up', NULL, NULL, '2025-10-10 00:00:00', 'V-1011', 'Complete cough syrup, return if fever develops', NULL, NULL),
(27, 'OPD-002', NULL, NULL, NULL, 'BP controlled, no complications', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-10-06 00:00:00', 'V-1012', 'Continue current medications, BP monitoring at home', NULL, NULL),
(28, 'OPD-003', NULL, NULL, NULL, 'HbA1c improved to 7.2%', 'None', 'None', 'Metformin, Glimepiride, Insulin Glargine', '500mg BD, 2mg OD, 10 units HS', 'Sulfa drugs', 'Follow-up', NULL, NULL, '2025-09-29 00:00:00', 'V-1013', 'Good control, continue regimen, next HbA1c in 3 months', NULL, NULL),
(29, 'OPD-006', NULL, NULL, NULL, 'Migraine frequency reduced', 'None', 'None', 'Propranolol, Magnesium', '40mg BD, 400mg OD', 'Aspirin', 'Follow-up', NULL, NULL, '2025-10-03 00:00:00', 'V-1014', 'Maintain stress diary, continue prophylaxis', NULL, NULL),
(30, 'OPD-007', NULL, NULL, NULL, 'Joint pain improved', 'None', 'None', 'Diclofenac, Glucosamine, Physiotherapy', '75mg BD, 500mg OD, 3x/week', 'None Known', 'Follow-up', NULL, NULL, '2025-10-08 00:00:00', 'V-1015', 'Continue therapy, consider intra-articular injection', NULL, NULL),
(31, 'OPD-001', NULL, NULL, NULL, 'Common Cold - New episode', 'None', 'None', 'Paracetamol, Cetirizine, Vitamin C', '500mg TID, 10mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-09-13 00:00:00', 'V-1016', 'Symptomatic treatment, adequate rest', NULL, NULL),
(32, 'OPD-002', NULL, NULL, NULL, 'Hypertension - Routine checkup', 'None', 'None', 'Amlodipine, Losartan, Aspirin', '5mg OD, 50mg OD, 100mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-14 00:00:00', 'V-1017', 'BP well controlled, continue medications', NULL, NULL),
(33, 'OPD-011', NULL, NULL, NULL, 'Lipid panel improved', 'None', 'None', 'Atorvastatin, Omega-3, Fenofibrate', '20mg OD, 1000mg OD, 145mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-07-15 00:00:00', 'V-1018', 'Excellent response, maintain lifestyle changes', NULL, NULL),
(34, 'OPD-012', NULL, NULL, NULL, 'TSH normalized', 'None', 'None', 'Levothyroxine', '100mcg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-01 00:00:00', 'V-1019', 'Optimal dose achieved, annual monitoring', NULL, NULL),
(35, 'OPD-015', NULL, NULL, NULL, 'Stable angina', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin, Isosorbide', '100mg OD, 75mg OD, 50mg BD, 20mg OD, 5mg BD', 'NSAIDs', 'Follow-up', NULL, NULL, '2025-09-22 00:00:00', 'V-1020', 'Exercise tolerance improved, continue cardiac rehab', NULL, NULL),
(36, 'OPD-013', NULL, NULL, NULL, 'Ankle fully healed', 'None', 'None', 'Stopped medications', 'None', 'None Known', 'Follow-up', NULL, NULL, '2025-09-29 00:00:00', 'V-1021', 'Gradual return to activities, strengthening exercises', NULL, NULL),
(37, 'OPD-014', NULL, NULL, NULL, 'Normal pregnancy progression - 28 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium, Vitamin D', '5mg OD, 60mg OD, 500mg BD, 1000 IU OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-15 00:00:00', 'V-1022', 'Ultrasound scheduled, glucose tolerance test done', NULL, NULL),
(38, 'OPD-008', NULL, NULL, NULL, 'Asthma well controlled', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Follow-up', NULL, NULL, '2025-09-28 00:00:00', 'V-1023', 'Peak flow monitoring, continue preventer', NULL, NULL),
(39, 'OPD-009', NULL, NULL, NULL, 'Eczema improved', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Follow-up', NULL, NULL, '2025-10-06 00:00:00', 'V-1024', 'Taper steroid cream, emollient use', NULL, NULL),
(40, 'OPD-004', NULL, NULL, NULL, 'Back pain recurrence', 'None', 'None', 'Diclofenac, Muscle Relaxant, Physiotherapy', '75mg BD, 1 tab TID, Daily sessions', 'None Known', 'Outpatient', NULL, NULL, '2025-09-23 00:00:00', 'V-1025', 'MRI scheduled, core strengthening exercises', NULL, NULL),
(41, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(42, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-08 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(43, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(44, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(45, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-06 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(46, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(47, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(48, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(49, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(50, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(51, 'IPD-001', NULL, NULL, NULL, 'Pneumonia resolving', 'None', 'Current admission', 'Oral Amoxicillin, Bromhexine', '500mg TID, 8mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2011', 'Ready for discharge tomorrow, complete oral antibiotics', NULL, NULL),
(52, 'IPD-003', NULL, NULL, NULL, 'Dengue - Platelets recovering', 'None', 'Current admission', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2012', 'Platelets 95k, continue monitoring, discharge in 2 days', NULL, NULL),
(53, 'IPD-005', NULL, NULL, NULL, 'Stroke - Rehabilitation progress', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel, Physiotherapy', '100mg OD, 40mg OD, 75mg OD, BD sessions', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2013', 'Motor function improving, continue intensive rehab', NULL, NULL),
(54, 'IPD-007', NULL, NULL, NULL, 'Fracture healing well', 'ORIF Left Femur', 'Current admission', 'Oral Cefuroxime, Tramadol', '500mg BD, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2014', 'X-ray shows good alignment, start partial weight bearing', NULL, NULL),
(55, 'IPD-010', NULL, NULL, NULL, 'Post-cholecystectomy recovery', 'Laparoscopic Cholecystectomy', 'Current admission', 'Oral Cefuroxime, Paracetamol', '500mg BD, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2015', 'Wound healing well, tolerating diet, discharge tomorrow', NULL, NULL),
(56, 'OPD-001', 0, '', '', 'Seasonal Allergies', 'None', NULL, NULL, NULL, 'None Known', '', '', '', '2025-10-14 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', '{"bp":"","temp":"","pulse":"","weight":"","respiratory":"","spo2":"","height":"","bmi":""}', ''),
(57, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(58, 'OPD-003', NULL, NULL, NULL, 'Diabetes Type 2 (10 years)', 'None', 'None', 'Metformin, Glimepiride', '500mg BD, 2mg OD', 'Sulfa drugs', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', NULL, NULL),
(59, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(60, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(61, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(62, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(63, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(64, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(65, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(66, 'OPD-011', NULL, NULL, NULL, 'Hyperlipidemia', 'None', 'None', 'Atorvastatin, Omega-3', '20mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1011', 'Low fat diet, regular exercise, follow-up in 3 months', NULL, NULL),
(67, 'OPD-012', NULL, NULL, NULL, 'Hypothyroidism', 'None', 'None', 'Levothyroxine', '100mcg OD (morning)', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1012', 'Take on empty stomach, thyroid function test in 6 weeks', NULL, NULL),
(68, 'OPD-013', NULL, NULL, NULL, 'Ankle Sprain', 'None', 'None', 'Diclofenac, Ice therapy', '75mg BD, Apply 4x/day', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1013', 'RICE protocol, avoid weight bearing, follow-up in 1 week', NULL, NULL),
(69, 'OPD-014', NULL, NULL, NULL, 'Prenatal Care - 24 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium', '5mg OD, 60mg OD, 500mg BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1014', 'Regular antenatal checkups, balanced diet, adequate rest', NULL, NULL),
(70, 'OPD-015', NULL, NULL, NULL, 'Coronary Artery Disease', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin', '100mg OD, 75mg OD, 50mg BD, 20mg OD', 'NSAIDs', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1015', 'Cardiac rehab, stress test in 3 months, low cholesterol diet', NULL, NULL),
(71, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(72, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(73, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(74, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(75, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(76, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(77, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(78, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(79, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(80, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(81, 'OPD-001', NULL, NULL, NULL, 'URI resolved, mild cough persists', 'None', 'None', 'Dextromethorphan Syrup', '10ml TID', 'None Known', 'Follow-up', NULL, NULL, '2025-10-11 00:00:00', 'V-1011', 'Complete cough syrup, return if fever develops', NULL, NULL),
(82, 'OPD-002', NULL, NULL, NULL, 'BP controlled, no complications', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-10-07 00:00:00', 'V-1012', 'Continue current medications, BP monitoring at home', NULL, NULL),
(83, 'OPD-003', NULL, NULL, NULL, 'HbA1c improved to 7.2%', 'None', 'None', 'Metformin, Glimepiride, Insulin Glargine', '500mg BD, 2mg OD, 10 units HS', 'Sulfa drugs', 'Follow-up', NULL, NULL, '2025-09-30 00:00:00', 'V-1013', 'Good control, continue regimen, next HbA1c in 3 months', NULL, NULL),
(84, 'OPD-006', NULL, NULL, NULL, 'Migraine frequency reduced', 'None', 'None', 'Propranolol, Magnesium', '40mg BD, 400mg OD', 'Aspirin', 'Follow-up', NULL, NULL, '2025-10-04 00:00:00', 'V-1014', 'Maintain stress diary, continue prophylaxis', NULL, NULL),
(85, 'OPD-007', NULL, NULL, NULL, 'Joint pain improved', 'None', 'None', 'Diclofenac, Glucosamine, Physiotherapy', '75mg BD, 500mg OD, 3x/week', 'None Known', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1015', 'Continue therapy, consider intra-articular injection', NULL, NULL),
(86, 'OPD-001', NULL, NULL, NULL, 'Common Cold - New episode', 'None', 'None', 'Paracetamol, Cetirizine, Vitamin C', '500mg TID, 10mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-09-14 00:00:00', 'V-1016', 'Symptomatic treatment, adequate rest', NULL, NULL),
(87, 'OPD-002', NULL, NULL, NULL, 'Hypertension - Routine checkup', 'None', 'None', 'Amlodipine, Losartan, Aspirin', '5mg OD, 50mg OD, 100mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-15 00:00:00', 'V-1017', 'BP well controlled, continue medications', NULL, NULL),
(88, 'OPD-011', NULL, NULL, NULL, 'Lipid panel improved', 'None', 'None', 'Atorvastatin, Omega-3, Fenofibrate', '20mg OD, 1000mg OD, 145mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-07-16 00:00:00', 'V-1018', 'Excellent response, maintain lifestyle changes', NULL, NULL),
(89, 'OPD-012', NULL, NULL, NULL, 'TSH normalized', 'None', 'None', 'Levothyroxine', '100mcg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-02 00:00:00', 'V-1019', 'Optimal dose achieved, annual monitoring', NULL, NULL),
(90, 'OPD-015', NULL, NULL, NULL, 'Stable angina', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin, Isosorbide', '100mg OD, 75mg OD, 50mg BD, 20mg OD, 5mg BD', 'NSAIDs', 'Follow-up', NULL, NULL, '2025-09-23 00:00:00', 'V-1020', 'Exercise tolerance improved, continue cardiac rehab', NULL, NULL),
(91, 'OPD-013', NULL, NULL, NULL, 'Ankle fully healed', 'None', 'None', 'Stopped medications', 'None', 'None Known', 'Follow-up', NULL, NULL, '2025-09-30 00:00:00', 'V-1021', 'Gradual return to activities, strengthening exercises', NULL, NULL),
(92, 'OPD-014', NULL, NULL, NULL, 'Normal pregnancy progression - 28 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium, Vitamin D', '5mg OD, 60mg OD, 500mg BD, 1000 IU OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-16 00:00:00', 'V-1022', 'Ultrasound scheduled, glucose tolerance test done', NULL, NULL),
(93, 'OPD-008', NULL, NULL, NULL, 'Asthma well controlled', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Follow-up', NULL, NULL, '2025-09-29 00:00:00', 'V-1023', 'Peak flow monitoring, continue preventer', NULL, NULL),
(94, 'OPD-009', NULL, NULL, NULL, 'Eczema improved', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Follow-up', NULL, NULL, '2025-10-07 00:00:00', 'V-1024', 'Taper steroid cream, emollient use', NULL, NULL),
(95, 'OPD-004', NULL, NULL, NULL, 'Back pain recurrence', 'None', 'None', 'Diclofenac, Muscle Relaxant, Physiotherapy', '75mg BD, 1 tab TID, Daily sessions', 'None Known', 'Outpatient', NULL, NULL, '2025-09-24 00:00:00', 'V-1025', 'MRI scheduled, core strengthening exercises', NULL, NULL),
(96, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(97, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(98, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(99, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(100, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL);

INSERT INTO `tbl_treatment` (`id`, `patient_id`, `doctor_id`, `chief_complaint`, `present_illness`, `Past_Diagnoses`, `Surgeries_Procedures`, `Hospitalizations`, `Current_Medications`, `Dosages`, `Allergen`, `Treatment_Type`, `diagnosis`, `prescription`, `Date`, `Voucher_id`, `Recommendation`, `vital_signs`, `notes`) VALUES
(101, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(102, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(103, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(104, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(105, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(106, 'IPD-001', NULL, NULL, NULL, 'Pneumonia resolving', 'None', 'Current admission', 'Oral Amoxicillin, Bromhexine', '500mg TID, 8mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2011', 'Ready for discharge tomorrow, complete oral antibiotics', NULL, NULL),
(107, 'IPD-003', NULL, NULL, NULL, 'Dengue - Platelets recovering', 'None', 'Current admission', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2012', 'Platelets 95k, continue monitoring, discharge in 2 days', NULL, NULL),
(108, 'IPD-005', NULL, NULL, NULL, 'Stroke - Rehabilitation progress', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel, Physiotherapy', '100mg OD, 40mg OD, 75mg OD, BD sessions', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2013', 'Motor function improving, continue intensive rehab', NULL, NULL),
(109, 'IPD-007', NULL, NULL, NULL, 'Fracture healing well', 'ORIF Left Femur', 'Current admission', 'Oral Cefuroxime, Tramadol', '500mg BD, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2014', 'X-ray shows good alignment, start partial weight bearing', NULL, NULL),
(110, 'IPD-010', NULL, NULL, NULL, 'Post-cholecystectomy recovery', 'Laparoscopic Cholecystectomy', 'Current admission', 'Oral Cefuroxime, Paracetamol', '500mg BD, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2015', 'Wound healing well, tolerating diet, discharge tomorrow', NULL, NULL),
(111, 'OPD-001', NULL, NULL, NULL, 'Seasonal Allergies', 'None', 'None', 'Paracetamol, Vitamin C', '500mg TID, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', NULL, NULL),
(112, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(113, 'OPD-003', NULL, NULL, NULL, 'Diabetes Type 2 (10 years)', 'None', 'None', 'Metformin, Glimepiride', '500mg BD, 2mg OD', 'Sulfa drugs', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', NULL, NULL),
(114, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(115, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(116, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(117, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(118, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(119, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(120, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(121, 'OPD-011', NULL, NULL, NULL, 'Hyperlipidemia', 'None', 'None', 'Atorvastatin, Omega-3', '20mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1011', 'Low fat diet, regular exercise, follow-up in 3 months', NULL, NULL),
(122, 'OPD-012', NULL, NULL, NULL, 'Hypothyroidism', 'None', 'None', 'Levothyroxine', '100mcg OD (morning)', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1012', 'Take on empty stomach, thyroid function test in 6 weeks', NULL, NULL),
(123, 'OPD-013', NULL, NULL, NULL, 'Ankle Sprain', 'None', 'None', 'Diclofenac, Ice therapy', '75mg BD, Apply 4x/day', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1013', 'RICE protocol, avoid weight bearing, follow-up in 1 week', NULL, NULL),
(124, 'OPD-014', NULL, NULL, NULL, 'Prenatal Care - 24 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium', '5mg OD, 60mg OD, 500mg BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1014', 'Regular antenatal checkups, balanced diet, adequate rest', NULL, NULL),
(125, 'OPD-015', NULL, NULL, NULL, 'Coronary Artery Disease', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin', '100mg OD, 75mg OD, 50mg BD, 20mg OD', 'NSAIDs', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1015', 'Cardiac rehab, stress test in 3 months, low cholesterol diet', NULL, NULL),
(126, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(127, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(128, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(129, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(130, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(131, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(132, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(133, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(134, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(135, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(136, 'OPD-001', NULL, NULL, NULL, 'URI resolved, mild cough persists', 'None', 'None', 'Dextromethorphan Syrup', '10ml TID', 'None Known', 'Follow-up', NULL, NULL, '2025-10-11 00:00:00', 'V-1011', 'Complete cough syrup, return if fever develops', NULL, NULL),
(137, 'OPD-002', NULL, NULL, NULL, 'BP controlled, no complications', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-10-07 00:00:00', 'V-1012', 'Continue current medications, BP monitoring at home', NULL, NULL),
(138, 'OPD-003', NULL, NULL, NULL, 'HbA1c improved to 7.2%', 'None', 'None', 'Metformin, Glimepiride, Insulin Glargine', '500mg BD, 2mg OD, 10 units HS', 'Sulfa drugs', 'Follow-up', NULL, NULL, '2025-09-30 00:00:00', 'V-1013', 'Good control, continue regimen, next HbA1c in 3 months', NULL, NULL),
(139, 'OPD-006', NULL, NULL, NULL, 'Migraine frequency reduced', 'None', 'None', 'Propranolol, Magnesium', '40mg BD, 400mg OD', 'Aspirin', 'Follow-up', NULL, NULL, '2025-10-04 00:00:00', 'V-1014', 'Maintain stress diary, continue prophylaxis', NULL, NULL),
(140, 'OPD-007', NULL, NULL, NULL, 'Joint pain improved', 'None', 'None', 'Diclofenac, Glucosamine, Physiotherapy', '75mg BD, 500mg OD, 3x/week', 'None Known', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1015', 'Continue therapy, consider intra-articular injection', NULL, NULL),
(141, 'OPD-001', NULL, NULL, NULL, 'Common Cold - New episode', 'None', 'None', 'Paracetamol, Cetirizine, Vitamin C', '500mg TID, 10mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-09-14 00:00:00', 'V-1016', 'Symptomatic treatment, adequate rest', NULL, NULL),
(142, 'OPD-002', NULL, NULL, NULL, 'Hypertension - Routine checkup', 'None', 'None', 'Amlodipine, Losartan, Aspirin', '5mg OD, 50mg OD, 100mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-15 00:00:00', 'V-1017', 'BP well controlled, continue medications', NULL, NULL),
(143, 'OPD-011', NULL, NULL, NULL, 'Lipid panel improved', 'None', 'None', 'Atorvastatin, Omega-3, Fenofibrate', '20mg OD, 1000mg OD, 145mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-07-16 00:00:00', 'V-1018', 'Excellent response, maintain lifestyle changes', NULL, NULL),
(144, 'OPD-012', NULL, NULL, NULL, 'TSH normalized', 'None', 'None', 'Levothyroxine', '100mcg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-02 00:00:00', 'V-1019', 'Optimal dose achieved, annual monitoring', NULL, NULL),
(145, 'OPD-015', NULL, NULL, NULL, 'Stable angina', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin, Isosorbide', '100mg OD, 75mg OD, 50mg BD, 20mg OD, 5mg BD', 'NSAIDs', 'Follow-up', NULL, NULL, '2025-09-23 00:00:00', 'V-1020', 'Exercise tolerance improved, continue cardiac rehab', NULL, NULL),
(146, 'OPD-013', NULL, NULL, NULL, 'Ankle fully healed', 'None', 'None', 'Stopped medications', 'None', 'None Known', 'Follow-up', NULL, NULL, '2025-09-30 00:00:00', 'V-1021', 'Gradual return to activities, strengthening exercises', NULL, NULL),
(147, 'OPD-014', NULL, NULL, NULL, 'Normal pregnancy progression - 28 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium, Vitamin D', '5mg OD, 60mg OD, 500mg BD, 1000 IU OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-16 00:00:00', 'V-1022', 'Ultrasound scheduled, glucose tolerance test done', NULL, NULL),
(148, 'OPD-008', NULL, NULL, NULL, 'Asthma well controlled', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Follow-up', NULL, NULL, '2025-09-29 00:00:00', 'V-1023', 'Peak flow monitoring, continue preventer', NULL, NULL),
(149, 'OPD-009', NULL, NULL, NULL, 'Eczema improved', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Follow-up', NULL, NULL, '2025-10-07 00:00:00', 'V-1024', 'Taper steroid cream, emollient use', NULL, NULL),
(150, 'OPD-004', NULL, NULL, NULL, 'Back pain recurrence', 'None', 'None', 'Diclofenac, Muscle Relaxant, Physiotherapy', '75mg BD, 1 tab TID, Daily sessions', 'None Known', 'Outpatient', NULL, NULL, '2025-09-24 00:00:00', 'V-1025', 'MRI scheduled, core strengthening exercises', NULL, NULL),
(151, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(152, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(153, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(154, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(155, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(156, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(157, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(158, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(159, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(160, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(161, 'IPD-001', NULL, NULL, NULL, 'Pneumonia resolving', 'None', 'Current admission', 'Oral Amoxicillin, Bromhexine', '500mg TID, 8mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2011', 'Ready for discharge tomorrow, complete oral antibiotics', NULL, NULL),
(162, 'IPD-003', NULL, NULL, NULL, 'Dengue - Platelets recovering', 'None', 'Current admission', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2012', 'Platelets 95k, continue monitoring, discharge in 2 days', NULL, NULL),
(163, 'IPD-005', NULL, NULL, NULL, 'Stroke - Rehabilitation progress', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel, Physiotherapy', '100mg OD, 40mg OD, 75mg OD, BD sessions', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2013', 'Motor function improving, continue intensive rehab', NULL, NULL),
(164, 'IPD-007', NULL, NULL, NULL, 'Fracture healing well', 'ORIF Left Femur', 'Current admission', 'Oral Cefuroxime, Tramadol', '500mg BD, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2014', 'X-ray shows good alignment, start partial weight bearing', NULL, NULL),
(165, 'IPD-010', NULL, NULL, NULL, 'Post-cholecystectomy recovery', 'Laparoscopic Cholecystectomy', 'Current admission', 'Oral Cefuroxime, Paracetamol', '500mg BD, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2015', 'Wound healing well, tolerating diet, discharge tomorrow', NULL, NULL),
(166, 'OPD-002', 5, 'ass', 'ss', 'ss', 's', NULL, NULL, NULL, 's', 'Laboratory', 'ss', 'Paracetamol 500mg - TID - 5 days
Amoxicillin 500mg - TID - 7 days
Ibuprofen 400mg - BID - 3 days
Azithromycin 500mg - OD - 3 days
Cetirizine 10mg - OD - 5 days', '2025-10-14 00:00:00', NULL, 's', '{"bp":"120/82","temp":"22","pulse":"22","weight":"22","respiratory":"22","spo2":"22","height":"22","bmi":"454.5 (Obese)"}', 's'),
(167, 'OPD-002', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emergency', 'sdas', 'asd', '2025-10-14 00:00:00', NULL, NULL, NULL, NULL),
(168, 'OPD-001', 7, '22', '2', '2', '2', NULL, NULL, NULL, '2', 'Consultation', '2', 'Amoxicillin 500mg - TID - 7 days
Paracetamol 500mg - TID - 5 days
Ibuprofen 400mg - BID - 3 days
Cetirizine 10mg - OD - 5 days
Azithromycin 500mg - OD - 3 days', '2025-10-14 00:00:00', NULL, '2', '{"bp":"22","temp":"22","pulse":"2","weight":"2","respiratory":"2","spo2":"2","height":"2","bmi":"5000.0 (Obese)"}', '2'),
(169, 'OPD-001', 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Follow-up', 'fsdfsdf', 'sdfsdfsdfsdfsdf', '2025-10-14 00:00:00', NULL, NULL, NULL, NULL),
(170, 'OPD-001', 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Follow-up', '22222222222', '2222222222', '2025-10-14 00:00:00', NULL, NULL, NULL, NULL),
(171, 'OPD-001', NULL, 'Test', 'Test', 'Test', 'Test', NULL, NULL, NULL, 'Test', 'Follow-up', 'Test', 'Paracetamol 500mg - TID - 5 days
Amoxicillin 500mg - TID - 7 days
Omeprazole 20mg - OD - 7 days', '2025-10-14 00:00:00', NULL, 'Test', '{"bp":"120","temp":"98","pulse":"72","weight":"70","respiratory":"120","spo2":"98","height":"170","bmi":"24.2 (Normal)"}', 'Test');

-- Table: tbl_unit
DROP TABLE IF EXISTS `tbl_unit`;
CREATE TABLE `tbl_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit_name` varchar(50) DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_unit
INSERT INTO `tbl_unit` (`id`, `unit_name`, `remark`) VALUES
(1, 'Tablet', 'Per tablet'),
(2, 'Box', 'Per box'),
(3, 'Bottle', 'Per bottle'),
(4, 'Vial', 'Per vial'),
(5, 'Pack', 'Per pack'),
(6, 'Piece', 'Per piece'),
(7, 'Tablet', 'Per tablet'),
(8, 'Box', 'Per box'),
(9, 'Bottle', 'Per bottle'),
(10, 'Vial', 'Per vial'),
(11, 'Pack', 'Per pack'),
(12, 'Piece', 'Per piece'),
(13, 'Tablet', 'Per tablet'),
(14, 'Box', 'Per box'),
(15, 'Bottle', 'Per bottle'),
(16, 'Vial', 'Per vial'),
(17, 'Pack', 'Per pack'),
(18, 'Piece', 'Per piece');

-- Table: tbl_user
DROP TABLE IF EXISTS `tbl_user`;
CREATE TABLE `tbl_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` varchar(100) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `passwd` varchar(100) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `photo` longblob DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_user
INSERT INTO `tbl_user` (`id`, `role_id`, `name`, `passwd`, `ph_no`, `nrc_no`, `address`, `photo`, `date`) VALUES
(1, '1', 'admin', '$2a$10$HYGCRFlrrH8XXMztCZJhMO1ijTFzByrnNf7nERKFvMPyATJLickES', '09-123456789', '12/YGNXXX', 'Yangon', NULL, '2025-10-13 00:00:00');

-- Table: tbl_user_log
DROP TABLE IF EXISTS `tbl_user_log`;
CREATE TABLE `tbl_user_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) NOT NULL,
  `login_time` datetime DEFAULT NULL,
  `logout_time` datetime DEFAULT NULL,
  `total_sale` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_user_log
INSERT INTO `tbl_user_log` (`id`, `user_name`, `login_time`, `logout_time`, `total_sale`) VALUES
(1, 'admin', '2025-10-13 09:35:40', NULL, NULL),
(2, 'admin', '2025-10-13 11:32:45', NULL, NULL);

-- Table: tbl_voucher
DROP TABLE IF EXISTS `tbl_voucher`;
CREATE TABLE `tbl_voucher` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_voucher
INSERT INTO `tbl_voucher` (`id`, `user_name`, `sub_total`, `actual_cost`, `dis`, `tax`, `customer_name`, `Date`, `status`, `payment`) VALUES
(1, 'Current User', 650, 650, 0, 0, 'Walk-in', '2025-10-13 09:36:06', 1, 'Cash'),
(2, 'Current User', 6291, 6291, 0, 0, 'Walk-in', '2025-10-13 11:21:59', 1, 'Cash'),
(3, 'Current User', 1336, 1336, 0, 0, 'Walk-in', '2025-10-14 14:13:30', 1, 'Cash'),
(4, 'Current User', 2455, 2455, 0, 0, 'Walk-in', '2025-10-14 15:25:30', 1, 'Cash'),
(5, 'Current User', 217500, 217500, 0, 0, 'Walk-in', '2025-10-14 16:26:46', 1, 'Cash');

-- Table: tbl_voucher_archive
DROP TABLE IF EXISTS `tbl_voucher_archive`;
CREATE TABLE `tbl_voucher_archive` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_voucher_return
DROP TABLE IF EXISTS `tbl_voucher_return`;
CREATE TABLE `tbl_voucher_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SET FOREIGN_KEY_CHECKS=1;
