-- Clinic Pro V3 Database Backup
-- Created: 2025-10-24T06:50:10.855Z
-- Tables: 86

SET FOREIGN_KEY_CHECKS=0;

-- Table: tbl_adverse_drug_events
DROP TABLE IF EXISTS `tbl_adverse_drug_events`;
CREATE TABLE `tbl_adverse_drug_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `drug_id` int(11) NOT NULL,
  `event_type` varchar(100) NOT NULL COMMENT 'Allergic reaction, Side effect, etc.',
  `severity` enum('Mild','Moderate','Severe','Life-threatening') DEFAULT 'Mild',
  `description` text NOT NULL,
  `onset_date` datetime DEFAULT NULL,
  `reported_date` datetime DEFAULT current_timestamp(),
  `reported_by` int(11) NOT NULL,
  `action_taken` text DEFAULT NULL,
  `outcome` enum('Resolved','Ongoing','Fatal','Unknown') DEFAULT 'Ongoing',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` enum('Open','Under_Review','Resolved','Closed') DEFAULT 'Open',
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_drug_id` (`drug_id`),
  KEY `idx_severity` (`severity`),
  KEY `idx_reported_date` (`reported_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_alert
DROP TABLE IF EXISTS `tbl_alert`;
CREATE TABLE `tbl_alert` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_alert
INSERT INTO `tbl_alert` (`id`, `cat_name`, `barcode`, `name`, `qty`, `qty_alert`, `date`, `status`) VALUES
(1, '21', '8808231739997', 'Amoxilin', 1, 10, '2025-10-14 00:00:00', 1),
(2, '21', '8808231739997', 'Amoxilin', 0, 10, '2025-10-16 00:00:00', 1);

-- Table: tbl_appointment
DROP TABLE IF EXISTS `tbl_appointment`;
CREATE TABLE `tbl_appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `case_` varchar(50) DEFAULT NULL,
  `dr_name` varchar(50) DEFAULT NULL,
  `token_number` varchar(50) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `status` varchar(20) DEFAULT 'scheduled',
  PRIMARY KEY (`id`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_appointment
INSERT INTO `tbl_appointment` (`id`, `name`, `phone`, `case_`, `dr_name`, `token_number`, `time`, `status`) VALUES
(2, 'Thua UA', '234234444', NULL, 'Dr. Aung Aung', NULL, '2025-10-14 14:22:00', 'completed'),
(3, 'Mr Moe', '09225111', 'ပြမယ်', 'Dr. Kyaw Kyaw', NULL, '2025-10-23 14:22:00', 'completed');

-- Table: tbl_beds
DROP TABLE IF EXISTS `tbl_beds`;
CREATE TABLE `tbl_beds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bed_number` varchar(20) NOT NULL,
  `room_number` varchar(20) NOT NULL,
  `department_id` int(11) NOT NULL,
  `bed_type` enum('General','ICU','CCU','NICU','Private','Semi-Private') DEFAULT 'General',
  `status` enum('Available','Occupied','Maintenance','Reserved') DEFAULT 'Available',
  `current_patient_id` varchar(50) DEFAULT NULL,
  `admission_date` datetime DEFAULT NULL,
  `daily_rate` decimal(10,2) DEFAULT 0.00,
  `equipment` text DEFAULT NULL COMMENT 'JSON array of equipment',
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_bed` (`bed_number`,`room_number`,`department_id`),
  KEY `idx_bed_number` (`bed_number`),
  KEY `idx_department` (`department_id`),
  KEY `idx_status` (`status`),
  CONSTRAINT `tbl_beds_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_beds
INSERT INTO `tbl_beds` (`id`, `bed_number`, `room_number`, `department_id`, `bed_type`, `status`, `current_patient_id`, `admission_date`, `daily_rate`, `equipment`, `notes`, `is_active`, `created_at`, `updated_at`) VALUES
(3, 'ER003', 'ER-3', 1, 'General', '', NULL, NULL, '100.00', 'Standard equipment', 'Bed in Emergency department', 1, '2025-10-15 19:34:50', '2025-10-17 23:27:28'),
(4, 'ICU001', 'ICU-101', 2, 'ICU', 'Occupied', 'IP000051', '2025-10-17 23:30:47', '500.00', 'Standard equipment', 'Bed in Intensive Care Unit department', 1, '2025-10-15 19:34:50', '2025-10-17 23:30:47'),
(5, 'ICU002', 'ICU-102', 2, 'ICU', 'Occupied', 'IP000052', '2025-10-23 10:09:35', '500.00', 'Standard equipment', 'Bed in Intensive Care Unit department', 1, '2025-10-15 19:34:50', '2025-10-23 10:09:35'),
(6, 'ICU003', 'ICU-103', 2, 'ICU', 'Maintenance', NULL, NULL, '500.00', 'Standard equipment', 'Bed in Intensive Care Unit department', 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(7, 'GM001', 'GM-201', 3, 'General', 'Occupied', 'IP000053', '2025-10-24 12:04:45', '200.00', 'Standard equipment', 'Bed in General Medicine department', 1, '2025-10-15 19:34:50', '2025-10-24 12:04:45'),
(8, 'GM002', 'GM-202', 3, 'Private', 'Available', NULL, NULL, '300.00', 'Standard equipment', 'Bed in General Medicine department', 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(9, 'GM003', 'GM-203', 3, 'Semi-Private', 'Available', NULL, NULL, '250.00', 'Standard equipment', 'Bed in General Medicine department', 1, '2025-10-15 19:34:50', '2025-10-16 23:50:57'),
(10, 'SUR001', 'SUR-301', 4, 'General', 'Available', NULL, NULL, '350.00', 'Standard equipment', 'Bed in Surgery department', 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(11, 'SUR002', 'SUR-302', 4, 'Private', 'Reserved', NULL, NULL, '450.00', 'Standard equipment', 'Bed in Surgery department', 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(12, 'PED001', 'PED-401', 5, 'General', 'Occupied', 'IP000054', '2025-10-24 12:05:45', '180.00', 'Standard equipment', 'Bed in Pediatrics department', 1, '2025-10-15 19:34:50', '2025-10-24 12:05:45'),
(14, 'Mr-001', '2001', 3, 'ICU', 'Maintenance', NULL, NULL, '5000.00', 'aa', 'aa', 1, '2025-10-15 19:57:14', '2025-10-15 19:57:14');

-- Table: tbl_case
DROP TABLE IF EXISTS `tbl_case`;
CREATE TABLE `tbl_case` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_case
INSERT INTO `tbl_case` (`id`, `name`) VALUES
(1, 'Fever'),
(2, 'Cold & Flu'),
(3, 'Headache'),
(4, 'Stomach Pain'),
(5, 'Injury'),
(6, 'Diabetes'),
(7, 'Hypertension'),
(8, 'Check-up'),
(9, 'Follow-up'),
(10, 'Vaccination'),
(11, 'Fever'),
(12, 'Cold & Flu'),
(13, 'Headache'),
(14, 'Stomach Pain'),
(15, 'Injury'),
(16, 'Diabetes'),
(17, 'Hypertension'),
(18, 'Check-up'),
(19, 'Follow-up'),
(20, 'Vaccination'),
(21, 'Fever'),
(22, 'Cold & Flu'),
(23, 'Headache'),
(24, 'Stomach Pain'),
(25, 'Injury'),
(26, 'Diabetes'),
(27, 'Hypertension'),
(28, 'Check-up'),
(29, 'Follow-up'),
(30, 'Vaccination'),
(31, 'Fever'),
(32, 'Cold & Flu'),
(33, 'Headache'),
(34, 'Stomach Pain'),
(35, 'Injury'),
(36, 'Diabetes'),
(37, 'Hypertension'),
(38, 'Check-up'),
(39, 'Follow-up'),
(40, 'Vaccination'),
(41, 'Fever'),
(42, 'Cold & Flu'),
(43, 'Headache'),
(44, 'Stomach Pain'),
(45, 'Injury'),
(46, 'Diabetes'),
(47, 'Hypertension'),
(48, 'Check-up'),
(49, 'Follow-up'),
(50, 'Vaccination'),
(51, 'Fever'),
(52, 'Cold & Flu'),
(53, 'Headache'),
(54, 'Stomach Pain'),
(55, 'Injury'),
(56, 'Diabetes'),
(57, 'Hypertension'),
(58, 'Check-up'),
(59, 'Follow-up'),
(60, 'Vaccination');

-- Table: tbl_cat_expenses
DROP TABLE IF EXISTS `tbl_cat_expenses`;
CREATE TABLE `tbl_cat_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_cat_expenses
INSERT INTO `tbl_cat_expenses` (`id`, `name`) VALUES
(1, 'Salary'),
(2, 'Utilities'),
(3, 'Rent'),
(4, 'Maintenance'),
(5, 'Office Supplies'),
(6, 'Transportation'),
(7, 'Salary'),
(8, 'Utilities'),
(9, 'Rent'),
(10, 'Maintenance'),
(11, 'Office Supplies'),
(12, 'Transportation'),
(13, 'Salary'),
(14, 'Utilities'),
(15, 'Rent'),
(16, 'Maintenance'),
(17, 'Office Supplies'),
(18, 'Transportation'),
(19, 'Salary'),
(20, 'Utilities'),
(21, 'Rent'),
(22, 'Maintenance'),
(23, 'Office Supplies'),
(24, 'Transportation'),
(25, 'Salary'),
(26, 'Utilities'),
(27, 'Rent'),
(28, 'Maintenance'),
(29, 'Office Supplies'),
(30, 'Transportation'),
(31, 'Salary'),
(32, 'Utilities'),
(33, 'Rent'),
(34, 'Maintenance'),
(35, 'Office Supplies'),
(36, 'Transportation');

-- Table: tbl_catalog
DROP TABLE IF EXISTS `tbl_catalog`;
CREATE TABLE `tbl_catalog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_catalog
INSERT INTO `tbl_catalog` (`id`, `name`) VALUES
(1, 'Tablets'),
(3, 'Syrup'),
(5, 'Medical Equipment'),
(7, 'Vitamins & Supplements'),
(12, 'Injection'),
(35, 'Antibiotics'),
(42, 'First Aid'),
(44, 'တရုတ်အစားအစာ');

-- Table: tbl_catalog_2
DROP TABLE IF EXISTS `tbl_catalog_2`;
CREATE TABLE `tbl_catalog_2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_clinical_indicators
DROP TABLE IF EXISTS `tbl_clinical_indicators`;
CREATE TABLE `tbl_clinical_indicators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `indicator_name` varchar(255) NOT NULL,
  `indicator_type` varchar(100) NOT NULL,
  `value` decimal(10,2) NOT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `target_value` decimal(10,2) DEFAULT NULL,
  `measurement_date` date NOT NULL,
  `department_id` int(11) DEFAULT NULL,
  `status` enum('Above_Target','At_Target','Below_Target','Critical') DEFAULT NULL,
  `trend` enum('Improving','Stable','Declining') DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_indicator_type` (`indicator_type`),
  KEY `idx_measurement_date` (`measurement_date`),
  KEY `idx_department` (`department_id`),
  CONSTRAINT `tbl_clinical_indicators_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_controlled_substance_log
DROP TABLE IF EXISTS `tbl_controlled_substance_log`;
CREATE TABLE `tbl_controlled_substance_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `drug_id` int(11) NOT NULL,
  `transaction_type` enum('Received','Dispensed','Wasted','Returned') NOT NULL,
  `quantity` decimal(10,2) NOT NULL,
  `balance` decimal(10,2) NOT NULL,
  `prescription_id` int(11) DEFAULT NULL,
  `patient_id` varchar(50) DEFAULT NULL,
  `performed_by` int(11) NOT NULL COMMENT 'User ID',
  `witnessed_by` int(11) DEFAULT NULL COMMENT 'Second user for verification',
  `transaction_date` datetime DEFAULT current_timestamp(),
  `reason` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_drug_id` (`drug_id`),
  KEY `idx_transaction_type` (`transaction_type`),
  KEY `idx_transaction_date` (`transaction_date`),
  KEY `idx_performed_by` (`performed_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_customer
DROP TABLE IF EXISTS `tbl_customer`;
CREATE TABLE `tbl_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `shop` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `remark` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_customer
INSERT INTO `tbl_customer` (`id`, `name`, `ph_no`, `nrc_no`, `shop`, `address`, `date`, `remark`) VALUES
(1, 'Aung Aung', '+95 9 123 456 789', '12/YKNXXX', 'regular', 'Yangon, Myanmar', '2025-10-12 00:00:00', 'aung@email.com'),
(2, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-12 00:00:00', 'VIP customer'),
(3, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-12 00:00:00', 'Good credit'),
(4, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-12 00:00:00', 'Monthly payment'),
(5, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-12 00:00:00', 'Wholesale buyer'),
(6, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-12 00:00:00', 'Retail customer'),
(7, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-12 00:00:00', 'Regional customer'),
(8, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-12 00:00:00', 'Cash only'),
(9, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-12 00:00:00', 'Credit customer'),
(10, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-12 00:00:00', 'New customer'),
(11, 'Aung Aung', '09-111111111', '12/YKNXXX', 'Aung Aung Pharmacy', 'Downtown, Yangon', '2025-10-12 00:00:00', 'Regular customer'),
(12, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-12 00:00:00', 'VIP customer'),
(13, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-12 00:00:00', 'Good credit'),
(14, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-12 00:00:00', 'Monthly payment'),
(15, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-12 00:00:00', 'Wholesale buyer'),
(16, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-12 00:00:00', 'Retail customer'),
(17, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-12 00:00:00', 'Regional customer'),
(18, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-12 00:00:00', 'Cash only'),
(19, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-12 00:00:00', 'Credit customer'),
(20, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-12 00:00:00', 'New customer'),
(21, 'Aung Aung', '09-111111111', '12/YKNXXX', 'Aung Aung Pharmacy', 'Downtown, Yangon', '2025-10-14 00:00:00', 'Regular customer'),
(22, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-14 00:00:00', 'VIP customer'),
(23, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-14 00:00:00', 'Good credit'),
(24, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-14 00:00:00', 'Monthly payment'),
(25, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-14 00:00:00', 'Wholesale buyer'),
(26, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-14 00:00:00', 'Retail customer'),
(27, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-14 00:00:00', 'Regional customer'),
(28, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-14 00:00:00', 'Cash only'),
(29, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-14 00:00:00', 'Credit customer'),
(30, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-14 00:00:00', 'New customer'),
(31, 'Aung Aung', '09-111111111', '12/YKNXXX', 'Aung Aung Pharmacy', 'Downtown, Yangon', '2025-10-16 00:00:00', 'Regular customer'),
(32, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-16 00:00:00', 'VIP customer'),
(33, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-16 00:00:00', 'Good credit'),
(34, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-16 00:00:00', 'Monthly payment'),
(35, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-16 00:00:00', 'Wholesale buyer'),
(36, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-16 00:00:00', 'Retail customer'),
(37, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-16 00:00:00', 'Regional customer'),
(38, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-16 00:00:00', 'Cash only'),
(39, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-16 00:00:00', 'Credit customer'),
(40, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-16 00:00:00', 'New customer'),
(41, 'Aung Aung', '09-111111111', '12/YKNXXX', 'Aung Aung Pharmacy', 'Downtown, Yangon', '2025-10-16 00:00:00', 'Regular customer'),
(42, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-16 00:00:00', 'VIP customer'),
(43, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-16 00:00:00', 'Good credit'),
(44, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-16 00:00:00', 'Monthly payment'),
(45, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-16 00:00:00', 'Wholesale buyer'),
(46, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-16 00:00:00', 'Retail customer'),
(47, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-16 00:00:00', 'Regional customer'),
(48, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-16 00:00:00', 'Cash only'),
(49, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-16 00:00:00', 'Credit customer'),
(50, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-16 00:00:00', 'New customer');

-- Table: tbl_customer_debt
DROP TABLE IF EXISTS `tbl_customer_debt`;
CREATE TABLE `tbl_customer_debt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_departments
DROP TABLE IF EXISTS `tbl_departments`;
CREATE TABLE `tbl_departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dept_code` varchar(20) NOT NULL,
  `dept_name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `head_of_department` int(11) DEFAULT NULL,
  `contact_number` varchar(20) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `bed_capacity` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `dept_code` (`dept_code`),
  KEY `idx_dept_code` (`dept_code`),
  KEY `idx_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_departments
INSERT INTO `tbl_departments` (`id`, `dept_code`, `dept_name`, `description`, `head_of_department`, `contact_number`, `location`, `bed_capacity`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'EMER', 'Emergency', 'Emergency Department', NULL, NULL, 'Ground Floor', 10, 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(2, 'ICU', 'Intensive Care Unit', 'Critical Care Unit', NULL, NULL, '3rd Floor', 20, 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(3, 'GMED', 'General Medicine', 'General Medical Ward', NULL, NULL, '1st Floor', 30, 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(4, 'SURG', 'Surgery', 'Surgical Department', NULL, NULL, '2nd Floor', 15, 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(5, 'PED', 'Pediatrics', 'Children\'s Department', NULL, NULL, '4th Floor', 25, 1, '2025-10-15 19:34:50', '2025-10-15 19:34:50');

-- Table: tbl_deposit_transaction
DROP TABLE IF EXISTS `tbl_deposit_transaction`;
CREATE TABLE `tbl_deposit_transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `transaction_type` enum('deposit','withdrawal','refund','adjustment') NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `balance_after` decimal(10,2) NOT NULL,
  `description` text DEFAULT NULL,
  `reference_no` varchar(50) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` enum('active','cancelled') DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_transaction_type` (`transaction_type`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_reference_no` (`reference_no`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `tbl_deposit_transaction_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `tbl_patient` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tbl_deposit_transaction_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `tbl_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table: tbl_deposit_transaction
INSERT INTO `tbl_deposit_transaction` (`id`, `patient_id`, `transaction_type`, `amount`, `balance_after`, `description`, `reference_no`, `created_by`, `created_at`, `updated_at`, `status`) VALUES
(1, 46, 'deposit', '5000.00', '5000.00', 'Test', 'test', 1, '2025-10-16 23:08:47', '2025-10-16 23:08:47', 'active'),
(2, 46, 'withdrawal', '3000.00', '2000.00', 'test', '', 1, '2025-10-16 23:09:07', '2025-10-16 23:09:07', 'active'),
(3, 46, 'deposit', '50000.00', '52000.00', '', '', 1, '2025-10-17 00:25:49', '2025-10-17 00:25:49', 'active'),
(4, 46, 'deposit', '500000.00', '552000.00', '', '', 1, '2025-10-17 19:11:03', '2025-10-17 19:11:03', 'active'),
(5, 46, 'deposit', '100000.00', '652000.00', '', '', 1, '2025-10-17 23:43:33', '2025-10-17 23:43:33', 'active');

-- Table: tbl_doctor
DROP TABLE IF EXISTS `tbl_doctor`;
CREATE TABLE `tbl_doctor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `education` varchar(250) DEFAULT NULL,
  `specialist` varchar(250) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL COMMENT 'Doctor photo path',
  `email` varchar(100) DEFAULT NULL COMMENT 'Doctor email',
  `address` text DEFAULT NULL COMMENT 'Doctor address',
  `license_number` varchar(50) DEFAULT NULL COMMENT 'Medical license number',
  `experience_years` int(11) DEFAULT NULL COMMENT 'Years of experience',
  `consultation_fee` decimal(10,2) DEFAULT 0.00 COMMENT 'Consultation fee',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'Active status',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_doctor_active` (`is_active`),
  KEY `idx_doctor_specialist` (`specialist`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_doctor
INSERT INTO `tbl_doctor` (`id`, `name`, `phone`, `education`, `specialist`, `remark`, `photo`, `email`, `address`, `license_number`, `experience_years`, `consultation_fee`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Dr. Aung Aung', '09-111111111', 'MBBS, MD', 'General Physician', 'Available Mon-Fri', '/uploads/481071456_617493164224193_316415243334250112_n-1760637387645-274742688.jpg', NULL, NULL, NULL, NULL, '0.00', 1, '2025-10-16 23:45:13', '2025-10-17 00:26:27'),
(3, 'Dr. Kyaw Kyaw', '09-333333333', 'MBBS, MS (Ortho)', 'Orthopedic Surgeon', 'Available on appointment', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-10-16 23:45:13', '2025-10-16 23:45:13'),
(11, 'Dr. Su Su', '09-222222222', 'MBBS, MD (Peds)', 'Pediatrician', 'Available Mon-Sat', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-10-16 23:45:13', '2025-10-16 23:45:13');

-- Table: tbl_drug_formulary
DROP TABLE IF EXISTS `tbl_drug_formulary`;
CREATE TABLE `tbl_drug_formulary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `drug_code` varchar(50) NOT NULL,
  `generic_name` varchar(255) NOT NULL,
  `brand_name` varchar(255) DEFAULT NULL,
  `drug_class` varchar(100) DEFAULT NULL COMMENT 'Antibiotic, Analgesic, etc.',
  `therapeutic_category` varchar(100) DEFAULT NULL,
  `form` varchar(50) DEFAULT NULL,
  `strength` varchar(50) DEFAULT NULL COMMENT 'e.g., 500mg, 10mg/ml',
  `route` varchar(50) DEFAULT NULL COMMENT 'Oral, IV, IM, etc.',
  `unit_of_measure` varchar(50) DEFAULT NULL,
  `formulary_status` enum('Preferred','Non-Preferred','Restricted','Non-Formulary') DEFAULT 'Non-Preferred',
  `contraindications` text DEFAULT NULL,
  `side_effects` text DEFAULT NULL,
  `storage_requirements` text DEFAULT NULL,
  `interactions` text DEFAULT NULL,
  `pregnancy_category` varchar(10) DEFAULT NULL,
  `manufacturer` varchar(255) DEFAULT NULL,
  `is_controlled_substance` tinyint(1) DEFAULT 0,
  `dea_schedule` varchar(10) DEFAULT NULL,
  `requires_authorization` tinyint(1) DEFAULT 0,
  `max_daily_dose` varchar(100) DEFAULT NULL,
  `typical_dosage` text DEFAULT NULL,
  `price` decimal(10,2) DEFAULT 0.00,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `drug_code` (`drug_code`),
  KEY `idx_drug_code` (`drug_code`),
  KEY `idx_generic_name` (`generic_name`),
  KEY `idx_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_drug_formulary
INSERT INTO `tbl_drug_formulary` (`id`, `drug_code`, `generic_name`, `brand_name`, `drug_class`, `therapeutic_category`, `form`, `strength`, `route`, `unit_of_measure`, `formulary_status`, `contraindications`, `side_effects`, `storage_requirements`, `interactions`, `pregnancy_category`, `manufacturer`, `is_controlled_substance`, `dea_schedule`, `requires_authorization`, `max_daily_dose`, `typical_dosage`, `price`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'A12312', '234234', '334', 'Antibiotic', NULL, 'Capsule', '33', 'IV', NULL, 'Preferred', '33', '33', NULL, NULL, NULL, NULL, 0, 'None', 0, NULL, '33', '0.00', 1, '2025-10-15 21:20:19', '2025-10-15 21:20:19');

-- Table: tbl_emergency_admissions
DROP TABLE IF EXISTS `tbl_emergency_admissions`;
CREATE TABLE `tbl_emergency_admissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `arrival_date` datetime NOT NULL DEFAULT current_timestamp(),
  `triage_level` enum('Level_1','Level_2','Level_3','Level_4','Level_5') NOT NULL COMMENT '1=Critical, 5=Non-urgent',
  `chief_complaint` text NOT NULL,
  `vital_signs` text DEFAULT NULL COMMENT 'JSON of vital signs',
  `assigned_doctor_id` int(11) DEFAULT NULL,
  `bed_assigned` varchar(20) DEFAULT NULL,
  `disposition` enum('Admitted','Discharged','Transferred','Expired') DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_diagnosis` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_arrival_date` (`arrival_date`),
  KEY `idx_triage_level` (`triage_level`),
  KEY `idx_disposition` (`disposition`),
  KEY `assigned_doctor_id` (`assigned_doctor_id`),
  CONSTRAINT `tbl_emergency_admissions_ibfk_1` FOREIGN KEY (`assigned_doctor_id`) REFERENCES `tbl_doctor` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_expenses
DROP TABLE IF EXISTS `tbl_expenses`;
CREATE TABLE `tbl_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_exp_id` varchar(50) NOT NULL,
  `amount` double NOT NULL,
  `user_name` varchar(50) NOT NULL,
  `reason` varchar(50) NOT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date NOT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_form
DROP TABLE IF EXISTS `tbl_form`;
CREATE TABLE `tbl_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` varchar(50) NOT NULL,
  `sale` varchar(50) NOT NULL,
  `buy` varchar(50) NOT NULL,
  `product` varchar(50) NOT NULL,
  `change_item_price` varchar(50) NOT NULL,
  `cashier` varchar(50) NOT NULL,
  `login_user` varchar(50) NOT NULL,
  `customer` varchar(50) NOT NULL,
  `supplier` varchar(50) NOT NULL,
  `barcode` varchar(50) NOT NULL,
  `expenses` varchar(50) NOT NULL,
  `report` varchar(50) NOT NULL,
  `setting` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_images
DROP TABLE IF EXISTS `tbl_images`;
CREATE TABLE `tbl_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) DEFAULT NULL,
  `treatment_id` int(11) DEFAULT NULL,
  `image` longblob DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `upload_date` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_images
INSERT INTO `tbl_images` (`id`, `patient_id`, `treatment_id`, `image`, `image_path`, `upload_date`) VALUES
(1, 'OPD-003', 130, NULL, '/uploads/medical/medical-1760704937929-321455294.png', '2025-10-17 19:12:18'),
(2, 'OPD-003', 130, NULL, '/uploads/medical/medical-1760704938060-712760180.jpg', '2025-10-17 19:12:18'),
(3, 'OPD-003', 130, NULL, '/uploads/medical/medical-1760704938062-888192776.png', '2025-10-17 19:12:18'),
(4, 'OPD-003', 130, NULL, '/uploads/medical/medical-1760704938063-143953615.jpg', '2025-10-17 19:12:18'),
(5, 'OPD-003', 130, NULL, '/uploads/medical/medical-1760704938063-471085518.jpg', '2025-10-17 19:12:18'),
(6, 'OPD-003', 130, NULL, '/uploads/medical/medical-1760704938063-525432212.png', '2025-10-17 19:12:18'),
(7, 'P000074', 238, NULL, '/uploads/medical/medical-1761191207436-348461605.png', '2025-10-23 10:16:47'),
(8, 'P000074', 238, NULL, '/uploads/medical/medical-1761191207476-577828786.jpg', '2025-10-23 10:16:47'),
(9, 'P000074', 238, NULL, '/uploads/medical/medical-1761191207488-100793698.jpg', '2025-10-23 10:16:47'),
(10, 'P000074', 238, NULL, '/uploads/medical/medical-1761191207505-429846989.jpg', '2025-10-23 10:16:47'),
(11, 'P000074', 238, NULL, '/uploads/medical/medical-1761191207513-277559899.jpg', '2025-10-23 10:16:47'),
(12, 'P000074', 238, NULL, '/uploads/medical/medical-1761191207543-248401891.jpg', '2025-10-23 10:16:47');

-- Table: tbl_incident_reports
DROP TABLE IF EXISTS `tbl_incident_reports`;
CREATE TABLE `tbl_incident_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `incident_number` varchar(50) NOT NULL,
  `incident_date` datetime NOT NULL,
  `incident_type` varchar(100) NOT NULL COMMENT 'Patient Safety, Equipment, Staff, etc.',
  `severity` enum('Low','Medium','High','Critical') NOT NULL,
  `location` varchar(255) NOT NULL,
  `department_id` int(11) DEFAULT NULL,
  `patient_involved` tinyint(1) DEFAULT 0,
  `patient_id` varchar(50) DEFAULT NULL,
  `staff_involved` text DEFAULT NULL COMMENT 'JSON array of staff IDs',
  `description` text NOT NULL,
  `immediate_action` text DEFAULT NULL,
  `investigation_required` tinyint(1) DEFAULT 0,
  `investigation_findings` text DEFAULT NULL,
  `corrective_actions` text DEFAULT NULL,
  `preventive_measures` text DEFAULT NULL,
  `status` enum('Open','Under_Investigation','Closed','Referred') DEFAULT 'Open',
  `reported_by` int(11) NOT NULL,
  `investigation_status` enum('Pending','In_Progress','Completed','Closed') DEFAULT 'Pending',
  `assigned_to` int(11) DEFAULT NULL,
  `target_completion` date DEFAULT NULL,
  `actual_completion` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `resolved_date` datetime DEFAULT NULL,
  `resolution_notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `incident_number` (`incident_number`),
  KEY `idx_incident_number` (`incident_number`),
  KEY `idx_incident_date` (`incident_date`),
  KEY `idx_incident_type` (`incident_type`),
  KEY `idx_severity` (`severity`),
  KEY `idx_status` (`status`),
  KEY `idx_department` (`department_id`),
  CONSTRAINT `tbl_incident_reports_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_incident_reports
INSERT INTO `tbl_incident_reports` (`id`, `incident_number`, `incident_date`, `incident_type`, `severity`, `location`, `department_id`, `patient_involved`, `patient_id`, `staff_involved`, `description`, `immediate_action`, `investigation_required`, `investigation_findings`, `corrective_actions`, `preventive_measures`, `status`, `reported_by`, `investigation_status`, `assigned_to`, `target_completion`, `actual_completion`, `created_at`, `updated_at`, `resolved_date`, `resolution_notes`) VALUES
(1, 'INC2025000004', '2025-10-15 20:01:00', 'Fall', '', 'အမှတ်(၁၀)၊ ၄ လွှာ၊ ဝေဠုဝန်လမ်းကျယ်၊ စမ်းချောင်း', NULL, 0, '1231', NULL, 'as', 'ss', 0, NULL, NULL, NULL, 'Open', 1, 'Pending', NULL, NULL, NULL, '2025-10-15 20:22:55', '2025-10-15 20:22:55', NULL, NULL),
(2, 'INC2025000005', '2025-10-15 20:01:00', 'Fall', '', 'အမှတ်(၁၀)၊ ၄ လွှာ၊ ဝေဠုဝန်လမ်းကျယ်၊ စမ်းချောင်း', NULL, 0, '1231', NULL, 'as', 'ss', 0, NULL, NULL, NULL, 'Open', 1, 'Pending', NULL, NULL, NULL, '2025-10-15 20:23:27', '2025-10-15 20:23:27', NULL, NULL),
(3, 'INC2025000006', '2025-10-15 20:01:00', 'Fall', '', 'အမှတ်(၁၀)၊ ၄ လွှာ၊ ဝေဠုဝန်လမ်းကျယ်၊ စမ်းချောင်း', NULL, 0, '1231', NULL, 'as', 'ss', 0, NULL, NULL, NULL, 'Open', 1, 'Pending', NULL, NULL, NULL, '2025-10-15 20:23:39', '2025-10-15 20:23:39', NULL, NULL);

-- Table: tbl_incident_sequence
DROP TABLE IF EXISTS `tbl_incident_sequence`;
CREATE TABLE `tbl_incident_sequence` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_incident_number` int(11) DEFAULT 0,
  `year` int(11) DEFAULT year(curdate()),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_incident_sequence
INSERT INTO `tbl_incident_sequence` (`id`, `last_incident_number`, `year`) VALUES
(1, 6, 2025),
(2, 6, 2025),
(3, 0, 2025);

-- Table: tbl_infection_surveillance
DROP TABLE IF EXISTS `tbl_infection_surveillance`;
CREATE TABLE `tbl_infection_surveillance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `infection_type` varchar(100) NOT NULL COMMENT 'HAI, SSI, UTI, CLABSI, etc.',
  `infection_site` varchar(100) DEFAULT NULL,
  `onset_date` date NOT NULL,
  `detected_date` datetime DEFAULT NULL,
  `days_since_admission` int(11) DEFAULT NULL,
  `risk_factors` text DEFAULT NULL,
  `causative_organism` varchar(255) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `associated_procedure` varchar(255) DEFAULT NULL,
  `device_related` tinyint(1) DEFAULT 0,
  `device_type` varchar(100) DEFAULT NULL,
  `reported_by` int(11) NOT NULL,
  `status` enum('Active','Resolved','Under_Treatment') DEFAULT 'Active',
  `resolution_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `preventable` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_infection_type` (`infection_type`),
  KEY `idx_onset_date` (`onset_date`),
  KEY `idx_department` (`department_id`),
  CONSTRAINT `tbl_infection_surveillance_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_infection_surveillance
INSERT INTO `tbl_infection_surveillance` (`id`, `patient_id`, `infection_type`, `infection_site`, `onset_date`, `detected_date`, `days_since_admission`, `risk_factors`, `causative_organism`, `department_id`, `associated_procedure`, `device_related`, `device_type`, `reported_by`, `status`, `resolution_date`, `created_at`, `preventable`) VALUES
(1, '123123', 'UTI', NULL, '2025-10-15 00:00:00', '2025-10-15 00:00:00', 123, 'asas', NULL, NULL, NULL, 1, NULL, 1, 'Active', NULL, '2025-10-15 20:27:40', 0);

-- Table: tbl_inpatient
DROP TABLE IF EXISTS `tbl_inpatient`;
CREATE TABLE `tbl_inpatient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `case_` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `dr_name` varchar(250) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  `room_no` varchar(250) DEFAULT NULL,
  `deposit` int(11) DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `bed_id` int(11) DEFAULT NULL COMMENT 'Reference to tbl_beds.id',
  `bed_number` varchar(20) DEFAULT NULL COMMENT 'Bed number from bed assignment',
  `bed_type` varchar(50) DEFAULT NULL COMMENT 'Type of bed (General, ICU, Private, etc.)',
  `daily_rate` decimal(10,2) DEFAULT 0.00 COMMENT 'Daily rate for bed',
  `dr_id` int(11) DEFAULT NULL COMMENT 'Reference to tbl_doctor.id',
  `final_bill` decimal(10,2) DEFAULT NULL COMMENT 'Final bill amount on discharge',
  `discharge_notes` text DEFAULT NULL COMMENT 'Notes on discharge',
  `discharge_date` date DEFAULT NULL COMMENT 'Date of discharge',
  PRIMARY KEY (`id`),
  KEY `idx_inpatient_bed_id` (`bed_id`),
  KEY `idx_inpatient_dr_id` (`dr_id`),
  KEY `idx_inpatient_end_date` (`end_date`),
  CONSTRAINT `fk_inpatient_bed` FOREIGN KEY (`bed_id`) REFERENCES `tbl_beds` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_inpatient_doctor` FOREIGN KEY (`dr_id`) REFERENCES `tbl_doctor` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_inpatient
INSERT INTO `tbl_inpatient` (`id`, `name`, `age`, `phone`, `address`, `case_`, `remark`, `start_date`, `dr_name`, `patient_id`, `room_no`, `deposit`, `end_date`, `bed_id`, `bed_number`, `bed_type`, `daily_rate`, `dr_id`, `final_bill`, `discharge_notes`, `discharge_date`) VALUES
(1, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-09 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, '2025-10-13 00:00:00', NULL, NULL, 'General', '0.00', NULL, '5756.00', NULL, '2025-10-10 00:00:00'),
(2, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-07 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(3, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, '2025-10-13 00:00:00', NULL, NULL, 'General', '0.00', NULL, '5906.00', NULL, '2025-10-12 00:00:00'),
(4, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 1000000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(5, 'U Kyaw Soe', '62', '09-565656565', 'Hlaing, Yangon', 'Stroke', 'Stable condition, physiotherapy started', '2025-10-05 00:00:00', 'Dr. Aung Aung', 'IPD-005', 'R-104', 1500000, '2025-10-07 00:00:00', NULL, NULL, 'General', '0.00', NULL, '5970.00', NULL, '2025-10-06 00:00:00'),
(6, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(7, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-08 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, '2025-10-10 00:00:00', NULL, NULL, 'General', '0.00', NULL, '1457.00', NULL, '2025-10-11 00:00:00'),
(8, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, '2025-10-17 00:00:00', NULL, NULL, 'General', '0.00', NULL, '1151.00', NULL, '2025-10-19 00:00:00'),
(10, 'Daw Yin', '43', '09-101010101', 'Insein, Yangon', 'Gallbladder Surgery', 'Post-op day 3', '2025-10-09 00:00:00', 'Dr. Myo Myo', 'IPD-010', 'R-203', 900000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(11, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-09 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, '2025-10-14 00:00:00', NULL, NULL, 'General', '0.00', NULL, '2886.00', NULL, '2025-10-10 00:00:00'),
(12, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-07 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(13, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, '2025-10-12 00:00:00', NULL, NULL, 'General', '0.00', NULL, '3912.00', NULL, '2025-10-12 00:00:00'),
(14, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 1000000, '2025-10-14 00:00:00', NULL, NULL, 'General', '0.00', NULL, '5787.00', NULL, '2025-10-16 00:00:00'),
(16, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, '2025-10-13 00:00:00', NULL, NULL, 'General', '0.00', NULL, '4545.00', NULL, '2025-10-18 00:00:00'),
(17, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-08 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, '2025-10-15 00:00:00', NULL, NULL, 'General', '0.00', NULL, '1671.00', NULL, '2025-10-14 00:00:00'),
(18, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(19, 'U Win Htun', '55', '09-909090909', 'Botataung, Yangon', 'Gastric Ulcer', 'Medical management', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-009', 'R-107', 450000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(21, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-11 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(22, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-09 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, '2025-10-10 00:00:00', NULL, NULL, 'General', '0.00', NULL, '4874.00', NULL, '2025-10-14 00:00:00'),
(23, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(24, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 1000000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(25, 'U Kyaw Soe', '62', '09-565656565', 'Hlaing, Yangon', 'Stroke', 'Stable condition, physiotherapy started', '2025-10-07 00:00:00', 'Dr. Aung Aung', 'IPD-005', 'R-104', 1500000, '2025-10-14 00:00:00', NULL, NULL, 'General', '0.00', NULL, '5002.00', NULL, '2025-10-11 00:00:00'),
(26, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, '2025-10-16 00:00:00', NULL, NULL, 'General', '0.00', NULL, '5448.00', NULL, '2025-10-15 00:00:00'),
(27, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(28, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(29, 'U Win Htun', '55', '09-909090909', 'Botataung, Yangon', 'Gastric Ulcer', 'Medical management', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-009', 'R-107', 450000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(30, 'Daw Yin', '43', '09-101010101', 'Insein, Yangon', 'Gallbladder Surgery', 'Post-op day 3', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-010', 'R-203', 900000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(31, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(32, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(33, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, '2025-10-18 00:00:00', NULL, NULL, 'General', '0.00', NULL, '5478.00', NULL, '2025-10-20 00:00:00'),
(34, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-15 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 50000, '2025-10-22 00:00:00', NULL, NULL, 'General', '0.00', NULL, '3762.00', NULL, '2025-10-16 00:00:00'),
(35, 'U Kyaw Soe', '62', '09-565656565', 'Hlaing, Yangon', 'Stroke', 'Stable condition, physiotherapy started', '2025-10-09 00:00:00', 'Dr. Aung Aung', 'IPD-005', 'R-104', 1500000, '2025-10-16 00:00:00', NULL, NULL, 'General', '0.00', NULL, '1227.00', NULL, '2025-10-16 00:00:00'),
(36, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-15 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(37, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(38, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment | Discharged: Discharged', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, '2025-10-17 00:00:00', NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(39, 'U Win Htun', '55', '09-909090909', 'Botataung, Yangon', 'Gastric Ulcer', 'Medical management', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'IPD-009', 'R-107', 450000, '2025-10-17 00:00:00', NULL, NULL, 'General', '0.00', NULL, '3254.00', NULL, '2025-10-18 00:00:00'),
(40, 'Daw Yin', '43', '09-101010101', 'Insein, Yangon', 'Gallbladder Surgery', 'Post-op day 3', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-010', 'R-203', 900000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(41, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-13 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, '2025-10-19 00:00:00', NULL, NULL, 'General', '0.00', NULL, '3469.00', NULL, '2025-10-20 00:00:00'),
(42, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, '2025-10-15 00:00:00', NULL, NULL, 'General', '0.00', NULL, '2615.00', NULL, '2025-10-18 00:00:00'),
(43, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, '2025-10-20 00:00:00', NULL, NULL, 'General', '0.00', NULL, '3592.00', NULL, '2025-10-20 00:00:00'),
(44, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-15 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 50000, '2025-10-22 00:00:00', NULL, NULL, 'General', '0.00', NULL, '0.00', NULL, NULL),
(45, 'U Kyaw Soe', '62', '09-565656565', 'Hlaing, Yangon', 'Stroke', 'Stable condition, physiotherapy started', '2025-10-09 00:00:00', 'Dr. Aung Aung', 'IPD-005', 'R-104', 1500000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(46, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-15 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, '2025-10-23 00:00:00', NULL, NULL, 'General', '0.00', NULL, '0.00', NULL, NULL),
(47, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(48, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment | Discharged: Discharged', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, '2025-10-17 00:00:00', NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(49, 'U Win Htun', '55', '09-909090909', 'Botataung, Yangon', 'Gastric Ulcer', 'Medical management', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'IPD-009', 'R-107', 450000, '2025-10-22 00:00:00', NULL, NULL, 'General', '0.00', NULL, '0.00', NULL, NULL),
(50, 'Daw Yin', '43', '09-101010101', 'Insein, Yangon', 'Gallbladder Surgery', 'Post-op day 3', '2025-10-13 00:00:00', 'Dr. Myo Myo', 'IPD-010', 'R-203', 900000, NULL, NULL, NULL, 'General', '0.00', NULL, NULL, NULL, NULL),
(51, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', NULL, ' | Discharged: Discharged', '2025-10-17 00:00:00', NULL, 'IP000048', 'ICU-102', 200000, '2025-10-17 00:00:00', 5, 'ICU002', 'ICU', '500.00', NULL, NULL, NULL, NULL),
(52, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', NULL, ' | Discharged: Discharged', '2025-10-17 00:00:00', NULL, 'IP000049', 'ER-2', 30000, '2025-10-17 00:00:00', NULL, 'ER002 11', 'General', '100.00', NULL, NULL, NULL, NULL),
(53, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', NULL, ' | Discharged: Discharged', '2025-10-17 00:00:00', NULL, 'IP000050', 'ER-3', 30000, '2025-10-17 00:00:00', 3, 'ER003', 'General', '100.00', 3, NULL, NULL, NULL),
(54, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', NULL, NULL, '2025-10-17 00:00:00', NULL, 'IP000051', 'ICU-101', 100000, NULL, 4, 'ICU001', 'ICU', '500.00', NULL, NULL, NULL, NULL),
(55, 'Ko Moe Tain', '25', '092514114', 'Yangon', NULL, NULL, '2025-10-23 00:00:00', NULL, 'IP000052', 'ICU-102', 60000, NULL, 5, 'ICU002', 'ICU', '500.00', 1, NULL, NULL, NULL),
(56, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', NULL, NULL, '2025-10-24 00:00:00', NULL, 'IP000053', 'GM-201', 50000, NULL, 7, 'GM001', 'General', '200.00', 3, NULL, NULL, NULL),
(57, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', NULL, NULL, '2025-10-24 00:00:00', NULL, 'IP000054', 'PED-401', 500000, NULL, 12, 'PED001', 'General', '180.00', 1, NULL, NULL, NULL);

-- Table: tbl_inpatient_deposits
DROP TABLE IF EXISTS `tbl_inpatient_deposits`;
CREATE TABLE `tbl_inpatient_deposits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inpatient_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_method` enum('cash','card','bank_transfer','check','other') NOT NULL DEFAULT 'cash',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_inpatient_id` (`inpatient_id`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `fk_deposits_inpatient` FOREIGN KEY (`inpatient_id`) REFERENCES `tbl_inpatient` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_inpatient_deposits
INSERT INTO `tbl_inpatient_deposits` (`id`, `inpatient_id`, `amount`, `payment_method`, `notes`, `created_at`, `created_by`) VALUES
(1, 34, '50000.00', 'cash', NULL, '2025-10-22 13:12:14', NULL),
(2, 54, '100000.00', 'cash', NULL, '2025-10-22 13:15:47', NULL),
(3, 34, '50000.00', 'bank_transfer', NULL, '2025-10-22 14:19:30', NULL),
(4, 44, '50000.00', 'cash', NULL, '2025-10-22 15:04:30', NULL),
(5, 46, '132.00', 'cash', 'Final payment on discharge', '2025-10-23 09:11:07', NULL),
(6, 55, '60000.00', 'cash', '', '2025-10-23 10:14:48', 1);

-- Table: tbl_inpatient_discharge
DROP TABLE IF EXISTS `tbl_inpatient_discharge`;
CREATE TABLE `tbl_inpatient_discharge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inpatient_id` int(11) NOT NULL,
  `discharge_date` date NOT NULL,
  `total_usage` decimal(10,2) NOT NULL DEFAULT 0.00,
  `bed_charges` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total_charges` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total_deposits` decimal(10,2) NOT NULL DEFAULT 0.00,
  `outstanding_balance` decimal(10,2) NOT NULL DEFAULT 0.00,
  `final_payment` decimal(10,2) NOT NULL DEFAULT 0.00,
  `payment_method` enum('cash','card','bank_transfer','check','other') DEFAULT NULL,
  `discharge_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_inpatient_discharge` (`inpatient_id`),
  KEY `idx_discharge_date` (`discharge_date`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `fk_discharge_inpatient` FOREIGN KEY (`inpatient_id`) REFERENCES `tbl_inpatient` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_inpatient_sale
DROP TABLE IF EXISTS `tbl_inpatient_sale`;
CREATE TABLE `tbl_inpatient_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_inpatient_saledebit
DROP TABLE IF EXISTS `tbl_inpatient_saledebit`;
CREATE TABLE `tbl_inpatient_saledebit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(250) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_inpatient_usage
DROP TABLE IF EXISTS `tbl_inpatient_usage`;
CREATE TABLE `tbl_inpatient_usage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inpatient_id` int(11) NOT NULL,
  `item_type` enum('product','service') NOT NULL DEFAULT 'product',
  `item_id` int(11) NOT NULL,
  `quantity` decimal(10,2) NOT NULL DEFAULT 1.00,
  `price` decimal(10,2) NOT NULL,
  `notes` text DEFAULT NULL,
  `usage_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_inpatient_id` (`inpatient_id`),
  KEY `idx_usage_date` (`usage_date`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_item_type` (`item_type`),
  CONSTRAINT `fk_usage_inpatient` FOREIGN KEY (`inpatient_id`) REFERENCES `tbl_inpatient` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_inpatient_usage
INSERT INTO `tbl_inpatient_usage` (`id`, `inpatient_id`, `item_type`, `item_id`, `quantity`, `price`, `notes`, `usage_date`, `created_at`, `created_by`) VALUES
(1, 34, 'product', 2, '1.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:12:22', NULL),
(2, 34, 'product', 5, '1.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:12:22', NULL),
(3, 34, 'product', 8, '1.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:12:22', NULL),
(4, 34, 'product', 13, '1.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:12:22', NULL),
(5, 34, 'product', 18, '1.00', '100.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:12:22', NULL),
(6, 54, 'product', 16, '1.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:15:56', NULL),
(7, 54, 'product', 13, '1.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:15:56', NULL),
(8, 54, 'product', 2, '2.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:15:57', NULL),
(9, 54, 'product', 2, '2.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:21:58', NULL),
(10, 54, 'product', 5, '2.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:21:58', NULL),
(11, 54, 'product', 8, '1.00', '33.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:21:58', NULL),
(12, 54, 'product', 4, '1.00', '100.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:21:58', NULL),
(13, 54, 'product', 11, '2.00', '6000.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:21:58', NULL),
(14, 54, 'product', 18, '4.00', '100.00', NULL, '2025-10-22 00:00:00', '2025-10-22 13:21:58', NULL),
(15, 54, 'product', 2, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 14:39:06', NULL),
(16, 54, 'product', 5, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 14:39:06', NULL),
(17, 54, 'product', 13, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 14:39:06', NULL),
(18, 54, 'product', 19, '2.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 14:39:06', NULL),
(19, 44, 'product', 5, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:04:41', NULL),
(20, 44, 'product', 8, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:04:41', NULL),
(21, 44, 'product', 13, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:04:41', NULL),
(22, 44, 'product', 2, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:04:41', NULL),
(23, 36, 'product', 2, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:23:25', NULL),
(24, 36, 'product', 5, '2.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:23:25', NULL),
(25, 36, 'product', 13, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:23:25', NULL),
(26, 36, 'product', 6, '1.00', '200.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:27:00', NULL),
(27, 36, 'product', 3, '1.00', '200.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:27:00', NULL),
(28, 36, 'product', 15, '1.00', '100.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:27:00', NULL),
(29, 36, 'product', 19, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:27:00', NULL),
(30, 36, 'product', 13, '1.00', '33.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:27:00', NULL),
(31, 36, 'product', 4, '1.00', '100.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:27:00', NULL),
(32, 36, 'product', 7, '1.00', '100.00', 'Processed from cart', '2025-10-22 00:00:00', '2025-10-22 15:27:00', NULL),
(33, 46, 'product', 2, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 09:10:58', NULL),
(34, 46, 'product', 5, '3.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 09:10:58', NULL),
(35, 55, 'product', 2, '2.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:15:22', NULL),
(36, 55, 'product', 5, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:15:22', NULL),
(37, 55, 'product', 8, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:15:22', NULL),
(38, 55, 'product', 13, '2.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:15:22', NULL),
(39, 55, 'product', 16, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:15:22', NULL),
(40, 55, 'product', 5, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:15:29', NULL),
(41, 55, 'product', 13, '2.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:15:29', NULL),
(42, 55, 'product', 16, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:15:29', NULL),
(43, 55, 'product', 5, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:43:35', NULL),
(44, 55, 'product', 2, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:43:35', NULL),
(45, 55, 'product', 19, '1.00', '33.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:43:35', NULL),
(46, 55, 'product', 6, '2.00', '200.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:43:35', NULL),
(47, 55, 'product', 3, '1.00', '200.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:43:35', NULL),
(48, 55, 'product', 18, '1.00', '100.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:43:35', NULL),
(49, 55, 'product', 15, '1.00', '100.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:43:35', NULL),
(50, 55, 'product', 12, '1.00', '100.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:43:35', NULL),
(52, 55, 'service', 86, '1.00', '25000.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:51:36', NULL),
(53, 55, 'service', 28, '1.00', '25000.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:51:36', NULL),
(54, 55, 'service', 143, '1.00', '25000.00', 'Processed from cart', '2025-10-23 00:00:00', '2025-10-23 10:51:36', NULL);

-- Table: tbl_lab_critical_alerts
DROP TABLE IF EXISTS `tbl_lab_critical_alerts`;
CREATE TABLE `tbl_lab_critical_alerts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `result_id` int(11) DEFAULT NULL,
  `lab_result_id` int(11) NOT NULL,
  `patient_id` varchar(50) NOT NULL,
  `test_name` varchar(255) NOT NULL,
  `result_value` text NOT NULL,
  `critical_value` text DEFAULT NULL,
  `critical_threshold` varchar(100) DEFAULT NULL,
  `alert_date` datetime DEFAULT current_timestamp(),
  `notified_to` int(11) DEFAULT NULL COMMENT 'Doctor/Staff ID',
  `notification_sent` tinyint(1) DEFAULT 0,
  `acknowledgment_date` datetime DEFAULT NULL,
  `acknowledged_by` int(11) DEFAULT NULL,
  `status` enum('Pending','Acknowledged','Resolved') DEFAULT 'Pending',
  `action_taken` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_status` (`status`),
  KEY `idx_alert_date` (`alert_date`),
  KEY `idx_lab_result` (`lab_result_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_lab_order_details
DROP TABLE IF EXISTS `tbl_lab_order_details`;
CREATE TABLE `tbl_lab_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `test_code` varchar(50) DEFAULT NULL,
  `test_name` varchar(255) NOT NULL,
  `specimen_id` varchar(50) DEFAULT NULL,
  `sample_collected` tinyint(1) DEFAULT 0,
  `collection_date` datetime DEFAULT NULL,
  `collected_by` int(11) DEFAULT NULL,
  `status` enum('Pending','Collected','In_Progress','Processing','Completed','Cancelled') DEFAULT 'Pending',
  `price` decimal(10,2) DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order` (`order_id`),
  KEY `idx_test` (`test_id`),
  CONSTRAINT `tbl_lab_order_details_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `tbl_lab_orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tbl_lab_order_details_ibfk_2` FOREIGN KEY (`test_id`) REFERENCES `tbl_lab_test_catalog` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_lab_order_details
INSERT INTO `tbl_lab_order_details` (`id`, `order_id`, `test_id`, `test_code`, `test_name`, `specimen_id`, `sample_collected`, `collection_date`, `collected_by`, `status`, `price`, `created_at`) VALUES
(2, 2, 24, 'HEP001', 'Hepatitis B Surface Antigen', NULL, 0, NULL, NULL, 'Pending', '25.00', '2025-10-15 21:55:47'),
(3, 2, 18, 'URINE001', 'Urine Culture', NULL, 0, NULL, NULL, 'Pending', '25.00', '2025-10-15 21:55:47'),
(4, 3, 6, 'HBA1C001', 'Hemoglobin A1C', NULL, 0, NULL, NULL, 'Pending', '25.00', '2025-10-15 22:12:23');

-- Table: tbl_lab_orders
DROP TABLE IF EXISTS `tbl_lab_orders`;
CREATE TABLE `tbl_lab_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(50) NOT NULL,
  `patient_id` varchar(50) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `order_date` datetime NOT NULL DEFAULT current_timestamp(),
  `collection_date` datetime DEFAULT NULL,
  `collected_by` int(11) DEFAULT NULL,
  `priority` enum('Routine','Urgent','STAT') DEFAULT 'Routine',
  `clinical_notes` text DEFAULT NULL,
  `clinical_info` text DEFAULT NULL,
  `total_amount` decimal(10,2) DEFAULT 0.00,
  `status` enum('Ordered','Pending','Collected','Specimen_Collected','In_Progress','Processing','Completed','Cancelled') DEFAULT 'Ordered',
  `ordered_by` int(11) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_number` (`order_number`),
  KEY `idx_order_number` (`order_number`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_lab_orders
INSERT INTO `tbl_lab_orders` (`id`, `order_number`, `patient_id`, `doctor_id`, `order_date`, `collection_date`, `collected_by`, `priority`, `clinical_notes`, `clinical_info`, `total_amount`, `status`, `ordered_by`, `created_by`, `created_at`, `updated_at`) VALUES
(2, 'LAB2025000002', 'aaa', 1, '2025-10-15 21:55:47', NULL, NULL, 'STAT', NULL, 'sss', '50.00', 'Ordered', 0, 1, '2025-10-15 21:55:47', '2025-10-15 21:55:47'),
(3, 'LAB2025000003', 'OPD-002', 1, '2025-10-15 22:12:23', NULL, NULL, 'STAT', NULL, 'ree', '25.00', 'Ordered', 0, 1, '2025-10-15 22:12:23', '2025-10-15 22:12:23');

-- Table: tbl_lab_report
DROP TABLE IF EXISTS `tbl_lab_report`;
CREATE TABLE `tbl_lab_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_no` varchar(50) DEFAULT NULL,
  `patient_id` varchar(50) NOT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `report_type` varchar(100) DEFAULT NULL,
  `collected_at` datetime DEFAULT NULL,
  `reported_at` datetime DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_lab_patient` (`patient_id`),
  KEY `idx_lab_doctor` (`doctor_id`),
  KEY `idx_lab_report_no` (`report_no`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_lab_report
INSERT INTO `tbl_lab_report` (`id`, `report_no`, `patient_id`, `doctor_id`, `report_type`, `collected_at`, `reported_at`, `notes`, `created_at`) VALUES
(1, 'A123123', 'OPD-002', 7, 'CBC', '2025-11-11 14:05:00', '5201-02-02 14:22:00', NULL, '2025-10-17 23:08:04'),
(2, 'A-12333', 'OPD-002', 1, 'CBC', '2025-10-22 14:22:00', '2025-10-22 11:11:00', NULL, '2025-10-22 12:39:32');

-- Table: tbl_lab_report_item
DROP TABLE IF EXISTS `tbl_lab_report_item`;
CREATE TABLE `tbl_lab_report_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `test_name` varchar(150) NOT NULL,
  `result_value` varchar(100) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `reference_range` varchar(100) DEFAULT NULL,
  `flag` varchar(10) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_lab_report_item_report` (`report_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_lab_report_item
INSERT INTO `tbl_lab_report_item` (`id`, `report_id`, `test_name`, `result_value`, `unit`, `reference_range`, `flag`, `remark`) VALUES
(1, 1, 'Hemoglobin', NULL, 'g/dL', '12 - 16', NULL, NULL),
(2, 1, 'WBC', NULL, '/mm³', '4,000 - 11,000', NULL, NULL),
(3, 2, 'CAAAA', '120', '23/mm³', '4,000 - 11,000', NULL, 'test');

-- Table: tbl_lab_results
DROP TABLE IF EXISTS `tbl_lab_results`;
CREATE TABLE `tbl_lab_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_detail_id` int(11) NOT NULL,
  `order_id` int(11) DEFAULT NULL,
  `patient_id` varchar(50) DEFAULT NULL,
  `test_id` int(11) DEFAULT NULL,
  `result_value` text DEFAULT NULL,
  `result_numeric` decimal(15,4) DEFAULT NULL,
  `result_text` text DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `normal_range` varchar(255) DEFAULT NULL,
  `reference_range` varchar(255) DEFAULT NULL,
  `flag` enum('Normal','High','Low','Critical','Abnormal') DEFAULT 'Normal',
  `comments` text DEFAULT NULL,
  `result_date` datetime NOT NULL DEFAULT current_timestamp(),
  `verified_by` int(11) DEFAULT NULL,
  `verified_date` datetime DEFAULT NULL,
  `is_critical` tinyint(1) DEFAULT 0,
  `performed_by` int(11) DEFAULT NULL,
  `performed_date` datetime DEFAULT NULL,
  `status` enum('Preliminary','Final','Corrected','Cancelled') DEFAULT 'Preliminary',
  `notes` text DEFAULT NULL,
  `critical_notified` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order_detail` (`order_detail_id`),
  KEY `idx_critical` (`is_critical`),
  CONSTRAINT `tbl_lab_results_ibfk_1` FOREIGN KEY (`order_detail_id`) REFERENCES `tbl_lab_order_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_lab_sequence
DROP TABLE IF EXISTS `tbl_lab_sequence`;
CREATE TABLE `tbl_lab_sequence` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_order_number` int(11) DEFAULT 0,
  `year` int(11) DEFAULT year(curdate()),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_lab_sequence
INSERT INTO `tbl_lab_sequence` (`id`, `last_order_number`, `year`) VALUES
(1, 3, 2025),
(2, 3, 2025),
(3, 3, 2025),
(4, 3, 2025);

-- Table: tbl_lab_test_catalog
DROP TABLE IF EXISTS `tbl_lab_test_catalog`;
CREATE TABLE `tbl_lab_test_catalog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_code` varchar(50) NOT NULL,
  `test_name` varchar(255) NOT NULL,
  `category` varchar(100) NOT NULL COMMENT 'Hematology, Chemistry, Microbiology, etc.',
  `sample_type` varchar(50) NOT NULL COMMENT 'Blood, Urine, Stool, etc.',
  `normal_range_male` text DEFAULT NULL,
  `normal_range_female` text DEFAULT NULL,
  `normal_range_min` decimal(15,4) DEFAULT NULL,
  `normal_range_max` decimal(15,4) DEFAULT NULL,
  `critical_low` decimal(15,4) DEFAULT NULL,
  `critical_high` decimal(15,4) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `method` varchar(100) DEFAULT NULL,
  `department` varchar(100) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT 0.00,
  `tat_hours` int(11) DEFAULT 24 COMMENT 'Turnaround time in hours',
  `critical_values` text DEFAULT NULL,
  `preparation_required` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `test_code` (`test_code`),
  KEY `idx_test_code` (`test_code`),
  KEY `idx_category` (`category`),
  KEY `idx_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_lab_test_catalog
INSERT INTO `tbl_lab_test_catalog` (`id`, `test_code`, `test_name`, `category`, `sample_type`, `normal_range_male`, `normal_range_female`, `normal_range_min`, `normal_range_max`, `critical_low`, `critical_high`, `unit`, `method`, `department`, `price`, `tat_hours`, `critical_values`, `preparation_required`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'CBC001', 'Complete Blood Count (CBC)', 'Hematology', 'Blood', '4.5-5.5 million cells/mcL', '4.0-5.0 million cells/mcL', NULL, NULL, NULL, NULL, 'cells/mcL', 'Automated Counter', 'Hematology Lab', '15.00', 2, '<3.5 or >6.0', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(2, 'HGB001', 'Hemoglobin', 'Hematology', 'Blood', '13.5-17.5 g/dL', '12.0-15.5 g/dL', NULL, NULL, NULL, NULL, 'g/dL', 'Automated Counter', 'Hematology Lab', '10.00', 2, '<7.0 or >20.0', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(3, 'PLT001', 'Platelet Count', 'Hematology', 'Blood', '150-400 x10^3/mcL', '150-400 x10^3/mcL', NULL, NULL, NULL, NULL, 'x10^3/mcL', 'Automated Counter', 'Hematology Lab', '10.00', 2, '<50 or >1000', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(4, 'WBC001', 'White Blood Cell Count', 'Hematology', 'Blood', '4.5-11.0 x10^3/mcL', '4.5-11.0 x10^3/mcL', NULL, NULL, NULL, NULL, 'x10^3/mcL', 'Automated Counter', 'Hematology Lab', '10.00', 2, '<2.0 or >30.0', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(5, 'GLU001', 'Fasting Blood Glucose', 'Chemistry', 'Blood', '70-100 mg/dL', '70-100 mg/dL', NULL, NULL, NULL, NULL, 'mg/dL', 'Enzymatic', 'Chemistry Lab', '8.00', 4, '<40 or >400', '8-12 hours fasting', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(6, 'HBA1C001', 'Hemoglobin A1C', 'Chemistry', 'Blood', '<5.7%', '<5.7%', NULL, NULL, NULL, NULL, '%', 'HPLC', 'Chemistry Lab', '25.00', 24, '>10%', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(7, 'CRE001', 'Creatinine', 'Chemistry', 'Blood', '0.7-1.3 mg/dL', '0.6-1.1 mg/dL', NULL, NULL, NULL, NULL, 'mg/dL', 'Jaffe Method', 'Chemistry Lab', '10.00', 4, '>5.0', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(8, 'BUN001', 'Blood Urea Nitrogen', 'Chemistry', 'Blood', '7-20 mg/dL', '7-20 mg/dL', NULL, NULL, NULL, NULL, 'mg/dL', 'Enzymatic', 'Chemistry Lab', '10.00', 4, '>100', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(9, 'ALT001', 'ALT (SGPT)', 'Chemistry', 'Blood', '7-55 U/L', '7-45 U/L', NULL, NULL, NULL, NULL, 'U/L', 'Enzymatic', 'Chemistry Lab', '12.00', 6, '>500', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(10, 'AST001', 'AST (SGOT)', 'Chemistry', 'Blood', '8-48 U/L', '8-43 U/L', NULL, NULL, NULL, NULL, 'U/L', 'Enzymatic', 'Chemistry Lab', '12.00', 6, '>500', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(11, 'CHOL001', 'Total Cholesterol', 'Chemistry', 'Blood', '<200 mg/dL', '<200 mg/dL', NULL, NULL, NULL, NULL, 'mg/dL', 'Enzymatic', 'Chemistry Lab', '12.00', 6, '>400', '9-12 hours fasting', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(12, 'HDL001', 'HDL Cholesterol', 'Chemistry', 'Blood', '>40 mg/dL', '>50 mg/dL', NULL, NULL, NULL, NULL, 'mg/dL', 'Enzymatic', 'Chemistry Lab', '12.00', 6, '<20', '9-12 hours fasting', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(13, 'LDL001', 'LDL Cholesterol', 'Chemistry', 'Blood', '<130 mg/dL', '<130 mg/dL', NULL, NULL, NULL, NULL, 'mg/dL', 'Calculated', 'Chemistry Lab', '12.00', 6, '>190', '9-12 hours fasting', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(14, 'TRIG001', 'Triglycerides', 'Chemistry', 'Blood', '<150 mg/dL', '<150 mg/dL', NULL, NULL, NULL, NULL, 'mg/dL', 'Enzymatic', 'Chemistry Lab', '12.00', 6, '>500', '9-12 hours fasting', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(15, 'TSH001', 'TSH', 'Chemistry', 'Blood', '0.4-4.0 mIU/L', '0.4-4.0 mIU/L', NULL, NULL, NULL, NULL, 'mIU/L', 'Immunoassay', 'Chemistry Lab', '20.00', 24, '<0.1 or >20', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(16, 'T3001', 'T3 Total', 'Chemistry', 'Blood', '80-200 ng/dL', '80-200 ng/dL', NULL, NULL, NULL, NULL, 'ng/dL', 'Immunoassay', 'Chemistry Lab', '20.00', 24, '<40 or >400', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(17, 'T4001', 'T4 Total', 'Chemistry', 'Blood', '5-12 mcg/dL', '5-12 mcg/dL', NULL, NULL, NULL, NULL, 'mcg/dL', 'Immunoassay', 'Chemistry Lab', '20.00', 24, '<2.0 or >20', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(18, 'URINE001', 'Urine Culture', 'Microbiology', 'Urine', 'No Growth', 'No Growth', NULL, NULL, NULL, NULL, NULL, 'Culture', 'Microbiology Lab', '25.00', 48, '>100,000 CFU/mL', 'Clean catch', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(19, 'BLOOD001', 'Blood Culture', 'Microbiology', 'Blood', 'No Growth', 'No Growth', NULL, NULL, NULL, NULL, NULL, 'Culture', 'Microbiology Lab', '35.00', 72, 'Any growth', 'Aseptic technique', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(20, 'STOOL001', 'Stool Culture', 'Microbiology', 'Stool', 'Normal Flora', 'Normal Flora', NULL, NULL, NULL, NULL, NULL, 'Culture', 'Microbiology Lab', '30.00', 72, 'Pathogen detected', 'Fresh sample', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(21, 'UA001', 'Urinalysis Complete', 'Urinalysis', 'Urine', 'Normal', 'Normal', NULL, NULL, NULL, NULL, NULL, 'Microscopy', 'Urinalysis Lab', '10.00', 2, 'Blood/Protein present', 'Clean catch', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(22, 'UCG001', 'Urine Pregnancy Test', 'Urinalysis', 'Urine', 'Negative', 'Negative', NULL, NULL, NULL, NULL, NULL, 'Immunoassay', 'Urinalysis Lab', '8.00', 1, NULL, 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(23, 'HIV001', 'HIV Screening', 'Serology', 'Blood', 'Non-Reactive', 'Non-Reactive', NULL, NULL, NULL, NULL, NULL, 'ELISA', 'Serology Lab', '30.00', 24, 'Reactive', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(24, 'HEP001', 'Hepatitis B Surface Antigen', 'Serology', 'Blood', 'Non-Reactive', 'Non-Reactive', NULL, NULL, NULL, NULL, NULL, 'Immunoassay', 'Serology Lab', '25.00', 24, 'Reactive', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55'),
(25, 'COVID001', 'COVID-19 RT-PCR', 'Serology', 'Blood', 'Not Detected', 'Not Detected', NULL, NULL, NULL, NULL, NULL, 'RT-PCR', 'Serology Lab', '50.00', 12, 'Detected', 'None', 1, '2025-10-15 21:38:55', '2025-10-15 21:38:55');

-- Table: tbl_labour
DROP TABLE IF EXISTS `tbl_labour`;
CREATE TABLE `tbl_labour` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level_name` varchar(50) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `sex` varchar(10) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `nrc` varchar(250) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `work_in` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_labour_balance
DROP TABLE IF EXISTS `tbl_labour_balance`;
CREATE TABLE `tbl_labour_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labour_name` varchar(50) NOT NULL,
  `InMoney` int(11) DEFAULT NULL,
  `OutMoney` int(11) DEFAULT NULL,
  `About` text DEFAULT NULL,
  `Remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_labour_level
DROP TABLE IF EXISTS `tbl_labour_level`;
CREATE TABLE `tbl_labour_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `salary` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_loss
DROP TABLE IF EXISTS `tbl_loss`;
CREATE TABLE `tbl_loss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_migrations
DROP TABLE IF EXISTS `tbl_migrations`;
CREATE TABLE `tbl_migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `migration_name` varchar(255) NOT NULL,
  `executed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `migration_name` (`migration_name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_migrations
INSERT INTO `tbl_migrations` (`id`, `migration_name`, `executed_at`) VALUES
(1, '001_add_doctor_photo.sql', '2025-10-16 23:58:24'),
(2, '002_add_deposit_system.sql', '2025-10-16 23:58:24'),
(3, '003_add_inpatient_bed_fields.sql', '2025-10-16 23:58:47'),
(4, '004_fix_bed_inconsistencies.sql', '2025-10-16 23:58:47');

-- Table: tbl_operating_rooms
DROP TABLE IF EXISTS `tbl_operating_rooms`;
CREATE TABLE `tbl_operating_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `or_code` varchar(20) NOT NULL,
  `or_name` varchar(255) NOT NULL,
  `department_id` int(11) NOT NULL,
  `capacity` int(11) DEFAULT 1 COMMENT 'Number of operating tables',
  `equipment` text DEFAULT NULL COMMENT 'JSON array of equipment',
  `status` enum('Available','In_Use','Maintenance','Cleaning') DEFAULT 'Available',
  `is_active` tinyint(1) DEFAULT 1,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `or_code` (`or_code`),
  KEY `idx_or_code` (`or_code`),
  KEY `idx_department` (`department_id`),
  KEY `idx_status` (`status`),
  CONSTRAINT `tbl_operating_rooms_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_operating_rooms
INSERT INTO `tbl_operating_rooms` (`id`, `or_code`, `or_name`, `department_id`, `capacity`, `equipment`, `status`, `is_active`, `notes`, `created_at`, `updated_at`) VALUES
(4, 'OR01', 'Operating Room 1', 4, 8, 'Basic surgical equipment', 'Available', 1, NULL, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(5, 'OR02', 'Operating Room 2', 4, 10, 'Advanced cardiac equipment', 'Available', 1, NULL, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(6, 'OR03', 'Operating Room 3', 4, 6, 'Orthopedic surgical tools', 'Available', 1, NULL, '2025-10-15 19:34:50', '2025-10-15 19:34:50'),
(7, 'ER01', 'Emergency OR', 1, 8, 'Emergency surgical kit', 'Available', 1, NULL, '2025-10-15 19:34:50', '2025-10-15 19:34:50');

-- Table: tbl_operational_metrics
DROP TABLE IF EXISTS `tbl_operational_metrics`;
CREATE TABLE `tbl_operational_metrics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `metric_name` varchar(255) NOT NULL,
  `metric_type` varchar(100) NOT NULL COMMENT 'Efficiency, Utilization, Throughput',
  `value` decimal(10,2) NOT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `target_value` decimal(10,2) DEFAULT NULL,
  `measurement_date` date NOT NULL,
  `department_id` int(11) DEFAULT NULL,
  `shift` enum('Day','Evening','Night','All') DEFAULT NULL,
  `data_points` int(11) DEFAULT NULL COMMENT 'Number of observations',
  `variance` decimal(10,2) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_metric_type` (`metric_type`),
  KEY `idx_measurement_date` (`measurement_date`),
  KEY `idx_department` (`department_id`),
  CONSTRAINT `tbl_operational_metrics_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_or_equipment
DROP TABLE IF EXISTS `tbl_or_equipment`;
CREATE TABLE `tbl_or_equipment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `equipment_name` varchar(255) NOT NULL,
  `equipment_code` varchar(50) NOT NULL,
  `or_room` varchar(20) NOT NULL,
  `status` enum('Available','In_Use','Maintenance','Out_of_Service') DEFAULT 'Available',
  `last_maintenance` date DEFAULT NULL,
  `next_maintenance` date DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `warranty_expiry` date DEFAULT NULL,
  `manufacturer` varchar(255) DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `serial_number` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `equipment_code` (`equipment_code`),
  KEY `idx_equipment_code` (`equipment_code`),
  KEY `idx_or_room` (`or_room`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_or_schedules
DROP TABLE IF EXISTS `tbl_or_schedules`;
CREATE TABLE `tbl_or_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `or_number` varchar(20) NOT NULL,
  `patient_id` varchar(50) NOT NULL,
  `surgeon_id` int(11) NOT NULL,
  `anesthetist_id` int(11) DEFAULT NULL,
  `procedure_name` varchar(255) NOT NULL,
  `procedure_code` varchar(50) DEFAULT NULL,
  `scheduled_date` datetime NOT NULL,
  `estimated_duration` int(11) NOT NULL COMMENT 'Duration in minutes',
  `actual_start_time` datetime DEFAULT NULL,
  `actual_end_time` datetime DEFAULT NULL,
  `status` enum('Scheduled','In_Progress','Completed','Cancelled','Postponed') DEFAULT 'Scheduled',
  `priority` enum('Routine','Urgent','Emergency') DEFAULT 'Routine',
  `pre_op_notes` text DEFAULT NULL,
  `post_op_notes` text DEFAULT NULL,
  `complications` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_or_number` (`or_number`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_surgeon` (`surgeon_id`),
  KEY `idx_scheduled_date` (`scheduled_date`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_patient
DROP TABLE IF EXISTS `tbl_patient`;
CREATE TABLE `tbl_patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `case_` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `dr_name` varchar(250) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  `room_no` varchar(250) DEFAULT NULL,
  `deposit` int(11) DEFAULT NULL,
  `deposit_balance` decimal(10,2) DEFAULT 0.00,
  PRIMARY KEY (`id`),
  KEY `idx_patient_patient_id` (`patient_id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_patient
INSERT INTO `tbl_patient` (`id`, `name`, `age`, `phone`, `address`, `case_`, `remark`, `date`, `dr_name`, `patient_id`, `room_no`, `deposit`, `deposit_balance`) VALUES
(2, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL, '0.00'),
(3, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL, '0.00'),
(4, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL, '0.00'),
(6, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL, '0.00'),
(7, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL, '0.00'),
(8, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL, '0.00'),
(9, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL, '0.00'),
(10, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL, '0.00'),
(11, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL, '0.00'),
(12, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL, '0.00'),
(13, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL, '0.00'),
(14, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL, '0.00'),
(15, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL, '0.00'),
(16, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', 'Common Cold', 'Follow-up in 3 days', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-001', NULL, NULL, '0.00'),
(17, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL, '0.00'),
(18, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL, '0.00'),
(19, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL, '0.00'),
(20, 'Ko Zaw', '42', '09-555666777', 'Thingangyun Township, Yangon', 'Gastritis', 'Dietary advice given', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-005', NULL, NULL, '0.00'),
(21, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL, '0.00'),
(22, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL, '0.00'),
(23, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL, '0.00'),
(24, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL, '0.00'),
(25, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL, '0.00'),
(26, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL, '0.00'),
(27, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL, '0.00'),
(28, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL, '0.00'),
(29, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL, '0.00'),
(30, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL, '0.00'),
(31, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', 'Common Cold', 'Follow-up in 3 days', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-001', NULL, NULL, '0.00'),
(32, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL, '0.00'),
(33, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL, '0.00'),
(34, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL, '0.00'),
(35, 'Ko Zaw', '42', '09-555666777', 'Thingangyun Township, Yangon', 'Gastritis', 'Dietary advice given', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-005', NULL, NULL, '0.00'),
(36, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL, '0.00'),
(37, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL, '0.00'),
(38, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL, '0.00'),
(39, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL, '0.00'),
(40, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL, '0.00'),
(41, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL, '0.00'),
(42, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL, '0.00'),
(43, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL, '0.00'),
(44, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-14 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL, '0.00'),
(45, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-14 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL, '0.00'),
(46, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', 'Common Cold', 'Follow-up in 3 days', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-001', NULL, NULL, '652000.00'),
(47, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL, '0.00'),
(48, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL, '0.00'),
(49, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL, '0.00'),
(50, 'Ko Zaw', '42', '09-555666777', 'Thingangyun Township, Yangon', 'Gastritis', 'Dietary advice given', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-005', NULL, NULL, '0.00'),
(51, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL, '0.00'),
(52, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL, '0.00'),
(53, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL, '0.00'),
(54, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL, '0.00'),
(55, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL, '0.00'),
(56, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL, '0.00'),
(57, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL, '0.00'),
(58, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL, '0.00'),
(59, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL, '0.00'),
(60, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL, '0.00'),
(61, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', 'Common Cold', 'Follow-up in 3 days', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-001', NULL, NULL, '0.00'),
(62, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL, '0.00'),
(63, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL, '0.00'),
(64, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL, '0.00'),
(65, 'Ko Zaw', '42', '09-555666777', 'Thingangyun Township, Yangon', 'Gastritis', 'Dietary advice given', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-005', NULL, NULL, '0.00'),
(66, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL, '0.00'),
(67, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL, '0.00'),
(68, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL, '0.00'),
(69, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL, '0.00'),
(70, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL, '0.00'),
(71, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL, '0.00'),
(72, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL, '0.00'),
(73, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL, '0.00'),
(74, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-16 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL, '0.00'),
(75, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-16 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL, '0.00'),
(76, 'Ko Moe Tain', '25', '092514114', 'Yangon', 'General', '', '2025-10-23 00:00:00', 'Dr. Kyaw Kyaw', 'P000074', '', 0, '0.00');

-- Table: tbl_patient_sale
DROP TABLE IF EXISTS `tbl_patient_sale`;
CREATE TABLE `tbl_patient_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_patient_satisfaction
DROP TABLE IF EXISTS `tbl_patient_satisfaction`;
CREATE TABLE `tbl_patient_satisfaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `survey_date` date NOT NULL,
  `survey_type` varchar(100) NOT NULL COMMENT 'Discharge, Outpatient, Emergency',
  `overall_rating` int(11) NOT NULL COMMENT '1-5 scale',
  `staff_courtesy` int(11) DEFAULT NULL COMMENT '1-5 scale',
  `communication` int(11) DEFAULT NULL COMMENT '1-5 scale',
  `cleanliness` int(11) DEFAULT NULL COMMENT '1-5 scale',
  `pain_management` int(11) DEFAULT NULL COMMENT '1-5 scale',
  `discharge_information` int(11) DEFAULT NULL COMMENT '1-5 scale',
  `would_recommend` tinyint(1) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `response_method` enum('Phone','Email','Paper','Tablet') DEFAULT 'Paper',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_survey_date` (`survey_date`),
  KEY `idx_overall_rating` (`overall_rating`),
  KEY `idx_department` (`department_id`),
  CONSTRAINT `tbl_patient_satisfaction_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_patient_vitals
DROP TABLE IF EXISTS `tbl_patient_vitals`;
CREATE TABLE `tbl_patient_vitals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `treatment_id` int(11) DEFAULT NULL,
  `blood_pressure_systolic` int(11) DEFAULT NULL,
  `blood_pressure_diastolic` int(11) DEFAULT NULL,
  `heart_rate` int(11) DEFAULT NULL,
  `temperature` decimal(4,1) DEFAULT NULL,
  `respiratory_rate` int(11) DEFAULT NULL,
  `oxygen_saturation` int(11) DEFAULT NULL,
  `weight` decimal(5,2) DEFAULT NULL,
  `height` decimal(5,2) DEFAULT NULL,
  `bmi` decimal(4,2) DEFAULT NULL,
  `blood_glucose` decimal(5,2) DEFAULT NULL,
  `recorded_by` varchar(100) DEFAULT NULL,
  `recorded_date` datetime DEFAULT current_timestamp(),
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_patient_vitals` (`patient_id`),
  KEY `idx_vitals_date` (`recorded_date`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_patient_vitals
INSERT INTO `tbl_patient_vitals` (`id`, `patient_id`, `treatment_id`, `blood_pressure_systolic`, `blood_pressure_diastolic`, `heart_rate`, `temperature`, `respiratory_rate`, `oxygen_saturation`, `weight`, `height`, `bmi`, `blood_glucose`, `recorded_by`, `recorded_date`, `notes`) VALUES
(1, 'OPD-002', NULL, 150, 95, 82, '98.2', 18, 98, '75.50', '165.00', '27.70', NULL, 'Nurse May', '2025-04-15 15:20:49', 'Initial visit - High BP'),
(2, 'OPD-002', NULL, 145, 92, 80, '98.0', 17, 98, '75.20', '165.00', '27.60', NULL, 'Nurse May', '2025-05-15 15:20:49', 'Month 1 - Improving'),
(3, 'OPD-002', NULL, 142, 90, 78, '97.8', 18, 98, '74.80', '165.00', '27.50', NULL, 'Nurse May', '2025-06-14 15:20:49', 'Month 2 - Good response'),
(4, 'OPD-002', NULL, 138, 88, 76, '98.1', 17, 99, '74.50', '165.00', '27.40', NULL, 'Nurse May', '2025-07-14 15:20:49', 'Month 3 - Stable'),
(5, 'OPD-002', NULL, 135, 85, 75, '98.0', 18, 98, '74.00', '165.00', '27.20', NULL, 'Nurse May', '2025-08-13 15:20:49', 'Month 4 - Well controlled'),
(6, 'OPD-002', NULL, 132, 82, 74, '97.9', 17, 99, '73.50', '165.00', '27.00', NULL, 'Nurse May', '2025-09-12 15:20:49', 'Month 5 - Excellent'),
(7, 'OPD-002', NULL, 128, 80, 72, '98.0', 18, 99, '73.00', '165.00', '26.80', NULL, 'Nurse May', '2025-10-12 15:20:49', 'Month 6 - Target achieved'),
(8, 'OPD-003', NULL, 135, 85, 76, '98.0', 18, 98, '82.00', '168.00', '29.10', '180.00', 'Nurse May', '2025-07-14 15:20:49', 'Initial - High glucose'),
(9, 'OPD-003', NULL, 132, 82, 75, '97.8', 17, 98, '80.50', '168.00', '28.50', '160.00', 'Nurse May', '2025-08-13 15:20:49', 'Improving glucose'),
(10, 'OPD-003', NULL, 130, 80, 74, '98.1', 18, 99, '79.00', '168.00', '28.00', '145.00', 'Nurse May', '2025-09-12 15:20:49', 'Good control'),
(11, 'OPD-003', NULL, 128, 78, 73, '98.0', 17, 99, '78.00', '168.00', '27.60', '125.00', 'Nurse May', '2025-10-12 15:20:49', 'Target achieved'),
(12, 'IPD-001', NULL, 120, 75, 95, '101.2', 24, 92, '68.00', '172.00', '23.00', NULL, 'ICU Nurse', '2025-10-09 15:20:49', 'Admission - Fever, tachypnea'),
(13, 'IPD-001', NULL, 118, 74, 90, '100.5', 22, 94, '68.00', '172.00', '23.00', NULL, 'ICU Nurse', '2025-10-10 15:20:49', 'Day 2 - Improving'),
(14, 'IPD-001', NULL, 120, 76, 85, '99.2', 20, 96, '68.00', '172.00', '23.00', NULL, 'ICU Nurse', '2025-10-11 15:20:49', 'Day 3 - Much better'),
(15, 'IPD-001', NULL, 122, 78, 80, '98.4', 18, 98, '68.00', '172.00', '23.00', NULL, 'Nurse May', '2025-10-12 15:20:49', 'Day 4 - Ready for discharge'),
(16, 'IPD-005', NULL, 180, 100, 88, '98.0', 18, 97, '72.00', '170.00', '24.90', NULL, 'ICU Nurse', '2025-10-05 15:20:49', 'Admission - Hypertensive'),
(17, 'IPD-005', NULL, 165, 95, 85, '97.8', 17, 98, '72.00', '170.00', '24.90', NULL, 'ICU Nurse', '2025-10-06 15:20:49', 'Day 2 - BP lowering'),
(18, 'IPD-005', NULL, 155, 90, 82, '98.0', 18, 98, '72.00', '170.00', '24.90', NULL, 'Nurse May', '2025-10-07 15:20:49', 'Day 3 - Stable'),
(19, 'IPD-005', NULL, 145, 85, 80, '98.1', 17, 98, '72.00', '170.00', '24.90', NULL, 'Nurse May', '2025-10-09 15:20:49', 'Day 5 - Good response'),
(20, 'IPD-005', NULL, 138, 82, 78, '97.9', 18, 99, '72.00', '170.00', '24.90', NULL, 'Nurse May', '2025-10-12 15:20:49', 'Day 8 - Target BP reached'),
(21, 'OPD-007', NULL, 140, 85, 75, '98.0', 17, 98, '88.00', '168.00', '31.20', NULL, 'Nurse May', '2025-06-14 15:20:49', 'Overweight - plan started'),
(22, 'OPD-007', NULL, 138, 84, 74, '98.1', 17, 98, '86.50', '168.00', '30.60', NULL, 'Nurse May', '2025-07-14 15:20:49', 'Lost 1.5kg'),
(23, 'OPD-007', NULL, 135, 82, 73, '97.9', 18, 99, '84.00', '168.00', '29.80', NULL, 'Nurse May', '2025-08-13 15:20:49', 'Lost 4kg total'),
(24, 'OPD-007', NULL, 132, 80, 72, '98.0', 17, 99, '82.00', '168.00', '29.10', NULL, 'Nurse May', '2025-09-12 15:20:49', 'Lost 6kg - excellent'),
(25, 'OPD-007', NULL, 130, 78, 71, '98.0', 18, 99, '80.50', '168.00', '28.50', NULL, 'Nurse May', '2025-10-12 15:20:49', 'Lost 7.5kg - Continue'),
(26, 'IPD-003', NULL, 115, 70, 105, '103.5', 20, 98, '65.00', '170.00', '22.50', NULL, 'ICU Nurse', '2025-10-10 15:20:49', 'Admission - High fever'),
(27, 'IPD-003', NULL, 118, 72, 100, '102.0', 19, 98, '65.00', '170.00', '22.50', NULL, 'ICU Nurse', '2025-10-11 15:20:49', 'Day 2 - Fever persists'),
(28, 'IPD-003', NULL, 120, 75, 90, '99.5', 18, 98, '65.00', '170.00', '22.50', NULL, 'Nurse May', '2025-10-12 15:20:49', 'Day 3 - Fever breaking'),
(29, 'OPD-014', NULL, 110, 70, 68, '98.2', 16, 99, '62.00', '160.00', '24.20', NULL, 'Nurse May', '2025-09-12 15:20:49', 'Pregnancy week 20'),
(30, 'OPD-014', NULL, 115, 72, 70, '98.0', 16, 99, '64.00', '160.00', '25.00', '90.00', 'Nurse May', '2025-10-12 15:20:49', 'Pregnancy week 24 - All normal'),
(31, 'OPD-008', NULL, 125, 78, 72, '98.0', 18, 98, '58.00', '162.00', '22.10', NULL, 'Nurse May', '2025-09-27 15:20:49', 'Asthma checkup'),
(32, 'OPD-008', NULL, 122, 76, 70, '98.1', 17, 99, '58.00', '162.00', '22.10', NULL, 'Nurse May', '2025-10-12 15:20:49', 'Asthma controlled');

-- Table: tbl_payment_method
DROP TABLE IF EXISTS `tbl_payment_method`;
CREATE TABLE `tbl_payment_method` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_payment_method
INSERT INTO `tbl_payment_method` (`id`, `name`) VALUES
(1, 'Cash'),
(2, 'KBZ Pay'),
(3, 'CB Pay'),
(4, 'Aya Pay'),
(5, 'Wave Money'),
(6, 'Bank Transfer');

-- Table: tbl_prescription_details
DROP TABLE IF EXISTS `tbl_prescription_details`;
CREATE TABLE `tbl_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `drug_id` int(11) DEFAULT NULL,
  `drug_code` varchar(50) DEFAULT NULL,
  `drug_name` varchar(255) NOT NULL,
  `quantity` int(11) NOT NULL,
  `refills` int(11) DEFAULT 0,
  `dosage` varchar(100) DEFAULT NULL,
  `frequency` varchar(100) DEFAULT NULL,
  `route` varchar(50) DEFAULT NULL,
  `duration` varchar(50) DEFAULT NULL,
  `instructions` text DEFAULT NULL,
  `indication` varchar(255) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `is_prn` tinyint(1) DEFAULT 0,
  `price` decimal(10,2) DEFAULT 0.00,
  `total` decimal(10,2) DEFAULT 0.00,
  `status` enum('Pending','Dispensed','Cancelled') DEFAULT 'Pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_prescription_id` (`prescription_id`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_prescription_details
INSERT INTO `tbl_prescription_details` (`id`, `prescription_id`, `drug_id`, `drug_code`, `drug_name`, `quantity`, `refills`, `dosage`, `frequency`, `route`, `duration`, `instructions`, `indication`, `start_date`, `end_date`, `is_prn`, `price`, `total`, `status`, `created_at`) VALUES
(1, 2, NULL, NULL, 'as', 3, 0, 's', 's', 'Oral', '3', NULL, NULL, NULL, NULL, 0, '3.00', '0.00', 'Pending', '2025-10-15 21:26:19');

-- Table: tbl_prescription_items
DROP TABLE IF EXISTS `tbl_prescription_items`;
CREATE TABLE `tbl_prescription_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `drug_id` int(11) NOT NULL,
  `drug_name` varchar(255) NOT NULL,
  `dosage` varchar(100) DEFAULT NULL,
  `frequency` varchar(100) DEFAULT NULL COMMENT 'e.g., BID, TID, QID',
  `duration` varchar(100) DEFAULT NULL COMMENT 'e.g., 7 days, 2 weeks',
  `quantity` int(11) NOT NULL,
  `unit_price` decimal(10,2) DEFAULT 0.00,
  `total_price` decimal(10,2) DEFAULT 0.00,
  `instructions` text DEFAULT NULL,
  `is_dispensed` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_prescription_id` (`prescription_id`),
  KEY `idx_drug_id` (`drug_id`),
  CONSTRAINT `tbl_prescription_items_ibfk_1` FOREIGN KEY (`prescription_id`) REFERENCES `tbl_prescription_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_prescription_orders
DROP TABLE IF EXISTS `tbl_prescription_orders`;
CREATE TABLE `tbl_prescription_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(50) NOT NULL,
  `patient_id` varchar(50) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `encounter_type` enum('Outpatient','Inpatient','Emergency','Consultation') DEFAULT 'Outpatient',
  `order_date` datetime DEFAULT current_timestamp(),
  `diagnosis` text DEFAULT NULL,
  `allergies` text DEFAULT NULL,
  `status` enum('Active','Completed','Cancelled','On_Hold') DEFAULT 'Active',
  `total_amount` decimal(10,2) DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  `pharmacist_id` int(11) DEFAULT NULL,
  `dispensed_date` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_number` (`order_number`),
  KEY `idx_order_number` (`order_number`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_doctor_id` (`doctor_id`),
  KEY `idx_status` (`status`),
  KEY `idx_order_date` (`order_date`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_prescription_orders
INSERT INTO `tbl_prescription_orders` (`id`, `order_number`, `patient_id`, `doctor_id`, `encounter_type`, `order_date`, `diagnosis`, `allergies`, `status`, `total_amount`, `notes`, `pharmacist_id`, `dispensed_date`, `created_by`, `created_at`, `updated_at`) VALUES
(1, 'RX2025000002', '2123', 1, 'Inpatient', '2025-10-15 21:23:49', 'qweqweqwe', NULL, 'Active', '0.00', NULL, NULL, NULL, 1, '2025-10-15 21:23:49', '2025-10-15 21:23:49'),
(2, 'RX2025000003', '2123', 1, 'Inpatient', '2025-10-15 21:26:19', 'qweqweqwe', NULL, 'Active', '0.00', NULL, NULL, NULL, 1, '2025-10-15 21:26:19', '2025-10-15 21:26:19');

-- Table: tbl_prescription_sequence
DROP TABLE IF EXISTS `tbl_prescription_sequence`;
CREATE TABLE `tbl_prescription_sequence` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `last_order_number` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_year` (`year`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_prescription_sequence
INSERT INTO `tbl_prescription_sequence` (`id`, `year`, `last_order_number`, `created_at`, `updated_at`) VALUES
(1, 2025, 3, '2025-10-15 20:03:12', '2025-10-15 21:26:19');

-- Table: tbl_purchase
DROP TABLE IF EXISTS `tbl_purchase`;
CREATE TABLE `tbl_purchase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_voucher_id` int(11) DEFAULT NULL,
  `cat_id` varchar(255) DEFAULT NULL,
  `cat_id_2` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  `total_cost_price` int(11) DEFAULT NULL,
  `sale_price_latli` int(11) DEFAULT NULL,
  `sale_price_latkar` int(11) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `alert_month` int(11) DEFAULT NULL,
  `alert_date` date DEFAULT NULL,
  `margin` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_purchase
INSERT INTO `tbl_purchase` (`id`, `purchase_voucher_id`, `cat_id`, `cat_id_2`, `barcode`, `name`, `qty`, `qty_alert`, `unit_name`, `cost_price`, `total_cost_price`, `sale_price_latli`, `sale_price_latkar`, `remark`, `date`, `status`, `expire_date`, `alert_month`, `alert_date`, `margin`) VALUES
(1, NULL, NULL, NULL, '234234', 'Test', 33, 10, 'pcs', 33, 1089, 33, 0, '', '2025-10-14 00:00:00', 1, '2025-10-14 00:00:00', NULL, NULL, NULL),
(2, NULL, '17', NULL, '8850987180002', 'AAAAA', 33, 10, 'pcs', 33, 1089, 33, 0, '', '2025-10-14 00:00:00', 1, '2025-10-14 00:00:00', 3, NULL, NULL),
(3, NULL, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 44, 10, 'Capsule', 33, 1452, 33, 0, '444', '2025-10-16 00:00:00', 1, '2025-10-16 00:00:00', 4, NULL, NULL),
(4, NULL, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 33, 10, 'Capsule', 33, 1089, 33, 0, '3', '2025-10-16 00:00:00', 1, '2025-10-16 00:00:00', 3, NULL, NULL),
(5, NULL, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 22, 10, 'Capsule', 33, 726, 33, 0, '123', '2025-10-16 00:00:00', 1, '2025-10-16 00:00:00', 3, NULL, NULL),
(6, NULL, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 20, 10, 'Capsule', 33, 660, 33, 0, '', '2025-10-17 00:00:00', 1, '2025-12-02 00:00:00', 3, NULL, NULL),
(7, NULL, '21', NULL, '8808231739997', 'Amoxilin', 500, 10, 'Box', 500, 250000, 800, 0, '', '2025-10-23 00:00:00', 1, NULL, 3, NULL, NULL),
(8, NULL, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 500, 10, 'Capsule', 33, 16500, 33, 0, '', '2025-10-23 00:00:00', 1, '2024-10-23 00:00:00', 6, NULL, NULL);

-- Table: tbl_purchase_return
DROP TABLE IF EXISTS `tbl_purchase_return`;
CREATE TABLE `tbl_purchase_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_purchase_voucher
DROP TABLE IF EXISTS `tbl_purchase_voucher`;
CREATE TABLE `tbl_purchase_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `total_cost` double NOT NULL,
  `supplier_name` varchar(50) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_quality_metrics
DROP TABLE IF EXISTS `tbl_quality_metrics`;
CREATE TABLE `tbl_quality_metrics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `metric_name` varchar(255) NOT NULL,
  `metric_category` varchar(100) NOT NULL COMMENT 'Patient Safety, Clinical Effectiveness, etc.',
  `numerator` int(11) NOT NULL,
  `denominator` int(11) NOT NULL,
  `percentage` decimal(5,2) NOT NULL,
  `target_percentage` decimal(5,2) DEFAULT NULL,
  `period_start` date NOT NULL,
  `period_end` date NOT NULL,
  `department_id` int(11) DEFAULT NULL,
  `data_source` varchar(255) DEFAULT NULL,
  `benchmark_comparison` varchar(255) DEFAULT NULL,
  `action_required` tinyint(1) DEFAULT 0,
  `notes` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `meets_target` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_category` (`metric_category`),
  KEY `idx_period` (`period_start`,`period_end`),
  KEY `idx_department` (`department_id`),
  CONSTRAINT `tbl_quality_metrics_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_readmissions
DROP TABLE IF EXISTS `tbl_readmissions`;
CREATE TABLE `tbl_readmissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `original_admission_date` date NOT NULL,
  `original_discharge_date` date NOT NULL,
  `readmission_date` date NOT NULL,
  `days_between` int(11) NOT NULL,
  `is_planned` tinyint(1) DEFAULT 0,
  `original_diagnosis` varchar(255) NOT NULL,
  `readmission_diagnosis` varchar(255) NOT NULL,
  `is_related` tinyint(1) DEFAULT 0 COMMENT 'Related to original admission',
  `department_id` int(11) DEFAULT NULL,
  `attending_physician` int(11) DEFAULT NULL,
  `risk_score` decimal(5,2) DEFAULT NULL,
  `preventable` enum('Yes','No','Possibly','Under_Review') DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `days_since_discharge` int(11) DEFAULT NULL COMMENT 'Number of days between discharge and readmission',
  `preventability_assessment` enum('Preventable','Potentially_Preventable','Not_Preventable','Unknown') DEFAULT 'Unknown',
  PRIMARY KEY (`id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_readmission_date` (`readmission_date`),
  KEY `idx_days_between` (`days_between`),
  KEY `idx_department` (`department_id`),
  CONSTRAINT `tbl_readmissions_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `tbl_departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_role
DROP TABLE IF EXISTS `tbl_role`;
CREATE TABLE `tbl_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_role
INSERT INTO `tbl_role` (`id`, `name`) VALUES
(1, 'Admin'),
(2, 'Manager'),
(3, 'Cashier'),
(4, 'Doctor');

-- Table: tbl_sale
DROP TABLE IF EXISTS `tbl_sale`;
CREATE TABLE `tbl_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_sale_vno` (`VNo`),
  KEY `idx_sale_date` (`Date`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_sale
INSERT INTO `tbl_sale` (`id`, `cat_id`, `Barcode`, `Name`, `SaleType`, `SalePrice`, `dis`, `Qty`, `Total`, `Profit`, `VNo`, `Date`, `Cashier`, `Refer`, `cost_price`) VALUES
(1, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 1, 350, 150, 1000, '2025-10-12 00:00:00', 'Current User', NULL, 200),
(2, '1', '8850987180001', 'Paracetamol 500mg', 'Retail', 100, 0, 1, 100, 50, 1000, '2025-10-12 00:00:00', 'Current User', NULL, 50),
(3, '1', '8850987180003', 'Vitamin C 1000mg', 'Retail', 200, 0, 1, 200, 100, 1000, '2025-10-12 00:00:00', 'Current User', NULL, 100),
(4, '1', '8850987180001', 'Paracetamol 500mg', 'Retail', 100, 0, 20, 2000, 1000, 1001, '2025-10-12 00:00:00', 'Current User', NULL, 50),
(5, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 15, 5250, 2250, 1001, '2025-10-12 00:00:00', 'Current User', NULL, 200),
(6, '1', '8850987180003', 'Vitamin C 1000mg', 'Retail', 200, 0, 4, 800, 400, 1001, '2025-10-12 00:00:00', 'Current User', NULL, 100),
(7, '1', '8850987180001', 'Paracetamol 500mg', 'Retail', 100, 0, 2, 200, 100, 1002, '2025-10-12 00:00:00', 'Current User', NULL, 50),
(8, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 2, 700, 300, 1002, '2025-10-12 00:00:00', 'Current User', NULL, 200),
(9, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1003, '2025-10-14 00:00:00', 'Current User', NULL, 1000),
(10, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 1, 2000, 1500, 1003, '2025-10-14 00:00:00', 'Current User', NULL, 500),
(11, '21', '8808231739997', 'Amoxilin', 'Retail', 800, 0, 1, 800, 300, 1003, '2025-10-14 00:00:00', 'Current User', NULL, 500),
(12, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 2, 700, 300, 1003, '2025-10-14 00:00:00', 'Current User', NULL, 200),
(13, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1004, '2025-10-14 00:00:00', 'Current User', NULL, 1000),
(14, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 1, 2000, 1500, 1004, '2025-10-14 00:00:00', 'Current User', NULL, 500),
(15, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 1, 350, 150, 1004, '2025-10-14 00:00:00', 'Current User', NULL, 200),
(16, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1005, '2025-10-14 00:00:00', 'Current User', NULL, 5000),
(17, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1005, '2025-10-14 00:00:00', 'Current User', NULL, 5000),
(18, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1005, '2025-10-14 00:00:00', 'Current User', NULL, 3500),
(19, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 1, 350, 150, 1005, '2025-10-14 00:00:00', 'Current User', NULL, 200),
(20, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 350, 0, 1, 350, 150, 1006, '2025-10-14 00:00:00', 'Current User', NULL, 200),
(21, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1006, '2025-10-14 00:00:00', 'Current User', NULL, 3500),
(22, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1006, '2025-10-14 00:00:00', 'Current User', NULL, 5000),
(23, '7', 'S7007890123', 'Ear Cleaning', 'Service', 3500, 0, 1, 3500, 2700, 1007, '2025-10-14 00:00:00', 'Current User', NULL, 800),
(24, '5', 'S5004567890', 'ECG Analysis Report', 'Service', 5000, 0, 1, 5000, 4000, 1007, '2025-10-14 00:00:00', 'Current User', NULL, 1000),
(25, '1', 'S1004567890', 'Emergency Consultation', 'Service', 35000, 0, 1, 35000, 25000, 1007, '2025-10-14 00:00:00', 'Current User', NULL, 10000),
(26, '8', 'S8001234567', 'Emergency Treatment', 'Service', 40000, 0, 1, 40000, 30000, 1007, '2025-10-14 00:00:00', 'Current User', NULL, 10000),
(27, '3', 'S3004567890', 'Dental X-Ray', 'Service', 12000, 0, 1, 12000, 9500, 1007, '2025-10-14 00:00:00', 'Current User', NULL, 2500),
(28, '2', 'S2014567890', 'Dengue Test', 'Service', 12000, 0, 1, 12000, 9000, 1007, '2025-10-14 00:00:00', 'Current User', NULL, 3000),
(29, '1', 'S1003456789', 'Follow-up Consultation', 'Service', 10000, 0, 1, 10000, 7000, 1007, '2025-10-14 00:00:00', 'Current User', NULL, 3000),
(30, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1008, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(31, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1008, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(32, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1009, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(33, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1009, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(34, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1010, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(35, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1010, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(36, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1011, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(37, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1011, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(38, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1012, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(39, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1012, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(40, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1013, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(41, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1013, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(42, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 33, 0, 1, 33, 0, 1014, '2025-10-16 00:00:00', 'Current User', NULL, 33),
(43, '21', '8808231739997', 'Amoxilin', 'Retail', 800, 0, 1, 800, 300, 1014, '2025-10-16 00:00:00', 'Current User', NULL, 500),
(44, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 1, 2000, 1500, 1014, '2025-10-16 00:00:00', 'Current User', NULL, 500),
(45, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 2, 50000, 40000, 1015, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(46, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 3, 75000, 60000, 1015, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(47, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 3, 54000, 43500, 1015, '2025-10-16 00:00:00', 'Current User', NULL, 3500),
(48, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 33, 0, 4, 132, 0, 1015, '2025-10-16 00:00:00', 'Current User', NULL, 33),
(49, '3', 'S3001234567', 'Chest X-Ray', 'Service', 15000, 0, 1, 15000, 12000, 1015, '2025-10-16 00:00:00', 'Current User', NULL, 3000),
(50, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 1, 2000, 1500, 1015, '2025-10-16 00:00:00', 'Current User', NULL, 500),
(51, '2', 'S2001234567', 'Complete Blood Count (CBC)', 'Service', 8000, 0, 1, 8000, 6000, 1015, '2025-10-16 00:00:00', 'Current User', NULL, 2000),
(52, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1016, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(53, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1016, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(54, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1016, '2025-10-16 00:00:00', 'Current User', NULL, 3500),
(55, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1017, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(56, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 33, 0, 2, 66, 0, 1017, '2025-10-16 00:00:00', 'Current User', NULL, 33),
(57, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1018, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(58, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1018, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(59, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 2, 36000, 29000, 1018, '2025-10-16 00:00:00', 'Current User', NULL, 3500),
(60, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1019, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(61, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1019, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(62, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1019, '2025-10-16 00:00:00', 'Current User', NULL, 3500),
(63, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 1, 2000, 1500, 1020, '2025-10-16 00:00:00', 'Current User', NULL, 500),
(64, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1021, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(65, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1021, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(66, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1022, '2025-10-16 00:00:00', 'Current User', NULL, 3500),
(67, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 4, 100000, 80000, 1022, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(68, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 2, 50000, 40000, 1022, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(69, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1023, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(70, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 3, 75000, 60000, 1023, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(71, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1023, '2025-10-16 00:00:00', 'Current User', NULL, 3500),
(72, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1024, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(73, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1024, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(74, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1024, '2025-10-16 00:00:00', 'Current User', NULL, 1200),
(75, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1024, '2025-10-16 00:00:00', 'Current User', NULL, 1000),
(76, '2', 'S2001234567', 'Complete Blood Count (CBC)', 'Service', 8000, 0, 1, 8000, 6000, 1024, '2025-10-16 00:00:00', 'Current User', NULL, 2000),
(77, '3', 'S3001234567', 'Chest X-Ray', 'Service', 15000, 0, 1, 15000, 12000, 1024, '2025-10-16 00:00:00', 'Current User', NULL, 3000),
(78, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1025, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(79, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1025, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(80, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1025, '2025-10-16 00:00:00', 'Current User', NULL, 1200),
(81, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1025, '2025-10-16 00:00:00', 'Current User', NULL, 1000),
(82, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 1, 16000, 12800, 1025, '2025-10-16 00:00:00', 'Current User', NULL, 3200),
(83, '4', 'S4005678901', 'Cardiac Ultrasound', 'Service', 40000, 0, 1, 40000, 32000, 1025, '2025-10-16 00:00:00', 'Current User', NULL, 8000),
(84, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 1, 2000, 1500, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 500),
(85, '2', 'S2001234567', 'Complete Blood Count (CBC)', 'Service', 8000, 0, 1, 8000, 6000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 2000),
(86, '3', 'S3001234567', 'Chest X-Ray', 'Service', 15000, 0, 1, 15000, 12000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 3000),
(87, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 1, 16000, 12800, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 3200),
(88, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 2, 8000, 5600, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 1200),
(89, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(90, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(91, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 1000),
(92, '1', '8850987180003', 'Vitamin C 1000mg', 'Retail', 200, 0, 1, 200, 100, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 100),
(93, '1', '8850987180001', 'Paracetamol 500mg', 'Retail', 100, 0, 1, 100, 50, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 50),
(94, '8', 'S8003456789', 'CPR Service', 'Service', 25000, 0, 1, 25000, 20000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(95, '6', 'S6003456789', 'COVID-19 Vaccine', 'Service', 5000, 0, 1, 5000, 5000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 0),
(96, '17', '12212122', 'kkk', 'Retail', 6000, 0, 1, 6000, 1000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(97, '3', 'S3004567890', 'Dental X-Ray', 'Service', 12000, 0, 1, 12000, 9500, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 2500),
(98, '9', 'S9005678901', 'Drug Interaction Check', 'Service', 4000, 0, 1, 4000, 3000, 1026, '2025-10-16 00:00:00', 'Current User', NULL, 1000),
(99, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1027, '2025-10-16 00:00:00', 'Current User', NULL, 1000),
(100, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1027, '2025-10-16 00:00:00', 'Current User', NULL, 1200);

INSERT INTO `tbl_sale` (`id`, `cat_id`, `Barcode`, `Name`, `SaleType`, `SalePrice`, `dis`, `Qty`, `Total`, `Profit`, `VNo`, `Date`, `Cashier`, `Refer`, `cost_price`) VALUES
(101, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 1, 16000, 12800, 1027, '2025-10-16 00:00:00', 'Current User', NULL, 3200),
(102, '3', 'S3001234567', 'Chest X-Ray', 'Service', 15000, 0, 2, 30000, 24000, 1027, '2025-10-16 00:00:00', 'Current User', NULL, 3000),
(103, '4', 'S4005678901', 'Cardiac Ultrasound', 'Service', 40000, 0, 1, 40000, 32000, 1027, '2025-10-16 00:00:00', 'Current User', NULL, 8000),
(104, '1', '8850987180003', 'Vitamin C 1000mg', 'Retail', 200, 0, 1, 200, 100, 1027, '2025-10-16 00:00:00', 'Current User', NULL, 100),
(105, '8', 'S8003456789', 'CPR Service', 'Service', 25000, 0, 1, 25000, 20000, 1027, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(106, '6', 'S6003456789', 'COVID-19 Vaccine', 'Service', 5000, 0, 2, 10000, 10000, 1027, '2025-10-16 00:00:00', 'Current User', NULL, 0),
(107, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1028, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(108, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1028, '2025-10-16 00:00:00', 'Current User', NULL, 1000),
(109, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1028, '2025-10-16 00:00:00', 'Current User', NULL, 1200),
(110, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 1, 16000, 12800, 1028, '2025-10-16 00:00:00', 'Current User', NULL, 3200),
(111, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(112, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(113, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 1200),
(114, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 1000),
(115, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 1, 16000, 12800, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 3200),
(116, '4', 'S4005678901', 'Cardiac Ultrasound', 'Service', 40000, 0, 1, 40000, 32000, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 8000),
(117, '3', 'S3001234567', 'Chest X-Ray', 'Service', 15000, 0, 1, 15000, 12000, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 3000),
(118, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 2, 4000, 3000, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 500),
(119, '2', 'S2001234567', 'Complete Blood Count (CBC)', 'Service', 8000, 0, 1, 8000, 6000, 1029, '2025-10-16 00:00:00', 'Current User', NULL, 2000),
(120, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1030, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(121, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1030, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(122, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 1, 16000, 12800, 1030, '2025-10-16 00:00:00', 'Current User', NULL, 3200),
(123, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1031, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(124, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1031, '2025-10-16 00:00:00', 'Current User', NULL, 5000),
(125, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1031, '2025-10-16 00:00:00', 'Current User', NULL, 3500),
(126, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 1, 16000, 12800, 1031, '2025-10-16 00:00:00', 'Current User', NULL, 3200),
(127, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1031, '2025-10-16 00:00:00', 'Current User', NULL, 1200),
(128, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1032, '2025-10-16 00:00:00', 'Current User', NULL, 3500),
(129, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 33, 0, 1, 33, 0, 1032, '2025-10-16 00:00:00', 'Current User', NULL, 33),
(130, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1033, '2025-10-17 00:00:00', 'Current User', NULL, 5000),
(131, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 4, 100000, 80000, 1033, '2025-10-17 00:00:00', 'Current User', NULL, 5000),
(132, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 2, 36000, 29000, 1033, '2025-10-17 00:00:00', 'Current User', NULL, 3500),
(133, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 33, 0, 2, 66, 0, 1033, '2025-10-17 00:00:00', 'Current User', NULL, 33),
(134, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1034, '2025-10-17 00:00:00', 'Current User', NULL, 5000),
(135, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1034, '2025-10-17 00:00:00', 'Current User', NULL, 5000),
(136, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1034, '2025-10-17 00:00:00', 'Current User', NULL, 1200),
(137, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1034, '2025-10-17 00:00:00', 'Current User', NULL, 1000),
(138, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 2, 4000, 3000, 1035, '2025-10-17 00:00:00', 'Current User', NULL, 500),
(139, '9', 'S9005678901', 'Drug Interaction Check', 'Service', 4000, 0, 1, 4000, 3000, 1035, '2025-10-17 00:00:00', 'Current User', NULL, 1000),
(140, '3', 'S3004567890', 'Dental X-Ray', 'Service', 12000, 0, 1, 12000, 9500, 1035, '2025-10-17 00:00:00', 'Current User', NULL, 2500),
(141, '2', 'S2014567890', 'Dengue Test', 'Service', 12000, 0, 1, 12000, 9000, 1035, '2025-10-17 00:00:00', 'Current User', NULL, 3000),
(142, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1035, '2025-10-17 00:00:00', 'Current User', NULL, 5000),
(143, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1035, '2025-10-17 00:00:00', 'Current User', NULL, 5000),
(144, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1036, '2025-10-19 00:00:00', 'Current User', NULL, 5000),
(145, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1036, '2025-10-19 00:00:00', 'Current User', NULL, 5000),
(146, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1036, '2025-10-19 00:00:00', 'Current User', NULL, 3500),
(147, '3', 'S3005678901', 'Bone X-Ray', 'Service', 16000, 0, 1, 16000, 12800, 1036, '2025-10-19 00:00:00', 'Current User', NULL, 3200),
(148, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1036, '2025-10-19 00:00:00', 'Current User', NULL, 1200),
(149, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1036, '2025-10-19 00:00:00', 'Current User', NULL, 1000),
(150, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 2, 50000, 40000, 1037, '2025-10-19 00:00:00', 'Current User', NULL, 5000),
(151, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 2, 50000, 40000, 1037, '2025-10-19 00:00:00', 'Current User', NULL, 5000),
(152, '2', 'S2002345678', 'Blood Sugar Test', 'Service', 5000, 0, 1, 5000, 4000, 1037, '2025-10-19 00:00:00', 'Current User', NULL, 1000),
(153, '2', 'S2011234567', 'Blood Type Test', 'Service', 4000, 0, 1, 4000, 2800, 1037, '2025-10-19 00:00:00', 'Current User', NULL, 1200),
(154, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1038, '2025-10-20 00:00:00', 'Current User', NULL, 5000),
(155, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1038, '2025-10-20 00:00:00', 'Current User', NULL, 5000),
(156, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1038, '2025-10-20 00:00:00', 'Current User', NULL, 3500),
(157, '7', 'S7001234567', 'Blood Pressure Monitoring', 'Service', 2000, 0, 1, 2000, 1500, 1038, '2025-10-20 00:00:00', 'Current User', NULL, 500),
(158, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 2, 50000, 40000, 1039, '2025-10-20 00:00:00', 'Current User', NULL, 5000),
(159, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 2, 50000, 40000, 1039, '2025-10-20 00:00:00', 'Current User', NULL, 5000),
(160, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 2, 36000, 29000, 1039, '2025-10-20 00:00:00', 'Current User', NULL, 3500),
(161, '1', '8850987180002', 'Amoxicillin 500mg', 'Retail', 33, 0, 1, 33, 0, 1040, '2025-10-21 00:00:00', 'Current User', NULL, 33),
(162, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1040, '2025-10-21 00:00:00', 'Current User', NULL, 3500),
(163, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1040, '2025-10-21 00:00:00', 'Current User', NULL, 5000),
(164, '4', 'S547959475', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1040, '2025-10-21 00:00:00', 'Current User', NULL, 5000),
(165, '3', 'S3002345678', 'Abdominal X-Ray', 'Service', 18000, 0, 1, 18000, 14500, 1041, '2025-10-21 00:00:00', 'Current User', NULL, 3500),
(166, '4', 'S4001234567', 'Abdominal Ultrasound', 'Service', 25000, 0, 1, 25000, 20000, 1041, '2025-10-21 00:00:00', 'Current User', NULL, 5000);

-- Table: tbl_sale_archive
DROP TABLE IF EXISTS `tbl_sale_archive`;
CREATE TABLE `tbl_sale_archive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_draft
DROP TABLE IF EXISTS `tbl_sale_draft`;
CREATE TABLE `tbl_sale_draft` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_draft_no
DROP TABLE IF EXISTS `tbl_sale_draft_no`;
CREATE TABLE `tbl_sale_draft_no` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_package
DROP TABLE IF EXISTS `tbl_sale_package`;
CREATE TABLE `tbl_sale_package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_package_no
DROP TABLE IF EXISTS `tbl_sale_package_no`;
CREATE TABLE `tbl_sale_package_no` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_return
DROP TABLE IF EXISTS `tbl_sale_return`;
CREATE TABLE `tbl_sale_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `sale_price` double DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `total` double DEFAULT NULL,
  `profit` double DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `voucher_return_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_return_item
DROP TABLE IF EXISTS `tbl_sale_return_item`;
CREATE TABLE `tbl_sale_return_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `sale_price` double DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `total` double DEFAULT NULL,
  `profit` double DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `vno` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_sale_return_item
INSERT INTO `tbl_sale_return_item` (`id`, `cat_id`, `barcode`, `name`, `sale_price`, `qty`, `total`, `profit`, `remark`, `date`, `vno`) VALUES
(1, '4', 'S547959475', 'Abdominal Ultrasound', 25000, 1, 25000, NULL, 'tedd', '2025-10-19 00:00:00', 1),
(2, '4', 'S547959475', 'Abdominal Ultrasound', 25000, 2, 50000, NULL, 'test return by ko ko', '2025-10-20 00:00:00', 2),
(3, '4', 'S4001234567', 'Abdominal Ultrasound', 25000, 2, 50000, NULL, 'test return by ko ko', '2025-10-20 00:00:00', 2),
(4, '2', 'S2002345678', 'Blood Sugar Test', 5000, 1, 5000, NULL, 'test return by ko ko', '2025-10-20 00:00:00', 2);

-- Table: tbl_service
DROP TABLE IF EXISTS `tbl_service`;
CREATE TABLE `tbl_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `barcode` varchar(50) NOT NULL,
  `service_name` varchar(50) NOT NULL,
  `cat_id` varchar(50) NOT NULL,
  `buy_price` int(11) NOT NULL,
  `sale_price` int(11) NOT NULL,
  `remark` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=237 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_service
INSERT INTO `tbl_service` (`id`, `barcode`, `service_name`, `cat_id`, `buy_price`, `sale_price`, `remark`) VALUES
(1, 'S1001234567', 'General Doctor Consultation', '1', 5000, 15000, 'Basic medical consultation and examination'),
(2, 'S1002345678', 'Specialist Consultation', '1', 8000, 25000, 'Consultation with medical specialist'),
(3, 'S1003456789', 'Follow-up Consultation', '1', 3000, 10000, 'Follow-up appointment after treatment'),
(4, 'S1004567890', 'Emergency Consultation', '1', 10000, 35000, '24/7 emergency medical consultation'),
(5, 'S1005678901', 'Pediatric Consultation', '1', 6000, 20000, 'Specialized consultation for children'),
(6, 'S2001234567', 'Complete Blood Count (CBC)', '2', 2000, 8000, 'Full blood analysis and cell count'),
(7, 'S2002345678', 'Blood Sugar Test', '2', 1000, 5000, 'Glucose level measurement'),
(8, 'S2003456789', 'Lipid Profile', '2', 2500, 10000, 'Cholesterol and triglyceride test'),
(9, 'S2004567890', 'Liver Function Test', '2', 3000, 12000, 'Liver enzyme and function analysis'),
(10, 'S2005678901', 'Kidney Function Test', '2', 2800, 11000, 'Creatinine and BUN test'),
(11, 'S2006789012', 'Thyroid Function Test', '2', 3500, 15000, 'TSH, T3, T4 hormone levels'),
(12, 'S2007890123', 'Urine Analysis', '2', 800, 3000, 'Complete urine examination'),
(13, 'S2008901234', 'Hepatitis B Test', '2', 4000, 18000, 'Hepatitis B surface antigen test'),
(14, 'S2009012345', 'HIV Test', '2', 5000, 20000, 'HIV antibody screening test'),
(15, 'S2010123456', 'Pregnancy Test', '2', 1500, 6000, 'Beta HCG pregnancy test'),
(16, 'S2011234567', 'Blood Type Test', '2', 1200, 4000, 'ABO blood group determination'),
(17, 'S2012345678', 'ESR Test', '2', 1000, 4500, 'Erythrocyte sedimentation rate'),
(18, 'S2013456789', 'Malaria Test', '2', 1500, 6000, 'Malaria parasite detection'),
(19, 'S2014567890', 'Dengue Test', '2', 3000, 12000, 'Dengue fever diagnostic test'),
(20, 'S2015678901', 'Tuberculosis Test', '2', 2500, 10000, 'TB bacterial detection test'),
(21, 'S3001234567', 'Chest X-Ray', '3', 3000, 15000, 'Standard chest radiography'),
(23, 'S3003456789', 'Spine X-Ray', '3', 4000, 20000, 'Spinal column X-ray examination'),
(24, 'S3004567890', 'Dental X-Ray', '3', 2500, 12000, 'Dental and jaw X-ray imaging'),
(25, 'S3005678901', 'Bone X-Ray', '3', 3200, 16000, 'Bone fracture and joint X-ray'),
(26, 'S3006789012', 'Skull X-Ray', '3', 3800, 19000, 'Cranial and facial X-ray'),
(27, 'S3007890123', 'Pelvis X-Ray', '3', 3600, 18000, 'Pelvic bone X-ray examination'),
(28, 'S547959475', 'Abdominal Ultrasound', '4', 5000, 25000, 'Ultrasound scan of abdominal organs'),
(29, 'S4002345678', 'Pregnancy Ultrasound', '4', 6000, 30000, 'Prenatal ultrasound examination'),
(30, 'S4003456789', 'Pelvic Ultrasound', '4', 5500, 28000, 'Pelvic region ultrasound scan'),
(31, 'S4004567890', 'Thyroid Ultrasound', '4', 4500, 22000, 'Thyroid gland ultrasound'),
(32, 'S4005678901', 'Cardiac Ultrasound', '4', 8000, 40000, 'Heart ultrasound examination'),
(33, 'S5001234567', 'Resting ECG', '5', 2000, 8000, '12-lead electrocardiogram at rest'),
(34, 'S5002345678', 'Exercise Stress Test', '5', 8000, 35000, 'ECG during physical exercise'),
(35, 'S5003456789', 'Holter Monitor (24hr)', '5', 15000, 60000, '24-hour continuous ECG monitoring'),
(36, 'S5004567890', 'ECG Analysis Report', '5', 1000, 5000, 'Professional ECG interpretation'),
(37, 'S6001234567', 'Hepatitis B Vaccine', '6', 8000, 20000, 'Hepatitis B immunization shot'),
(38, 'S6002345678', 'Flu Vaccine', '6', 5000, 15000, 'Annual influenza vaccination'),
(39, 'S6003456789', 'COVID-19 Vaccine', '6', 0, 5000, 'COVID-19 immunization'),
(40, 'S6004567890', 'Tetanus Vaccine', '6', 3000, 10000, 'Tetanus immunization shot'),
(41, 'S6005678901', 'Pneumonia Vaccine', '6', 12000, 30000, 'Pneumococcal vaccination'),
(42, 'S6006789012', 'Measles Vaccine', '6', 6000, 18000, 'Measles immunization'),
(43, 'S6007890123', 'Rubella Vaccine', '6', 7000, 19000, 'Rubella immunization shot'),
(44, 'S7001234567', 'Blood Pressure Monitoring', '7', 500, 2000, 'Blood pressure measurement and monitoring'),
(45, 'S7002345678', 'Wound Dressing', '7', 1000, 5000, 'Professional wound cleaning and dressing'),
(46, 'S7003456789', 'Injection Administration', '7', 800, 3000, 'Intramuscular or intravenous injection'),
(47, 'S7004567890', 'Suture Removal', '7', 1200, 5000, 'Safe removal of surgical sutures'),
(48, 'S7005678901', 'IV Drip Administration', '7', 2000, 8000, 'Intravenous fluid administration'),
(49, 'S7006789012', 'Minor Surgery', '7', 15000, 50000, 'Minor surgical procedures'),
(50, 'S7007890123', 'Ear Cleaning', '7', 800, 3500, 'Professional ear wax removal'),
(51, 'S7008901234', 'Physical Examination', '7', 2000, 8000, 'Complete physical health examination'),
(52, 'S8001234567', 'Emergency Treatment', '8', 10000, 40000, '24/7 emergency medical care'),
(53, 'S8002345678', 'Trauma Care', '8', 15000, 60000, 'Emergency trauma treatment'),
(54, 'S8003456789', 'CPR Service', '8', 5000, 25000, 'Cardiopulmonary resuscitation'),
(55, 'S8004567890', 'First Aid Treatment', '8', 2000, 8000, 'Basic first aid medical treatment'),
(56, 'S9001234567', 'Medicine Home Delivery', '9', 1000, 3000, 'Home delivery for medicines'),
(57, 'S9002345678', 'Medication Counseling', '9', 2000, 8000, 'Professional medication guidance'),
(58, 'S9003456789', 'Prescription Review', '9', 1500, 5000, 'Pharmacist prescription review'),
(59, 'S9004567890', 'Medicine Packaging', '9', 500, 2000, 'Weekly/monthly medicine packaging'),
(60, 'S9005678901', 'Drug Interaction Check', '9', 1000, 4000, 'Check for medication interactions'),
(61, 'S0001234567', 'Medical Certificate', '10', 500, 3000, 'Official medical fitness certificate'),
(62, 'S0002345678', 'Health Record Copy', '10', 200, 1000, 'Copy of patient medical records'),
(63, 'S0003456789', 'Insurance Form Processing', '10', 800, 3500, 'Medical insurance form completion'),
(64, 'S0004567890', 'Referral Letter', '10', 300, 1500, 'Medical referral to specialist'),
(65, 'S0005678901', 'Medical Report', '10', 1000, 5000, 'Detailed medical examination report'),
(66, 'S1001234567', 'General Doctor Consultation', '1', 5000, 15000, 'Basic medical consultation and examination'),
(67, 'S1002345678', 'Specialist Consultation', '1', 8000, 25000, 'Consultation with medical specialist'),
(68, 'S1003456789', 'Follow-up Consultation', '1', 3000, 10000, 'Follow-up appointment after treatment'),
(69, 'S1004567890', 'Emergency Consultation', '1', 10000, 35000, '24/7 emergency medical consultation'),
(70, 'S1005678901', 'Pediatric Consultation', '1', 6000, 20000, 'Specialized consultation for children'),
(71, 'S2001234567', 'Complete Blood Count (CBC)', '2', 2000, 8000, 'Full blood analysis and cell count'),
(72, 'S2002345678', 'Blood Sugar Test', '2', 1000, 5000, 'Glucose level measurement'),
(73, 'S2003456789', 'Lipid Profile', '2', 2500, 10000, 'Cholesterol and triglyceride test'),
(74, 'S2004567890', 'Liver Function Test', '2', 3000, 12000, 'Liver enzyme and function analysis'),
(75, 'S2005678901', 'Kidney Function Test', '2', 2800, 11000, 'Creatinine and BUN test'),
(76, 'S2006789012', 'Thyroid Function Test', '2', 3500, 15000, 'TSH, T3, T4 hormone levels'),
(77, 'S2007890123', 'Urine Analysis', '2', 800, 3000, 'Complete urine examination'),
(78, 'S2008901234', 'Hepatitis B Test', '2', 4000, 18000, 'Hepatitis B surface antigen test'),
(79, 'S2009012345', 'HIV Test', '2', 5000, 20000, 'HIV antibody screening test'),
(80, 'S2010123456', 'Pregnancy Test', '2', 1500, 6000, 'Beta HCG pregnancy test'),
(81, 'S3001234567', 'Chest X-Ray', '3', 3000, 15000, 'Standard chest radiography'),
(82, 'S3002345678', 'Abdominal X-Ray', '3', 3500, 18000, 'Abdominal region X-ray imaging'),
(83, 'S3003456789', 'Spine X-Ray', '3', 4000, 20000, 'Spinal column X-ray examination'),
(84, 'S3004567890', 'Dental X-Ray', '3', 2500, 12000, 'Dental and jaw X-ray imaging'),
(85, 'S3005678901', 'Bone X-Ray', '3', 3200, 16000, 'Bone fracture and joint X-ray'),
(86, 'S4001234567', 'Abdominal Ultrasound', '4', 5000, 25000, 'Ultrasound scan of abdominal organs'),
(87, 'S4002345678', 'Pregnancy Ultrasound', '4', 6000, 30000, 'Prenatal ultrasound examination'),
(88, 'S4003456789', 'Pelvic Ultrasound', '4', 5500, 28000, 'Pelvic region ultrasound scan'),
(89, 'S4004567890', 'Thyroid Ultrasound', '4', 4500, 22000, 'Thyroid gland ultrasound'),
(90, 'S4005678901', 'Cardiac Ultrasound', '4', 8000, 40000, 'Heart ultrasound examination'),
(91, 'S5001234567', 'Resting ECG', '5', 2000, 8000, '12-lead electrocardiogram at rest'),
(92, 'S5002345678', 'Exercise Stress Test', '5', 8000, 35000, 'ECG during physical exercise'),
(93, 'S5003456789', 'Holter Monitor (24hr)', '5', 15000, 60000, '24-hour continuous ECG monitoring'),
(94, 'S6001234567', 'Hepatitis B Vaccine', '6', 8000, 20000, 'Hepatitis B immunization shot'),
(95, 'S6002345678', 'Flu Vaccine', '6', 5000, 15000, 'Annual influenza vaccination'),
(96, 'S6003456789', 'COVID-19 Vaccine', '6', 0, 5000, 'COVID-19 immunization'),
(97, 'S6004567890', 'Tetanus Vaccine', '6', 3000, 10000, 'Tetanus immunization shot'),
(98, 'S6005678901', 'Pneumonia Vaccine', '6', 12000, 30000, 'Pneumococcal vaccination'),
(99, 'S7001234567', 'Blood Pressure Monitoring', '7', 500, 2000, 'Blood pressure measurement and monitoring'),
(100, 'S7002345678', 'Wound Dressing', '7', 1000, 5000, 'Professional wound cleaning and dressing'),
(101, 'S7003456789', 'Injection Administration', '7', 800, 3000, 'Intramuscular or intravenous injection');

INSERT INTO `tbl_service` (`id`, `barcode`, `service_name`, `cat_id`, `buy_price`, `sale_price`, `remark`) VALUES
(102, 'S7004567890', 'Suture Removal', '7', 1200, 5000, 'Safe removal of surgical sutures'),
(103, 'S7005678901', 'IV Drip Administration', '7', 2000, 8000, 'Intravenous fluid administration'),
(104, 'S7006789012', 'Minor Surgery', '7', 15000, 50000, 'Minor surgical procedures'),
(105, 'S7007890123', 'Ear Cleaning', '7', 800, 3500, 'Professional ear wax removal'),
(106, 'S7008901234', 'Physical Examination', '7', 2000, 8000, 'Complete physical health examination'),
(107, 'S8001234567', 'Emergency Treatment', '8', 10000, 40000, '24/7 emergency medical care'),
(108, 'S8002345678', 'Trauma Care', '8', 15000, 60000, 'Emergency trauma treatment'),
(109, 'S8003456789', 'CPR Service', '8', 5000, 25000, 'Cardiopulmonary resuscitation'),
(110, 'S8004567890', 'First Aid Treatment', '8', 2000, 8000, 'Basic first aid medical treatment'),
(111, 'S9001234567', 'Medicine Home Delivery', '9', 1000, 3000, 'Free home delivery for medicines'),
(112, 'S9002345678', 'Medication Counseling', '9', 2000, 8000, 'Professional medication guidance'),
(113, 'S9003456789', 'Prescription Review', '9', 1500, 5000, 'Pharmacist prescription review'),
(114, 'S9004567890', 'Medicine Packaging', '9', 500, 2000, 'Weekly/monthly medicine packaging'),
(115, 'S9005678901', 'Drug Interaction Check', '9', 1000, 4000, 'Check for medication interactions'),
(116, 'S0001234567', 'Medical Certificate', '10', 500, 3000, 'Official medical fitness certificate'),
(117, 'S0002345678', 'Health Record Copy', '10', 200, 1000, 'Copy of patient medical records'),
(118, 'S0003456789', 'Insurance Form Processing', '10', 800, 3500, 'Medical insurance form completion'),
(119, 'S0004567890', 'Referral Letter', '10', 300, 1500, 'Medical referral to specialist'),
(120, 'S0005678901', 'Medical Report', '10', 1000, 5000, 'Detailed medical examination report'),
(121, 'S0006789012', 'Prescription Copy', '10', 200, 800, 'Copy of medical prescription'),
(122, 'S0007890123', 'Vaccination Certificate', '10', 300, 1500, 'Official vaccination record certificate'),
(123, 'S1001234567', 'General Doctor Consultation', '1', 5000, 15000, 'Basic medical consultation and examination'),
(124, 'S1002345678', 'Specialist Consultation', '1', 8000, 25000, 'Consultation with medical specialist'),
(125, 'S1003456789', 'Follow-up Consultation', '1', 3000, 10000, 'Follow-up appointment after treatment'),
(126, 'S1004567890', 'Emergency Consultation', '1', 10000, 35000, '24/7 emergency medical consultation'),
(127, 'S1005678901', 'Pediatric Consultation', '1', 6000, 20000, 'Specialized consultation for children'),
(128, 'S2001234567', 'Complete Blood Count (CBC)', '2', 2000, 8000, 'Full blood analysis and cell count'),
(129, 'S2002345678', 'Blood Sugar Test', '2', 1000, 5000, 'Glucose level measurement'),
(130, 'S2003456789', 'Lipid Profile', '2', 2500, 10000, 'Cholesterol and triglyceride test'),
(131, 'S2004567890', 'Liver Function Test', '2', 3000, 12000, 'Liver enzyme and function analysis'),
(132, 'S2005678901', 'Kidney Function Test', '2', 2800, 11000, 'Creatinine and BUN test'),
(133, 'S2006789012', 'Thyroid Function Test', '2', 3500, 15000, 'TSH, T3, T4 hormone levels'),
(134, 'S2007890123', 'Urine Analysis', '2', 800, 3000, 'Complete urine examination'),
(135, 'S2008901234', 'Hepatitis B Test', '2', 4000, 18000, 'Hepatitis B surface antigen test'),
(136, 'S2009012345', 'HIV Test', '2', 5000, 20000, 'HIV antibody screening test'),
(137, 'S2010123456', 'Pregnancy Test', '2', 1500, 6000, 'Beta HCG pregnancy test'),
(138, 'S3001234567', 'Chest X-Ray', '3', 3000, 15000, 'Standard chest radiography'),
(139, 'S3002345678', 'Abdominal X-Ray', '3', 3500, 18000, 'Abdominal region X-ray imaging'),
(140, 'S3003456789', 'Spine X-Ray', '3', 4000, 20000, 'Spinal column X-ray examination'),
(141, 'S3004567890', 'Dental X-Ray', '3', 2500, 12000, 'Dental and jaw X-ray imaging'),
(142, 'S3005678901', 'Bone X-Ray', '3', 3200, 16000, 'Bone fracture and joint X-ray'),
(143, 'S4001234567', 'Abdominal Ultrasound', '4', 5000, 25000, 'Ultrasound scan of abdominal organs'),
(144, 'S4002345678', 'Pregnancy Ultrasound', '4', 6000, 30000, 'Prenatal ultrasound examination'),
(145, 'S4003456789', 'Pelvic Ultrasound', '4', 5500, 28000, 'Pelvic region ultrasound scan'),
(146, 'S4004567890', 'Thyroid Ultrasound', '4', 4500, 22000, 'Thyroid gland ultrasound'),
(147, 'S4005678901', 'Cardiac Ultrasound', '4', 8000, 40000, 'Heart ultrasound examination'),
(148, 'S5001234567', 'Resting ECG', '5', 2000, 8000, '12-lead electrocardiogram at rest'),
(149, 'S5002345678', 'Exercise Stress Test', '5', 8000, 35000, 'ECG during physical exercise'),
(150, 'S5003456789', 'Holter Monitor (24hr)', '5', 15000, 60000, '24-hour continuous ECG monitoring'),
(151, 'S6001234567', 'Hepatitis B Vaccine', '6', 8000, 20000, 'Hepatitis B immunization shot'),
(152, 'S6002345678', 'Flu Vaccine', '6', 5000, 15000, 'Annual influenza vaccination'),
(153, 'S6003456789', 'COVID-19 Vaccine', '6', 0, 5000, 'COVID-19 immunization'),
(154, 'S6004567890', 'Tetanus Vaccine', '6', 3000, 10000, 'Tetanus immunization shot'),
(155, 'S6005678901', 'Pneumonia Vaccine', '6', 12000, 30000, 'Pneumococcal vaccination'),
(156, 'S7001234567', 'Blood Pressure Monitoring', '7', 500, 2000, 'Blood pressure measurement and monitoring'),
(157, 'S7002345678', 'Wound Dressing', '7', 1000, 5000, 'Professional wound cleaning and dressing'),
(158, 'S7003456789', 'Injection Administration', '7', 800, 3000, 'Intramuscular or intravenous injection'),
(159, 'S7004567890', 'Suture Removal', '7', 1200, 5000, 'Safe removal of surgical sutures'),
(160, 'S7005678901', 'IV Drip Administration', '7', 2000, 8000, 'Intravenous fluid administration'),
(161, 'S7006789012', 'Minor Surgery', '7', 15000, 50000, 'Minor surgical procedures'),
(162, 'S7007890123', 'Ear Cleaning', '7', 800, 3500, 'Professional ear wax removal'),
(163, 'S7008901234', 'Physical Examination', '7', 2000, 8000, 'Complete physical health examination'),
(164, 'S8001234567', 'Emergency Treatment', '8', 10000, 40000, '24/7 emergency medical care'),
(165, 'S8002345678', 'Trauma Care', '8', 15000, 60000, 'Emergency trauma treatment'),
(166, 'S8003456789', 'CPR Service', '8', 5000, 25000, 'Cardiopulmonary resuscitation'),
(167, 'S8004567890', 'First Aid Treatment', '8', 2000, 8000, 'Basic first aid medical treatment'),
(168, 'S9001234567', 'Medicine Home Delivery', '9', 1000, 3000, 'Free home delivery for medicines'),
(169, 'S9002345678', 'Medication Counseling', '9', 2000, 8000, 'Professional medication guidance'),
(170, 'S9003456789', 'Prescription Review', '9', 1500, 5000, 'Pharmacist prescription review'),
(171, 'S9004567890', 'Medicine Packaging', '9', 500, 2000, 'Weekly/monthly medicine packaging'),
(172, 'S9005678901', 'Drug Interaction Check', '9', 1000, 4000, 'Check for medication interactions'),
(173, 'S0001234567', 'Medical Certificate', '10', 500, 3000, 'Official medical fitness certificate'),
(174, 'S0002345678', 'Health Record Copy', '10', 200, 1000, 'Copy of patient medical records'),
(175, 'S0003456789', 'Insurance Form Processing', '10', 800, 3500, 'Medical insurance form completion'),
(176, 'S0004567890', 'Referral Letter', '10', 300, 1500, 'Medical referral to specialist'),
(177, 'S0005678901', 'Medical Report', '10', 1000, 5000, 'Detailed medical examination report'),
(178, 'S0006789012', 'Prescription Copy', '10', 200, 800, 'Copy of medical prescription'),
(179, 'S0007890123', 'Vaccination Certificate', '10', 300, 1500, 'Official vaccination record certificate'),
(180, 'S1001234567', 'General Doctor Consultation', '1', 5000, 15000, 'Basic medical consultation and examination'),
(181, 'S1002345678', 'Specialist Consultation', '1', 8000, 25000, 'Consultation with medical specialist'),
(182, 'S1003456789', 'Follow-up Consultation', '1', 3000, 10000, 'Follow-up appointment after treatment'),
(183, 'S1004567890', 'Emergency Consultation', '1', 10000, 35000, '24/7 emergency medical consultation'),
(184, 'S1005678901', 'Pediatric Consultation', '1', 6000, 20000, 'Specialized consultation for children'),
(185, 'S2001234567', 'Complete Blood Count (CBC)', '2', 2000, 8000, 'Full blood analysis and cell count'),
(186, 'S2002345678', 'Blood Sugar Test', '2', 1000, 5000, 'Glucose level measurement'),
(187, 'S2003456789', 'Lipid Profile', '2', 2500, 10000, 'Cholesterol and triglyceride test'),
(188, 'S2004567890', 'Liver Function Test', '2', 3000, 12000, 'Liver enzyme and function analysis'),
(189, 'S2005678901', 'Kidney Function Test', '2', 2800, 11000, 'Creatinine and BUN test'),
(190, 'S2006789012', 'Thyroid Function Test', '2', 3500, 15000, 'TSH, T3, T4 hormone levels'),
(191, 'S2007890123', 'Urine Analysis', '2', 800, 3000, 'Complete urine examination'),
(192, 'S2008901234', 'Hepatitis B Test', '2', 4000, 18000, 'Hepatitis B surface antigen test'),
(193, 'S2009012345', 'HIV Test', '2', 5000, 20000, 'HIV antibody screening test'),
(194, 'S2010123456', 'Pregnancy Test', '2', 1500, 6000, 'Beta HCG pregnancy test'),
(195, 'S3001234567', 'Chest X-Ray', '3', 3000, 15000, 'Standard chest radiography'),
(196, 'S3002345678', 'Abdominal X-Ray', '3', 3500, 18000, 'Abdominal region X-ray imaging'),
(197, 'S3003456789', 'Spine X-Ray', '3', 4000, 20000, 'Spinal column X-ray examination'),
(198, 'S3004567890', 'Dental X-Ray', '3', 2500, 12000, 'Dental and jaw X-ray imaging'),
(199, 'S3005678901', 'Bone X-Ray', '3', 3200, 16000, 'Bone fracture and joint X-ray'),
(200, 'S4001234567', 'Abdominal Ultrasound', '4', 5000, 25000, 'Ultrasound scan of abdominal organs'),
(201, 'S4002345678', 'Pregnancy Ultrasound', '4', 6000, 30000, 'Prenatal ultrasound examination');

INSERT INTO `tbl_service` (`id`, `barcode`, `service_name`, `cat_id`, `buy_price`, `sale_price`, `remark`) VALUES
(202, 'S4003456789', 'Pelvic Ultrasound', '4', 5500, 28000, 'Pelvic region ultrasound scan'),
(203, 'S4004567890', 'Thyroid Ultrasound', '4', 4500, 22000, 'Thyroid gland ultrasound'),
(204, 'S4005678901', 'Cardiac Ultrasound', '4', 8000, 40000, 'Heart ultrasound examination'),
(205, 'S5001234567', 'Resting ECG', '5', 2000, 8000, '12-lead electrocardiogram at rest'),
(206, 'S5002345678', 'Exercise Stress Test', '5', 8000, 35000, 'ECG during physical exercise'),
(207, 'S5003456789', 'Holter Monitor (24hr)', '5', 15000, 60000, '24-hour continuous ECG monitoring'),
(208, 'S6001234567', 'Hepatitis B Vaccine', '6', 8000, 20000, 'Hepatitis B immunization shot'),
(209, 'S6002345678', 'Flu Vaccine', '6', 5000, 15000, 'Annual influenza vaccination'),
(210, 'S6003456789', 'COVID-19 Vaccine', '6', 0, 5000, 'COVID-19 immunization'),
(211, 'S6004567890', 'Tetanus Vaccine', '6', 3000, 10000, 'Tetanus immunization shot'),
(212, 'S6005678901', 'Pneumonia Vaccine', '6', 12000, 30000, 'Pneumococcal vaccination'),
(213, 'S7001234567', 'Blood Pressure Monitoring', '7', 500, 2000, 'Blood pressure measurement and monitoring'),
(214, 'S7002345678', 'Wound Dressing', '7', 1000, 5000, 'Professional wound cleaning and dressing'),
(215, 'S7003456789', 'Injection Administration', '7', 800, 3000, 'Intramuscular or intravenous injection'),
(216, 'S7004567890', 'Suture Removal', '7', 1200, 5000, 'Safe removal of surgical sutures'),
(217, 'S7005678901', 'IV Drip Administration', '7', 2000, 8000, 'Intravenous fluid administration'),
(218, 'S7006789012', 'Minor Surgery', '7', 15000, 50000, 'Minor surgical procedures'),
(219, 'S7007890123', 'Ear Cleaning', '7', 800, 3500, 'Professional ear wax removal'),
(220, 'S7008901234', 'Physical Examination', '7', 2000, 8000, 'Complete physical health examination'),
(221, 'S8001234567', 'Emergency Treatment', '8', 10000, 40000, '24/7 emergency medical care'),
(222, 'S8002345678', 'Trauma Care', '8', 15000, 60000, 'Emergency trauma treatment'),
(223, 'S8003456789', 'CPR Service', '8', 5000, 25000, 'Cardiopulmonary resuscitation'),
(224, 'S8004567890', 'First Aid Treatment', '8', 2000, 8000, 'Basic first aid medical treatment'),
(225, 'S9001234567', 'Medicine Home Delivery', '9', 1000, 3000, 'Free home delivery for medicines'),
(226, 'S9002345678', 'Medication Counseling', '9', 2000, 8000, 'Professional medication guidance'),
(227, 'S9003456789', 'Prescription Review', '9', 1500, 5000, 'Pharmacist prescription review'),
(228, 'S9004567890', 'Medicine Packaging', '9', 500, 2000, 'Weekly/monthly medicine packaging'),
(229, 'S9005678901', 'Drug Interaction Check', '9', 1000, 4000, 'Check for medication interactions'),
(230, 'S0001234567', 'Medical Certificate', '10', 500, 3000, 'Official medical fitness certificate'),
(231, 'S0002345678', 'Health Record Copy', '10', 200, 1000, 'Copy of patient medical records'),
(232, 'S0003456789', 'Insurance Form Processing', '10', 800, 3500, 'Medical insurance form completion'),
(233, 'S0004567890', 'Referral Letter', '10', 300, 1500, 'Medical referral to specialist'),
(234, 'S0005678901', 'Medical Report', '10', 1000, 5000, 'Detailed medical examination report'),
(235, 'S0006789012', 'Prescription Copy', '10', 200, 800, 'Copy of medical prescription'),
(236, 'S0007890123', 'Vaccination Certificate', '10', 300, 1500, 'Official vaccination record certificate');

-- Table: tbl_service_catalog
DROP TABLE IF EXISTS `tbl_service_catalog`;
CREATE TABLE `tbl_service_catalog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_service_catalog
INSERT INTO `tbl_service_catalog` (`id`, `name`) VALUES
(1, 'Consultation'),
(2, 'Laboratory'),
(3, 'X-Ray'),
(4, 'Ultrasound'),
(5, 'ECG'),
(6, 'Vaccination'),
(7, 'Consultation'),
(8, 'Laboratory'),
(9, 'X-Ray'),
(10, 'Ultrasound'),
(11, 'ECG'),
(12, 'Vaccination'),
(13, 'Consultation'),
(14, 'Laboratory'),
(15, 'X-Ray'),
(16, 'Ultrasound'),
(17, 'ECG'),
(18, 'Vaccination'),
(19, 'Consultation'),
(20, 'Laboratory'),
(21, 'X-Ray'),
(22, 'Ultrasound'),
(23, 'ECG'),
(24, 'Vaccination'),
(25, 'Medical Procedures'),
(26, 'Emergency Care'),
(27, 'Pharmacy Services'),
(28, 'Administrative'),
(29, 'Consultation'),
(30, 'Laboratory'),
(31, 'X-Ray'),
(32, 'Ultrasound'),
(33, 'ECG'),
(34, 'Vaccination'),
(35, 'Medical Procedures'),
(36, 'Emergency Care'),
(37, 'Pharmacy Services'),
(38, 'Administrative'),
(39, 'Consultation'),
(40, 'Laboratory'),
(41, 'X-Ray'),
(42, 'Ultrasound'),
(43, 'ECG'),
(44, 'Vaccination'),
(45, 'Medical Procedures'),
(46, 'Emergency Care'),
(47, 'Pharmacy Services'),
(48, 'Administrative'),
(49, 'Consultation'),
(50, 'Laboratory'),
(51, 'X-Ray'),
(52, 'Ultrasound'),
(53, 'ECG'),
(54, 'Vaccination'),
(55, 'Medical Procedures'),
(56, 'Emergency Care'),
(57, 'Pharmacy Services'),
(58, 'Administrative');

-- Table: tbl_shopinfo
DROP TABLE IF EXISTS `tbl_shopinfo`;
CREATE TABLE `tbl_shopinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `address` varchar(500) DEFAULT NULL,
  `remark` varchar(250) DEFAULT NULL,
  `thanks` varchar(250) DEFAULT NULL,
  `photo` longblob DEFAULT NULL,
  `photo_path` varchar(255) DEFAULT NULL,
  `user_code` varchar(250) DEFAULT NULL,
  `product_code` varchar(250) DEFAULT NULL,
  `software_code` varchar(250) DEFAULT NULL,
  `printer_voucher_count` int(11) DEFAULT NULL,
  `printer` varchar(50) DEFAULT NULL,
  `currency` varchar(10) DEFAULT '$',
  `currency_symbol` varchar(10) DEFAULT '$',
  `currency_position` enum('before','after') DEFAULT 'before',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_shopinfo
INSERT INTO `tbl_shopinfo` (`id`, `name`, `type`, `ph_no`, `email`, `address`, `remark`, `thanks`, `photo`, `photo_path`, `user_code`, `product_code`, `software_code`, `printer_voucher_count`, `printer`, `currency`, `currency_symbol`, `currency_position`) VALUES
(1, 'အေးချမ်းသာယာ', 'Medical Center', '09261521111 , 09254741578', 'info@clinicpro.com', 'အမှတ်(၁၀)၊ ၄ လွှာ၊ဝေဠုဝန်လမ်းကျယ်၊ စမ်းချောင်း။ ', 'Open 24/7', 'Thank you for choosing Clinic Pro! Stay healthy!', NULL, '/uploads/logo/logo-1760626846837-340474023.jpg', 'Not registered', 'Not registered', 'Not registered', 1, 'A4', 'MMK', 'Ks', 'after');

-- Table: tbl_stock
DROP TABLE IF EXISTS `tbl_stock`;
CREATE TABLE `tbl_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` varchar(255) DEFAULT NULL,
  `cat_id_2` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  `sale_price_latli` int(11) DEFAULT NULL,
  `sale_price_latkar` int(11) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `alert_month` int(11) DEFAULT NULL,
  `alert_date` date DEFAULT NULL,
  `margin` double DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_stock_barcode` (`barcode`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_stock
INSERT INTO `tbl_stock` (`id`, `cat_id`, `cat_id_2`, `barcode`, `name`, `qty`, `qty_alert`, `unit_name`, `cost_price`, `sale_price_latli`, `sale_price_latkar`, `remark`, `expire_date`, `alert_month`, `alert_date`, `margin`, `image_path`) VALUES
(1, '1', NULL, '8850987180001', 'Paracetamol 500mg', 976, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(2, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 1106, 30, 'Capsule', 33, 33, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(3, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 791, 40, 'Tablet', 100, 200, 180, 'Immune support', NULL, NULL, NULL, NULL, NULL),
(4, '1', NULL, '8850987180001', 'Paracetamol 500mg', 975, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(5, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 1106, 30, 'Capsule', 33, 33, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(6, '1', NULL, '4712715394', 'Vitamin C 1000mg', 793, 10, 'Tablet', 100, 200, 200, 'Immune support', NULL, NULL, NULL, NULL, NULL),
(7, '1', NULL, '8850987180001', 'Paracetamol 500mg', 976, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(8, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 1115, 30, 'Capsule', 33, 33, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(9, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 794, 10, 'Tablet', 100, 200, 200, 'Immune support', NULL, NULL, NULL, NULL, NULL),
(10, '21', NULL, '8808231739997', 'Amoxilin', 500, 10, 'Box', 500, 800, 700, '', '2025-10-12 00:00:00', 3, '2025-07-12 00:00:00', 20, '/uploads/products/1771413914-Amoxicillin_125mg5ml-Oral-Suspension_100ml_FF2-1760269182758-978259884.png'),
(11, '17', NULL, '12212122', 'kkk', 197, 10, 'pc', 5000, 6000, 6000, '', NULL, NULL, NULL, NULL, NULL),
(12, '1', NULL, '8850987180001', 'Paracetamol 500mg', 998, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(13, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 1126, 30, 'Capsule', 33, 33, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(14, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 798, 40, 'Tablet', 100, 200, 180, 'Immune support', NULL, NULL, NULL, NULL, NULL),
(15, '1', NULL, '8850987180001', 'Paracetamol 500mg', 997, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(16, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 1105, 30, 'Capsule', 33, 33, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(17, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 798, 40, 'Tablet', 100, 200, 180, 'Immune support', NULL, NULL, NULL, NULL, NULL),
(18, '1', NULL, '8850987180001', 'Paracetamol 500mg', 993, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(19, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 1104, 30, 'Capsule', 33, 33, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(20, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 798, 40, 'Tablet', 100, 200, 180, 'Immune support', NULL, NULL, NULL, NULL, NULL);

-- Table: tbl_stock_expense
DROP TABLE IF EXISTS `tbl_stock_expense`;
CREATE TABLE `tbl_stock_expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `reason` varchar(250) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_supplier
DROP TABLE IF EXISTS `tbl_supplier`;
CREATE TABLE `tbl_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `shop` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `remark` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_supplier
INSERT INTO `tbl_supplier` (`id`, `name`, `ph_no`, `nrc_no`, `shop`, `address`, `date`, `remark`) VALUES
(1, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-12 00:00:00', 'Main pharmaceutical supplier'),
(2, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-12 00:00:00', 'Import medicines'),
(3, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-12 00:00:00', 'International supplier'),
(4, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-12 00:00:00', 'Local distributor'),
(5, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-12 00:00:00', 'National distributor'),
(6, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-12 00:00:00', 'Medical equipment'),
(7, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-12 00:00:00', 'Bulk supplier'),
(8, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-12 00:00:00', 'Generic medicines'),
(9, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-12 00:00:00', 'Fast delivery'),
(10, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-12 00:00:00', 'Competitive prices'),
(11, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-12 00:00:00', 'Main pharmaceutical supplier'),
(12, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-12 00:00:00', 'Import medicines'),
(13, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-12 00:00:00', 'International supplier'),
(14, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-12 00:00:00', 'Local distributor'),
(15, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-12 00:00:00', 'National distributor'),
(16, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-12 00:00:00', 'Medical equipment'),
(17, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-12 00:00:00', 'Bulk supplier'),
(18, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-12 00:00:00', 'Generic medicines'),
(19, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-12 00:00:00', 'Fast delivery'),
(20, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-12 00:00:00', 'Competitive prices'),
(21, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-14 00:00:00', 'Main pharmaceutical supplier'),
(22, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-14 00:00:00', 'Import medicines'),
(23, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-14 00:00:00', 'International supplier'),
(24, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-14 00:00:00', 'Local distributor'),
(25, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-14 00:00:00', 'National distributor'),
(26, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-14 00:00:00', 'Medical equipment'),
(27, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-14 00:00:00', 'Bulk supplier'),
(28, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-14 00:00:00', 'Generic medicines'),
(29, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-14 00:00:00', 'Fast delivery'),
(30, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-14 00:00:00', 'Competitive prices'),
(31, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-16 00:00:00', 'Main pharmaceutical supplier'),
(32, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-16 00:00:00', 'Import medicines'),
(33, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-16 00:00:00', 'International supplier'),
(34, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-16 00:00:00', 'Local distributor'),
(35, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-16 00:00:00', 'National distributor'),
(36, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-16 00:00:00', 'Medical equipment'),
(37, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-16 00:00:00', 'Bulk supplier'),
(38, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-16 00:00:00', 'Generic medicines'),
(39, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-16 00:00:00', 'Fast delivery'),
(40, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-16 00:00:00', 'Competitive prices'),
(41, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-16 00:00:00', 'Main pharmaceutical supplier'),
(42, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-16 00:00:00', 'Import medicines'),
(43, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-16 00:00:00', 'International supplier'),
(44, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-16 00:00:00', 'Local distributor'),
(45, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-16 00:00:00', 'National distributor'),
(46, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-16 00:00:00', 'Medical equipment'),
(47, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-16 00:00:00', 'Bulk supplier'),
(48, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-16 00:00:00', 'Generic medicines'),
(49, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-16 00:00:00', 'Fast delivery'),
(50, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-16 00:00:00', 'Competitive prices');

-- Table: tbl_supplier_debt
DROP TABLE IF EXISTS `tbl_supplier_debt`;
CREATE TABLE `tbl_supplier_debt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_surgery_schedules
DROP TABLE IF EXISTS `tbl_surgery_schedules`;
CREATE TABLE `tbl_surgery_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `or_id` int(11) NOT NULL,
  `patient_id` varchar(50) NOT NULL,
  `surgeon_id` int(11) NOT NULL,
  `anesthesiologist_id` int(11) DEFAULT NULL,
  `procedure_name` varchar(255) NOT NULL,
  `procedure_code` varchar(50) DEFAULT NULL,
  `scheduled_date` date NOT NULL,
  `scheduled_start_time` time NOT NULL,
  `scheduled_end_time` time DEFAULT NULL,
  `actual_start_time` datetime DEFAULT NULL,
  `actual_end_time` datetime DEFAULT NULL,
  `duration_minutes` int(11) DEFAULT NULL,
  `status` enum('Scheduled','In_Progress','Completed','Cancelled','Postponed') DEFAULT 'Scheduled',
  `priority` enum('Routine','Urgent','Emergency') DEFAULT 'Routine',
  `diagnosis` text DEFAULT NULL,
  `pre_op_notes` text DEFAULT NULL,
  `post_op_notes` text DEFAULT NULL,
  `complications` text DEFAULT NULL,
  `estimated_duration` int(11) NOT NULL COMMENT 'Estimated duration in minutes',
  `actual_duration` int(11) DEFAULT NULL COMMENT 'Actual duration in minutes',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_or_id` (`or_id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_surgeon` (`surgeon_id`),
  KEY `idx_scheduled_date` (`scheduled_date`),
  KEY `idx_status` (`status`),
  CONSTRAINT `tbl_surgery_schedules_ibfk_1` FOREIGN KEY (`or_id`) REFERENCES `tbl_operating_rooms` (`id`),
  CONSTRAINT `tbl_surgery_schedules_ibfk_2` FOREIGN KEY (`surgeon_id`) REFERENCES `tbl_doctor` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_surgery_sequence
DROP TABLE IF EXISTS `tbl_surgery_sequence`;
CREATE TABLE `tbl_surgery_sequence` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_schedule_number` int(11) DEFAULT 0,
  `year` int(11) DEFAULT year(curdate()),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_surgery_sequence
INSERT INTO `tbl_surgery_sequence` (`id`, `last_schedule_number`, `year`) VALUES
(1, 0, 2025);

-- Table: tbl_township
DROP TABLE IF EXISTS `tbl_township`;
CREATE TABLE `tbl_township` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_treatment
DROP TABLE IF EXISTS `tbl_treatment`;
CREATE TABLE `tbl_treatment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `chief_complaint` text DEFAULT NULL,
  `present_illness` text DEFAULT NULL,
  `Past_Diagnoses` text DEFAULT NULL,
  `Surgeries_Procedures` text DEFAULT NULL,
  `Hospitalizations` text DEFAULT NULL,
  `Current_Medications` text DEFAULT NULL,
  `Dosages` text DEFAULT NULL,
  `Allergen` text DEFAULT NULL,
  `Treatment_Type` text DEFAULT NULL,
  `diagnosis` text DEFAULT NULL,
  `prescription` text DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Voucher_id` varchar(50) DEFAULT NULL,
  `Recommendation` text DEFAULT NULL,
  `vital_signs` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_treatment_patient` (`patient_id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_treatment
INSERT INTO `tbl_treatment` (`id`, `patient_id`, `doctor_id`, `chief_complaint`, `present_illness`, `Past_Diagnoses`, `Surgeries_Procedures`, `Hospitalizations`, `Current_Medications`, `Dosages`, `Allergen`, `Treatment_Type`, `diagnosis`, `prescription`, `Date`, `Voucher_id`, `Recommendation`, `vital_signs`, `notes`) VALUES
(1, 'OPD-001', NULL, NULL, NULL, 'Seasonal Allergies', 'None', 'None', 'Paracetamol, Vitamin C', '500mg TID, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', NULL, NULL),
(2, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(3, 'OPD-003', NULL, NULL, NULL, 'Diabetes Type 2 (10 years)', 'None', 'None', 'Metformin, Glimepiride', '500mg BD, 2mg OD', 'Sulfa drugs', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', NULL, NULL),
(4, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(5, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(6, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(7, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(8, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(9, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(10, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-05 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(11, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(12, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(13, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(14, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(15, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(16, 'OPD-001', NULL, NULL, NULL, 'Seasonal Allergies', 'None', 'None', 'Paracetamol, Vitamin C', '500mg TID, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', NULL, NULL),
(17, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(18, 'OPD-003', NULL, NULL, NULL, 'Diabetes Type 2 (10 years)', 'None', 'None', 'Metformin, Glimepiride', '500mg BD, 2mg OD', 'Sulfa drugs', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', NULL, NULL),
(19, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(20, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(21, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(22, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(23, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(24, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(25, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(26, 'OPD-011', NULL, NULL, NULL, 'Hyperlipidemia', 'None', 'None', 'Atorvastatin, Omega-3', '20mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1011', 'Low fat diet, regular exercise, follow-up in 3 months', NULL, NULL),
(27, 'OPD-012', NULL, NULL, NULL, 'Hypothyroidism', 'None', 'None', 'Levothyroxine', '100mcg OD (morning)', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1012', 'Take on empty stomach, thyroid function test in 6 weeks', NULL, NULL),
(28, 'OPD-013', NULL, NULL, NULL, 'Ankle Sprain', 'None', 'None', 'Diclofenac, Ice therapy', '75mg BD, Apply 4x/day', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1013', 'RICE protocol, avoid weight bearing, follow-up in 1 week', NULL, NULL),
(29, 'OPD-014', NULL, NULL, NULL, 'Prenatal Care - 24 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium', '5mg OD, 60mg OD, 500mg BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1014', 'Regular antenatal checkups, balanced diet, adequate rest', NULL, NULL),
(30, 'OPD-015', NULL, NULL, NULL, 'Coronary Artery Disease', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin', '100mg OD, 75mg OD, 50mg BD, 20mg OD', 'NSAIDs', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1015', 'Cardiac rehab, stress test in 3 months, low cholesterol diet', NULL, NULL),
(31, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(32, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(33, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(34, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(35, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-05 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(36, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(37, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-08 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(38, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(39, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(40, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(41, 'OPD-001', NULL, NULL, NULL, 'URI resolved, mild cough persists', 'None', 'None', 'Dextromethorphan Syrup', '10ml TID', 'None Known', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1011', 'Complete cough syrup, return if fever develops', NULL, NULL),
(42, 'OPD-002', NULL, NULL, NULL, 'BP controlled, no complications', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-10-05 00:00:00', 'V-1012', 'Continue current medications, BP monitoring at home', NULL, NULL),
(43, 'OPD-003', NULL, NULL, NULL, 'HbA1c improved to 7.2%', 'None', 'None', 'Metformin, Glimepiride, Insulin Glargine', '500mg BD, 2mg OD, 10 units HS', 'Sulfa drugs', 'Follow-up', NULL, NULL, '2025-09-28 00:00:00', 'V-1013', 'Good control, continue regimen, next HbA1c in 3 months', NULL, NULL),
(44, 'OPD-006', NULL, NULL, NULL, 'Migraine frequency reduced', 'None', 'None', 'Propranolol, Magnesium', '40mg BD, 400mg OD', 'Aspirin', 'Follow-up', NULL, NULL, '2025-10-02 00:00:00', 'V-1014', 'Maintain stress diary, continue prophylaxis', NULL, NULL),
(45, 'OPD-007', NULL, NULL, NULL, 'Joint pain improved', 'None', 'None', 'Diclofenac, Glucosamine, Physiotherapy', '75mg BD, 500mg OD, 3x/week', 'None Known', 'Follow-up', NULL, NULL, '2025-10-07 00:00:00', 'V-1015', 'Continue therapy, consider intra-articular injection', NULL, NULL),
(46, 'OPD-001', NULL, NULL, NULL, 'Common Cold - New episode', 'None', 'None', 'Paracetamol, Cetirizine, Vitamin C', '500mg TID, 10mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-09-12 00:00:00', 'V-1016', 'Symptomatic treatment, adequate rest', NULL, NULL),
(47, 'OPD-002', NULL, NULL, NULL, 'Hypertension - Routine checkup', 'None', 'None', 'Amlodipine, Losartan, Aspirin', '5mg OD, 50mg OD, 100mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-13 00:00:00', 'V-1017', 'BP well controlled, continue medications', NULL, NULL),
(48, 'OPD-011', NULL, NULL, NULL, 'Lipid panel improved', 'None', 'None', 'Atorvastatin, Omega-3, Fenofibrate', '20mg OD, 1000mg OD, 145mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-07-14 00:00:00', 'V-1018', 'Excellent response, maintain lifestyle changes', NULL, NULL),
(49, 'OPD-012', NULL, NULL, NULL, 'TSH normalized', 'None', 'None', 'Levothyroxine', '100mcg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-31 00:00:00', 'V-1019', 'Optimal dose achieved, annual monitoring', NULL, NULL),
(50, 'OPD-015', NULL, NULL, NULL, 'Stable angina', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin, Isosorbide', '100mg OD, 75mg OD, 50mg BD, 20mg OD, 5mg BD', 'NSAIDs', 'Follow-up', NULL, NULL, '2025-09-21 00:00:00', 'V-1020', 'Exercise tolerance improved, continue cardiac rehab', NULL, NULL),
(51, 'OPD-013', NULL, NULL, NULL, 'Ankle fully healed', 'None', 'None', 'Stopped medications', 'None', 'None Known', 'Follow-up', NULL, NULL, '2025-09-28 00:00:00', 'V-1021', 'Gradual return to activities, strengthening exercises', NULL, NULL),
(52, 'OPD-014', NULL, NULL, NULL, 'Normal pregnancy progression - 28 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium, Vitamin D', '5mg OD, 60mg OD, 500mg BD, 1000 IU OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-14 00:00:00', 'V-1022', 'Ultrasound scheduled, glucose tolerance test done', NULL, NULL),
(53, 'OPD-008', NULL, NULL, NULL, 'Asthma well controlled', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Follow-up', NULL, NULL, '2025-09-27 00:00:00', 'V-1023', 'Peak flow monitoring, continue preventer', NULL, NULL),
(54, 'OPD-009', NULL, NULL, NULL, 'Eczema improved', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Follow-up', NULL, NULL, '2025-10-05 00:00:00', 'V-1024', 'Taper steroid cream, emollient use', NULL, NULL),
(55, 'OPD-004', NULL, NULL, NULL, 'Back pain recurrence', 'None', 'None', 'Diclofenac, Muscle Relaxant, Physiotherapy', '75mg BD, 1 tab TID, Daily sessions', 'None Known', 'Outpatient', NULL, NULL, '2025-09-22 00:00:00', 'V-1025', 'MRI scheduled, core strengthening exercises', NULL, NULL),
(56, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(57, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(58, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(59, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(60, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-05 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(61, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(62, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-08 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(63, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(64, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(65, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(66, 'IPD-001', NULL, NULL, NULL, 'Pneumonia resolving', 'None', 'Current admission', 'Oral Amoxicillin, Bromhexine', '500mg TID, 8mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2011', 'Ready for discharge tomorrow, complete oral antibiotics', NULL, NULL),
(67, 'IPD-003', NULL, NULL, NULL, 'Dengue - Platelets recovering', 'None', 'Current admission', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2012', 'Platelets 95k, continue monitoring, discharge in 2 days', NULL, NULL),
(68, 'IPD-005', NULL, NULL, NULL, 'Stroke - Rehabilitation progress', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel, Physiotherapy', '100mg OD, 40mg OD, 75mg OD, BD sessions', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2013', 'Motor function improving, continue intensive rehab', NULL, NULL),
(69, 'IPD-007', NULL, NULL, NULL, 'Fracture healing well', 'ORIF Left Femur', 'Current admission', 'Oral Cefuroxime, Tramadol', '500mg BD, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2014', 'X-ray shows good alignment, start partial weight bearing', NULL, NULL),
(70, 'IPD-010', NULL, NULL, NULL, 'Post-cholecystectomy recovery', 'Laparoscopic Cholecystectomy', 'Current admission', 'Oral Cefuroxime, Paracetamol', '500mg BD, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2015', 'Wound healing well, tolerating diet, discharge tomorrow', NULL, NULL),
(71, 'OPD-001', NULL, 'tes', 'testr', 'sdf', 'sdf', NULL, NULL, NULL, 'sdf', 'Surgery', 'st', 'sdfsdf', '2025-10-12 00:00:00', NULL, 'sdf', '{"bp":"120/80","temp":"98","pulse":"820","weight":"22"}', 'sdf'),
(72, 'OPD-001', NULL, NULL, NULL, 'Seasonal Allergies', 'None', 'None', 'Paracetamol, Vitamin C', '500mg TID, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', NULL, NULL),
(73, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(74, 'OPD-003', NULL, NULL, NULL, 'Diabetes Type 2 (10 years)', 'None', 'None', 'Metformin, Glimepiride', '500mg BD, 2mg OD', 'Sulfa drugs', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', NULL, NULL),
(75, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(76, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(77, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(78, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(79, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(80, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(81, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(82, 'OPD-011', NULL, NULL, NULL, 'Hyperlipidemia', 'None', 'None', 'Atorvastatin, Omega-3', '20mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1011', 'Low fat diet, regular exercise, follow-up in 3 months', NULL, NULL),
(83, 'OPD-012', NULL, NULL, NULL, 'Hypothyroidism', 'None', 'None', 'Levothyroxine', '100mcg OD (morning)', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1012', 'Take on empty stomach, thyroid function test in 6 weeks', NULL, NULL),
(84, 'OPD-013', NULL, NULL, NULL, 'Ankle Sprain', 'None', 'None', 'Diclofenac, Ice therapy', '75mg BD, Apply 4x/day', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1013', 'RICE protocol, avoid weight bearing, follow-up in 1 week', NULL, NULL),
(85, 'OPD-014', NULL, NULL, NULL, 'Prenatal Care - 24 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium', '5mg OD, 60mg OD, 500mg BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1014', 'Regular antenatal checkups, balanced diet, adequate rest', NULL, NULL),
(86, 'OPD-015', NULL, NULL, NULL, 'Coronary Artery Disease', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin', '100mg OD, 75mg OD, 50mg BD, 20mg OD', 'NSAIDs', 'Outpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-1015', 'Cardiac rehab, stress test in 3 months, low cholesterol diet', NULL, NULL),
(87, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(88, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(89, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(90, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(91, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(92, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(93, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(94, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(95, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(96, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(97, 'OPD-001', NULL, NULL, NULL, 'URI resolved, mild cough persists', 'None', 'None', 'Dextromethorphan Syrup', '10ml TID', 'None Known', 'Follow-up', NULL, NULL, '2025-10-11 00:00:00', 'V-1011', 'Complete cough syrup, return if fever develops', NULL, NULL),
(98, 'OPD-002', NULL, NULL, NULL, 'BP controlled, no complications', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-10-07 00:00:00', 'V-1012', 'Continue current medications, BP monitoring at home', NULL, NULL),
(99, 'OPD-003', NULL, NULL, NULL, 'HbA1c improved to 7.2%', 'None', 'None', 'Metformin, Glimepiride, Insulin Glargine', '500mg BD, 2mg OD, 10 units HS', 'Sulfa drugs', 'Follow-up', NULL, NULL, '2025-09-30 00:00:00', 'V-1013', 'Good control, continue regimen, next HbA1c in 3 months', NULL, NULL),
(100, 'OPD-006', NULL, NULL, NULL, 'Migraine frequency reduced', 'None', 'None', 'Propranolol, Magnesium', '40mg BD, 400mg OD', 'Aspirin', 'Follow-up', NULL, NULL, '2025-10-04 00:00:00', 'V-1014', 'Maintain stress diary, continue prophylaxis', NULL, NULL);

INSERT INTO `tbl_treatment` (`id`, `patient_id`, `doctor_id`, `chief_complaint`, `present_illness`, `Past_Diagnoses`, `Surgeries_Procedures`, `Hospitalizations`, `Current_Medications`, `Dosages`, `Allergen`, `Treatment_Type`, `diagnosis`, `prescription`, `Date`, `Voucher_id`, `Recommendation`, `vital_signs`, `notes`) VALUES
(101, 'OPD-007', NULL, NULL, NULL, 'Joint pain improved', 'None', 'None', 'Diclofenac, Glucosamine, Physiotherapy', '75mg BD, 500mg OD, 3x/week', 'None Known', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1015', 'Continue therapy, consider intra-articular injection', NULL, NULL),
(102, 'OPD-001', NULL, NULL, NULL, 'Common Cold - New episode', 'None', 'None', 'Paracetamol, Cetirizine, Vitamin C', '500mg TID, 10mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-09-14 00:00:00', 'V-1016', 'Symptomatic treatment, adequate rest', NULL, NULL),
(103, 'OPD-002', NULL, NULL, NULL, 'Hypertension - Routine checkup', 'None', 'None', 'Amlodipine, Losartan, Aspirin', '5mg OD, 50mg OD, 100mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-15 00:00:00', 'V-1017', 'BP well controlled, continue medications', NULL, NULL),
(104, 'OPD-011', NULL, NULL, NULL, 'Lipid panel improved', 'None', 'None', 'Atorvastatin, Omega-3, Fenofibrate', '20mg OD, 1000mg OD, 145mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-07-16 00:00:00', 'V-1018', 'Excellent response, maintain lifestyle changes', NULL, NULL),
(105, 'OPD-012', NULL, NULL, NULL, 'TSH normalized', 'None', 'None', 'Levothyroxine', '100mcg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-02 00:00:00', 'V-1019', 'Optimal dose achieved, annual monitoring', NULL, NULL),
(106, 'OPD-015', NULL, NULL, NULL, 'Stable angina', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin, Isosorbide', '100mg OD, 75mg OD, 50mg BD, 20mg OD, 5mg BD', 'NSAIDs', 'Follow-up', NULL, NULL, '2025-09-23 00:00:00', 'V-1020', 'Exercise tolerance improved, continue cardiac rehab', NULL, NULL),
(107, 'OPD-013', NULL, NULL, NULL, 'Ankle fully healed', 'None', 'None', 'Stopped medications', 'None', 'None Known', 'Follow-up', NULL, NULL, '2025-09-30 00:00:00', 'V-1021', 'Gradual return to activities, strengthening exercises', NULL, NULL),
(108, 'OPD-014', NULL, NULL, NULL, 'Normal pregnancy progression - 28 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium, Vitamin D', '5mg OD, 60mg OD, 500mg BD, 1000 IU OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-16 00:00:00', 'V-1022', 'Ultrasound scheduled, glucose tolerance test done', NULL, NULL),
(109, 'OPD-008', NULL, NULL, NULL, 'Asthma well controlled', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Follow-up', NULL, NULL, '2025-09-29 00:00:00', 'V-1023', 'Peak flow monitoring, continue preventer', NULL, NULL),
(110, 'OPD-009', NULL, NULL, NULL, 'Eczema improved', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Follow-up', NULL, NULL, '2025-10-07 00:00:00', 'V-1024', 'Taper steroid cream, emollient use', NULL, NULL),
(111, 'OPD-004', NULL, NULL, NULL, 'Back pain recurrence', 'None', 'None', 'Diclofenac, Muscle Relaxant, Physiotherapy', '75mg BD, 1 tab TID, Daily sessions', 'None Known', 'Outpatient', NULL, NULL, '2025-09-24 00:00:00', 'V-1025', 'MRI scheduled, core strengthening exercises', NULL, NULL),
(112, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(113, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(114, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(115, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(116, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(117, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(118, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(119, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(120, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(121, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(122, 'IPD-001', NULL, NULL, NULL, 'Pneumonia resolving', 'None', 'Current admission', 'Oral Amoxicillin, Bromhexine', '500mg TID, 8mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2011', 'Ready for discharge tomorrow, complete oral antibiotics', NULL, NULL),
(123, 'IPD-003', NULL, NULL, NULL, 'Dengue - Platelets recovering', 'None', 'Current admission', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2012', 'Platelets 95k, continue monitoring, discharge in 2 days', NULL, NULL),
(124, 'IPD-005', NULL, NULL, NULL, 'Stroke - Rehabilitation progress', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel, Physiotherapy', '100mg OD, 40mg OD, 75mg OD, BD sessions', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2013', 'Motor function improving, continue intensive rehab', NULL, NULL),
(125, 'IPD-007', NULL, NULL, NULL, 'Fracture healing well', 'ORIF Left Femur', 'Current admission', 'Oral Cefuroxime, Tramadol', '500mg BD, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2014', 'X-ray shows good alignment, start partial weight bearing', NULL, NULL),
(126, 'IPD-010', NULL, NULL, NULL, 'Post-cholecystectomy recovery', 'Laparoscopic Cholecystectomy', 'Current admission', 'Oral Cefuroxime, Paracetamol', '500mg BD, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2015', 'Wound healing well, tolerating diet, discharge tomorrow', NULL, NULL),
(127, 'IPD-003', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Consultation', NULL, NULL, '2025-10-14 00:00:00', NULL, NULL, NULL, NULL),
(128, 'OPD-001', NULL, NULL, NULL, 'Seasonal Allergies', 'None', 'None', 'Paracetamol, Vitamin C', '500mg TID, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', NULL, NULL),
(129, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(130, 'OPD-003', 7, '', '', 'Diabetes Type 2 (10 years)', 'None', NULL, NULL, NULL, 'Sulfa drugs', '', '', 'Paracetamol 500mg - TID - 5 days
Amoxicillin 500mg - TID - 7 days
Omeprazole 20mg - OD - 7 days
Azithromycin 500mg - OD - 3 days
Azithromycin 500mg - OD - 3 days', '2025-10-16 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', '{"bp":"","temp":"","pulse":"","weight":"","respiratory":"","spo2":"","height":"","bmi":""}', ''),
(131, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(132, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(133, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(134, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(135, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(136, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(137, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(138, 'OPD-011', NULL, NULL, NULL, 'Hyperlipidemia', 'None', 'None', 'Atorvastatin, Omega-3', '20mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1011', 'Low fat diet, regular exercise, follow-up in 3 months', NULL, NULL),
(139, 'OPD-012', NULL, NULL, NULL, 'Hypothyroidism', 'None', 'None', 'Levothyroxine', '100mcg OD (morning)', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1012', 'Take on empty stomach, thyroid function test in 6 weeks', NULL, NULL),
(140, 'OPD-013', NULL, NULL, NULL, 'Ankle Sprain', 'None', 'None', 'Diclofenac, Ice therapy', '75mg BD, Apply 4x/day', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1013', 'RICE protocol, avoid weight bearing, follow-up in 1 week', NULL, NULL),
(141, 'OPD-014', NULL, NULL, NULL, 'Prenatal Care - 24 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium', '5mg OD, 60mg OD, 500mg BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1014', 'Regular antenatal checkups, balanced diet, adequate rest', NULL, NULL),
(142, 'OPD-015', NULL, NULL, NULL, 'Coronary Artery Disease', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin', '100mg OD, 75mg OD, 50mg BD, 20mg OD', 'NSAIDs', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1015', 'Cardiac rehab, stress test in 3 months, low cholesterol diet', NULL, NULL),
(143, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(144, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(145, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(146, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(147, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(148, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(149, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(150, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(151, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(152, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(153, 'OPD-001', NULL, NULL, NULL, 'URI resolved, mild cough persists', 'None', 'None', 'Dextromethorphan Syrup', '10ml TID', 'None Known', 'Follow-up', NULL, NULL, '2025-10-13 00:00:00', 'V-1011', 'Complete cough syrup, return if fever develops', NULL, NULL),
(154, 'OPD-002', NULL, NULL, NULL, 'BP controlled, no complications', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1012', 'Continue current medications, BP monitoring at home', NULL, NULL),
(155, 'OPD-003', NULL, NULL, NULL, 'HbA1c improved to 7.2%', 'None', 'None', 'Metformin, Glimepiride, Insulin Glargine', '500mg BD, 2mg OD, 10 units HS', 'Sulfa drugs', 'Follow-up', NULL, NULL, '2025-10-02 00:00:00', 'V-1013', 'Good control, continue regimen, next HbA1c in 3 months', NULL, NULL),
(156, 'OPD-006', NULL, NULL, NULL, 'Migraine frequency reduced', 'None', 'None', 'Propranolol, Magnesium', '40mg BD, 400mg OD', 'Aspirin', 'Follow-up', NULL, NULL, '2025-10-06 00:00:00', 'V-1014', 'Maintain stress diary, continue prophylaxis', NULL, NULL),
(157, 'OPD-007', NULL, NULL, NULL, 'Joint pain improved', 'None', 'None', 'Diclofenac, Glucosamine, Physiotherapy', '75mg BD, 500mg OD, 3x/week', 'None Known', 'Follow-up', NULL, NULL, '2025-10-11 00:00:00', 'V-1015', 'Continue therapy, consider intra-articular injection', NULL, NULL),
(158, 'OPD-001', NULL, NULL, NULL, 'Common Cold - New episode', 'None', 'None', 'Paracetamol, Cetirizine, Vitamin C', '500mg TID, 10mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-09-16 00:00:00', 'V-1016', 'Symptomatic treatment, adequate rest', NULL, NULL),
(159, 'OPD-002', NULL, NULL, NULL, 'Hypertension - Routine checkup', 'None', 'None', 'Amlodipine, Losartan, Aspirin', '5mg OD, 50mg OD, 100mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-17 00:00:00', 'V-1017', 'BP well controlled, continue medications', NULL, NULL),
(160, 'OPD-011', NULL, NULL, NULL, 'Lipid panel improved', 'None', 'None', 'Atorvastatin, Omega-3, Fenofibrate', '20mg OD, 1000mg OD, 145mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-07-18 00:00:00', 'V-1018', 'Excellent response, maintain lifestyle changes', NULL, NULL),
(161, 'OPD-012', NULL, NULL, NULL, 'TSH normalized', 'None', 'None', 'Levothyroxine', '100mcg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-04 00:00:00', 'V-1019', 'Optimal dose achieved, annual monitoring', NULL, NULL),
(162, 'OPD-015', NULL, NULL, NULL, 'Stable angina', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin, Isosorbide', '100mg OD, 75mg OD, 50mg BD, 20mg OD, 5mg BD', 'NSAIDs', 'Follow-up', NULL, NULL, '2025-09-25 00:00:00', 'V-1020', 'Exercise tolerance improved, continue cardiac rehab', NULL, NULL),
(163, 'OPD-013', NULL, NULL, NULL, 'Ankle fully healed', 'None', 'None', 'Stopped medications', 'None', 'None Known', 'Follow-up', NULL, NULL, '2025-10-02 00:00:00', 'V-1021', 'Gradual return to activities, strengthening exercises', NULL, NULL),
(164, 'OPD-014', NULL, NULL, NULL, 'Normal pregnancy progression - 28 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium, Vitamin D', '5mg OD, 60mg OD, 500mg BD, 1000 IU OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-18 00:00:00', 'V-1022', 'Ultrasound scheduled, glucose tolerance test done', NULL, NULL),
(165, 'OPD-008', NULL, NULL, NULL, 'Asthma well controlled', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Follow-up', NULL, NULL, '2025-10-01 00:00:00', 'V-1023', 'Peak flow monitoring, continue preventer', NULL, NULL),
(166, 'OPD-009', NULL, NULL, NULL, 'Eczema improved', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1024', 'Taper steroid cream, emollient use', NULL, NULL),
(167, 'OPD-004', NULL, NULL, NULL, 'Back pain recurrence', 'None', 'None', 'Diclofenac, Muscle Relaxant, Physiotherapy', '75mg BD, 1 tab TID, Daily sessions', 'None Known', 'Outpatient', NULL, NULL, '2025-09-26 00:00:00', 'V-1025', 'MRI scheduled, core strengthening exercises', NULL, NULL),
(168, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(169, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(170, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(171, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(172, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(173, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(174, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(175, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(176, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(177, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(178, 'IPD-001', NULL, NULL, NULL, 'Pneumonia resolving', 'None', 'Current admission', 'Oral Amoxicillin, Bromhexine', '500mg TID, 8mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2011', 'Ready for discharge tomorrow, complete oral antibiotics', NULL, NULL),
(179, 'IPD-003', NULL, NULL, NULL, 'Dengue - Platelets recovering', 'None', 'Current admission', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-2012', 'Platelets 95k, continue monitoring, discharge in 2 days', NULL, NULL),
(180, 'IPD-005', NULL, NULL, NULL, 'Stroke - Rehabilitation progress', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel, Physiotherapy', '100mg OD, 40mg OD, 75mg OD, BD sessions', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2013', 'Motor function improving, continue intensive rehab', NULL, NULL),
(181, 'IPD-007', NULL, NULL, NULL, 'Fracture healing well', 'ORIF Left Femur', 'Current admission', 'Oral Cefuroxime, Tramadol', '500mg BD, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2014', 'X-ray shows good alignment, start partial weight bearing', NULL, NULL),
(182, 'IPD-010', NULL, NULL, NULL, 'Post-cholecystectomy recovery', 'Laparoscopic Cholecystectomy', 'Current admission', 'Oral Cefuroxime, Paracetamol', '500mg BD, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2015', 'Wound healing well, tolerating diet, discharge tomorrow', NULL, NULL),
(183, 'OPD-001', NULL, NULL, NULL, 'Seasonal Allergies', 'None', 'None', 'Paracetamol, Vitamin C', '500mg TID, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', NULL, NULL),
(184, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(185, 'OPD-003', NULL, NULL, NULL, 'Diabetes Type 2 (10 years)', 'None', 'None', 'Metformin, Glimepiride', '500mg BD, 2mg OD', 'Sulfa drugs', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', NULL, NULL),
(186, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(187, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(188, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(189, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(190, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(191, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(192, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(193, 'OPD-011', NULL, NULL, NULL, 'Hyperlipidemia', 'None', 'None', 'Atorvastatin, Omega-3', '20mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1011', 'Low fat diet, regular exercise, follow-up in 3 months', NULL, NULL),
(194, 'OPD-012', NULL, NULL, NULL, 'Hypothyroidism', 'None', 'None', 'Levothyroxine', '100mcg OD (morning)', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1012', 'Take on empty stomach, thyroid function test in 6 weeks', NULL, NULL),
(195, 'OPD-013', NULL, NULL, NULL, 'Ankle Sprain', 'None', 'None', 'Diclofenac, Ice therapy', '75mg BD, Apply 4x/day', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1013', 'RICE protocol, avoid weight bearing, follow-up in 1 week', NULL, NULL),
(196, 'OPD-014', NULL, NULL, NULL, 'Prenatal Care - 24 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium', '5mg OD, 60mg OD, 500mg BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1014', 'Regular antenatal checkups, balanced diet, adequate rest', NULL, NULL),
(197, 'OPD-015', NULL, NULL, NULL, 'Coronary Artery Disease', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin', '100mg OD, 75mg OD, 50mg BD, 20mg OD', 'NSAIDs', 'Outpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-1015', 'Cardiac rehab, stress test in 3 months, low cholesterol diet', NULL, NULL),
(198, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(199, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(200, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL);

INSERT INTO `tbl_treatment` (`id`, `patient_id`, `doctor_id`, `chief_complaint`, `present_illness`, `Past_Diagnoses`, `Surgeries_Procedures`, `Hospitalizations`, `Current_Medications`, `Dosages`, `Allergen`, `Treatment_Type`, `diagnosis`, `prescription`, `Date`, `Voucher_id`, `Recommendation`, `vital_signs`, `notes`) VALUES
(201, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(202, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(203, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(204, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(205, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(206, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(207, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(208, 'OPD-001', NULL, NULL, NULL, 'URI resolved, mild cough persists', 'None', 'None', 'Dextromethorphan Syrup', '10ml TID', 'None Known', 'Follow-up', NULL, NULL, '2025-10-13 00:00:00', 'V-1011', 'Complete cough syrup, return if fever develops', NULL, NULL),
(209, 'OPD-002', NULL, NULL, NULL, 'BP controlled, no complications', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1012', 'Continue current medications, BP monitoring at home', NULL, NULL),
(210, 'OPD-003', NULL, NULL, NULL, 'HbA1c improved to 7.2%', 'None', 'None', 'Metformin, Glimepiride, Insulin Glargine', '500mg BD, 2mg OD, 10 units HS', 'Sulfa drugs', 'Follow-up', NULL, NULL, '2025-10-02 00:00:00', 'V-1013', 'Good control, continue regimen, next HbA1c in 3 months', NULL, NULL),
(211, 'OPD-006', NULL, NULL, NULL, 'Migraine frequency reduced', 'None', 'None', 'Propranolol, Magnesium', '40mg BD, 400mg OD', 'Aspirin', 'Follow-up', NULL, NULL, '2025-10-06 00:00:00', 'V-1014', 'Maintain stress diary, continue prophylaxis', NULL, NULL),
(212, 'OPD-007', NULL, NULL, NULL, 'Joint pain improved', 'None', 'None', 'Diclofenac, Glucosamine, Physiotherapy', '75mg BD, 500mg OD, 3x/week', 'None Known', 'Follow-up', NULL, NULL, '2025-10-11 00:00:00', 'V-1015', 'Continue therapy, consider intra-articular injection', NULL, NULL),
(213, 'OPD-001', NULL, NULL, NULL, 'Common Cold - New episode', 'None', 'None', 'Paracetamol, Cetirizine, Vitamin C', '500mg TID, 10mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-09-16 00:00:00', 'V-1016', 'Symptomatic treatment, adequate rest', NULL, NULL),
(214, 'OPD-002', NULL, NULL, NULL, 'Hypertension - Routine checkup', 'None', 'None', 'Amlodipine, Losartan, Aspirin', '5mg OD, 50mg OD, 100mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-17 00:00:00', 'V-1017', 'BP well controlled, continue medications', NULL, NULL),
(215, 'OPD-011', NULL, NULL, NULL, 'Lipid panel improved', 'None', 'None', 'Atorvastatin, Omega-3, Fenofibrate', '20mg OD, 1000mg OD, 145mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-07-18 00:00:00', 'V-1018', 'Excellent response, maintain lifestyle changes', NULL, NULL),
(216, 'OPD-012', NULL, NULL, NULL, 'TSH normalized', 'None', 'None', 'Levothyroxine', '100mcg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-04 00:00:00', 'V-1019', 'Optimal dose achieved, annual monitoring', NULL, NULL),
(217, 'OPD-015', NULL, NULL, NULL, 'Stable angina', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin, Isosorbide', '100mg OD, 75mg OD, 50mg BD, 20mg OD, 5mg BD', 'NSAIDs', 'Follow-up', NULL, NULL, '2025-09-25 00:00:00', 'V-1020', 'Exercise tolerance improved, continue cardiac rehab', NULL, NULL),
(218, 'OPD-013', NULL, NULL, NULL, 'Ankle fully healed', 'None', 'None', 'Stopped medications', 'None', 'None Known', 'Follow-up', NULL, NULL, '2025-10-02 00:00:00', 'V-1021', 'Gradual return to activities, strengthening exercises', NULL, NULL),
(219, 'OPD-014', NULL, NULL, NULL, 'Normal pregnancy progression - 28 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium, Vitamin D', '5mg OD, 60mg OD, 500mg BD, 1000 IU OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-18 00:00:00', 'V-1022', 'Ultrasound scheduled, glucose tolerance test done', NULL, NULL),
(220, 'OPD-008', NULL, NULL, NULL, 'Asthma well controlled', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Follow-up', NULL, NULL, '2025-10-01 00:00:00', 'V-1023', 'Peak flow monitoring, continue preventer', NULL, NULL),
(221, 'OPD-009', NULL, NULL, NULL, 'Eczema improved', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1024', 'Taper steroid cream, emollient use', NULL, NULL),
(222, 'OPD-004', NULL, NULL, NULL, 'Back pain recurrence', 'None', 'None', 'Diclofenac, Muscle Relaxant, Physiotherapy', '75mg BD, 1 tab TID, Daily sessions', 'None Known', 'Outpatient', NULL, NULL, '2025-09-26 00:00:00', 'V-1025', 'MRI scheduled, core strengthening exercises', NULL, NULL),
(223, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(224, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(225, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(226, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(227, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(228, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(229, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(230, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(231, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-14 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(232, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(233, 'IPD-001', NULL, NULL, NULL, 'Pneumonia resolving', 'None', 'Current admission', 'Oral Amoxicillin, Bromhexine', '500mg TID, 8mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2011', 'Ready for discharge tomorrow, complete oral antibiotics', NULL, NULL),
(234, 'IPD-003', NULL, NULL, NULL, 'Dengue - Platelets recovering', 'None', 'Current admission', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-16 00:00:00', 'V-2012', 'Platelets 95k, continue monitoring, discharge in 2 days', NULL, NULL),
(235, 'IPD-005', NULL, NULL, NULL, 'Stroke - Rehabilitation progress', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel, Physiotherapy', '100mg OD, 40mg OD, 75mg OD, BD sessions', 'None Known', 'Inpatient', NULL, NULL, '2025-10-13 00:00:00', 'V-2013', 'Motor function improving, continue intensive rehab', NULL, NULL),
(236, 'IPD-007', NULL, NULL, NULL, 'Fracture healing well', 'ORIF Left Femur', 'Current admission', 'Oral Cefuroxime, Tramadol', '500mg BD, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2014', 'X-ray shows good alignment, start partial weight bearing', NULL, NULL),
(237, 'IPD-010', NULL, NULL, NULL, 'Post-cholecystectomy recovery', 'Laparoscopic Cholecystectomy', 'Current admission', 'Oral Cefuroxime, Paracetamol', '500mg BD, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-15 00:00:00', 'V-2015', 'Wound healing well, tolerating diet, discharge tomorrow', NULL, NULL),
(238, 'P000074', 1, 'General consultation', 'Patient presents for routine consultation.', 'Test Diagnoses', 'test Surgeries/Procedures', NULL, NULL, NULL, 'nothing Allergies', 'Consultation', 'General health assessment', '1. Health advice provided
2. Follow-up as needed
Amoxicillin 500mg - TID - 7 days
Paracetamol 500mg - TID - 5 days
Ibuprofen 400mg - BID - 3 days
Ibuprofen 400mg - BID - 3 days
Omeprazole 20mg - OD - 7 days
Cetirizine 10mg - OD - 5 days', '2025-10-23 00:00:00', NULL, 'Continue current lifestyle. Follow-up in 3 months for routine check.', '{"bp":"120/80","temp":"98.6","pulse":"72","weight":"70","respiratory":"16","spo2":"98","height":"170","bmi":"24.2 (Normal)"}', NULL),
(239, 'P000074', 1, 'General consultation', 'Patient presents for routine consultation.', NULL, NULL, NULL, NULL, NULL, NULL, 'Consultation', 'General health assessment', '1. Health advice provided
2. Follow-up as needed', '2025-10-23 00:00:00', NULL, 'Continue current lifestyle. Follow-up in 3 months for routine check.', '{"bp":"110/70","temp":"101","pulse":"78","weight":"65","respiratory":"22","spo2":"92","height":"170","bmi":"22.5 (Normal)"}', NULL);

-- Table: tbl_unit
DROP TABLE IF EXISTS `tbl_unit`;
CREATE TABLE `tbl_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit_name` varchar(50) DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_unit
INSERT INTO `tbl_unit` (`id`, `unit_name`, `remark`) VALUES
(1, 'Tablet', 'Per tablet'),
(2, 'Box', 'Per box'),
(3, 'Bottle', 'Per bottle'),
(4, 'Vial', 'Per vial'),
(5, 'Pack', 'Per pack'),
(6, 'Piece', 'Per piece'),
(7, 'Tablet', 'Per tablet'),
(8, 'Box', 'Per box'),
(9, 'Bottle', 'Per bottle'),
(10, 'Vial', 'Per vial'),
(11, 'Pack', 'Per pack'),
(12, 'Piece', 'Per piece'),
(13, 'Tablet', 'Per tablet'),
(14, 'Box', 'Per box'),
(15, 'Bottle', 'Per bottle'),
(16, 'Vial', 'Per vial'),
(17, 'Pack', 'Per pack'),
(18, 'Piece', 'Per piece'),
(19, 'Tablet', 'Per tablet'),
(20, 'Box', 'Per box'),
(21, 'Bottle', 'Per bottle'),
(22, 'Vial', 'Per vial'),
(23, 'Pack', 'Per pack'),
(24, 'Piece', 'Per piece'),
(25, 'Tablet', 'Per tablet'),
(26, 'Box', 'Per box'),
(27, 'Bottle', 'Per bottle'),
(28, 'Vial', 'Per vial'),
(29, 'Pack', 'Per pack'),
(30, 'Piece', 'Per piece'),
(31, 'Tablet', 'Per tablet'),
(32, 'Box', 'Per box'),
(33, 'Bottle', 'Per bottle'),
(34, 'Vial', 'Per vial'),
(35, 'Pack', 'Per pack'),
(36, 'Piece', 'Per piece');

-- Table: tbl_user
DROP TABLE IF EXISTS `tbl_user`;
CREATE TABLE `tbl_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` varchar(100) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `passwd` varchar(100) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `photo` longblob DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_user
INSERT INTO `tbl_user` (`id`, `role_id`, `name`, `passwd`, `ph_no`, `nrc_no`, `address`, `photo`, `date`) VALUES
(1, '1', 'admin', '$2a$10$1irptYeNDKFOXUNIFG4J.ulLfwCk49BnGZr/wsHIfZlwB0PT8w4ce', '09-123456789', '12/YGNXXX', 'Yangon', NULL, '2025-10-12 00:00:00');

-- Table: tbl_user_log
DROP TABLE IF EXISTS `tbl_user_log`;
CREATE TABLE `tbl_user_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) NOT NULL,
  `login_time` datetime DEFAULT NULL,
  `logout_time` datetime DEFAULT NULL,
  `total_sale` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_user_log
INSERT INTO `tbl_user_log` (`id`, `user_name`, `login_time`, `logout_time`, `total_sale`) VALUES
(1, 'admin', '2025-10-12 14:08:58', NULL, NULL),
(2, 'admin', '2025-10-12 14:11:19', '2025-10-12 14:15:07', NULL),
(3, 'admin', '2025-10-12 14:15:11', NULL, NULL),
(4, 'admin', '2025-10-19 09:27:03', NULL, NULL);

-- Table: tbl_voucher
DROP TABLE IF EXISTS `tbl_voucher`;
CREATE TABLE `tbl_voucher` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `doctor_name` varchar(100) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_doctor_id` (`doctor_id`),
  KEY `idx_patient_id` (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_voucher
INSERT INTO `tbl_voucher` (`id`, `user_name`, `sub_total`, `actual_cost`, `dis`, `tax`, `customer_name`, `Date`, `status`, `payment`, `doctor_id`, `doctor_name`, `patient_id`) VALUES
(1000, 'Current User', 650, 650, 0, 0, 'Walk-in', '2025-10-12 14:18:30', 1, 'Cash', NULL, NULL, NULL),
(1001, 'Current User', 8050, 8050, 0, 0, 'Walk-in', '2025-10-12 17:42:02', 1, 'Cash', NULL, NULL, NULL),
(1002, 'Current User', 900, 400, 500, 0, 'Walk-in', '2025-10-12 18:04:41', 1, 'CB Pay', NULL, NULL, NULL),
(1003, 'Current User', 8500, 8500, 0, 0, 'Daw Khin', '2025-10-14 20:21:13', 1, 'Cash', NULL, NULL, NULL),
(1004, 'Current User', 7350, 7350, 0, 0, 'Ma Hla', '2025-10-14 21:30:34', 1, 'Cash', NULL, NULL, NULL),
(1005, 'Current User', 68350, 68350, 0, 0, 'Ko Aung', '2025-10-14 21:39:17', 1, 'Cash', 1, 'Dr. Dr. Aung Aung', 43),
(1006, 'Current User', 43350, 38350, 5000, 0, 'Walk-in', '2025-10-14 21:45:04', 1, 'Cash', NULL, NULL, NULL),
(1007, 'Current User', 117500, 109500, 8000, 0, 'Daw Mya', '2025-10-14 21:56:49', 1, 'Cash', 1, 'Dr. Dr. Aung Aung', 42),
(1008, 'Current User', 50000, 50000, 0, 0, 'Ma Hla', '2025-10-16 19:22:03', 1, 'Cash', 1, 'Dr. Dr. Aung Aung', 40),
(1009, 'Current User', 50000, 50000, 0, 0, 'Ma Hla', '2025-10-16 19:26:10', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 55),
(1010, 'Current User', 50000, 50000, 0, 0, 'Ko Win', '2025-10-16 19:33:06', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 54),
(1011, 'Current User', 50000, 50000, 0, 0, 'Ma Hla', '2025-10-16 19:33:46', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 55),
(1012, 'Current User', 50000, 50000, 0, 0, 'Walk-in', '2025-10-16 19:44:32', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 55),
(1013, 'Current User', 50000, 50000, 0, 0, 'Walk-in', '2025-10-16 19:46:23', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 55),
(1014, 'Current User', 2833, 2833, 0, 0, 'Ma Hla', '2025-10-16 19:51:01', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 55),
(1015, 'Current User', 204132, 203567, 565, 0, 'U Myint', '2025-10-16 20:03:21', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 56),
(1016, 'Current User', 68000, 68000, 0, 0, 'U Myint', '2025-10-16 20:07:08', 1, 'KBZ Pay', 3, 'Dr. Dr. Kyaw Kyaw', 56),
(1017, 'Current User', 25066, 25066, 0, 0, 'U Myint', '2025-10-16 20:08:04', 1, 'KBZ Pay', 3, 'Dr. Dr. Kyaw Kyaw', 56),
(1018, 'Current User', 86000, 86000, 0, 0, 'Walk-in', '2025-10-16 20:09:56', 1, 'KBZ Pay', NULL, NULL, NULL),
(1019, 'Current User', 68000, 62200, 5800, 0, 'Ma Hla', '2025-10-16 21:18:49', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 55),
(1020, 'Current User', 2000, 2000, 0, 0, 'U Htun', '2025-10-16 21:43:12', 1, 'Cash', 1, 'Dr. Dr. Aung Aung', 52),
(1021, 'Current User', 50000, 50000, 0, 0, 'U Myint', '2025-10-16 21:46:47', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 56),
(1022, 'Current User', 168000, 168000, 0, 0, 'Ma Hla', '2025-10-16 21:47:11', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 55),
(1023, 'Current User', 118000, 118000, 0, 0, 'Walk-in', '2025-10-16 21:47:33', 1, 'Cash', NULL, NULL, NULL),
(1024, 'Current User', 82000, 82000, 0, 0, 'Daw Aye', '2025-10-16 21:52:51', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 49),
(1025, 'Current User', 115000, 115000, 0, 0, 'Walk-in', '2025-10-16 21:56:53', 1, 'CB Pay', NULL, NULL, NULL),
(1026, 'Current User', 156300, 156300, 0, 0, 'Daw Mya', '2025-10-16 21:57:53', 1, 'CB Pay', 3, 'Dr. Dr. Kyaw Kyaw', 57),
(1027, 'Current User', 130200, 130200, 0, 0, 'U Myint', '2025-10-16 21:59:04', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 56),
(1028, 'Current User', 50000, 50000, 0, 0, 'Walk-in', '2025-10-16 22:03:37', 1, 'KBZ Pay', NULL, NULL, NULL),
(1029, 'Current User', 142000, 137000, 5000, 0, 'Walk-in', '2025-10-16 22:08:42', 1, 'KBZ Pay', NULL, NULL, NULL),
(1030, 'Current User', 66000, 66000, 0, 0, 'U Myint', '2025-10-16 22:14:18', 1, 'KBZ Pay', 3, 'Dr. Dr. Kyaw Kyaw', 56),
(1031, 'Current User', 88000, 88000, 0, 0, 'U Htun', '2025-10-16 22:16:13', 1, 'KBZ Pay', 3, 'Dr. Dr. Kyaw Kyaw', 52),
(1032, 'Current User', 18033, 18033, 0, 0, 'Ko Win', '2025-10-16 23:24:52', 1, 'Cash', 1, 'Dr. Dr. Aung Aung', 54),
(1033, 'Current User', 161066, 160566, 500, 0, 'Ma Hla', '2025-10-17 19:09:58', 1, 'Cash', 1, 'Dr. Dr. Aung Aung', 55),
(1034, 'Current User', 59000, 59000, 0, 0, 'Ma Hla', '2025-10-17 19:10:33', 1, 'KBZ Pay', 3, 'Dr. Dr. Kyaw Kyaw', 55),
(1035, 'Current User', 82000, 81000, 1000, 0, 'U Myint', '2025-10-17 23:16:11', 1, 'KBZ Pay', 1, 'Dr. Dr. Aung Aung', 56),
(1036, 'Current User', 93000, 88000, 5000, 0, 'U Myint', '2025-10-19 09:16:04', 1, 'KBZ Pay', 3, 'Dr. Dr. Kyaw Kyaw', 56),
(1037, 'Current User', 109000, 109000, 0, 0, 'Walk-in', '2025-10-19 09:16:49', 1, 'KBZ Pay', 3, 'Dr. Dr. Kyaw Kyaw', 56),
(1038, 'Current User', 70000, 68000, 2000, 0, 'Ko Win', '2025-10-20 10:30:27', 1, 'Cash', 3, 'Dr. Dr. Kyaw Kyaw', 54),
(1039, 'Current User', 136000, 136000, 0, 0, 'Daw Khin', '2025-10-20 11:03:49', 1, 'KBZ Pay', 1, 'Dr. Dr. Aung Aung', 53),
(1040, 'Current User', 68033, 68033, 0, 0, 'Ko Win', '2025-10-21 14:49:03', 1, 'Bank Transfer', 1, 'Dr. Dr. Aung Aung', 54),
(1041, 'Current User', 43000, 43000, 0, 0, 'Ma Hla', '2025-10-21 16:35:01', 1, 'Bank Transfer', 1, 'Dr. Dr. Aung Aung', 55);

-- Table: tbl_voucher_archive
DROP TABLE IF EXISTS `tbl_voucher_archive`;
CREATE TABLE `tbl_voucher_archive` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `doctor_name` varchar(100) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_voucher_return
DROP TABLE IF EXISTS `tbl_voucher_return`;
CREATE TABLE `tbl_voucher_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `doctor_name` varchar(100) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_voucher_return
INSERT INTO `tbl_voucher_return` (`id`, `user_name`, `sub_total`, `actual_cost`, `dis`, `tax`, `customer_name`, `Date`, `status`, `payment`, `doctor_id`, `doctor_name`, `patient_id`) VALUES
(1, 'admin', 25000, 25000, 0, NULL, 'Return for Voucher #1036', '2025-10-19 23:08:26', 1, NULL, NULL, NULL, NULL),
(2, 'admin', 105000, 105000, 0, NULL, 'Return for Voucher #1037', '2025-10-20 09:38:05', 1, NULL, NULL, NULL, NULL);

SET FOREIGN_KEY_CHECKS=1;
