-- Add status column to appointments table
-- This allows tracking: scheduled, arrived, in-progress, completed, cancelled, no-show

ALTER TABLE tbl_appointment 
ADD COLUMN IF NOT EXISTS status VARCHAR(20) DEFAULT 'scheduled' 
COMMENT 'Status: scheduled, arrived, in-progress, completed, cancelled, no-show';

-- Update existing appointments to have default status
UPDATE tbl_appointment SET status = 'scheduled' WHERE status IS NULL OR status = '';

-- Add index for faster status queries
ALTER TABLE tbl_appointment ADD INDEX idx_status (status);
ALTER TABLE tbl_appointment ADD INDEX idx_time_status (time, status);

