-- Add currency support to tbl_shopinfo

-- Add currency column (ignore error if exists)
ALTER TABLE tbl_shopinfo ADD COLUMN currency VARCHAR(10) NULL DEFAULT '$';

-- Add currency symbol column (ignore error if exists)
ALTER TABLE tbl_shopinfo ADD COLUMN currency_symbol VARCHAR(10) NULL DEFAULT '$';

-- Add currency position column (ignore error if exists)
ALTER TABLE tbl_shopinfo ADD COLUMN currency_position ENUM('before', 'after') NULL DEFAULT 'before';

-- Update existing record to ensure currency fields have values
UPDATE tbl_shopinfo 
SET currency = COALESCE(currency, '$'),
    currency_symbol = COALESCE(currency_symbol, '$'),
    currency_position = COALESCE(currency_position, 'before')
WHERE id = 1;
