-- Add discount and tax fields to tbl_inpatient_discharge table
-- This migration adds discount and tax calculation fields to support discharge settlements

-- Add discount and tax fields to tbl_inpatient_discharge
ALTER TABLE `tbl_inpatient_discharge` 
ADD COLUMN `discount_amount` DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER `total_deposits`,
ADD COLUMN `tax_rate` DECIMAL(5,2) NOT NULL DEFAULT 0.00 AFTER `discount_amount`,
ADD COLUMN `tax_amount` DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER `tax_rate`,
ADD COLUMN `amount_after_discount` DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER `tax_amount`;

-- Update the outstanding_balance calculation to use the new fields
-- Note: This is just for reference - the actual calculation will be done in the application
-- outstanding_balance = amount_after_discount + tax_amount - total_deposits

-- Add comments to document the new fields
ALTER TABLE `tbl_inpatient_discharge` 
MODIFY COLUMN `discount_amount` DECIMAL(10,2) NOT NULL DEFAULT 0.00 COMMENT 'Discount amount applied to the discharge',
MODIFY COLUMN `tax_rate` DECIMAL(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Tax rate percentage applied',
MODIFY COLUMN `tax_amount` DECIMAL(10,2) NOT NULL DEFAULT 0.00 COMMENT 'Tax amount calculated on amount after discount',
MODIFY COLUMN `amount_after_discount` DECIMAL(10,2) NOT NULL DEFAULT 0.00 COMMENT 'Amount after discount is applied';

-- Create index for better performance on discharge queries
CREATE INDEX IF NOT EXISTS `idx_discharge_discount_tax` ON `tbl_inpatient_discharge` (`discount_amount`, `tax_rate`);

-- Show the updated table structure
DESCRIBE `tbl_inpatient_discharge`;
