-- Add doctor_id and doctor_name columns to voucher tables
-- This links sales/vouchers to prescribing doctors

-- Add to main voucher table
ALTER TABLE tbl_voucher 
ADD COLUMN IF NOT EXISTS doctor_id INT NULL COMMENT 'Prescribing doctor ID',
ADD COLUMN IF NOT EXISTS doctor_name VARCHAR(100) NULL COMMENT 'Prescribing doctor name',
ADD COLUMN IF NOT EXISTS patient_id INT NULL COMMENT 'Patient ID';

-- Add indexes for faster queries
ALTER TABLE tbl_voucher ADD INDEX IF NOT EXISTS idx_doctor_id (doctor_id);
ALTER TABLE tbl_voucher ADD INDEX IF NOT EXISTS idx_patient_id (patient_id);

-- Add to voucher return table (for consistency)
ALTER TABLE tbl_voucher_return 
ADD COLUMN IF NOT EXISTS doctor_id INT NULL,
ADD COLUMN IF NOT EXISTS doctor_name VARCHAR(100) NULL,
ADD COLUMN IF NOT EXISTS patient_id INT NULL;

-- Add to voucher archive table (for consistency)
ALTER TABLE tbl_voucher_archive 
ADD COLUMN IF NOT EXISTS doctor_id INT NULL,
ADD COLUMN IF NOT EXISTS doctor_name VARCHAR(100) NULL,
ADD COLUMN IF NOT EXISTS patient_id INT NULL;

-- Update existing vouchers from treatment table (if any data exists)
UPDATE tbl_voucher v
LEFT JOIN tbl_treatment t ON t.Voucher_id = v.id
LEFT JOIN tbl_doctor d ON t.doctor_id = d.id
SET v.doctor_id = t.doctor_id,
    v.doctor_name = d.name,
    v.patient_id = t.patient_id
WHERE t.id IS NOT NULL;

