-- Add image_path column to tbl_stock if it doesn't exist
ALTER TABLE tbl_stock ADD COLUMN IF NOT EXISTS image_path VARCHAR(255) NULL;

-- Create index for faster image lookups
CREATE INDEX IF NOT EXISTS idx_stock_image ON tbl_stock(image_path);

-- Add default placeholder image path for existing products
UPDATE tbl_stock SET image_path = '/images/no-image.png' WHERE image_path IS NULL;

