-- Complete Database Schema for Clinic Pro V3
-- All 46 Tables with proper structure

USE clinic_pro_db;

-- Add missing columns to existing tables if needed

-- Update tbl_stock to support images
ALTER TABLE tbl_stock ADD COLUMN IF NOT EXISTS image_path VARCHAR(255) NULL AFTER remark;

-- Update tbl_shopinfo to support logo
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS photo_path VARCHAR(255) NULL AFTER photo;

-- Add missing tables if not created

-- tbl_inpatient_saledebit (if not exists)
CREATE TABLE IF NOT EXISTS `tbl_inpatient_saledebit` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `patient_id` VARCHAR(250) NOT NULL,
    `voucher_id` INT NULL,
    `debt` DOUBLE NULL,
    `pay` DOUBLE NULL,
    `remark` TEXT NULL,
    `date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- tbl_township (if not exists)
CREATE TABLE IF NOT EXISTS `tbl_township` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(100) NULL,
    `state` VARCHAR(100) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Verify all indexes exist
CREATE INDEX IF NOT EXISTS idx_patient_patient_id ON tbl_patient(patient_id);
CREATE INDEX IF NOT EXISTS idx_patient_sale_patient_id ON tbl_patient_sale(patient_id);
CREATE INDEX IF NOT EXISTS idx_inpatient_patient_id ON tbl_inpatient(patient_id);
CREATE INDEX IF NOT EXISTS idx_inpatient_sale_patient_id ON tbl_inpatient_sale(patient_id);
CREATE INDEX IF NOT EXISTS idx_sale_vno ON tbl_sale(VNo);
CREATE INDEX IF NOT EXISTS idx_sale_date ON tbl_sale(Date);
CREATE INDEX IF NOT EXISTS idx_stock_barcode ON tbl_stock(barcode);
CREATE INDEX IF NOT EXISTS idx_purchase_barcode ON tbl_purchase(barcode);
CREATE INDEX IF NOT EXISTS idx_voucher_date ON tbl_voucher(Date);
CREATE INDEX IF NOT EXISTS idx_customer_debt_customer_id ON tbl_customer_debt(customer_id);
CREATE INDEX IF NOT EXISTS idx_supplier_debt_supplier_id ON tbl_supplier_debt(supplier_id);
CREATE INDEX IF NOT EXISTS idx_treatment_patient ON tbl_treatment(patient_id);
CREATE INDEX IF NOT EXISTS idx_images_patient ON tbl_images(patient_id);
CREATE INDEX IF NOT EXISTS idx_stock_image ON tbl_stock(image_path);

SELECT 'Schema update completed successfully!' AS Status;

