-- Fix tbl_purchase table ID column to be AUTO_INCREMENT
-- This resolves purchase save failures

-- Modify the id column to be AUTO_INCREMENT
ALTER TABLE tbl_purchase 
MODIFY COLUMN id INT NOT NULL AUTO_INCREMENT;

-- Ensure PRIMARY KEY is set
ALTER TABLE tbl_purchase 
ADD PRIMARY KEY IF NOT EXISTS (id);

-- Set AUTO_INCREMENT start value if table has data
SET @max_id = (SELECT COALESCE(MAX(id), 0) FROM tbl_purchase);
SET @sql = CONCAT('ALTER TABLE tbl_purchase AUTO_INCREMENT = ', @max_id + 1);
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
