-- ============================================
-- Clinic Pro V3 Database - MySQL Version
-- Converted from SQL Server
-- Script Date: Converted on 2025
-- ============================================

-- Create Database
CREATE DATABASE IF NOT EXISTS `clinic_pro_db` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE `clinic_pro_db`;

-- ============================================
-- Table: tbl_alert
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_alert` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_name` VARCHAR(50) NULL,
    `barcode` VARCHAR(50) NULL,
    `name` VARCHAR(50) NULL,
    `qty` INT NULL,
    `qty_alert` INT NULL,
    `date` DATE NULL,
    `status` INT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_cat_expenses
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_cat_expenses` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` TEXT NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_catalog
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_catalog` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` TEXT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_catalog_2
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_catalog_2` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_appointment
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_appointment` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NULL,
    `phone` VARCHAR(50) NULL,
    `case_` VARCHAR(50) NULL,
    `dr_name` VARCHAR(50) NULL,
    `token_number` VARCHAR(50) NULL,
    `time` DATETIME NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_customer
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_customer` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NULL,
    `ph_no` VARCHAR(50) NULL,
    `nrc_no` VARCHAR(50) NULL,
    `shop` TEXT NULL,
    `address` TEXT NULL,
    `date` DATE NULL,
    `remark` TEXT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_customer_debt
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_customer_debt` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `customer_id` INT NOT NULL,
    `voucher_id` INT NULL,
    `debt` DOUBLE NULL,
    `pay` DOUBLE NULL,
    `remark` TEXT NULL,
    `date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_expenses
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_expenses` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_exp_id` VARCHAR(50) NOT NULL,
    `amount` DOUBLE NOT NULL,
    `user_name` VARCHAR(50) NOT NULL,
    `reason` VARCHAR(50) NOT NULL,
    `remark` VARCHAR(50) NULL,
    `date` DATE NOT NULL,
    `status` INT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_form
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_form` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `role_id` VARCHAR(50) NOT NULL,
    `sale` VARCHAR(50) NOT NULL,
    `buy` VARCHAR(50) NOT NULL,
    `product` VARCHAR(50) NOT NULL,
    `change_item_price` VARCHAR(50) NOT NULL,
    `cashier` VARCHAR(50) NOT NULL,
    `login_user` VARCHAR(50) NOT NULL,
    `customer` VARCHAR(50) NOT NULL,
    `supplier` VARCHAR(50) NOT NULL,
    `barcode` VARCHAR(50) NOT NULL,
    `expenses` VARCHAR(50) NOT NULL,
    `report` VARCHAR(50) NOT NULL,
    `setting` VARCHAR(50) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_labour
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_labour` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `level_name` VARCHAR(50) NULL,
    `name` VARCHAR(250) NULL,
    `sex` VARCHAR(10) NULL,
    `age` VARCHAR(50) NULL,
    `nrc` VARCHAR(250) NULL,
    `ph_no` VARCHAR(50) NULL,
    `address` VARCHAR(250) NULL,
    `work_in` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_labour_balance
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_labour_balance` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `labour_name` VARCHAR(50) NOT NULL,
    `InMoney` INT NULL,
    `OutMoney` INT NULL,
    `About` TEXT NULL,
    `Remark` TEXT NULL,
    `date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_labour_level
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_labour_level` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NOT NULL,
    `salary` VARCHAR(50) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_loss
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_loss` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `user_name` VARCHAR(50) NULL,
    `cat_id` TEXT NULL,
    `barcode` VARCHAR(50) NULL,
    `name` VARCHAR(50) NULL,
    `qty` INT NULL,
    `cost_price` DOUBLE NULL,
    `total_cost` DOUBLE NULL,
    `date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_purchase
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_purchase` (
    `id` INT NOT NULL,
    `purchase_voucher_id` INT NULL,
    `cat_id` VARCHAR(255) NULL,
    `cat_id_2` VARCHAR(50) NULL,
    `barcode` VARCHAR(50) NULL,
    `name` TEXT NULL,
    `qty` INT NULL,
    `qty_alert` INT NULL,
    `unit_name` VARCHAR(50) NULL,
    `cost_price` INT NULL,
    `total_cost_price` INT NULL,
    `sale_price_latli` INT NULL,
    `sale_price_latkar` INT NULL,
    `remark` VARCHAR(255) NULL,
    `date` DATE NULL,
    `status` INT NULL,
    `expire_date` DATE NULL,
    `alert_month` INT NULL,
    `alert_date` DATE NULL,
    `margin` DOUBLE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_purchase_return
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_purchase_return` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `user_name` VARCHAR(50) NULL,
    `cat_id` TEXT NULL,
    `barcode` VARCHAR(50) NULL,
    `name` VARCHAR(50) NULL,
    `qty` INT NULL,
    `unit_name` VARCHAR(50) NULL,
    `cost_price` DOUBLE NULL,
    `total_cost` DOUBLE NULL,
    `date` DATE NULL,
    `status` INT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_purchase_voucher
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_purchase_voucher` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `user_name` VARCHAR(50) NULL,
    `total_cost` DOUBLE NOT NULL,
    `supplier_name` VARCHAR(50) NULL,
    `Date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_role
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_role` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_sale
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_sale` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` TEXT NULL,
    `Barcode` VARCHAR(50) NULL,
    `Name` TEXT NULL,
    `SaleType` VARCHAR(50) NULL,
    `SalePrice` DOUBLE NULL,
    `dis` DOUBLE NULL,
    `Qty` INT NULL,
    `Total` DOUBLE NULL,
    `Profit` DOUBLE NULL,
    `VNo` INT NULL,
    `Date` DATE NULL,
    `Cashier` VARCHAR(50) NULL,
    `Refer` VARCHAR(250) NULL,
    `cost_price` INT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_sale_draft
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_sale_draft` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` TEXT NULL,
    `Barcode` VARCHAR(50) NULL,
    `Name` TEXT NULL,
    `SaleType` VARCHAR(50) NULL,
    `SalePrice` DOUBLE NULL,
    `dis` DOUBLE NULL,
    `Qty` INT NULL,
    `Total` DOUBLE NULL,
    `Profit` DOUBLE NULL,
    `VNo` INT NULL,
    `Date` DATE NULL,
    `Cashier` VARCHAR(50) NULL,
    `Refer` VARCHAR(250) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_sale_draft_no
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_sale_draft_no` (
    `id` INT NOT NULL,
    `user_name` VARCHAR(50) NULL,
    `sub_total` DOUBLE NULL,
    `actual_cost` DOUBLE NOT NULL,
    `dis` DOUBLE NULL,
    `tax` DOUBLE NULL,
    `customer_name` VARCHAR(50) NULL,
    `Date` DATETIME NULL,
    `status` INT NULL,
    `payment` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_sale_return
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_sale_return` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` TEXT NULL,
    `barcode` VARCHAR(50) NULL,
    `name` VARCHAR(50) NULL,
    `sale_price` DOUBLE NULL,
    `qty` INT NULL,
    `total` DOUBLE NULL,
    `profit` DOUBLE NULL,
    `remark` VARCHAR(50) NULL,
    `date` DATE NULL,
    `voucher_return_id` INT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_sale_return_item
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_sale_return_item` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` TEXT NULL,
    `barcode` VARCHAR(50) NULL,
    `name` VARCHAR(50) NULL,
    `sale_price` DOUBLE NULL,
    `qty` INT NULL,
    `total` DOUBLE NULL,
    `profit` DOUBLE NULL,
    `remark` VARCHAR(50) NULL,
    `date` DATE NULL,
    `vno` INT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_shopinfo
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_shopinfo` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NULL,
    `type` VARCHAR(50) NULL,
    `ph_no` VARCHAR(50) NULL,
    `email` VARCHAR(250) NULL,
    `address` VARCHAR(500) NULL,
    `remark` VARCHAR(250) NULL,
    `thanks` VARCHAR(250) NULL,
    `photo` LONGBLOB NULL,
    `user_code` VARCHAR(250) NULL,
    `product_code` VARCHAR(250) NULL,
    `software_code` VARCHAR(250) NULL,
    `printer_voucher_count` INT NULL,
    `printer` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_stock
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_stock` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` VARCHAR(255) NULL,
    `cat_id_2` VARCHAR(50) NULL,
    `barcode` VARCHAR(50) NULL,
    `name` TEXT NULL,
    `qty` INT NULL,
    `qty_alert` INT NULL,
    `unit_name` VARCHAR(50) NULL,
    `cost_price` INT NULL,
    `sale_price_latli` INT NULL,
    `sale_price_latkar` INT NULL,
    `remark` VARCHAR(255) NULL,
    `expire_date` DATE NULL,
    `alert_month` INT NULL,
    `alert_date` DATE NULL,
    `margin` DOUBLE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_supplier
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_supplier` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NULL,
    `ph_no` VARCHAR(50) NULL,
    `nrc_no` VARCHAR(50) NULL,
    `shop` TEXT NULL,
    `address` TEXT NULL,
    `date` DATE NULL,
    `remark` TEXT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_supplier_debt
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_supplier_debt` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `supplier_id` INT NOT NULL,
    `voucher_id` INT NULL,
    `debt` DOUBLE NULL,
    `pay` DOUBLE NULL,
    `remark` TEXT NULL,
    `date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_unit
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_unit` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `unit_name` VARCHAR(50) NULL,
    `remark` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_service
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_service` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `barcode` VARCHAR(50) NOT NULL,
    `service_name` VARCHAR(50) NOT NULL,
    `cat_id` VARCHAR(50) NOT NULL,
    `buy_price` INT NOT NULL,
    `sale_price` INT NOT NULL,
    `remark` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_service_catalog
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_service_catalog` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_payment_method
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_payment_method` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default payment methods
INSERT INTO `tbl_payment_method` (`id`, `name`) VALUES 
(1, 'Cash'),
(2, 'KBZ Pay'),
(3, 'CB Pay'),
(4, 'Aya Pay'),
(5, 'Wave Money');

-- ============================================
-- Table: tbl_user_log
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_user_log` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `user_name` VARCHAR(50) NOT NULL,
    `login_time` DATETIME NULL,
    `logout_time` DATETIME NULL,
    `total_sale` DOUBLE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_voucher
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_voucher` (
    `id` INT NOT NULL,
    `user_name` VARCHAR(50) NULL,
    `sub_total` DOUBLE NULL,
    `actual_cost` DOUBLE NOT NULL,
    `dis` DOUBLE NULL,
    `tax` DOUBLE NULL,
    `customer_name` VARCHAR(50) NULL,
    `Date` DATETIME NULL,
    `status` INT NULL,
    `payment` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_patient
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_patient` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NULL,
    `age` VARCHAR(50) NULL,
    `phone` VARCHAR(50) NULL,
    `address` VARCHAR(250) NULL,
    `case_` TEXT NULL,
    `remark` TEXT NULL,
    `date` DATE NULL,
    `dr_name` VARCHAR(250) NULL,
    `patient_id` VARCHAR(250) NULL,
    `room_no` VARCHAR(250) NULL,
    `deposit` INT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_sale_package_no
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_sale_package_no` (
    `id` INT NOT NULL,
    `user_name` VARCHAR(50) NULL,
    `sub_total` DOUBLE NULL,
    `actual_cost` DOUBLE NOT NULL,
    `dis` DOUBLE NULL,
    `tax` DOUBLE NULL,
    `customer_name` VARCHAR(50) NULL,
    `Date` DATETIME NULL,
    `status` INT NULL,
    `payment` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_sale_package
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_sale_package` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` TEXT NULL,
    `Barcode` VARCHAR(50) NULL,
    `Name` TEXT NULL,
    `SaleType` VARCHAR(50) NULL,
    `SalePrice` DOUBLE NULL,
    `dis` DOUBLE NULL,
    `Qty` INT NULL,
    `Total` DOUBLE NULL,
    `Profit` DOUBLE NULL,
    `VNo` INT NULL,
    `Date` DATE NULL,
    `Cashier` VARCHAR(50) NULL,
    `Refer` VARCHAR(250) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_doctor
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_doctor` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NULL,
    `phone` VARCHAR(50) NULL,
    `education` VARCHAR(250) NULL,
    `specialist` VARCHAR(250) NULL,
    `photo` VARCHAR(255) NULL,
    `remark` TEXT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_patient_sale
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_patient_sale` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` TEXT NULL,
    `Barcode` VARCHAR(50) NULL,
    `Name` TEXT NULL,
    `SaleType` VARCHAR(50) NULL,
    `SalePrice` DOUBLE NULL,
    `dis` DOUBLE NULL,
    `Qty` INT NULL,
    `Total` DOUBLE NULL,
    `Profit` DOUBLE NULL,
    `VNo` INT NULL,
    `Date` DATE NULL,
    `Cashier` VARCHAR(50) NULL,
    `patient_id` VARCHAR(250) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_stock_expense
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_stock_expense` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `user_name` VARCHAR(50) NULL,
    `cat_id` TEXT NULL,
    `barcode` VARCHAR(50) NULL,
    `name` VARCHAR(250) NULL,
    `qty` INT NULL,
    `unit` VARCHAR(50) NULL,
    `cost_price` DOUBLE NULL,
    `total_cost` DOUBLE NULL,
    `reason` VARCHAR(250) NULL,
    `date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_treatment
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_treatment` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `patient_id` VARCHAR(50) NULL,
    `Past_Diagnoses` TEXT NULL,
    `Surgeries_Procedures` TEXT NULL,
    `Hospitalizations` TEXT NULL,
    `Current_Medications` TEXT NULL,
    `Dosages` TEXT NULL,
    `Allergen` TEXT NULL,
    `Treatment_Type` TEXT NULL,
    `Date` DATE NULL,
    `Voucher_id` VARCHAR(50) NULL,
    `Recommendation` TEXT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_case
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_case` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_voucher_return
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_voucher_return` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `user_name` VARCHAR(50) NULL,
    `sub_total` DOUBLE NULL,
    `actual_cost` DOUBLE NOT NULL,
    `dis` DOUBLE NULL,
    `tax` DOUBLE NULL,
    `customer_name` VARCHAR(50) NULL,
    `Date` DATETIME NULL,
    `status` INT NULL,
    `payment` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_images
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_images` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `patient_id` VARCHAR(50) NULL,
    `image` LONGBLOB NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_sale_archive
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_sale_archive` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` TEXT NULL,
    `Barcode` VARCHAR(50) NULL,
    `Name` TEXT NULL,
    `SaleType` VARCHAR(50) NULL,
    `SalePrice` DOUBLE NULL,
    `dis` DOUBLE NULL,
    `Qty` INT NULL,
    `Total` DOUBLE NULL,
    `Profit` DOUBLE NULL,
    `VNo` INT NULL,
    `Date` DATE NULL,
    `Cashier` VARCHAR(50) NULL,
    `Refer` VARCHAR(250) NULL,
    `cost_price` INT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_voucher_archive
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_voucher_archive` (
    `id` INT NOT NULL,
    `user_name` VARCHAR(50) NULL,
    `sub_total` DOUBLE NULL,
    `actual_cost` DOUBLE NOT NULL,
    `dis` DOUBLE NULL,
    `tax` DOUBLE NULL,
    `customer_name` VARCHAR(50) NULL,
    `Date` DATETIME NULL,
    `status` INT NULL,
    `payment` VARCHAR(50) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_inpatient
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_inpatient` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NULL,
    `age` VARCHAR(50) NULL,
    `phone` VARCHAR(50) NULL,
    `address` VARCHAR(250) NULL,
    `case_` TEXT NULL,
    `remark` TEXT NULL,
    `start_date` DATE NULL,
    `dr_name` VARCHAR(250) NULL,
    `patient_id` VARCHAR(250) NULL,
    `room_no` VARCHAR(250) NULL,
    `deposit` INT NULL,
    `end_date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_inpatient_sale
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_inpatient_sale` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `cat_id` TEXT NULL,
    `Barcode` VARCHAR(50) NULL,
    `Name` TEXT NULL,
    `SaleType` VARCHAR(50) NULL,
    `SalePrice` DOUBLE NULL,
    `dis` DOUBLE NULL,
    `Qty` INT NULL,
    `Total` DOUBLE NULL,
    `Profit` DOUBLE NULL,
    `VNo` INT NULL,
    `Date` DATE NULL,
    `Cashier` VARCHAR(50) NULL,
    `patient_id` VARCHAR(250) NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_inpatient_saledebit
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_inpatient_saledebit` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `patient_id` VARCHAR(250) NOT NULL,
    `voucher_id` INT NULL,
    `debt` DOUBLE NULL,
    `pay` DOUBLE NULL,
    `remark` TEXT NULL,
    `date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table: tbl_user
-- ============================================
CREATE TABLE IF NOT EXISTS `tbl_user` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `role_id` VARCHAR(100) NOT NULL,
    `name` VARCHAR(100) NULL,
    `passwd` VARCHAR(100) NULL,
    `ph_no` VARCHAR(50) NULL,
    `nrc_no` VARCHAR(50) NULL,
    `address` VARCHAR(150) NULL,
    `photo` LONGBLOB NULL,
    `date` DATE NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default users
INSERT INTO `tbl_user` (`id`, `role_id`, `name`, `passwd`, `ph_no`, `nrc_no`, `address`, `photo`, `date`) VALUES 
(1, '1', 'a', 'a', '22222', '433333333', 'POL', NULL, NULL),
(3, '1', 'ko', 'ko', 'ko', 'ko', 'ko', NULL, NULL),
(4, '3', 'mm', 'mm', 'mm', 'mm', 'mm', NULL, NULL),
(5, '2', 'aa', 'aa', 'a', 'a', 'a', NULL, NULL);

-- ============================================
-- STORED PROCEDURES
-- ============================================

-- Procedure: auto_purchase_id
DELIMITER //
CREATE PROCEDURE `auto_purchase_id`()
BEGIN
    DECLARE v_row_count INT;
    DECLARE v_id INT;
    DECLARE v_temp_new_number INT;
    
    SET v_row_count = (SELECT COUNT(id) FROM tbl_purchase);
    
    IF (v_row_count = 0) THEN
        SET v_id = 1;
    ELSE
        SET v_temp_new_number = (SELECT MAX(id) FROM tbl_purchase);
        SET v_id = v_temp_new_number + 1;
    END IF;
    
    SELECT v_id AS 'id';
END //
DELIMITER ;

-- Procedure: AutoGeneratevoucherNo_purchase
DELIMITER //
CREATE PROCEDURE `AutoGeneratevoucherNo_purchase`()
BEGIN
    DECLARE v_row_count INT;
    DECLARE v_voucher INT;
    DECLARE v_temp_new_number INT;
    
    SET v_row_count = (SELECT COUNT(id) FROM tbl_purchase);
    
    IF (v_row_count = 0) THEN
        SET v_voucher = 1000;
    ELSE
        SET v_temp_new_number = (SELECT MAX(purchase_voucher_id) FROM tbl_purchase);
        SET v_voucher = v_temp_new_number + 1;
    END IF;
    
    SELECT v_voucher AS 'voucher';
END //
DELIMITER ;

-- Procedure: AutoGeneratevoucherNo_Sale
DELIMITER //
CREATE PROCEDURE `AutoGeneratevoucherNo_Sale`()
BEGIN
    DECLARE v_row_count INT;
    DECLARE v_voucher INT;
    DECLARE v_temp_new_number INT;
    
    SET v_row_count = (SELECT COUNT(id) FROM tbl_sale);
    
    IF (v_row_count = 0) THEN
        SET v_voucher = 1000;
    ELSE
        SET v_temp_new_number = (SELECT MAX(VNo) FROM tbl_sale);
        SET v_voucher = v_temp_new_number + 1;
    END IF;
    
    SELECT v_voucher AS 'voucher';
END //
DELIMITER ;

-- ============================================
-- INDEXES for Performance Optimization
-- ============================================

-- Indexes on frequently queried columns
CREATE INDEX idx_patient_patient_id ON tbl_patient(patient_id);
CREATE INDEX idx_patient_sale_patient_id ON tbl_patient_sale(patient_id);
CREATE INDEX idx_inpatient_patient_id ON tbl_inpatient(patient_id);
CREATE INDEX idx_inpatient_sale_patient_id ON tbl_inpatient_sale(patient_id);
CREATE INDEX idx_sale_vno ON tbl_sale(VNo);
CREATE INDEX idx_sale_date ON tbl_sale(Date);
CREATE INDEX idx_stock_barcode ON tbl_stock(barcode);
CREATE INDEX idx_purchase_barcode ON tbl_purchase(barcode);
CREATE INDEX idx_voucher_date ON tbl_voucher(Date);
CREATE INDEX idx_customer_debt_customer_id ON tbl_customer_debt(customer_id);
CREATE INDEX idx_supplier_debt_supplier_id ON tbl_supplier_debt(supplier_id);

-- ============================================
-- COMPLETION MESSAGE
-- ============================================
SELECT 'Database conversion completed successfully!' AS Status;

