-- Migration: Add photo and additional fields to tbl_doctor
-- Created: 2024-10-16
-- Description: Adds photo column and other useful fields to doctor table

-- Add photo column
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS photo VARCHAR(255) NULL COMMENT 'Doctor photo path';

-- Add email column
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS email VARCHAR(100) NULL COMMENT 'Doctor email';

-- Add address column
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS address TEXT NULL COMMENT 'Doctor address';

-- Add license number column
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS license_number VARCHAR(50) NULL COMMENT 'Medical license number';

-- Add experience years column
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS experience_years INT NULL COMMENT 'Years of experience';

-- Add consultation fee column
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS consultation_fee DECIMAL(10,2) DEFAULT 0.00 COMMENT 'Consultation fee';

-- Add active status column
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS is_active TINYINT(1) DEFAULT 1 COMMENT 'Active status';

-- Add created_at timestamp
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP;

-- Add updated_at timestamp
ALTER TABLE tbl_doctor 
ADD COLUMN IF NOT EXISTS updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;

-- Add indexes for better performance
-- Note: Remove IF NOT EXISTS for MySQL compatibility
CREATE INDEX idx_doctor_active ON tbl_doctor(is_active);
CREATE INDEX idx_doctor_specialist ON tbl_doctor(specialist);
