-- Migration: Add deposit system for patients
-- Created: 2024-10-16
-- Description: Creates deposit transaction table and adds deposit balance to patient table

-- Add deposit_balance to tbl_patient
ALTER TABLE tbl_patient 
ADD COLUMN IF NOT EXISTS deposit_balance DECIMAL(10,2) DEFAULT 0.00 COMMENT 'Current deposit balance';

-- Create deposit transaction table
CREATE TABLE IF NOT EXISTS tbl_deposit_transaction (
    id INT NOT NULL AUTO_INCREMENT,
    patient_id INT NOT NULL COMMENT 'Reference to tbl_patient.id',
    transaction_type ENUM('deposit', 'withdrawal') NOT NULL COMMENT 'Type of transaction',
    amount DECIMAL(10,2) NOT NULL COMMENT 'Transaction amount',
    balance_before DECIMAL(10,2) NOT NULL COMMENT 'Balance before transaction',
    balance_after DECIMAL(10,2) NOT NULL COMMENT 'Balance after transaction',
    description TEXT NULL COMMENT 'Transaction description',
    reference_no VARCHAR(50) NULL COMMENT 'Reference number (voucher/receipt)',
    created_by INT NULL COMMENT 'User who created the transaction',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    INDEX idx_patient_id (patient_id),
    INDEX idx_transaction_type (transaction_type),
    INDEX idx_created_at (created_at),
    INDEX idx_reference_no (reference_no)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Update existing patients with initial deposit balance from deposit column if exists
UPDATE tbl_patient 
SET deposit_balance = COALESCE(deposit, 0) 
WHERE deposit_balance IS NULL OR deposit_balance = 0;
