-- Migration: Add bed-related fields to tbl_inpatient
-- Created: 2024-10-16
-- Description: Adds bed integration fields for inpatient management

-- Add bed_id column (foreign key to tbl_beds)
ALTER TABLE tbl_inpatient 
ADD COLUMN IF NOT EXISTS bed_id INT NULL COMMENT 'Reference to tbl_beds.id';

-- Add bed_number column
ALTER TABLE tbl_inpatient 
ADD COLUMN IF NOT EXISTS bed_number VARCHAR(20) NULL COMMENT 'Bed number from bed assignment';

-- Add bed_type column
ALTER TABLE tbl_inpatient 
ADD COLUMN IF NOT EXISTS bed_type VARCHAR(50) NULL COMMENT 'Type of bed (General, ICU, Private, etc.)';

-- Add daily_rate column
ALTER TABLE tbl_inpatient 
ADD COLUMN IF NOT EXISTS daily_rate DECIMAL(10,2) DEFAULT 0.00 COMMENT 'Daily rate for bed';

-- Add dr_id column (foreign key to tbl_doctor)
ALTER TABLE tbl_inpatient 
ADD COLUMN IF NOT EXISTS dr_id INT NULL COMMENT 'Reference to tbl_doctor.id';

-- Add indexes for better performance
-- Note: Remove IF NOT EXISTS for MySQL compatibility
CREATE INDEX idx_inpatient_bed_id ON tbl_inpatient(bed_id);
CREATE INDEX idx_inpatient_dr_id ON tbl_inpatient(dr_id);
CREATE INDEX idx_inpatient_end_date ON tbl_inpatient(end_date);

-- Update existing records to set default values
UPDATE tbl_inpatient 
SET bed_type = 'General', daily_rate = 0.00 
WHERE bed_type IS NULL;

-- Note: Foreign key constraints are not added in migration
-- They should be added manually if tbl_beds and tbl_doctor tables exist
-- ALTER TABLE tbl_inpatient ADD CONSTRAINT fk_inpatient_bed FOREIGN KEY (bed_id) REFERENCES tbl_beds(id) ON DELETE SET NULL;
-- ALTER TABLE tbl_inpatient ADD CONSTRAINT fk_inpatient_doctor FOREIGN KEY (dr_id) REFERENCES tbl_doctor(id) ON DELETE SET NULL;