-- Migration: Add is_settled column to tbl_inpatient_usage
-- Created: 2025-10-28
-- Description: Adds is_settled flag to track which usage items have been settled/billed

USE clinic_pro_db;

-- Add is_settled column to track settlement status
ALTER TABLE `tbl_inpatient_usage` 
ADD COLUMN IF NOT EXISTS `is_settled` TINYINT(1) DEFAULT 0 COMMENT 'Flag to mark if usage has been settled (0 = unsettled, 1 = settled)';

-- Add index for better query performance
CREATE INDEX IF NOT EXISTS `idx_is_settled` ON `tbl_inpatient_usage`(`is_settled`);

-- Add composite index for common query pattern
CREATE INDEX IF NOT EXISTS `idx_inpatient_settled` ON `tbl_inpatient_usage`(`inpatient_id`, `is_settled`);

-- Update existing records to be marked as unsettled (0) by default
UPDATE `tbl_inpatient_usage` 
SET `is_settled` = 0 
WHERE `is_settled` IS NULL;

-- Optional: View to show unsettled usage items
CREATE OR REPLACE VIEW `vw_unsettled_inpatient_usage` AS
SELECT 
    u.id,
    u.inpatient_id,
    i.patient_id,
    i.name as patient_name,
    u.product_id,
    s.Name as product_name,
    u.quantity,
    u.price,
    (u.quantity * u.price) as total,
    u.usage_date,
    u.notes,
    u.created_at
FROM tbl_inpatient_usage u
JOIN tbl_inpatient i ON u.inpatient_id = i.id
JOIN tbl_stock s ON u.product_id = s.id
WHERE u.is_settled = 0 OR u.is_settled IS NULL
ORDER BY u.usage_date DESC, u.created_at DESC;

-- Success message
SELECT 'Migration 004: is_settled column added successfully' as status;

