-- ============================================
-- Migration: Ensure Doctor Fields in Voucher Tables
-- Date: October 2025
-- Purpose: Support doctor tracking in POS sales and doctor performance reports
-- ============================================

-- Add doctor fields to tbl_voucher if they don't exist
ALTER TABLE tbl_voucher 
ADD COLUMN IF NOT EXISTS doctor_id INT NULL,
ADD COLUMN IF NOT EXISTS doctor_name VARCHAR(100) NULL,
ADD COLUMN IF NOT EXISTS patient_id VARCHAR(50) NULL;

-- Add indexes for better performance
-- Note: Remove IF NOT EXISTS for MySQL compatibility
CREATE INDEX idx_voucher_doctor ON tbl_voucher(doctor_id);
CREATE INDEX idx_voucher_patient ON tbl_voucher(patient_id);
CREATE INDEX idx_voucher_date ON tbl_voucher(Date);

-- Add doctor fields to tbl_voucher_return if they don't exist
ALTER TABLE tbl_voucher_return 
ADD COLUMN IF NOT EXISTS doctor_id INT NULL,
ADD COLUMN IF NOT EXISTS doctor_name VARCHAR(100) NULL,
ADD COLUMN IF NOT EXISTS patient_id VARCHAR(50) NULL;

-- Add doctor fields to tbl_voucher_archive if they don't exist
ALTER TABLE tbl_voucher_archive 
ADD COLUMN IF NOT EXISTS doctor_id INT NULL,
ADD COLUMN IF NOT EXISTS doctor_name VARCHAR(100) NULL,
ADD COLUMN IF NOT EXISTS patient_id VARCHAR(50) NULL;

-- Ensure tbl_sale_return_item table has proper fields
ALTER TABLE tbl_sale_return_item 
MODIFY COLUMN vno INT NULL COMMENT 'Links to tbl_voucher_return.id';

-- Add index on treatment Voucher_id for better join performance
-- Note: Remove IF NOT EXISTS for MySQL compatibility
CREATE INDEX idx_treatment_voucher ON tbl_treatment(Voucher_id);

-- ============================================
-- Notes:
-- - These columns enable tracking which doctor is associated with each sale
-- - Used in Doctor Performance Report to show all doctor-related revenue
-- - Supports both EMR treatments and direct POS sales
-- ============================================

