-- ============================================
-- REFERRING DOCTOR SYSTEM - Tables Only
-- Migration 005: Create core tables
-- ============================================

USE clinic_pro_db;

-- Table: tbl_referring_doctor
CREATE TABLE IF NOT EXISTS `tbl_referring_doctor` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(100) NOT NULL,
    `specialty` VARCHAR(100) NULL,
    `qualification` VARCHAR(200) NULL,
    `clinic_name` VARCHAR(200) NULL,
    `phone` VARCHAR(50) NULL,
    `email` VARCHAR(100) NULL,
    `address` TEXT NULL,
    `city` VARCHAR(100) NULL,
    `state` VARCHAR(100) NULL,
    `commission_type` ENUM('percentage', 'fixed', 'none') DEFAULT 'none',
    `commission_value` DECIMAL(10,2) DEFAULT 0.00,
    `commission_applies_to` ENUM('all', 'products_only', 'services_only', 'lab_only') DEFAULT 'all',
    `is_internal` TINYINT(1) DEFAULT 0,
    `internal_doctor_id` INT NULL,
    `registration_number` VARCHAR(100) NULL,
    `notes` TEXT NULL,
    `photo_path` VARCHAR(255) NULL,
    `active` TINYINT(1) DEFAULT 1,
    `total_referrals` INT DEFAULT 0,
    `total_revenue` DECIMAL(12,2) DEFAULT 0.00,
    `total_commission_earned` DECIMAL(12,2) DEFAULT 0.00,
    `total_commission_paid` DECIMAL(12,2) DEFAULT 0.00,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `created_by` INT NULL,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` INT NULL,
    PRIMARY KEY (`id`),
    INDEX `idx_name` (`name`),
    INDEX `idx_active` (`active`),
    INDEX `idx_is_internal` (`is_internal`),
    INDEX `idx_internal_doctor` (`internal_doctor_id`),
    INDEX `idx_commission_type` (`commission_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_referral_commission
CREATE TABLE IF NOT EXISTS `tbl_referral_commission` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `referring_doctor_id` INT NOT NULL,
    `transaction_type` ENUM('sale', 'lab_order', 'service', 'appointment') NOT NULL,
    `sale_id` INT NULL,
    `lab_order_id` INT NULL,
    `voucher_no` VARCHAR(50) NULL,
    `patient_id` VARCHAR(250) NULL,
    `patient_name` VARCHAR(100) NULL,
    `transaction_date` DATE NOT NULL,
    `transaction_amount` DECIMAL(10,2) NOT NULL,
    `commission_type` ENUM('percentage', 'fixed', 'none') NOT NULL,
    `commission_rate` DECIMAL(5,2) NULL,
    `commission_amount` DECIMAL(10,2) NOT NULL DEFAULT 0.00,
    `payment_status` ENUM('pending', 'approved', 'paid', 'cancelled') DEFAULT 'pending',
    `payment_date` DATE NULL,
    `payment_method` VARCHAR(50) NULL,
    `payment_reference` VARCHAR(100) NULL,
    `payment_notes` TEXT NULL,
    `notes` TEXT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `created_by` INT NULL,
    `approved_at` TIMESTAMP NULL,
    `approved_by` INT NULL,
    `paid_at` TIMESTAMP NULL,
    `paid_by` INT NULL,
    PRIMARY KEY (`id`),
    INDEX `idx_referring_doctor` (`referring_doctor_id`),
    INDEX `idx_transaction_type` (`transaction_type`),
    INDEX `idx_sale` (`sale_id`),
    INDEX `idx_lab_order` (`lab_order_id`),
    INDEX `idx_voucher` (`voucher_no`),
    INDEX `idx_transaction_date` (`transaction_date`),
    INDEX `idx_payment_status` (`payment_status`),
    INDEX `idx_patient` (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add referring_doctor_id to tbl_sale
ALTER TABLE `tbl_sale` 
ADD COLUMN `referring_doctor_id` INT NULL,
ADD COLUMN `referring_doctor_name` VARCHAR(100) NULL;

-- Add referring_doctor_id to tbl_lab_order (if exists)
ALTER TABLE `tbl_lab_order` 
ADD COLUMN `referring_doctor_id` INT NULL,
ADD COLUMN `referring_doctor_name` VARCHAR(100) NULL;

-- Insert sample referring doctors
INSERT INTO `tbl_referring_doctor` 
(`name`, `specialty`, `clinic_name`, `phone`, `email`, `commission_type`, `commission_value`, `is_internal`, `active`, `notes`) 
VALUES 
('Walk-in / No Referral', 'N/A', 'N/A', NULL, 'none@clinic.local', 'none', 0.00, 0, 1, 'Default option for walk-in patients with no referring doctor'),
('Dr. External Referrer', 'General Medicine', 'City Medical Center', '+1-234-567-8900', 'external@medical.com', 'percentage', 10.00, 0, 1, 'Sample external referring doctor - 10% commission');

SELECT 'Migration 005: Referring Doctor tables created successfully!' as status;

