-- Add missing columns to tbl_supplier table
ALTER TABLE tbl_supplier
ADD COLUMN IF NOT EXISTS `email` VARCHAR(100) NULL AFTER `ph_no`;

ALTER TABLE tbl_supplier
ADD COLUMN IF NOT EXISTS `credit_balance` DECIMAL(10, 2) NOT NULL DEFAULT 0 AFTER `address`;

-- Create indexes for better performance
CREATE INDEX IF NOT EXISTS `idx_supplier_name` ON `tbl_supplier`(`name`);
CREATE INDEX IF NOT EXISTS `idx_supplier_ph_no` ON `tbl_supplier`(`ph_no`);
CREATE INDEX IF NOT EXISTS `idx_supplier_email` ON `tbl_supplier`(`email`);

