-- Add missing columns to tbl_supplier table (Cloud-compatible version)
-- This version uses plain ALTER TABLE statements without IF NOT EXISTS
-- Error handling in the migration runner will catch duplicate column errors

-- Add email column (will fail silently if already exists due to error handling)
ALTER TABLE tbl_supplier
ADD COLUMN `email` VARCHAR(100) NULL AFTER `ph_no`;

-- Add credit_balance column (will fail silently if already exists due to error handling)
ALTER TABLE tbl_supplier
ADD COLUMN `credit_balance` DECIMAL(10, 2) NOT NULL DEFAULT 0 AFTER `address`;

-- Create indexes (will fail silently if already exists due to error handling)
CREATE INDEX `idx_supplier_name` ON `tbl_supplier`(`name`);
CREATE INDEX `idx_supplier_ph_no` ON `tbl_supplier`(`ph_no`);
CREATE INDEX `idx_supplier_email` ON `tbl_supplier`(`email`);
