-- Add doctor, patient, and referring doctor fields to tbl_sale_draft_no table
-- This allows drafts to store complete sale information

ALTER TABLE `tbl_sale_draft_no`
ADD COLUMN `doctor_id` INT NULL AFTER `payment`,
ADD COLUMN `doctor_name` VARCHAR(255) NULL AFTER `doctor_id`,
ADD COLUMN `patient_id` INT NULL AFTER `doctor_name`,
ADD COLUMN `referring_doctor_id` INT NULL AFTER `patient_id`,
ADD COLUMN `referring_doctor_name` VARCHAR(255) NULL AFTER `referring_doctor_id`;

-- Add index for better query performance
CREATE INDEX `idx_doctor_id` ON `tbl_sale_draft_no`(`doctor_id`);
CREATE INDEX `idx_patient_id` ON `tbl_sale_draft_no`(`patient_id`);
CREATE INDEX `idx_referring_doctor_id` ON `tbl_sale_draft_no`(`referring_doctor_id`);

