-- Migration: Add price history tracking table (Cloud-compatible version)
-- Description: Tracks price changes for stock items
-- This version uses plain SQL without IF NOT EXISTS for compatibility with older MySQL/MariaDB

CREATE TABLE IF NOT EXISTS `tbl_price_history` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `stock_id` INT NOT NULL,
    `old_cost_price` DECIMAL(10, 2) NULL,
    `new_cost_price` DECIMAL(10, 2) NULL,
    `old_sale_price` DECIMAL(10, 2) NULL,
    `new_sale_price` DECIMAL(10, 2) NULL,
    `old_margin` DECIMAL(10, 2) NULL,
    `new_margin` DECIMAL(10, 2) NULL,
    `changed_by` VARCHAR(100) NULL,
    `changed_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    INDEX `idx_stock_id` (`stock_id`),
    INDEX `idx_changed_at` (`changed_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add alert_date column to tbl_stock (will fail silently if already exists due to error handling)
ALTER TABLE `tbl_stock` 
ADD COLUMN `alert_date` DATE NULL AFTER `alert_month`;

-- Add alert_date column to tbl_purchase (will fail silently if already exists due to error handling)
ALTER TABLE `tbl_purchase` 
ADD COLUMN `alert_date` DATE NULL AFTER `alert_month`;

-- Add indexes (will fail silently if already exists due to error handling)
CREATE INDEX `idx_stock_expire_date` ON `tbl_stock`(`expire_date`);
CREATE INDEX `idx_stock_alert_date` ON `tbl_stock`(`alert_date`);
CREATE INDEX `idx_purchase_expire_date` ON `tbl_purchase`(`expire_date`);

SELECT 'Price history table and indexes created successfully!' AS Status;
