-- Migration: Create Laboratory Items Table
-- Description: Creates tbl_laboratory_item table for managing laboratory test items
-- Date: 2024
-- Author: System

-- Create tbl_laboratory_item table (similar structure to tbl_service)
CREATE TABLE IF NOT EXISTS tbl_laboratory_item (
    id INT NOT NULL AUTO_INCREMENT,
    barcode VARCHAR(50) NULL,
    item_name VARCHAR(50) NOT NULL,
    cat_id INT NULL,
    buy_price DECIMAL(10, 2) DEFAULT 0.00,
    sale_price DECIMAL(10, 2) DEFAULT 0.00,
    unit VARCHAR(50) NULL COMMENT 'Unit of measurement (e.g., mg/dL, mmol/L, g/L)',
    reference_ranges TEXT NULL COMMENT 'Normal reference ranges for the test (e.g., "Male: 3.5-5.5, Female: 3.5-5.0")',
    remark TEXT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    INDEX idx_barcode (barcode),
    INDEX idx_item_name (item_name),
    INDEX idx_cat_id (cat_id),
    INDEX idx_unit (unit),
    FOREIGN KEY (cat_id) REFERENCES tbl_service_catalog(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add comment to table
ALTER TABLE tbl_laboratory_item COMMENT = 'Laboratory test items that can be sold in POS and Inpatient Sales';