-- Migration: Create Delete History Table
-- Purpose: Track deletions across the application
-- Columns:
--   id          : PK
--   table_name  : source table
--   record_id   : primary key of deleted row (string to cover UUID/int)
--   deleted_by  : user id if available
--   username    : username if available
--   old_data    : JSON string of the deleted row
--   reason      : optional reason/context
--   ip_address  : request IP if available
--   user_agent  : request user agent if available
--   deleted_at  : timestamp

CREATE TABLE IF NOT EXISTS tbl_delete_history (
    id BIGINT NOT NULL AUTO_INCREMENT,
    table_name VARCHAR(100) NOT NULL,
    record_id VARCHAR(100) NULL,
    deleted_by INT NULL,
    username VARCHAR(100) NULL,
    old_data LONGTEXT NULL COMMENT 'JSON data stored as text',
    reason VARCHAR(255) NULL,
    ip_address VARCHAR(45) NULL,
    user_agent VARCHAR(255) NULL,
    deleted_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    INDEX idx_table (table_name),
    INDEX idx_deleted_by (deleted_by),
    INDEX idx_deleted_at (deleted_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

