-- Add supplier_id column to tbl_stock table
-- This allows linking products to suppliers

ALTER TABLE tbl_stock 
ADD COLUMN IF NOT EXISTS `supplier_id` INT NULL AFTER `cat_id_2`;

-- Add foreign key constraint
ALTER TABLE tbl_stock
ADD CONSTRAINT `fk_stock_supplier` 
FOREIGN KEY (`supplier_id`) REFERENCES `tbl_supplier`(`id`) 
ON DELETE SET NULL;

-- Create index for better query performance
CREATE INDEX IF NOT EXISTS `idx_stock_supplier` ON `tbl_stock`(`supplier_id`);

