-- Migration: Create Laboratory Packages Tables
-- Description: Creates tables for laboratory packages and package items
-- Date: 2025
-- Author: System

-- Create tbl_laboratory_package table
CREATE TABLE IF NOT EXISTS tbl_laboratory_package (
    id INT NOT NULL AUTO_INCREMENT,
    package_name VARCHAR(255) NOT NULL,
    package_code VARCHAR(50) NULL UNIQUE COMMENT 'Unique code for package (e.g., PKG001)',
    description TEXT NULL,
    total_price DECIMAL(10, 2) DEFAULT 0.00 COMMENT 'Total price of package (sum of all items)',
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    INDEX idx_package_name (package_name),
    INDEX idx_package_code (package_code),
    INDEX idx_is_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create tbl_laboratory_package_item table (junction table)
CREATE TABLE IF NOT EXISTS tbl_laboratory_package_item (
    id INT NOT NULL AUTO_INCREMENT,
    package_id INT NOT NULL,
    lab_item_id INT NOT NULL,
    quantity INT DEFAULT 1 COMMENT 'Quantity of this item in the package',
    item_price DECIMAL(10, 2) DEFAULT 0.00 COMMENT 'Price of this item at time of package creation',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    INDEX idx_package_id (package_id),
    INDEX idx_lab_item_id (lab_item_id),
    FOREIGN KEY (package_id) REFERENCES tbl_laboratory_package(id) ON DELETE CASCADE,
    FOREIGN KEY (lab_item_id) REFERENCES tbl_laboratory_item(id) ON DELETE CASCADE,
    UNIQUE KEY unique_package_item (package_id, lab_item_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add comment to tables
ALTER TABLE tbl_laboratory_package COMMENT = 'Laboratory test packages that contain multiple laboratory items';
ALTER TABLE tbl_laboratory_package_item COMMENT = 'Items included in laboratory packages';
