-- Migration: Add Unit and Reference Ranges to Laboratory Items
-- Description: Adds unit and reference_ranges columns to tbl_laboratory_item
-- Date: 2025
-- Author: System

-- Add unit column
ALTER TABLE tbl_laboratory_item 
ADD COLUMN IF NOT EXISTS unit VARCHAR(50) NULL COMMENT 'Unit of measurement (e.g., mg/dL, mmol/L, g/L)' AFTER sale_price;

-- Add reference_ranges column
ALTER TABLE tbl_laboratory_item 
ADD COLUMN IF NOT EXISTS reference_ranges TEXT NULL COMMENT 'Normal reference ranges for the test (e.g., "Male: 3.5-5.5, Female: 3.5-5.0")' AFTER unit;

-- Add index on unit for filtering
CREATE INDEX IF NOT EXISTS idx_unit ON tbl_laboratory_item(unit);
