-- Add supplier_id column to tbl_purchase table
-- This migration adds supplier_id to track which supplier each purchase came from
-- Compatible with MariaDB/MySQL - errors will be caught by migration runner if column already exists

-- Add supplier_id column (will fail silently if already exists due to error handling)
ALTER TABLE tbl_purchase
ADD COLUMN supplier_id INT NULL AFTER purchase_voucher_id;

-- Add foreign key constraint (will fail silently if already exists due to error handling)
ALTER TABLE tbl_purchase
ADD CONSTRAINT fk_purchase_supplier 
FOREIGN KEY (supplier_id) REFERENCES tbl_supplier(id) 
ON DELETE SET NULL
ON UPDATE CASCADE;

-- Create index (will fail silently if already exists due to error handling)
CREATE INDEX idx_purchase_supplier ON tbl_purchase(supplier_id);

SELECT 'Migration completed: supplier_id column added to tbl_purchase' AS result;
