-- Add warehouse_id column to tbl_stock_expense table
-- This migration adds warehouse_id to track which warehouse the stock expense came from

-- Add warehouse_id column (will fail silently if already exists due to error handling)
ALTER TABLE tbl_stock_expense
ADD COLUMN warehouse_id INT NULL AFTER date;

-- Add foreign key constraint (will fail silently if already exists due to error handling)
ALTER TABLE tbl_stock_expense
ADD CONSTRAINT fk_stock_expense_warehouse 
FOREIGN KEY (warehouse_id) REFERENCES tbl_warehouse(id) 
ON DELETE SET NULL
ON UPDATE CASCADE;

-- Create index (will fail silently if already exists due to error handling)
CREATE INDEX idx_stock_expense_warehouse ON tbl_stock_expense(warehouse_id);

SELECT 'Migration completed: warehouse_id column added to tbl_stock_expense' AS result;
