-- Reset admin role and grant full permissions to user 'admin'
-- Safe to run multiple times (idempotent)

-- Resolve Admin role ID
SET @adminRoleId := (SELECT id FROM tbl_role WHERE name = 'Admin' LIMIT 1);

-- Ensure Admin role is active and has bypass metadata
UPDATE tbl_role
SET level = 100,
    active = 1,
    metadata = JSON_OBJECT('color', '#dc3545', 'icon', 'shield', 'bypassChecks', true)
WHERE id = @adminRoleId;

-- Assign admin user to Admin role
UPDATE tbl_user
SET role_id = @adminRoleId
WHERE name = 'admin';

-- Ensure all permissions exist for Admin role
INSERT INTO tbl_role_permission (role_id, permission_id, granted, active, metadata, created_at, updated_at)
SELECT
    @adminRoleId,
    p.id,
    1,
    1,
    JSON_OBJECT(),
    NOW(),
    NOW()
FROM tbl_permission p
WHERE p.active = 1
  AND NOT EXISTS (
      SELECT 1
      FROM tbl_role_permission rp
      WHERE rp.role_id = @adminRoleId
        AND rp.permission_id = p.id
  );

-- Force-enable all Admin permissions
UPDATE tbl_role_permission
SET granted = 1,
    active = 1,
    updated_at = NOW()
WHERE role_id = @adminRoleId;

SELECT 'Admin permissions reset complete' AS result;
