-- ============================================
-- Seed Data: Doctor Performance Sample Data
-- Date: October 2025
-- Purpose: Sample data for testing doctor performance reports
-- ============================================

-- Ensure we have some doctors with specialists
UPDATE tbl_doctor SET specialist = 'General Medicine' WHERE id = 1 AND (specialist IS NULL OR specialist = '');
UPDATE tbl_doctor SET specialist = 'Pediatrics' WHERE id = 2 AND (specialist IS NULL OR specialist = '');
UPDATE tbl_doctor SET specialist = 'Cardiology' WHERE id = 3 AND (specialist IS NULL OR specialist = '');

-- Sample: Link existing vouchers to doctors (for testing)
-- Update recent vouchers to have doctor associations
UPDATE tbl_voucher 
SET doctor_id = 1, 
    doctor_name = (SELECT name FROM tbl_doctor WHERE id = 1 LIMIT 1)
WHERE id IN (SELECT id FROM tbl_voucher ORDER BY Date DESC LIMIT 5)
  AND doctor_id IS NULL;

UPDATE tbl_voucher 
SET doctor_id = 2, 
    doctor_name = (SELECT name FROM tbl_doctor WHERE id = 2 LIMIT 1)
WHERE id IN (SELECT id FROM tbl_voucher ORDER BY Date DESC LIMIT 3 OFFSET 5)
  AND doctor_id IS NULL;

-- Sample: Create treatments linked to some vouchers if they don't exist
-- This ensures the report shows both types of data
INSERT IGNORE INTO tbl_treatment 
(patient_id, doctor_id, chief_complaint, diagnosis, Treatment_Type, Voucher_id, Date)
SELECT 
    v.patient_id,
    v.doctor_id,
    'Sample consultation',
    'General checkup',
    'Consultation',
    v.id,
    v.Date
FROM tbl_voucher v
WHERE v.doctor_id IS NOT NULL 
  AND NOT EXISTS (
      SELECT 1 FROM tbl_treatment t WHERE t.Voucher_id = v.id
  )
LIMIT 5;

-- ============================================
-- Notes:
-- - This seed provides sample data for doctor performance testing
-- - Links vouchers to doctors so reports show data
-- - Creates sample treatments for comprehensive testing
-- - Safe to run multiple times (uses INSERT IGNORE and UPDATE WHERE)
-- ============================================

