/**
 * Complete Database Setup
 * Runs migrations and seeds in order
 */

const { runMigrations } = require('./migrations/run-all-migrations');
const { runSeeds } = require('./seeds/run-all-seeds');

async function setupDatabase() {
    try {
        console.log('═══════════════════════════════════════════════════════');
        console.log('🏥 CLINIC PRO - DATABASE SETUP');
        console.log('═══════════════════════════════════════════════════════\n');
        
        // Step 1: Run migrations
        console.log('📦 STEP 1: Running Migrations');
        console.log('───────────────────────────────────────────────────────\n');
        await runMigrations();
        
        console.log('\n───────────────────────────────────────────────────────\n');
        
        // Step 2: Run seeds
        console.log('📦 STEP 2: Running Seeds');
        console.log('───────────────────────────────────────────────────────\n');
        await runSeeds();
        
        console.log('\n═══════════════════════════════════════════════════════');
        console.log('✅ DATABASE SETUP COMPLETED SUCCESSFULLY!');
        console.log('═══════════════════════════════════════════════════════\n');
        
        console.log('📋 Summary:');
        console.log('   ✅ All migrations executed');
        console.log('   ✅ All seeds executed');
        console.log('   ✅ Database is ready to use\n');
        
    } catch (error) {
        console.error('\n═══════════════════════════════════════════════════════');
        console.error('❌ DATABASE SETUP FAILED!');
        console.error('═══════════════════════════════════════════════════════\n');
        console.error('Error:', error.message);
        throw error;
    }
}

// Run setup if called directly
if (require.main === module) {
    setupDatabase()
        .then(() => {
            console.log('✅ Setup process completed successfully');
            process.exit(0);
        })
        .catch((error) => {
            console.error('❌ Setup process failed:', error);
            process.exit(1);
        });
}

module.exports = { setupDatabase };
