-- Stock adjustment queries for POS/Inpatient sales
-- For direct SQL execution, set variables below.

SET @qty = 1;
SET @warehouse_id = 1;
SET @stock_id = 1;
SET @barcode = 'ABC123';

-- 1) Deduct warehouse stock by warehouse + stock id
UPDATE tbl_warehouse_stock
SET quantity = quantity - @qty
WHERE warehouse_id = @warehouse_id AND stock_id = @stock_id;

-- 2) Deduct warehouse stock by warehouse + barcode (fallback)
UPDATE tbl_warehouse_stock ws
INNER JOIN tbl_stock s ON ws.stock_id = s.id
SET ws.quantity = ws.quantity - @qty
WHERE ws.warehouse_id = @warehouse_id AND s.barcode = @barcode;

-- 3) Deduct main stock by stock id
UPDATE tbl_stock
SET qty = qty - @qty
WHERE id = @stock_id;

-- 4) Deduct main stock by barcode (fallback)
UPDATE tbl_stock
SET qty = qty - @qty
WHERE barcode = @barcode;

