-- Update EMR Schema
-- Add additional fields to tbl_treatment for comprehensive EMR

-- Add columns to tbl_treatment if they don't exist
ALTER TABLE tbl_treatment ADD COLUMN IF NOT EXISTS doctor_id INT NULL;
ALTER TABLE tbl_treatment ADD COLUMN IF NOT EXISTS chief_complaint TEXT NULL;
ALTER TABLE tbl_treatment ADD COLUMN IF NOT EXISTS present_illness TEXT NULL;
ALTER TABLE tbl_treatment ADD COLUMN IF NOT EXISTS diagnosis TEXT NULL;
ALTER TABLE tbl_treatment ADD COLUMN IF NOT EXISTS prescription TEXT NULL;
ALTER TABLE tbl_treatment ADD COLUMN IF NOT EXISTS vital_signs TEXT NULL;
ALTER TABLE tbl_treatment ADD COLUMN IF NOT EXISTS notes TEXT NULL;

-- Update tbl_images to support treatment_id
ALTER TABLE tbl_images ADD COLUMN IF NOT EXISTS treatment_id INT NULL;
ALTER TABLE tbl_images ADD COLUMN IF NOT EXISTS image_path VARCHAR(255) NULL;
ALTER TABLE tbl_images ADD COLUMN IF NOT EXISTS upload_date DATETIME DEFAULT CURRENT_TIMESTAMP;

-- Add indexes for better performance
CREATE INDEX IF NOT EXISTS idx_treatment_patient ON tbl_treatment(patient_id);
CREATE INDEX IF NOT EXISTS idx_treatment_doctor ON tbl_treatment(doctor_id);
CREATE INDEX IF NOT EXISTS idx_treatment_date ON tbl_treatment(Date);
CREATE INDEX IF NOT EXISTS idx_images_treatment ON tbl_images(treatment_id);
CREATE INDEX IF NOT EXISTS idx_images_patient ON tbl_images(patient_id);

-- Add foreign key relationships (optional, comment out if issues)
-- ALTER TABLE tbl_treatment ADD CONSTRAINT fk_treatment_doctor 
--     FOREIGN KEY (doctor_id) REFERENCES tbl_doctor(id) ON DELETE SET NULL;

-- ALTER TABLE tbl_images ADD CONSTRAINT fk_images_treatment 
--     FOREIGN KEY (treatment_id) REFERENCES tbl_treatment(id) ON DELETE CASCADE;

