-- Update tbl_shopinfo schema to support logo path

-- Add photo_path column if it doesn't exist
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS photo_path VARCHAR(255) NULL;

-- Ensure all required columns exist
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS name VARCHAR(50) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS type VARCHAR(50) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS ph_no VARCHAR(50) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS email VARCHAR(250) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS address VARCHAR(500) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS remark VARCHAR(250) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS thanks VARCHAR(250) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS user_code VARCHAR(250) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS product_code VARCHAR(250) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS software_code VARCHAR(250) NULL;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS printer_voucher_count INT NULL DEFAULT 1;
ALTER TABLE tbl_shopinfo ADD COLUMN IF NOT EXISTS printer VARCHAR(50) NULL DEFAULT '80mm';

-- Create default shop info if not exists
INSERT INTO tbl_shopinfo (id, name, type, ph_no, address, printer)
SELECT 1, 'Clinic Pro Medical Center', 'Clinic & Pharmacy', '09-999999999', 'Your Address Here', '80mm'
WHERE NOT EXISTS (SELECT 1 FROM tbl_shopinfo WHERE id = 1);

-- Update existing record to ensure all fields have values
UPDATE tbl_shopinfo 
SET thanks = COALESCE(thanks, 'Thank you for choosing our clinic! Stay healthy!'),
    remark = COALESCE(remark, 'Terms & Conditions apply'),
    printer = COALESCE(printer, '80mm'),
    printer_voucher_count = COALESCE(printer_voucher_count, 1)
WHERE id = 1;

