/**
 * PM2 Ecosystem Configuration
 * Clinic Pro V3 - Production Cluster Mode
 * 
 * Usage:
 *   pm2 start ecosystem.config.js
 *   pm2 save
 *   pm2 startup
 */

module.exports = {
  apps: [{
    // Application name
    name: 'clinic-pro-server',
    
    // Script to start
    script: './backend/server.js',
    
    // Cluster mode (use all CPU cores)
    instances: 'max',  // Or specify number: 2, 4, etc.
    exec_mode: 'cluster',
    
    // Watch for file changes (disable in production)
    watch: false,
    
    // Restart if memory exceeds 500MB
    max_memory_restart: '500M',
    
    // Environment variables
    env: {
      NODE_ENV: 'production',
      PORT: 5000
    },
    
    // Development environment (use: pm2 start ecosystem.config.js --env development)
    env_development: {
      NODE_ENV: 'development',
      PORT: 5000
    },
    
    // Logging
    error_file: './logs/pm2-error.log',
    out_file: './logs/pm2-output.log',
    log_date_format: 'YYYY-MM-DD HH:mm:ss Z',
    merge_logs: true,
    
    // Auto restart settings
    autorestart: true,
    max_restarts: 10,  // Max restarts within 1 minute
    min_uptime: '10s',  // Min uptime before considered stable
    
    // Graceful shutdown
    kill_timeout: 5000,
    listen_timeout: 3000,
    
    // Additional options
    instance_var: 'INSTANCE_ID',
    
    // Cron restart (optional - restart at 3 AM daily)
    // cron_restart: '0 3 * * *',
    
    // Time before force restart when using cluster mode
    wait_ready: true,
    
    // Health check (PM2 Plus feature)
    // health: {
    //   interval: 30000,
    //   threshold: {
    //     cpu: 80,
    //     memory: 500
    //   }
    // }
  }],
  
  // Deployment configuration (optional)
  deploy: {
    production: {
      user: 'root',
      host: 'your-server-ip',
      ref: 'origin/main',
      repo: 'git@github.com:yourusername/clinic-pro-v3.git',
      path: '/var/www/html/clinic-pro-v3',
      'post-deploy': 'cd backend && npm install && pm2 reload ecosystem.config.js --env production'
    }
  }
};

