/**
 * Script to add favicon links to all HTML pages
 * Run with: node add-favicon-to-pages.js
 */

const fs = require('fs');
const path = require('path');

const pagesDir = path.join(__dirname, 'pages');
const faviconLinks = `    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="../favicon.svg">
    <link rel="icon" type="image/png" href="../favicon.png">
    <link rel="apple-touch-icon" href="../favicon.png">
    
`;

// Get all HTML files in pages directory
const htmlFiles = fs.readdirSync(pagesDir).filter(file => file.endsWith('.html'));

let updatedCount = 0;

htmlFiles.forEach(file => {
    const filePath = path.join(pagesDir, file);
    let content = fs.readFileSync(filePath, 'utf8');
    
    // Check if favicon already exists
    if (content.includes('favicon.svg') || content.includes('favicon.png')) {
        console.log(`⏭️  Skipping ${file} - favicon already exists`);
        return;
    }
    
    // Find the title tag and add favicon after it
    const titlePattern = /(<title[^>]*>.*?<\/title>)/s;
    const match = content.match(titlePattern);
    
    if (match) {
        const titleTag = match[1];
        const replacement = titleTag + '\n' + faviconLinks;
        content = content.replace(titleTag, replacement);
        
        fs.writeFileSync(filePath, content, 'utf8');
        console.log(`✅ Updated ${file}`);
        updatedCount++;
    } else {
        console.log(`⚠️  Could not find title tag in ${file}`);
    }
});

console.log(`\n✨ Done! Updated ${updatedCount} files.`);

