/**
 * Script to add UX utilities to all HTML pages
 */

const fs = require('fs');
const path = require('path');

const frontendPagesDir = path.join(__dirname, '../frontend/pages');
const files = fs.readdirSync(frontendPagesDir).filter(f => f.endsWith('.html'));

let addedCount = 0;
let skippedCount = 0;

files.forEach(file => {
    const filePath = path.join(frontendPagesDir, file);
    let content = fs.readFileSync(filePath, 'utf8');
    let modified = false;

    // Add CSS if not present
    if (!content.includes('ux-utils.css')) {
        // Try to find toast.css or glass-theme.css to add after
        if (content.includes('toast.css')) {
            content = content.replace(
                /<link[^>]*toast\.css[^>]*>/i,
                match => match + '\n    <link rel="stylesheet" href="../css/ux-utils.css">'
            );
            modified = true;
        } else if (content.includes('glass-theme.css')) {
            content = content.replace(
                /<link[^>]*glass-theme\.css[^>]*>/i,
                match => match + '\n    <link rel="stylesheet" href="../css/ux-utils.css">'
            );
            modified = true;
        }
    }

    // Add JS if not present
    if (!content.includes('ux-utils.js')) {
        // Try to find toast.js to add after
        if (content.includes('toast.js')) {
            content = content.replace(
                /<script[^>]*toast\.js[^>]*><\/script>/i,
                match => match + '\n    <script src="../js/ux-utils.js"></script>'
            );
            modified = true;
        } else if (content.includes('bootstrap.bundle.min.js')) {
            // Add after bootstrap
            content = content.replace(
                /<script[^>]*bootstrap\.bundle\.min\.js[^>]*><\/script>/i,
                match => match + '\n    <script src="../js/ux-utils.js"></script>'
            );
            modified = true;
        }
    }

    if (modified) {
        fs.writeFileSync(filePath, content, 'utf8');
        addedCount++;
        console.log(`✓ Added UX utilities to ${file}`);
    } else {
        skippedCount++;
        console.log(`- Skipped ${file} (already has or no insertion point)`);
    }
});

console.log(`\n✅ Complete! Added to ${addedCount} files, skipped ${skippedCount} files.`);

