// Referring Doctor Integration for POS Page
// Add this code to pos.html <script> section

// Global variables for referring doctors
let referringDoctorsData = [];
let referringDoctorsLoaded = false;

// Load referring doctors from API
async function loadReferringDoctors() {
    if (referringDoctorsLoaded) {
        console.log('Referring doctors already loaded, skipping...');
        return;
    }
    
    try {
        const response = await fetch('/api/referring-doctors?active=true&limit=1000', {
            headers: { 'Authorization': `Bearer ${getAuthToken()}` }
        });
        
        if (!response.ok) {
            console.warn('Could not load referring doctors');
            return;
        }
        
        const data = await response.json();
        if (data.success && data.data) {
            referringDoctorsData = data.data;
            populateReferringDoctorList();
            referringDoctorsLoaded = true;
            console.log(`Loaded ${referringDoctorsData.length} referring doctors`);
        }
    } catch (error) {
        console.warn('Error loading referring doctors:', error);
    }
}

// Populate referring doctor dropdowns
function populateReferringDoctorList() {
    const desktopList = document.getElementById('referringDoctorList');
    const mobileList = document.getElementById('mobileReferringDoctorList');
    
    if (!desktopList || !mobileList) return;
    
    // Clear existing options
    desktopList.innerHTML = '<option value="">None</option>';
    mobileList.innerHTML = '<option value="">None</option>';
    
    // Add referring doctor options
    referringDoctorsData.forEach(doctor => {
        const optionValue = doctor.name;
        const displayText = `${doctor.name}${doctor.specialty ? ' - ' + doctor.specialty : ''}`;
        
        // Desktop dropdown
        const desktopOption = document.createElement('option');
        desktopOption.value = optionValue;
        desktopOption.textContent = displayText;
        desktopOption.setAttribute('data-doctor-id', doctor.id);
        desktopOption.setAttribute('data-commission-type', doctor.commission_type);
        desktopOption.setAttribute('data-commission-value', doctor.commission_value);
        desktopList.appendChild(desktopOption);
        
        // Mobile dropdown
        const mobileOption = document.createElement('option');
        mobileOption.value = optionValue;
        mobileOption.textContent = displayText;
        mobileOption.setAttribute('data-doctor-id', doctor.id);
        mobileList.appendChild(mobileOption);
    });
}

// Handle referring doctor selection (Desktop)
document.getElementById('referringDoctorName').addEventListener('input', function() {
    const selectedName = this.value;
    const doctor = referringDoctorsData.find(d => d.name === selectedName);
    
    if (doctor) {
        document.getElementById('selectedReferringDoctorId').value = doctor.id;
        console.log('Selected referring doctor:', doctor.name, `(ID: ${doctor.id})`);
        
        // Show commission info if configured
        if (doctor.commission_type !== 'none') {
            const commissionInfo = doctor.commission_type === 'percentage' 
                ? `${doctor.commission_value}% commission`
                : `${doctor.commission_value} fixed commission`;
            console.log('Commission:', commissionInfo);
        }
    } else {
        document.getElementById('selectedReferringDoctorId').value = '';
    }
});

// Handle referring doctor selection (Mobile)
document.getElementById('mobileReferringDoctorName').addEventListener('input', function() {
    const selectedName = this.value;
    const doctor = referringDoctorsData.find(d => d.name === selectedName);
    
    if (doctor) {
        // Store in dataset for mobile use
        this.dataset.doctorId = doctor.id;
        // Also sync with desktop field
        document.getElementById('selectedReferringDoctorId').value = doctor.id;
        document.getElementById('referringDoctorName').value = doctor.name;
    } else {
        this.dataset.doctorId = '';
    }
});

// IMPORTANT: Update the completeSale function
// Find the line where saleData object is created and add these two fields:
/*
const saleData = {
    items: cart.map(item => ({
        barcode: item.barcode,
        name: item.name,
        price: item.price,
        quantity: item.quantity,
        discount: item.discount || 0,
        item_type: item.item_type
    })),
    doctor_id: document.getElementById('selectedDoctorId').value || null,
    doctor_name: document.getElementById('doctorName').value || null,
    customer_name: document.getElementById('customerName').value || 'Walk-in',
    patient_id: document.getElementById('selectedPatientId').value || null,
    
    // ADD THESE TWO LINES:
    referring_doctor_id: document.getElementById('selectedReferringDoctorId').value || null,
    referring_doctor_name: document.getElementById('referringDoctorName').value || null,
    
    sub_total: parseFloat(document.getElementById('subtotal').textContent.replace(/[^\d.]/g, '')),
    discount: parseFloat(document.getElementById('discount').value) || 0,
    tax: 0,
    total: parseFloat(document.getElementById('grandTotal').textContent.replace(/[^\d.]/g, '')),
    payment_method: document.getElementById('paymentMethod').value,
    cashier: 'Current User'
};
*/

// Also update mobile sale submission (mobileCompleteSaleBtn)
// Add the same two fields to mobile saleData object

console.log('Referring Doctor Integration loaded successfully!');

