import type { jsPDF, jsPDFOptions } from 'jspdf';
import type { Options as Html2CanvasOptions } from 'html2canvas';
type WaterMarkHandlerParam = {
    pdf: jsPDF;
    pageNumber: number;
    totalPageNumber: number;
    imgNode: HTMLImageElement;
};
type WaterMarkOptions = {
    scale: number;
    src?: string;
    handler?: (param: WaterMarkHandlerParam) => void;
} | ((param: Omit<WaterMarkHandlerParam, 'imgNode'>) => void) | string;
export interface Options {
    jsPDF: Partial<jsPDFOptions>;
    html2canvas: Partial<Html2CanvasOptions>;
    margin: {
        right: number;
        top: number;
        bottom: number;
        left: number;
    };
    imageType: string;
    imageQuality: number;
    output: string;
    autoResize: boolean;
    watermarkImg?: HTMLImageElement;
    watermark?: WaterMarkOptions;
    init: (this: Options, pdf: jsPDF) => Promise<void> | void;
    success: (pdf: jsPDF) => Promise<void> | void;
}
export interface PdfInstance {
    pdf: jsPDF;
    pdfWidth: number;
    pdfHeight: number;
    pdfContentWidth: number;
    pdfContentHeight: number;
    position: number;
    currentPage: number;
    pageOfCurrentNode: number;
}
export type jsPDFInternal = jsPDF['internal'] & {
    getNumberOfPages: () => number;
};
export {};
