<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <title>Return _<?php echo e($return_sale['Ref']); ?></title>
      <link rel="stylesheet" href="<?php echo e(asset('/css/pdf_style.css')); ?>" media="all" />
   </head>

   <body>
      <header class="clearfix">
         <div id="logo">
         <img src="<?php echo e(asset('/images/'.$setting['logo'])); ?>">
         </div>
         <div id="company">
            <div><strong> Date : </strong><?php echo e($return_sale['date']); ?></div>
            <div><strong> Number : </strong> <?php echo e($return_sale['Ref']); ?></div>
            <div><strong> Sale Ref : </strong> <?php echo e($return_sale['sale_ref']); ?></div>
            <div><strong> Status : </strong> <?php echo e($return_sale['statut']); ?></div>
            <div><strong> Payment Status : </strong> <?php echo e($return_sale['payment_status']); ?></div>

         </div>
         <div id="Title-heading">
            Return  : <?php echo e($return_sale['Ref']); ?>

         </div>
         </div>
      </header>
      <main>
         <div id="details" class="clearfix">
            <div id="client">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Customer Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div><strong>Name :</strong> <?php echo e($return_sale['client_name']); ?></div>
                           <div><strong>Phone :</strong> <?php echo e($return_sale['client_phone']); ?></div>
                           <div><strong>Email :</strong>  <?php echo e($return_sale['client_email']); ?></div>
                           <div><strong>Address :</strong>   <?php echo e($return_sale['client_adr']); ?></div>
                           <?php if($return_sale['client_tax']): ?><div><strong>Tax Number :</strong>  <?php echo e($return_sale['client_tax']); ?></div><?php endif; ?>
                           
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
            <div id="invoice">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Company Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div id="comp"><?php echo e($setting['CompanyName']); ?></div>
                           <div><strong>Phone :</strong>  <?php echo e($setting['CompanyPhone']); ?></div>
                           <div><strong>Email :</strong>  <?php echo e($setting['email']); ?></div>
                           <div><strong>Address :</strong>  <?php echo e($setting['CompanyAdress']); ?></div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
         </div>
         <div id="details_inv">
            <table class="table-sm">
               <thead>
                  <tr>
                     <th>PRODUCT</th>
                     <th>UNIT PRICE</th>
                     <th>QUANTITY</th>
                     <th>DISCOUNT</th>
                     <th>TAX</th>
                     <th>TOTAL</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                  <tr>
                     <td>
                        <span><?php echo e($detail['code']); ?> (<?php echo e($detail['name']); ?>)</span>
                           <?php if($detail['is_imei'] && $detail['imei_number'] !==null): ?>
                              <p>IMEI/SN : <?php echo e($detail['imei_number']); ?></p>
                           <?php endif; ?>
                     </td>
                     <td><?php echo e($detail['price']); ?> </td>
                     <td><?php echo e($detail['quantity']); ?>/<?php echo e($detail['unitSale']); ?></td>
                     <td><?php echo e($detail['DiscountNet']); ?> </td>
                     <td><?php echo e($detail['taxe']); ?> </td>
                     <td><?php echo e($detail['total']); ?> </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               </tbody>
            </table>
         </div>
         <div id="total">
            <table>
               <tr>
                  <td>Order Tax</td>
                  <td><?php echo e($return_sale['TaxNet']); ?> </td>
               </tr>
               <tr>
                  <td>Discount</td>
                  <td><?php echo e($return_sale['discount']); ?> </td>
               </tr>
               <tr>
                  <td>Shipping</td>
                  <td><?php echo e($return_sale['shipping']); ?> </td>
               </tr>
               <tr>
                  <td>Total</td>
                  <td><?php echo e($symbol); ?> <?php echo e($return_sale['GrandTotal']); ?> </td>
               </tr>

               <tr>
                  <td>Paid Amount</td>
                  <td><?php echo e($symbol); ?> <?php echo e($return_sale['paid_amount']); ?> </td>
               </tr>

               <tr>
                  <td>Due</td>
                  <td><?php echo e($symbol); ?> <?php echo e($return_sale['due']); ?> </td>
               </tr>
            </table>
         </div>
         <div id="signature">
            <?php if($setting['is_invoice_footer'] && $setting['invoice_footer'] !==null): ?>
               <p><?php echo e($setting['invoice_footer']); ?></p>
            <?php endif; ?>
         </div>
      </main>
   </body>
</html><?php /**PATH /var/www/html/htdocs/resources/views/pdf/Sales_Return_pdf.blade.php ENDPATH**/ ?>