<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <title>Purchase _<?php echo e($purchase['Ref']); ?></title>
      <link rel="stylesheet" href="<?php echo e(asset('/css/pdf_style.css')); ?>" media="all" />
   </head>

   <body>
      <header class="clearfix">
         <div id="logo">
         <img src="<?php echo e(asset('/images/'.$setting['logo'])); ?>">
         </div>
         <div id="company">
            <div><strong> Date: </strong><?php echo e($purchase['date']); ?></div>
            <div><strong> Number: </strong> <?php echo e($purchase['Ref']); ?></div>
            <div><strong> Status: </strong> <?php echo e($purchase['statut']); ?></div>
            <div><strong> Payment Status: </strong> <?php echo e($purchase['payment_status']); ?></div>
         </div>
         <div id="Title-heading">
             Purchase  : <?php echo e($purchase['Ref']); ?>

         </div>
         </div>
      </header>
      <main>
         <div id="details" class="clearfix">
            <div id="client">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Supplier Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div><strong>Full Name :</strong> <?php echo e($purchase['supplier_name']); ?></div>
                           <div><strong>Phone :</strong> <?php echo e($purchase['supplier_phone']); ?></div>
                           <div><strong>Address :</strong>   <?php echo e($purchase['supplier_adr']); ?></div>
                           <div><strong>Email :</strong>  <?php echo e($purchase['supplier_email']); ?></div>
                           <?php if($purchase['supplier_tax']): ?><div><strong>Tax Number :</strong>  <?php echo e($purchase['supplier_tax']); ?></div><?php endif; ?>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
            <div id="invoice">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Company Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div id="comp"><?php echo e($setting['CompanyName']); ?></div>
                           <div><strong>Address :</strong>  <?php echo e($setting['CompanyAdress']); ?></div>
                           <div><strong>Phone :</strong>  <?php echo e($setting['CompanyPhone']); ?></div>
                           <div><strong>Email :</strong>  <?php echo e($setting['email']); ?></div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
         </div>
         <div id="details_inv">
            <table class="table-sm">
               <thead>
                  <tr>
                     <th>PRODUCT</th>
                     <th>UNIT COST</th>
                     <th>QUANTITY</th>
                     <th>DISCOUNT</th>
                     <th>TAX</th>
                     <th>TOTAL</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                  <tr>
                     <td>
                        <span><?php echo e($detail['code']); ?> (<?php echo e($detail['name']); ?>)</span>
                           <?php if($detail['is_imei'] && $detail['imei_number'] !==null): ?>
                              <p>IMEI/SN : <?php echo e($detail['imei_number']); ?></p>
                           <?php endif; ?>
                     </td>
                     <td><?php echo e($detail['cost']); ?> </td>
                     <td><?php echo e($detail['quantity']); ?>/<?php echo e($detail['unit_purchase']); ?></td>
                     <td><?php echo e($detail['DiscountNet']); ?> </td>
                     <td><?php echo e($detail['taxe']); ?> </td>
                     <td><?php echo e($detail['total']); ?> </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               </tbody>
            </table>
         </div>
         <div id="total">
            <table>
               <tr>
                  <td>Order Tax</td>
                  <td><?php echo e($purchase['TaxNet']); ?> </td>
               </tr>
               <tr>
                  <td>Discount</td>
                  <td><?php echo e($purchase['discount']); ?> </td>
               </tr>
               <tr>
                  <td>Shipping</td>
                  <td><?php echo e($purchase['shipping']); ?> </td>
               </tr>
               <tr>
                  <td>Total</td>
                  <td><?php echo e($symbol); ?> <?php echo e($purchase['GrandTotal']); ?> </td>
               </tr>

               <tr>
                  <td>Paid Amount</td>
                  <td><?php echo e($symbol); ?> <?php echo e($purchase['paid_amount']); ?> </td>
               </tr>

               <tr>
                  <td>Due</td>
                  <td><?php echo e($symbol); ?> <?php echo e($purchase['due']); ?> </td>
               </tr>
            </table>
         </div>
         <div id="signature">
            <?php if($setting['is_invoice_footer'] && $setting['invoice_footer'] !==null): ?>
               <p><?php echo e($setting['invoice_footer']); ?></p>
            <?php endif; ?>
         </div>
      </main>
   </body>
</html><?php /**PATH /var/www/html/htdocs/resources/views/pdf/purchase_pdf.blade.php ENDPATH**/ ?>