/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/axios/index.js":
/*!*************************************!*\
  !*** ./node_modules/axios/index.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! ./lib/axios */ "./node_modules/axios/lib/axios.js");

/***/ }),

/***/ "./node_modules/axios/lib/adapters/xhr.js":
/*!************************************************!*\
  !*** ./node_modules/axios/lib/adapters/xhr.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var settle = __webpack_require__(/*! ./../core/settle */ "./node_modules/axios/lib/core/settle.js");
var buildURL = __webpack_require__(/*! ./../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");
var buildFullPath = __webpack_require__(/*! ../core/buildFullPath */ "./node_modules/axios/lib/core/buildFullPath.js");
var parseHeaders = __webpack_require__(/*! ./../helpers/parseHeaders */ "./node_modules/axios/lib/helpers/parseHeaders.js");
var isURLSameOrigin = __webpack_require__(/*! ./../helpers/isURLSameOrigin */ "./node_modules/axios/lib/helpers/isURLSameOrigin.js");
var createError = __webpack_require__(/*! ../core/createError */ "./node_modules/axios/lib/core/createError.js");

module.exports = function xhrAdapter(config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    var requestData = config.data;
    var requestHeaders = config.headers;

    if (utils.isFormData(requestData)) {
      delete requestHeaders['Content-Type']; // Let the browser set it
    }

    var request = new XMLHttpRequest();

    // HTTP basic authentication
    if (config.auth) {
      var username = config.auth.username || '';
      var password = config.auth.password || '';
      requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);
    }

    var fullPath = buildFullPath(config.baseURL, config.url);
    request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);

    // Set the request timeout in MS
    request.timeout = config.timeout;

    // Listen for ready state
    request.onreadystatechange = function handleLoad() {
      if (!request || request.readyState !== 4) {
        return;
      }

      // The request errored out and we didn't get a response, this will be
      // handled by onerror instead
      // With one exception: request that using file: protocol, most browsers
      // will return status as 0 even though it's a successful request
      if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
        return;
      }

      // Prepare the response
      var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;
      var responseData = !config.responseType || config.responseType === 'text' ? request.responseText : request.response;
      var response = {
        data: responseData,
        status: request.status,
        statusText: request.statusText,
        headers: responseHeaders,
        config: config,
        request: request
      };

      settle(resolve, reject, response);

      // Clean up request
      request = null;
    };

    // Handle browser request cancellation (as opposed to a manual cancellation)
    request.onabort = function handleAbort() {
      if (!request) {
        return;
      }

      reject(createError('Request aborted', config, 'ECONNABORTED', request));

      // Clean up request
      request = null;
    };

    // Handle low level network errors
    request.onerror = function handleError() {
      // Real errors are hidden from us by the browser
      // onerror should only fire if it's a network error
      reject(createError('Network Error', config, null, request));

      // Clean up request
      request = null;
    };

    // Handle timeout
    request.ontimeout = function handleTimeout() {
      var timeoutErrorMessage = 'timeout of ' + config.timeout + 'ms exceeded';
      if (config.timeoutErrorMessage) {
        timeoutErrorMessage = config.timeoutErrorMessage;
      }
      reject(createError(timeoutErrorMessage, config, 'ECONNABORTED',
        request));

      // Clean up request
      request = null;
    };

    // Add xsrf header
    // This is only done if running in a standard browser environment.
    // Specifically not if we're in a web worker, or react-native.
    if (utils.isStandardBrowserEnv()) {
      var cookies = __webpack_require__(/*! ./../helpers/cookies */ "./node_modules/axios/lib/helpers/cookies.js");

      // Add xsrf header
      var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ?
        cookies.read(config.xsrfCookieName) :
        undefined;

      if (xsrfValue) {
        requestHeaders[config.xsrfHeaderName] = xsrfValue;
      }
    }

    // Add headers to the request
    if ('setRequestHeader' in request) {
      utils.forEach(requestHeaders, function setRequestHeader(val, key) {
        if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {
          // Remove Content-Type if data is undefined
          delete requestHeaders[key];
        } else {
          // Otherwise add header to the request
          request.setRequestHeader(key, val);
        }
      });
    }

    // Add withCredentials to request if needed
    if (!utils.isUndefined(config.withCredentials)) {
      request.withCredentials = !!config.withCredentials;
    }

    // Add responseType to request if needed
    if (config.responseType) {
      try {
        request.responseType = config.responseType;
      } catch (e) {
        // Expected DOMException thrown by browsers not compatible XMLHttpRequest Level 2.
        // But, this can be suppressed for 'json' type as it can be parsed by default 'transformResponse' function.
        if (config.responseType !== 'json') {
          throw e;
        }
      }
    }

    // Handle progress if needed
    if (typeof config.onDownloadProgress === 'function') {
      request.addEventListener('progress', config.onDownloadProgress);
    }

    // Not all browsers support upload events
    if (typeof config.onUploadProgress === 'function' && request.upload) {
      request.upload.addEventListener('progress', config.onUploadProgress);
    }

    if (config.cancelToken) {
      // Handle cancellation
      config.cancelToken.promise.then(function onCanceled(cancel) {
        if (!request) {
          return;
        }

        request.abort();
        reject(cancel);
        // Clean up request
        request = null;
      });
    }

    if (requestData === undefined) {
      requestData = null;
    }

    // Send the request
    request.send(requestData);
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/axios.js":
/*!*****************************************!*\
  !*** ./node_modules/axios/lib/axios.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");
var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");
var Axios = __webpack_require__(/*! ./core/Axios */ "./node_modules/axios/lib/core/Axios.js");
var mergeConfig = __webpack_require__(/*! ./core/mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");
var defaults = __webpack_require__(/*! ./defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Create an instance of Axios
 *
 * @param {Object} defaultConfig The default config for the instance
 * @return {Axios} A new instance of Axios
 */
function createInstance(defaultConfig) {
  var context = new Axios(defaultConfig);
  var instance = bind(Axios.prototype.request, context);

  // Copy axios.prototype to instance
  utils.extend(instance, Axios.prototype, context);

  // Copy context to instance
  utils.extend(instance, context);

  return instance;
}

// Create the default instance to be exported
var axios = createInstance(defaults);

// Expose Axios class to allow class inheritance
axios.Axios = Axios;

// Factory for creating new instances
axios.create = function create(instanceConfig) {
  return createInstance(mergeConfig(axios.defaults, instanceConfig));
};

// Expose Cancel & CancelToken
axios.Cancel = __webpack_require__(/*! ./cancel/Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");
axios.CancelToken = __webpack_require__(/*! ./cancel/CancelToken */ "./node_modules/axios/lib/cancel/CancelToken.js");
axios.isCancel = __webpack_require__(/*! ./cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");

// Expose all/spread
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = __webpack_require__(/*! ./helpers/spread */ "./node_modules/axios/lib/helpers/spread.js");

module.exports = axios;

// Allow use of default import syntax in TypeScript
module.exports["default"] = axios;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/Cancel.js":
/*!*************************************************!*\
  !*** ./node_modules/axios/lib/cancel/Cancel.js ***!
  \*************************************************/
/***/ ((module) => {

"use strict";


/**
 * A `Cancel` is an object that is thrown when an operation is canceled.
 *
 * @class
 * @param {string=} message The message.
 */
function Cancel(message) {
  this.message = message;
}

Cancel.prototype.toString = function toString() {
  return 'Cancel' + (this.message ? ': ' + this.message : '');
};

Cancel.prototype.__CANCEL__ = true;

module.exports = Cancel;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/CancelToken.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/cancel/CancelToken.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var Cancel = __webpack_require__(/*! ./Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");

/**
 * A `CancelToken` is an object that can be used to request cancellation of an operation.
 *
 * @class
 * @param {Function} executor The executor function.
 */
function CancelToken(executor) {
  if (typeof executor !== 'function') {
    throw new TypeError('executor must be a function.');
  }

  var resolvePromise;
  this.promise = new Promise(function promiseExecutor(resolve) {
    resolvePromise = resolve;
  });

  var token = this;
  executor(function cancel(message) {
    if (token.reason) {
      // Cancellation has already been requested
      return;
    }

    token.reason = new Cancel(message);
    resolvePromise(token.reason);
  });
}

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
CancelToken.prototype.throwIfRequested = function throwIfRequested() {
  if (this.reason) {
    throw this.reason;
  }
};

/**
 * Returns an object that contains a new `CancelToken` and a function that, when called,
 * cancels the `CancelToken`.
 */
CancelToken.source = function source() {
  var cancel;
  var token = new CancelToken(function executor(c) {
    cancel = c;
  });
  return {
    token: token,
    cancel: cancel
  };
};

module.exports = CancelToken;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/isCancel.js":
/*!***************************************************!*\
  !*** ./node_modules/axios/lib/cancel/isCancel.js ***!
  \***************************************************/
/***/ ((module) => {

"use strict";


module.exports = function isCancel(value) {
  return !!(value && value.__CANCEL__);
};


/***/ }),

/***/ "./node_modules/axios/lib/core/Axios.js":
/*!**********************************************!*\
  !*** ./node_modules/axios/lib/core/Axios.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var buildURL = __webpack_require__(/*! ../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");
var InterceptorManager = __webpack_require__(/*! ./InterceptorManager */ "./node_modules/axios/lib/core/InterceptorManager.js");
var dispatchRequest = __webpack_require__(/*! ./dispatchRequest */ "./node_modules/axios/lib/core/dispatchRequest.js");
var mergeConfig = __webpack_require__(/*! ./mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");

/**
 * Create a new instance of Axios
 *
 * @param {Object} instanceConfig The default config for the instance
 */
function Axios(instanceConfig) {
  this.defaults = instanceConfig;
  this.interceptors = {
    request: new InterceptorManager(),
    response: new InterceptorManager()
  };
}

/**
 * Dispatch a request
 *
 * @param {Object} config The config specific for this request (merged with this.defaults)
 */
Axios.prototype.request = function request(config) {
  /*eslint no-param-reassign:0*/
  // Allow for axios('example/url'[, config]) a la fetch API
  if (typeof config === 'string') {
    config = arguments[1] || {};
    config.url = arguments[0];
  } else {
    config = config || {};
  }

  config = mergeConfig(this.defaults, config);

  // Set config.method
  if (config.method) {
    config.method = config.method.toLowerCase();
  } else if (this.defaults.method) {
    config.method = this.defaults.method.toLowerCase();
  } else {
    config.method = 'get';
  }

  // Hook up interceptors middleware
  var chain = [dispatchRequest, undefined];
  var promise = Promise.resolve(config);

  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
    chain.unshift(interceptor.fulfilled, interceptor.rejected);
  });

  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
    chain.push(interceptor.fulfilled, interceptor.rejected);
  });

  while (chain.length) {
    promise = promise.then(chain.shift(), chain.shift());
  }

  return promise;
};

Axios.prototype.getUri = function getUri(config) {
  config = mergeConfig(this.defaults, config);
  return buildURL(config.url, config.params, config.paramsSerializer).replace(/^\?/, '');
};

// Provide aliases for supported request methods
utils.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, config) {
    return this.request(utils.merge(config || {}, {
      method: method,
      url: url
    }));
  };
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, data, config) {
    return this.request(utils.merge(config || {}, {
      method: method,
      url: url,
      data: data
    }));
  };
});

module.exports = Axios;


/***/ }),

/***/ "./node_modules/axios/lib/core/InterceptorManager.js":
/*!***********************************************************!*\
  !*** ./node_modules/axios/lib/core/InterceptorManager.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

function InterceptorManager() {
  this.handlers = [];
}

/**
 * Add a new interceptor to the stack
 *
 * @param {Function} fulfilled The function to handle `then` for a `Promise`
 * @param {Function} rejected The function to handle `reject` for a `Promise`
 *
 * @return {Number} An ID used to remove interceptor later
 */
InterceptorManager.prototype.use = function use(fulfilled, rejected) {
  this.handlers.push({
    fulfilled: fulfilled,
    rejected: rejected
  });
  return this.handlers.length - 1;
};

/**
 * Remove an interceptor from the stack
 *
 * @param {Number} id The ID that was returned by `use`
 */
InterceptorManager.prototype.eject = function eject(id) {
  if (this.handlers[id]) {
    this.handlers[id] = null;
  }
};

/**
 * Iterate over all the registered interceptors
 *
 * This method is particularly useful for skipping over any
 * interceptors that may have become `null` calling `eject`.
 *
 * @param {Function} fn The function to call for each interceptor
 */
InterceptorManager.prototype.forEach = function forEach(fn) {
  utils.forEach(this.handlers, function forEachHandler(h) {
    if (h !== null) {
      fn(h);
    }
  });
};

module.exports = InterceptorManager;


/***/ }),

/***/ "./node_modules/axios/lib/core/buildFullPath.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/core/buildFullPath.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isAbsoluteURL = __webpack_require__(/*! ../helpers/isAbsoluteURL */ "./node_modules/axios/lib/helpers/isAbsoluteURL.js");
var combineURLs = __webpack_require__(/*! ../helpers/combineURLs */ "./node_modules/axios/lib/helpers/combineURLs.js");

/**
 * Creates a new URL by combining the baseURL with the requestedURL,
 * only when the requestedURL is not already an absolute URL.
 * If the requestURL is absolute, this function returns the requestedURL untouched.
 *
 * @param {string} baseURL The base URL
 * @param {string} requestedURL Absolute or relative URL to combine
 * @returns {string} The combined full path
 */
module.exports = function buildFullPath(baseURL, requestedURL) {
  if (baseURL && !isAbsoluteURL(requestedURL)) {
    return combineURLs(baseURL, requestedURL);
  }
  return requestedURL;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/createError.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/core/createError.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var enhanceError = __webpack_require__(/*! ./enhanceError */ "./node_modules/axios/lib/core/enhanceError.js");

/**
 * Create an Error with the specified message, config, error code, request and response.
 *
 * @param {string} message The error message.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The created error.
 */
module.exports = function createError(message, config, code, request, response) {
  var error = new Error(message);
  return enhanceError(error, config, code, request, response);
};


/***/ }),

/***/ "./node_modules/axios/lib/core/dispatchRequest.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/core/dispatchRequest.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var transformData = __webpack_require__(/*! ./transformData */ "./node_modules/axios/lib/core/transformData.js");
var isCancel = __webpack_require__(/*! ../cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");
var defaults = __webpack_require__(/*! ../defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
}

/**
 * Dispatch a request to the server using the configured adapter.
 *
 * @param {object} config The config that is to be used for the request
 * @returns {Promise} The Promise to be fulfilled
 */
module.exports = function dispatchRequest(config) {
  throwIfCancellationRequested(config);

  // Ensure headers exist
  config.headers = config.headers || {};

  // Transform request data
  config.data = transformData(
    config.data,
    config.headers,
    config.transformRequest
  );

  // Flatten headers
  config.headers = utils.merge(
    config.headers.common || {},
    config.headers[config.method] || {},
    config.headers
  );

  utils.forEach(
    ['delete', 'get', 'head', 'post', 'put', 'patch', 'common'],
    function cleanHeaderConfig(method) {
      delete config.headers[method];
    }
  );

  var adapter = config.adapter || defaults.adapter;

  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);

    // Transform response data
    response.data = transformData(
      response.data,
      response.headers,
      config.transformResponse
    );

    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config);

      // Transform response data
      if (reason && reason.response) {
        reason.response.data = transformData(
          reason.response.data,
          reason.response.headers,
          config.transformResponse
        );
      }
    }

    return Promise.reject(reason);
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/core/enhanceError.js":
/*!*****************************************************!*\
  !*** ./node_modules/axios/lib/core/enhanceError.js ***!
  \*****************************************************/
/***/ ((module) => {

"use strict";


/**
 * Update an Error with the specified config, error code, and response.
 *
 * @param {Error} error The error to update.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The error.
 */
module.exports = function enhanceError(error, config, code, request, response) {
  error.config = config;
  if (code) {
    error.code = code;
  }

  error.request = request;
  error.response = response;
  error.isAxiosError = true;

  error.toJSON = function() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: this.config,
      code: this.code
    };
  };
  return error;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/mergeConfig.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/core/mergeConfig.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");

/**
 * Config-specific merge-function which creates a new config-object
 * by merging two configuration objects together.
 *
 * @param {Object} config1
 * @param {Object} config2
 * @returns {Object} New object resulting from merging config2 to config1
 */
module.exports = function mergeConfig(config1, config2) {
  // eslint-disable-next-line no-param-reassign
  config2 = config2 || {};
  var config = {};

  var valueFromConfig2Keys = ['url', 'method', 'params', 'data'];
  var mergeDeepPropertiesKeys = ['headers', 'auth', 'proxy'];
  var defaultToConfig2Keys = [
    'baseURL', 'url', 'transformRequest', 'transformResponse', 'paramsSerializer',
    'timeout', 'withCredentials', 'adapter', 'responseType', 'xsrfCookieName',
    'xsrfHeaderName', 'onUploadProgress', 'onDownloadProgress',
    'maxContentLength', 'validateStatus', 'maxRedirects', 'httpAgent',
    'httpsAgent', 'cancelToken', 'socketPath'
  ];

  utils.forEach(valueFromConfig2Keys, function valueFromConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    }
  });

  utils.forEach(mergeDeepPropertiesKeys, function mergeDeepProperties(prop) {
    if (utils.isObject(config2[prop])) {
      config[prop] = utils.deepMerge(config1[prop], config2[prop]);
    } else if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (utils.isObject(config1[prop])) {
      config[prop] = utils.deepMerge(config1[prop]);
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  utils.forEach(defaultToConfig2Keys, function defaultToConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  var axiosKeys = valueFromConfig2Keys
    .concat(mergeDeepPropertiesKeys)
    .concat(defaultToConfig2Keys);

  var otherKeys = Object
    .keys(config2)
    .filter(function filterAxiosKeys(key) {
      return axiosKeys.indexOf(key) === -1;
    });

  utils.forEach(otherKeys, function otherKeysDefaultToConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  return config;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/settle.js":
/*!***********************************************!*\
  !*** ./node_modules/axios/lib/core/settle.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var createError = __webpack_require__(/*! ./createError */ "./node_modules/axios/lib/core/createError.js");

/**
 * Resolve or reject a Promise based on response status.
 *
 * @param {Function} resolve A function that resolves the promise.
 * @param {Function} reject A function that rejects the promise.
 * @param {object} response The response.
 */
module.exports = function settle(resolve, reject, response) {
  var validateStatus = response.config.validateStatus;
  if (!validateStatus || validateStatus(response.status)) {
    resolve(response);
  } else {
    reject(createError(
      'Request failed with status code ' + response.status,
      response.config,
      null,
      response.request,
      response
    ));
  }
};


/***/ }),

/***/ "./node_modules/axios/lib/core/transformData.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/core/transformData.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

/**
 * Transform the data for a request or a response
 *
 * @param {Object|String} data The data to be transformed
 * @param {Array} headers The headers for the request or response
 * @param {Array|Function} fns A single function or Array of functions
 * @returns {*} The resulting transformed data
 */
module.exports = function transformData(data, headers, fns) {
  /*eslint no-param-reassign:0*/
  utils.forEach(fns, function transform(fn) {
    data = fn(data, headers);
  });

  return data;
};


/***/ }),

/***/ "./node_modules/axios/lib/defaults.js":
/*!********************************************!*\
  !*** ./node_modules/axios/lib/defaults.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process/browser.js */ "./node_modules/process/browser.js");


var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");
var normalizeHeaderName = __webpack_require__(/*! ./helpers/normalizeHeaderName */ "./node_modules/axios/lib/helpers/normalizeHeaderName.js");

var DEFAULT_CONTENT_TYPE = {
  'Content-Type': 'application/x-www-form-urlencoded'
};

function setContentTypeIfUnset(headers, value) {
  if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {
    headers['Content-Type'] = value;
  }
}

function getDefaultAdapter() {
  var adapter;
  if (typeof XMLHttpRequest !== 'undefined') {
    // For browsers use XHR adapter
    adapter = __webpack_require__(/*! ./adapters/xhr */ "./node_modules/axios/lib/adapters/xhr.js");
  } else if (typeof process !== 'undefined' && Object.prototype.toString.call(process) === '[object process]') {
    // For node use HTTP adapter
    adapter = __webpack_require__(/*! ./adapters/http */ "./node_modules/axios/lib/adapters/xhr.js");
  }
  return adapter;
}

var defaults = {
  adapter: getDefaultAdapter(),

  transformRequest: [function transformRequest(data, headers) {
    normalizeHeaderName(headers, 'Accept');
    normalizeHeaderName(headers, 'Content-Type');
    if (utils.isFormData(data) ||
      utils.isArrayBuffer(data) ||
      utils.isBuffer(data) ||
      utils.isStream(data) ||
      utils.isFile(data) ||
      utils.isBlob(data)
    ) {
      return data;
    }
    if (utils.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (utils.isURLSearchParams(data)) {
      setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');
      return data.toString();
    }
    if (utils.isObject(data)) {
      setContentTypeIfUnset(headers, 'application/json;charset=utf-8');
      return JSON.stringify(data);
    }
    return data;
  }],

  transformResponse: [function transformResponse(data) {
    /*eslint no-param-reassign:0*/
    if (typeof data === 'string') {
      try {
        data = JSON.parse(data);
      } catch (e) { /* Ignore */ }
    }
    return data;
  }],

  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,

  xsrfCookieName: 'XSRF-TOKEN',
  xsrfHeaderName: 'X-XSRF-TOKEN',

  maxContentLength: -1,

  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  }
};

defaults.headers = {
  common: {
    'Accept': 'application/json, text/plain, */*'
  }
};

utils.forEach(['delete', 'get', 'head'], function forEachMethodNoData(method) {
  defaults.headers[method] = {};
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
});

module.exports = defaults;


/***/ }),

/***/ "./node_modules/axios/lib/helpers/bind.js":
/*!************************************************!*\
  !*** ./node_modules/axios/lib/helpers/bind.js ***!
  \************************************************/
/***/ ((module) => {

"use strict";


module.exports = function bind(fn, thisArg) {
  return function wrap() {
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }
    return fn.apply(thisArg, args);
  };
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/buildURL.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/helpers/buildURL.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

function encode(val) {
  return encodeURIComponent(val).
    replace(/%40/gi, '@').
    replace(/%3A/gi, ':').
    replace(/%24/g, '$').
    replace(/%2C/gi, ',').
    replace(/%20/g, '+').
    replace(/%5B/gi, '[').
    replace(/%5D/gi, ']');
}

/**
 * Build a URL by appending params to the end
 *
 * @param {string} url The base of the url (e.g., http://www.google.com)
 * @param {object} [params] The params to be appended
 * @returns {string} The formatted url
 */
module.exports = function buildURL(url, params, paramsSerializer) {
  /*eslint no-param-reassign:0*/
  if (!params) {
    return url;
  }

  var serializedParams;
  if (paramsSerializer) {
    serializedParams = paramsSerializer(params);
  } else if (utils.isURLSearchParams(params)) {
    serializedParams = params.toString();
  } else {
    var parts = [];

    utils.forEach(params, function serialize(val, key) {
      if (val === null || typeof val === 'undefined') {
        return;
      }

      if (utils.isArray(val)) {
        key = key + '[]';
      } else {
        val = [val];
      }

      utils.forEach(val, function parseValue(v) {
        if (utils.isDate(v)) {
          v = v.toISOString();
        } else if (utils.isObject(v)) {
          v = JSON.stringify(v);
        }
        parts.push(encode(key) + '=' + encode(v));
      });
    });

    serializedParams = parts.join('&');
  }

  if (serializedParams) {
    var hashmarkIndex = url.indexOf('#');
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }

    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
  }

  return url;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/combineURLs.js":
/*!*******************************************************!*\
  !*** ./node_modules/axios/lib/helpers/combineURLs.js ***!
  \*******************************************************/
/***/ ((module) => {

"use strict";


/**
 * Creates a new URL by combining the specified URLs
 *
 * @param {string} baseURL The base URL
 * @param {string} relativeURL The relative URL
 * @returns {string} The combined URL
 */
module.exports = function combineURLs(baseURL, relativeURL) {
  return relativeURL
    ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '')
    : baseURL;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/cookies.js":
/*!***************************************************!*\
  !*** ./node_modules/axios/lib/helpers/cookies.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs support document.cookie
    (function standardBrowserEnv() {
      return {
        write: function write(name, value, expires, path, domain, secure) {
          var cookie = [];
          cookie.push(name + '=' + encodeURIComponent(value));

          if (utils.isNumber(expires)) {
            cookie.push('expires=' + new Date(expires).toGMTString());
          }

          if (utils.isString(path)) {
            cookie.push('path=' + path);
          }

          if (utils.isString(domain)) {
            cookie.push('domain=' + domain);
          }

          if (secure === true) {
            cookie.push('secure');
          }

          document.cookie = cookie.join('; ');
        },

        read: function read(name) {
          var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
          return (match ? decodeURIComponent(match[3]) : null);
        },

        remove: function remove(name) {
          this.write(name, '', Date.now() - 86400000);
        }
      };
    })() :

  // Non standard browser env (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return {
        write: function write() {},
        read: function read() { return null; },
        remove: function remove() {}
      };
    })()
);


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isAbsoluteURL.js":
/*!*********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isAbsoluteURL.js ***!
  \*********************************************************/
/***/ ((module) => {

"use strict";


/**
 * Determines whether the specified URL is absolute
 *
 * @param {string} url The URL to test
 * @returns {boolean} True if the specified URL is absolute, otherwise false
 */
module.exports = function isAbsoluteURL(url) {
  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).
  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed
  // by any combination of letters, digits, plus, period, or hyphen.
  return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isURLSameOrigin.js":
/*!***********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isURLSameOrigin.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs have full support of the APIs needed to test
  // whether the request URL is of the same origin as current location.
    (function standardBrowserEnv() {
      var msie = /(msie|trident)/i.test(navigator.userAgent);
      var urlParsingNode = document.createElement('a');
      var originURL;

      /**
    * Parse a URL to discover it's components
    *
    * @param {String} url The URL to be parsed
    * @returns {Object}
    */
      function resolveURL(url) {
        var href = url;

        if (msie) {
        // IE needs attribute set twice to normalize properties
          urlParsingNode.setAttribute('href', href);
          href = urlParsingNode.href;
        }

        urlParsingNode.setAttribute('href', href);

        // urlParsingNode provides the UrlUtils interface - http://url.spec.whatwg.org/#urlutils
        return {
          href: urlParsingNode.href,
          protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',
          host: urlParsingNode.host,
          search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',
          hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',
          hostname: urlParsingNode.hostname,
          port: urlParsingNode.port,
          pathname: (urlParsingNode.pathname.charAt(0) === '/') ?
            urlParsingNode.pathname :
            '/' + urlParsingNode.pathname
        };
      }

      originURL = resolveURL(window.location.href);

      /**
    * Determine if a URL shares the same origin as the current location
    *
    * @param {String} requestURL The URL to test
    * @returns {boolean} True if URL shares the same origin, otherwise false
    */
      return function isURLSameOrigin(requestURL) {
        var parsed = (utils.isString(requestURL)) ? resolveURL(requestURL) : requestURL;
        return (parsed.protocol === originURL.protocol &&
            parsed.host === originURL.host);
      };
    })() :

  // Non standard browser envs (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return function isURLSameOrigin() {
        return true;
      };
    })()
);


/***/ }),

/***/ "./node_modules/axios/lib/helpers/normalizeHeaderName.js":
/*!***************************************************************!*\
  !*** ./node_modules/axios/lib/helpers/normalizeHeaderName.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");

module.exports = function normalizeHeaderName(headers, normalizedName) {
  utils.forEach(headers, function processHeader(value, name) {
    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
      headers[normalizedName] = value;
      delete headers[name];
    }
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/parseHeaders.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/parseHeaders.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

// Headers whose duplicates are ignored by node
// c.f. https://nodejs.org/api/http.html#http_message_headers
var ignoreDuplicateOf = [
  'age', 'authorization', 'content-length', 'content-type', 'etag',
  'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since',
  'last-modified', 'location', 'max-forwards', 'proxy-authorization',
  'referer', 'retry-after', 'user-agent'
];

/**
 * Parse headers into an object
 *
 * ```
 * Date: Wed, 27 Aug 2014 08:58:49 GMT
 * Content-Type: application/json
 * Connection: keep-alive
 * Transfer-Encoding: chunked
 * ```
 *
 * @param {String} headers Headers needing to be parsed
 * @returns {Object} Headers parsed into an object
 */
module.exports = function parseHeaders(headers) {
  var parsed = {};
  var key;
  var val;
  var i;

  if (!headers) { return parsed; }

  utils.forEach(headers.split('\n'), function parser(line) {
    i = line.indexOf(':');
    key = utils.trim(line.substr(0, i)).toLowerCase();
    val = utils.trim(line.substr(i + 1));

    if (key) {
      if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
        return;
      }
      if (key === 'set-cookie') {
        parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
      }
    }
  });

  return parsed;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/spread.js":
/*!**************************************************!*\
  !*** ./node_modules/axios/lib/helpers/spread.js ***!
  \**************************************************/
/***/ ((module) => {

"use strict";


/**
 * Syntactic sugar for invoking a function and expanding an array for arguments.
 *
 * Common use case would be to use `Function.prototype.apply`.
 *
 *  ```js
 *  function f(x, y, z) {}
 *  var args = [1, 2, 3];
 *  f.apply(null, args);
 *  ```
 *
 * With `spread` this example can be re-written.
 *
 *  ```js
 *  spread(function(x, y, z) {})([1, 2, 3]);
 *  ```
 *
 * @param {Function} callback
 * @returns {Function}
 */
module.exports = function spread(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
};


/***/ }),

/***/ "./node_modules/axios/lib/utils.js":
/*!*****************************************!*\
  !*** ./node_modules/axios/lib/utils.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");

/*global toString:true*/

// utils is a library of generic helper functions non-specific to axios

var toString = Object.prototype.toString;

/**
 * Determine if a value is an Array
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Array, otherwise false
 */
function isArray(val) {
  return toString.call(val) === '[object Array]';
}

/**
 * Determine if a value is undefined
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if the value is undefined, otherwise false
 */
function isUndefined(val) {
  return typeof val === 'undefined';
}

/**
 * Determine if a value is a Buffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Buffer, otherwise false
 */
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor)
    && typeof val.constructor.isBuffer === 'function' && val.constructor.isBuffer(val);
}

/**
 * Determine if a value is an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an ArrayBuffer, otherwise false
 */
function isArrayBuffer(val) {
  return toString.call(val) === '[object ArrayBuffer]';
}

/**
 * Determine if a value is a FormData
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an FormData, otherwise false
 */
function isFormData(val) {
  return (typeof FormData !== 'undefined') && (val instanceof FormData);
}

/**
 * Determine if a value is a view on an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false
 */
function isArrayBufferView(val) {
  var result;
  if ((typeof ArrayBuffer !== 'undefined') && (ArrayBuffer.isView)) {
    result = ArrayBuffer.isView(val);
  } else {
    result = (val) && (val.buffer) && (val.buffer instanceof ArrayBuffer);
  }
  return result;
}

/**
 * Determine if a value is a String
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a String, otherwise false
 */
function isString(val) {
  return typeof val === 'string';
}

/**
 * Determine if a value is a Number
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Number, otherwise false
 */
function isNumber(val) {
  return typeof val === 'number';
}

/**
 * Determine if a value is an Object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Object, otherwise false
 */
function isObject(val) {
  return val !== null && typeof val === 'object';
}

/**
 * Determine if a value is a Date
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Date, otherwise false
 */
function isDate(val) {
  return toString.call(val) === '[object Date]';
}

/**
 * Determine if a value is a File
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a File, otherwise false
 */
function isFile(val) {
  return toString.call(val) === '[object File]';
}

/**
 * Determine if a value is a Blob
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Blob, otherwise false
 */
function isBlob(val) {
  return toString.call(val) === '[object Blob]';
}

/**
 * Determine if a value is a Function
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Function, otherwise false
 */
function isFunction(val) {
  return toString.call(val) === '[object Function]';
}

/**
 * Determine if a value is a Stream
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Stream, otherwise false
 */
function isStream(val) {
  return isObject(val) && isFunction(val.pipe);
}

/**
 * Determine if a value is a URLSearchParams object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a URLSearchParams object, otherwise false
 */
function isURLSearchParams(val) {
  return typeof URLSearchParams !== 'undefined' && val instanceof URLSearchParams;
}

/**
 * Trim excess whitespace off the beginning and end of a string
 *
 * @param {String} str The String to trim
 * @returns {String} The String freed of excess whitespace
 */
function trim(str) {
  return str.replace(/^\s*/, '').replace(/\s*$/, '');
}

/**
 * Determine if we're running in a standard browser environment
 *
 * This allows axios to run in a web worker, and react-native.
 * Both environments support XMLHttpRequest, but not fully standard globals.
 *
 * web workers:
 *  typeof window -> undefined
 *  typeof document -> undefined
 *
 * react-native:
 *  navigator.product -> 'ReactNative'
 * nativescript
 *  navigator.product -> 'NativeScript' or 'NS'
 */
function isStandardBrowserEnv() {
  if (typeof navigator !== 'undefined' && (navigator.product === 'ReactNative' ||
                                           navigator.product === 'NativeScript' ||
                                           navigator.product === 'NS')) {
    return false;
  }
  return (
    typeof window !== 'undefined' &&
    typeof document !== 'undefined'
  );
}

/**
 * Iterate over an Array or an Object invoking a function for each item.
 *
 * If `obj` is an Array callback will be called passing
 * the value, index, and complete array for each item.
 *
 * If 'obj' is an Object callback will be called passing
 * the value, key, and complete object for each property.
 *
 * @param {Object|Array} obj The object to iterate
 * @param {Function} fn The callback to invoke for each item
 */
function forEach(obj, fn) {
  // Don't bother if no value provided
  if (obj === null || typeof obj === 'undefined') {
    return;
  }

  // Force an array if not already something iterable
  if (typeof obj !== 'object') {
    /*eslint no-param-reassign:0*/
    obj = [obj];
  }

  if (isArray(obj)) {
    // Iterate over array values
    for (var i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    // Iterate over object keys
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        fn.call(null, obj[key], key, obj);
      }
    }
  }
}

/**
 * Accepts varargs expecting each argument to be an object, then
 * immutably merges the properties of each object and returns result.
 *
 * When multiple objects contain the same key the later object in
 * the arguments list will take precedence.
 *
 * Example:
 *
 * ```js
 * var result = merge({foo: 123}, {foo: 456});
 * console.log(result.foo); // outputs 456
 * ```
 *
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function merge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (typeof result[key] === 'object' && typeof val === 'object') {
      result[key] = merge(result[key], val);
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Function equal to merge with the difference being that no reference
 * to original objects is kept.
 *
 * @see merge
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function deepMerge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (typeof result[key] === 'object' && typeof val === 'object') {
      result[key] = deepMerge(result[key], val);
    } else if (typeof val === 'object') {
      result[key] = deepMerge({}, val);
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Extends object a by mutably adding to it the properties of object b.
 *
 * @param {Object} a The object to be extended
 * @param {Object} b The object to copy properties from
 * @param {Object} thisArg The object to bind function to
 * @return {Object} The resulting value of object a
 */
function extend(a, b, thisArg) {
  forEach(b, function assignValue(val, key) {
    if (thisArg && typeof val === 'function') {
      a[key] = bind(val, thisArg);
    } else {
      a[key] = val;
    }
  });
  return a;
}

module.exports = {
  isArray: isArray,
  isArrayBuffer: isArrayBuffer,
  isBuffer: isBuffer,
  isFormData: isFormData,
  isArrayBufferView: isArrayBufferView,
  isString: isString,
  isNumber: isNumber,
  isObject: isObject,
  isUndefined: isUndefined,
  isDate: isDate,
  isFile: isFile,
  isBlob: isBlob,
  isFunction: isFunction,
  isStream: isStream,
  isURLSearchParams: isURLSearchParams,
  isStandardBrowserEnv: isStandardBrowserEnv,
  forEach: forEach,
  merge: merge,
  deepMerge: deepMerge,
  extend: extend,
  trim: trim
};


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/App.vue?vue&type=script&lang=js&":
/*!************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/App.vue?vue&type=script&lang=js& ***!
  \************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//
//
//
//
//
//
//
//
//


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      Loading: false
    };
  },
  computed: _objectSpread(_objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_0__.mapGetters)(["getThemeMode", "isAuthenticated"])), {}, {
    themeName: function themeName() {
      return this.getThemeMode.dark ? "dark-theme" : " ";
    },
    rtl: function rtl() {
      return this.getThemeMode.rtl ? "rtl" : " ";
    }
  }),
  metaInfo: function metaInfo() {
    return {
      // if no subcomponents specify a metaInfo.title, this title will be used
      title: "Info Tech",
      // all titles will be injected into this template
      titleTemplate: "%s | Ultimate Inventory With POS",
      bodyAttrs: {
        "class": [this.themeName, "text-left"]
      },
      htmlAttrs: {
        dir: this.rtl
      }
    };
  },
  methods: _objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_0__.mapActions)(["refreshUserPermissions"])),
  beforeMount: function beforeMount() {
    var _this = this;
    // if(this.isAuthenticated){
    this.refreshUserPermissions();
    setTimeout(function () {
      return _this.Loading = true;
    }, 300);
    // }
    // else{
    //   setTimeout(() => this.Loading= true, 300);
    // }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/components/breadcumb.vue?vue&type=script&lang=js&":
/*!*****************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/components/breadcumb.vue?vue&type=script&lang=js& ***!
  \*****************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['page', 'folder']
});

/***/ }),

/***/ "./resources/src/auth/IsConnected.js":
/*!*******************************************!*\
  !*** ./resources/src/auth/IsConnected.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_cookies__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-cookies */ "./node_modules/vue-cookies/vue-cookies.js");
/* harmony import */ var vue_cookies__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vue_cookies__WEBPACK_IMPORTED_MODULE_0__);


vue__WEBPACK_IMPORTED_MODULE_1__["default"].use((vue_cookies__WEBPACK_IMPORTED_MODULE_0___default()));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (function (to, from, next) {
  var accessToken = vue_cookies__WEBPACK_IMPORTED_MODULE_0___default().isKey("Stocky_token");
  if (accessToken) {
    next("/app/dashboard");
  } else {
    return next();
  }
});

/***/ }),

/***/ "./resources/src/auth/authenticate.js":
/*!********************************************!*\
  !*** ./resources/src/auth/authenticate.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_cookies__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-cookies */ "./node_modules/vue-cookies/vue-cookies.js");
/* harmony import */ var vue_cookies__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vue_cookies__WEBPACK_IMPORTED_MODULE_0__);


vue__WEBPACK_IMPORTED_MODULE_1__["default"].use((vue_cookies__WEBPACK_IMPORTED_MODULE_0___default()));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (function (to, from, next) {
  var accessToken = vue_cookies__WEBPACK_IMPORTED_MODULE_0___default().isKey("Stocky_token");
  if (!accessToken) {
    next("/app/sessions/signIn");
  } else {
    return next();
  }
});

/***/ }),

/***/ "./resources/src/auth/index.js":
/*!*************************************!*\
  !*** ./resources/src/auth/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Auth)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _store_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../store/index.js */ "./resources/src/store/index.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }


var Auth = /*#__PURE__*/function () {
  function Auth() {
    _classCallCheck(this, Auth);
  }
  _createClass(Auth, [{
    key: "login",
    value: function login(token) {
      _store_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].dispatch('setLoginCred', {
        token: token
      });
    }
  }, {
    key: "setAuthToken",
    value: function setAuthToken(token) {
      var tokenIsSet = (axios__WEBPACK_IMPORTED_MODULE_0___default().defaults).headers.common['Authorization'] = 'Bearer ' + token;
    }

    // checks for login status, returns boolean
  }, {
    key: "check",
    value: function check() {
      return !!_store_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.auth.token;
    }
  }]);
  return Auth;
}();


/***/ }),

/***/ "./resources/src/plugins/i18n.js":
/*!***************************************!*\
  !*** ./resources/src/plugins/i18n.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i18n: () => (/* binding */ i18n)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue-i18n */ "./node_modules/vue-i18n/dist/vue-i18n.esm.js");
/* harmony import */ var _translations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../translations */ "./resources/src/translations/index.js");



vue__WEBPACK_IMPORTED_MODULE_1__["default"].use(vue_i18n__WEBPACK_IMPORTED_MODULE_2__["default"]);
var i18n = new vue_i18n__WEBPACK_IMPORTED_MODULE_2__["default"]({
  locale: 'en',
  fallbackLocale: 'en',
  messages: _translations__WEBPACK_IMPORTED_MODULE_0__["default"]
});

/***/ }),

/***/ "./resources/src/plugins/stocky.kit.js":
/*!*********************************************!*\
  !*** ./resources/src/plugins/stocky.kit.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var bootstrap_vue_dist_bootstrap_vue_esm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! bootstrap-vue/dist/bootstrap-vue.esm */ "./node_modules/bootstrap-vue/dist/bootstrap-vue.esm.js");
/* harmony import */ var vue_good_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue-good-table */ "./node_modules/vue-good-table/dist/vue-good-table.esm.js");
/* harmony import */ var vue_meta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-meta */ "./node_modules/vue-meta/dist/vue-meta.esm.js");
/* harmony import */ var _assets_styles_sass_themes_lite_purple_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../assets/styles/sass/themes/lite-purple.scss */ "./resources/src/assets/styles/sass/themes/lite-purple.scss");
/* harmony import */ var _sweetalert2_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sweetalert2.js */ "./resources/src/plugins/sweetalert2.js");
/* harmony import */ var vue_html_to_paper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-html-to-paper */ "./node_modules/vue-html-to-paper/dist/index.js");






var options = {
  name: '_blank',
  specs: ['fullscreen=yes', 'titlebar=yes', 'scrollbars=yes'],
  styles: ['https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css', 'https://unpkg.com/kidlat-css/css/kidlat.css'],
  timeout: 1000,
  // default timeout before the print window appears
  autoClose: true,
  // if false, the window will not close after printing
  windowTitle: window.document.title // override the window title
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  install: function install(Vue) {
    Vue.use(bootstrap_vue_dist_bootstrap_vue_esm__WEBPACK_IMPORTED_MODULE_4__["default"]);
    Vue.component("large-sidebar",
    // The `import` function returns a Promise.
    function () {
      return __webpack_require__.e(/*! import() | largeSidebar */ "largeSidebar").then(__webpack_require__.bind(__webpack_require__, /*! ../containers/layouts/largeSidebar */ "./resources/src/containers/layouts/largeSidebar/index.vue"));
    });
    Vue.component("customizer",
    // The `import` function returns a Promise.
    function () {
      return __webpack_require__.e(/*! import() | customizer */ "customizer").then(__webpack_require__.bind(__webpack_require__, /*! ../components/common/customizer.vue */ "./resources/src/components/common/customizer.vue"));
    });
    Vue.component("vue-perfect-scrollbar", function () {
      return __webpack_require__.e(/*! import() | vue-perfect-scrollbar */ "vue-perfect-scrollbar").then(__webpack_require__.t.bind(__webpack_require__, /*! vue-perfect-scrollbar */ "./node_modules/vue-perfect-scrollbar/dist/index.js", 23));
    });
    Vue.use(vue_meta__WEBPACK_IMPORTED_MODULE_0__["default"], {
      keyName: "metaInfo",
      attribute: "data-vue-meta",
      ssrAttribute: "data-vue-meta-server-rendered",
      tagIDKeyName: "vmid",
      refreshOnceOnNavigation: true
    });
    Vue.use(vue_good_table__WEBPACK_IMPORTED_MODULE_5__["default"]);
    Vue.use(vue_html_to_paper__WEBPACK_IMPORTED_MODULE_3__["default"], options);
  }
});

/***/ }),

/***/ "./resources/src/plugins/sweetalert2.js":
/*!**********************************************!*\
  !*** ./resources/src/plugins/sweetalert2.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_sweetalert2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-sweetalert2 */ "./node_modules/vue-sweetalert2/dist/index.js");
/* harmony import */ var sweetalert2_dist_sweetalert2_min_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! sweetalert2/dist/sweetalert2.min.css */ "./node_modules/sweetalert2/dist/sweetalert2.min.css");
// main.js



// If you don't need the styles, do not connect

var options = {
  confirmButtonColor: '#41b882',
  cancelButtonColor: '#ff7674'
};
vue__WEBPACK_IMPORTED_MODULE_2__["default"].use(vue_sweetalert2__WEBPACK_IMPORTED_MODULE_0__["default"], options);

/***/ }),

/***/ "./resources/src/router.js":
/*!*********************************!*\
  !*** ./resources/src/router.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./store */ "./resources/src/store/index.js");
/* harmony import */ var vue_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vue-router */ "./node_modules/vue-router/dist/vue-router.esm.js");
/* harmony import */ var _plugins_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugins/i18n */ "./resources/src/plugins/i18n.js");
/* harmony import */ var _auth_authenticate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./auth/authenticate */ "./resources/src/auth/authenticate.js");
/* harmony import */ var _auth_IsConnected__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./auth/IsConnected */ "./resources/src/auth/IsConnected.js");
/* harmony import */ var nprogress__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! nprogress */ "./node_modules/nprogress/nprogress.js");
/* harmony import */ var nprogress__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(nprogress__WEBPACK_IMPORTED_MODULE_4__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _Check_Token;
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }







vue__WEBPACK_IMPORTED_MODULE_5__["default"].use(vue_router__WEBPACK_IMPORTED_MODULE_6__["default"]);

// create new router

var routes = [{
  path: "/",
  component: function component() {
    return __webpack_require__.e(/*! import() */ "resources_src_views_app_index_vue").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app */ "./resources/src/views/app/index.vue"));
  },
  redirect: "/app/dashboard",
  children: [{
    path: "/app/dashboard",
    name: "dashboard",
    component: function component() {
      return __webpack_require__.e(/*! import() | dashboard */ "dashboard").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/dashboard/dashboard */ "./resources/src/views/app/dashboard/dashboard.vue"));
    }
  },
  //Products
  {
    path: "/app/products",
    component: function component() {
      return __webpack_require__.e(/*! import() | products */ "products").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products */ "./resources/src/views/app/pages/products/index.vue"));
    },
    redirect: "app/products/list",
    children: [{
      name: "index_products",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_products */ "index_products").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/index_products */ "./resources/src/views/app/pages/products/index_products.vue"));
      }
    }, {
      path: "store",
      name: "store_product",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_product */ "store_product").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/Add_product */ "./resources/src/views/app/pages/products/Add_product.vue"));
      }
    }, {
      path: "edit/:id",
      name: "edit_product",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_product */ "edit_product").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/Edit_product */ "./resources/src/views/app/pages/products/Edit_product.vue"));
      }
    }, {
      path: "detail/:id",
      name: "detail_product",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_product */ "detail_product").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/Detail_Product */ "./resources/src/views/app/pages/products/Detail_Product.vue"));
      }
    }, {
      path: "barcode",
      name: "barcode",
      component: function component() {
        return __webpack_require__.e(/*! import() | barcode */ "barcode").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/barcode */ "./resources/src/views/app/pages/products/barcode.vue"));
      }
    },
    // categories
    {
      name: "categories",
      path: "Categories",
      component: function component() {
        return __webpack_require__.e(/*! import() | Categories */ "Categories").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/categorie */ "./resources/src/views/app/pages/products/categorie.vue"));
      }
    },
    // brands
    {
      name: "brands",
      path: "Brands",
      component: function component() {
        return __webpack_require__.e(/*! import() | Brands */ "Brands").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/brands */ "./resources/src/views/app/pages/products/brands.vue"));
      }
    },
    // units
    {
      name: "units",
      path: "Units",
      component: function component() {
        return __webpack_require__.e(/*! import() | units */ "units").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/units */ "./resources/src/views/app/pages/products/units.vue"));
      }
    }]
  },
  //Adjustement
  {
    path: "/app/adjustments",
    component: function component() {
      return __webpack_require__.e(/*! import() | adjustments */ "adjustments").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/adjustment */ "./resources/src/views/app/pages/adjustment/index.vue"));
    },
    redirect: "/app/adjustments/list",
    children: [{
      name: "index_adjustment",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_adjustment */ "index_adjustment").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/adjustment/index_Adjustment */ "./resources/src/views/app/pages/adjustment/index_Adjustment.vue"));
      }
    }, {
      name: "store_adjustment",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_adjustment */ "store_adjustment").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/adjustment/Create_Adjustment */ "./resources/src/views/app/pages/adjustment/Create_Adjustment.vue"));
      }
    }, {
      name: "edit_adjustment",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_adjustment */ "edit_adjustment").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/adjustment/Edit_Adjustment */ "./resources/src/views/app/pages/adjustment/Edit_Adjustment.vue"));
      }
    }]
  },
  //Transfer
  {
    path: "/app/transfers",
    component: function component() {
      return __webpack_require__.e(/*! import() | transfers */ "transfers").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/transfers */ "./resources/src/views/app/pages/transfers/index.vue"));
    },
    redirect: "/app/transfers/list",
    children: [{
      name: "index_transfer",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_transfer */ "index_transfer").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/transfers/index_transfer */ "./resources/src/views/app/pages/transfers/index_transfer.vue"));
      }
    }, {
      name: "store_transfer",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_transfer */ "store_transfer").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/transfers/create_transfer */ "./resources/src/views/app/pages/transfers/create_transfer.vue"));
      }
    }, {
      name: "edit_transfer",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_transfer */ "edit_transfer").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/transfers/edit_transfer */ "./resources/src/views/app/pages/transfers/edit_transfer.vue"));
      }
    }]
  },
  //Expense
  {
    path: "/app/expenses",
    component: function component() {
      return __webpack_require__.e(/*! import() | expenses */ "expenses").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense */ "./resources/src/views/app/pages/expense/index.vue"));
    },
    redirect: "/app/expenses/list",
    children: [{
      name: "index_expense",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_expense */ "index_expense").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense/index_expense */ "./resources/src/views/app/pages/expense/index_expense.vue"));
      }
    }, {
      name: "store_expense",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_expense */ "store_expense").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense/create_expense */ "./resources/src/views/app/pages/expense/create_expense.vue"));
      }
    }, {
      name: "edit_expense",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_expense */ "edit_expense").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense/edit_expense */ "./resources/src/views/app/pages/expense/edit_expense.vue"));
      }
    }, {
      name: "expense_category",
      path: "category",
      component: function component() {
        return __webpack_require__.e(/*! import() | expense_category */ "expense_category").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense/category_expense */ "./resources/src/views/app/pages/expense/category_expense.vue"));
      }
    }]
  },
  //Quotation
  {
    path: "/app/quotations",
    component: function component() {
      return __webpack_require__.e(/*! import() | quotations */ "quotations").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations */ "./resources/src/views/app/pages/quotations/index.vue"));
    },
    redirect: "/app/quotations/list",
    children: [{
      name: "index_quotation",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() */ "resources_src_views_app_pages_quotations_index_quotation_vue").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations/index_quotation */ "./resources/src/views/app/pages/quotations/index_quotation.vue"));
      }
    }, {
      name: "store_quotation",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_quotation */ "store_quotation").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations/create_quotation */ "./resources/src/views/app/pages/quotations/create_quotation.vue"));
      }
    }, {
      name: "edit_quotation",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_quotation */ "edit_quotation").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations/edit_quotation */ "./resources/src/views/app/pages/quotations/edit_quotation.vue"));
      }
    }, {
      name: "detail_quotation",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_quotation */ "detail_quotation").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations/detail_quotation */ "./resources/src/views/app/pages/quotations/detail_quotation.vue"));
      }
    }, {
      name: "change_to_sale",
      path: "create_sale/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | change_to_sale */ "change_to_sale").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/change_to_sale.vue */ "./resources/src/views/app/pages/sales/change_to_sale.vue"));
      }
    }]
  },
  //Purchase
  {
    path: "/app/purchases",
    component: function component() {
      return __webpack_require__.e(/*! import() | purchases */ "purchases").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases */ "./resources/src/views/app/pages/purchases/index.vue"));
    },
    redirect: "/app/purchases/list",
    children: [{
      name: "index_purchases",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_purchases */ "index_purchases").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases/index_purchase */ "./resources/src/views/app/pages/purchases/index_purchase.vue"));
      }
    }, {
      name: "store_purchase",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_purchase */ "store_purchase").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases/create_purchase */ "./resources/src/views/app/pages/purchases/create_purchase.vue"));
      }
    }, {
      name: "edit_purchase",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_purchase */ "edit_purchase").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases/edit_purchase */ "./resources/src/views/app/pages/purchases/edit_purchase.vue"));
      }
    }, {
      name: "purchase_return",
      path: "purchase_return/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | create_purchase_return */ "create_purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return/create_purchase_return */ "./resources/src/views/app/pages/purchase_return/create_purchase_return.vue"));
      }
    }, {
      name: "detail_purchase",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_purchase */ "detail_purchase").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases/detail_purchase */ "./resources/src/views/app/pages/purchases/detail_purchase.vue"));
      }
    }]
  },
  //Sale
  {
    path: "/app/sales",
    component: function component() {
      return __webpack_require__.e(/*! import() | sales */ "sales").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales */ "./resources/src/views/app/pages/sales/index.vue"));
    },
    redirect: "/app/sales/list",
    children: [{
      name: "index_sales",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_sales */ "index_sales").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/index_sale */ "./resources/src/views/app/pages/sales/index_sale.vue"));
      }
    }, {
      name: "store_sale",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_sale */ "store_sale").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/create_sale */ "./resources/src/views/app/pages/sales/create_sale.vue"));
      }
    }, {
      name: "edit_sale",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_sale */ "edit_sale").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/edit_sale */ "./resources/src/views/app/pages/sales/edit_sale.vue"));
      }
    }, {
      name: "sale_return",
      path: "sale_return/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | create_sale_return */ "create_sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return/create_sale_return */ "./resources/src/views/app/pages/sale_return/create_sale_return.vue"));
      }
    }, {
      name: "detail_sale",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_sale */ "detail_sale").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/detail_sale */ "./resources/src/views/app/pages/sales/detail_sale.vue"));
      }
    }, {
      name: "shipment",
      path: "shipment",
      component: function component() {
        return __webpack_require__.e(/*! import() | shipment */ "shipment").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/shipments */ "./resources/src/views/app/pages/sales/shipments.vue"));
      }
    }]
  },
  // Sales Return
  {
    path: "/app/sale_return",
    component: function component() {
      return __webpack_require__.e(/*! import() | sale_return */ "sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return */ "./resources/src/views/app/pages/sale_return/index.vue"));
    },
    redirect: "/app/sale_return/list",
    children: [{
      name: "index_sale_return",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_sale_return */ "index_sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return/index_sale_return */ "./resources/src/views/app/pages/sale_return/index_sale_return.vue"));
      }
    },
    // {
    //     name: "store_sale_return",
    //     path: "store",
    //     component: () =>
    //         import(
    //             /* webpackChunkName: "store_sale_return" */
    //             "./views/app/pages/sale_return/create_sale_return"
    //         )
    // },
    {
      name: "edit_sale_return",
      path: "edit/:id/:sale_id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_sale_return */ "edit_sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return/edit_sale_return */ "./resources/src/views/app/pages/sale_return/edit_sale_return.vue"));
      }
    }, {
      name: "detail_sale_return",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_sale_return */ "detail_sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return/detail_sale_return */ "./resources/src/views/app/pages/sale_return/detail_sale_return.vue"));
      }
    }]
  },
  // purchase Return
  {
    path: "/app/purchase_return",
    component: function component() {
      return __webpack_require__.e(/*! import() | purchase_return */ "purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return */ "./resources/src/views/app/pages/purchase_return/index.vue"));
    },
    redirect: "/app/purchase_return/list",
    children: [{
      name: "index_purchase_return",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_purchase_return */ "index_purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return/index_purchase_return */ "./resources/src/views/app/pages/purchase_return/index_purchase_return.vue"));
      }
    },
    // {
    //     name: "store_purchase_return",
    //     path: "store",
    //     component: () =>
    //         import(
    //             /* webpackChunkName: "store_purchase_return" */
    //             "./views/app/pages/purchase_return/create_purchase_return"
    //         )
    // },
    {
      name: "edit_purchase_return",
      path: "edit/:id/:purchase_id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_purchase_return */ "edit_purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return/edit_purchase_return */ "./resources/src/views/app/pages/purchase_return/edit_purchase_return.vue"));
      }
    }, {
      name: "detail_purchase_return",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_purchase_return */ "detail_purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return/detail_purchase_return */ "./resources/src/views/app/pages/purchase_return/detail_purchase_return.vue"));
      }
    }]
  },
  // Hrm
  {
    path: "/app/hrm",
    component: function component() {
      return __webpack_require__.e(/*! import() | hrm */ "hrm").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm */ "./resources/src/views/app/pages/hrm/index.vue"));
    },
    redirect: "/app/hrm/employees",
    children: [
    // employees
    {
      path: "employees",
      component: function component() {
        return __webpack_require__.e(/*! import() | employees */ "employees").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees */ "./resources/src/views/app/pages/hrm/employees/index.vue"));
      },
      redirect: "/app/hrm/employees/list",
      children: [{
        name: "employees_list",
        path: "list",
        component: function component() {
          return __webpack_require__.e(/*! import() | index_employee */ "index_employee").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees/index_employee */ "./resources/src/views/app/pages/hrm/employees/index_employee.vue"));
        }
      }, {
        name: "store_employee",
        path: "store",
        component: function component() {
          return __webpack_require__.e(/*! import() | store_employee */ "store_employee").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees/employee_create */ "./resources/src/views/app/pages/hrm/employees/employee_create.vue"));
        }
      }, {
        name: "edit_employee",
        path: "edit/:id",
        component: function component() {
          return __webpack_require__.e(/*! import() | edit_employee */ "edit_employee").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees/employee_edit */ "./resources/src/views/app/pages/hrm/employees/employee_edit.vue"));
        }
      }, {
        name: "detail_employee",
        path: "detail/:id",
        component: function component() {
          return __webpack_require__.e(/*! import() | detail_employee */ "detail_employee").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees/employee_details */ "./resources/src/views/app/pages/hrm/employees/employee_details.vue"));
        }
      }]
    },
    // company
    {
      name: "company",
      path: "company",
      component: function component() {
        return __webpack_require__.e(/*! import() | company */ "company").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/company */ "./resources/src/views/app/pages/hrm/company.vue"));
      }
    },
    // departments
    {
      name: "departments",
      path: "departments",
      component: function component() {
        return __webpack_require__.e(/*! import() | departments */ "departments").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/department */ "./resources/src/views/app/pages/hrm/department.vue"));
      }
    },
    // designations
    {
      name: "designations",
      path: "designations",
      component: function component() {
        return __webpack_require__.e(/*! import() | designations */ "designations").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/designation */ "./resources/src/views/app/pages/hrm/designation.vue"));
      }
    },
    // office_shift
    {
      name: "office_shift",
      path: "office_shift",
      component: function component() {
        return __webpack_require__.e(/*! import() | office_shift */ "office_shift").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/office_shift */ "./resources/src/views/app/pages/hrm/office_shift.vue"));
      }
    },
    // attendance
    {
      name: "attendance",
      path: "attendance",
      component: function component() {
        return __webpack_require__.e(/*! import() | attendance */ "attendance").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/attendance */ "./resources/src/views/app/pages/hrm/attendance.vue"));
      }
    },
    // holidays
    {
      name: "holidays",
      path: "holidays",
      component: function component() {
        return __webpack_require__.e(/*! import() | holidays */ "holidays").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/holidays */ "./resources/src/views/app/pages/hrm/holidays.vue"));
      }
    }, {
      path: "leaves",
      component: function component() {
        return __webpack_require__.e(/*! import() | leaves */ "leaves").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/leaves */ "./resources/src/views/app/pages/hrm/leaves/index.vue"));
      },
      redirect: "/app/hrm/leaves/list",
      children: [{
        name: "leave_list",
        path: "list",
        component: function component() {
          return __webpack_require__.e(/*! import() | leave_list */ "leave_list").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/leaves/leave_list */ "./resources/src/views/app/pages/hrm/leaves/leave_list.vue"));
        }
      }, {
        name: "leave_type",
        path: "type",
        component: function component() {
          return __webpack_require__.e(/*! import() | leave_type */ "leave_type").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/leaves/leave_type */ "./resources/src/views/app/pages/hrm/leaves/leave_type.vue"));
        }
      }]
    }]
  },
  // People
  {
    path: "/app/People",
    component: function component() {
      return __webpack_require__.e(/*! import() | People */ "People").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/people */ "./resources/src/views/app/pages/people/index.vue"));
    },
    redirect: "/app/People/Customers",
    children: [
    // Customers
    {
      name: "Customers",
      path: "Customers",
      component: function component() {
        return __webpack_require__.e(/*! import() | Customers */ "Customers").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/people/customers */ "./resources/src/views/app/pages/people/customers.vue"));
      }
    },
    // Suppliers
    {
      name: "Suppliers",
      path: "Suppliers",
      component: function component() {
        return __webpack_require__.e(/*! import() | Suppliers */ "Suppliers").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/people/providers */ "./resources/src/views/app/pages/people/providers.vue"));
      }
    },
    // Users
    {
      name: "user",
      path: "Users",
      component: function component() {
        return __webpack_require__.e(/*! import() | Users */ "Users").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/people/users */ "./resources/src/views/app/pages/people/users.vue"));
      }
    }]
  },
  // Settings
  {
    path: "/app/settings",
    component: function component() {
      return __webpack_require__.e(/*! import() | settings */ "settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings */ "./resources/src/views/app/pages/settings/index.vue"));
    },
    redirect: "/app/settings/System_settings",
    children: [
    // Permissions
    {
      path: "permissions",
      component: function component() {
        return __webpack_require__.e(/*! import() | permissions */ "permissions").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/permissions */ "./resources/src/views/app/pages/settings/permissions/index.vue"));
      },
      redirect: "/app/settings/permissions/list",
      children: [{
        name: "groupPermission",
        path: "list",
        component: function component() {
          return __webpack_require__.e(/*! import() | groupPermission */ "groupPermission").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/permissions/Permissions */ "./resources/src/views/app/pages/settings/permissions/Permissions.vue"));
        }
      }, {
        name: "store_permission",
        path: "store",
        component: function component() {
          return __webpack_require__.e(/*! import() | store_permission */ "store_permission").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/permissions/Create_permission */ "./resources/src/views/app/pages/settings/permissions/Create_permission.vue"));
        }
      }, {
        name: "edit_permission",
        path: "edit/:id",
        component: function component() {
          return __webpack_require__.e(/*! import() | edit_permission */ "edit_permission").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/permissions/Edit_permission */ "./resources/src/views/app/pages/settings/permissions/Edit_permission.vue"));
        }
      }]
    },
    // sms_settings
    {
      name: "sms_settings",
      path: "sms_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | sms_settings */ "sms_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/sms_settings */ "./resources/src/views/app/pages/settings/sms_settings.vue"));
      }
    },
    // sms_templates
    {
      name: "sms_templates",
      path: "sms_templates",
      component: function component() {
        return __webpack_require__.e(/*! import() | sms_templates */ "sms_templates").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/sms_templates */ "./resources/src/views/app/pages/settings/sms_templates.vue"));
      }
    },
    // email_templates
    {
      name: "email_templates",
      path: "email_templates",
      component: function component() {
        return __webpack_require__.e(/*! import() | email_templates */ "email_templates").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/email_templates */ "./resources/src/views/app/pages/settings/email_templates.vue"));
      }
    },
    // pos_settings
    {
      name: "pos_settings",
      path: "pos_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | pos_settings */ "pos_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/pos_settings */ "./resources/src/views/app/pages/settings/pos_settings.vue"));
      }
    },
    // payment_gateway
    {
      name: "payment_gateway",
      path: "payment_gateway",
      component: function component() {
        return __webpack_require__.e(/*! import() | payment_gateway */ "payment_gateway").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/payment_gateway */ "./resources/src/views/app/pages/settings/payment_gateway.vue"));
      }
    },
    // mail_settings
    {
      name: "mail_settings",
      path: "mail_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | mail_settings */ "mail_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/mail_settings */ "./resources/src/views/app/pages/settings/mail_settings.vue"));
      }
    },
    // update_settings
    {
      name: "update_settings",
      path: "update_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | update_settings */ "update_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/update_settings */ "./resources/src/views/app/pages/settings/update_settings.vue"));
      }
    },
    // currencies
    {
      name: "currencies",
      path: "Currencies",
      component: function component() {
        return __webpack_require__.e(/*! import() | Currencies */ "Currencies").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/currencies */ "./resources/src/views/app/pages/settings/currencies.vue"));
      }
    },
    // Backup
    {
      name: "Backup",
      path: "Backup",
      component: function component() {
        return __webpack_require__.e(/*! import() | Backup */ "Backup").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/backup */ "./resources/src/views/app/pages/settings/backup.vue"));
      }
    },
    // Warehouses
    {
      name: "Warehouses",
      path: "Warehouses",
      component: function component() {
        return __webpack_require__.e(/*! import() | Warehouses */ "Warehouses").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/warehouses */ "./resources/src/views/app/pages/settings/warehouses.vue"));
      }
    },
    // System Settings
    {
      name: "system_settings",
      path: "System_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | System_settings */ "System_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/system_settings */ "./resources/src/views/app/pages/settings/system_settings.vue"));
      }
    }]
  },
  // Reports
  {
    path: "/app/reports",
    component: function component() {
      return __webpack_require__.e(/*! import() */ "resources_src_views_app_pages_reports_index_vue").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports */ "./resources/src/views/app/pages/reports/index.vue"));
    },
    redirect: "/app/reports/profit_and_loss",
    children: [{
      name: "payments_purchases",
      path: "payments_purchase",
      component: function component() {
        return __webpack_require__.e(/*! import() | payments_purchases */ "payments_purchases").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/payments/payments_purchases */ "./resources/src/views/app/pages/reports/payments/payments_purchases.vue"));
      }
    }, {
      name: "payments_sales",
      path: "payments_sale",
      component: function component() {
        return __webpack_require__.e(/*! import() | payments_sales */ "payments_sales").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/payments/payments_sales */ "./resources/src/views/app/pages/reports/payments/payments_sales.vue"));
      }
    }, {
      name: "payments_purchases_returns",
      path: "payments_purchases_returns",
      component: function component() {
        return __webpack_require__.e(/*! import() | payments_purchases_returns */ "payments_purchases_returns").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/payments/payments_purchases_returns */ "./resources/src/views/app/pages/reports/payments/payments_purchases_returns.vue"));
      }
    }, {
      name: "payments_sales_returns",
      path: "payments_sales_returns",
      component: function component() {
        return __webpack_require__.e(/*! import() | payments_sales_returns */ "payments_sales_returns").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/payments/payments_sales_returns */ "./resources/src/views/app/pages/reports/payments/payments_sales_returns.vue"));
      }
    }, {
      name: "profit_and_loss",
      path: "profit_and_loss",
      component: function component() {
        return __webpack_require__.e(/*! import() | profit_and_loss */ "profit_and_loss").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/profit_and_loss */ "./resources/src/views/app/pages/reports/profit_and_loss.vue"));
      }
    }, {
      name: "quantity_alerts",
      path: "quantity_alerts",
      component: function component() {
        return __webpack_require__.e(/*! import() | quantity_alerts */ "quantity_alerts").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/quantity_alerts */ "./resources/src/views/app/pages/reports/quantity_alerts.vue"));
      }
    }, {
      name: "warehouse_report",
      path: "warehouse_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | warehouse_report */ "warehouse_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/warehouse_report */ "./resources/src/views/app/pages/reports/warehouse_report.vue"));
      }
    }, {
      name: "sales_report",
      path: "sales_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | sales_report */ "sales_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/sales_report */ "./resources/src/views/app/pages/reports/sales_report.vue"));
      }
    }, {
      name: "product_sales_report",
      path: "product_sales_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | product_sales_report */ "product_sales_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/product_sales_report */ "./resources/src/views/app/pages/reports/product_sales_report.vue"));
      }
    }, {
      name: "purchase_report",
      path: "purchase_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | purchase_report */ "purchase_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/purchase_report */ "./resources/src/views/app/pages/reports/purchase_report.vue"));
      }
    }, {
      name: "product_purchases_report",
      path: "product_purchases_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | product_purchases_report */ "product_purchases_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/product_purchases_report */ "./resources/src/views/app/pages/reports/product_purchases_report.vue"));
      }
    }, {
      name: "customers_report",
      path: "customers_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | customers_report */ "customers_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/customers_report */ "./resources/src/views/app/pages/reports/customers_report.vue"));
      }
    }, {
      name: "detail_customer_report",
      path: "detail_customer/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_customer_report */ "detail_customer_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_Customer_Report */ "./resources/src/views/app/pages/reports/detail_Customer_Report.vue"));
      }
    }, {
      name: "providers_report",
      path: "providers_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | providers_report */ "providers_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/providers_report */ "./resources/src/views/app/pages/reports/providers_report.vue"));
      }
    }, {
      name: "detail_supplier_report",
      path: "detail_supplier/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_supplier_report */ "detail_supplier_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_Supplier_Report */ "./resources/src/views/app/pages/reports/detail_Supplier_Report.vue"));
      }
    }, {
      name: "top_selling_products",
      path: "top_selling_products",
      component: function component() {
        return __webpack_require__.e(/*! import() | top_selling_products */ "top_selling_products").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/top_selling_products */ "./resources/src/views/app/pages/reports/top_selling_products.vue"));
      }
    }, {
      name: "product_report",
      path: "product_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | product_report */ "product_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/product_report */ "./resources/src/views/app/pages/reports/product_report.vue"));
      }
    }, {
      name: "detail_product_report",
      path: "detail_product/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_product_report */ "detail_product_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_product_report */ "./resources/src/views/app/pages/reports/detail_product_report.vue"));
      }
    }, {
      name: "top_customers",
      path: "top_customers",
      component: function component() {
        return __webpack_require__.e(/*! import() | top_customers */ "top_customers").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/top_customers */ "./resources/src/views/app/pages/reports/top_customers.vue"));
      }
    }, {
      name: "stock_report",
      path: "stock_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | stock_report */ "stock_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/stock_report */ "./resources/src/views/app/pages/reports/stock_report.vue"));
      }
    }, {
      name: "detail_stock_report",
      path: "detail_stock/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_stock_report */ "detail_stock_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_stock_report */ "./resources/src/views/app/pages/reports/detail_stock_report.vue"));
      }
    }, {
      name: "users_report",
      path: "users_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | users_report */ "users_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/users_report */ "./resources/src/views/app/pages/reports/users_report.vue"));
      }
    }, {
      name: "detail_user_report",
      path: "detail_user/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_user_report */ "detail_user_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_user_report */ "./resources/src/views/app/pages/reports/detail_user_report.vue"));
      }
    }]
  }, {
    name: "profile",
    path: "/app/profile",
    component: function component() {
      return __webpack_require__.e(/*! import() | profile */ "profile").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/profile */ "./resources/src/views/app/pages/profile.vue"));
    }
  }]
}, {
  name: "pos",
  path: "/app/pos",
  // beforeEnter: authenticate,
  component: function component() {
    return __webpack_require__.e(/*! import() | pos */ "pos").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/pos */ "./resources/src/views/app/pages/pos.vue"));
  }
}, {
  path: "*",
  name: "NotFound",
  component: function component() {
    return __webpack_require__.e(/*! import() | NotFound */ "NotFound").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/notFound */ "./resources/src/views/app/pages/notFound.vue"));
  }
}, {
  path: "not_authorize",
  name: "not_authorize",
  component: function component() {
    return __webpack_require__.e(/*! import() | not_authorize */ "not_authorize").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/NotAuthorize */ "./resources/src/views/app/pages/NotAuthorize.vue"));
  }
}];
var router = new vue_router__WEBPACK_IMPORTED_MODULE_6__["default"]({
  mode: "history",
  linkActiveClass: "open",
  routes: routes,
  scrollBehavior: function scrollBehavior(to, from, savedPosition) {
    return {
      x: 0,
      y: 0
    };
  }
});
var originalPush = vue_router__WEBPACK_IMPORTED_MODULE_6__["default"].prototype.push;
vue_router__WEBPACK_IMPORTED_MODULE_6__["default"].prototype.push = function push(location, onResolve, onReject) {
  if (onResolve || onReject) return originalPush.call(this, location, onResolve, onReject);
  return originalPush.call(this, location)["catch"](function (err) {
    return err;
  });
};
router.beforeEach(function (to, from, next) {
  // If this isn't an initial page load.
  if (to.path) {
    // Start the route progress bar.
    nprogress__WEBPACK_IMPORTED_MODULE_4___default().start();
    nprogress__WEBPACK_IMPORTED_MODULE_4___default().set(0.1);
  }
  next();
  if (_store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language && _store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language !== _plugins_i18n__WEBPACK_IMPORTED_MODULE_1__.i18n.locale) {
    _plugins_i18n__WEBPACK_IMPORTED_MODULE_1__.i18n.locale = _store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language;
    next();
  } else if (!_store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language) {
    _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("language/setLanguage", navigator.languages).then(function () {
      _plugins_i18n__WEBPACK_IMPORTED_MODULE_1__.i18n.locale = _store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language;
      next();
    });
  } else {
    next();
  }
});
router.afterEach(function () {
  // Remove initial loading
  var gullPreLoading = document.getElementById("loading_wrap");
  if (gullPreLoading) {
    gullPreLoading.style.display = "none";
  }
  // Complete the animation of the route progress bar.
  setTimeout(function () {
    return nprogress__WEBPACK_IMPORTED_MODULE_4___default().done();
  }, 500);
  // NProgress.done();

  if (window.innerWidth <= 1200) {
    _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("changeSidebarProperties");
    if (_store__WEBPACK_IMPORTED_MODULE_0__["default"].getters.getSideBarToggleProperties.isSecondarySideNavOpen) {
      _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("changeSecondarySidebarProperties");
    }
    if (_store__WEBPACK_IMPORTED_MODULE_0__["default"].getters.getCompactSideBarToggleProperties.isSideNavOpen) {
      _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("changeCompactSidebarProperties");
    }
  } else {
    if (_store__WEBPACK_IMPORTED_MODULE_0__["default"].getters.getSideBarToggleProperties.isSecondarySideNavOpen) {
      _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("changeSecondarySidebarProperties");
    }
  }
});
function Check_Token(_x, _x2, _x3) {
  return (_Check_Token = _Check_Token || _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(to, from, next) {
    var token, res;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          token = to.params.token;
          _context.next = 3;
          return axios.get("password/find/" + token).then(function (response) {
            return response.data;
          });
        case 3:
          res = _context.sent;
          if (res.success) {
            _context.next = 8;
            break;
          }
          next("/app/sessions/signIn");
          _context.next = 9;
          break;
        case 8:
          return _context.abrupt("return", next());
        case 9:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }))).apply(this, arguments);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (router);

/***/ }),

/***/ "./resources/src/store/index.js":
/*!**************************************!*\
  !*** ./resources/src/store/index.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _modules_largeSidebar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modules/largeSidebar */ "./resources/src/store/modules/largeSidebar.js");
/* harmony import */ var _modules_compactSidebar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modules/compactSidebar */ "./resources/src/store/modules/compactSidebar.js");
/* harmony import */ var _modules_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modules/config */ "./resources/src/store/modules/config.js");
/* harmony import */ var _modules_auth__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modules/auth */ "./resources/src/store/modules/auth.js");
/* harmony import */ var _modules_language__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modules/language */ "./resources/src/store/modules/language.js");







// Load Vuex
vue__WEBPACK_IMPORTED_MODULE_5__["default"].use(vuex__WEBPACK_IMPORTED_MODULE_6__["default"]);

// Create store
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new vuex__WEBPACK_IMPORTED_MODULE_6__["default"].Store({
  modules: {
    language: _modules_language__WEBPACK_IMPORTED_MODULE_4__["default"],
    auth: _modules_auth__WEBPACK_IMPORTED_MODULE_3__["default"],
    largeSidebar: _modules_largeSidebar__WEBPACK_IMPORTED_MODULE_0__["default"],
    compactSidebar: _modules_compactSidebar__WEBPACK_IMPORTED_MODULE_1__["default"],
    config: _modules_config__WEBPACK_IMPORTED_MODULE_2__["default"]
  }
}));

/***/ }),

/***/ "./resources/src/store/modules/auth.js":
/*!*********************************************!*\
  !*** ./resources/src/store/modules/auth.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../router */ "./resources/src/router.js");
/* harmony import */ var _store_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../store/index.js */ "./resources/src/store/index.js");
/* harmony import */ var _plugins_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../plugins/i18n */ "./resources/src/plugins/i18n.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }






vue__WEBPACK_IMPORTED_MODULE_4__["default"].use(vuex__WEBPACK_IMPORTED_MODULE_5__["default"]);
var state = {
  isAuthenticated: false,
  Permissions: null,
  user: {},
  loading: false,
  error: null,
  notifs: 0,
  Default_Language: 'en'
};
var getters = {
  isAuthenticated: function isAuthenticated(state) {
    return state.isAuthenticated;
  },
  currentUser: function currentUser(state) {
    return state.user;
  },
  currentUserPermissions: function currentUserPermissions(state) {
    return state.Permissions;
  },
  loading: function loading(state) {
    return state.loading;
  },
  notifs_alert: function notifs_alert(state) {
    return state.notifs;
  },
  DefaultLanguage: function DefaultLanguage(state) {
    return state.Default_Language;
  },
  error: function error(state) {
    return state.error;
  }
};
var mutations = {
  setLoading: function setLoading(state, data) {
    state.loading = data;
    state.error = null;
  },
  setError: function setError(state, data) {
    state.error = data;
    state.loggedInUser = null;
    state.loading = false;
  },
  clearError: function clearError(state) {
    state.error = null;
  },
  setPermissions: function setPermissions(state, Permissions) {
    state.Permissions = Permissions;
  },
  setUser: function setUser(state, user) {
    state.user = user;
  },
  SetDefaultLanguage: function SetDefaultLanguage(state, Language) {
    _plugins_i18n__WEBPACK_IMPORTED_MODULE_3__.i18n.locale = Language;
    _store_index_js__WEBPACK_IMPORTED_MODULE_2__["default"].dispatch("language/setLanguage", Language);
    state.Default_Language = Language;
  },
  Notifs_alert: function Notifs_alert(state, notifs) {
    state.notifs = notifs;
  },
  logout: function logout(state) {
    state.user = null;
    state.Permissions = null;
    state.loggedInUser = null;
    state.loading = false;
    state.error = null;
  }
};
var actions = {
  refreshUserPermissions: function refreshUserPermissions(context) {
    return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return axios__WEBPACK_IMPORTED_MODULE_0___default().get("get_user_auth").then(function (userAuth) {
              var Permissions = userAuth.data.permissions;
              var user = userAuth.data.user;
              var notifs = userAuth.data.notifs;
              var default_language = userAuth.data.user.default_language;
              context.commit('setPermissions', Permissions);
              context.commit('setUser', user);
              context.commit('Notifs_alert', notifs);
              context.commit('SetDefaultLanguage', default_language);
            })["catch"](function () {
              context.commit('setPermissions', null);
              context.commit('setallmodules', null);
              context.commit('setUser', null);
              context.commit('Notifs_alert', null);
              context.commit('SetDefaultLanguage', 'en');
            });
          case 2:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  logout: function logout(_ref) {
    var commit = _ref.commit;
    axios__WEBPACK_IMPORTED_MODULE_0___default()({
      method: 'post',
      url: '/logout',
      baseURL: ''
    }).then(function (userData) {
      window.location.href = '/login';
    });
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  state: state,
  getters: getters,
  actions: actions,
  mutations: mutations
});

/***/ }),

/***/ "./resources/src/store/modules/compactSidebar.js":
/*!*******************************************************!*\
  !*** ./resources/src/store/modules/compactSidebar.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var state = {
  compactSidebarToggleProperties: {
    isSideNavOpen: true,
    isActiveSecondarySideNav: false
  },
  compactLeftSideBarBgColor: "sidebar-dark-purple"
};
var getters = {
  getCompactSideBarToggleProperties: function getCompactSideBarToggleProperties(state) {
    return state.compactSidebarToggleProperties;
  },
  getcompactLeftSideBarBgColor: function getcompactLeftSideBarBgColor(state) {
    return state.compactLeftSideBarBgColor;
  }
};
var actions = {
  changeCompactSidebarProperties: function changeCompactSidebarProperties(_ref) {
    var commit = _ref.commit;
    commit("toggleCompactSidebarProperties");
  },
  changecompactLeftSideBarBgColor: function changecompactLeftSideBarBgColor(_ref2, data) {
    var commit = _ref2.commit;
    commit("togglecompactLeftSideBarBgColor", data);
  }
};
var mutations = {
  toggleCompactSidebarProperties: function toggleCompactSidebarProperties(state) {
    return state.compactSidebarToggleProperties.isSideNavOpen = !state.compactSidebarToggleProperties.isSideNavOpen;
  },
  togglecompactLeftSideBarBgColor: function togglecompactLeftSideBarBgColor(state, data) {
    state.compactLeftSideBarBgColor = data;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  state: state,
  getters: getters,
  actions: actions,
  mutations: mutations
});

/***/ }),

/***/ "./resources/src/store/modules/config.js":
/*!***********************************************!*\
  !*** ./resources/src/store/modules/config.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var state = {
  themeMode: {
    dark: false,
    light: true,
    semi_dark: false,
    theme_color: 'lite-purple',
    layout: 'large-sidebar',
    rtl: false
  }
};
var getters = {
  getThemeMode: function getThemeMode(state) {
    return state.themeMode;
  }
};
var actions = {
  changeThemeMode: function changeThemeMode(_ref) {
    var commit = _ref.commit;
    commit('toggleThemeMode');
  },
  changeThemeLayout: function changeThemeLayout(_ref2, data) {
    var commit = _ref2.commit;
    commit('toggleThemeLayout', data);
  },
  changeThemeRtl: function changeThemeRtl(_ref3) {
    var commit = _ref3.commit;
    commit('toggleThemeRtl');
  }
};
var mutations = {
  toggleThemeMode: function toggleThemeMode(state) {
    state.themeMode.dark = !state.themeMode.dark;
  },
  toggleThemeLayout: function toggleThemeLayout(state, data) {
    state.themeMode.layout = data;
  },
  toggleThemeRtl: function toggleThemeRtl(state) {
    state.themeMode.rtl = !state.themeMode.rtl;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  state: state,
  getters: getters,
  actions: actions,
  mutations: mutations
});

/***/ }),

/***/ "./resources/src/store/modules/language.js":
/*!*************************************************!*\
  !*** ./resources/src/store/modules/language.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_localstorage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-localstorage */ "./node_modules/vue-localstorage/dist/vue-local-storage.js");
/* harmony import */ var vue_localstorage__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vue_localstorage__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _translations__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../translations */ "./resources/src/translations/index.js");



vue__WEBPACK_IMPORTED_MODULE_2__["default"].use((vue_localstorage__WEBPACK_IMPORTED_MODULE_0___default()));
var supportedLanguages = Object.getOwnPropertyNames(_translations__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  namespaced: true,
  state: {
    language: vue__WEBPACK_IMPORTED_MODULE_2__["default"].localStorage.get('language')
  },
  mutations: {
    SET_LANGUAGE: function SET_LANGUAGE(state, lang) {
      vue__WEBPACK_IMPORTED_MODULE_2__["default"].localStorage.set('language', lang);
      state.language = lang;
    }
  },
  actions: {
    setLanguage: function setLanguage(_ref, languages) {
      var commit = _ref.commit;
      if (typeof languages === 'string') {
        commit('SET_LANGUAGE', languages);
      } else {
        var language = supportedLanguages.find(function (sl) {
          return languages.find(function (l) {
            return l.split(new RegExp(sl, 'gi')).length - 1 > 0 ? sl : null;
          });
        });
        commit('SET_LANGUAGE', language);
      }
    }
  }
});

/***/ }),

/***/ "./resources/src/store/modules/largeSidebar.js":
/*!*****************************************************!*\
  !*** ./resources/src/store/modules/largeSidebar.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var state = {
  sidebarToggleProperties: {
    isSideNavOpen: true,
    isSecondarySideNavOpen: false,
    isActiveSecondarySideNav: false
  }
};
var getters = {
  getSideBarToggleProperties: function getSideBarToggleProperties(state) {
    return state.sidebarToggleProperties;
  }
};
var actions = {
  changeSidebarProperties: function changeSidebarProperties(_ref) {
    var commit = _ref.commit;
    commit("toggleSidebarProperties");
  },
  changeSecondarySidebarProperties: function changeSecondarySidebarProperties(_ref2) {
    var commit = _ref2.commit;
    commit("toggleSecondarySidebarProperties");
  },
  changeSecondarySidebarPropertiesViaMenuItem: function changeSecondarySidebarPropertiesViaMenuItem(_ref3, data) {
    var commit = _ref3.commit;
    commit("toggleSecondarySidebarPropertiesViaMenuItem", data);
  },
  changeSecondarySidebarPropertiesViaOverlay: function changeSecondarySidebarPropertiesViaOverlay(_ref4) {
    var commit = _ref4.commit;
    commit("toggleSecondarySidebarPropertiesViaOverlay");
  }
};
var mutations = {
  toggleSidebarProperties: function toggleSidebarProperties(state) {
    return state.sidebarToggleProperties.isSideNavOpen = !state.sidebarToggleProperties.isSideNavOpen;
  },
  toggleSecondarySidebarProperties: function toggleSecondarySidebarProperties(state) {
    return state.sidebarToggleProperties.isSecondarySideNavOpen = !state.sidebarToggleProperties.isSecondarySideNavOpen;
  },
  toggleSecondarySidebarPropertiesViaMenuItem: function toggleSecondarySidebarPropertiesViaMenuItem(state, data) {
    state.sidebarToggleProperties.isSecondarySideNavOpen = data;
    state.sidebarToggleProperties.isActiveSecondarySideNav = data;
  },
  toggleSecondarySidebarPropertiesViaOverlay: function toggleSecondarySidebarPropertiesViaOverlay(state) {
    state.sidebarToggleProperties.isSecondarySideNavOpen = !state.sidebarToggleProperties.isSecondarySideNavOpen;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  state: state,
  getters: getters,
  actions: actions,
  mutations: mutations
});

/***/ }),

/***/ "./resources/src/translations/index.js":
/*!*********************************************!*\
  !*** ./resources/src/translations/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _locales_en__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./locales/en */ "./resources/src/translations/locales/en.js");
/* harmony import */ var _locales_fr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./locales/fr */ "./resources/src/translations/locales/fr.js");
/* harmony import */ var _locales_ar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./locales/ar */ "./resources/src/translations/locales/ar.js");
/* harmony import */ var _locales_de__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./locales/de */ "./resources/src/translations/locales/de.js");
/* harmony import */ var _locales_es__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./locales/es */ "./resources/src/translations/locales/es.js");
/* harmony import */ var _locales_it__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./locales/it */ "./resources/src/translations/locales/it.js");
/* harmony import */ var _locales_Ind__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./locales/Ind */ "./resources/src/translations/locales/Ind.js");
/* harmony import */ var _locales_thai__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./locales/thai */ "./resources/src/translations/locales/thai.js");
/* harmony import */ var _locales_tr_ch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./locales/tr_ch */ "./resources/src/translations/locales/tr_ch.js");
/* harmony import */ var _locales_sm_ch__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./locales/sm_ch */ "./resources/src/translations/locales/sm_ch.js");
/* harmony import */ var _locales_tur__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./locales/tur */ "./resources/src/translations/locales/tur.js");
/* harmony import */ var _locales_ru__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./locales/ru */ "./resources/src/translations/locales/ru.js");
/* harmony import */ var _locales_hn__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./locales/hn */ "./resources/src/translations/locales/hn.js");
/* harmony import */ var _locales_vn__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./locales/vn */ "./resources/src/translations/locales/vn.js");
/* harmony import */ var _locales_kr__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./locales/kr */ "./resources/src/translations/locales/kr.js");
/* harmony import */ var _locales_ba__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./locales/ba */ "./resources/src/translations/locales/ba.js");
/* harmony import */ var _locales_br__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./locales/br */ "./resources/src/translations/locales/br.js");
/* harmony import */ var _locales_da__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./locales/da */ "./resources/src/translations/locales/da.js");
/* harmony import */ var _locales_mm__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./locales/mm */ "./resources/src/translations/locales/mm.js");



















/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  en: _locales_en__WEBPACK_IMPORTED_MODULE_0__["default"],
  mm: _locales_mm__WEBPACK_IMPORTED_MODULE_18__["default"],
  fr: _locales_fr__WEBPACK_IMPORTED_MODULE_1__["default"],
  ar: _locales_ar__WEBPACK_IMPORTED_MODULE_2__["default"],
  de: _locales_de__WEBPACK_IMPORTED_MODULE_3__["default"],
  es: _locales_es__WEBPACK_IMPORTED_MODULE_4__["default"],
  it: _locales_it__WEBPACK_IMPORTED_MODULE_5__["default"],
  Ind: _locales_Ind__WEBPACK_IMPORTED_MODULE_6__["default"],
  thai: _locales_thai__WEBPACK_IMPORTED_MODULE_7__["default"],
  tr_ch: _locales_tr_ch__WEBPACK_IMPORTED_MODULE_8__["default"],
  sm_ch: _locales_sm_ch__WEBPACK_IMPORTED_MODULE_9__["default"],
  tur: _locales_tur__WEBPACK_IMPORTED_MODULE_10__["default"],
  ru: _locales_ru__WEBPACK_IMPORTED_MODULE_11__["default"],
  hn: _locales_hn__WEBPACK_IMPORTED_MODULE_12__["default"],
  vn: _locales_vn__WEBPACK_IMPORTED_MODULE_13__["default"],
  kr: _locales_kr__WEBPACK_IMPORTED_MODULE_14__["default"],
  ba: _locales_ba__WEBPACK_IMPORTED_MODULE_15__["default"],
  br: _locales_br__WEBPACK_IMPORTED_MODULE_16__["default"],
  da: _locales_da__WEBPACK_IMPORTED_MODULE_17__["default"]
});

/***/ }),

/***/ "./resources/src/translations/locales/Ind.js":
/*!***************************************************!*\
  !*** ./resources/src/translations/locales/Ind.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Indonesian

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Kuitansi',
  Pos_Settings: 'Pengaturan titik penjualan',
  Note_to_customer: 'Catatan untuk pelanggan',
  Show_Note_to_customer: 'Tunjukkan Catatan kepada pelanggan',
  Show_barcode: 'Tampilkan kode batang',
  Show_Tax_and_Discount: 'Tampilkan Pajak & Diskon & Pengiriman',
  Show_Customer: 'Tampilkan Pelanggan',
  Show_Email: 'Tampilkan Email',
  Show_Phone: 'Tampilkan Telepon',
  Show_Address: 'Tampilkan Alamat',
  DefaultLanguage: 'Bahasa Bawaan',
  footer: 'catatan kaki',
  Received_Amount: 'Jumlah yang Diterima',
  Paying_Amount: 'Membayar Jumlah',
  Change: 'Mengubah',
  Paying_amount_is_greater_than_Received_amount: 'Jumlah pembayaran lebih besar dari jumlah yang diterima',
  Paying_amount_is_greater_than_Grand_Total: 'Jumlah pembayaran lebih besar dari total keseluruhan',
  code_must_be_not_exist_already: 'kode harus belum ada',
  You_will_find_your_backup_on: 'Anda akan menemukan cadangan Anda di',
  and_save_it_to_your_pc: 'dan simpan ke pc Anda',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Pindai kode batang Anda dan pilih simbologi yang benar di bawah ini',
  Scan_Search_Product_by_Code_Name: 'Pindai/Cari Produk dengan Nama Kode',
  Paper_size: 'Ukuran kertas',
  Clear_Cache: 'Hapus Cache',
  Cache_cleared_successfully: 'Cache berhasil dibersihkan',
  Failed_to_clear_cache: 'Gagal menghapus cache',
  Scan_Barcode: 'Pemindai kode batang',
  Please_use_short_name_of_unit: 'Silakan gunakan nama pendek unit',
  DefaultCustomer: 'Pelanggan Default',
  DefaultWarehouse: 'Gudang Bawaan',
  Payment_Gateway: 'Payment Gateway',
  SMS_Configuration: 'Konfigurasi SMS',
  Gateway: 'Payment Gateway',
  Choose_Gateway: 'Pilih Payment Gateway',
  Send_SMS: 'Pesan berhasil dikirim',
  sms_config_invalid: 'konfigurasi sms salah tidak valid',
  Remove_Stripe_Key_Secret: 'Hapus kunci API Stripe',
  credit_card_account_not_available: 'Rekening kartu kredit tidak tersedia',
  Credit_Card_Info: 'Info Kartu Kredit',
  developed_by: 'Dikembangkan oleh',
  Unit_already_linked_with_sub_unit: 'Unit sudah terhubung dengan sub unit',
  Total_Items_Quantity: 'Total Item dan Kuantitas',
  Value_by_Cost_and_Price: 'Nilai berdasarkan Biaya dan Harga',
  Search_this_table: 'Cari tabel ini',
  import_products: 'Produk impor',
  Field_optional: 'Bidang opsional',
  Download_exemple: 'Unduh contoh',
  field_must_be_in_csv_format: 'Bidang harus dalam format csv',
  Successfully_Imported: 'Berhasil Diimpor',
  file_size_must_be_less_than_1_mega: 'Ukuran file harus kurang dari 1 mega',
  Please_follow_the_import_instructions: 'Harap ikuti petunjuk impor',
  must_be_exist: 'unit harus sudah dibuat',
  Import_Customers: 'Impor Pelanggan',
  Import_Suppliers: 'Pemasok Impor',
  Recent_Sales: 'Penjualan Terbaru',
  Create_Transfer: 'Buat Transfer',
  order_products: 'Item pesanan',
  Search_Product_by_Code_Name: 'Cari Produk dengan Kode atau Nama',
  Reports_payments_Purchase_Return: 'Melaporkan Pembayaran Pengembalian Pembelian',
  Reports_payments_Sale_Return: 'Laporan Pembayaran Retur Penjualan',
  payments_Sales_Return: 'Pembayaran retur penjualan',
  payments_Purchases_Return: 'Pembayaran pembelian kembali',
  CreateSaleReturn: 'Buat Retur Penjualan',
  EditSaleReturn: 'Edit Pengembalian Penjualan',
  SalesReturn: 'Retur Penjualan',
  CreatePurchaseReturn: 'Buat Pengembalian Pembelian',
  EditPurchaseReturn: 'Edit Pengembalian Pembelian',
  PurchasesReturn: 'Pembelian Kembali',
  Due: 'jatuh tempo',
  Profit: 'Keuntungan',
  Revenue: 'Pendapatan',
  Sales_today: 'Penjualan hari ini',
  People: 'Orang-orang',
  Successfully_Created: 'Berhasil Dibuat',
  Successfully_Updated: 'Berhasil diperbaharui',
  Success: 'sukses',
  Failed: 'Gagal',
  Warning: 'Peringatan',
  Please_fill_the_form_correctly: 'Harap isi formulir dengan benar',
  Field_is_required: 'Bidang wajib diisi',
  Error: 'Kesalahan!',
  you_are_not_authorized: 'Maaf! Anda tidak berwenang.',
  Go_back_to_home: 'Kembali ke beranda',
  page_not_exist: 'Maaf! Halaman yang Anda cari tidak ada.',
  Choose_Status: 'Pilih status',
  Choose_Method: 'Pilih Metode',
  Choose_Symbology: 'Pilih simbologi',
  Choose_Category: 'Pilih Kategori',
  Choose_Customer: 'Pilih Pelanggan',
  Choose_Supplier: 'Pilih Pemasok',
  Choose_Unit_Purchase: 'Pilih Unit Pembelian',
  Choose_Sub_Category: 'Pilih Subkategori',
  Choose_Brand: 'Pilih Merek',
  Choose_Warehouse: 'Pilih Gudang',
  Choose_Unit_Sale: 'Pilih Unit Penjualan',
  Enter_Product_Cost: 'Masukkan Biaya Produk',
  Enter_Stock_alert: 'Masuk ke Stock alert',
  Choose_Unit_Product: 'Pilih Unit Produk',
  Enter_Product_Price: 'Masukkan Harga Produk',
  Enter_Name_Product: 'Masukkan Nama Produk',
  Enter_Role_Name: 'Masukkan Nama Peran',
  Enter_Role_Description: 'Masukkan Deskripsi Peran',
  Enter_name_category: 'Masukkan Nama kategori',
  Enter_Code_category: 'Masukkan Kode kategori',
  Enter_Name_Brand: 'Masukkan Nama Merek',
  Enter_Description_Brand: 'Masukkan Deskripsi Merek',
  Enter_Code_Currency: 'Masukkan Mata Uang Kode',
  Enter_name_Currency: 'Masukkan nama Mata uang',
  Enter_Symbol_Currency: 'Masukkan Mata Uang Simbol',
  Enter_Name_Unit: 'Masukkan Nama Unit',
  Enter_ShortName_Unit: 'Masukkan Unit nama pendek',
  Choose_Base_Unit: 'Pilih Unit Dudukan',
  Choose_Operator: 'Pilih Operator',
  Enter_Operation_Value: 'Masukkan Nilai Operasi',
  Enter_Name_Warehouse: 'Masukkan Nama Gudang',
  Enter_Phone_Warehouse: 'Masukkan Telepon Gudang',
  Enter_Country_Warehouse: 'Masukkan Negara Gudang',
  Enter_City_Warehouse: 'Masuk kota gudang',
  Enter_Email_Warehouse: 'Masukkan email Gudang',
  Enter_ZipCode_Warehouse: 'Masukkan Kode Pos Gudang',
  Choose_Currency: 'Pilih mata uang',
  Thank_you_for_your_business: 'Terima kasih atas bisnis Anda!',
  Cancel: 'Membatalkan',
  New_Customer: 'Pelanggan baru',
  Incorrect_Login: 'Login Salah',
  Successfully_Logged_In: 'Berhasil Masuk',
  This_user_not_active: 'Pengguna ini tidak aktif',
  SignIn: 'Masuk',
  Create_an_account: 'Buat sebuah akun',
  Forgot_Password: 'Tidak ingat kata sandi ?',
  Email_Address: 'Alamat email',
  SignUp: 'Daftar',
  Already_have_an_account: 'Sudah memiliki akun ?',
  Reset_Password: 'Setel Ulang Kata Sandi',
  Failed_to_authenticate_on_SMTP_server: 'Gagal mengautentikasi di server SMTP',
  We_cant_find_a_user_with_that_email_addres: 'Kami tidak dapat menemukan pengguna dengan alamat email itu',
  We_have_emailed_your_password_reset_link: 'Kami telah mengirimkan email tautan pengaturan ulang kata sandi Anda',
  Please_fill_the_Email_Adress: 'Silahkan isi Alamat Email',
  Confirm_password: 'Setujui password',
  Your_Password_has_been_changed: 'Kata sandi Anda telah diubah',
  The_password_confirmation_does_not_match: 'Konfirmasi kata sandi tidak cocok',
  This_password_reset_token_is_invalid: 'Token penyetelan ulang sandi ini tidak valid',
  Warehouse_report: 'Laporan gudang',
  All_Warehouses: 'Semua Gudang',
  Expense_List: 'Daftar Biaya',
  Expenses: 'Beban',
  This_Week_Sales_Purchases: 'Penjualan & Pembelian Minggu Ini',
  Top_Selling_Products: 'Produk Terlaris',
  View_all: 'Lihat semua',
  Payment_Sent_Received: 'Pembayaran Dikirim & Diterima',
  Filter: 'Saring',
  Invoice_POS: 'POS Faktur',
  Invoice: 'Faktur',
  Customer_Info: 'Info Pelanggan',
  Company_Info: 'Info perusahaan',
  Invoice_Info: 'Info Faktur',
  Order_Summary: 'Ringkasan Pesanan',
  Quote_Info: 'Info Kutipan',
  Del: 'Menghapus',
  SuppliersPaiementsReport: 'Laporan Pembayaran Pemasok',
  Purchase_Info: 'Beli Info',
  Supplier_Info: 'Info Pemasok',
  Return_Info: 'info Kembali',
  Expense_Category: 'Kategori Biaya',
  Create_Expense: 'Buat Beban',
  Details: 'rincian',
  Discount_Method: 'Metode Diskon',
  Net_Unit_Cost: 'Biaya Satuan Net',
  Net_Unit_Price: 'Harga Satuan Bersih',
  Edit_Expense: 'Edit Biaya',
  All_Brand: 'Semua Merek',
  All_Category: 'Semua Kategori',
  ListExpenses: 'Daftar Biaya',
  Create_Permission: 'Buat Izin',
  Edit_Permission: 'Edit Izin',
  Reports_payments_Sales: 'Laporan pembayaran Penjualan',
  Reports_payments_Purchases: 'Melaporkan pembayaran Pembelian',
  Reports_payments_Return_Customers: 'Laporan pembayaran Retur Pelanggan',
  Reports_payments_Return_Suppliers: 'Laporan pembayaran Kembali Pemasok',
  Expense_Deleted: 'Pengeluaran ini telah dihapus',
  Expense_Updated: 'Biaya ini telah Diperbarui',
  Expense_Created: 'Pengeluaran Ini Telah Dibuat',
  DemoVersion: 'Anda tidak dapat melakukan ini di versi demo',
  OrderStatistics: 'Statistik Penjualan',
  AlreadyAdd: 'Produk Ini Sudah Ditambahkan !!',
  AddProductToList: 'Silakan Tambahkan Produk Ke Daftar !!',
  AddQuantity: 'Tambahkan jumlah Detail !!',
  InvalidData: 'Data Tidak Valid !!',
  LowStock: 'kuantitas melebihi kuantitas yang tersedia dalam stok',
  WarehouseIdentical: 'Kedua gudang itu tidak mungkin sama !!',
  VariantDuplicate: 'Varian Ini Duplikat !!',
  Filesize: 'Ukuran file',
  GenerateBackup: 'Hasilkan Cadangan',
  BackupDatabase: 'Database cadangan',
  Backup: 'Cadangan',
  Paid: 'Dibayar',
  Unpaid: 'Belum dibayar',
  Today: 'Hari ini',
  Income: 'Pendapatan'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'Beban'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'Penjualan'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Aktif'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Tidak aktif'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Telepon'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Cari lewat Telepon'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Pemasok'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Kutipan'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'Penjualan'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'Pembelian'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'Kembali'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'Pengaturan'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'Pengaturan sistem'), _defineProperty(_Receipt$Pos_Settings, "Users", 'Pengguna'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Izin Grup'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'Mata Uang'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'Gudang'), _defineProperty(_Receipt$Pos_Settings, "Units", 'Unit'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", ' Pembelian Unit'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Unit Penjualan'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'Laporan'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Laporan Pembayaran'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Pembelian Pembayaran'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Pembayaran Penjualan'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Laba rugi'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Grafik Stok Gudang'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'Laporan penjualan'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Laporan Pembelian'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'Laporan Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Laporan Pemasok'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Laporan Pemasok'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'Data Penjualan Harian'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'Data Pembelian Harian'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Lima rekor terakhir'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'Filter'), _defineProperty(_Receipt$Pos_Settings, "date", 'tanggal'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Referensi'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Pemasok'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Status pembayaran'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'Kode pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Status'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Kode penyuplai'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Kategori'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'Kategori'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'Transfer Saham'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Manajemen Stok'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Dasbor'), _defineProperty(_Receipt$Pos_Settings, "Products", 'Produk'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'Daftar produk'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Manajemen Produk'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Peringatan Kuantitas Produk'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Kode Produk'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Pajak Produk'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'Subkategori'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'Penunjukan'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Peringatan Stok'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'gudang'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'Pajak'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Harga beli'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Harga jual'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'Kuantitas'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Penjualan Unit'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'Pembelian Unit'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Manajemen Mata Uang'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Kode mata uang'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Nama Mata Uang'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Simbol'), _defineProperty(_Receipt$Pos_Settings, "All", 'Semua'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Edit Produk'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Cari berdasarkan Kode'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Cari berdasarkan nama'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Rincian Produk'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'Nama Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Manajemen pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Membuat'), _defineProperty(_Receipt$Pos_Settings, "add", 'Membuat'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'Edit'), _defineProperty(_Receipt$Pos_Settings, "Close", 'Menutup'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Silahkan pilih'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Tindakan'), _defineProperty(_Receipt$Pos_Settings, "Email", 'Surel'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Edit Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Buat Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Country", 'Negara'), _defineProperty(_Receipt$Pos_Settings, "City", 'Kota'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Alamat'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'detil pelanggan'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Daftar Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Kode penyuplai'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'nama pemasok'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Manajemen Pemasok'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Detail Pemasok'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Manajemen Kutipan'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Subtotal'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Jumlah tersisa'), _defineProperty(_Receipt$Pos_Settings, "complete", 'lengkap'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'tertunda'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Diterima'), _defineProperty(_Receipt$Pos_Settings, "partial", 'Sebagian'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Kembali'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Detail kutipan'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Edit Kutipan'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Buat Penjualan'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'Unduh PDF'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'Kutipan Terkirim di Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Hapus Kutipan'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'Buat Kutipan'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Pilih Produk'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Produk (Kode - Nama)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Harga'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'persediaan'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Total'), _defineProperty(_Receipt$Pos_Settings, "Num", 'N°'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Biaya unit'), _defineProperty(_Receipt$Pos_Settings, "to", 'ke'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Subyek'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Pesan'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'Email Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Kirim'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'Kutipan'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Halo'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Silakan temukan lampiran untuk Quotation Anda'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Tambahkan Produk ke Daftar Pesanan'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Pilih gudang'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'silahkan Pilih Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Manajemen penjualan'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Keseimbangan'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Kuantitas Kembali'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Total Pengembalian'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'Jumlah'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Detail penjualan'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Edit Obral'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Buat Penjualan'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Tunjukkan Pembayaran'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'Buat Pembayaran'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Edit Pembayaran'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Kirim Obral melalui Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Hapus Obral'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Dibayar oleh'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Pilihan pembayaran'), _defineProperty(_Receipt$Pos_Settings, "Note", 'Catatan'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Pembayaran selesai!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Manajemen Pembelian'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Dipesan'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Hapus Pembelian'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Kirim Pembelian melalui Email'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'Edit Pembelian'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'Detail pembelian'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Buat Pembelian'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'Email Pemasok'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Membeli pembayaran'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Membeli data pembayaran'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'Pembayaran penjualan'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Data pembayaran penjualan'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'manajemen pengguna'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'Nama depan'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'nama keluarga'), _defineProperty(_Receipt$Pos_Settings, "username", 'Nama pengguna'), _defineProperty(_Receipt$Pos_Settings, "password", 'Kata sandi'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'Kata sandi baru'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Mengubah avatar'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Harap kosongkan bidang ini jika Anda belum mengubahnya'), _defineProperty(_Receipt$Pos_Settings, "type", 'Tipe'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Izin Pengguna'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Wewenang'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Deskripsi peran'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Buat Izin'), _defineProperty(_Receipt$Pos_Settings, "View", 'Melihat'), _defineProperty(_Receipt$Pos_Settings, "Del", 'Menghapus'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'Penyesuaian Baru'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Edit Penyesuaian'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'Anda tidak dapat mengurangi produk yang memiliki stok 0'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'Tambahan'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Pengurangan'), _defineProperty(_Receipt$Pos_Settings, "profil", 'profil'), _defineProperty(_Receipt$Pos_Settings, "logout", 'keluar'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'Anda tidak dapat mengubah karena Pembelian ini sudah dibayar'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'Anda tidak dapat mengubah karena Obral ini sudah dibayar'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'Anda tidak dapat mengubah karena Pengembalian ini sudah dibayar'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'Kutipan ini sudah menghasilkan penjualan'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'Buat produk'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'Kutipan Ini Lengkap'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Konfigurasi Situs'), _defineProperty(_Receipt$Pos_Settings, "Language", 'Bahasa'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Mata Uang Default'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Masuk Captcha'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'Default Email'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Nama situs'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Ubah Logo'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'Konfigurasi SMTP'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'TUAN RUMAH'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'PELABUHAN'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'Enkripsi'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'Konfigurasi SMTP Salah'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Pembayaran Kembali'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'Mengembalikan Faktur'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'Mengembalikan Data Faktur'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'Tampilkan semua catatan dari semua Pengguna'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Diskon'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Pajak Pesanan'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'pengiriman'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Nama Perusahaan'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Telepon Perusahaan'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Alamat perusahaan'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Kode'), _defineProperty(_Receipt$Pos_Settings, "image", 'gambar'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Cetak kode batang'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Mengembalikan Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Pengembalian Pemasok'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'Kembalikan Faktur Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Faktur Pemasok Kembali'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'Tidak ada data yang tersedia'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'gambar produk'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'Barcode'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'titik Penjualan'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Unggah Ubahsuaian'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'Point of Sale Management'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Pengaturan'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Memperbarui'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Setel ulang'), _defineProperty(_Receipt$Pos_Settings, "print", 'Mencetak'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Cari Melalui Email'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Choose Product'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Jml'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Item'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Jumlah'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'jumlah total'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Silakan Pilih Pemasok'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Silakan Pilih Status'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'Dibayar oleh'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Pilih Gudang'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'Bayar sekarang'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'Daftar Kategori'), _defineProperty(_Receipt$Pos_Settings, "Description", 'Deskripsi'), _defineProperty(_Receipt$Pos_Settings, "submit", 'Kirimkan'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'Terjadi masalah saat membuat Faktur ini. Silakan coba lagi'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'Ada masalah pembayaran. Silakan coba lagi.'), _defineProperty(_Receipt$Pos_Settings, "IncomeExpenses", 'Pendapatan & Beban'), _defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Penjualan & Pembelian Harian'), _defineProperty(_Receipt$Pos_Settings, "ProductsExpired", 'Produk Kedaluwarsa'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'Daftar Merek'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'Buat Penyesuaian'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'Beberapa kata ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'Gambar Pengguna'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Perbarui Produk'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'Merek'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'Simbologi Barcode'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'Biaya Produk'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Harga Produk'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'Produk Satuan'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'Metode Perpajakan'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'Beberapa Gambar'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'Produk Memiliki Banyak Varian'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'Produk Memiliki Promosi'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Promosi Mulai'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Promosi Berakhir'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Harga promosi'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Harga'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'Biaya'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'Satuan'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'Variasi Produk'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'Varian'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Patokan harga'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'Buat Pelanggan Kembali'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Edit Pelanggan Kembali'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'Buat Pemasok Pengembalian'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'Dokumentasi'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'Edit Pemasok Pengembalian'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Dari Gudang'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'Ke Gudang'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'Edit Transfer'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'Transfer Detail'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'tertunda'), _defineProperty(_Receipt$Pos_Settings, "Received", 'Diterima'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Dipesan'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'Manajemen Izin'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'Merek'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'Citra Merek'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'Nama merk'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'Deskripsi Merek'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'Unit dasar'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'Manajemen Unit'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Nilai Operasi'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'Operator'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'Lima Produk Teratas'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'Lima Penjualan terakhir'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'Penyesuaian Daftar'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'Daftar Transfer'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Buat Transfer'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'Manajemen Pesanan'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'Daftar Kutipan'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'Daftar Pembelian'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'Daftar Penjualan'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'Daftar Pengembalian'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'Manajemen Orang'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: 'Apakah kamu yakin',
  Text: 'Anda tidak akan dapat mengembalikan ini!',
  confirmButtonText: 'Ya, hapus!',
  cancelButtonText: 'Membatalkan',
  Deleted: 'Dihapus!',
  Failed: 'Gagal!',
  Therewassomethingwronge: 'Ada yang salah',
  CustomerDeleted: 'Klien ini telah dihapus.',
  SupplierDeleted: 'Pemasok ini telah dihapus.',
  QuoteDeleted: 'Kutipan ini telah dihapus.',
  SaleDeleted: 'Obral ini telah dihapus.',
  PaymentDeleted: 'Pembayaran ini telah dihapus.',
  PurchaseDeleted: 'Pembelian ini telah dihapus.',
  ReturnDeleted: 'Pengembalian ini telah dihapus.',
  ProductDeleted: 'Produk ini telah dihapus.',
  ClientError: 'Klien ini sudah terhubung dengan Operasi lain',
  ProviderError: 'Pemasok ini sudah terhubung dengan Operasi lain',
  UserDeleted: 'Pengguna ini telah dihapus.',
  UnitDeleted: 'Unit ini telah dihapus.',
  RoleDeleted: 'Peran ini telah dihapus.',
  TaxeDeleted: 'Pajak ini telah dihapus.',
  SubCatDeleted: 'Sub Kategori ini telah dihapus.',
  CatDeleted: 'Kategori ini telah dihapus.',
  WarehouseDeleted: 'Gudang ini telah dihapus.',
  AlreadyLinked: 'produk ini sudah ditautkan dengan Operasi lain',
  AdjustDeleted: 'Penyesuaian ini telah dihapus.',
  TitleCurrency: 'Mata Uang ini telah dihapus.',
  TitleTransfer: 'Transfer berhasil dihapus',
  BackupDeleted: 'Cadangan berhasil dihapus',
  TitleBrand: 'Merek ini telah dihapus'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleProfile: 'Profil Anda berhasil diperbarui',
  TitleAdjust: 'Penyesuaian Berhasil diperbarui',
  TitleRole: 'Peran berhasil diperbarui',
  TitleUnit: 'Unit Berhasil Diperbarui',
  TitleUser: 'Pengguna Berhasil Diperbarui',
  TitleCustomer: 'Pembaruan Pelanggan berhasil',
  TitleQuote: 'Kutipan Berhasil Diperbarui',
  TitleSale: 'Obral Berhasil Diperbarui',
  TitlePayment: 'Pembayaran berhasil diperbarui',
  TitlePurchase: 'Pembelian Berhasil Diperbarui',
  TitleReturn: 'Kembali Diperbarui dengan sukses',
  TitleProduct: 'Pembaruan Produk berhasil',
  TitleSupplier: 'Pemasok berhasil diperbarui',
  TitleTaxe: 'Pajak berhasil diperbarui',
  TitleCat: 'Kategori Berhasil diperbarui',
  TitleWarhouse: 'Gudang berhasil diperbarui',
  TitleSetting: 'Pengaturan Berhasil Diperbarui',
  TitleCurrency: 'Pembaruan Mata Uang berhasil',
  TitleTransfer: 'Transfer Berhasil diperbarui',
  TitleBrand: 'Merek ini telah diperbarui'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'Merek Ini Telah Dibuat',
  TitleRole: 'Peran berhasil dibuat',
  TitleUnit: 'Unit Berhasil Dibuat',
  TitleUser: 'Pengguna Berhasil Dibuat di',
  TitleCustomer: 'Pelanggan Dibuat dengan sukses',
  TitleQuote: 'Kutipan Berhasil dibuat',
  TitleSale: 'Penjualan Berhasil dibuat',
  TitlePayment: 'Pembayaran Berhasil Dibuat',
  TitlePurchase: 'Pembelian Berhasil dibuat',
  TitleReturn: 'Kembali Dibuat dengan sukses',
  TitleProduct: 'Produk Berhasil Dibuat di',
  TitleSupplier: 'Pemasok Dibuat dengan sukses',
  TitleTaxe: 'Pajak berhasil dibuat',
  TitleCat: 'Kategori Berhasil dibuat',
  TitleWarhouse: 'Gudang Dibuat dengan sukses',
  TitleAdjust: 'Penyesuaian Berhasil Dibuat',
  TitleCurrency: 'Mata uang Dibuat dengan sukses',
  TitleTransfer: 'Transfer Dibuat dengan sukses'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email Berhasil dikirim'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'penjualan ini sudah ditautkan dengan Return!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'Manajemen Pengembalian'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'detail pengembalian'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'Edit Kembali'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'Buat Pengembalian'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'Kirim Pengembalian melalui Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Hapus Kembali'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'Biaya Tambahan Pengembalian'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'pengiriman'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Pilih Sale'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'Anda dapat menghapus item atau mengatur kuantitas dikembalikan ke nol jika tidak dikembalikan'), _defineProperty(_Receipt$Pos_Settings, "Return", 'Kembali'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'Membeli'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'Total Penjualan'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total Pembelian'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'Total Pengembalian'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'Pembayaran Bersih'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'Paiements Sent'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'Pembayaran diterima'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'Diterima'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Terkirim'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Peringatan Kuantitas Produk'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Kode'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'Produk'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'Kuantitas Peringatan'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Grafik Stok Gudang'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'Total Produk'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'Jumlah total'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'Lima Pelanggan Teratas'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Jumlah total'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'Total Dibayar'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'Laporan Penjualan Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Laporan Pembayaran Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'Laporan Kutipan Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'Pembayaran'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'Lima Pemasok Teratas'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'Laporan Pembelian Pemasok'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'Laporan Pembayaran Pemasok'), _defineProperty(_Receipt$Pos_Settings, "Name", 'Nama'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Kode'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'Manajemen Gudang'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'Kode Pos'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Manajemen kategori'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'Kategori kode'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'Kategori nama'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'Kategori Induk'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'Manajemen pajak'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'Nama Pajak'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'Persentase pajak'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Pembelian Unit'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'Unit penjualan'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'Nama pendek'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Harap Pilih Ini sebelum menambahkan produk apa pun'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'Penyesuaian Stok'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'Pilih gudang sebelum memilih produk apa pun'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'Transfer Saham'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'Pilih Periode'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'Tahun ini'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'Hari Ini'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Bulan ini'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'Minggu ini'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'Detail Penyesuaian'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'Pengguna Ini Telah Diaktifkan'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'Pengguna Ini Telah Dinonaktifkan'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'Halaman tidak ditemukan.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'kesalahan! Halaman tidak ditemukan.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'Kami tidak dapat menemukan halaman yang Anda cari. Sementara itu, Anda mungkin'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'kembali ke dasbor'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'HRM'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'Para karyawan'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'Kehadiran'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Tinggalkan Permintaan'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Tinggalkan Jenis'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Perusahaan'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Departemen'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'sebutan'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Pergeseran Kantor'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Liburan'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Masukkan nama perusahaan'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Masukkan alamat email'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Masukkan telepon perusahaan'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Masukkan negara perusahaan'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Berhasil dibuat'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Berhasil diperbarui'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Berhasil dihapus'), _defineProperty(_Receipt$Pos_Settings, "department", 'Departemen'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Masukkan nama departemen'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Pilih Perusahaan'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Kepala Departemen'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Pilih Kepala Departemen'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Masukkan nama Shift'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Monday In'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tuesday In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'tuesday Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'Liburan'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Masukkan judul'), _defineProperty(_Receipt$Pos_Settings, "title", 'judul'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Mulai tanggal'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Masukkan tanggal mulai'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Tanggal selesai'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Masukkan tanggal selesai'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Harap berikan detail apa pun'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'Kehadiran'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Masukkan tanggal kehadiran'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'Pilih Karyawan'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'Karyawan'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Lama pengerjaan'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'Daun yang tersisa tidak mencukupi'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Tinggalkan Jenis'), _defineProperty(_Receipt$Pos_Settings, "Days", 'hari'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Departemen'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Pilih jenis cuti'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'Pilih status'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Tinggalkan Alasan'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Masuk Alasan Keluar'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Tambahkan Karyawan'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'Nama depan'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Masukkan Nama Depan'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Nama keluarga'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Masukkan Nama Belakang'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Jenis kelamin'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Pilih Jenis Kelamin'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Masukkan tanggal lahir'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Tanggal lahir'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Masukkan Negara'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Masukkan nomor telepon'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Tanggal Bergabung'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Masukkan tanggal bergabung'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'Pilih Penunjukan'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'Penamaan'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Pergeseran Kantor'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Pilih Shift Kantor'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Masukkan Tanggal Keluar'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Tanggal Keluar'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Cuti tahunan'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Masuk Cuti Tahunan'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Sisa cuti'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Detail Karyawan'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Informasi dasar'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Status keluarga'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Pilih status Keluarga'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Jenis Pekerjaan'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Pilih jenis Pekerjaan'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Masukkan Kota'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Propinsi'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Masuk Provinsi'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Masukkan alamat'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Masukkan kode pos'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Kode Pos'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Tarif per jam'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Masukkan tarif Per Jam'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Gaji pokok'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Masukkan Gaji Pokok'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Media sosial'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skype'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Masuk ke Skype'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Masuk ke Facebook'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Masuk ke WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Masuk ke LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Masuk ke Twitter'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Pengalaman'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'akun bank'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Nama perusahaan'), _defineProperty(_Receipt$Pos_Settings, "Location", 'Lokasi'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Masukkan lokasi'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Masukkan Deskripsi'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Nama Bank'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Masukkan Nama Bank'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Cabang Bank'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Masuk Cabang Bank'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Nomor Bank'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Masukkan Nomor Bank'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'gudang yang ditugaskan'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'Pelanggan teratas'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Lampiran'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'lihat karyawan'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'edit karyawan'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'hapus karyawan'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Ditambahkan oleh'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Tambahkan IMEI/Nomor Seri produk'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'Produk Memiliki Imei/Nomor Seri'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'pengiriman'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Dikirim ke'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Referensi Pengiriman'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Referensi Penjualan'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Sunting Pengiriman'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Penuh sesak'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Dikirim'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Terkirim'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Dibatalkan'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Status pengiriman'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Laporan Pengguna'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'Laporan Stok'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Jumlah Pembelian'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Jumlah Kutipan'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Jumlah penjualan retur'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Jumlah pengembalian pembelian'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Jumlah transfer'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Penyesuaian total'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'Laporan Pengguna'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Saham saat ini'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'Nama Produk'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Jumlah Hutang'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Jumlah Hutang'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Beberapa Gudang'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'Semua Gudang'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Biaya Produk'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'Pengaturan SMS'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'Pengaturan POS'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Gerbang pembayaran'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'Pengaturan Surat'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Gerbang SMS Standar'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Pengaturan Modul'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Modul berhasil diaktifkan'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Modul berhasil Dinonaktifkan'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Perbarui Pengaturan'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Silakan Unggah Modul yang Benar'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Berhasil diunggah'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'detil pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Sunting Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Hapus Pelanggan'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'membayar Jatuh tempo'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'Jumlah pembayaran lebih besar dari Total Hutang'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Faktur pelanggan'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'Produk Ini Bukan Untuk Dijual'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Selamat datang di Dasbor Anda'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Total yang harus dibayar'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Pilih Ref Penjualan'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Silahkan Pilih Dijual'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Referensi Penjualan'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'daftar pengembalian produk'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'qty kembali'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Pilih Referensi Pembelian'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Referensi Pembelian'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Silahkan Pilih Pembelian'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'Qty return lebih besar dari Qty yang dibeli'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'Qty return lebih besar dari Qty yang terjual'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Qty terjual'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Kuantitas yang dibeli'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Nama pengirim'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'Modul harus diunggah sebagai file zip'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Unggah Modul'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Semua Modul Terpasang'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Versi sekarang'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'Anda sudah memiliki versi terbaru'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Pembaruan tersedia'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Perbarui Log'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Memperbarui sekarang'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'Lihat Ubah Log'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Footer faktur'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'CATATAN: Harap Tunggu hingga pembaruan selesai sepenuhnya. Tidak disarankan untuk menutup browser atau menghentikan proses Upgrade'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Catatan: Pastikan Anda membuat cadangan versi & basis data Anda saat ini sebelum menjalankan Peningkatan, Untuk memulihkannya jika ada kesalahan'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Zona waktu'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'catatan pembayaran'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'nota penjualan'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Total Penjualan hutang'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Total Jual Kembalikan hutang'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'bayar semua hutang jual sekaligus'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'bayar semua hutang retur penjualan sekaligus'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Laba kotor'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'membayar semua utang pembelian sekaligus'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Hapus Penyedia'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Sunting Penyedia'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Detail penyedia'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Total Pembelian jatuh tempo'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Nota kredit'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Nota kredit'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Kembalikan penjualan'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Pengembalian Pembelian'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Nomor pajak'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Silakan tambahkan jumlah pengembalian'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'Pengembalian ada untuk Transaksi'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'Qty return lebih besar dari Quantity Remaining'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Produk apa pun dengan jumlah yang disetel ke 0 tidak akan dikembalikan dananya'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'bayar semua retur pembelian yang jatuh tempo sekaligus'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Total Pengembalian Pembelian yang jatuh tempo'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Pengembalian pembelian jatuh tempo'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'Jual retur jatuh tempo'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'Laporan produk'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'laporan penjualan produk'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'laporan pembelian produk'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'Qty terjual'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Qty dibeli'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Saring menurut gudang'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Cetak Faktur secara otomatis'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'melihat gudang'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Info Kartu Kredit'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Info Kartu Kredit Tersimpan'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Kartu kredit berhasil diubah'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Template Notifikasi'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'Notifikasi Email'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'Notifikasi SMS'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Ubah Detail Produk'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'Ubah Pajak, Diskon, dan Pengiriman'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Buat Kutipan dengan Stok'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Nama Variabel'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Biaya Variabel'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Harga Variabel'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Kode Variabel'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Harap tunggu hingga produk dimuat'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Pilih Gateway SMS'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Notifikasi Klien'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Tag yang Tersedia'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'Subjek Email'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'Isi Email'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Notifikasi Pemasok'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'Isi SMS'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'SMS Templates'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Email Templates'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/ar.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/ar.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Update, _Create, _Pos_Settings$Receipt;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Arabe

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Pos_Settings$Receipt = {
  Pos_Settings: 'إعدادات نقاط البيع',
  Receipt: 'الإيصال',
  Note_to_customer: 'ملاحظة للعميل',
  Show_Note_to_customer: 'إظهار ملاحظة للعميل',
  Show_barcode: 'إظهار الشفرة',
  Show_Tax_and_Discount: 'إظهار الضرائب والخصم والشحن',
  Show_Customer: 'إظهار العميل',
  Show_Email: 'إظهار البريد الإلكتروني',
  Show_Phone: 'إظهار الهاتف',
  Show_Address: 'إظهار العنوان',
  DefaultLanguage: 'اللغة الافتراضية',
  footer: 'تذييل',
  Received_Amount: 'المبلغ المستلم',
  Paying_Amount: 'مبلغ الدفع',
  Change: 'الصرف',
  Paying_amount_is_greater_than_Received_amount: 'مبلغ الدفع أكبر من المبلغ المستلم',
  Paying_amount_is_greater_than_Grand_Total: 'مبلغ الدفع أكبر من المبلغ الإجمالي الكلي',
  code_must_be_not_exist_already: 'يجب أن يكون الرمز غير موجود بالفعل',
  You_will_find_your_backup_on: 'سوف تجد النسخة الاحتياطية الخاصة بك على',
  and_save_it_to_your_pc: 'و قم بحفظه على جهاز الكمبيوتر الخاص بك',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'امسح الرمز الشريطي ضوئيًا وحدد الترميز الصحيح أدناه',
  Scan_Search_Product_by_Code_Name: 'مسح / بحث عن المنتج حسب الاسم الرمزي',
  Paper_size: 'حجم الورق',
  Clear_Cache: 'مسح ذاكرة التخزين المؤقت',
  Cache_cleared_successfully: 'تم مسح ذاكرة التخزين المؤقت بنجاح',
  Failed_to_clear_cache: 'فشل مسح ذاكرة التخزين المؤقت',
  Scan_Barcode: 'ماسح الباركود',
  Please_use_short_name_of_unit: 'الرجاء استخدام الاسم المختصر للوحدة',
  DefaultCustomer: 'العميل الافتراضي',
  DefaultWarehouse: 'المستودع الافتراضي',
  Payment_Gateway: 'بوابة الدفع',
  SMS_Configuration: 'إعدادات الرسائل القصيرة',
  Gateway: 'بوابة الدفع',
  Choose_Gateway: 'اختر بوابة الدفع',
  Send_SMS: 'تم ارسال الرسالة بنجاح',
  sms_config_invalid: 'إعدادات الرسائل القصيرة غير صالحة',
  Remove_Stripe_Key_Secret: 'حذف مفاتيح Stripe API',
  credit_card_account_not_available: 'حساب بطاقة الائتمان غير متوفر',
  Credit_Card_Info: 'معلومات بطاقة الائتمان',
  developed_by: 'طورت بواسطة',
  Unit_already_linked_with_sub_unit: 'الوحدة مرتبطة بالفعل بوحدة فرعية',
  Total_Items_Quantity: 'مجموع العناصر والكمية',
  Value_by_Cost_and_Price: 'القيمة حسب التكلفة والسعر',
  Search_this_table: 'ابحث في هذا الجدول',
  import_products: 'استيراد المنتجات',
  Field_optional: 'حقل اختياري',
  Download_exemple: 'تحميل المثال',
  field_must_be_in_csv_format: 'يجب أن يكون الحقل بتنسيق csv',
  Successfully_Imported: 'تم الاستيراد بنجاح',
  file_size_must_be_less_than_1_mega: 'يجب أن يكون حجم الملف أقل من 1 ميغا',
  Please_follow_the_import_instructions: 'يرجى اتباع تعليمات الاستيراد',
  must_be_exist: 'يجب أن تكون الوحدة قد تم إنشاؤها بالفعل',
  Import_Customers: 'استيراد العملاء',
  Import_Suppliers: 'استيراد الموردين',
  Recent_Sales: 'المبيعات الأخيرة',
  Create_Transfer: 'إنشاء تحويل',
  order_products: 'طلب المنتجات',
  Search_Product_by_Code_Name: 'ابحث عن المنتج بالكود أو الاسم',
  Reports_payments_Purchase_Return: 'تقارير مدفوعات مرتجعات الشراء',
  Reports_payments_Sale_Return: 'تقارير مدفوعات مرتجعات البيع',
  payments_Sales_Return: 'مدفوعات إرجاع المبيعات',
  payments_Purchases_Return: 'مدفوعات مشتريات العودة',
  CreateSaleReturn: 'إنشاء عائد بيع',
  EditSaleReturn: 'تحرير إرجاع البيع',
  SalesReturn: 'عائد المبيعات',
  CreatePurchaseReturn: 'إنشاء إرجاع الشراء',
  EditPurchaseReturn: 'تحرير إرجاع الشراء',
  PurchasesReturn: 'عائد المشتريات',
  Due: 'دين',
  Profit: 'ربح',
  Revenue: 'دخل',
  Sales_today: 'مبيعات اليوم',
  People: 'اشخاص',
  Successfully_Created: 'تم إنشاؤه بنجاح',
  Successfully_Updated: 'تم التحديث بنجاح',
  Success: 'نجاح',
  Failed: 'باءت بالفشل',
  Warning: 'إنذار',
  Please_fill_the_form_correctly: 'يرجى ملء النموذج بشكل صحيح',
  Field_is_required: 'هذا الحقل مطلوب',
  Choose_Status: 'اختر الحالة',
  Choose_Method: 'اختر الطريقة',
  Choose_Symbology: 'اختر الترميز',
  Choose_Category: 'اختر الفئة',
  Choose_Customer: 'اختر الزبون',
  Choose_Supplier: 'اختر المورد',
  Choose_Unit_Purchase: 'اختر وحدة الشراء',
  Choose_Sub_Category: 'اختر الفئة الفرعية',
  Choose_Brand: 'اختر الماركة',
  Choose_Warehouse: 'اختر المستودع',
  Choose_Unit_Sale: 'اختر وحدة البيع',
  Enter_Product_Cost: 'أدخل تكلفة المنتج',
  Enter_Stock_alert: 'أدخل تنبيه المخزون',
  Choose_Unit_Product: 'اختر وحدة المنتج',
  Enter_Product_Price: 'أدخل سعر المنتج',
  Enter_Name_Product: 'أدخل اسم المنتج',
  Enter_Role_Name: 'أدخل اسم الدور',
  Enter_Role_Description: 'أدخل وصف الدور',
  Enter_name_category: 'أدخل اسم الفئة',
  Enter_Code_category: 'أدخل رمز الفئة',
  Enter_Name_Brand: 'أدخل اسم الماركة',
  Enter_Description_Brand: 'أدخل وصف الماركة ',
  Enter_Code_Currency: 'أدخل رمز العملة',
  Enter_name_Currency: 'أدخل اسم العملة',
  Enter_Symbol_Currency: 'أدخل رمز العملة',
  Enter_Name_Unit: 'أدخل اسم وحدة',
  Enter_ShortName_Unit: 'أدخل اسمًا قصيرًا للوحدة',
  Choose_Base_Unit: 'اختر وحدة القاعدة',
  Choose_Operator: 'اختر عامل التشغيل',
  Enter_Operation_Value: 'أدخل قيمة العملية',
  Enter_Name_Warehouse: 'أدخل اسم المستودع',
  Enter_Phone_Warehouse: 'أدخل هاتف المستودع',
  Enter_Country_Warehouse: 'أدخل بلد المستودع',
  Enter_City_Warehouse: 'أدخل مدينة المستودع',
  Enter_Email_Warehouse: 'أدخل البريد الإلكتروني للمستودع',
  Enter_ZipCode_Warehouse: 'أدخل الرمز البريدي للمستودع',
  Choose_Currency: 'اختر العملة',
  Thank_you_for_your_business: 'شكرا لك على عملك !',
  Cancel: 'إلغاء',
  New_Customer: 'عميل جديد',
  Incorrect_Login: 'تسجيل الدخول غير صحيح',
  Successfully_Logged_In: 'تم تسجيل الدخول بنجاح',
  This_user_not_active: 'هذا المستخدم غير نشط',
  SignIn: 'تسجيل الدخول',
  Create_an_account: 'انشئ حساب',
  Forgot_Password: 'هل نسيت كلمة السر',
  Email_Address: 'بريد الكتروني',
  SignUp: 'اشتراك',
  Already_have_an_account: 'هل لديك حساب ؟',
  Reset_Password: 'إعادة تعيين كلمة المرور',
  Failed_to_authenticate_on_SMTP_server: 'فشل المصادقة على خادم SMTP',
  We_cant_find_a_user_with_that_email_addres: 'لا يمكننا العثور على مستخدم بعنوان البريد الإلكتروني هذا',
  We_have_emailed_your_password_reset_link: 'لقد أرسلنا رابط إعادة تعيين كلمة المرور بالبريد الإلكتروني',
  Please_fill_the_Email_Adress: 'يرجى ملء عنوان البريد الإلكتروني',
  Confirm_password: 'تأكيد كلمة المرور',
  Your_Password_has_been_changed: 'تم تغيير كلمة السر الخاصة بك',
  The_password_confirmation_does_not_match: 'تأكيد كلمة المرور غير متطابق',
  This_password_reset_token_is_invalid: 'رمز إعادة تعيين كلمة المرور هذا غير صالح',
  Warehouse_report: 'تقرير المستودع',
  All_Warehouses: 'جميع المستودعات',
  Expense_List: 'قائمة المصاريف',
  Expenses: 'المصاريف',
  This_Week_Sales_Purchases: 'مبيعات ومشتريات هذا الأسبوع',
  Top_Selling_Products: 'المنتجات الأكثر مبيعًا',
  View_all: 'مشاهدة الكل',
  Payment_Sent_Received: 'الدفع - المرسل والمستلم',
  Error: 'خطأ !',
  you_are_not_authorized: 'آسف! أنك غير مخول.',
  Go_back_to_home: 'العودة الى الصفحة الرئيسية',
  page_not_exist: 'آسف! الصفحة التي تبحث عنها غير موجودة.',
  Filter: 'فلتر',
  Invoice_POS: 'فاتورة نقاط البيع',
  Invoice: 'فاتورة',
  Customer_Info: 'معلومات العميل',
  Company_Info: 'معلومات الشركة',
  Invoice_Info: 'معلومات الفاتورة',
  Order_Summary: 'ملخص الطلب',
  Quote_Info: 'معلومات الاقتباس',
  Del: 'حذف',
  SuppliersPaiementsReport: 'تقرير مدفوعات الموردين',
  Purchase_Info: 'معلومات الشراء',
  Supplier_Info: 'معلومات المورد',
  Return_Info: 'معلومات العودة',
  Expense_Category: 'فئة المصاريف',
  Create_Expense: 'أضف المصاريف',
  Details: 'تفاصيل',
  Discount_Method: 'طريقة الخصم',
  Net_Unit_Cost: 'صافي تكلفة الوحدة',
  Net_Unit_Price: 'صافي سعر الوحدة',
  Edit_Expense: 'تحرير المصاريف',
  All_Brand: 'جميع العلامات التجارية',
  All_Category: 'كل الفئات',
  ListExpenses: 'قائمة المصروفات',
  Create_Permission: 'إنشاء إذن',
  Edit_Permission: 'تحرير إذن',
  Reports_payments_Sales: 'تقارير مدفوعات المبيعات',
  Reports_payments_Purchases: 'تقارير مشتريات المدفوعات',
  Reports_payments_Return_Customers: 'تقارير المدفوعات المرتجعة للعملاء',
  Reports_payments_Return_Suppliers: 'تقارير المدفوعات عودة الموردين',
  Expense_Deleted: 'تم حذف هذه المصاريف',
  Expense_Updated: 'تم تحديث هذه المصاريف',
  Expense_Created: 'تم إنشاء هذه المصاريف',
  DemoVersion: 'لا يمكنك القيام بذلك في النسخة التجريبية',
  Filesize: 'حجم الملف',
  GenerateBackup: 'إنشاء نسخة احتياطية',
  BackupDatabase: 'النسخ الاحتياطية',
  Backup: 'النسخ الاحتياطية',
  OrderStatistics: 'إحصائيات المبيعات',
  AlreadyAdd: 'هذا المنتج مضاف بالفعل',
  AddProductToList: 'الرجاء إضافة المنتج إلى القائمة',
  AddQuantity: 'الرجاء إضافة الكمية للمنتج',
  InvalidData: 'بيانات غير صالحة',
  LowStock: 'الكمية تتجاوز الكمية المتوفرة في المخزون',
  WarehouseIdentical: 'لا يمكن أن يكون المستودعين متطابقين',
  VariantDuplicate: 'هذا المتغير مكرر',
  Paid: 'مدفوعة',
  Unpaid: 'غير مدفوعة',
  IncomeExpenses: 'الدخل مقابل المصروفات',
  dailySalesPurchases: 'المبيعات والمشتريات اليومية',
  ProductsExpired: 'المنتجات منتهية الصلاحية',
  Income: 'الدخل'
}, _defineProperty(_Pos_Settings$Receipt, "Expenses", 'المصروفات'), _defineProperty(_Pos_Settings$Receipt, "Sale", 'المبيعة'), _defineProperty(_Pos_Settings$Receipt, "Actif", 'فعال'), _defineProperty(_Pos_Settings$Receipt, "Inactif", 'غير فعال'), _defineProperty(_Pos_Settings$Receipt, "Phone", 'الهاتف'), _defineProperty(_Pos_Settings$Receipt, "SearchByPhone", 'البحت بالهاتف'), _defineProperty(_Pos_Settings$Receipt, "CustomerName", 'اسم العميل'), _defineProperty(_Pos_Settings$Receipt, "StockManagement", 'إدارة المخزون'), _defineProperty(_Pos_Settings$Receipt, "dashboard", 'لوحة الإستعلام'), _defineProperty(_Pos_Settings$Receipt, "Products", 'منتجات'), _defineProperty(_Pos_Settings$Receipt, "productsList", 'قائمة المنتجات'), _defineProperty(_Pos_Settings$Receipt, "StockTransfers", 'تحويل المخزون'), _defineProperty(_Pos_Settings$Receipt, "Customers", 'الزبائن'), _defineProperty(_Pos_Settings$Receipt, "Suppliers", 'الموردون'), _defineProperty(_Pos_Settings$Receipt, "Quotations", 'عرض الأسعار'), _defineProperty(_Pos_Settings$Receipt, "Sales", 'المبيعات'), _defineProperty(_Pos_Settings$Receipt, "Purchases", 'المشتريات'), _defineProperty(_Pos_Settings$Receipt, "Returns", 'العوائد'), _defineProperty(_Pos_Settings$Receipt, "Settings", 'الإعدادات'), _defineProperty(_Pos_Settings$Receipt, "SystemSettings", 'إعدادات النظام'), _defineProperty(_Pos_Settings$Receipt, "Users", 'المستخدمين'), _defineProperty(_Pos_Settings$Receipt, "GroupPermissions", 'صلاحية المجموعة'), _defineProperty(_Pos_Settings$Receipt, "Currencies", 'العملات'), _defineProperty(_Pos_Settings$Receipt, "ProductTax", 'ضريبة المنتج'), _defineProperty(_Pos_Settings$Receipt, "Categories", 'التصنيفات'), _defineProperty(_Pos_Settings$Receipt, "Warehouses", 'المستودعات'), _defineProperty(_Pos_Settings$Receipt, "Units", 'الوحدات'), _defineProperty(_Pos_Settings$Receipt, "UnitsPrchases", 'وحدات الشراء'), _defineProperty(_Pos_Settings$Receipt, "UnitsSales", 'وحدات البيع'), _defineProperty(_Pos_Settings$Receipt, "Reports", 'التقارير'), _defineProperty(_Pos_Settings$Receipt, "PaymentsReport", 'تقرير المدفوعات'), _defineProperty(_Pos_Settings$Receipt, "PaymentsPurchases", 'مدفوعات المشتريات'), _defineProperty(_Pos_Settings$Receipt, "PaymentsSales", 'مدفوعات المبيعات'), _defineProperty(_Pos_Settings$Receipt, "PaymentsReturns", 'مدفوعات المرتجعات'), _defineProperty(_Pos_Settings$Receipt, "ProfitandLoss", 'الربح والخسارة'), _defineProperty(_Pos_Settings$Receipt, "ProductQuantityAlerts", 'تنبيهات كمية المنتج'), _defineProperty(_Pos_Settings$Receipt, "WarehouseStockChart", 'الرسم البياني لسهم المستودع'), _defineProperty(_Pos_Settings$Receipt, "SalesReport", 'تقرير المبيعات'), _defineProperty(_Pos_Settings$Receipt, "PurchasesReport", 'تقرير المشتريات'), _defineProperty(_Pos_Settings$Receipt, "CustomersReport", 'تقرير العملاء'), _defineProperty(_Pos_Settings$Receipt, "SuppliersReport", 'تقرير الموردين'), _defineProperty(_Pos_Settings$Receipt, "SupplierReport", 'تقرير المورد'), _defineProperty(_Pos_Settings$Receipt, "DailySalesData", 'بيانات المبيعات اليومية'), _defineProperty(_Pos_Settings$Receipt, "DailyPurchasesData", 'بيانات المشتريات اليومية'), _defineProperty(_Pos_Settings$Receipt, "Derni\xE8rescinqrecords", 'السجلات الخمسة الأخيرة'), _defineProperty(_Pos_Settings$Receipt, "Filters", 'البحت'), _defineProperty(_Pos_Settings$Receipt, "date", 'التاريخ'), _defineProperty(_Pos_Settings$Receipt, "Reference", 'المرجع'), _defineProperty(_Pos_Settings$Receipt, "Supplier", 'المورد'), _defineProperty(_Pos_Settings$Receipt, "PaymentStatus", 'حالة الدفع'), _defineProperty(_Pos_Settings$Receipt, "Customer", 'الزبون'), _defineProperty(_Pos_Settings$Receipt, "CustomerCode", 'رمز الزبون'), _defineProperty(_Pos_Settings$Receipt, "Status", 'الحالة'), _defineProperty(_Pos_Settings$Receipt, "SupplierCode", 'رمز المورد'), _defineProperty(_Pos_Settings$Receipt, "ProductManagement", 'إدارة المنتجات'), _defineProperty(_Pos_Settings$Receipt, "CodeProduct", 'رمز المنتج'), _defineProperty(_Pos_Settings$Receipt, "Categorie", 'التصنيف'), _defineProperty(_Pos_Settings$Receipt, "SubCategorie", 'التصنيف الفرعي'), _defineProperty(_Pos_Settings$Receipt, "Name_product", 'إسم المنتج'), _defineProperty(_Pos_Settings$Receipt, "StockAlert", 'تنبيه المخزون'), _defineProperty(_Pos_Settings$Receipt, "warehouse", 'المستودع'), _defineProperty(_Pos_Settings$Receipt, "Tax", 'الضريبة'), _defineProperty(_Pos_Settings$Receipt, "BuyingPrice", 'سعر الشراء'), _defineProperty(_Pos_Settings$Receipt, "SellPrice", 'سعر البيع'), _defineProperty(_Pos_Settings$Receipt, "Quantity", 'كمية'), _defineProperty(_Pos_Settings$Receipt, "Action", 'الإجراءات'), _defineProperty(_Pos_Settings$Receipt, "UnitSale", 'وحدة البيع'), _defineProperty(_Pos_Settings$Receipt, "UnitPurchase", 'وحدة الشراء'), _defineProperty(_Pos_Settings$Receipt, "ProductDetails", 'تفاصيل المنتج'), _defineProperty(_Pos_Settings$Receipt, "All", 'الكل'), _defineProperty(_Pos_Settings$Receipt, "EditProduct", 'تعديل المنتج'), _defineProperty(_Pos_Settings$Receipt, "AddProduct", 'إضافة منتج'), _defineProperty(_Pos_Settings$Receipt, "SearchByCode", 'البحت بالرمز'), _defineProperty(_Pos_Settings$Receipt, "SearchByName", 'البحت بالاسم'), _defineProperty(_Pos_Settings$Receipt, "Edit", 'تعديل'), _defineProperty(_Pos_Settings$Receipt, "Close", 'أغلق'), _defineProperty(_Pos_Settings$Receipt, "PleaseSelect", 'يرجى التحديد'), _defineProperty(_Pos_Settings$Receipt, "CustomerManagement", 'إدارة الزبائن'), _defineProperty(_Pos_Settings$Receipt, "Email", 'البريد '), _defineProperty(_Pos_Settings$Receipt, "EditCustomer", 'تحرير العميل'), _defineProperty(_Pos_Settings$Receipt, "AddCustomer", 'إضافة عميل'), _defineProperty(_Pos_Settings$Receipt, "Country", 'البلد'), _defineProperty(_Pos_Settings$Receipt, "City", 'المدينة'), _defineProperty(_Pos_Settings$Receipt, "Adress", 'العنوان'), _defineProperty(_Pos_Settings$Receipt, "CustomerDetails", 'تفاصيل العميل'), _defineProperty(_Pos_Settings$Receipt, "CustomersList", 'قائمة الزبائن'), _defineProperty(_Pos_Settings$Receipt, "SupplierCode", 'رمز المورد'), _defineProperty(_Pos_Settings$Receipt, "SupplierName", 'اسم المورد'), _defineProperty(_Pos_Settings$Receipt, "SuppliersManagement", 'إدارة الموردين'), _defineProperty(_Pos_Settings$Receipt, "SupplierDetails", 'تفاصيل المورد'), _defineProperty(_Pos_Settings$Receipt, "QuotationsManagement", 'إدارة التسعيرات'), _defineProperty(_Pos_Settings$Receipt, "SubTotal", 'المجموع الكلي'), _defineProperty(_Pos_Settings$Receipt, "complete", 'مكتملة'), _defineProperty(_Pos_Settings$Receipt, "EnAttendant", 'قيد الانتظار'), _defineProperty(_Pos_Settings$Receipt, "Recu", 'تم الاستلام'), _defineProperty(_Pos_Settings$Receipt, "partial", 'جزئي'), _defineProperty(_Pos_Settings$Receipt, "Retournee", 'مسترجعة'), _defineProperty(_Pos_Settings$Receipt, "DetailQuote", 'تفاصيل عرض السعر '), _defineProperty(_Pos_Settings$Receipt, "EditQuote", 'تعديل عرض السعر'), _defineProperty(_Pos_Settings$Receipt, "CreateSale", 'إنشاء مبيعة'), _defineProperty(_Pos_Settings$Receipt, "DownloadPdf", 'تحميل PDF'), _defineProperty(_Pos_Settings$Receipt, "QuoteEmail", 'ارسال عرض السعر بالبريد الالكتروني'), _defineProperty(_Pos_Settings$Receipt, "DeleteQuote", 'حذف عرض السعر'), _defineProperty(_Pos_Settings$Receipt, "AddQuote", 'إضافة عرض سعر'), _defineProperty(_Pos_Settings$Receipt, "SelectProduct", 'حدد المنتج'), _defineProperty(_Pos_Settings$Receipt, "Price", 'السعر'), _defineProperty(_Pos_Settings$Receipt, "CurrentStock", 'المخزون '), _defineProperty(_Pos_Settings$Receipt, "Total", 'مجموع'), _defineProperty(_Pos_Settings$Receipt, "Num", 'رقم'), _defineProperty(_Pos_Settings$Receipt, "Unitcost", 'تكلفة الوحدة'), _defineProperty(_Pos_Settings$Receipt, "to", 'إلى'), _defineProperty(_Pos_Settings$Receipt, "Subject", 'الموضوع'), _defineProperty(_Pos_Settings$Receipt, "Message", 'الرسالة'), _defineProperty(_Pos_Settings$Receipt, "EmailCustomer", 'البريد الإلكتروني للعميل'), _defineProperty(_Pos_Settings$Receipt, "Sent", 'إرسال'), _defineProperty(_Pos_Settings$Receipt, "ProductCodeName", 'المنتج'), _defineProperty(_Pos_Settings$Receipt, "Quote", 'عرض الأسعار'), _defineProperty(_Pos_Settings$Receipt, "Hello", 'أهلا'), _defineProperty(_Pos_Settings$Receipt, "AttachmentQuote", 'يرجى العثور على المرفق لعرض الأسعار الخاص بك'), _defineProperty(_Pos_Settings$Receipt, "AddProducts", 'إضافة منتجات إلى قائمة الطلبات'), _defineProperty(_Pos_Settings$Receipt, "SelectWarehouse", 'الرجاء اختيار المستودع'), _defineProperty(_Pos_Settings$Receipt, "SelectCustomer", 'اختر الزبون'), _defineProperty(_Pos_Settings$Receipt, "SalesManagement", 'إدارة المبيعات'), _defineProperty(_Pos_Settings$Receipt, "Balance", 'الرصيد'), _defineProperty(_Pos_Settings$Receipt, "QtyBack", 'كمية العوائد'), _defineProperty(_Pos_Settings$Receipt, "TotalReturn", 'مجموع العوائد'), _defineProperty(_Pos_Settings$Receipt, "MontantReste", 'المبلغ المتبقي'), _defineProperty(_Pos_Settings$Receipt, "SaleDetail", 'تفاصيل المبيعة'), _defineProperty(_Pos_Settings$Receipt, "EditSale", 'تعديل المبيعة'), _defineProperty(_Pos_Settings$Receipt, "AddSale", 'إضافة مبيعة'), _defineProperty(_Pos_Settings$Receipt, "ShowPayment", 'إظهار المدفوعات'), _defineProperty(_Pos_Settings$Receipt, "AddPayment", 'إضافة الدفع'), _defineProperty(_Pos_Settings$Receipt, "EditPayment", 'تعديل الدفع'), _defineProperty(_Pos_Settings$Receipt, "EmailSale", 'إرسال المبيعة في البريد الإلكتروني'), _defineProperty(_Pos_Settings$Receipt, "DeleteSale", 'حذف المبيعة'), _defineProperty(_Pos_Settings$Receipt, "Amount", 'المبلغ'), _defineProperty(_Pos_Settings$Receipt, "ModePaiement", 'طريقة الدفع'), _defineProperty(_Pos_Settings$Receipt, "Paymentchoice", 'طريقة الدفع'), _defineProperty(_Pos_Settings$Receipt, "Note", 'ملحوظة'), _defineProperty(_Pos_Settings$Receipt, "PaymentComplete", 'اكتمل الدفع'), _defineProperty(_Pos_Settings$Receipt, "UserManagement", 'إدارة المستخدمين'), _defineProperty(_Pos_Settings$Receipt, "Firstname", 'الاسم الأول'), _defineProperty(_Pos_Settings$Receipt, "lastname", 'اسم العائلة'), _defineProperty(_Pos_Settings$Receipt, "username", 'اسم المستخدم'), _defineProperty(_Pos_Settings$Receipt, "type", 'النوع'), _defineProperty(_Pos_Settings$Receipt, "UserPermissions", 'تراخيص المستخدمين'), _defineProperty(_Pos_Settings$Receipt, "RoleName", 'اسم الدور'), _defineProperty(_Pos_Settings$Receipt, "RoleDescription", 'وصف الدور'), _defineProperty(_Pos_Settings$Receipt, "AddPermissions", 'اضافة التراخيص'), _defineProperty(_Pos_Settings$Receipt, "View", 'عرض'), _defineProperty(_Pos_Settings$Receipt, "Add", 'إضافة'), _defineProperty(_Pos_Settings$Receipt, "add", 'إضافة'), _defineProperty(_Pos_Settings$Receipt, "Del", 'حذف'), _defineProperty(_Pos_Settings$Receipt, "NewAdjustement", 'تعديل جديد'), _defineProperty(_Pos_Settings$Receipt, "EditAdjustement", 'تحرير التعديل'), _defineProperty(_Pos_Settings$Receipt, "CannotSubstraction", 'لا يمكنك طرح منتجات لها مخزون 0'), _defineProperty(_Pos_Settings$Receipt, "Addition", 'إضافة'), _defineProperty(_Pos_Settings$Receipt, "Subtraction", 'طرح'), _defineProperty(_Pos_Settings$Receipt, "profil", 'الملف الشخصي'), _defineProperty(_Pos_Settings$Receipt, "logout", 'تسجيل الخروج'), _defineProperty(_Pos_Settings$Receipt, "PurchaseAlreadyPaid", 'لا يمكنك التعديل لأن هذا الشراء  مكتمل الدفع  بالفع'), _defineProperty(_Pos_Settings$Receipt, "SaleAlreadyPaid", 'لا يمكنك التعديل لأن هذه المبيعة  مكتملة الدفع  بالفع'), _defineProperty(_Pos_Settings$Receipt, "ReturnAlreadyPaid", 'لا يمكنك التعديل لأن هذه المرتجعة  مكتملة الدفع  بالفع'), _defineProperty(_Pos_Settings$Receipt, "QuoteAlready", ' هذه التسعيرة أدت بالفعل إلى بيع'), _defineProperty(_Pos_Settings$Receipt, "QuotationComplete", 'هده التسعيرة مكتملة'), _defineProperty(_Pos_Settings$Receipt, "password", 'كلمة المرور'), _defineProperty(_Pos_Settings$Receipt, "Newpassword", 'كلمة المرور جديدة'), _defineProperty(_Pos_Settings$Receipt, "ChangeAvatar", 'تغيير الصورة'), _defineProperty(_Pos_Settings$Receipt, "LeaveBlank", 'يرجى ترك هذا الحقل فارغًا إذا لم تقم بتغييره'), _defineProperty(_Pos_Settings$Receipt, "SiteConfiguration", 'اعدادات عامة'), _defineProperty(_Pos_Settings$Receipt, "Language", 'اللغة'), _defineProperty(_Pos_Settings$Receipt, "DefaultCurrency", 'العملة الرئيسية'), _defineProperty(_Pos_Settings$Receipt, "LoginCaptcha", 'كلمة التحقق'), _defineProperty(_Pos_Settings$Receipt, "DefaultEmail", 'البريد الرئيسي'), _defineProperty(_Pos_Settings$Receipt, "SiteName", 'اسم الموقع'), _defineProperty(_Pos_Settings$Receipt, "ChangeLogo", 'تغيير الشعار'), _defineProperty(_Pos_Settings$Receipt, "SMTPConfiguration", 'اعدادات الارسال'), _defineProperty(_Pos_Settings$Receipt, "HOST", 'مضيف'), _defineProperty(_Pos_Settings$Receipt, "PORT", 'المنفذ'), _defineProperty(_Pos_Settings$Receipt, "encryption", 'التشفير'), _defineProperty(_Pos_Settings$Receipt, "SMTPIncorrect", 'اعدادات الارسال غير صحيحة'), _defineProperty(_Pos_Settings$Receipt, "ReturnsInvoices", 'فواتير المرتجعات'), _defineProperty(_Pos_Settings$Receipt, "ReturnsInvoicesData", 'بيانات فواتير المرتجعات'), _defineProperty(_Pos_Settings$Receipt, "ShowAll", 'إظهار كافة سجلات كافة المستخدمين'), _defineProperty(_Pos_Settings$Receipt, "Discount", 'الخصم'), _defineProperty(_Pos_Settings$Receipt, "OrderTax", 'ضريبة الطلب'), _defineProperty(_Pos_Settings$Receipt, "Shipping", 'الشحن'), _defineProperty(_Pos_Settings$Receipt, "ManagementCurrencies", 'ادارة العملات'), _defineProperty(_Pos_Settings$Receipt, "CurrencyCode", 'شفرة العملة'), _defineProperty(_Pos_Settings$Receipt, "CurrencyName", 'اسم العملة'), _defineProperty(_Pos_Settings$Receipt, "Symbol", 'رمز العملة'), _defineProperty(_Pos_Settings$Receipt, "CompanyName", 'اسم الشركة'), _defineProperty(_Pos_Settings$Receipt, "CompanyPhone", 'هاتف الشركة'), _defineProperty(_Pos_Settings$Receipt, "CompanyAdress", 'عنوان الشركة'), _defineProperty(_Pos_Settings$Receipt, "Code", 'رمز'), _defineProperty(_Pos_Settings$Receipt, "image", 'صورة'), _defineProperty(_Pos_Settings$Receipt, "Printbarcode", 'طباعة الباركود'), _defineProperty(_Pos_Settings$Receipt, "ReturnsCustomers", 'مرتجعات العملاء'), _defineProperty(_Pos_Settings$Receipt, "ReturnsSuppliers", 'مرتجعات الموردين'), _defineProperty(_Pos_Settings$Receipt, "FactureReturnCustomers", 'فواتير مرتجعات العملاء'), _defineProperty(_Pos_Settings$Receipt, "FactureReturnSuppliers", 'فواتير مرتجعات الموردين'), _defineProperty(_Pos_Settings$Receipt, "NodataAvailable", 'لا تتوافر بيانات'), _defineProperty(_Pos_Settings$Receipt, "ProductImage", 'صورة المنتج'), _defineProperty(_Pos_Settings$Receipt, "Barcode", 'الباركود'), _defineProperty(_Pos_Settings$Receipt, "pointofsales", 'نقطة مبيعات'), _defineProperty(_Pos_Settings$Receipt, "CustomUpload", 'تحميل مخصص'), _defineProperty(_Pos_Settings$Receipt, "pointofsaleManagement", 'إدارة نقاط البيع'), _defineProperty(_Pos_Settings$Receipt, "Adjustment", 'تعديل'), _defineProperty(_Pos_Settings$Receipt, "Updat", 'تحديث'), _defineProperty(_Pos_Settings$Receipt, "Reset", 'إعادة تعيين'), _defineProperty(_Pos_Settings$Receipt, "print", 'طباعة'), _defineProperty(_Pos_Settings$Receipt, "SearchByEmail", 'البحث بالبريد الإلكتروني'), _defineProperty(_Pos_Settings$Receipt, "ChooseProduct", 'اختر المنتج'), _defineProperty(_Pos_Settings$Receipt, "Qty", 'الكمية'), _defineProperty(_Pos_Settings$Receipt, "Items", 'العناصر'), _defineProperty(_Pos_Settings$Receipt, "AmountHT", 'المبلغ دون ضريبة'), _defineProperty(_Pos_Settings$Receipt, "AmountTTC", 'المبلغ الإجمالي'), _defineProperty(_Pos_Settings$Receipt, "PleaseSelectSupplier", 'الرجاء تحديد المورد'), _defineProperty(_Pos_Settings$Receipt, "PleaseSelectStatut", 'يرجى تحديد الحالة'), _defineProperty(_Pos_Settings$Receipt, "PayeBy", 'الدفع عن طريق'), _defineProperty(_Pos_Settings$Receipt, "ChooseWarehouse", 'اختر المستودع'), _defineProperty(_Pos_Settings$Receipt, "payNow", 'ادفع الآن'), _defineProperty(_Pos_Settings$Receipt, "ListofCategory", 'قائمة الفئات'), _defineProperty(_Pos_Settings$Receipt, "Description", 'وصف'), _defineProperty(_Pos_Settings$Receipt, "submit", 'تأكيد'), _defineProperty(_Pos_Settings$Receipt, "ProblemCreatingThisInvoice", 'حدثت مشكلة في إنشاء هذه الفاتورة. حاول مرة اخرى'), _defineProperty(_Pos_Settings$Receipt, "ProblemPayment", 'كانت هناك مشكلة في الدفع. حاول مرة اخرى'), _defineProperty(_Pos_Settings$Receipt, "CreateAdjustment", 'إنشاء تعديل'), _defineProperty(_Pos_Settings$Receipt, "Afewwords", '... بضع كلمات عن'), _defineProperty(_Pos_Settings$Receipt, "UserImage", 'صورة المستخدم'), _defineProperty(_Pos_Settings$Receipt, "UpdateProduct", 'تحديث المنتج'), _defineProperty(_Pos_Settings$Receipt, "Brand", 'الماركة'), _defineProperty(_Pos_Settings$Receipt, "BarcodeSymbology", 'ترميز الباركود'), _defineProperty(_Pos_Settings$Receipt, "ProductCost", 'تكلفة المنتج'), _defineProperty(_Pos_Settings$Receipt, "ProductPrice", 'سعر المنتج'), _defineProperty(_Pos_Settings$Receipt, "UnitProduct", 'منتج الوحدة'), _defineProperty(_Pos_Settings$Receipt, "TaxMethod", 'الطريقة الضريبية'), _defineProperty(_Pos_Settings$Receipt, "MultipleImage", 'صور متعددة'), _defineProperty(_Pos_Settings$Receipt, "ProductHasMultiVariants", 'المنتج له متغيرات متعددة'), _defineProperty(_Pos_Settings$Receipt, "ProductHasPromotion", 'المنتج له عرض ترويجي'), _defineProperty(_Pos_Settings$Receipt, "PromotionStart", 'بدء الترويج'), _defineProperty(_Pos_Settings$Receipt, "PromotionEnd", 'نهاية الترويج'), _defineProperty(_Pos_Settings$Receipt, "PromotionPrice", 'سعر الترويج'), _defineProperty(_Pos_Settings$Receipt, "Price", 'السعر'), _defineProperty(_Pos_Settings$Receipt, "Cost", 'كلفة'), _defineProperty(_Pos_Settings$Receipt, "Unit", 'وحدة'), _defineProperty(_Pos_Settings$Receipt, "ProductVariant", 'متغير المنتج'), _defineProperty(_Pos_Settings$Receipt, "Variant", 'متغير'), _defineProperty(_Pos_Settings$Receipt, "UnitPrice", 'سعر الوحدة'), _defineProperty(_Pos_Settings$Receipt, "CreateReturnCustomer", 'إنشاء إرجاع العميل'), _defineProperty(_Pos_Settings$Receipt, "EditReturnCustomer", 'تحرير إرجاع العميل'), _defineProperty(_Pos_Settings$Receipt, "CreateReturnSupplier", 'إنشاء إرجاع المورد'), _defineProperty(_Pos_Settings$Receipt, "Documentation", 'توثيق'), _defineProperty(_Pos_Settings$Receipt, "EditReturnSupplier", 'تحرير إرجاع المورد'), _defineProperty(_Pos_Settings$Receipt, "FromWarehouse", 'من المستودع'), _defineProperty(_Pos_Settings$Receipt, "ToWarehouse", 'إلى المستودع'), _defineProperty(_Pos_Settings$Receipt, "EditTransfer", 'تحرير النقل'), _defineProperty(_Pos_Settings$Receipt, "TransferDetail", 'تفاصيل النقل'), _defineProperty(_Pos_Settings$Receipt, "Pending", 'قيد الانتظار'), _defineProperty(_Pos_Settings$Receipt, "Received", 'تم الاستلام'), _defineProperty(_Pos_Settings$Receipt, "Ordered", 'طلب'), _defineProperty(_Pos_Settings$Receipt, "PermissionsManager", 'مدير الأذونات'), _defineProperty(_Pos_Settings$Receipt, "BrandManager", 'العلامة التجارية'), _defineProperty(_Pos_Settings$Receipt, "BrandImage", 'صورة الماركة'), _defineProperty(_Pos_Settings$Receipt, "BrandName", 'اسم الماركة'), _defineProperty(_Pos_Settings$Receipt, "BrandDescription", 'ةصف الماركة'), _defineProperty(_Pos_Settings$Receipt, "BaseUnit", 'الوحده الأساسيه'), _defineProperty(_Pos_Settings$Receipt, "ManagerUnits", 'إدارة الوحدات'), _defineProperty(_Pos_Settings$Receipt, "OperationValue", 'قيمة العملية'), _defineProperty(_Pos_Settings$Receipt, "Operator", 'عامل'), _defineProperty(_Pos_Settings$Receipt, "Top5Products", 'أفضل 5 منتجات'), _defineProperty(_Pos_Settings$Receipt, "Last5Sales", 'آخر 5 مبيعات'), _defineProperty(_Pos_Settings$Receipt, "ListAdjustments", 'قائمة التعديلات'), _defineProperty(_Pos_Settings$Receipt, "ListTransfers", 'قائمة التحويلات'), _defineProperty(_Pos_Settings$Receipt, "CreateTransfer", 'إنشاء تحويل'), _defineProperty(_Pos_Settings$Receipt, "OrdersManager", 'مدير الطلبات'), _defineProperty(_Pos_Settings$Receipt, "ListQuotations", 'قائمة التسعيرات'), _defineProperty(_Pos_Settings$Receipt, "ListPurchases", 'قائمة المشتريات'), _defineProperty(_Pos_Settings$Receipt, "ListSales", 'قائمة المبيعات'), _defineProperty(_Pos_Settings$Receipt, "ListReturns", 'قائمة المرتجعات'), _defineProperty(_Pos_Settings$Receipt, "PeopleManager", 'إدارة الأفراد'), _defineProperty(_Pos_Settings$Receipt, "ListofBrand", 'قائمة العلامة التجارية'), _defineProperty(_Pos_Settings$Receipt, "Delete", {
  Title: 'هل أنت واثق؟',
  Text: ' !لن تتمكن من التراجع عن هذا',
  confirmButtonText: 'نعم ، احذفه!',
  cancelButtonText: 'إلغاء',
  Deleted: 'تم الحذف!',
  Failed: 'فشل',
  Therewassomethingwronge: 'كان هناك شيء خاطئ',
  CustomerDeleted: 'تم حذف هذا العميل',
  UserDeleted: 'تم حذف هذا المستخدم',
  SupplierDeleted: 'تم حذف هذا العميل المورد',
  QuoteDeleted: 'تم حذف هذه التسعيرة',
  SaleDeleted: 'تم حذف هذا البيع',
  PaymentDeleted: 'تم حذف هذا الدفع',
  PurchaseDeleted: 'تم حذف هذا الشراء',
  ReturnDeleted: 'تم حذف هذه المرتجعة',
  ProductDeleted: 'تم حذف هدا المنتوج',
  ClientError: 'هذا العميل مرتبط بالفعل بعملية أخرى',
  ProviderError: 'هذا المورد مرتبط بالفعل بعملية أخرى',
  UnitDeleted: 'تم حذف هذه الوحدة',
  RoleDeleted: 'تم حذف هدا الدور',
  TaxeDeleted: 'تم حذف هذه الضريبة بنجاح',
  SubCatDeleted: 'تم حذف هذا  التصنيف فرعي بنجاح',
  CatDeleted: 'تم حذف هذا التصنيف  بنجاح',
  WarehouseDeleted: 'تم حذف هذا المخزن  بنجاح',
  AlreadyLinked: 'هذا المنتج مرتبط بالفعل بعملية أخرى',
  AdjustDeleted: 'تم حذف هذا التعديل  بنجاح',
  TitleCurrency: 'تم حذف هذه العملة  بنجاح',
  TitleTransfer: 'تم حذف النقل  بنجاح',
  BackupDeleted: 'تمت إزالة النسخة الاحتياطية بنجاح',
  TitleBrand: 'تم حذف هذه العلامة التجارية'
}), _defineProperty(_Pos_Settings$Receipt, "Update", (_Update = {
  TitleBrand: 'تم تحديث هذه العلامة التجارية',
  TitleSetting: 'تم تحديث الاعدادات بنجاح',
  TitleProfile: 'تم تحديث ملفك الشخصي بنجاح',
  TitleAdjust: 'تم تحديث التعديل بنجاح',
  TitleRole: 'تم تحديث الدور بنجاح',
  TitleUnit: 'تم تحديث الوحدة بنجاح',
  TitleCustomer: 'تم تحديث المستخدم بنجاح'
}, _defineProperty(_Update, "TitleCustomer", 'تم تحديث المستخدم بنجاح'), _defineProperty(_Update, "TitleCustomer", 'تم تحديث العميل بنجاح'), _defineProperty(_Update, "TitleQuote", 'تم تحديث التسعيرة بنجاح'), _defineProperty(_Update, "TitleSale", 'تم تحديث البيع بنجاح'), _defineProperty(_Update, "TitlePayment", 'تم تحديث الدفع بنجاح'), _defineProperty(_Update, "TitlePurchase", 'تم تحديث الشراء بنجاح'), _defineProperty(_Update, "TitleReturn", 'تم تحديث المرتجعة بنجاح'), _defineProperty(_Update, "TitleProduct", 'تم تحديث المنتوج بنجاح'), _defineProperty(_Update, "TitleSupplier", 'تم تحديث المورد بنجاح'), _defineProperty(_Update, "TitleTaxe", 'تم تحديث الضريبة بنجاح'), _defineProperty(_Update, "TitleCat", 'تم تحديث التصنيف بنجاح'), _defineProperty(_Update, "TitleWarhouse", 'تم تحديث المخزن بنجاح'), _defineProperty(_Update, "TitleCurrency", 'تم تحديث هذه العملة  بنجاح'), _defineProperty(_Update, "TitleTransfer", 'تم تحديث النقل  بنجاح'), _Update)), _defineProperty(_Pos_Settings$Receipt, "Create", (_Create = {
  TitleBrand: 'تم إنشاء هذه العلامة التجارية',
  TitleTransfer: 'تم إنشاء النقل بنجاح',
  TitleAdjust: 'تم إنشاء التعديل بنجاح',
  TitleRole: 'تم إنشاء الدور بنجاح',
  TitleUnit: 'تم إنشاء الوحدة بنجاح',
  TitleCustomer: 'تم إنشاء المستخدم بنجاح'
}, _defineProperty(_Create, "TitleCustomer", 'تم إنشاء العميل بنجاح'), _defineProperty(_Create, "TitleQuote", 'تم إنشاء التسعيرة بنجاح'), _defineProperty(_Create, "TitleSale", 'تم إنشاء البيع بنجاح'), _defineProperty(_Create, "TitlePayment", 'تم إنشاء الدفع بنجاح'), _defineProperty(_Create, "TitlePurchase", 'تم إنشاء الشراء بنجاح'), _defineProperty(_Create, "TitleReturn", 'تم إنشاء المرتجعة بنجاح'), _defineProperty(_Create, "TitleProduct", 'تم إنشاء المنتوج بنجاح'), _defineProperty(_Create, "TitleSupplier", 'تم إنشاء المورد بنجاح'), _defineProperty(_Create, "TitleTaxe", 'تم إنشاء الضريبة بنجاح'), _defineProperty(_Create, "TitleCat", 'تم إنشاء التصنيف بنجاح'), _defineProperty(_Create, "TitleWarhouse", 'تم إنشاء المخزن بنجاح'), _defineProperty(_Create, "TitleCurrency", 'تم إنشاء هذه العملة  بنجاح'), _Create)), _defineProperty(_Pos_Settings$Receipt, "Send", {
  TitleEmail: 'تم الارسال بنجاح'
}), _defineProperty(_Pos_Settings$Receipt, "return", {
  TitleSale: 'هذا البيع مرتبط بالفعل بإرجاع'
}), _defineProperty(_Pos_Settings$Receipt, "PurchasesManagement", 'إدارة المشتريات'), _defineProperty(_Pos_Settings$Receipt, "Ordered", 'أمر'), _defineProperty(_Pos_Settings$Receipt, "DeletePurchase", 'حذف الشراء'), _defineProperty(_Pos_Settings$Receipt, "EmailPurchase", 'إرسال الشراء في البريد الإلكتروني'), _defineProperty(_Pos_Settings$Receipt, "EditPurchase", 'تحرير الشراء'), _defineProperty(_Pos_Settings$Receipt, "PurchaseDetail", 'تفاصيل الشراء'), _defineProperty(_Pos_Settings$Receipt, "AddPurchase", 'أضف شراء'), _defineProperty(_Pos_Settings$Receipt, "EmailSupplier", 'البريد الإلكتروني للمورد'), _defineProperty(_Pos_Settings$Receipt, "ReturnManagement", 'إدارة المرتجعات'), _defineProperty(_Pos_Settings$Receipt, "ReturnDetail", 'تفاصيل  المرتجعة'), _defineProperty(_Pos_Settings$Receipt, "EditReturn", 'تحرير المرتجعة'), _defineProperty(_Pos_Settings$Receipt, "AddReturn", 'إضافة مرتجعة'), _defineProperty(_Pos_Settings$Receipt, "EmailReturn", 'إرسال المرتجعة في البريد الإلكتروني'), _defineProperty(_Pos_Settings$Receipt, "DeleteReturn", 'حذف  المرتجعة'), _defineProperty(_Pos_Settings$Receipt, "Retoursurcharge", 'تكلفة إضافية'), _defineProperty(_Pos_Settings$Receipt, "Laivrison", 'التسليم'), _defineProperty(_Pos_Settings$Receipt, "SelectSale", 'حدد المبيعة'), _defineProperty(_Pos_Settings$Receipt, "ZeroPardefault", 'يمكنك حذف العنصر أو تعيين الكمية التي تم إرجاعها إلى الصفر إذا لم يتم إرجاعها'), _defineProperty(_Pos_Settings$Receipt, "Return", 'مرتجعة'), _defineProperty(_Pos_Settings$Receipt, "Purchase", 'شراء'), _defineProperty(_Pos_Settings$Receipt, "PurchaseInvoice", 'مدفوعات المشتريات'), _defineProperty(_Pos_Settings$Receipt, "PurchasesInvoicesData", 'بيانات مدفوعات المشتريات'), _defineProperty(_Pos_Settings$Receipt, "SalesInvoice", 'مدفوعات المبيعات'), _defineProperty(_Pos_Settings$Receipt, "SalesInvoicesData", 'بيانات مدفوعات المبيعات'), _defineProperty(_Pos_Settings$Receipt, "TotalSales", 'إجمالي المبيعات'), _defineProperty(_Pos_Settings$Receipt, "TotalPurchases", 'إجمالي المشتريات'), _defineProperty(_Pos_Settings$Receipt, "TotalReturns", 'إجمالي العائدات'), _defineProperty(_Pos_Settings$Receipt, "PaiementsNet", 'صافي المدفوعات'), _defineProperty(_Pos_Settings$Receipt, "PaiementsSent", 'الدفعات المرسلة'), _defineProperty(_Pos_Settings$Receipt, "PaiementsReceived", 'الدفعات المستلمة'), _defineProperty(_Pos_Settings$Receipt, "Recieved", 'المستلمة'), _defineProperty(_Pos_Settings$Receipt, "Sent", 'المرسلة'), _defineProperty(_Pos_Settings$Receipt, "ProductQuantityAlerts", 'تنبيهات كمية المنتج'), _defineProperty(_Pos_Settings$Receipt, "ProductCode", 'كود المنتج'), _defineProperty(_Pos_Settings$Receipt, "ProductName", 'المنتج'), _defineProperty(_Pos_Settings$Receipt, "AlertQuantity", 'كمية التنبيه'), _defineProperty(_Pos_Settings$Receipt, "WarehouseStockChart", 'مخطط المخزون  المستودعات'), _defineProperty(_Pos_Settings$Receipt, "TotalProducts", 'إجمالي المنتجات'), _defineProperty(_Pos_Settings$Receipt, "TotalQuantity", 'إجمالي الكمية'), _defineProperty(_Pos_Settings$Receipt, "TopCustomers", 'أفضل 5 عملاء'), _defineProperty(_Pos_Settings$Receipt, "TotalAmount", 'المبلغ الإجمالي'), _defineProperty(_Pos_Settings$Receipt, "TotalPaid", 'المبلغ المدفوع'), _defineProperty(_Pos_Settings$Receipt, "CustomerSalesReport", 'تقرير المبيعات '), _defineProperty(_Pos_Settings$Receipt, "CustomerPaiementsReport", ' تقرير المدفوعات '), _defineProperty(_Pos_Settings$Receipt, "CustomerQuotationsReport", 'تقرير عروض أسعار '), _defineProperty(_Pos_Settings$Receipt, "Payments", 'المدفوعات'), _defineProperty(_Pos_Settings$Receipt, "TopSuppliers", 'أفضل 5 الموردين'), _defineProperty(_Pos_Settings$Receipt, "SupplierPurchasesReport", 'تقرير المشتريات '), _defineProperty(_Pos_Settings$Receipt, "SupplierPaiementsReport", 'تقرير المدفوعات '), _defineProperty(_Pos_Settings$Receipt, "Name", 'اسم'), _defineProperty(_Pos_Settings$Receipt, "Code", 'الكود'), _defineProperty(_Pos_Settings$Receipt, "ManagementWarehouse", 'إدارة المستودعات'), _defineProperty(_Pos_Settings$Receipt, "ZipCode", 'الرمز البريدي'), _defineProperty(_Pos_Settings$Receipt, "managementCategories", 'إدارة التصنيفات'), _defineProperty(_Pos_Settings$Receipt, "Codecategorie", 'رمز الفئة'), _defineProperty(_Pos_Settings$Receipt, "Namecategorie", 'اسم الفئة'), _defineProperty(_Pos_Settings$Receipt, "Parentcategorie", 'اصل الفئة'), _defineProperty(_Pos_Settings$Receipt, "managementTax", 'إدارة الضرائب'), _defineProperty(_Pos_Settings$Receipt, "TaxName", 'اسم الضريبة'), _defineProperty(_Pos_Settings$Receipt, "TaxRate", 'معدل الضريبة'), _defineProperty(_Pos_Settings$Receipt, "managementUnitPurchases", 'إدارة وحدة المشتريات'), _defineProperty(_Pos_Settings$Receipt, "managementUnitSales", 'إدارة وحدة المبيعات'), _defineProperty(_Pos_Settings$Receipt, "ShortName", 'اسم قصير'), _defineProperty(_Pos_Settings$Receipt, "PleaseSelectThesebeforeaddinganyproduct", 'يرجى تحديد هذه قبل إضافة أي منتج'), _defineProperty(_Pos_Settings$Receipt, "StockAdjustement", 'تعديل المخزون'), _defineProperty(_Pos_Settings$Receipt, "PleaseSelectWarehouse", 'يرجى تحديد المستودع قبل اختيار أي منتج'), _defineProperty(_Pos_Settings$Receipt, "StockTransfer", 'تحويل المخزون'), _defineProperty(_Pos_Settings$Receipt, "Today", 'اليوم'), _defineProperty(_Pos_Settings$Receipt, "SelectPeriod", 'حدد الفترة'), _defineProperty(_Pos_Settings$Receipt, "ThisToday", 'هذا اليوم'), _defineProperty(_Pos_Settings$Receipt, "ThisYear", 'هذا العام'), _defineProperty(_Pos_Settings$Receipt, "ThisMonth", 'هذا الشهر'), _defineProperty(_Pos_Settings$Receipt, "ThisWeek", 'هذا الاسبوع'), _defineProperty(_Pos_Settings$Receipt, "AdjustmentDetail", 'تفاصيل التعديل'), _defineProperty(_Pos_Settings$Receipt, "ActivateUser", 'تم تنشيط هذا المستخدم'), _defineProperty(_Pos_Settings$Receipt, "DisActivateUser", 'تم إلغاء تنشيط هذا المستخدم'), _defineProperty(_Pos_Settings$Receipt, "NotFound", 'الصفحة غير موجودة.'), _defineProperty(_Pos_Settings$Receipt, "oops", 'خطأ! الصفحة غير موجودة.'), _defineProperty(_Pos_Settings$Receipt, "couldNotFind", 'لم نتمكن من العثور على الصفحة التي تبحث عنها ، وفي الوقت نفسه ، يمكنك ذلك'), _defineProperty(_Pos_Settings$Receipt, "ReturnDashboard", 'العودة إلى لوحة القيادة'), _defineProperty(_Pos_Settings$Receipt, "hrm", 'إدارة الموارد البشرية'), _defineProperty(_Pos_Settings$Receipt, "Employees", 'الموظفين'), _defineProperty(_Pos_Settings$Receipt, "Attendance", 'الحضور'), _defineProperty(_Pos_Settings$Receipt, "Leave_request", 'طلب إجازة'), _defineProperty(_Pos_Settings$Receipt, "Leave_type", 'نوع الإجازة'), _defineProperty(_Pos_Settings$Receipt, "Company", 'الشركة'), _defineProperty(_Pos_Settings$Receipt, "Departments", 'الإدارات'), _defineProperty(_Pos_Settings$Receipt, "Designations", 'التعيينات'), _defineProperty(_Pos_Settings$Receipt, "Office_Shift", 'مكتب التحول'), _defineProperty(_Pos_Settings$Receipt, "Holidays", 'العطل'), _defineProperty(_Pos_Settings$Receipt, "Enter_Company_Name", 'ادخل اسم الشركة'), _defineProperty(_Pos_Settings$Receipt, "Enter_email_address", 'أدخل عنوان البريد الالكتروني'), _defineProperty(_Pos_Settings$Receipt, "Enter_Company_Phone", 'أدخل رقم هاتف الشركة'), _defineProperty(_Pos_Settings$Receipt, "Enter_Company_Country", 'أدخل بلد الشركة'), _defineProperty(_Pos_Settings$Receipt, "Created_in_successfully", 'تم إنشاؤه بنجاح'), _defineProperty(_Pos_Settings$Receipt, "Updated_in_successfully", 'تم التحديث بنجاح'), _defineProperty(_Pos_Settings$Receipt, "Deleted_in_successfully", 'تم الحذف بنجاح'), _defineProperty(_Pos_Settings$Receipt, "department", 'إدارة'), _defineProperty(_Pos_Settings$Receipt, "Enter_Department_Name", 'أدخل اسم الإدارة'), _defineProperty(_Pos_Settings$Receipt, "Choose_Company", 'اختر الشركة'), _defineProperty(_Pos_Settings$Receipt, "Department_Head", 'رئيس القسم'), _defineProperty(_Pos_Settings$Receipt, "Choose_Department_Head", 'اختر رئيس القسم'), _defineProperty(_Pos_Settings$Receipt, "Enter_Shift_name", 'أدخل اسم التحول'), _defineProperty(_Pos_Settings$Receipt, "Monday_In", 'الاثنين من'), _defineProperty(_Pos_Settings$Receipt, "Monday_Out", 'الاثنين الى'), _defineProperty(_Pos_Settings$Receipt, "Tuesday_In", 'الثلاثاء من'), _defineProperty(_Pos_Settings$Receipt, "tuesday_out", 'الثلاثاء الى'), _defineProperty(_Pos_Settings$Receipt, "wednesday_in", 'الأربعاء من'), _defineProperty(_Pos_Settings$Receipt, "wednesday_out", 'الأربعاء الى'), _defineProperty(_Pos_Settings$Receipt, "thursday_in", 'الخميس الى'), _defineProperty(_Pos_Settings$Receipt, "thursday_out", 'الخميس الى'), _defineProperty(_Pos_Settings$Receipt, "friday_in", 'الجمعة من'), _defineProperty(_Pos_Settings$Receipt, "friday_out", 'الجمعة الى'), _defineProperty(_Pos_Settings$Receipt, "saturday_in", 'السبت من'), _defineProperty(_Pos_Settings$Receipt, "saturday_out", 'السبت الى'), _defineProperty(_Pos_Settings$Receipt, "sunday_in", 'الأحد من'), _defineProperty(_Pos_Settings$Receipt, "sunday_out", 'الأحد الى'), _defineProperty(_Pos_Settings$Receipt, "Holiday", 'الاجازة'), _defineProperty(_Pos_Settings$Receipt, "Enter_title", 'أدخل العنوان'), _defineProperty(_Pos_Settings$Receipt, "title", 'العنوان'), _defineProperty(_Pos_Settings$Receipt, "start_date", 'تاريخ البداية'), _defineProperty(_Pos_Settings$Receipt, "Enter_Start_date", 'أدخل تاريخ البدء'), _defineProperty(_Pos_Settings$Receipt, "Finish_Date", 'تاريخ الانتهاء'), _defineProperty(_Pos_Settings$Receipt, "Enter_Finish_date", 'أدخل تاريخ الانتهاء'), _defineProperty(_Pos_Settings$Receipt, "Please_provide_any_details", 'يرجى تقديم أي تفاصيل'), _defineProperty(_Pos_Settings$Receipt, "Attendances", 'الحضور'), _defineProperty(_Pos_Settings$Receipt, "Enter_Attendance_date", 'أدخل تاريخ الحضور'), _defineProperty(_Pos_Settings$Receipt, "Time_In", 'وقت الدخول'), _defineProperty(_Pos_Settings$Receipt, "Time_Out", 'وقت الخروج'), _defineProperty(_Pos_Settings$Receipt, "Choose_Employee", 'اختر الموظف'), _defineProperty(_Pos_Settings$Receipt, "Employee", 'الموظف'), _defineProperty(_Pos_Settings$Receipt, "Work_Duration", 'مدة العمل'), _defineProperty(_Pos_Settings$Receipt, "remaining_leaves_are_insufficient", 'الإجازات المتبقية غير كافية'), _defineProperty(_Pos_Settings$Receipt, "Leave_Type", 'نوع الإجازة'), _defineProperty(_Pos_Settings$Receipt, "Days", 'الأيام'), _defineProperty(_Pos_Settings$Receipt, "Department", 'إدارة'), _defineProperty(_Pos_Settings$Receipt, "Choose_leave_type", 'اختر نوع الإجازة'), _defineProperty(_Pos_Settings$Receipt, "Choose_status", 'اختر الحالة'), _defineProperty(_Pos_Settings$Receipt, "Leave_Reason", 'سبب الإجازة'), _defineProperty(_Pos_Settings$Receipt, "Enter_Reason_Leave", 'أدخل سبب الإجازة'), _defineProperty(_Pos_Settings$Receipt, "Add_Employee", 'اضافة موظف'), _defineProperty(_Pos_Settings$Receipt, "FirstName", 'الاسم الأول'), _defineProperty(_Pos_Settings$Receipt, "Enter_FirstName", 'أدخل الاسم الأول'), _defineProperty(_Pos_Settings$Receipt, "LastName", 'الاسم الاخير'), _defineProperty(_Pos_Settings$Receipt, "Enter_LastName", 'أدخل الاسم الأخير'), _defineProperty(_Pos_Settings$Receipt, "Gender", 'الجنس'), _defineProperty(_Pos_Settings$Receipt, "Choose_Gender", 'اختر الجنس'), _defineProperty(_Pos_Settings$Receipt, "Enter_Birth_date", 'أدخل تاريخ الميلاد'), _defineProperty(_Pos_Settings$Receipt, "Birth_date", 'تاريخ الولادة'), _defineProperty(_Pos_Settings$Receipt, "Enter_Country", 'أدخل الدولة'), _defineProperty(_Pos_Settings$Receipt, "Enter_Phone_Number", 'أدخل رقم الهاتف'), _defineProperty(_Pos_Settings$Receipt, "joining_date", 'تاريخ الانضمام'), _defineProperty(_Pos_Settings$Receipt, "Enter_joining_date", 'أدخل تاريخ الانضمام'), _defineProperty(_Pos_Settings$Receipt, "Choose_Designation", 'اختر التعيين'), _defineProperty(_Pos_Settings$Receipt, "Designation", 'التعيين'), _defineProperty(_Pos_Settings$Receipt, "Office_Shift", 'مكتب التحول'), _defineProperty(_Pos_Settings$Receipt, "Choose_Office_Shift", 'اختر مكتب التحول'), _defineProperty(_Pos_Settings$Receipt, "Enter_Leaving_Date", 'أدخل تاريخ المغادرة'), _defineProperty(_Pos_Settings$Receipt, "Leaving_Date", 'تاريخ المغادرة'), _defineProperty(_Pos_Settings$Receipt, "Annual_Leave", 'الإجازة السنوية'), _defineProperty(_Pos_Settings$Receipt, "Enter_Annual_Leave", 'أدخل الإجازة السنوية'), _defineProperty(_Pos_Settings$Receipt, "Remaining_leave", 'الاجازة المتبقية'), _defineProperty(_Pos_Settings$Receipt, "Employee_Details", 'تفاصيل الموظف'), _defineProperty(_Pos_Settings$Receipt, "Basic_Information", 'معلومات اساسية'), _defineProperty(_Pos_Settings$Receipt, "Family_status", 'الوضع العائلي'), _defineProperty(_Pos_Settings$Receipt, "Choose_Family_status", 'اختر الحالة العائلية'), _defineProperty(_Pos_Settings$Receipt, "Employment_type", 'نوع الوظيفة'), _defineProperty(_Pos_Settings$Receipt, "Select_Employment_type", 'حدد نوع التوظيف'), _defineProperty(_Pos_Settings$Receipt, "Enter_City", 'أدخل المدينة'), _defineProperty(_Pos_Settings$Receipt, "Province", 'مقاطعة'), _defineProperty(_Pos_Settings$Receipt, "Enter_Province", 'أدخل المقاطعة'), _defineProperty(_Pos_Settings$Receipt, "Enter_Address", 'أدخل العنوان'), _defineProperty(_Pos_Settings$Receipt, "Enter_Zip_code", 'أدخل الرمز البريدي'), _defineProperty(_Pos_Settings$Receipt, "Zip_code", 'الرمز البريدي'), _defineProperty(_Pos_Settings$Receipt, "Hourly_rate", 'السعر بالساعة'), _defineProperty(_Pos_Settings$Receipt, "Enter_Hourly_rate", 'أدخل سعر الساعة'), _defineProperty(_Pos_Settings$Receipt, "Basic_salary", 'الراتب الاساسي'), _defineProperty(_Pos_Settings$Receipt, "Enter_Basic_salary", 'أدخل الراتب الأساسي'), _defineProperty(_Pos_Settings$Receipt, "Social_Media", 'وسائل التواصل الاجتماعي'), _defineProperty(_Pos_Settings$Receipt, "Skype", 'سكايب'), _defineProperty(_Pos_Settings$Receipt, "Enter_Skype", 'أدخل سكايب'), _defineProperty(_Pos_Settings$Receipt, "Facebook", 'فيسبوك'), _defineProperty(_Pos_Settings$Receipt, "Enter_Facebook", 'أدخل الفيسبوك'), _defineProperty(_Pos_Settings$Receipt, "WhatsApp", 'واتس اب'), _defineProperty(_Pos_Settings$Receipt, "Enter_WhatsApp", 'أدخل واتسآب'), _defineProperty(_Pos_Settings$Receipt, "LinkedIn", 'لينكد إن'), _defineProperty(_Pos_Settings$Receipt, "Enter_LinkedIn", 'أدخل لينكد إن'), _defineProperty(_Pos_Settings$Receipt, "Twitter", 'تويتر'), _defineProperty(_Pos_Settings$Receipt, "Enter_Twitter", 'أدخل تويتر'), _defineProperty(_Pos_Settings$Receipt, "Experiences", 'الخبرات'), _defineProperty(_Pos_Settings$Receipt, "bank_account", 'حساب البنك'), _defineProperty(_Pos_Settings$Receipt, "Company_Name", 'اسم الشركة'), _defineProperty(_Pos_Settings$Receipt, "Location", 'الموقع'), _defineProperty(_Pos_Settings$Receipt, "Enter_location", 'أدخل الموقع'), _defineProperty(_Pos_Settings$Receipt, "Enter_Description", 'أدخل الوصف'), _defineProperty(_Pos_Settings$Receipt, "Bank_Name", 'اسم البنك'), _defineProperty(_Pos_Settings$Receipt, "Enter_Bank_Name", 'أدخل اسم البنك'), _defineProperty(_Pos_Settings$Receipt, "Bank_Branch", 'فرع البنك'), _defineProperty(_Pos_Settings$Receipt, "Enter_Bank_Branch", 'أدخل فرع البنك'), _defineProperty(_Pos_Settings$Receipt, "Bank_Number", 'رقم البنك'), _defineProperty(_Pos_Settings$Receipt, "Enter_Bank_Number", 'أدخل رقم البنك'), _defineProperty(_Pos_Settings$Receipt, "Assigned_warehouses", 'المخازن المخصصة'), _defineProperty(_Pos_Settings$Receipt, "Top_customers", 'أفضل العملاء'), _defineProperty(_Pos_Settings$Receipt, "Attachment", 'المرفق'), _defineProperty(_Pos_Settings$Receipt, "view_employee", 'مشاهدة الموظفين'), _defineProperty(_Pos_Settings$Receipt, "edit_employee", 'تحرير الموظفين'), _defineProperty(_Pos_Settings$Receipt, "delete_employee", 'حذف الموظفين'), _defineProperty(_Pos_Settings$Receipt, "Created_by", 'تمت الإضافة بواسطة'), _defineProperty(_Pos_Settings$Receipt, "Add_product_IMEI_Serial_number", 'أضف الرقم التسلسلي للمنتج'), _defineProperty(_Pos_Settings$Receipt, "Product_Has_Imei_Serial_number", 'المنتج له رقم تسلسلي'), _defineProperty(_Pos_Settings$Receipt, "IMEI_SN", 'الرقم التسلسلي'), _defineProperty(_Pos_Settings$Receipt, "Shipments", 'الشحنات'), _defineProperty(_Pos_Settings$Receipt, "delivered_to", 'سلمت إلى'), _defineProperty(_Pos_Settings$Receipt, "shipment_ref", 'مرجع الشحنة'), _defineProperty(_Pos_Settings$Receipt, "sale_ref", 'المرجع للبيع'), _defineProperty(_Pos_Settings$Receipt, "Edit_Shipping", 'تحرير الشحن'), _defineProperty(_Pos_Settings$Receipt, "Packed", 'معبأة'), _defineProperty(_Pos_Settings$Receipt, "Shipped", 'تم الشحن'), _defineProperty(_Pos_Settings$Receipt, "Delivered", 'تم التوصيل'), _defineProperty(_Pos_Settings$Receipt, "Cancelled", 'ألغيت'), _defineProperty(_Pos_Settings$Receipt, "Shipping_status", 'حالة الشحن'), _defineProperty(_Pos_Settings$Receipt, "Users_Report", 'تقرير المستخدمين'), _defineProperty(_Pos_Settings$Receipt, "stock_report", 'تقرير المخزون'), _defineProperty(_Pos_Settings$Receipt, "TotalPurchases", 'إجمالي المشتريات'), _defineProperty(_Pos_Settings$Receipt, "Total_quotations", 'إجمالي عروض الأسعار'), _defineProperty(_Pos_Settings$Receipt, "Total_return_sales", 'إجمالي عوائد المبيعات'), _defineProperty(_Pos_Settings$Receipt, "Total_return_purchases", 'إجمالي عوائد المشتريات'), _defineProperty(_Pos_Settings$Receipt, "Total_transfers", 'إجمالي التحويلات'), _defineProperty(_Pos_Settings$Receipt, "Total_adjustments", 'إجمالي التعديلات'), _defineProperty(_Pos_Settings$Receipt, "User_report", 'تقرير المستخدم'), _defineProperty(_Pos_Settings$Receipt, "Current_stock", 'المخزون الحالي'), _defineProperty(_Pos_Settings$Receipt, "product_name", 'اسم المنتج'), _defineProperty(_Pos_Settings$Receipt, "Total_Customers_Due", 'إجمالي الديون'), _defineProperty(_Pos_Settings$Receipt, "Total_Suppliers_Due", 'إجمالي الديون'), _defineProperty(_Pos_Settings$Receipt, "Some_warehouses", 'بعض المستودعات'), _defineProperty(_Pos_Settings$Receipt, "All_Warehouses", 'جميع المستودعات'), _defineProperty(_Pos_Settings$Receipt, "Product_Cost", 'تكلفة المنتج'), _defineProperty(_Pos_Settings$Receipt, "sms_settings", 'إعدادات الرسائل القصيرة'), _defineProperty(_Pos_Settings$Receipt, "pos_settings", 'إعدادات نقاط البيع'), _defineProperty(_Pos_Settings$Receipt, "payment_gateway", 'بوابة الدفع'), _defineProperty(_Pos_Settings$Receipt, "mail_settings", 'إعدادات البريد'), _defineProperty(_Pos_Settings$Receipt, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Pos_Settings$Receipt, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Pos_Settings$Receipt, "Default_SMS_Gateway", 'بوابة الرسائل القصيرة الافتراضية'), _defineProperty(_Pos_Settings$Receipt, "module_settings", 'إعدادات الوحدة'), _defineProperty(_Pos_Settings$Receipt, "Module_enabled_success", 'تم تفعيل الوحدة بنجاح'), _defineProperty(_Pos_Settings$Receipt, "Module_Disabled_success", 'تم تعطيل الوحدة النمطية بنجاح'), _defineProperty(_Pos_Settings$Receipt, "update_settings", 'إعدادات التحديث'), _defineProperty(_Pos_Settings$Receipt, "Please_Upload_the_Correct_Module", 'يرجى تحميل الوحدة الصحيحة'), _defineProperty(_Pos_Settings$Receipt, "Uploaded_Success", 'تم الرفع بنجاح'), _defineProperty(_Pos_Settings$Receipt, "Customer_details", 'تفاصيل العميل'), _defineProperty(_Pos_Settings$Receipt, "Edit_Customer", 'تحرير العميل'), _defineProperty(_Pos_Settings$Receipt, "Delete_Customer", 'حذف العميل'), _defineProperty(_Pos_Settings$Receipt, "Pay_Due", 'الدفع المستحق'), _defineProperty(_Pos_Settings$Receipt, "Paying_amount_is_greater_than_Total_Due", 'مبلغ الدفع أكبر من إجمالي المبلغ المستحق'), _defineProperty(_Pos_Settings$Receipt, "Customer_Invoice", 'فاتورة العميل'), _defineProperty(_Pos_Settings$Receipt, "This_Product_Not_For_Selling", 'هذا المنتج ليس للبيع'), _defineProperty(_Pos_Settings$Receipt, "Welcome_to_your_Dashboard", 'مرحبًا بك في لوحة التحكم'), _defineProperty(_Pos_Settings$Receipt, "Total_Payable", 'إجمالي الدفع'), _defineProperty(_Pos_Settings$Receipt, "Choose_Sale_Ref", 'اختر مرجع البيع'), _defineProperty(_Pos_Settings$Receipt, "Please_Select_Sale", 'يرجى تحديد البيع'), _defineProperty(_Pos_Settings$Receipt, "Sale_Ref", 'مرجع البيع'), _defineProperty(_Pos_Settings$Receipt, "list_product_returns", 'قائمة المنتجات المرتجعة'), _defineProperty(_Pos_Settings$Receipt, "Qty_return", 'إرجاع الكمية'), _defineProperty(_Pos_Settings$Receipt, "Choose_Purchase_Ref", 'اختر مرجع الشراء'), _defineProperty(_Pos_Settings$Receipt, "Purchase_Ref", 'مرجع الشراء'), _defineProperty(_Pos_Settings$Receipt, "please_select_purchase", 'يرجى تحديد شراء'), _defineProperty(_Pos_Settings$Receipt, "qty_return_is_greater_than_qty_purchased", 'الكمية المرتجعة أكبر من الكمية المشتراة'), _defineProperty(_Pos_Settings$Receipt, "qty_return_is_greater_than_qty_sold", 'الكمية المرتجعة أكبر من الكمية المباعة'), _defineProperty(_Pos_Settings$Receipt, "Quantity_sold", 'الكمية المباعة'), _defineProperty(_Pos_Settings$Receipt, "qty_purchased", 'الكمية المشتراة'), _defineProperty(_Pos_Settings$Receipt, "Sender_Name", 'اسم المرسل'), _defineProperty(_Pos_Settings$Receipt, "Upload_Module", 'تحميل الوحدة'), _defineProperty(_Pos_Settings$Receipt, "The_module_must_be_uploaded_as_zip_file", 'يجب تحميل الوحدة كملف مضغوط'), _defineProperty(_Pos_Settings$Receipt, "Upload_Module", 'تحميل الوحدة'), _defineProperty(_Pos_Settings$Receipt, "All_Modules_Installed", 'جميع الوحدات المثبتة'), _defineProperty(_Pos_Settings$Receipt, "Current_Version", 'النسخة الحالية'), _defineProperty(_Pos_Settings$Receipt, "You_already_have_the_latest_version", 'لديك بالفعل أحدث إصدار'), _defineProperty(_Pos_Settings$Receipt, "Update_Available", 'التحديث متاح'), _defineProperty(_Pos_Settings$Receipt, "Update_Log", 'سجل التحديث'), _defineProperty(_Pos_Settings$Receipt, "Update_Now", 'تحديث الان'), _defineProperty(_Pos_Settings$Receipt, "View_Change_Log", 'مشاهدة سجل التغيير'), _defineProperty(_Pos_Settings$Receipt, "invoice_footer", 'تذييل الفاتورة'), _defineProperty(_Pos_Settings$Receipt, "Please_Wait_for_the_update", 'ملاحظة: يرجى انتظار انتهاء التحديث تمامًا. لا يوصى بإغلاق المتصفح أو إيقاف عملية الترقية'), _defineProperty(_Pos_Settings$Receipt, "Note_update", 'ملاحظة: تأكد من الاحتفاظ بنسخة احتياطية من الإصدار الحالي وقاعدة البيانات قبل تشغيل الترقية ، لاستعادتها إذا كان هناك خطأ'), _defineProperty(_Pos_Settings$Receipt, "Time_Zone", 'المنطقة الزمنية'), _defineProperty(_Pos_Settings$Receipt, "Payment_note", 'ملاحظات الدفع'), _defineProperty(_Pos_Settings$Receipt, "sale_note", 'ملاحظات البيع'), _defineProperty(_Pos_Settings$Receipt, "Total_Sale_Due", 'إجمالي ديون البيع'), _defineProperty(_Pos_Settings$Receipt, "Total_Sell_Return_Due", 'إجمالي الديون عائد البيع'), _defineProperty(_Pos_Settings$Receipt, "pay_all_sell_due_at_a_time", 'دفع جميع ديون البيع في وقت واحد'), _defineProperty(_Pos_Settings$Receipt, "pay_all_sell_return_due_at_a_time", 'دفع جميع ديون عائد البيع في وقت واحد'), _defineProperty(_Pos_Settings$Receipt, "Gross_Profit", 'اجمالي الربح'), _defineProperty(_Pos_Settings$Receipt, "pay_all_purchase_due_at_a_time", 'دفع جميع ديون الشراء في وقت واحد'), _defineProperty(_Pos_Settings$Receipt, "Delete_Provider", 'حذف المورد'), _defineProperty(_Pos_Settings$Receipt, "Edit_Provider", 'تحرير المورد'), _defineProperty(_Pos_Settings$Receipt, "Provider_details", 'تفاصيل المورد'), _defineProperty(_Pos_Settings$Receipt, "Total_Purchase_Due", 'إجمالي ديون الشراء'), _defineProperty(_Pos_Settings$Receipt, "Provider_Credit_Note", 'إشعار ائتمان المورد'), _defineProperty(_Pos_Settings$Receipt, "Customer_Credit_Note", 'إشعار ائتمان العميل'), _defineProperty(_Pos_Settings$Receipt, "Sell_Return", 'عائد بيع'), _defineProperty(_Pos_Settings$Receipt, "Purchase_Return", 'إرجاع الشراء'), _defineProperty(_Pos_Settings$Receipt, "Tax_Number", 'الرقم الضريبي'), _defineProperty(_Pos_Settings$Receipt, "Please_add_return_quantity", 'الرجاء إضافة الكمية المرتجعة'), _defineProperty(_Pos_Settings$Receipt, "Return_exist_for_the_Transaction", 'العودة موجودة في هذه الصفقة'), _defineProperty(_Pos_Settings$Receipt, "qty_return_is_greater_than_Quantity_Remaining", 'الكمية المرتجعة أكبر من الكمية المتبقية'), _defineProperty(_Pos_Settings$Receipt, "products_refunded_alert", 'لن يتم رد أي منتجات ذات كمية محددة على 0'), _defineProperty(_Pos_Settings$Receipt, "pay_all_purchase_return_due_at_a_time", 'دفع جميع ديون عوائد الشراء في وقت واحد'), _defineProperty(_Pos_Settings$Receipt, "Total_Purchase_Return_Due", 'إجمالي ديون عوائد الشراء'), _defineProperty(_Pos_Settings$Receipt, "Purchase_return_due", 'ديون عوائد الشراء'), _defineProperty(_Pos_Settings$Receipt, "Sell_return_due", 'ديون عوائد البيع'), _defineProperty(_Pos_Settings$Receipt, "product_report", 'تقرير المنتجات'), _defineProperty(_Pos_Settings$Receipt, "product_sales_report", 'تقرير مبيعات المنتج'), _defineProperty(_Pos_Settings$Receipt, "Product_purchases_report", 'تقرير مشتريات المنتج'), _defineProperty(_Pos_Settings$Receipt, "Qty_sold", 'الكمية المباعة'), _defineProperty(_Pos_Settings$Receipt, "Qty_purchased", 'الكمية المشتراة'), _defineProperty(_Pos_Settings$Receipt, "Filter_by_warehouse", 'تصفية بالمستودع'), _defineProperty(_Pos_Settings$Receipt, "Enable_Print_Invoice", 'قم بتمكين طباعة الفاتورة تلقائيًا'), _defineProperty(_Pos_Settings$Receipt, "Show_Warehouse", 'عرض المستودع'), _defineProperty(_Pos_Settings$Receipt, "credit_card_info", 'معلومات بطاقة الائتمان'), _defineProperty(_Pos_Settings$Receipt, "Saved_Credit_Card_Info", 'معلومات بطاقة الائتمان المحفوظة'), _defineProperty(_Pos_Settings$Receipt, "Credit_card_changed_successfully", 'تم تغيير بطاقة الائتمان بنجاح'), _defineProperty(_Pos_Settings$Receipt, "notification_template", 'قالب الإشعارات'), _defineProperty(_Pos_Settings$Receipt, "email_notification", 'إشعار بالبريد الإلكتروني'), _defineProperty(_Pos_Settings$Receipt, "sms_notification", 'إشعار بالرسائل القصيرة (SMS)'), _defineProperty(_Pos_Settings$Receipt, "Change_product_details", 'تغيير تفاصيل المنتج'), _defineProperty(_Pos_Settings$Receipt, "edit_tax_and_discount_and_shipping", 'تحرير الضرائب والخصومات والشحن'), _defineProperty(_Pos_Settings$Receipt, "Create_Quotation_with_Stock", 'إنشاء عرض أسعار مع الأسهم'), _defineProperty(_Pos_Settings$Receipt, "Variant_Name", 'اسم المتغير'), _defineProperty(_Pos_Settings$Receipt, "Variant_cost", 'تكلفة المتغير'), _defineProperty(_Pos_Settings$Receipt, "Variant_price", 'سعر المتغير'), _defineProperty(_Pos_Settings$Receipt, "Variant_code", 'رمز المتغير'), _defineProperty(_Pos_Settings$Receipt, "Please_wait_until_the_product_is_loaded", 'يرجى الانتظار حتى يتم تحميل المنتج'), _defineProperty(_Pos_Settings$Receipt, "Choose_SMS_Gateway", 'اختر بوابة SMS'), _defineProperty(_Pos_Settings$Receipt, "Notification_Client", 'إشعار العميل'), _defineProperty(_Pos_Settings$Receipt, "Available_Tags", 'العلامات المتاحة'), _defineProperty(_Pos_Settings$Receipt, "Email_Subject", 'عنوان البريد الإلكتروني'), _defineProperty(_Pos_Settings$Receipt, "Email_body", 'محتوى البريد الإلكتروني'), _defineProperty(_Pos_Settings$Receipt, "Notification_Supplier", 'إشعار المورد'), _defineProperty(_Pos_Settings$Receipt, "sms_body", 'محتوى الرسالة القصيرة (SMS)'), _defineProperty(_Pos_Settings$Receipt, "sms_templates", 'قوالب الرسائل القصيرة'), _defineProperty(_Pos_Settings$Receipt, "email_templates", 'قوالب البريد الإلكتروني'), _Pos_Settings$Receipt);

/***/ }),

/***/ "./resources/src/translations/locales/ba.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/ba.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language bangla

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'রসিদ',
  Pos_Settings: 'পদ সেটিংস (রসিদ)',
  Note_to_customer: 'গ্রাহককে নোট করুন',
  Show_Note_to_customer: 'গ্রাহককে নোট দেখান',
  Show_barcode: 'বারকোড দেখান',
  Show_Tax_and_Discount: 'ট্যাক্স এবং ডিসকাউন্ট এবং শিপিং দেখান',
  Show_Customer: 'গ্রাহক দেখান',
  Show_Email: 'ইমেইল দেখান',
  Show_Phone: 'ফোন দেখান',
  Show_Address: 'ঠিকানা দেখান',
  DefaultLanguage: 'নির্ধারিত ভাষা',
  footer: 'ফুটার',
  Received_Amount: 'প্রাপ্তির পরিমাণ',
  Paying_Amount: 'পরিশোধের পরিমাণ',
  Change: 'রিটার্ন পরিবর্তন',
  Paying_amount_is_greater_than_Received_amount: 'পরিশোধের পরিমাণ প্রাপ্ত পরিমাণের চেয়ে বেশি',
  Paying_amount_is_greater_than_Grand_Total: 'অর্থপ্রদানের পরিমাণ গ্র্যান্ড মোটের চেয়ে বেশি',
  code_must_be_not_exist_already: 'কোড ইতিমধ্যে বিদ্যমান না থাকা আবশ্যক',
  You_will_find_your_backup_on: 'আপনি আপনার ব্যাকআপ পাবেন',
  and_save_it_to_your_pc: 'এবং আপনার পিসিতে সংরক্ষণ করুন',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'আপনার বারকোড স্ক্যান করুন এবং নীচের সঠিক সিম্বলজি নির্বাচন করুন',
  Scan_Search_Product_by_Code_Name: 'কোড বা নাম দ্বারা পণ্য স্ক্যান/অনুসন্ধান করুন',
  Paper_size: 'কাগজের আকার',
  Clear_Cache: 'ক্যাশে সাফ করুন',
  Cache_cleared_successfully: 'ক্যাশে সফলভাবে সাফ করা হয়েছে৷',
  Failed_to_clear_cache: 'ক্যাশে সাফ করতে ব্যর্থ হয়েছে৷',
  Scan_Barcode: 'বারকোড স্ক্যানার',
  Please_use_short_name_of_unit: 'অনুগ্রহ করে ইউনিটের সংক্ষিপ্ত নাম ব্যবহার করুন',
  DefaultCustomer: 'ডিফল্ট গ্রাহক',
  DefaultWarehouse: 'ডিফল্ট গুদাম',
  Payment_Gateway: 'পেমেন্ট গেটওয়ে',
  SMS_Configuration: 'এসএমএস কনফিগারেশন',
  Gateway: 'এসএমএস গেটওয়ে',
  Choose_Gateway: 'এসএমএস গেটওয়ে নির্বাচন করুন',
  Send_SMS: 'বার্তা সফলভাবে পাঠানো হয়েছে',
  sms_config_invalid: 'ভুল এসএমএস কনফিগারেশন অবৈধ',
  Remove_Stripe_Key_Secret: 'স্ট্রাইপ এপিআই কী মুছুন',
  credit_card_account_not_available: 'ক্রেডিট কার্ড অ্যাকাউন্ট উপলব্ধ নেই',
  Credit_Card_Info: 'ক্রেডিট কার্ড তথ্য',
  developed_by: 'দ্বারা বিকশিত',
  Unit_already_linked_with_sub_unit: 'ইউনিট ইতিমধ্যে সাব ইউনিটের সাথে লিঙ্ক করা হয়েছে৷',
  Total_Items_Quantity: 'মোট আইটেম এবং পরিমাণ',
  Value_by_Cost_and_Price: 'খরচ এবং মূল্য',
  Search_this_table: 'এই টেবিল অনুসন্ধান করুন',
  import_products: 'পণ্য আমদানি করুন',
  Field_optional: 'ক্ষেত্র ঐচ্ছিক',
  Download_exemple: 'উদাহরণ ডাউনলোড করুন',
  field_must_be_in_csv_format: 'ক্ষেত্র অবশ্যই csv ফরম্যাটে হতে হবে',
  Successfully_Imported: 'সফলভাবে আমদানি করা হয়েছে',
  file_size_must_be_less_than_1_mega: 'ফাইলের আকার 1 মেগা থেকে কম হতে হবে',
  Please_follow_the_import_instructions: 'আমদানি নির্দেশাবলী অনুসরণ করুন',
  must_be_exist: 'ইউনিট ইতিমধ্যে তৈরি করতে হবে',
  Import_Customers: 'গ্রাহকদের আমদানি করুন',
  Import_Suppliers: 'আমদানি সরবরাহকারী',
  Recent_Sales: 'সাম্প্রতিক বিক্রয়',
  Create_Transfer: 'ট্রান্সফার তৈরি করুন',
  order_products: 'অর্ডার আইটেম',
  Search_Product_by_Code_Name: 'কোড বা নাম দ্বারা পণ্য অনুসন্ধান করুন',
  Reports_payments_Purchase_Return: 'রিপোর্ট ক্রয় রিটার্ন পেমেন্ট',
  Reports_payments_Sale_Return: 'রিপোর্ট বিক্রয় রিটার্ন পেমেন্ট',
  payments_Sales_Return: 'পেমেন্ট বিক্রয় রিটার্ন',
  payments_Purchases_Return: 'পেমেন্ট ক্রয় রিটার্ন',
  CreateSaleReturn: 'বিক্রয় রিটার্ন তৈরি করুন',
  EditSaleReturn: 'বিক্রয় রিটার্ন সম্পাদনা করুন',
  SalesReturn: 'বিক্রয় রিটার্ন',
  CreatePurchaseReturn: 'ক্রয় রিটার্ন তৈরি করুন',
  EditPurchaseReturn: 'ক্রয় রিটার্ন সম্পাদনা করুন',
  PurchasesReturn: 'ক্রয় রিটার্ন',
  Due: 'বাকি',
  Profit: 'লাভ',
  Revenue: 'রাজস্ব',
  Sales_today: 'আজ সেলস',
  People: 'মানুষ',
  Successfully_Created: 'সফলভাবে তৈরি',
  Successfully_Updated: 'সফলভাবে আপডেট',
  Success: 'সফলতা',
  Failed: 'ব্যর্থ হয়েছে',
  Warning: 'সতর্কবাণী',
  Please_fill_the_form_correctly: 'অনুগ্রহ করে ফর্মটি সঠিকভাবে পূরণ করুন',
  Field_is_required: 'এই ক্ষেত্র প্রয়োজন',
  Error: 'ত্রুটি!',
  you_are_not_authorized: 'দুঃখিত! আপনি অনুমোদিত নন।',
  Go_back_to_home: 'হোমপেজে ফিরে যান',
  page_not_exist: 'দুঃখিত! আপনি যে পৃষ্ঠাটি খুঁজছিলেন সেটি বিদ্যমান নেই৷',
  Choose_Status: 'স্থিতি চয়ন করুন',
  Choose_Method: 'পদ্ধতি বেছে নিন',
  Choose_Symbology: 'প্রতীকবিদ্যা চয়ন করুন',
  Choose_Category: 'বিভাগ চয়ন করুন',
  Choose_Customer: 'গ্রাহক চয়ন করুন',
  Choose_Supplier: 'সরবরাহকারী চয়ন করুন',
  Choose_Unit_Purchase: 'ক্রয় ইউনিট নির্বাচন করুন',
  Choose_Sub_Category: 'উপশ্রেণী নির্বাচন করুন',
  Choose_Brand: 'ব্র্যান্ড চয়ন করুন',
  Choose_Warehouse: 'ওয়্যারহাউস বেছে নিন',
  Choose_Unit_Sale: 'বিক্রয় ইউনিট নির্বাচন করুন',
  Enter_Product_Cost: 'পণ্য খরচ লিখুন',
  Enter_Stock_alert: 'স্টক সতর্কতা প্রবেশ করুন',
  Choose_Unit_Product: 'পণ্য ইউনিট চয়ন করুন',
  Enter_Product_Price: 'পণ্যের দাম লিখুন',
  Enter_Name_Product: 'পণ্যের নাম লিখুন',
  Enter_Role_Name: 'ভূমিকার নাম লিখুন',
  Enter_Role_Description: 'ভূমিকার বর্ণনা লিখুন',
  Enter_name_category: 'ক্যাটাগরির নাম লিখুন',
  Enter_Code_category: 'ক্যাটাগরি কোড লিখুন',
  Enter_Name_Brand: 'নাম ব্র্যান্ড লিখুন',
  Enter_Description_Brand: 'বিবরণ ব্র্যান্ড লিখুন',
  Enter_Code_Currency: 'কোড মুদ্রা লিখুন',
  Enter_name_Currency: 'নাম মুদ্রা লিখুন',
  Enter_Symbol_Currency: 'প্রতীক মুদ্রা লিখুন',
  Enter_Name_Unit: 'ইউনিটের নাম লিখুন',
  Enter_ShortName_Unit: 'সংক্ষিপ্ত নাম ইউনিট লিখুন',
  Choose_Base_Unit: 'বেস ইউনিট চয়ন করুন',
  Choose_Operator: 'অপারেটর চয়ন করুন',
  Enter_Operation_Value: 'অপারেশন মান লিখুন',
  Enter_Name_Warehouse: 'গুদাম নাম লিখুন',
  Enter_Phone_Warehouse: 'ওয়্যারহাউস ফোন লিখুন',
  Enter_Country_Warehouse: 'গুদাম দেশ লিখুন',
  Enter_City_Warehouse: 'ওয়্যারহাউস সিটিতে প্রবেশ করুন',
  Enter_Email_Warehouse: 'গুদাম ইমেল লিখুন',
  Enter_ZipCode_Warehouse: 'গুদাম জিপ কোড লিখুন',
  Choose_Currency: 'মুদ্রা পছন্দ করুন',
  Thank_you_for_your_business: 'আমাদের সাথে কেনাকাটা করার জন্য আপনাকে ধন্যবাদ . অনুগ্রহ করে আবার আসবেন',
  Cancel: 'বাতিল করুন',
  New_Customer: 'নতুন গ্রাহক',
  Incorrect_Login: 'ভুল লগইন',
  Successfully_Logged_In: 'সফলভাবে লগ ইন',
  This_user_not_active: 'এই ব্যবহারকারী সক্রিয় নয়',
  SignIn: 'সাইন ইন করুন',
  Create_an_account: 'একটি অ্যাকাউন্ট তৈরি করুন',
  Forgot_Password: 'পাসওয়ার্ড ভুলে গেছেন ?',
  Email_Address: 'ইমেইল ঠিকানা',
  SignUp: 'সাইন আপ করুন',
  Already_have_an_account: 'ইতিমধ্যে একটি একাউন্ট আছে ?',
  Reset_Password: 'পাসওয়ার্ড রিসেট করুন',
  Failed_to_authenticate_on_SMTP_server: 'মেল সার্ভারে প্রমাণীকরণ করতে ব্যর্থ হয়েছে৷',
  We_cant_find_a_user_with_that_email_addres: 'আমরা সেই ইমেল ঠিকানা সহ একজন ব্যবহারকারী খুঁজে পাচ্ছি না',
  We_have_emailed_your_password_reset_link: 'আমরা আপনার পাসওয়ার্ড রিসেট লিঙ্ক ই-মেইল করেছি',
  Please_fill_the_Email_Adress: 'অনুগ্রহ করে ইমেল ঠিকানা পূরণ করুন',
  Confirm_password: 'পাসওয়ার্ড নিশ্চিত করুন',
  Your_Password_has_been_changed: 'আপনার পাসওয়ার্ড পরিবর্তন করা হয়েছে',
  The_password_confirmation_does_not_match: 'পাসওয়ার্ড নিশ্চিতকরণ মেলে না',
  This_password_reset_token_is_invalid: 'এই পাসওয়ার্ড রিসেট টোকেন অবৈধ',
  Warehouse_report: 'গুদাম রিপোর্ট',
  All_Warehouses: 'সমস্ত গুদাম',
  Expense_List: 'সমস্ত ব্যয়',
  Expenses: 'ব্যয়',
  This_Week_Sales_Purchases: 'এই সপ্তাহে বিক্রয় এবং ক্রয়',
  Top_Selling_Products: 'শীর্ষ বিক্রয় পণ্য',
  View_all: 'সব দেখ',
  Payment_Sent_Received: 'পেমেন্ট পাঠানো এবং প্রাপ্ত',
  Filter: 'ছাঁকনি',
  Invoice_POS: 'চালান POS',
  Invoice: 'চালান',
  Customer_Info: 'গ্রাহক তথ্য',
  Company_Info: 'কোম্পানির তথ্য',
  Invoice_Info: 'চালান তথ্য',
  Order_Summary: 'অর্ডার সারাংশ',
  Quote_Info: 'কোটেশন তথ্য',
  Del: 'মুছে ফেলা',
  SuppliersPaiementsReport: 'সরবরাহকারী পেমেন্ট রিপোর্ট',
  Purchase_Info: 'ক্রয় তথ্য',
  Supplier_Info: 'সরবরাহকারীর তথ্য',
  Return_Info: 'প্রত্যাবর্তনের তথ্য',
  Expense_Category: 'বিভাগ',
  Create_Expense: 'ব্যয় তৈরি করুন',
  Details: 'বিস্তারিত',
  Discount_Method: 'ডিসকাউন্ট টাইপ',
  Net_Unit_Cost: 'নেট ইউনিট খরচ',
  Net_Unit_Price: 'নেট ইউনিট মূল্য',
  Edit_Expense: 'ব্যয় সম্পাদনা করুন',
  All_Brand: 'সমস্ত ব্র্যান্ড',
  All_Category: 'সমস্ত বিভাগ',
  ListExpenses: 'সমস্ত খরচ',
  Create_Permission: 'অনুমতি তৈরি করুন',
  Edit_Permission: 'সম্পাদনা অনুমতি',
  Reports_payments_Sales: 'পেমেন্ট বিক্রয় রিপোর্ট',
  Reports_payments_Purchases: 'রিপোর্ট পেমেন্ট ক্রয়',
  Reports_payments_Return_Customers: 'পেমেন্ট রিটার্ন গ্রাহকদের',
  Reports_payments_Return_Suppliers: 'পেমেন্ট রিটার্ন সরবরাহকারী',
  Expense_Deleted: 'এই ব্যয় মুছে ফেলা হয়েছে',
  Expense_Updated: 'এই ব্যয় আপডেট করা হয়েছে',
  Expense_Created: 'এই ব্যয় তৈরি করা হয়েছে',
  DemoVersion: 'আপনি ডেমো সংস্করণে এটি করতে পারবেন না',
  OrderStatistics: 'বিক্রয় পরিসংখ্যান',
  AlreadyAdd: 'এই পণ্য ইতিমধ্যে যোগ করা হয়েছে!!',
  AddProductToList: 'তালিকায় পণ্য যোগ করুন!',
  AddQuantity: 'অনুগ্রহ করে পণ্যের পরিমাণ যোগ করুন !!',
  InvalidData: 'অবৈধ তথ্য !!',
  LowStock: 'পরিমাণ স্টক উপলব্ধ পরিমাণ অতিক্রম',
  WarehouseIdentical: 'দুটি গুদাম একই হতে পারে না!!',
  VariantDuplicate: 'এই ভেরিয়েন্টটি ডুপ্লিকেট!!',
  Filesize: 'ফাইলের আকার',
  GenerateBackup: 'ব্যাকআপ জেনারেট করুন',
  BackupDatabase: 'ব্যাকআপ ডাটাবেস',
  Backup: 'ব্যাকআপ',
  Paid: 'পরিশোধিত পরিমাণ',
  Unpaid: 'অবৈতনিক',
  Today: 'আজ',
  Income: 'আয়'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'ব্যয়'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'বিক্রয়'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'সক্রিয়'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'নিষ্ক্রিয়'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'গ্রাহকদের'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'ফোন'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'ফোন দ্বারা অনুসন্ধান করুন'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'সরবরাহকারীদের'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'কোটেশন'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'সেলস'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'কেনাকাটা'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'প্রত্যাবর্তন'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'সেটিংস'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'সিস্টেম সেটিংস'), _defineProperty(_Receipt$Pos_Settings, "Users", 'ব্যবহারকারীদের'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'গ্রুপ অনুমতি'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'কারেন্সি'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'গুদাম'), _defineProperty(_Receipt$Pos_Settings, "Units", 'ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'ক্রয় ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'বিক্রয় ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'পেমেন্ট রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'পেমেন্ট ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'পেমেন্ট বিক্রয়'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'লাভ এবং ক্ষতি'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'গুদাম স্টক চার্ট'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'বিক্রয় প্রতিবেদন'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Purchase Reportক্রয় প্রতিবেদন'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'গ্রাহক রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'সরবরাহকারী রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'সরবরাহকারী রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'দৈনিক বিক্রয় ডেটা'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'দৈনিক ক্রয় ডেটা'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'সর্বশেষ পাঁচটি রেকর্ড'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'ফিল্টার'), _defineProperty(_Receipt$Pos_Settings, "date", 'তারিখ'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'উল্লেখ'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'সরবরাহকারী'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'পরিশোধের হাল'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'গ্রাহক'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'গ্রাহক কোড'), _defineProperty(_Receipt$Pos_Settings, "Status", 'স্ট্যাটাস'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'সরবরাহকারী কোড'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'ক্যাটাগরি'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'ক্যাটাগরি'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'স্থানান্তর'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'স্টক ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'ড্যাশবোর্ড'), _defineProperty(_Receipt$Pos_Settings, "Products", 'পণ্য'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'সব পণ্য'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'পণ্য ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'পণ্য পরিমাণ সতর্কতা'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'কোড পণ্য'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'গুণফল ট্যাক্স'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'সাব ক্যাটাগরি'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'নাম'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'স্টক সতর্কতা'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'গুদাম'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'ট্যাক্স'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'ক্রয় মূল্য'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'বিক্রয় মূল্য'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'পরিমান'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'বিক্রয় ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'ক্রয় ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'মুদ্রা ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'মুদ্রা কোড'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'মুদ্রার নাম'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'প্রতীক'), _defineProperty(_Receipt$Pos_Settings, "All", 'সব'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'পণ্য সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'কোড দ্বারা অনুসন্ধান করুন'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'নাম দ্বারা অনুসন্ধান'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'পণ্যের বিবরণ'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'গ্রাহকের নাম'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'গ্রাহক ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "Add", 'তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "add", 'তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'সম্পাদনা'), _defineProperty(_Receipt$Pos_Settings, "Close", 'ঘনিষ্ঠ'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'অনুগ্রহ করে নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Action", 'কর্ম'), _defineProperty(_Receipt$Pos_Settings, "Email", 'ইমেইল'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'গ্রাহক সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'গ্রাহক তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "Country", 'দেশ'), _defineProperty(_Receipt$Pos_Settings, "City", 'শহর'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'ঠিকানা'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'গ্রাহক বিবরণ'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'গ্রাহকদের'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'সরবরাহকারী কোড'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'সরবরাহকারী নাম'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'সরবরাহকারী ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'সরবরাহকারীর বিবরণ'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'কোটেশন ম্যানেজমেন্ট'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'সাবটোটাল'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'পরিমাণ বাকি'), _defineProperty(_Receipt$Pos_Settings, "complete", 'সম্পন্ন'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'বিচারাধীন'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'গৃহীত'), _defineProperty(_Receipt$Pos_Settings, "partial", 'আংশিক'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'প্রত্যাবর্তন'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'বিস্তারিত উদ্ধৃতি'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'উদ্ধৃতি সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'বিক্রয় তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'পিডিএফ ডাউনলোড করুন'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'ইমেইলে উদ্ধৃতি পাঠান'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'মুছে ফেলা উদ্ধৃতাংশ'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'তৈরি করুন উদ্ধৃতাংশ'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'পণ্য নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'পণ্য (কোড - নাম)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'দাম'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'স্টক'), _defineProperty(_Receipt$Pos_Settings, "Total", 'গ্র্যান্ড টোটাল'), _defineProperty(_Receipt$Pos_Settings, "Num", 'N°'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'ইউনিট খরচ'), _defineProperty(_Receipt$Pos_Settings, "to", 'To'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'বিষয়'), _defineProperty(_Receipt$Pos_Settings, "Message", 'বার্তা'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'গ্রাহককে ইমেল করুন'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'পাঠান'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'উদ্ধৃতাংশ'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'হ্যালো'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'অনুগ্রহ করে আপনার উদ্ধৃতির জন্য সংযুক্তি খুঁজুন'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'অর্ডার তালিকায় পণ্য যোগ করুন'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'অনুগ্রহ করে গুদাম নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'অনুগ্রহ করে গ্রাহক নির্বাচন করুন৷'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'বিক্রয় ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'ভারসাম্য'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Qty Back'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'টোটাল রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'পরিমাণ'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'বিক্রয় বিস্তারিত'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'বিক্রয় সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'বিক্রয় তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'পেমেন্ট দেখান'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'পেমেন্ট তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'অর্থপ্রদান সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'ইমেইলে বিক্রয় পাঠান'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'বিক্রয় মুছুন'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'দ্বারা পরিশোধ করা হয়'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'পেমেন্ট পছন্দ'), _defineProperty(_Receipt$Pos_Settings, "Note", 'দ্রষ্টব্য'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'অর্থ প্রদান সম্পূর্ণ!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'ক্রয় ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'আদেশ দিয়েছেন'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'ক্রয় মুছুন'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'ইমেল এ ক্রয় পাঠান'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'ক্রয় সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'ক্রয় বিস্তারিত'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'ক্রয় তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'সরবরাহকারী ইমেল'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'পেমেন্ট ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'অর্থপ্রদানের ডেটা ক্রয় করে'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'বিক্রয় পেমেন্ট'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'বিক্রয় অর্থপ্রদানের ডেটা'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'ব্যবহারকারী ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'প্রথম নাম'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'নামের শেষাংশ'), _defineProperty(_Receipt$Pos_Settings, "username", 'ব্যবহারকারীর নাম'), _defineProperty(_Receipt$Pos_Settings, "password", 'পাসওয়ার্ড'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'নতুন পাসওয়ার্ড'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'অবতার পরিবর্তন করুন'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'আপনি যদি এটি পরিবর্তন না করে থাকেন তাহলে অনুগ্রহ করে এই ক্ষেত্রটি ফাঁকা রাখুন৷'), _defineProperty(_Receipt$Pos_Settings, "type", 'টাইপ'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'ব্যবহারকারীদের অনুমতি'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'ভূমিকার নাম'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'ভূমিকার বর্ণনা'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'অনুমতি তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "View", 'দেখুন'), _defineProperty(_Receipt$Pos_Settings, "Del", 'মুছে ফেলা'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'নতুন সমন্বয়'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'সমন্বয় সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'আপনি স্টক 0 আছে এমন পণ্য বিয়োগ করতে পারবেন না'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'সংযোজন'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'বিয়োগ'), _defineProperty(_Receipt$Pos_Settings, "profil", 'প্রোফাইল'), _defineProperty(_Receipt$Pos_Settings, "logout", 'প্রস্থান'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'আপনি পরিবর্তন করতে পারবেন না কারণ এই ক্রয়টি ইতিমধ্যেই অর্থপ্রদান করেছে৷'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'আপনি পরিবর্তন করতে পারবেন না কারণ এই বিক্রয় ইতিমধ্যেই অর্থপ্রদান করেছে৷'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'আপনি পরিবর্তন করতে পারবেন না কারণ এই রিটার্ন ইতিমধ্যেই পরিশোধ করা হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'এই উদ্ধৃতি ইতিমধ্যে বিক্রয় উৎপন্ন হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'প্রোডাক্ট তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'এই উদ্ধৃতি সম্পূর্ণ'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'সাইট কনফিগারেশন'), _defineProperty(_Receipt$Pos_Settings, "Language", 'ভাষা'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'ডিফল্ট মুদ্রা'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'লগইন ক্যাপচা'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'ডিফল্ট ইমেল'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'সাইটের নাম'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'লোগো পরিবর্তন করুন'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'মেইল কনফিগারেশন'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'হোস্ট'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'পোর্ট'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'এনক্রিপশন'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'কনফিগারেশন ভুল'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'পেমেন্ট রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'চালান রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'ইনভয়েস ডেটা ফেরত দেয়'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'সমস্ত ব্যবহারকারীর সমস্ত রেকর্ড দেখুন'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'ছাড়'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'অর্ডার ট্যাক্স'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'শিপিং'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'কোমপানির নাম'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'কোম্পানির ফোন'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'কোম্পানির ঠিকানা'), _defineProperty(_Receipt$Pos_Settings, "Code", 'কোড'), _defineProperty(_Receipt$Pos_Settings, "image", 'চিত্র'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'বারকোড প্রিন্ট করুন'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'গ্রাহক রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'রিটার্ন সরবরাহকারী'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'গ্রাহক চালান ফেরত দিন'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'সরবরাহকারী চালান ফেরত দিন'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'কোন তথ্য উপলব্ধ নেই'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'পণ্য ইমেজ'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'বারকোড'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'বিক্রয় বিন্দু'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'কাস্টম আপলোড'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'পয়েন্ট অফ সেল ম্যানেজমেন্ট'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'সমন্বয়'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'হালনাগাদ'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'রিসেট'), _defineProperty(_Receipt$Pos_Settings, "print", 'প্রিন্ট'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'ইমেল দ্বারা অনুসন্ধান করুন'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'পণ্য নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'পরিমান'), _defineProperty(_Receipt$Pos_Settings, "Items", 'আইটেমগুলি'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Amount HT'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'Amount TTC'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'অনুগ্রহ করে সরবরাহকারী নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'দয়া করে স্থিতি নির্বাচন করুন৷'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'দ্বারা অর্থপ্রদান'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'ওয়্যারহাউস বেছে নিন'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'এখন পরিশোধ করুন'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'ক্যাটাগরির তালিকা'), _defineProperty(_Receipt$Pos_Settings, "Description", 'বর্ণনা'), _defineProperty(_Receipt$Pos_Settings, "submit", 'জমা দিন'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'এই চালান তৈরিতে একটি সমস্যা হয়েছে৷ অনুগ্রহপূর্বক আবার চেষ্টা করুন'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'পেমেন্টে সমস্যা হয়েছে। অনুগ্রহপূর্বক আবার চেষ্টা করুন.'), _defineProperty(_Receipt$Pos_Settings, "IncomeExpenses", 'আয় ও ব্যয়'), _defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'দৈনিক বিক্রয় এবং ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "ProductsExpired", 'পণ্যের মেয়াদ শেষ'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'ব্র্যান্ডস'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'সমন্বয় তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'কয়েক শব্দ ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'ব্যবহারকারীর ছবি'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'পণ্য আপডেট করুন'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'ব্র্যান্ড'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'বারকোড সিম্বোলজি'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'পণ্য খরচ'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'পণ্য মূল্য'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'পণ্য ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'ট্যাক্স প্রকার'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'একাধিক ছবি'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'এই পণ্যের মাল্টি বৈকল্পিক আছে'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'পণ্য প্রচার আছে'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Promotion Start'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Promotion End'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Promotion Price'), _defineProperty(_Receipt$Pos_Settings, "Price", 'দাম'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'খরচ'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'পণ্য বৈকল্পিক'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'বৈকল্পিক'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'ইউনিট মূল্য'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'রিটার্ন গ্রাহক তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'রিটার্ন গ্রাহক সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'রিটার্ন সরবরাহকারী তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'ডক'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'রিটার্ন সরবরাহকারী সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'গুদাম থেকে'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'গুদাম করার জন্য'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'স্থানান্তর সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'স্থানান্তর বিবরণ'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'বিচারাধীন'), _defineProperty(_Receipt$Pos_Settings, "Received", 'গৃহীত'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'আদেশ দিয়েছেন'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'অনুমতি ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'ব্র্যান্ড'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'ব্র্যান্ড ইমেজ'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'ব্র্যান্ডের নাম'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'ব্র্যান্ডের বর্ণনা'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'বেস একক'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'ইউনিট ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'অপারেশন ভ্যালু'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'অপারেটর'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'সেরা 5টি পণ্য'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'শেষ 5 বিক্রয়'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'সমস্ত সমন্বয়'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'সমস্ত স্থানান্তর'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'ট্রান্সফার তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'আদেশ ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'সব উদ্ধৃতি'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'সমস্ত ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'সমস্ত বিক্রয়'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'সব রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'মানুষ ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: 'তুমি কি নিশ্চিত?',
  Text: 'আপনি এটি প্রত্যাবর্তন করতে সক্ষম হবেন না!',
  confirmButtonText: 'হ্যাঁ, এটা মুছে ফেলুন!',
  cancelButtonText: 'বাতিল করুন',
  Deleted: 'মুছে ফেলা হয়েছে!',
  Failed: 'ব্যর্থ হয়েছে!',
  Therewassomethingwronge: 'কিছু ভুল ছিল',
  CustomerDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  SupplierDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  QuoteDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  SaleDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  PaymentDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  PurchaseDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  ReturnDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  ProductDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  ClientError: 'এই ক্লায়েন্টটি ইতিমধ্যেই অন্যান্য অপারেশনের সাথে লিঙ্ক করা হয়েছে৷',
  ProviderError: 'এই সরবরাহকারী ইতিমধ্যেই অন্যান্য অপারেশনের সাথে সংযুক্ত',
  UserDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  UnitDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  RoleDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  TaxeDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  SubCatDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  CatDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  WarehouseDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  AlreadyLinked: 'এই পণ্যটি ইতিমধ্যেই অন্যান্য অপারেশনের সাথে যুক্ত',
  AdjustDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  TitleCurrency: 'সফলভাবে মুছে ফেলা হয়েছে',
  TitleTransfer: 'সফলভাবে মুছে ফেলা হয়েছে',
  BackupDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  TitleBrand: 'সফলভাবে মুছে ফেলা হয়েছে'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleBrand: 'সফলভাবে আপডেট হয়েছে',
  TitleProfile: 'সফলভাবে আপডেট হয়েছে',
  TitleAdjust: 'সফলভাবে আপডেট হয়েছে',
  TitleRole: 'সফলভাবে আপডেট হয়েছে',
  TitleUnit: 'সফলভাবে আপডেট হয়েছে',
  TitleUser: 'সফলভাবে আপডেট হয়েছে',
  TitleCustomer: 'সফলভাবে আপডেট হয়েছে',
  TitleQuote: 'সফলভাবে আপডেট হয়েছে',
  TitleSale: 'সফলভাবে আপডেট হয়েছে',
  TitlePayment: 'সফলভাবে আপডেট হয়েছে',
  TitlePurchase: 'সফলভাবে আপডেট হয়েছে',
  TitleReturn: 'সফলভাবে আপডেট হয়েছে',
  TitleProduct: 'সফলভাবে আপডেট হয়েছে',
  TitleSupplier: 'সফলভাবে আপডেট হয়েছে',
  TitleTaxe: 'সফলভাবে আপডেট হয়েছে',
  TitleCat: 'সফলভাবে আপডেট হয়েছে',
  TitleWarhouse: 'সফলভাবে আপডেট হয়েছে',
  TitleSetting: 'সফলভাবে আপডেট হয়েছে',
  TitleCurrency: 'সফলভাবে আপডেট হয়েছে',
  TitleTransfer: 'সফলভাবে আপডেট হয়েছে'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'সফলভাবে তৈরি করা হয়েছে',
  TitleRole: 'সফলভাবে তৈরি করা হয়েছে',
  TitleUnit: 'সফলভাবে তৈরি করা হয়েছে',
  TitleUser: 'সফলভাবে তৈরি করা হয়েছে',
  TitleCustomer: 'সফলভাবে তৈরি করা হয়েছে',
  TitleQuote: 'সফলভাবে তৈরি করা হয়েছে',
  TitleSale: 'সফলভাবে তৈরি করা হয়েছে',
  TitlePayment: 'সফলভাবে তৈরি করা হয়েছে',
  TitlePurchase: 'সফলভাবে তৈরি করা হয়েছে',
  TitleReturn: 'সফলভাবে তৈরি করা হয়েছে',
  TitleProduct: 'সফলভাবে তৈরি করা হয়েছে',
  TitleSupplier: 'সফলভাবে তৈরি করা হয়েছে',
  TitleTaxe: 'সফলভাবে তৈরি করা হয়েছে',
  TitleCat: 'সফলভাবে তৈরি করা হয়েছে',
  TitleWarhouse: 'সফলভাবে তৈরি করা হয়েছে',
  TitleAdjust: 'সফলভাবে তৈরি করা হয়েছে',
  TitleCurrency: 'সফলভাবে তৈরি করা হয়েছে',
  TitleTransfer: 'সফলভাবে তৈরি করা হয়েছে'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'ইমেল সফলভাবে পাঠান'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'এই বিক্রয় ইতিমধ্যে একটি রিটার্ন সঙ্গে লিঙ্ক!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'রিটার্ন ম্যানেজমেন্ট'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'রিটার্ন বিস্তারিত'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'রিটার্ন সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'রিটার্ন তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'ইমেলে রিটার্ন পাঠান'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'রিটার্ন মুছুন'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'রিটার্ন সারচার্জ'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'ডেলিভারি'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'বিক্রয় নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'আপনি আইটেমটি মুছে ফেলতে পারেন বা এটি ফেরত না দিলে পরিমাণটি শূন্যে সেট করতে পারেন'), _defineProperty(_Receipt$Pos_Settings, "Return", 'প্রত্যাবর্তন'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'মোট বিক্রয়'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'মোট ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'মোট রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'পেমেন্ট নেট'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'পেমেন্ট পাঠানো হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'পেমেন্ট পেয়েছি'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'গৃহীত'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'পাঠানো হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'পণ্য পরিমাণ সতর্কতা'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'কোড'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'গুণফল'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'সতর্কতা পরিমাণ'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'গুদাম স্টক চার্ট'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'মোট পণ্য'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'মোট পরিমাণ'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'সেরা 5 গ্রাহক'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'মোট পরিমাণ'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'মোট দেওয়া'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'গ্রাহক বিক্রয় রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'গ্রাহক পেমেন্ট রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'গ্রাহক উদ্ধৃতি রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'পেমেন্ট'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'শীর্ষ 5 সরবরাহকারী'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'সরবরাহকারী ক্রয় রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'সরবরাহকারী পেমেন্ট রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "Name", 'নাম'), _defineProperty(_Receipt$Pos_Settings, "Code", 'কোড'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'গুদাম ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'জিপ কোড'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'বিভাগসমূহ'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'বিভাগ কোড'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'বিভাগ নাম'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'অভিভাবক শ্রেণী'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'ট্যাক্স ব্যবস্থাপনা'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'ট্যাক্সের নাম'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'করের হার'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'ক্রয় ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'বিক্রয় ইউনিট'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'সংক্ষিপ্ত নাম'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'কোন পণ্য যোগ করার আগে এই নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'সমন্বয়'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'কোনো পণ্য নির্বাচন করার আগে গুদাম নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'স্টক স্থানান্তর'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'পিরিয়ড নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'এই বছর'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'এই টুডে'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'এই মাস'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'এই সপ্তাহ'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'সামঞ্জস্য বিস্তারিত'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'এই ব্যবহারকারী সক্রিয় করা হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'এই ব্যবহারকারী নিষ্ক্রিয় করা হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'পৃষ্ঠা খুঁজে পাওয়া যায়নি.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'উফ! পৃষ্ঠা খুঁজে পাওয়া যায়নি.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'আপনি যে পৃষ্ঠাটি খুঁজছিলেন তা আমরা খুঁজে পাইনি৷ এদিকে, আপনি হতে পারেন৷'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'ড্যাশবোর্ডে ফিরে যান'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'এইচআরএম'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'কর্মচারীদের'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'হাজিরা'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'অনুরোধ ছেড়ে দিন'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'টাইপ'), _defineProperty(_Receipt$Pos_Settings, "Company", 'কোম্পানি'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'বিভাগ'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'উপাধি'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'অফিস শিফট'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'ছুটির দিন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'কোম্পানির নাম লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'ইমেইল অ্যাড্রেস দিন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'কোম্পানির ফোন লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'কোম্পানির দেশ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'সফলভাবে তৈরি করা হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'সফলভাবে আপডেট করা হয়েছে৷'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'সফলভাবে মুছে ফেলা হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "department", 'বিভাগ'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'বিভাগের নাম দিন'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'কোম্পানি চয়ন করুন'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'বিভাগের প্রধান'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'বিভাগীয় প্রধান নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'শিফটের নাম লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Monday In'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tuesday In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'tuesday Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'ছুটি'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'শিরোনাম লিখুন'), _defineProperty(_Receipt$Pos_Settings, "title", 'শিরোনাম'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'শুরুর তারিখ'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'শুরুর তারিখ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'শেষ তারিখ'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'সমাপ্তির তারিখ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'কোন বিবরণ প্রদান করুন'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'উপস্থিতি'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'উপস্থিতির তারিখ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'কর্মচারী নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'কর্মচারী'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'কাজের সময়কাল'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'অবশিষ্ট পাতা অপর্যাপ্ত'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'টাইপ'), _defineProperty(_Receipt$Pos_Settings, "Days", 'দিনগুলি'), _defineProperty(_Receipt$Pos_Settings, "Department", 'বিভাগ'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'টাইপ বেছে নিন'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'স্ট্যাটাস বেছে নিন'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'যুক্তি'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'কারণ ছুটি লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'কর্মচারী যোগ করুন'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'প্রথম নাম'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'প্রথম নাম লিখুন'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'নামের শেষাংশ'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'শেষ নাম লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'লিঙ্গ'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'লিঙ্গ চয়ন করুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'জন্ম তারিখ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'জন্ম তারিখ'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'দেশে প্রবেশ করুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'ফোন নম্বর লিখুন'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'যোগদানের তারিখ'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'যোগদানের তারিখ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'পদবী চয়ন করুন'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'উপাধি'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'অফিস শিফট'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'অফিস শিফট নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'ছেড়ে যাওয়ার তারিখ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'তারিখ ছাড়ার'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'বার্ষিক ছুটি'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'বার্ষিক ছুটি লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'অবশিষ্ট ছুটি'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'কর্মচারী বিবরণ'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'মৌলিক তথ্য'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'পারিবারিক মর্যাদা'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'পারিবারিক অবস্থা চয়ন করুন'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'কর্মসংস্থান প্রকার'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'কর্মসংস্থানের ধরন নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'শহরে প্রবেশ করুন'), _defineProperty(_Receipt$Pos_Settings, "Province", 'প্রদেশ'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'প্রদেশে প্রবেশ করুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'ঠিকানা লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'জিপ কোড প্রবেশ'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'জিপ কোড'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'প্রতি ঘণ্টার হার'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'ঘন্টার হার লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'মূল বেতন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'বেসিক বেতন লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'সামাজিক মাধ্যম'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'স্কাইপ'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'স্কাইপ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'ফেসবুক'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'আপনার Facebook লিখুন'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'হোয়াটসঅ্যাপ'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'হোয়াটসঅ্যাপ লিখুন'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'লিঙ্কডইন'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'লিঙ্কডইন লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'টুইটার'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'আপনার টুইটার লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'অভিজ্ঞতাসমূহ'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'ব্যাংক হিসাব'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'কোমপানির নাম'), _defineProperty(_Receipt$Pos_Settings, "Location", 'অবস্থান'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'অবস্থান লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'বর্ণনা লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'ব্যাংকের নাম'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'ব্যাঙ্কের নাম লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'ব্যাংকের শাখা'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'ব্যাংক শাখায় প্রবেশ করুন'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'ব্যাঙ্ক নম্বর'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'ব্যাঙ্ক নম্বর লিখুন'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'অ্যাক্সেস গুদাম'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'সেরা গ্রাহকদের'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'সংযুক্তি'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'কর্মচারী দেখুন'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'কর্মচারী সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'কর্মচারী মুছুন'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'দ্বারা যোগ করা'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'পণ্যের IMEI/ক্রমিক নম্বর যোগ করুন'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'পণ্যের রয়েছে Imei/ক্রমিক নম্বর'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'প্রেরণ'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'বিতরণ করা হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'ডেলিভারি রেফ'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'বিক্রয় রেফ'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'শিপিং সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'বস্তাবন্দী'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'পাঠানো'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'বিতরণ করা হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'বাতিল'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'শিপিং অবস্থা'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'ব্যবহারকারীদের রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'স্টক রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'মোট ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'মোট কোটেশন'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'মোট রিটার্ন বিক্রয়'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'মোট রিটার্ন ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'মোট স্থানান্তর'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'মোট সমন্বয়'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'ব্যবহারকারীর প্রতিবেদন'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'বর্তমান স্টক'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'পণ্যের নাম'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'মোট ঋণ'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'মোট ঋণ'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'কিছু গুদাম'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'সমস্ত গুদাম'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'পণ্য খরচ'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'এসএমএস সেটিংস'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'POS সেটিংস'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'পেমেন্ট গেটওয়ে'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'মেল সেটিংস'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'নেক্সমো এসএমএস'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'ডিফল্ট এসএমএস গেটওয়ে'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'মডিউল সেটিংস'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'মডিউল সফলভাবে সক্ষম হয়েছে৷'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'মডিউল সফলভাবে নিষ্ক্রিয় হয়েছে৷'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'সেটিংস আপডেট করুন'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'অনুগ্রহ করে সঠিক মডিউলটি আপলোড করুন'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'সফলভাবে আপলোড করা হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'গ্রাহক বিবরণ'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'গ্রাহক সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'গ্রাহক মুছুন'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'ক্লায়েন্ট বিশ্রামের পরিমাণ পরিশোধ করুন'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'অর্থপ্রদানের পরিমাণ মোট বিশ্রামের পরিমাণের চেয়ে বেশি৷'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'গ্রাহক চালান'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'এই পণ্যটি বিক্রির জন্য নয়'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'আপনার ড্যাশবোর্ডে স্বাগতম'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'মোট প্রদেয়'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'বিক্রয় রেফ নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'বিক্রয় নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'বিক্রয় রেফ'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'তালিকা পণ্য রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'পরিমাণ রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'ক্রয় রেফ নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'রেফ ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'ক্রয় নির্বাচন করুন'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'পরিমাণ রিটার্ন ক্রয় করা পরিমাণের চেয়ে বেশি'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'পরিমাণ রিটার্ন বিক্রি করা পরিমাণের চেয়ে বেশি'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'পরিমাণ বিক্রি'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'পরিমাণ ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'প্রেরক নাম'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'আপলোড মডিউল'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'মডিউলটি অবশ্যই জিপ ফাইল হিসাবে আপলোড করতে হবে'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'সমস্ত মডিউল ইনস্টল'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'বর্তমান সংস্করণ'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'আপনি ইতিমধ্যে সর্বশেষ সংস্করণ আছে'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'আপডেট উপলব্ধ'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'আপডেট লগ'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'এখন হালনাগাদ করুন'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'পরিবর্তন লগ দেখুন'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'দ্রষ্টব্য: অনুগ্রহ করে আপডেট সম্পূর্ণভাবে শেষ হওয়ার জন্য অপেক্ষা করুন। এটি ব্রাউজার বন্ধ বা একটি প্রক্রিয়া আপগ্রেড বন্ধ করার সুপারিশ করা হয় না'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'দ্রষ্টব্য: আপগ্রেড চালানোর আগে আপনি আপনার বর্তমান সংস্করণ এবং ডাটাবেস ব্যাকআপ করেছেন তা নিশ্চিত করুন, যদি কোনও ত্রুটি থাকে তবে এটি পুনরুদ্ধার করতে'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'চালান ফুটার'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'সময় অঞ্চল'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'পেমেন্ট নোট'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'বিক্রয় নোট'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'মোট বিক্রয় ঋণ'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'মোট বিক্রি রিটার্ন ঋণ'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'এক সময়ে সমস্ত বিক্রয় ঋণ পরিশোধ করুন'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'এক সময়ে সব বিক্রি রিটার্ন ঋণ পরিশোধ'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'মোট মুনাফা'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'এক সময়ে সমস্ত ক্রয় ঋণ পরিশোধ করুন'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'প্রদানকারী মুছুন'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'প্রদানকারী সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'প্রদানকারীর বিবরণ'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'মোট ক্রয় দেনা'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'ক্রেডিট নোট'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'ক্রেডিট নোট'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'রিটার্ন বিক্রি করুন'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'ক্রয় রিটার্ন'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'কর নম্বর'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'রিটার্ন পরিমাণ যোগ করুন'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'লেনদেনের জন্য রিটার্ন বিদ্যমান'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'পরিমাণ রিটার্ন বাকি পরিমাণের চেয়ে বেশি'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", '0 তে সেটের পরিমাণ সহ যেকোন পণ্য ফেরত দেওয়া হবে না'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'এক সময়ে সমস্ত ক্রয় রিটার্ন পরিশোধ করুন'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'মোট ক্রয় রিটার্ন বকেয়া'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'ক্রয় রিটার্ন ঋণ'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'বিক্রয় ফেরত ঋণ'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'পণ্য রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'পণ্য বিক্রয় রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'পণ্য ক্রয় রিপোর্ট'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'পরিমাণ বিক্রি'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'পরিমাণ ক্রয়'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'গুদাম দ্বারা ফিল্টার'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'স্বয়ংক্রিয়ভাবে চালান প্রিন্ট করুন'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'গুদাম দেখান'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'ক্রেডিট কার্ড তথ্য'), _defineProperty(_Receipt$Pos_Settings, "saved_credit_card_info", 'সংরক্ষিত ক্রেডিট কার্ড তথ্য'), _defineProperty(_Receipt$Pos_Settings, "credit_card_changed_successfully", 'ক্রেডিট কার্ড সফলভাবে পরিবর্তিত হয়েছে'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'বিজ্ঞপ্তি টেমপ্লেট'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'ই-মেইল বিজ্ঞপ্তি'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'এসএমএস বিজ্ঞপ্তি'), _defineProperty(_Receipt$Pos_Settings, "change_product_details", 'পণ্যের বিস্তারিত পরিবর্তন করুন'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'কর এবং ছাড় এবং শিপিং সম্পাদনা করুন'), _defineProperty(_Receipt$Pos_Settings, "create_quotation_with_stock", 'স্টক সহ উদ্ধৃতি তৈরি করুন'), _defineProperty(_Receipt$Pos_Settings, "variant_name", 'পণ্যের পদক্ষেপের নাম'), _defineProperty(_Receipt$Pos_Settings, "variant_cost", 'পণ্যের পদক্ষেপ খরচ'), _defineProperty(_Receipt$Pos_Settings, "variant_price", 'পণ্যের পদক্ষেপ মূল্য'), _defineProperty(_Receipt$Pos_Settings, "variant_code", 'পণ্যের পদক্ষেপ কোড'), _defineProperty(_Receipt$Pos_Settings, "please_wait_until_the_product_is_loaded", 'পণ্য লোড হওয়া পর্যন্ত অপেক্ষা করুন'), _defineProperty(_Receipt$Pos_Settings, "choose_sms_gateway", 'এসএমএস গেটওয়ে চয়ন করুন'), _defineProperty(_Receipt$Pos_Settings, "notification_client", 'বিজ্ঞপ্তি ক্লায়েন্ট'), _defineProperty(_Receipt$Pos_Settings, "available_tags", 'উপলব্ধ ট্যাগগুলি'), _defineProperty(_Receipt$Pos_Settings, "email_subject", 'ই-মেইল বিষয়'), _defineProperty(_Receipt$Pos_Settings, "email_body", 'ই-মেইল বডি'), _defineProperty(_Receipt$Pos_Settings, "notification_supplier", 'বিজ্ঞপ্তি সাপ্লাইয়ার'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'এসএমএস বডি'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'এসএমএস টেমপ্লেট'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'ইমেল টেমপ্লেট'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/br.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/br.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language BR

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Recibo',
  Pos_Settings: 'Configurações de Pos (Recibo)',
  Note_to_customer: 'Nota ao cliente',
  Show_Note_to_customer: 'Mostrar nota ao cliente',
  Show_barcode: 'Mostre o código de barras',
  Show_Tax_and_Discount: 'Mostrar impostos e descontos e envios',
  Show_Customer: 'Mostrar cliente',
  Show_Email: 'Mostrar e-mail',
  Show_Phone: 'Mostrar telefone',
  Show_Address: 'Mostrar endereço',
  DefaultLanguage: 'Idioma padrão',
  footer: 'rodapé',
  Received_Amount: 'Valor recebido',
  Paying_Amount: 'Valor a pagar',
  Change: 'Alterar devolução',
  Paying_amount_is_greater_than_Received_amount: 'O valor pago é maior do que o valor recebido',
  Paying_amount_is_greater_than_Grand_Total: 'O valor do pagamento é maior que o total geral',
  code_must_be_not_exist_already: 'O código não deve existir já',
  You_will_find_your_backup_on: 'Você encontrará seu backup em',
  and_save_it_to_your_pc: 'e salve no seu pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Digitalize seu código de barras e selecione a simbologia correta abaixo',
  Scan_Search_Product_by_Code_Name: 'Digitalizar/pesquisar produto por código ou nome',
  Paper_size: 'Tamanho do papel',
  Clear_Cache: 'Limpar cache',
  Cache_cleared_successfully: 'Cache limpo com sucesso',
  Failed_to_clear_cache: 'Falha ao limpar o cache',
  Scan_Barcode: 'Leitor de códigos de barra',
  Please_use_short_name_of_unit: 'Por favor, use o nome abreviado da unidade',
  DefaultCustomer: 'Cliente padrão',
  DefaultWarehouse: 'Armazém padrão',
  Payment_Gateway: 'Gateway de pagamento',
  SMS_Configuration: 'Configuração de SMS',
  Gateway: 'Gateway SMS',
  Choose_Gateway: 'Escolha o Gateway SMS',
  Send_SMS: 'mensagem enviada com sucesso',
  sms_config_invalid: 'configuração de sms errada inválida',
  Remove_Stripe_Key_Secret: 'Excluir chaves da API Stripe',
  credit_card_account_not_available: 'Conta de cartão de crédito não disponível',
  Credit_Card_Info: 'Informações do cartão de crédito',
  developed_by: 'Desenvolvido por',
  Unit_already_linked_with_sub_unit: 'Unidade já vinculada à subunidade',
  Total_Items_Quantity: 'Total de Itens e Quantidade',
  Value_by_Cost_and_Price: 'Valor por Custo e Preço',
  Search_this_table: 'Pesquisar esta tabela',
  import_products: 'Importar produtos',
  Field_optional: 'Campo opcional',
  Download_exemple: 'Baixar exemplo',
  field_must_be_in_csv_format: 'O campo deve estar no formato csv',
  Successfully_Imported: 'Importado com sucesso',
  file_size_must_be_less_than_1_mega: 'O tamanho do arquivo deve ser menor que 1 mega',
  Please_follow_the_import_instructions: 'Por favor, siga as instruções de importação',
  must_be_exist: 'Unidade já deve ser criada',
  Import_Customers: 'Importar clientes',
  Import_Suppliers: 'Fornecedores de importação',
  Recent_Sales: 'Vendas recentes',
  Create_Transfer: 'Criar transferência',
  order_products: 'Itens de ordem',
  Search_Product_by_Code_Name: 'Pesquisar produto por código ou nome',
  Reports_payments_Purchase_Return: 'Relatórios de pagamentos de devolução de compra',
  Reports_payments_Sale_Return: 'Relatórios de Pagamentos de Devolução de Vendas',
  payments_Sales_Return: 'Devolução de vendas de pagamentos',
  payments_Purchases_Return: 'Pagamentos Devolução de Compras',
  CreateSaleReturn: 'Criar Devolução de Venda',
  EditSaleReturn: 'Editar devolução de venda',
  SalesReturn: 'Retorno de vendas',
  CreatePurchaseReturn: 'Criar devolução de compra',
  EditPurchaseReturn: 'Editar devolução de compra',
  PurchasesReturn: 'Devolução de compras',
  Due: 'Vencimento',
  Profit: 'Perfil',
  Revenue: 'receita',
  Sales_today: 'Vendas de hoje',
  People: 'Pessoas',
  Successfully_Created: 'Criado com sucesso',
  Successfully_Updated: 'Atualizado com sucesso',
  Success: 'Sucesso',
  Failed: 'Fracassado',
  Warning: 'Aviso',
  Please_fill_the_form_correctly: 'Por favor preencha o formulário corretamente',
  Field_is_required: 'Este campo é obrigatório',
  Error: 'Erro!',
  you_are_not_authorized: 'Desculpe! Você não está autorizado.',
  Go_back_to_home: 'Voltar para a página inicial',
  page_not_exist: 'Desculpe! A página que você estava procurando não existe.',
  Choose_Status: 'Escolha o status',
  Choose_Method: 'Escolha o método',
  Choose_Symbology: 'Escolha a simbologia',
  Choose_Category: 'Escolher categoria',
  Choose_Customer: 'Escolher categoria',
  Choose_Supplier: 'Escolha o fornecedor',
  Choose_Unit_Purchase: 'Escolha a unidade de compra',
  Choose_Sub_Category: 'Escolha a subcategoria',
  Choose_Brand: 'Escolha a marca',
  Choose_Warehouse: 'Escolher Armazém',
  Choose_Unit_Sale: 'Escolha a unidade de venda',
  Enter_Product_Cost: 'Insira o custo do produto',
  Enter_Stock_alert: 'Digite o alerta de estoque',
  Choose_Unit_Product: 'Escolha a unidade do produto',
  Enter_Product_Price: 'Insira o preço do produto',
  Enter_Name_Product: 'Digite o nome do produto',
  Enter_Role_Name: 'Digite o nome da função',
  Enter_Role_Description: 'Digite a descrição do papel',
  Enter_name_category: 'Digite o nome da categoriae',
  Enter_Code_category: 'Digite o código da categoria',
  Enter_Name_Brand: 'Digite o nome da marca',
  Enter_Description_Brand: 'Digite Descrição Marca',
  Enter_Code_Currency: 'Digite a moeda do código',
  Enter_name_Currency: 'Digite a moeda do código',
  Enter_Symbol_Currency: 'Insira a moeda do símbolo',
  Enter_Name_Unit: 'Digite o nome da unidade',
  Enter_ShortName_Unit: 'Insira a unidade de nome abreviado',
  Choose_Base_Unit: 'Escolha a unidade básica',
  Choose_Operator: 'Escolher Operador',
  Enter_Operation_Value: 'Enter Operation Value',
  Enter_Name_Warehouse: 'Enter Warehouse Name',
  Enter_Phone_Warehouse: 'Enter Warehouse Phone',
  Enter_Country_Warehouse: 'Enter Warehouse Country',
  Enter_City_Warehouse: 'Enter Warehouse City',
  Enter_Email_Warehouse: 'Enter Warehouse Email',
  Enter_ZipCode_Warehouse: 'Enter Warehouse Zip Code',
  Choose_Currency: 'Escolha a moeda',
  Thank_you_for_your_business: 'Obrigado por comprar conosco . Por favor, volte',
  Cancel: 'Cancelar',
  New_Customer: 'Novo cliente',
  Incorrect_Login: 'Login incorreto',
  Successfully_Logged_In: 'Logado com sucesso',
  This_user_not_active: 'Este usuário não está ativo',
  SignIn: 'Entrar',
  Create_an_account: 'Crie a sua conta aqui',
  Forgot_Password: 'Esqueceu a senha ?',
  Email_Address: 'Endereço de email',
  SignUp: 'Inscrever-se',
  Already_have_an_account: 'Já tem uma conta ?',
  Reset_Password: 'Redefinir senha',
  Failed_to_authenticate_on_SMTP_server: 'Falha ao autenticar no servidor SMTP',
  We_cant_find_a_user_with_that_email_addres: 'Não conseguimos encontrar um usuário com esse endereço de e-mail',
  We_have_emailed_your_password_reset_link: 'Enviamos o link de redefinição de senha por e-mail',
  Please_fill_the_Email_Adress: 'Por favor, preencha o endereço de e-mail',
  Confirm_password: 'Confirme a Senha',
  Your_Password_has_been_changed: 'Sua senha foi mudada',
  The_password_confirmation_does_not_match: 'A confirmação da senha não corresponde',
  This_password_reset_token_is_invalid: 'Este token de redefinição de senha é inválido',
  Warehouse_report: 'Relatório do armazém',
  All_Warehouses: 'Todos os Armazéns',
  Expense_List: 'Todas as despesas',
  Expenses: 'Despesas',
  This_Week_Sales_Purchases: 'Esta semana Vendas e compras',
  Top_Selling_Products: 'Produtos mais vendidos',
  View_all: 'Ver tudo',
  Payment_Sent_Received: 'Pagamento enviado e recebido',
  Filter: 'Filtro',
  Invoice_POS: 'Fatura PDV',
  Invoice: 'Fatura',
  Customer_Info: 'Informação do Cliente',
  Company_Info: 'Informação da companhia',
  Invoice_Info: 'Informações da fatura',
  Order_Summary: 'Resumo do pedido',
  Quote_Info: 'Informações da cotação',
  Del: 'Excluir',
  SuppliersPaiementsReport: 'Relatório de Pagamentos de Fornecedores',
  Purchase_Info: 'Informações de compra',
  Supplier_Info: 'Informações do fornecedor',
  Return_Info: 'Informações de Devolução',
  Expense_Category: 'Categoria de Despesa',
  Create_Expense: 'Criar Despesa',
  Details: 'Detalhes',
  Discount_Method: 'Tipo de desconto',
  Net_Unit_Cost: 'Custo unitário líquido',
  Net_Unit_Price: 'Preço unitário líquido',
  Edit_Expense: 'Edit Expense',
  All_Brand: 'Todas as marcas',
  All_Category: 'Todas as categorias',
  ListExpenses: 'Todas as despesas',
  Create_Permission: 'Criar permissão',
  Edit_Permission: 'Editar permissão',
  Reports_payments_Sales: 'Relatórios de pagamentos Vendas',
  Reports_payments_Purchases: 'Relatórios de pagamentos Compras',
  Reports_payments_Return_Customers: 'Clientes de Devolução de Pagamentos',
  Reports_payments_Return_Suppliers: 'Fornecedores de devolução de pagamentos',
  Expense_Deleted: 'Esta despesa foi excluída',
  Expense_Updated: 'Esta despesa contratada foi',
  Expense_Created: 'Esta despesa foi criada',
  DemoVersion: 'Você não pode fazer isso na versão demo',
  OrderStatistics: 'Estatísticas de vendas',
  AlreadyAdd: 'Este produto já foi adicionado !!',
  AddProductToList: 'Por favor, adicione o produto à lista !!',
  AddQuantity: 'Por favor, adicione a quantidade do produto !!',
  InvalidData: 'Dados inválidos !!',
  LowStock: 'A quantidade excede a quantidade disponível em estoque',
  WarehouseIdentical: 'Os dois armazéns não podem ser idênticos !!',
  VariantDuplicate: 'Esta variante é duplicada !!',
  Filesize: 'Tamanho do arquivo',
  GenerateBackup: 'Gerar Backup',
  BackupDatabase: 'Banco de dados de backup',
  Backup: 'Backup',
  Paid: 'Pago',
  Unpaid: 'Não pago',
  Today: 'Hoje',
  Income: 'Income'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'Despesas'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'Oferta'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Ativo'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Inativo'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'Cliente'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Telefone'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Pesquisar por telefone'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Fornecedores'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Cotações'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'Vendas'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'Compras'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'Retornar'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'Definições'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'Configurações de sistema'), _defineProperty(_Receipt$Pos_Settings, "Users", 'Usuários'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Permissões de grupo'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'Moeda'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'Armazém'), _defineProperty(_Receipt$Pos_Settings, "Units", 'Unidade'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'Unidades de compras'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Unidades de vendas'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'Relatórios'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Relatório de pagamentos'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Pagamentos Compras'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Pagamentos Vendas'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Lucros e perdas'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Gráfico de Estoque do Armazém'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'Relatório de vendas'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Relatório de compra'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'Relatório do cliente'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Relatório do Fornecedor'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Relatório do Fornecedor'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'Dados diários de vendas'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'Dados de compras diárias'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Últimos cinco registros'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'Filtros'), _defineProperty(_Receipt$Pos_Settings, "date", 'Encontro'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Referência'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Fornecedor'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Status do pagamento'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'Cliente'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'Código do Consumidor'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Status'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Código de fornecedor'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Categoria'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'Categoria'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'Transferir'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Gestão de Estoque'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Dashboard'), _defineProperty(_Receipt$Pos_Settings, "Products", 'Produtos'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'Todos os produtos'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Gestão de produtos'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Alertas de quantidade de produtos'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Código do produto'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Imposto sobre produtos'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'Subcategoria'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'Nome'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Alerta de estoque'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'Armazém'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'Imposto'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Preço de compra'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Preço de venda'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'Quantidade'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Unidade de venda'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'Unidade de compra'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Gerenciamento de moeda'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Código da moeda'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Nome da moeda'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Símbolo'), _defineProperty(_Receipt$Pos_Settings, "All", 'Tudo'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Editar produto'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Pesquisar por código'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Procura por nome'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Detalhes do produto'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'nome do cliente'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Gestão de Clientes'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Criar'), _defineProperty(_Receipt$Pos_Settings, "add", 'Criar'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'Editar'), _defineProperty(_Receipt$Pos_Settings, "Close", 'Fechar'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Por favor selecione'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Ação'), _defineProperty(_Receipt$Pos_Settings, "Email", 'Email'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Editar cliente'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Criar cliente'), _defineProperty(_Receipt$Pos_Settings, "Country", 'País'), _defineProperty(_Receipt$Pos_Settings, "City", 'Cidade'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Endereço'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'Detalhes do cliente'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Clientes'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Código de fornecedor'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'Nome do Fornecedor'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Gestão de fornecedores'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Detalhes do fornecedor'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Gerenciamento de Cotações'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Subtotal'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Quantidade restante'), _defineProperty(_Receipt$Pos_Settings, "complete", 'Concluído'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'Pendente'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Recebido'), _defineProperty(_Receipt$Pos_Settings, "partial", 'Parcial'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Retornar'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Cotação detalhada'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Editar cotação'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Criar venda'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'Baixar PDF'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'Enviar cotação no e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Excluir cotação'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'Criar cotação'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Selecionar produto'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Produto (Código - Nome)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Preço'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'Estoque'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Total geral'), _defineProperty(_Receipt$Pos_Settings, "Num", 'N°'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Custo unitário'), _defineProperty(_Receipt$Pos_Settings, "to", 'Para'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Sujeito'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Mensagem'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'E-mail do cliente'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Mandar'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'cotação'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Olá'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Por favor, encontre o anexo para sua cotação'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Adicionar produtos à lista de pedidos'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Selecione o armazém'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'Por favor selecione o cliente'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Gerenciamento de vendas'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Equilíbrio'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Quantidade de volta'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Retorno total'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'Quantia'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Detalhe da venda'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Editar venda'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Criar venda'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Mostrar pagamentos'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'Criar pagamento'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Editar pagamento'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Enviar venda por e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Excluir venda'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Pago pelo'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Opção de pagamento'), _defineProperty(_Receipt$Pos_Settings, "Note", 'Observação'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Pagamento concluído!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Gestão de compras'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Encomendado'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Excluir compra'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Enviar compra por e-mail'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'Editar compra'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'Detalhe da compra'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Criar compra'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'E-mail do fornecedor'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Pagamentos de compras'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Dados de pagamentos de compras'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'Pagamentos de vendas'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Dados de pagamentos de vendas'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'Gerenciamento de usuários'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'Primeiro nome'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'Sobrenome'), _defineProperty(_Receipt$Pos_Settings, "username", 'Nome de usuário'), _defineProperty(_Receipt$Pos_Settings, "password", 'Senha'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'Nova Senha'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Mudar Avatar'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Por favor, deixe este campo em branco se você não o alterou'), _defineProperty(_Receipt$Pos_Settings, "type", 'Modelo'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Permissões de usuários'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Função'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Descrição do papel'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Criar permissões'), _defineProperty(_Receipt$Pos_Settings, "View", 'Visão'), _defineProperty(_Receipt$Pos_Settings, "Del", 'Excluir'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'Novo ajuste'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Editar ajuste'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'Você não pode subtrair produtos que têm estoque 0'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'Adição'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Subtração'), _defineProperty(_Receipt$Pos_Settings, "profil", 'Perfil'), _defineProperty(_Receipt$Pos_Settings, "logout", 'Sair'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'Você não pode modificar porque esta compra já foi paga'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'Você não pode modificar porque esta venda já foi paga'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'Você não pode modificar porque esta Devolução já foi paga'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'Esta cotação já gerou venda'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'Criar produto'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'Esta cotação completa'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Configuração do site'), _defineProperty(_Receipt$Pos_Settings, "Language", 'Linguagem'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Moeda padrão'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Captcha de login'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'E-mail padrão'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Nome do site'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Alterar logotipo'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'Configuração SMTP'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'MAIL_HOST'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'MAIL_PORT'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'MAIL_ENCRYPTION'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'Configuração SMTP incorreta'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Devoluções de pagamentos'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'Devoluções de faturas'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'Devoluções de dados de faturas'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'Ver todos os registros de todos os usuários'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Desconto'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Imposto de pedido'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'Envio'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Nome da empresa'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Telefone da empresa'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Endereço da companhia'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Código'), _defineProperty(_Receipt$Pos_Settings, "image", 'Imagem'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Imprimir código de barras'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Cliente de Devoluções'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Fornecedor de devoluções'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'Devolução da fatura do cliente'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Devolução de fatura do fornecedor'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'Nenhum dado disponível'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'Imagem do Produto'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'Código de barras'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'Ponto de Vendas'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Upload personalizado'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'Gerenciamento de ponto de venda'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Ajustamento'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Atualizar'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Redefinir'), _defineProperty(_Receipt$Pos_Settings, "print", 'Imprimir'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Pesquisar por e-mail'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Escolha o produto'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Qty'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Itens'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Quantidade HT'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'Valor TTC'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Selecione o fornecedorPlease Select Supplier'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Selecione o status'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'Pago pelo'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Escolher Armazém'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'Pague agora'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'Lista de Categoria'), _defineProperty(_Receipt$Pos_Settings, "Description", 'Description'), _defineProperty(_Receipt$Pos_Settings, "submit", 'Enviar'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'Ocorreu um problema ao criar esta fatura. Por favor, tente novamente'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'Houve um problema no pagamento. Por favor, tente novamente..'), _defineProperty(_Receipt$Pos_Settings, "IncomeExpenses", 'Receitas e despesas'), _defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Vendas e compras diárias'), _defineProperty(_Receipt$Pos_Settings, "ProductsExpired", 'Produtos expirados'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'Marcas'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'Criar ajuste'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'Algumas palavras ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'Imagem do usuário'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Atualizar produto'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'Marca'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'Simbologia do código de barras'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'Custo do produto'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Preço do produto'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'Unidade de produto'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'Tipo de imposto'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'Várias imagens'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'Este produto tem várias variantes'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'Produto Tem Promoção'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Início da promoção'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Fim da promoção'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Preço de promoção'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Preço'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'Custo'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'Unidade'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'Variante do produto'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'Variante'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Preço unitário'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'Criar cliente de devolução'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Editar cliente de retorno'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'Criar fornecedor de devolução'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'Doc'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'Editar fornecedor de devolução'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Do armazém'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'Para Armazém'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'Editar transferência'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'Detalhe da transferência'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'Pendente'), _defineProperty(_Receipt$Pos_Settings, "Received", 'Recebido'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Encomendado'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'Gerenciamento de permissões'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'Marca'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'Imagem de marca'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'Marca'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'Descrição da marca'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'Unidade base'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'Gestão de Unidades'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Valor da operação'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'Operador'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", '5 principais produtos'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'Últimas 5 vendas'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'Todos os ajustes'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'Todas as transferências'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Criar transferência'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'Gestão de Pedidos'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'Todas as Cotações'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'Todas as compras'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'Todas as vendas'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'Todas as devoluções'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'Gestão de Pessoas'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: 'Tem certeza?',
  Text: 'Você não poderá reverter isso!',
  confirmButtonText: 'Sim, exclua!',
  cancelButtonText: 'Cancelar',
  Deleted: 'Excluído!',
  Failed: 'Fracassado!',
  Therewassomethingwronge: 'Havia algo errado',
  CustomerDeleted: 'Este cliente foi excluído.',
  SupplierDeleted: 'Este fornecedor foi excluído.',
  QuoteDeleted: 'Esta cotação foi excluída.',
  SaleDeleted: 'Esta venda foi excluída.',
  PaymentDeleted: 'Este pagamento foi excluído.',
  PurchaseDeleted: 'Esta compra foi excluída.',
  ReturnDeleted: 'Este retorno foi excluído.',
  ProductDeleted: 'Este produto foi excluído.',
  ClientError: 'Este Cliente já está vinculado a outra Operação',
  ProviderError: 'Este Fornecedor já vinculado a outra Operação',
  UserDeleted: 'Este usuário foi excluído.',
  UnitDeleted: 'Esta unidade foi excluída.',
  RoleDeleted: 'Esta função foi excluída.',
  TaxeDeleted: 'Este imposto foi excluído.',
  SubCatDeleted: 'Esta subcategoria foi excluída.',
  CatDeleted: 'Esta categoria foi excluída.',
  WarehouseDeleted: 'Este Armazém foi excluído.',
  AlreadyLinked: 'Este produto já está vinculado a outra Operação',
  AdjustDeleted: 'Este ajuste foi excluído.',
  TitleCurrency: 'Esta moeda foi excluída.',
  TitleTransfer: 'A transferência foi removida com sucesso',
  BackupDeleted: 'O backup foi removido com sucesso',
  TitleBrand: 'Esta marca foi excluída'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleBrand: 'Esta marca foi atualizada',
  TitleProfile: 'Seu perfil atualizado com sucesso',
  TitleAdjust: 'Ajuste atualizado com sucesso',
  TitleRole: 'Função atualizada com sucesso',
  TitleUnit: 'Unidade atualizada com sucesso',
  TitleUser: 'Usuário atualizado com sucesso',
  TitleCustomer: 'Cliente atualizado com sucesso',
  TitleQuote: 'Cotação atualizada com sucesso',
  TitleSale: 'Venda atualizada com sucesso',
  TitlePayment: 'Pagamento atualizado com sucesso',
  TitlePurchase: 'Compra atualizada com sucesso',
  TitleReturn: 'Devolução Atualizada com sucesso',
  TitleProduct: 'Produto atualizado com sucesso',
  TitleSupplier: 'Fornecedor atualizado com sucesso',
  TitleTaxe: 'Imposto atualizado com sucesso',
  TitleCat: 'Categoria atualizada com sucesso',
  TitleWarhouse: 'Armazém atualizado com sucesso',
  TitleSetting: 'Configurações atualizadas com sucesso',
  TitleCurrency: 'Moeda atualizada com sucesso',
  TitleTransfer: 'Transferência atualizada com sucesso'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'Esta marca foi criada',
  TitleRole: 'Função criada com sucesso',
  TitleUnit: 'Unidade criada com sucesso',
  TitleUser: 'Usuário criado com sucesso',
  TitleCustomer: 'Cliente criado com sucesso',
  TitleQuote: 'Cotação criada com sucesso',
  TitleSale: 'Venda criada com sucesso',
  TitlePayment: 'Pagamento criado com sucesso',
  TitlePurchase: 'Compra criada com sucesso',
  TitleReturn: 'Retorno criado com sucesso',
  TitleProduct: 'Produto criado com sucesso',
  TitleSupplier: 'Fornecedor criado com sucesso',
  TitleTaxe: 'Imposto criado com sucesso',
  TitleCat: 'Categoria criada com sucesso',
  TitleWarhouse: 'Armazém criado com sucesso',
  TitleAdjust: 'Armazém criado com sucesso',
  TitleCurrency: 'Moeda criada com sucesso',
  TitleTransfer: 'Transferência criada com sucesso'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email enviado com sucesso'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'Esta venda já está vinculada a uma Devolução!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'Gestão de Devolução'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Return Detail'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'Editar retorno'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'Criar Devolução'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'Enviar retorno no e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Excluir Devolução'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'Sobretaxa de devolução'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'Entrega'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Selecionar venda'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'Você pode excluir o item ou definir a quantidade devolvida para zero se não for devolvida'), _defineProperty(_Receipt$Pos_Settings, "Return", 'Retornar'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'Comprar'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'Vendas totais'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total de Compras'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'Devoluções totaiss'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'Pagamentos líquidos'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'Pagamentos enviados'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'Pagamentos recebidos'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'Recebid'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Enviado'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Product Quantity Alerts'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Código'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'Produtos'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'Quantidade de alertas'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Gráfico de Estoque do Armazém'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'Produtos totais'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'Quantidade total'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", '5 principais clientes'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", '5 principais clientes'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'Total pago'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'Relatório de vendas do cliente'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Relatório de pagamentos do cliente'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'Relatório de Cotações de Clientes'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'Pagamentos'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", '5 principais fornecedores'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'Relatório de Compras de Fornecedores'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'Relatório de Pagamentos de Fornecedores'), _defineProperty(_Receipt$Pos_Settings, "Name", 'Nome'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Código'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'Gerenciamento de armazenagem'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'Código postal'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Gerenciamento de categorias'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'Código da categoria'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'Nome da Categoria'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'Categoria Parental'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'Gestão tributária'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'Nome Fiscal'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'Taxa de imposto'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Unidade de compras'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'Unidade de vendas'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'Nome curto'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Por favor, selecione estes antes de adicionar qualquer produto'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'Ajustamento'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'Please Select warehouse before choose any product'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'Stock Transfer'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'Select Period'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'This Year'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'This Today'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'This Month'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'This Week'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'Adjustment Detail'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'This User Has been Activated'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'This User Has been Deactivated'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'Page not found.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'Ops! página não encontrada.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'Não foi possível encontrar a página que você estava procurando. Enquanto isso, você pode'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'Voltar ao painel'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'HRM'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'Funcionários'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'Comparecimento'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Deixar pedido'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Tipo de licença'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Companhia'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Departamentos'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'Designações'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Turno de escritório'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Feriados'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Digite o nome da empresae'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Insira o endereço de e-mail'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Digite o telefone da empresa'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Insira o país da empresa'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Criado com sucesso'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Atualizado com sucesso'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Excluído com sucesso'), _defineProperty(_Receipt$Pos_Settings, "department", 'Departamento'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Digite o nome do departamento'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Escolha a empresa'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Chefe de departamento'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Escolha o chefe de departamento'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Digite o nome do turno'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Segunda-feira'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Segunda-feira'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Terça-feira In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'terça Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'Feriado'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Digite o título'), _defineProperty(_Receipt$Pos_Settings, "title", 'título'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Data de início'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Enter start date'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Data de término'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Insira a data de término'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Por favor, forneça quaisquer detalhes'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'Presenças'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Insira a data de atendimento'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Em vez'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Tempo esgotado'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'Escolher funcionário'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'Empregado'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Duração do Trabalho'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'As folhas restantes são insuficientes'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Tipo de licença'), _defineProperty(_Receipt$Pos_Settings, "Days", 'Dias'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Departamento'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Escolha o tipo de licença'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'Escolha o status'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Motivo de Saída'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Digite o motivo da licença'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Adicionar funcionário'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'Primeiro nome'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Introduza o primeiro nome'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Sobrenome'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Insira o último nome'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Gênero'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Escolha o Gênero'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Digite a data de nascimento'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Data de nascimento'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Digite o país'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Digite o número de telefone'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Data de ingresso'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Insira a data de adesão'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'Escolha a designação'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'Designação'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Turno de escritório'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Escolha o turno do escritório'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Digite a data de saída'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Data partida'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Banco de horas'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Entrar férias anuais'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Licença restante'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Detalhes do funcionário'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Informação básica'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Situação familiar'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Escolha o status da família'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Tipo de Emprego'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Selecione o tipo de emprego'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Digite a cidade'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Província'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Digite a Província'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Insira o endereço'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Digite o código postal'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Código postal'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Taxa horária'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Insira a taxa por hora'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Salário básico'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Insira o salário base'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Mídia social'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skype'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Enter Skype'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Enter Facebook'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Enter WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Enter LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Enter Twitter'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Experiências'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'conta bancária'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'nome da empresa'), _defineProperty(_Receipt$Pos_Settings, "Location", 'Location'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Enter location'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Enter Description'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Nome do banco'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Digite o nome do banco'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Agência bancária'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Entrar na agência bancária'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Número do banco'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Digite o número do banco'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Acessar armazéns'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'Melhores clientes'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Acessório'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'ver funcionário'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'Editar funcionário'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'Excluir funcionário'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Adicionado por'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Adicionar IMEI/Número de Série do produto'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'O Produto Tem Imei/Número de Série'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'Remessos'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Entregue a'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Referência de remessa'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Referência de venda'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Editar envio'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Embalado'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Enviado'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Entregue'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Cancelado'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Status de envio'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Relatório de usuários'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'Relatório de Estoque'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total de Compras'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Cotações totais'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Vendas totais de retorno'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Total de compras de devolução'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Transferências totais'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Ajustes totais'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'Relatório do usuário'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Estoque atual'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'Nome do Produto'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Dívida total'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Dívida total'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Alguns Armazéns'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'Todos os Armazéns'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Custo do produto'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'Configurações de SMS'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'Configurações de PDV'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Gateway de pagamento'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'Configurações de e-mail'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Gateway de SMS padrão'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Configurações do módulo'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Módulo ativado com sucesso'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Módulo desativado com sucesso'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Melhoria'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Por favor, carregue o módulo correto'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Enviado com sucesso'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'Detalhes do cliente'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Editar cliente'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Excluir cliente'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'Pagamento devido'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'O valor do pagamento é maior que o total devido'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Fatura do cliente'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'Este Produto Não Para Venda'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Bem-vindo ao seu painel'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Total a pagar'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Escolher referência de venda'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Selecione a venda'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Referência de venda'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'Listar devoluções de produtos'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'Devolução de quantidade'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Escolha a referência de compra'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Referência de compra'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Por favor selecione a compra'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'O retorno da quantidade é maior que a quantidade comprada'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'O retorno da quantidade é maior que a quantidade vendida'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Quantidade vendida'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Quantidade comprada'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Nome do remetente'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'O módulo deve ser carregado como arquivo zip'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Módulo de upload'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Todos os módulos instalados'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Versão Atual'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'Você já tem a versão mais recente'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Atualização disponível'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Atualizar registro'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Atualizar agora'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'Visualizar registro de alteração'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'NOTA: Aguarde até que a atualização termine completamente. Não é recomendado fechar o navegador ou parar um processo Upgrade'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Nota: Certifique-se de fazer backup de sua versão atual e banco de dados antes de executar a atualização, para restaurá-la se houver um erro'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Rodapé da fatura'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Fuso horário'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'Notas de pagamento'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'Notas de venda'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Venda total devida'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Dívida Total de Devolução de Venda'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'pagar todas as dívidas de venda de uma só vez'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'pagar todas as dívidas de retorno de venda de uma só vez'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Lucro bruto'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'pagar todas as dívidas de compra de uma só vez'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Excluir provedor'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Editar provedor'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Detalhes do provedor'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Dívida total de compra'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Nota de crédito'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Nota de crédito'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Vender Devolução'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Devolução de compra'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Número fiscal'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Adicione a quantidade de devolução'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'O retorno existe para a transação'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'Qtde retorno é maior que Quantidade Restante'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Quaisquer produtos com uma quantidade definida como 0 não serão reembolsados'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'pagar todas as dívidas de devolução de compra de uma só vez'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Dívida total de devolução de compra'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Dívida de devolução de compra'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'dívida de retorno de venda'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'Relatório do produto'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'relatório de vendas de produtos'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'Relatório de compras de produtos'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'quantidade vendida'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'quantidade comprada'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Filtrar por armazém'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Imprimir fatura automaticamente'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'Mostrar armazém'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Informações do cartão de crédito'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Informações do cartão de crédito salvas'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Cartão de crédito alterado com sucesso'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Modelo de notificação'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'Notificação por e-mail'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'Notificação por SMS'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Alterar detalhes do produto'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'Editar impostos, descontos e envio'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Criar cotação com estoque'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Nome da variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Custo da variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Preço da variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Código da variante'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Por favor, aguarde até que o produto seja carregado'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Escolha um gateway SMS'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Notificação para o cliente'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Tags disponíveis'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'Assunto do e-mail'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'Corpo do e-mail'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Notificação para o fornecedor'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'Corpo do SMS'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'Modelos de SMS'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Modelos de e-mail'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/da.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/da.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
// Danish language

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Kvittering',
  Pos_Settings: 'POS-indstillinger (kvittering)',
  Note_to_customer: 'Bemærkning til kunden',
  Show_Note_to_customer: 'Vis bemærkning til kunden',
  Show_barcode: 'Vis stregkode',
  Show_Tax_and_Discount: 'Vis moms & rabat & levering',
  Show_Customer: 'Vis kunde',
  Show_Email: 'Vis e-mail',
  Show_Phone: 'Vis telefon',
  Show_Address: 'Vis adresse',
  DefaultLanguage: 'Standardsprog',
  footer: 'footer',
  Received_Amount: 'Modtaget beløb',
  Paying_Amount: 'Betalingsbeløb',
  Change: 'Retur',
  Paying_amount_is_greater_than_Received_amount: 'Betalingsbeløb er større end modtaget beløb',
  Paying_amount_is_greater_than_Grand_Total: 'Betalingsbeløb er større end det samlede beløb',
  code_must_be_not_exist_already: 'koden skal ikke eksistere allerede',
  You_will_find_your_backup_on: 'Du finder din sikkerhedskopi på',
  and_save_it_to_your_pc: 'og gem det på din pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scan din stregkode og vælg den korrekte symbologi nedenfor',
  Scan_Search_Product_by_Code_Name: 'Scan / Søg produkt ved kode eller navn',
  Paper_size: 'Papirstørrelse',
  Clear_Cache: 'Ryd cache',
  Cache_cleared_successfully: 'Cache ryddet med succes',
  Failed_to_clear_cache: 'Mislykkedes i at rydde cache',
  Scan_Barcode: 'Stregkode-scanner',
  Please_use_short_name_of_unit: 'Brug venligst en kort navneform for enheden',
  DefaultCustomer: 'Standardkunde',
  DefaultWarehouse: 'Standardlager',
  Payment_Gateway: 'Betalings-gateway',
  SMS_Configuration: 'SMS-konfiguration',
  Gateway: 'SMS-gateway',
  Choose_Gateway: 'Vælg SMS-gateway',
  Send_SMS: 'Besked sendt med succes',
  sms_config_invalid: 'forkert sms-konfig invalid',
  Remove_Stripe_Key_Secret: 'Slet Stripe API-nøgler',
  credit_card_account_not_available: 'Kreditkortkonto ikke tilgængelig',
  Credit_Card_Info: 'Kreditkort-oplysninger',
  developed_by: 'Udviklet af',
  Unit_already_linked_with_sub_unit: 'Unit already linked with sub unit',
  Total_Items_Quantity: 'Antal varer og mængde',
  Value_by_Cost_and_Price: 'Værdi efter omkostninger og pris',
  Search_this_table: 'Søg i denne tabel',
  import_products: 'Importere produkter',
  Field_optional: 'Valgfri felt',
  Download_exemple: 'Download eksempel',
  field_must_be_in_csv_format: 'Feltet skal være i csv-format',
  Successfully_Imported: 'Importeret med succes',
  file_size_must_be_less_than_1_mega: 'Filstørrelsen skal være mindre end 1 mega',
  Please_follow_the_import_instructions: 'Følg venligst importvejledningen',
  must_be_exist: 'enheden skal allerede være oprettet',
  Import_Customers: 'Importere kunder',
  Import_Suppliers: 'Importere leverandører',
  Recent_Sales: 'Seneste salg',
  Create_Transfer: 'Opret overførsel',
  order_products: 'Bestil varer',
  Search_Product_by_Code_Name: 'Søg efter produkt ved kode eller navn',
  Reports_payments_Purchase_Return: 'Rapporter købsreturbetalinger',
  Reports_payments_Sale_Return: 'Rapporter salgsreturbetalinger',
  payments_Sales_Return: 'Betalinger salgsreturnering',
  payments_Purchases_Return: 'Betalinger købsreturnering',
  CreateSaleReturn: 'Opret salgsreturnering',
  EditSaleReturn: 'Rediger salgsreturnering',
  SalesReturn: 'Salgsreturnering',
  CreatePurchaseReturn: 'Opret købsreturnering',
  EditPurchaseReturn: 'Rediger købsreturnering',
  PurchasesReturn: 'Købsreturnering',
  Due: 'Forfalden',
  Profit: 'Profit',
  Revenue: 'Indtægt',
  Sales_today: 'Dagens salg',
  People: 'Mennesker',
  Successfully_Created: 'Oprettet med succes',
  Successfully_Updated: 'Opdateret med succes',
  Success: 'Succes',
  Failed: 'Mislykkedes',
  Warning: 'Advarsel',
  Please_fill_the_form_correctly: 'Udfyld venligst formularen korrekt',
  Field_is_required: 'Dette felt er påkrævet',
  Error: 'Fejl!',
  you_are_not_authorized: 'Beklager! Du har ikke adgang.',
  Go_back_to_home: 'Gå tilbage til hjemmesiden',
  page_not_exist: 'Beklager! Siden du ledte efter eksisterer ikke.',
  Choose_Status: 'Vælg status',
  Choose_Method: 'Vælg metode',
  Choose_Symbology: 'Vælg symbolik',
  Choose_Category: 'Vælg kategori',
  Choose_Customer: 'Vælg kunde',
  Choose_Supplier: 'Vælg leverandør',
  Choose_Unit_Purchase: 'Vælg købsenhed',
  Choose_Sub_Category: 'Vælg underkategori',
  Choose_Brand: 'Vælg mærke',
  Choose_Warehouse: 'Vælg lager',
  Choose_Unit_Sale: 'Vælg salgsenhed',
  Enter_Product_Cost: 'Indtast produktomkostninger',
  Enter_Stock_alert: 'Indtast lageradvarsler',
  Choose_Unit_Product: 'Vælg produktenhed',
  Enter_Product_Price: 'Indtast produktpris',
  Enter_Name_Product: 'Indtast produktnavn',
  Enter_Role_Name: 'Indtast rolle navn',
  Enter_Role_Description: 'Indtast rolle beskrivelse',
  Enter_name_category: 'Indtast kategorinavn',
  Enter_Code_category: 'Indtast kategorikode',
  Enter_Name_Brand: 'Indtast mærkenavn',
  Enter_Description_Brand: 'Indtast mærkebeskrivelse',
  Enter_Code_Currency: 'Indtast valutakode',
  Enter_name_Currency: 'Indtast valutanavn',
  Enter_Symbol_Currency: 'Indtast valutasymbol',
  Enter_Name_Unit: 'Indtast enhedsnavn',
  Enter_ShortName_Unit: 'Indtast kort navn for enhed',
  Choose_Base_Unit: 'Vælg grundenhed',
  Choose_Operator: 'Vælg operatør',
  Enter_Operation_Value: 'Indtast operationens værdi',
  Enter_Name_Warehouse: 'Indtast lager navn',
  Enter_Phone_Warehouse: 'Indtast lager telefon',
  Enter_Country_Warehouse: 'Indtast lager land',
  Enter_City_Warehouse: 'Indtast lager by',
  Enter_Email_Warehouse: 'Indtast lager email',
  Enter_ZipCode_Warehouse: 'Indtast lager postnummer',
  Choose_Currency: 'Vælg valuta',
  Thank_you_for_your_business: 'Tak fordi du shoppede hos os. Kom igen',
  Cancel: 'Annuller',
  New_Customer: 'Ny kunde',
  Incorrect_Login: 'Forkert login',
  Successfully_Logged_In: 'Du er nu logget ind',
  This_user_not_active: 'Denne bruger er ikke aktiv',
  SignIn: 'Log ind',
  Create_an_account: 'Opret en konto',
  Forgot_Password: 'Glemt adgangskode?',
  Email_Address: 'E-mailadresse',
  SignUp: 'Tilmeld dig',
  Already_have_an_account: 'Har du allerede en konto?',
  Reset_Password: 'Nulstil adgangskode',
  Failed_to_authenticate_on_SMTP_server: 'Det lykkedes ikke at godkende på SMTP-server',
  We_cant_find_a_user_with_that_email_addres: 'Vi kan ikke finde en bruger med den e-mail-adresse',
  We_have_emailed_your_password_reset_link: 'Vi har sendt en e-mail med din link til nulstilling af adgangskode',
  Please_fill_the_Email_Adress: 'Udfyld venligst e-mail-adressen',
  Confirm_password: 'Bekræft adgangskode',
  Your_Password_has_been_changed: 'Din adgangskode er blevet ændret',
  The_password_confirmation_does_not_match: 'Bekræftelse af adgangskode passer ikke',
  This_password_reset_token_is_invalid: 'Token til nulstilling af adgangskode er ugyldig',
  Warehouse_report: 'Lagerrapport',
  All_Warehouses: 'Alle lagre',
  Expense_List: 'Alle udgifter',
  Expenses: 'Udgifter',
  This_Week_Sales_Purchases: 'Denne uges salg & køb',
  Top_Selling_Products: 'Top sælgende produkter',
  View_all: 'Vis alle',
  Payment_Sent_Received: 'Betaling sendt & modtaget',
  Filter: 'Filter',
  Invoice_POS: 'Faktura POS',
  Invoice: 'Faktura',
  Customer_Info: 'Kundeinfo',
  Company_Info: 'Firmainfo',
  Invoice_Info: 'Fakturainfo',
  Order_Summary: 'Ordreoversigt',
  Quote_Info: 'Tilbudsinfo',
  Del: 'Slet',
  SuppliersPaiementsReport: 'Rapport over leverandørbetalinger',
  Purchase_Info: 'Købsinfo',
  Supplier_Info: 'Leverandørinfo',
  Return_Info: 'Info om returnering',
  Expense_Category: 'Udgiftkategori',
  Create_Expense: 'Opret udgift',
  Details: 'Detaljer',
  Discount_Method: 'Rabattype',
  Net_Unit_Cost: 'Netto enhedskost',
  Net_Unit_Price: 'Netto enhedspris',
  Edit_Expense: 'Rediger udgift',
  All_Brand: 'Alle mærker',
  All_Category: 'Alle kategorier',
  ListExpenses: 'Alle udgifter',
  Create_Permission: 'Opret tilladelse',
  Edit_Permission: 'Rediger tilladelse',
  Reports_payments_Sales: 'Rapporter betalinger Salg',
  Reports_payments_Purchases: 'Rapporter betalinger Køb',
  Reports_payments_Return_Customers: 'Betalingsretur kunder',
  Reports_payments_Return_Suppliers: 'Betalingsretur leverandører',
  Expense_Deleted: 'Denne udgift er blevet slettet',
  Expense_Updated: 'Denne udgift er blevet opdateret',
  Expense_Created: 'Denne udgift er blevet oprettet',
  DemoVersion: 'Du kan ikke gøre dette i demo-versionen',
  OrderStatistics: 'Salgsstatistikker',
  AlreadyAdd: 'Dette produkt er allerede tilføjet !!',
  AddProductToList: 'Tilføj venligst produkt til liste !!',
  AddQuantity: 'Tilføj venligst mængde af produkt !!',
  InvalidData: 'Ugyldige data !!',
  LowStock: 'Antallet overstiger antallet, der er tilgængeligt på lageret',
  WarehouseIdentical: 'De to lagre kan ikke være identiske !!',
  VariantDuplicate: 'Denne variant er en duplikat !!',
  Filesize: 'Filstørrelse',
  GenerateBackup: 'Generer sikkerhedskopi',
  BackupDatabase: 'Sikkerhedskopier database',
  Backup: 'Sikkerhedskopi',
  Paid: 'Betalt',
  Unpaid: 'Ubetalte',
  Today: 'I dag',
  Income: 'Indtægt'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'Udgifter'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'Salg'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Aktiv'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Inaktiv'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'Kunder'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Telefon'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Søg efter telefonnummer'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Leverandører'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Tilbud'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'Salg'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'Køb'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'Returnering'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'Indstillinger'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'Systemindstillinger'), _defineProperty(_Receipt$Pos_Settings, "Users", 'Brugere'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Gruppe tilladelser'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'Valuta'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'Lager'), _defineProperty(_Receipt$Pos_Settings, "Units", 'Enhed'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'Køb enheder'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Salg enheder'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'Rapporter'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Betalingsrapport'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Betalinger køb'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Betalinger salg'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Fortjeneste og tab'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Lagerbeholdningsoversigt'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'Salgsrapport'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Købsrapport'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'Kunderapport'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Leverandørrapport'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Leverandørrapport'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'Daglige salgsdata'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'Daglige købsdata'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Sidste fem poster'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'Filtre'), _defineProperty(_Receipt$Pos_Settings, "date", 'Dato'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Reference'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Leverandør'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Betalingsstatus'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'Kunde'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'Kundekode'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Status'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Leverandørkode'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Kategori'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'Kategorier'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'Overførsel'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Lagerstyring'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Dashboard'), _defineProperty(_Receipt$Pos_Settings, "Products", 'Produkter'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'Alle produkter'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Produktstyring'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Produktmængdealarmer'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Produktkode'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Produktmoms'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'Underkategori'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'Navn'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Lageralarm'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'Lager'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'Moms'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Indkøbspris'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Salgspris'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'Mængde'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Salgsenhed'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'Indkøbsenhed'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Valutastyring'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Valutakode'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Valutanavn'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Symbol'), _defineProperty(_Receipt$Pos_Settings, "All", 'Alle'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Rediger produkt'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Søg efter kode'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Søg efter navn'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Produktdetaljer'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'Kundenavn'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Kundestyring'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Opret'), _defineProperty(_Receipt$Pos_Settings, "add", 'Opret'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'Rediger'), _defineProperty(_Receipt$Pos_Settings, "Close", 'Luk'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Vælg venligst'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Handling'), _defineProperty(_Receipt$Pos_Settings, "Email", 'E-mail'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Rediger kunde'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Opret kunde'), _defineProperty(_Receipt$Pos_Settings, "Country", 'Land'), _defineProperty(_Receipt$Pos_Settings, "City", 'By'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Adresse'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'Kundedetaljer'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Kunder'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'Leverandørnavn'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Leverandørstyring'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Leverandørdetaljer'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Tilbudsstyring'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Leverandørkode'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Subtotal'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Beløb tilbage'), _defineProperty(_Receipt$Pos_Settings, "complete", 'Fuldført'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'Afventer'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Modtaget'), _defineProperty(_Receipt$Pos_Settings, "partial", 'Delvist'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Returneret'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Detaljeret tilbud'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Rediger tilbud'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Opret salg'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'Download PDF'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'Send tilbud på e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Slet tilbud'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'Opret tilbud'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Vælg produkt'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Produkt (Kode - Navn)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Pris'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'Lagerbeholdning'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Total'), _defineProperty(_Receipt$Pos_Settings, "Num", 'Nr.'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Enhedsomkostninger'), _defineProperty(_Receipt$Pos_Settings, "to", 'Til'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Emne'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Besked'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'E-mail kunde'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Sendt'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'Tilbud'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Hej'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Vedhæftning af tilbud'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Tilføj produkter til ordreliste'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Vælg venligst lager'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'Vælg venligst kunde'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Salgsstyring'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Balance'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Antal tilbage'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Total returnering'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'Beløb'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Salgsdetaljer'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Rediger salg'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Opret salg'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Vis betalinger'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'Opret betaling'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Rediger betaling'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Send salg pr. e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Slet salg'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Betalingsmåde'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Betalingstype'), _defineProperty(_Receipt$Pos_Settings, "Note", 'Bemærkning'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Betaling fuldført!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Indkøbsstyring'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Bestilt'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Slet køb'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Send køb pr. e-mail'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'Rediger køb'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'Købsdetaljer'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Opret køb'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'Leverandør e-mail'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Indkøbsbetalinger'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Data om indkøbsbetalinger'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'Salgsbetalinger'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Data om salgsbetalinger'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'Brugerstyring'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'Fornavn'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'Efternavn'), _defineProperty(_Receipt$Pos_Settings, "username", 'Brugernavn'), _defineProperty(_Receipt$Pos_Settings, "password", 'Adgangskode'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'Ny adgangskode'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Skift avatar'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Lad dette felt være blankt, hvis du ikke har ændret det'), _defineProperty(_Receipt$Pos_Settings, "type", 'Type'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Brugerrettigheder'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Rolle'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Rollebeskrivelse'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Opret rettigheder'), _defineProperty(_Receipt$Pos_Settings, "View", 'Vis'), _defineProperty(_Receipt$Pos_Settings, "Del", 'Slet'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'Nye justeringer'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Rediger justeringer'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'Du kan ikke trække produkter fra med en lagerbeholdning på 0'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'Tilføjelse'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Fratrækning'), _defineProperty(_Receipt$Pos_Settings, "profil", 'Profil'), _defineProperty(_Receipt$Pos_Settings, "logout", 'Log ud'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'Du kan ikke ændre dette, da købet allerede er betalt'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'Du kan ikke ændre dette, da salget allerede er betalt'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'Du kan ikke ændre dette, da returneringen allerede er betalt'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'Dette tilbud har allerede genereret et salg'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'Opret produkt'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'Dette tilbud er færdigt'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Webstedsopsætning'), _defineProperty(_Receipt$Pos_Settings, "Language", 'Sprog'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Standardvaluta'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Login Captcha'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'Standard-email'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Webstedsnavn'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Skift logo'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'SMTP-opsætning'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'MAIL_HOST'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'MAIL_PORT'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'MAIL_ENCRYPTION'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'SMTP-opsætning er forkert'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Betaling og returnering'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'Returner fakturaer'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'Data for returnerede fakturaer'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'Vis alle poster for alle brugere'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Rabat'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Moms'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'Forsendelse'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Firmanavn'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Firmaets telefon'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Firmaadresse'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Kode'), _defineProperty(_Receipt$Pos_Settings, "image", 'Billede'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Udskriv etiketter'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Kundeafkast'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Leverandørafkast'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'Faktura for kundeaftale'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Faktura for leverandøraftale'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'Ingen data tilgængelige'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'Produktbillede'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'Stregkode'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'Salgssted'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Brugerdefineret upload'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'Salgsstedshåndtering'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Justering'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Opdater'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Nulstil'), _defineProperty(_Receipt$Pos_Settings, "print", 'Udskriv'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Søg efter e-mail'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Vælg produkt'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Antal'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Varer'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Beløb ekskl. moms'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'Beløb inkl. moms'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Vælg venligst leverandør'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Vælg venligst status'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'Betalt af'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Vælg lager'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'Betal nu'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'Liste over kategorier'), _defineProperty(_Receipt$Pos_Settings, "Description", 'Beskrivelse'), _defineProperty(_Receipt$Pos_Settings, "submit", 'Indsend'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'Der opstod et problem med at oprette denne faktura. Prøv igen'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'Der opstod et problem med betalingen. Prøv igen.'), _defineProperty(_Receipt$Pos_Settings, "IncomeExpenses", 'Indtægter og Udgifter'), _defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Daglige Salg og Køb'), _defineProperty(_Receipt$Pos_Settings, "ProductsExpired", 'Udløbne Produkter'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'Mærker'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'Opret Justering'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'Et par ord ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'Bruger Billede'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Opdater Produkt'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'Mærke'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'Stregkodesymbolik'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'Produktomkostninger'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Produktpris'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'Produktenhed'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'Momstype'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'Flere Billeder'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'Dette produkt har flere varianter'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'Produktet har en kampagne'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Kampagnen starter'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Kampagnen slutter'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Kampagnepris'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Pris'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'Omkostninger'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'Enhed'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'Produktvariant'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'Variant'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Enhedspris'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'Opret Tilbagevendende Kunde'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Rediger Tilbagevendende Kunde'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'Opret Tilbagevendende Leverandør'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'Dokumentation'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'Rediger Tilbagevendende Leverandør'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Fra Lager'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'Til Lager'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'Rediger Overførsel'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'Overførselsdetaljer'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'Afventer'), _defineProperty(_Receipt$Pos_Settings, "Received", 'Modtaget'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Bestilt'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'Rettigheder'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'Mærke'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'Mærke Billede'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'Mærke Navn'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'Mærke Beskrivelse'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'Basisenhed'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'Enhedshåndtering'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Operation Værdi'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'Operatør'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'Top 5 Produkter'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'Sidste 5 Salg'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'Alle Justeringer'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'Alle Overførsler'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Opret Overførsel'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'Ordre Håndtering'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'Alle Tilbud'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'Alle Køb'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'Alle Salg'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'Alle Returneringer'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'Personhåndtering'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Titel: 'Er du sikker?',
  Tekst: 'Du kan ikke fortryde dette!',
  confirmButtonText: 'Ja, slet det!',
  cancelButtonText: 'Annuller',
  Slettet: 'Slettet!',
  Mislykkedes: 'Mislykkedes!',
  DerVarNogetGalt: 'Der var noget galt',
  KundeSlettet: 'Denne kunde er blevet slettet.',
  LeverandørSlettet: 'Denne leverandør er blevet slettet.',
  TilbudsSlettet: 'Dette tilbud er blevet slettet.',
  SalgSlettet: 'Dette salg er blevet slettet.',
  BetalingSlettet: 'Denne betaling er blevet slettet.',
  KøbSlettet: 'Dette køb er blevet slettet.',
  ReturneringSlettet: 'Denne returnering er blevet slettet.',
  ProduktSlettet: 'Dette produkt er blevet slettet.',
  KundeFejl: 'Denne kunde er allerede tilknyttet en anden operation',
  LeverandørFejl: 'Denne leverandør er allerede tilknyttet en anden operation',
  BrugerSlettet: 'Denne bruger er blevet slettet.',
  EnhedSlettet: 'Denne enhed er blevet slettet.',
  RolleSlettet: 'Denne rolle er blevet slettet.',
  SkatSlettet: 'Denne skat er blevet slettet.',
  UnderkategoriSlettet: 'Denne underkategori er blevet slettet.',
  KategoriSlettet: 'Denne kategori er blevet slettet.',
  LagerSlettet: 'Dette lager er blevet slettet.',
  AlleredeTilknyttet: 'Dette produkt er allerede tilknyttet en anden operation',
  JusteringSlettet: 'Denne justering er blevet slettet.',
  ValutaTitel: 'Denne valuta er blevet slettet.',
  Overførselstitel: 'Overførslen er blevet fjernet med succes',
  BackupSlettet: 'Backup er blevet fjernet med succes',
  MærkeTitel: 'Dette mærke er blevet slettet'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleBrand: 'Dette brand er blevet opdateret',
  TitleProfile: 'Din profil er blevet opdateret succesfuldt',
  TitleAdjust: 'Justering er blevet opdateret succesfuldt',
  TitleRole: 'Rolle er blevet opdateret succesfuldt',
  TitleUnit: 'Enhed er blevet opdateret succesfuldt',
  TitleUser: 'Bruger er blevet opdateret succesfuldt',
  TitleCustomer: 'Kunde er blevet opdateret succesfuldt',
  TitleQuote: 'Tilbud er blevet opdateret succesfuldt',
  TitleSale: 'Salg er blevet opdateret succesfuldt',
  TitlePayment: 'Betaling er blevet opdateret succesfuldt',
  TitlePurchase: 'Køb er blevet opdateret succesfuldt',
  TitleReturn: 'Returnering er blevet opdateret succesfuldt',
  TitleProduct: 'Produkt er blevet opdateret succesfuldt',
  TitleSupplier: 'Leverandør er blevet opdateret succesfuldt',
  TitleTaxe: 'Skat er blevet opdateret succesfuldt',
  TitleCat: 'Kategori er blevet opdateret succesfuldt',
  TitleWarhouse: 'Lager er blevet opdateret succesfuldt',
  TitleSetting: 'Indstillinger er blevet opdateret succesfuldt',
  TitleCurrency: 'Valuta er blevet opdateret succesfuldt',
  TitleTransfer: 'Overførsel er blevet opdateret succesfuldt'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'Dette brand er blevet oprettet',
  TitleRole: 'Rolle er blevet oprettet succesfuldt',
  TitleUnit: 'Enhed er blevet oprettet succesfuldt',
  TitleUser: 'Bruger er blevet oprettet succesfuldt',
  TitleCustomer: 'Kunde er blevet oprettet succesfuldt',
  TitleQuote: 'Tilbud er blevet oprettet succesfuldt',
  TitleSale: 'Salg er blevet oprettet succesfuldt',
  TitlePayment: 'Betaling er blevet oprettet succesfuldt',
  TitlePurchase: 'Køb er blevet oprettet succesfuldt',
  TitleReturn: 'Returnering er blevet oprettet succesfuldt',
  TitleProduct: 'Produkt er blevet oprettet succesfuldt',
  TitleSupplier: 'Leverandør er blevet oprettet succesfuldt',
  TitleTaxe: 'Skat er blevet oprettet succesfuldt',
  TitleCat: 'Kategori er blevet oprettet succesfuldt',
  TitleWarhouse: 'Lager er blevet oprettet succesfuldt',
  TitleAdjust: 'Justering er blevet oprettet succesfuldt',
  TitleCurrency: 'Valuta er blevet oprettet succesfuldt',
  TitleTransfer: 'Overførsel er blevet oprettet succesfuldt'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'E-mail Sendt'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'Dette salg er allerede forbundet med en retur!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'Returhåndtering'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Returdetaljer'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'Rediger Retur'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'Opret Retur'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'Send Retur på E-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Slet Retur'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'Returgebyr'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'Levering'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Vælg Salg'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'Du kan slette varen eller sætte antallet returneret til nul, hvis den ikke er returneret'), _defineProperty(_Receipt$Pos_Settings, "Return", 'Retur'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'Køb'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'Total Salg'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total Køb'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'Total Retur'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'Netto Betalinger'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'Betalinger Sendt'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'Betalinger Modtaget'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'Modtaget'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Sendt'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Advarsler om Produktmængde'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Kode'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'Produkt'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'Advarsel Mængde'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Lageroversigt for Lager'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'Total Produkter'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'Total Mængde'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'Top 5 Kunder'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Total Beløb'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'Total Betalt'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'Rapport for Kundefordring'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Rapport for Kundebetalinger'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'Rapport for Kundetilbud'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'Betalinger'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'Top 5 Leverandører'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'Rapport for Leverandørkøb'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'Rapport for Leverandørbetalinger'), _defineProperty(_Receipt$Pos_Settings, "Name", 'Navn'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Kode'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'Lagerstyring'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'Postnummer'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Kategori styring'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'Kategori Kode'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'Kategori Navn'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'Overordnet Kategori'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'Skatte styring'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'Skatte Navn'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'Skatte Sats'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Indkøbsenhed'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'Salgsenhed'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'Kort Navn'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Vælg venligst disse før du tilføjer et produkt'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'Lagerjustering'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'Vælg venligst lager før du vælger et produkt'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'Lageroverførsel'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'Vælg Periode'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'Dette År'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'I Dag'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Denne Måned'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'Denne Uge'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'Justering Detaljer'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'Brugeren er blevet aktiveret'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'Brugeren er blevet deaktiveret'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'Siden kunne ikke findes.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'Ups! Siden blev ikke fundet.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'Vi kunne ikke finde den side, du ledte efter. Imens kan du'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'vende tilbage til oversigten'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'HRM'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'Medarbejdere'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'Tilstedeværelse'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Anmodning om orlov'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Orlovstype'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Virksomhed'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Afdelinger'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'Designationer'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Arbejdstid'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Ferie'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Indtast firmanavn'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Indtast e-mailadresse'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Indtast virksomhedstelefon'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Indtast land for virksomheden'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Oprettet med succes'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Opdateret med succes'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Slettet med succes'), _defineProperty(_Receipt$Pos_Settings, "department", 'Afdeling'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Indtast afdelingsnavn'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Vælg virksomhed'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Afdelingsleder'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Vælg afdelingsleder'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Indtast vagtnavn'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Mandag start'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Mandag slut'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tirsdag start'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'Tirsdag slut'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Onsdag start'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Onsdag slut'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Torsdag start'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Torsdag slut'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Fredag start'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Fredag slut'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Lørdag start'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Lørdag slut'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Søndag start'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Søndag slut'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'Ferie'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Indtast titel'), _defineProperty(_Receipt$Pos_Settings, "title", 'Titel'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Startdato'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Indtast startdato'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Slutdato'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Indtast slutdato'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Giv venligst nogle detaljer'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'Tilstedeværelser'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Indtast tilstedeværelsesdato'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Tid ind'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Tid ud'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'Vælg medarbejder'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'Medarbejder'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Arbejdstid'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'Resterende orlov er utilstrækkeligt'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Orlovstype'), _defineProperty(_Receipt$Pos_Settings, "Days", 'Dage'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Afdeling'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Vælg fraværstype'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'Vælg status'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Fraværsårsag'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Indtast fraværsårsag'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Tilføj medarbejder'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'Fornavn'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Indtast fornavn'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Efternavn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Indtast efternavn'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Køn'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Vælg køn'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Indtast fødselsdato'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Fødselsdato'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Indtast land'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Indtast telefonnummer'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Indtrædelsesdato'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Indtast indtrædelsesdato'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'Vælg stilling'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'Stilling'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Kontor skift'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Vælg kontor skift'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Indtast fratrædelsesdato'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Fratrædelsesdato'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Årligt fravær'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Indtast årligt fravær'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Resterende fravær'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Medarbejderoplysninger'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Grundlæggende oplysninger'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Familie status'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Vælg familie status'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Ansættelsestype'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Vælg ansættelsestype'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Indtast by'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Region'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Indtast region'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Indtast adresse'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Indtast postnummer'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Postnummer'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Timeløn'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Indtast timeløn'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Grundløn'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Indtast grundløn'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Sociale medier'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skype'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Indtast Skype'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Indtast Facebook'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Indtast WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Indtast LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Indtast Twitter'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Erfaringer'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'Bankkonto'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Firmanavn'), _defineProperty(_Receipt$Pos_Settings, "Location", 'Placering'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Indtast placering'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Indtast beskrivelse'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Banknavn'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Indtast banknavn'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Bankfilial'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Indtast bankfilial'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Banknummer'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Indtast banknummer'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Adgang til lagre'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'Bedste kunder'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Vedhæftning'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'Se medarbejder'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'Rediger medarbejder'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'Slet medarbejder'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Tilføjet af'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Tilføj produkt IMEI/serienummer'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'Produkt har IMEI/serienummer'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'Forsendelser'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Leveret til'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Forsendelsesreferance'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Salgsreferance'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Rediger forsendelse'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Pakket'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Afsendt'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Leveret'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Annulleret'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Forsendelsesstatus'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Bruger rapport'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'Lager rapport'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Samlede indkøb'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Samlede tilbud'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Samlet tilbagesalg'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Samlet tilbagekøb'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Samlede overførsler'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Samlede justeringer'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'Brugerrapport'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Nuværende lagerbeholdning'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'Produktnavn'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Total gæld (kunder)'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Total gæld (leverandører)'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Nogle lagre'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'Alle lagre'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Produktomkostninger'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'SMS-indstillinger'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'POS-indstillinger'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Betalingsgateway'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'Mail-indstillinger'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Standard-SMS-gateway'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Modulindstillinger'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Modul aktiveret med succes'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Modul deaktiveret med succes'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Opdatering'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Upload venligst det korrekte modul'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Uploadet med succes'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'Kundedetaljer'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Rediger kunde'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Slet kunde'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'Betal skyld'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'Betalt beløb er større end samlet skyld'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Kundefaktura'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'Dette produkt er ikke til salg'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Velkommen til dit kontrolpanel'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Total betalbart'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Vælg salgsreference'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Vælg venligst salg'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Salgsreference'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'Liste over produktreturneringer'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'Antal returner'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Vælg købsreference'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Købsreference'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Vælg venligst køb'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'Antal returneringer er større end antal købt'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'Antal returneringer er større end antal solgt'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Antal solgt'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Antal købt'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Afsenderens navn'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'Modulet skal uploades som en zip-fil'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Upload modul'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Alle moduler installeret'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Nuværende version'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'Du har allerede den nyeste version'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Opdatering tilgængelig'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Opdateringslog'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Opdater nu'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'Se ændringslog'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'BEMÆRK: Vent venligst, indtil opdateringen er fuldstændig færdig. Det anbefales ikke at lukke browseren eller stoppe en opgraderingsproces'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Bemærk: Sørg for at tage en sikkerhedskopi af din nuværende version og database, inden du kører opgraderingen, så du kan gendanne det, hvis der opstår en fejl'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Faktura fodnote'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Tidszone'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'Betalingsnoter'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'Salgsnoter'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Totalt salg skyldigt'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Totalt salgsretur skyldigt'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'Betal alle salg skyldige på én gang'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'Betal alle salgsretur skyldige på én gang'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Bruttogevinst'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'Betal alle købs skyldige på én gang'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Slet leverandør'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Rediger leverandør'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Leverandørdetaljer'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Totalt køb skyldigt'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Leverandør kreditnota'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Kunde kreditnota'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Salgsretur'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Købsretur'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'CVR-nummer'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Tilføj venligst antal returneringer'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'Der findes en returnering for transaktionen'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'Antal returneringer er større end resterende antal'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Eventuelle produkter med en mængde på 0 vil ikke blive refunderet'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'Betal alle købsretur skyldige på én gang'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Totalt købsretur skyldigt'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Købsretur skyldigt'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'Salgsreturnering skyldig'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'Produktrapport'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'Produktsalgsrapport'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'Produktkøbsrapport'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'Antal solgt'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Antal købt'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Filtrer efter lager'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Udskriv faktura automatisk'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Kreditkortoplysninger'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Gemte kreditkortoplysninger'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Kreditkort ændret med succes'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Notifikationsskabelon'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'E-mail notifikation'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'SMS notifikation'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Ændre produkt detaljer'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'Rediger skat, rabat og forsendelse'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Opret tilbud med lagerbeholdning'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Variantnavn'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Variantomkostninger'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Variantpris'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Variantkode'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Vent venligst indtil produktet er indlæst'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Vælg SMS-gateway'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Notifikation til kunden'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Tilgængelige tags'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'Emne i e-mail'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'E-mail indhold'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Notifikation til leverandøren'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'SMS indhold'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'SMS skabeloner'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Email skabeloner'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/de.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/de.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Allemand

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Erhalt',
  Pos_Settings: 'Pos-Einstellungen',
  Note_to_customer: 'Hinweis an den Kunden',
  Show_Note_to_customer: 'Hinweis für Kunden anzeigen',
  Show_barcode: 'Strichcode vorzeigen',
  Show_Tax_and_Discount: 'Steuern & Rabatt & Versand anzeigen',
  Show_Customer: 'Kunden anzeigen',
  Show_Email: 'E-Mail anzeigen',
  Show_Phone: 'Telefon anzeigen',
  Show_Address: 'Adresse anzeigen',
  DefaultLanguage: 'Standardsprache',
  footer: 'Fusszeile',
  Received_Amount: 'Erhaltener Betrag',
  Paying_Amount: 'Zahlungsbetrag',
  Change: 'Veränderung',
  Paying_amount_is_greater_than_Received_amount: 'Der Zahlungsbetrag ist höher als der erhaltene Betrag',
  Paying_amount_is_greater_than_Grand_Total: 'Der Zahlungsbetrag ist höher als die Gesamtsumme',
  code_must_be_not_exist_already: 'Code darf noch nicht vorhanden sein',
  You_will_find_your_backup_on: 'Sie finden Ihr Backup auf',
  and_save_it_to_your_pc: 'und speichere es auf deinem PC',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scannen Sie Ihren Barcode und wählen Sie unten die richtige Symbologie aus',
  Scan_Search_Product_by_Code_Name: 'Produkt nach Codename scannen/durchsuchen',
  Paper_size: 'Papier größe',
  Clear_Cache: 'Cache leeren',
  Cache_cleared_successfully: 'Cache erfolgreich geleert',
  Failed_to_clear_cache: 'Cache konnte nicht gelöscht werden',
  Scan_Barcode: 'Barcodelesegerät',
  Please_use_short_name_of_unit: 'Bitte verwenden Sie die Kurzbezeichnung der Einheit',
  DefaultCustomer: 'Standardkunde',
  DefaultWarehouse: 'Standardlager',
  Payment_Gateway: 'Zahlungs-Gateways',
  SMS_Configuration: 'SMS-Konfiguration',
  Gateway: 'Zahlungs-Gateways',
  Choose_Gateway: 'Wählen Sie Zahlungs-Gateways',
  Send_SMS: 'Nachricht erfolgreich gesendet',
  sms_config_invalid: 'falsche SMS-Konfiguration ungültig',
  Remove_Stripe_Key_Secret: 'Löschen Sie die Stripe-API-Schlüssel',
  credit_card_account_not_available: 'Kreditkartenkonto nicht verfügbar',
  Credit_Card_Info: 'Kreditkarteninformationen',
  developed_by: 'Entwickelt von',
  Unit_already_linked_with_sub_unit: 'Einheit bereits mit Untereinheit verbunden',
  Total_Items_Quantity: 'Gesamtartikel und Menge',
  Value_by_Cost_and_Price: 'Wert nach Kosten und Preis',
  Search_this_table: 'Durchsuchen Sie diese Tabelle',
  import_products: 'Produkte importieren',
  Field_optional: 'Feld optional',
  Download_exemple: 'Beispiel herunterladen',
  field_must_be_in_csv_format: 'Das Feld muss im CSV-Format vorliegen',
  Successfully_Imported: 'Erfolgreich importiert',
  file_size_must_be_less_than_1_mega: 'Die Dateigröße muss weniger als 1 Mega betragen',
  Please_follow_the_import_instructions: 'Bitte folgen Sie den Importanweisungen',
  must_be_exist: 'Einheit muss bereits angelegt sein',
  Import_Customers: 'Kunden importieren',
  Import_Suppliers: 'Lieferanten importieren',
  Recent_Sales: 'Letzte Verkäufe',
  Create_Transfer: 'Übertragung erstellen',
  order_products: 'Auftragspositionen',
  Search_Product_by_Code_Name: 'Suchen Sie das Produkt nach Code oder Name',
  Reports_payments_Purchase_Return: 'Meldet Kaufrückzahlungen',
  Reports_payments_Sale_Return: 'Berichte Verkauf Rückzahlungen',
  payments_Sales_Return: 'Zahlungen Verkäufe Rückgabe',
  payments_Purchases_Return: 'Zahlungen Einkäufe Rückgabe',
  CreateSaleReturn: 'Verkaufsrendite erstellen',
  EditSaleReturn: 'Verkaufsrückgabe bearbeiten',
  SalesReturn: 'Umsatzrendite',
  CreatePurchaseReturn: 'Kaufretoure erstellen',
  EditPurchaseReturn: 'Kaufretoure bearbeiten',
  PurchasesReturn: 'Käufe zurück',
  Due: 'fällig',
  Profit: 'Profitieren',
  Revenue: 'Einnahmen',
  Sales_today: 'Verkauf heute',
  People: 'Menschen',
  Successfully_Created: 'Erfolgreich erstellt',
  Successfully_Updated: 'Erfolgreich aktualisiert',
  Success: 'Erfolg',
  Failed: 'Gescheitert',
  Warning: 'Warnung',
  Please_fill_the_form_correctly: 'Bitte füllen Sie das Formular korrekt aus',
  Field_is_required: 'Feld ist erforderlich',
  Error: 'Error!',
  you_are_not_authorized: 'Es tut uns leid! Sie sind nicht berechtigt.',
  Go_back_to_home: 'Gehen Sie zurück zur Homepage',
  page_not_exist: 'Es tut uns leid! Die gesuchte Seite existiert nicht.',
  Choose_Status: 'Wählen Sie Status',
  Choose_Method: 'Wählen Sie Methode',
  Choose_Symbology: 'Wählen Sie Symbologie',
  Choose_Category: 'Kategorie auswählen',
  Choose_Customer: 'Wählen Sie Kunde',
  Choose_Supplier: 'Wählen Sie Lieferant',
  Choose_Unit_Purchase: 'Wählen Sie Kaufeinheit',
  Choose_Sub_Category: 'Wählen Sie Unterkategorie',
  Choose_Brand: 'Wählen Sie Marke',
  Choose_Warehouse: 'Wählen Sie Lager',
  Choose_Unit_Sale: 'Wählen Sie Verkaufseinheit',
  Enter_Product_Cost: 'Produktkosten eingeben',
  Enter_Stock_alert: 'Bestandswarnung eingeben',
  Choose_Unit_Product: 'Wählen Sie Produkteinheit',
  Enter_Product_Price: 'Produktpreis eingeben',
  Enter_Name_Product: 'Geben Sie den Namen Produkt ein',
  Enter_Role_Name: 'Geben Sie den Rollennamen ein',
  Enter_Role_Description: 'Geben Sie die Rollenbeschreibung ein',
  Enter_name_category: 'Geben Sie den Kategorienamen ein',
  Enter_Code_category: 'Geben Sie den Kategoriecode ein',
  Enter_Name_Brand: 'Geben Sie die Namensmarke ein',
  Enter_Description_Brand: 'Geben Sie Beschreibung Marke ein',
  Enter_Code_Currency: 'Geben Sie die Codewährung ein',
  Enter_name_Currency: 'Geben Sie den Namen Währung ein',
  Enter_Symbol_Currency: 'Geben Sie die Symbolwährung ein',
  Enter_Name_Unit: 'Geben Sie den Einheitennamen ein',
  Enter_ShortName_Unit: 'Geben Sie den Kurznamen Unit ein',
  Choose_Base_Unit: 'Wählen Sie Basiseinheit',
  Choose_Operator: 'Wählen Sie den Operator',
  Enter_Operation_Value: 'Geben Sie den Betriebswert ein',
  Enter_Name_Warehouse: 'Geben Sie den Lagernamen ein',
  Enter_Phone_Warehouse: 'Geben Sie das Lagertelefon ein',
  Enter_Country_Warehouse: 'Geben Sie das Lagerland ein',
  Enter_City_Warehouse: 'Geben Sie die Lagerstadt ein',
  Enter_Email_Warehouse: 'Geben Sie die Lager E-Mail ein',
  Enter_ZipCode_Warehouse: 'Geben Sie die Postleitzahl des Lagers ein',
  Choose_Currency: 'Währung wählen',
  Thank_you_for_your_business: 'Vielen Dank für Ihr Geschäft!',
  Cancel: 'Stornieren',
  New_Customer: 'Neukunde',
  Incorrect_Login: 'Falsche Anmeldedaten',
  Successfully_Logged_In: 'Erfolgreich angemeldet',
  This_user_not_active: 'Dieser Benutzer ist nicht aktiv',
  SignIn: 'Einloggen',
  Create_an_account: 'Ein Konto erstellen',
  Forgot_Password: 'Passwort vergessen ?',
  Email_Address: 'E-Mail-Addresse',
  SignUp: 'Anmeldung',
  Already_have_an_account: 'Sie haben bereits ein Konto ?',
  Reset_Password: 'Passwort zurücksetzen',
  Failed_to_authenticate_on_SMTP_server: 'Fehler beim Authentifizieren auf dem SMTP-Server',
  We_cant_find_a_user_with_that_email_addres: 'Wir können keinen Benutzer mit dieser E-Mail-Adresse finden',
  We_have_emailed_your_password_reset_link: 'Wir haben Ihren Link zum Zurücksetzen Ihres Passworts per E-Mail gesendet',
  Please_fill_the_Email_Adress: 'Bitte geben Sie die E-Mail-Adresse ein',
  Confirm_password: 'Kennwort bestätigen',
  Your_Password_has_been_changed: 'Ihr Passwort wurde geändert',
  The_password_confirmation_does_not_match: 'Die Passwortbestätigung stimmt nicht überein',
  This_password_reset_token_is_invalid: 'Dieses Token zum Zurücksetzen des Passworts ist ungültig',
  Warehouse_report: 'Lagerbericht',
  All_Warehouses: 'Alle Lagerhäuser',
  Expense_List: 'Spesenliste',
  Expenses: 'Kosten',
  This_Week_Sales_Purchases: 'Diese Woche Verkäufe & Käufe',
  Top_Selling_Products: 'Meistverkaufte Produkte',
  View_all: 'Alle ansehen',
  Payment_Sent_Received: 'Zahlung gesendet und erhalten',
  Filter: 'Filter',
  Invoice_POS: 'Rechnung POS',
  Invoice: 'Rechnung',
  Customer_Info: 'Kundeninformation',
  Company_Info: 'Firmeninfo',
  Invoice_Info: 'Rechnungsinfo',
  Order_Summary: 'Bestellübersicht',
  Quote_Info: 'Angebotsinfo',
  Del: 'Löschen',
  SuppliersPaiementsReport: 'Lieferantenzahlungsbericht',
  Purchase_Info: 'Kaufinfo',
  Supplier_Info: 'Lieferanteninfo',
  Return_Info: 'Infos zur Rücksendung',
  Expense_Category: 'Ausgabenkategorie',
  Create_Expense: 'Kosten erstellen',
  Details: 'Einzelheiten',
  Discount_Method: 'Rabattmethode',
  Net_Unit_Cost: 'Netto-Stückkosten',
  Net_Unit_Price: 'Netto-Stückpreis',
  Edit_Expense: 'Kosten bearbeiten',
  All_Brand: 'Alle Marke',
  All_Category: 'Alle Kategorie',
  ListExpenses: 'Ausgaben auflisten',
  Create_Permission: 'Berechtigung erstellen',
  Edit_Permission: 'Berechtigung bearbeiten',
  Reports_payments_Sales: 'Meldet Zahlungen Verkäufe',
  Reports_payments_Purchases: 'Meldet Zahlungen Einkäufe',
  Reports_payments_Return_Customers: 'Berichte Zahlungen Kunden zurückgeben',
  Reports_payments_Return_Suppliers: 'Berichte Zahlungen Rücklieferanten',
  Expense_Deleted: 'Diese Ausgabe wurde gelöscht',
  Expense_Updated: 'Diese Ausgabe wurde aktualisiert',
  Expense_Created: 'Diese Ausgabe wurde erstellt',
  DemoVersion: 'Dies ist in der Demoversion nicht möglich',
  OrderStatistics: 'Verkaufsstatistik',
  AlreadyAdd: 'Dieses Produkt ist bereits hinzugefügt',
  AddProductToList: 'Bitte fügen Sie das Produkt der Liste hinzu',
  AddQuantity: 'Bitte addieren Sie die Menge',
  InvalidData: 'Ungültige Daten',
  LowStock: 'Menge übersteigt die auf Lager verfügbare Menge',
  WarehouseIdentical: 'Die beiden Repositorys können nicht identisch sein',
  VariantDuplicate: 'Diese Variable ist redundant',
  Filesize: 'Dateigröße',
  GenerateBackup: 'Backup generieren',
  BackupDatabase: 'Backup-Datenbank',
  Backup: 'Backup-Datenbank',
  Paid: 'Bezahlt',
  Unpaid: 'Unbezahlt',
  IncomeExpenses: 'Einnahmen & Ausgaben',
  dailySalesPurchases: 'tägliche Verkäufe und Einkäufe',
  ProductsExpired: 'Produkt abgelaufen',
  Today: 'heute',
  Income: 'Einkommen'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'Kosten'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'Verkauf'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Aktiv'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Inaktiv'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'Kunden'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Telefon'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Suche per Telefon'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Lieferanten'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Zitate'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'Der Umsatz'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'Einkäufe'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'Kehrt zurück'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'die Einstellungen'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'Systemeinstellungen'), _defineProperty(_Receipt$Pos_Settings, "Users", 'Benutzer'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Gruppenberechtigungen'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'Währungen'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'Lagerhäuser'), _defineProperty(_Receipt$Pos_Settings, "Units", 'Einheiten'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'Kauf von Einheiten'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Einheiten Vertrieb'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'Berichte'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Zahlungsbericht'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Zahlungen Einkäufe'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Zahlungen Verkäufe'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Zahlung Rückgabe'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'Gibt Rechnungen zurück'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'Rechnungsdaten zurücksenden'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'Alle Datensätze aller Benutzer anzeigen'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Gewinn-und Verlust'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Lagerbestandstabelle'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'Verkaufsbericht'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Kaufbericht'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'Kundenbericht'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Lieferantenbericht'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Lieferantenbericht'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'Tägliche Verkaufsdaten'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'Tägliche Kaufdaten'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Letzte fünf Datensätze'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'Filter'), _defineProperty(_Receipt$Pos_Settings, "date", 'Datum'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Management Währungen'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Währungscode'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Währungsname'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Symbol'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Referenz'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Lieferant'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Zahlungsstatus'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'Kunde'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'Kundennummer'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Status'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Lieferantencode'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Kategorie'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'Kategorien'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'Umlagerung'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Lagerverwaltung'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Instrumententafel'), _defineProperty(_Receipt$Pos_Settings, "Products", 'Produkte'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'Produktliste'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Produkt Management'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Produktmengen Warnungen'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Code Produkt'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Produktsteuer'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'Unterkategorie'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'Bezeichnung'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Lagerwarnung'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'Warenhaus'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'MwSt'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Kaufpreis'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Verkaufspreis'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'Quantität'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Einheiten verkaufen'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'Stückkauf'), _defineProperty(_Receipt$Pos_Settings, "All", 'Alles'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Produkt bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'Produkt hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Suche nach Code'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Suche mit Name'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Produktdetails'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'Kundenname'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Kundenmanagement'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "add", 'Hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'Bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "Close", 'Schließen'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Bitte auswählen'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Aktion'), _defineProperty(_Receipt$Pos_Settings, "Email", 'Email'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Kunden bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Kunden hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "Country", 'Land'), _defineProperty(_Receipt$Pos_Settings, "City", 'Stadt'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Adresse'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'Kundendetails'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Kundenliste'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Lieferantencode'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'Name des Anbieters'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Lieferantenmanagement'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Lieferantendetails'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Zitate management'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Zwischensumme'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Restbetrag'), _defineProperty(_Receipt$Pos_Settings, "complete", 'Komplett'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'steht aus'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Empfangen'), _defineProperty(_Receipt$Pos_Settings, "partial", 'Teilweise'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Rückkehr'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Detaillierte Zita'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'bearbeiten zitat'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Verkauf erstellen'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'PDF Herunterladen'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'zitat per E-Mail senden'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", ' Löschen zitat'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'hinzufügen zitat'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Ausgewähltes Produkt'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Produkt (Code - Name)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Preis'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'Lagerbestand'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Gesamt'), _defineProperty(_Receipt$Pos_Settings, "Num", 'N°'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Kosten pro Einheit'), _defineProperty(_Receipt$Pos_Settings, "to", 'zu'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Gegenstand'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Botschaft'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'E-Mail an den Kunden'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Senden'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'Zitat'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Hallo'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Sie finden den Anhang zu Ihrem Zitat'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Produkte zur Bestellliste hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Bitte Lager auswählen'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'Wählen Sie Kunde'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Verkaufsleitung'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Balance'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Mengenrückgabe'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Gesamtrendite'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'Menge'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Verkaufsdetail'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Verkauf bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Verkauf hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Zahlungen anzeigen'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'Zahlung hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Zahlung bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Verkauf per E-Mail senden'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Verkauf löschen'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Bezahlverfahren'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Wahl der Zahlung'), _defineProperty(_Receipt$Pos_Settings, "Note", 'Hinweis'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Zahlung abgeschlossen!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Einkaufsmanagement'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Bestellt'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Kauf löschen'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Kauf per E-Mail senden'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'Kauf bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'Kaufdetail'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Kauf hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'Lieferanten-E-Mail'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Kauft Zahlungen'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Kauft Zahlungsdaten'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'Verkaufszahlungen'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Verkaufszahlungsdaten'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'Benutzerverwaltung'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'Vorname'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'Nachname'), _defineProperty(_Receipt$Pos_Settings, "username", 'NUTZERNAME'), _defineProperty(_Receipt$Pos_Settings, "password", 'PASSWORT'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'Neues Kennwort'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Avatar ändern'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Bitte lassen Sie dieses Feld leer, wenn Sie es nicht geändert haben'), _defineProperty(_Receipt$Pos_Settings, "type", 'Typ'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Benutzerberechtigungen'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Rollenname'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Rollenbeschreibung'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Berechtigungen hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "View", 'ansehen'), _defineProperty(_Receipt$Pos_Settings, "Del", 'Löschen'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'Neue Anpassung'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Anpassung bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'Sie können keine Produkte mit Lagerbestand 0 subtrahieren'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'Zusatz'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Subtraktion'), _defineProperty(_Receipt$Pos_Settings, "profil", 'profil'), _defineProperty(_Receipt$Pos_Settings, "logout", 'Ausloggen'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'Sie können keine Änderungen vornehmen, da dieser Kauf bereits bezahlt wurde'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'Sie können nicht ändern, da dieser Verkauf bereits bezahlt wurde'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'Sie können keine Änderungen vornehmen, da diese Rücksendung bereits bezahlt wurde'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'Dieses Angebot hat bereits einen Verkauf generiert'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'Dieses Angebot ist abgeschlossen'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Standortkonfiguration'), _defineProperty(_Receipt$Pos_Settings, "Language", 'Sprache'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Standardwährung'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Anmeldung Captcha'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'Standard-E-Mail'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Site-Name'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Logo ändern'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'SMTP-Konfiguration'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'GASTGEBER'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'HAFEN'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'Verschlüsselung'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'SMTP-Konfiguration falsch'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Rabatt'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Bestellsteuer'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'Versand'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Name der Firma'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Firmentelefon'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Firmenanschrift'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), _defineProperty(_Receipt$Pos_Settings, "image", 'Bild'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Strichcode drucken'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Gibt Kunden zurück'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Gibt Lieferanten zurück'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'Rechnungen Gibt Verkäufe zurück'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Rechnungen Gibt Einkäufe zurück'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'Keine Daten verfügbar'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'Produkt bild'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'Strichcode'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'Verkaufsstelle'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Benutzerdefinierter Upload'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'Kasse Management'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Änderung'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Aktualisieren'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Zurücksetzen'), _defineProperty(_Receipt$Pos_Settings, "print", 'drucken'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Suche per E-Mail'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Wählen Sie Produkt'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Menge'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Artikel'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Betrag HT'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'Betrag TTC'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Bitte wählen Sie Lieferant'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Bitte wählen Sie Statut'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'bezahlt mit'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Wählen Sie Lager'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'Zahlen Sie jetzt'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'Liste der Kategorien'), _defineProperty(_Receipt$Pos_Settings, "Description", 'Beschreibung'), _defineProperty(_Receipt$Pos_Settings, "submit", 'einreichen'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'Beim Erstellen dieser Rechnung ist ein Problem aufgetreten. Bitte versuche es erneut'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'Es gab ein Problem bei der Zahlung. Bitte versuche es erneut.'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'Anpassung erstellen'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'ein paar Worte über ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'Benutzerbild'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Produkt aktualisieren'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'Marke'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'Barcode-Symbologie'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'Produktkosten'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Produktpreis'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'Einheit Produkt'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'Steuermethode'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'Mehrfachbild'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'Produkt hat mehrere Varianten'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'Produkt hat Werbung'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Promotion Start'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Promotion-Ende'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Aktionspreis'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Preis'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'Kosten'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'Einheit'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'Produktvariante'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'Variante'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Stückpreis'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'Rückgabekunden erstellen'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Kundenretouren aktualisieren'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'Rücklieferanten anlegen'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'Dokumentation'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'Lieferantenrückgabe aktualisieren'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Aus dem Lager'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'Zum Lager'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'Übertragung bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'Detail übertragen'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'steht aus'), _defineProperty(_Receipt$Pos_Settings, "Received", 'Empfangen'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Bestellt'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'Berechtigungsmanagement'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'Markenführung'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'Markenzeichen'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'Markenname'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'Markenbeschreibung'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'Grundeinheit'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'Verwaltungseinheiten'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Betriebswert'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'Operator'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'Top 5 Produkte'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'Letzte 5 Verkäufe'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'Anpassungslisten'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'Übertragungen auflisten'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Übertragung erstellen'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'Auftragsverwaltung'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'Zitate auflisten'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'Einkäufe auflisten'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'Liste Verkäufe'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'Liste zurück'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'Management Leute'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'Markenliste'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: 'Bist du sicher?',
  Text: 'Sie können dies nicht rückgängig machen!',
  confirmButtonText: 'Ja, lösche es!',
  cancelButtonText: 'Stornieren',
  Deleted: 'Gelöscht!',
  Failed: 'Gescheitert!',
  Therewassomethingwronge: 'Etwas war falsch',
  CustomerDeleted: 'Dieser Client wurde gelöscht',
  SupplierDeleted: 'Dieser Lieferant wurde gelöscht',
  QuoteDeleted: 'Dieses Angebot wurde gelöscht',
  SaleDeleted: 'Dieser Verkauf wurde gelöscht',
  PaymentDeleted: 'Diese Zahlung wurde gelöscht',
  PurchaseDeleted: 'Dieser Kauf wurde gelöscht',
  ReturnDeleted: 'Diese Rückgabe wurde gelöscht',
  ProductDeleted: 'Dieses Produkt wurde gelöscht',
  ClientError: 'Dieser Client ist bereits mit einer anderen Operation verknüpft',
  ProviderError: 'Dieser Lieferant ist bereits mit anderen Vorgängen verbunden',
  UserDeleted: 'Dieser Benutzer wurde gelöscht',
  UnitDeleted: 'Diese Einheit wurde gelöscht',
  RoleDeleted: 'Diese Rolle wurde gelöscht',
  TaxeDeleted: 'Diese Steuer wurde gelöscht',
  SubCatDeleted: 'Diese Unterkategorie wurde gelöscht.',
  CatDeleted: 'Diese Kategorie wurde gelöscht',
  WarehouseDeleted: 'Dieses Warehouse wurde gelöscht',
  AlreadyLinked: 'Dieses Produkt ist bereits mit anderen Prozessen verknüpft',
  AdjustDeleted: 'Diese Anpassung wurde gelöscht',
  TitleCurrency: 'Diese Währung wurde erfolgreich gelöscht',
  TitleTransfer: 'Transfer wurde erfolgreich entfernt',
  BackupDeleted: 'Backup wurde erfolgreich entfernt',
  TitleBrand: 'Diese Marke wurde gelöscht'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleBrand: 'Diese Marke wurde aktualisiert',
  TitleProfile: 'Dein Profil wurde erfolgreich aktualisiert',
  TitleAdjust: 'Anpassung Erfolgreich aktualisiert',
  TitleRole: 'Rolle erfolgreich aktualisiert',
  TitleUnit: 'Einheit erfolgreich aktualisiert',
  TitleUser: 'Benutzer erfolgreich aktualisiert',
  TitleCustomer: 'Kunde erfolgreich aktualisiert',
  TitleQuote: 'Angebot erfolgreich aktualisiert',
  TitleSale: 'Verkauf erfolgreich aktualisiert',
  TitlePayment: 'Zahlung erfolgreich aktualisiert',
  TitlePurchase: 'Kauf Erfolgreich aktualisiert',
  TitleReturn: 'Zurück Erfolgreich aktualisiert',
  TitleProduct: 'Produktaktualisierung erfolgreich',
  TitleSupplier: 'Lieferant erfolgreich aktualisiert',
  TitleTaxe: 'Steuer erfolgreich aktualisiert',
  TitleCat: 'Kategorie Erfolgreich aktualisiert',
  TitleWarhouse: 'Warehouse erfolgreich aktualisiert',
  TitleSetting: 'Einstellungen erfolgreich aktualisiert',
  TitleCurrency: 'Diese Währung wurde erfolgreich aktualisiert',
  TitleTransfer: 'Transfer wurde erfolgreich aktualisiert'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'Diese Marke wurde erstellt',
  TitleTransfer: 'Transfer wurde erfolgreich erstellt',
  TitleRole: 'Rolle erfolgreich erstellt in',
  TitleUnit: 'Einheit erfolgreich erstellt in',
  TitleUser: 'Benutzer erfolgreich erstellt in',
  TitleCustomer: 'Kunde erfolgreich erstellt in',
  TitleQuote: 'Angebot erfolgreich erstellt in',
  TitleSale: 'Verkauf Erfolgreich erstellt in',
  TitlePayment: 'Zahlung erfolgreich erstellt in',
  TitlePurchase: 'Kauf erfolgreich erstellt in',
  TitleReturn: 'Rückgabe Erfolgreich erstellt in',
  TitleProduct: 'Produkt erfolgreich erstellt in',
  TitleSupplier: 'Lieferant Erfolgreich erstellt in',
  TitleTaxe: 'Steuer erfolgreich erstellt',
  TitleCat: 'Kategorie Erfolgreich erstellt in',
  TitleWarhouse: 'Warehouse erfolgreich erstellt in',
  TitleAdjust: 'Anpassung Erfolgreich erstellt in',
  TitleCurrency: 'Diese Münze wurde erfolgreich erstellt'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'E-Mail Erfolgreich einsenden'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'Dieser Verkauf ist bereits mit einer Rückgabe verbunden!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'Rückgabeverwaltung'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Detail zurückgeben'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'Rückgabe bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'Return hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'Senden Sie die Rücksendung per E-Mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Rückgabe löschen'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'Rücknahmegebühr'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'Lieferung'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Wählen Sie Verkauf'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'Sie können den Artikel löschen oder den zurückgegebenen Betrag auf Null setzen, wenn er nicht zurückgegeben wird'), _defineProperty(_Receipt$Pos_Settings, "Return", 'Rückkehr'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'Kauf'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'Gesamtumsatz'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Gesamtkäufe'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'Gesamtrendite'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'Zahlung netto'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'Zahlung senden'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'Zahlung erhalten'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'Empfangen'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'senden'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Warnung vor Produktmengen'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Produktcode'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'Produktname'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'Warnung Menge'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Inventardiagramm'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'Produkte insgesamt'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'Gesamtmenge'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'Top 5 Kunden'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Gesamtmenge'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'Ganz bezahlt'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'Kunden Verkaufsbericht'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Kundenzahlungsbericht'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'KundenangeboteBericht'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'Zahlungen'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'Top 5 Lieferanten'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'Lieferanten Einkaufsbericht'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'Lieferanten Zahlungsbericht'), _defineProperty(_Receipt$Pos_Settings, "Name", 'Name'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'Lagerverwaltung'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'Postleitzahl'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Kategorienverwaltung'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'Codekategorie'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'Namenskategorie'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'Eltern-Kategorie'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'Steuermanagement'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'Steuername'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'Steuersatz'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Käufe Einheitenverwaltung'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'Verkaufseinheit Management'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'Kurzer Name'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Bitte wählen Sie diese aus, bevor Sie ein Produkt hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'Bestandskorrektur'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'Bitte wählen Sie das Lager aus, bevor Sie ein Produkt auswählen'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'Umlagerung'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'Wählen Sie Periode'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'Dieses Jahr'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'Das heute'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Diesen Monat'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'Diese Woche'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'Anpassungsdetail'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'Dieser Benutzer wurde aktiviert'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'Dieser Benutzer wurde deaktiviert'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'Seite nicht gefunden.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'Error! Seite nicht gefunden.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'Wir konnten die gesuchte Seite nicht finden. In der Zwischenzeit können Sie'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'Zurück zum Dashboard'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'HRM'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'Mitarbeiter'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'Anwesenheit'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Anfrage hinterlassen'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Typ verlassen'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Gesellschaft'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Abteilungen'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'Bezeichnungen'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Büroschicht'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Ferien'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Geben Sie den Firmennamen ein'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'E-Mail Adresse eingeben'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Firmentelefon eingeben'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Firmenland eingeben'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Wurde erfolgreich erstellt'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Wurde erfolgreich aktualisiert'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Gelöscht in erfolgreich'), _defineProperty(_Receipt$Pos_Settings, "department", 'Abteilung'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Abteilungsname eingeben'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Wählen Sie Unternehmen'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Abteilungsleiterin'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Wählen Sie Abteilungsleiter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Geben Sie den Schichtnamen ein'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Monday In'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tuesday In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'tuesday Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'Ferien'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Titel eingeben'), _defineProperty(_Receipt$Pos_Settings, "title", 'Titel'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Startdatum'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Startdatum eingeben'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Endtermin'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Geben Sie das Enddatum ein'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Bitte geben Sie alle Details an'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'Anwesenheiten'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Anwesenheitsdatum eingeben'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'Wählen Angestellter'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'Angestellter'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Arbeitsdauer'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'Die verbleibenden Blätter sind unzureichend'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Typ verlassen'), _defineProperty(_Receipt$Pos_Settings, "Days", 'Tage'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Abteilung'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Urlaubsart wählen'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'Wählen Sie den Status'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Verlassen Sie die Vernunft'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Geben Sie den Grund für das Verlassen ein'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Mitarbeiter hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'Vorname'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Bitte Vornamen eingeben'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Nachname'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Nachnamen eingeben'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Geschlecht'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Wählen Sie Geschlecht'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Geburtsdatum eingeben'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Geburtstag'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Land eingeben'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Telefonnummer eingeben'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Beitrittsdatum'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Beitrittsdatum eingeben'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'Wählen Sie Bezeichnung'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'Bezeichnung'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Büroschicht'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Wählen Sie Büroschicht'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Geben Sie das Austrittsdatum ein'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Austrittsdatum'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Jährlicher Urlaub'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Geben Sie den Jahresurlaub ein'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Resturlaub'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Mitarbeiterdetails'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Grundlegende Informationen'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Familienstatus'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Wählen Sie Familienstatus'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Beschäftigungsart'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Wählen Sie Beschäftigungsart aus'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Stadt betreten'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Provinz'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Geben Sie die Provinz ein'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Geben Sie die Adresse ein'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Bitte Postleitzahl eingeben'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Postleitzahl'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Stundensatz'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Geben Sie den Stundensatz ein'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Grundgehalt'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Geben Sie das Grundgehalt ein'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Sozialen Medien'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skypen'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Geben Sie Skype ein'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Geben Sie Facebook ein'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'Whats App'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Geben Sie WhatsApp ein'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Geben Sie LinkedIn ein'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Geben Sie Twitter ein'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Erfahrungen'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'Bankkonto'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Name der Firma'), _defineProperty(_Receipt$Pos_Settings, "Location", 'Standort'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Ort eingeben'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Beschreibung eingeben'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Name der Bank'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Geben Sie den Banknamen ein'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Bankfiliale'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Geben Sie die Bankfiliale ein'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Bank Nummer'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Geben Sie die Banknummer ein'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Zugewiesene Lager'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'Top-Kunden'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Anhang'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'Mitarbeiter ansehen'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'Mitarbeiter bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'Mitarbeiter löschen'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Hinzugefügt von'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Produkt-IMEI/Seriennummer hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'Produkt hat IMEI/Seriennummer'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'Sendungen'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Geliefert an'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Sendungsnummer'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Verkauf Ref'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Versand bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Verpackt'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Versendet'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Geliefert'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Annulliert'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Versandstatus'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Benutzerbericht'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'Bestandsbericht'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Gesamteinkäufe'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Gesamtzitate'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Gesamtretourenverkäufe'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Total Return-Käufe'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Gesamtüberweisungen'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Gesamtanpassungen'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'Benutzerbericht'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Aktueller Lagerbestand'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'Produktname'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Gesamtschulden'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Gesamtschulden'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Einige Lager'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'Alle Lager'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Produktkosten'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'SMS-Einstellungen'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'POS-Einstellungen'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Zahlungs-Gateways'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'E-Mail-Einstellungen'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Standard-SMS-Gateway'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Moduleinstellungen'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Modul erfolgreich aktiviert'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Modul erfolgreich deaktiviert'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Update Einstellungen'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Bitte laden Sie das richtige Modul hoch'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Erfolgreich hochgeladen'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'Kundendetails'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Kunde bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Kunde löschen'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'alle Fälligen bezahlen'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'Der Zahlungsbetrag ist größer als der fällige Gesamtbetrag'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Kundenrechnung'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'Dieses Produkt ist nicht zum Verkauf bestimmt'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Willkommen auf Ihrem Dashboard'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Gesamtzahlbar'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Wählen Sie Verkaufsreferenz'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Bitte wählen Sie Verkauf'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Verkauf Ref'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'Produktrückgaben auflisten'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'Menge zurück'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Wählen Sie Kauf-Ref'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Kauf-Ref'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Bitte Kauf auswählen'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'Die zurückgegebene Menge ist größer als die gekaufte Menge'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'Die zurückgegebene Menge ist größer als die verkaufte Menge'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Menge verkauft'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Gekaufte Menge'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Absendername'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'Das Modul muss als Zip-Datei hochgeladen werden'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Modul hochladen'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Alle Module installiert'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Aktuelle Version'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'Sie haben bereits die neueste Version'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Update verfügbar'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Protokoll aktualisieren'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Jetzt aktualisieren'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'Änderungsprotokoll anzeigen'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Rechnung Fußzeile'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'HINWEIS: Bitte warten Sie, bis das Update vollständig abgeschlossen ist. Es wird nicht empfohlen, den Browser zu schließen oder ein Prozess-Upgrade zu stoppen'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Hinweis: Stellen Sie sicher, dass Sie Ihre aktuelle Version und Datenbank sichern, bevor Sie das Upgrade ausführen, um sie wiederherzustellen, wenn ein Fehler auftritt'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Zeitzone'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'Zahlungshinweis'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'Verkaufsnotizen'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Gesamtverkaufsschulden'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Total Sell Return Debt'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'alle Verkaufsschulden auf einmal bezahlen'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'Bezahlen Sie alle Verkaufsrenditeschulden auf einmal'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Bruttogewinn'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'Bezahlen Sie alle fälligen Einkäufe auf einmal'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Anbieter löschen'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Anbieter bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Anbieterdetails'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Gesamtschulden beim Kauf'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Gutschrift'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Gutschrift'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Rückgabe verkaufen'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Kaufrückgabe'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Steuernummer'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Bitte Retourenmenge hinzufügen'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'Rückgabe existiert für die Transaktion'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'Die zurückgegebene Menge ist größer als die verbleibende Menge'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Alle Produkte mit einer auf 0 gesetzten Menge werden nicht erstattet'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'alle fälligen Kaufrückgaben auf einmal bezahlen'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Gesamtkauf Retouren fällig'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Kaufrückgabe fällig'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'Verkaufe Rückgabe fällig'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'Produktbericht'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'Produktverkaufsbericht'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'Bericht über Produktkäufe'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'Menge verkauft'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Menge gekauft'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Nach Lager filtern'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Rechnung automatisch drucken'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'Lager ansehen'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Kreditkarteninformationen'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Gespeicherte Kreditkarteninformationen'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Kreditkarte erfolgreich geändert'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Benachrichtigungsvorlage'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'E-Mail Benachrichtigung'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'SMS-Benachrichtigung'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Produktdetails ändern'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'Steuern, Rabatte und Versand bearbeiten'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Angebot mit Lagerbestand erstellen'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Variantenname'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Variantenkosten'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Variantenpreis'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Variantencode'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Bitte warten Sie, bis das Produkt geladen ist'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'SMS-Gateway auswählen'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Benachrichtigung an den Kunden'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Verfügbare Tags'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'E-Mail Betreff'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'E-Mail Inhalt'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Benachrichtigung an den Lieferanten'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'SMS-Inhalt'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'SMS-Vorlagen'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'E-Mail-Vorlagen'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/en.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/en.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Anglais

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Receipt',
  Pos_Settings: 'Pos Settings (Receipt)',
  Note_to_customer: 'Note to customer',
  Show_Note_to_customer: 'Show Note to customer',
  Show_barcode: 'Show barcode',
  Show_Tax_and_Discount: 'Show Tax & Discount & Shipping',
  Show_Customer: 'Show Customer',
  Show_Email: 'Show Email',
  Show_Phone: 'Show Phone',
  Show_Address: 'Show Address',
  DefaultLanguage: 'Default Language',
  footer: 'footer',
  Received_Amount: 'Received Amount',
  Paying_Amount: 'Paying Amount',
  Change: 'Change Return',
  Paying_amount_is_greater_than_Received_amount: 'Paying amount is greater than received amount',
  Paying_amount_is_greater_than_Grand_Total: 'Paying amount is greater than Grand Total',
  code_must_be_not_exist_already: 'code must be not exist already',
  You_will_find_your_backup_on: 'You will find your backup on',
  and_save_it_to_your_pc: 'and save it to your pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scan your barcode and select the correct symbology below',
  Scan_Search_Product_by_Code_Name: 'Scan/Search Product by Code Or Name',
  Paper_size: 'Paper size',
  Clear_Cache: 'Clear Cache',
  Cache_cleared_successfully: 'Cache cleared successfully',
  Failed_to_clear_cache: 'Failed to clear cache',
  Scan_Barcode: 'Barcode Scanner',
  Please_use_short_name_of_unit: 'Please use short name of unit',
  DefaultCustomer: 'Default Customer',
  DefaultWarehouse: 'Default Warehouse',
  Payment_Gateway: 'Payment Gateway',
  SMS_Configuration: 'SMS Configuration',
  Gateway: 'SMS Gateway',
  Choose_Gateway: 'Choose SMS Gateway',
  Send_SMS: 'Message sent successfully',
  sms_config_invalid: 'wrong sms config invalid',
  Remove_Stripe_Key_Secret: 'Delete Stripe API keys',
  credit_card_account_not_available: 'Credit card account not available',
  Credit_Card_Info: 'Credit Card Info',
  developed_by: 'Developed by',
  Unit_already_linked_with_sub_unit: 'Unit already linked with sub unit',
  Total_Items_Quantity: 'Total Items & Quantity',
  Value_by_Cost_and_Price: 'Value by Cost and Price',
  Search_this_table: 'Search this table',
  import_products: 'Import products',
  Field_optional: 'Field optional',
  Download_exemple: 'Download example',
  field_must_be_in_csv_format: 'Field must be in csv format',
  Successfully_Imported: 'Successfully Imported',
  file_size_must_be_less_than_1_mega: 'File size must be less than 1 mega',
  Please_follow_the_import_instructions: 'Please follow the import instructions',
  must_be_exist: 'unit must already be created',
  Import_Customers: 'Import Customers',
  Import_Suppliers: 'Import Suppliers',
  Recent_Sales: 'Recent Sales',
  Create_Transfer: 'Create Transfer',
  order_products: 'Order items',
  Search_Product_by_Code_Name: 'Search Product by code or name',
  Reports_payments_Purchase_Return: 'Reports Purchase Return Payments',
  Reports_payments_Sale_Return: 'Reports Sale Return Payments',
  payments_Sales_Return: 'Payments Sales Return',
  payments_Purchases_Return: 'Payments Purchases Return',
  CreateSaleReturn: 'Create Sale Return',
  EditSaleReturn: 'Edit Sale Return',
  SalesReturn: 'Sales Return',
  CreatePurchaseReturn: 'Create Purchase Return',
  EditPurchaseReturn: 'Edit Purchase Return',
  PurchasesReturn: 'Purchases Return',
  Due: 'Due',
  Profit: 'Profit',
  Revenue: 'Revenue',
  Sales_today: 'Today Sales',
  People: 'People',
  Successfully_Created: 'Successfully Created',
  Successfully_Updated: 'Successfully Updated',
  Success: 'Success',
  Failed: 'Failed',
  Warning: 'Warning',
  Please_fill_the_form_correctly: 'Please fill the form correctly',
  Field_is_required: 'This Field is required',
  Error: 'Error!',
  you_are_not_authorized: 'Sorry! you are not authorized.',
  Go_back_to_home: 'Go back to homepage',
  page_not_exist: 'Sorry! The page you were looking for doesn\'t exist.',
  Choose_Status: 'Choose Status',
  Choose_Method: 'Choose Method',
  Choose_Symbology: 'Choose symbology',
  Choose_Category: 'Choose Category',
  Choose_Customer: 'Choose Customer',
  Choose_Supplier: 'Choose Supplier',
  Choose_Unit_Purchase: 'Choose Purchase Unit',
  Choose_Sub_Category: 'Choose SubCategory',
  Choose_Brand: 'Choose Brand',
  Choose_Warehouse: 'Choose Warehouse',
  Choose_Unit_Sale: 'Choose Sale Unit',
  Enter_Product_Cost: 'Enter Product Cost',
  Enter_Stock_alert: 'Enter Stock alert',
  Choose_Unit_Product: 'Choose Product Unit',
  Enter_Product_Price: 'Enter Product Price',
  Enter_Name_Product: 'Enter Name Product',
  Enter_Role_Name: 'Enter Role Name',
  Enter_Role_Description: 'Enter Role Description',
  Enter_name_category: 'Enter category Name',
  Enter_Code_category: 'Enter category Code',
  Enter_Name_Brand: 'Enter Name Brand',
  Enter_Description_Brand: 'Enter Description Brand',
  Enter_Code_Currency: 'Enter Code Currency',
  Enter_name_Currency: 'Enter name Currency',
  Enter_Symbol_Currency: 'Enter Symbol Currency',
  Enter_Name_Unit: 'Enter Unit Name',
  Enter_ShortName_Unit: 'Enter shortname Unit',
  Choose_Base_Unit: 'Choose Base Unit',
  Choose_Operator: 'Choose Operator',
  Enter_Operation_Value: 'Enter Operation Value',
  Enter_Name_Warehouse: 'Enter Warehouse Name',
  Enter_Phone_Warehouse: 'Enter Warehouse Phone',
  Enter_Country_Warehouse: 'Enter Warehouse Country',
  Enter_City_Warehouse: 'Enter Warehouse City',
  Enter_Email_Warehouse: 'Enter Warehouse Email',
  Enter_ZipCode_Warehouse: 'Enter Warehouse Zip Code',
  Choose_Currency: 'Choose Currency',
  Thank_you_for_your_business: 'Thank you for shopping with us . Please come again',
  Cancel: 'Cancel',
  New_Customer: 'New Customer',
  Incorrect_Login: 'Incorrect Login',
  Successfully_Logged_In: 'Successfully Logged In',
  This_user_not_active: 'This user not active',
  SignIn: 'Sign In',
  Create_an_account: 'Create an account',
  Forgot_Password: 'Forgot Password ?',
  Email_Address: 'Email Address',
  SignUp: 'Sign Up',
  Already_have_an_account: 'Already have an account ?',
  Reset_Password: 'Reset Password',
  Failed_to_authenticate_on_SMTP_server: 'Failed to authenticate on SMTP server',
  We_cant_find_a_user_with_that_email_addres: 'We can\'t find a user with that email addres',
  We_have_emailed_your_password_reset_link: 'We have e-mailed your password reset link',
  Please_fill_the_Email_Adress: 'Please fill the Email Address',
  Confirm_password: 'Confirm password',
  Your_Password_has_been_changed: 'Your Password has been changed',
  The_password_confirmation_does_not_match: 'The password confirmation does not match',
  This_password_reset_token_is_invalid: 'This password reset token is invalid',
  Warehouse_report: 'Warehouse report',
  All_Warehouses: 'All Warehouses',
  Expense_List: 'All Expenses',
  Expenses: 'Expenses',
  This_Week_Sales_Purchases: 'This Week Sales & Purchases',
  Top_Selling_Products: 'Top Selling Products',
  View_all: 'View all',
  Payment_Sent_Received: 'Payment Sent & Received',
  Filter: 'Filter',
  Invoice_POS: 'Invoice POS',
  Invoice: 'Invoice',
  Customer_Info: 'Customer Info',
  Company_Info: 'Company Info',
  Invoice_Info: 'Invoice Info',
  Order_Summary: 'Order Summary',
  Quote_Info: 'Quotation Info',
  Del: 'Delete',
  SuppliersPaiementsReport: 'Suppliers Payments Report',
  Purchase_Info: 'Purchase Info',
  Supplier_Info: 'Supplier Info',
  Return_Info: 'Info of Return',
  Expense_Category: 'Expense Category',
  Create_Expense: 'Create Expense',
  Details: 'Details',
  Discount_Method: 'Discount Type',
  Net_Unit_Cost: 'Net Unit Cost',
  Net_Unit_Price: 'Net Unit Price',
  Edit_Expense: 'Edit Expense',
  All_Brand: 'All Brand',
  All_Category: 'All Category',
  ListExpenses: 'All Expenses',
  Create_Permission: 'Create Permission',
  Edit_Permission: 'Edit Permission',
  Reports_payments_Sales: 'Reports payments Sales',
  Reports_payments_Purchases: 'Reports payments Purchases',
  Reports_payments_Return_Customers: 'Payments Return Customers',
  Reports_payments_Return_Suppliers: 'Payments Return Suppliers',
  Expense_Deleted: 'This Expense has been deleted',
  Expense_Updated: 'This Expense has been Updated',
  Expense_Created: 'This Expense has been Created',
  DemoVersion: 'You cannot do this in the demo version',
  OrderStatistics: 'Sales Statistics',
  AlreadyAdd: 'This Product Already Added !!',
  AddProductToList: 'Please Add Product To List !!',
  AddQuantity: 'Please Add quantity of product !!',
  InvalidData: 'Invalid Data !!',
  LowStock: 'Quantity exceeds quantity available in stock',
  WarehouseIdentical: 'The two warehouses cannot be identical !!',
  VariantDuplicate: 'This Variant Is Duplicate !!',
  Filesize: 'File size',
  GenerateBackup: 'Generate Backup',
  BackupDatabase: 'Backup Database',
  Backup: 'Backup',
  Paid: 'Paid',
  Unpaid: 'Unpaid',
  Today: 'Today',
  Income: 'Income'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'Expenses'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'Sale'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Active'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Inactive'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'Customers'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Phone'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Search by Phone'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Suppliers'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Quotations'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'Sales'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'Purchases'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'Return'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'Settings'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'System Settings '), _defineProperty(_Receipt$Pos_Settings, "Users", 'Users'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Group Permissions'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'Currency'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'Warehouse'), _defineProperty(_Receipt$Pos_Settings, "Units", 'Unit'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'Purchases Units'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Sales Units'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'Reports'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Payments Report'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Payments Purchases'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Payments Sales'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Profit and Loss'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Warehouse Stock Chart'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'Sale Report'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Purchase Report'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'Customer Report'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Supplier Report'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Supplier Report'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'Daily Sales Data'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'Daily Purchases Data'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Last five records'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'Filters'), _defineProperty(_Receipt$Pos_Settings, "date", 'Date'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Reference'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Supplier'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Payment Status'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'Customer'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'Customer Code'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Status'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Supplier Code'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Category'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'Category'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'Transfer'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Stock Management'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Dashboard '), _defineProperty(_Receipt$Pos_Settings, "Products", 'Products'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'All Products'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Product Management'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Product Quantity Alerts'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Code Product'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Product Tax'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'Sub Category'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'Name'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Stock Alert'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'Warehouse'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'Tax'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Buying price'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Sell price'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'Quantity'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Sale Unit'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'Purchase Unit'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Currency Management'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Currency Code'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Currency Name'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Symbol'), _defineProperty(_Receipt$Pos_Settings, "All", 'All'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Edit Product'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Search by Code'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Search by Name'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Product Details'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'Customer Name'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Customer Management'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Create'), _defineProperty(_Receipt$Pos_Settings, "add", 'Create'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'Edit'), _defineProperty(_Receipt$Pos_Settings, "Close", 'Close'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Please Select'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Action'), _defineProperty(_Receipt$Pos_Settings, "Email", 'Email'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Edit Customer'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Create Customer'), _defineProperty(_Receipt$Pos_Settings, "Country", 'Country'), _defineProperty(_Receipt$Pos_Settings, "City", 'City'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Address'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'Customer Details'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Customers'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Supplier Code'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'Supplier Name'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Suppliers Management'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Supplier Details'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Quotations Management'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Subtotal'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Amount left'), _defineProperty(_Receipt$Pos_Settings, "complete", 'Completed'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'Pending'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Received'), _defineProperty(_Receipt$Pos_Settings, "partial", 'Partial'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Return'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Detail Quotation'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Edit Quotation'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Create Sale'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'Download Pdf'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'Send Quotation on Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Delete Quotation'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'Create Quotation'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Select Product'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Product (Code - Name)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Price'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'Stock'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Grand Total'), _defineProperty(_Receipt$Pos_Settings, "Num", 'N°'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Unit cost'), _defineProperty(_Receipt$Pos_Settings, "to", 'To'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Subject'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Message'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'Email Customer'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Send'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'Quotation'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Hello'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Please find the attachment for your Quotation'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Add Products to the Order List'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Please Select warehouse'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'please Select Customer'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Sales Management'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Balance'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Qty Back'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Total Return'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'Amount'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Sale Detail'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Edit Sale'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Create Sale'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Show Payments'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'Create Payment'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Edit Payment'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Send Sale on Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Delete Sale'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Paid by'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Payment choice'), _defineProperty(_Receipt$Pos_Settings, "Note", 'Note'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Payment complete!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Purchases Management'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Ordered'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Delete Purchase'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Send Purchase on Email'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'Edit Purchase'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'Purchase Detail'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Create Purchase'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'Supplier Email'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Purchases payments'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Purchases payments data'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'Sales payments'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Sales payments data'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'Users management'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'First name'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'Last name'), _defineProperty(_Receipt$Pos_Settings, "username", 'Username'), _defineProperty(_Receipt$Pos_Settings, "password", 'Password'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'New password'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Change Avatar'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Please leave this field blank if you haven\'t changed it'), _defineProperty(_Receipt$Pos_Settings, "type", 'Type'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Users Permissions'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Role'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Role Description'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Create Permissions'), _defineProperty(_Receipt$Pos_Settings, "View", 'View'), _defineProperty(_Receipt$Pos_Settings, "Del", 'Delete'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'New Adjustement'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Edit Adjustement'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'You cannot subtraction products which have stock 0'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'Addition'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Subtraction'), _defineProperty(_Receipt$Pos_Settings, "profil", 'Profile'), _defineProperty(_Receipt$Pos_Settings, "logout", 'Logout'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'You cannot modify because this Purchase already paid'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'You cannot modify because this Sale already paid'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'You cannot modify because this Return already paid'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'This quote already has generate sale'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'Create product'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'This Quotation Complete'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Site Configuration'), _defineProperty(_Receipt$Pos_Settings, "Language", 'Language'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Default Currency'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Login Captcha'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'Default Email'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Site Name'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Change Logo'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'SMTP Configuration'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'MAIL_HOST'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'MAIL_PORT'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'MAIL_ENCRYPTION'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'SMTP Configuration Incorrect'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Payments Returns'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'Returns Invoices'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'Returns Invoices Data'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'View all records of all Users'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Discount'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Order Tax'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'Shipping'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Company Name'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Company Phone'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Company Address'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), _defineProperty(_Receipt$Pos_Settings, "image", 'Image'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Print Labels'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Returns Customer'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Returns Supplier'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'Return Customer Invoice'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Return Supplier Invoice'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'No data Available'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'Product Image'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'Barcode'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'Point of Sales'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Custom Upload'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'Point of Sale Management'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Adjustment'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Update'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Reset'), _defineProperty(_Receipt$Pos_Settings, "print", 'Print'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Search By Email'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Choose Product'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Qty'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Items'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Amount HT'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'Amount TTC'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Please Select Supplier'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Please Select Status'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'Paid By'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Choose Warehouse'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'Pay Now'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'List of Category'), _defineProperty(_Receipt$Pos_Settings, "Description", 'Description'), _defineProperty(_Receipt$Pos_Settings, "submit", 'Submit'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'There was a problem creating this Invoice. Please try again'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'There was a problem Payment. Please try again.'), _defineProperty(_Receipt$Pos_Settings, "IncomeExpenses", 'Income & Expenses'), _defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Daily Sales & Purchases'), _defineProperty(_Receipt$Pos_Settings, "ProductsExpired", 'Products Expired'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'Brands'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'Create Adjustment'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'A few words ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'User Image'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Update Product'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'Brand'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'Barcode Symbology'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'Product Cost'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Product Price'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'Product Unit'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'Tax Type'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'Multiple Image'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'This Product Has Multi Variants'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'Product Has Promotion'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Promotion Start'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Promotion End'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Promotion Price'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Price'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'Cost'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'Unit'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'Product Variant'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'Variant'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Unit Price'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'Create Return Customer'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Edit Return Customer'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'Create Return Supplier'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'Doc'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'Edit Return Supplier'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'From Warehouse'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'To Warehouse'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'Edit Transfer'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'Transfer Detail'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'Pending'), _defineProperty(_Receipt$Pos_Settings, "Received", 'Received'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Ordered'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'Permissions Management'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'Brand'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'Brand Image'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'Brand Name'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'Brand Description'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'Base Unit'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'Units Management'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Operation Value'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'Operator'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'Top 5 Products'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'Last 5 Sales'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'All Adjustments'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'All Transfers'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Create Transfer'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'Orders Management'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'All Quotations'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'All Purchases'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'All Sales'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'All Returns'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'People Management'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: 'Are you sure?',
  Text: 'You won\'t be able to revert this!',
  confirmButtonText: 'Yes, delete it!',
  cancelButtonText: 'Cancel',
  Deleted: 'Deleted!',
  Failed: 'Failed!',
  Therewassomethingwronge: 'There was something wronge',
  CustomerDeleted: 'This Client has been deleted.',
  SupplierDeleted: 'This Supplier has been deleted.',
  QuoteDeleted: 'This Quotation has been deleted.',
  SaleDeleted: 'This Sale has been deleted.',
  PaymentDeleted: 'This Payment has been deleted.',
  PurchaseDeleted: 'This Purchase has been deleted.',
  ReturnDeleted: 'This Return has been deleted.',
  ProductDeleted: 'This Product has been deleted.',
  ClientError: 'This Client already linked with other Operation',
  ProviderError: 'This Supplier already linked with other Operation',
  UserDeleted: 'This User has been deleted.',
  UnitDeleted: 'This Unit has been deleted.',
  RoleDeleted: 'This Role has been deleted.',
  TaxeDeleted: 'This Tax has been deleted.',
  SubCatDeleted: 'This Sub Category has been deleted.',
  CatDeleted: 'This Category has been deleted.',
  WarehouseDeleted: 'This Warehouse has been deleted.',
  AlreadyLinked: 'This product already linked with other Operation',
  AdjustDeleted: 'This Adjustement has been deleted.',
  TitleCurrency: 'This Currency has been deleted.',
  TitleTransfer: 'The Transfer has been removed successfully',
  BackupDeleted: 'Backup has been removed successfully',
  TitleBrand: 'This Brand has been deleted'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleBrand: 'This Brand has been Updated',
  TitleProfile: 'Your Profile Updated in successfully',
  TitleAdjust: 'Adjustement Updated in successfully',
  TitleRole: 'Role Updated in successfully',
  TitleUnit: 'Unit Updated in successfully',
  TitleUser: 'User Updated in successfully',
  TitleCustomer: 'Customer Updated in successfully',
  TitleQuote: 'Quotation Updated in successfully',
  TitleSale: 'Sale Updated in successfully',
  TitlePayment: 'Payment Updated in successfully',
  TitlePurchase: 'Purchase Updated in successfully',
  TitleReturn: 'Return Updated in successfully',
  TitleProduct: 'Product Updated in successfully',
  TitleSupplier: 'Supplier Updated in successfully',
  TitleTaxe: 'Tax Updated in successfully',
  TitleCat: 'Category Updated in successfully',
  TitleWarhouse: 'Warhouse Updated in successfully',
  TitleSetting: 'Settings Updated in successfully',
  TitleCurrency: 'Currency Updated in successfully',
  TitleTransfer: 'Transfer Updated in successfully'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'This Brand has been Created',
  TitleRole: 'Role Created in successfully',
  TitleUnit: 'Unit Created in successfully',
  TitleUser: 'User Created in successfully',
  TitleCustomer: 'Customer Created in successfully',
  TitleQuote: 'Quotation Created in successfully',
  TitleSale: 'Sale Created in successfully',
  TitlePayment: 'Payment Created in successfully',
  TitlePurchase: 'Purchase Created in successfully',
  TitleReturn: 'Return Created in successfully',
  TitleProduct: 'Product Created in successfully',
  TitleSupplier: 'Supplier Created in successfully',
  TitleTaxe: 'Tax Created in successfully',
  TitleCat: 'Category Created in successfully',
  TitleWarhouse: 'Warehouse Created in successfully',
  TitleAdjust: 'Adjustement Created in successfully',
  TitleCurrency: 'Currency Created in successfully',
  TitleTransfer: 'Transfer Created in successfully'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email Send in successfully'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'This sale already linked with a Return!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'Return Management'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Return Detail'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'Edit Return'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'Create Return'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'Send Return on Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Delete Return'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'Return Surcharge'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'Delivery'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Select Sale'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'You can delete the item or set the quantity returned to zero if it is not returned'), _defineProperty(_Receipt$Pos_Settings, "Return", 'Return'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'Purchase'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'Total Sales'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total Purchases'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'Total Returns'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'Payments Net'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'Payments Sent'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'Payments Received'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'Recieved'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Sent'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Product Quantity Alerts'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Code'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'Product'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'Alert Quantity'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Warehouse Stock Chart'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'Total Products'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'Total Quantity'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'Top 5 Customers'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Total Amount'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'Total Paid'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'Customer Sales Report'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Customer Payments Report'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'Customer Quotations Report'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'Payments'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'Top 5 Suppliers'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'Supplier Purchases Report'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'Supplier Payments Report'), _defineProperty(_Receipt$Pos_Settings, "Name", 'Name'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'Warehouse Management'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'Zip Code'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Categories management'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'Category Code'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'Category Name'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'Parent category'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'Tax management'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'Tax Name'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'Tax Rate'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Purchases Unit'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'Sales Unit'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'Short Name'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Please Select These before adding any product'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'Adjustment'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'Please Select warehouse before choose any product'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'Stock Transfer'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'Select Period'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'This Year'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'This Today'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'This Month'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'This Week'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'Adjustment Detail'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'This User Has been Activated'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'This User Has been Deactivated'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'Page not found.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'Oops! Page not found.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'We could not find the page you were looking for.Meanwhile, you may'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'Return to dashboard'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'HRM'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'Employees'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'Attendance'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Leave Request'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Leave Type'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Company'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Departments'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'Designations'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Office Shift'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Holidays'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Enter company name'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Enter email address'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Enter company phone'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Enter company country'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Created in successfully'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Updated in successfully'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Deleted in successfully'), _defineProperty(_Receipt$Pos_Settings, "department", 'Department'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Enter department name'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Choose Company'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Department Head'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Choose Department Head'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Enter Shift name'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Monday In'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tuesday In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'tuesday Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'Holiday'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Enter title'), _defineProperty(_Receipt$Pos_Settings, "title", 'title'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Start date'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Enter start date'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Finish date'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Enter finish date'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Please provide any details'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'Attendances'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Enter attendance date'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'Choose Employee'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'Employee'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Work Duration'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'Remaining leaves are insufficient'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Leave Type'), _defineProperty(_Receipt$Pos_Settings, "Days", 'Days'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Department'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Choose leave type'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'Choose status'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Leave Reason'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Enter Reason Leave'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Add Employee'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'First Name'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Enter First Name'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Last Name'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Enter Last Name'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Gender'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Choose Gender'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Enter birth date'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Birth date'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Enter Country'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Enter Phone Number'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Joining date'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Enter joining date'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'Choose Designation'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'Designation'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Office Shift'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Choose Office Shift'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Enter Leaving Date'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Leaving Date'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Annual Leave'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Enter Annual Leave'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Remaining leave'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Employee Details'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Basic Information'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Family Status'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Choose Family status'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Employment type'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Select Employment type'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Enter City'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Province'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Enter Province'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Enter Address'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Enter Zip code'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Zip code'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Hourly rate'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Enter Hourly rate'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Basic salary'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Enter Basic salary'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Social Media'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skype'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Enter Skype'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Enter Facebook'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Enter WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Enter LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Enter Twitter'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Experiences'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'bank account'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Company Name'), _defineProperty(_Receipt$Pos_Settings, "Location", 'Location'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Enter location'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Enter Description'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Bank Name'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Enter Bank Name'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Bank Branch'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Enter Bank Branch'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Bank Number'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Enter Bank Number'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Access warehouses'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'Best customers'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Attachment'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'view employee'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'Edit employee'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'Delete employee'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Added by'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Add product IMEI/Serial Number'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'Product Has Imei/Serial Number'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'Shipments'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Delivered To'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Shipment Ref'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Sale Ref'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Edit Shipping'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Packed'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Shipped'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Delivered'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Cancelled'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Shipping Status'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Users Report'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'Stock Report'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total Purchases'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Total Quotations'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Total return sales'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Total return purchases'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Total transfers'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Total adjustments'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'User Report'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Current Stock'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'Product Name'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Total Debt'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Total Debt'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Some Warehouses'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'All Warehouses'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Product Cost'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'Sms Settings'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'POS Settings'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Payment Gateway'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'Mail Settings'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Default SMS Gateway'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Module Settings'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Module enabled successfully'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Module Disabled successfully'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Upgrade'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Please Upload the Correct Module'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Uploaded in successfully'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'Customer Details'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Edit Customer'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Delete Customer'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'Pay Due'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'Paying amount is greater than Total Due'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Customer Invoice'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'This Product Not For Selling'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Welcome to your Dashboard'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Total Payable'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Choose Sale Ref'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Please Select Sale'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Sale Ref'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'list product returns'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'Qty return'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Choose Purchase Ref'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Purchase Ref'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Please Select Purchase'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'Qty return is greater than Qty purchased'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'Qty return is greater than Qty sold'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Qty sold'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Qty purchased'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Sender Name'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'The module must be uploaded as zip file'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Upload Module'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'All Modules Installed'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Current Version'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'You already have the latest version'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Update Available'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Update Log'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Update Now'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'View Change Log'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'NOTE:  Please Wait for the update to finish completely. It is not recommended to close the browser or stop a process Upgrade'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Note : Make sure you backup your Current version & database before you run the Upgrade , To restore it if there is an error'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Invoice footer'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Time Zone'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'Payment notes'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'Sale notes'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Total Sale Due'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Total Sell Return Due'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'pay all sell due at a time'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'pay all sell return due at a time'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Gross Profit'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'pay all purchase due at a time'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Delete Provider'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Edit Provider'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Provider details'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Total Purchase Due'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Provider Credit Note'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Customer Credit Note'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Sell Return'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Purchase Return'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Tax Number'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Please add return quantity'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'Return exist for the Transaction'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'Qty return is greater than Quantity Remaining'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Any products with a quantity set to 0 won\'t be refunded'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'pay all purchase return due at a time'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Total Purchase Return Due'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Purchase return due'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'Sell return due'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'Product report'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'Product sales report'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'Product purchases report'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'Qty sold'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Qty purchased'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Filter by warehouse'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Print Invoice automatically'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'Show warehouse'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Credit card info'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Saved Credit Card Info'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Credit card changed successfully'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Notification Template'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'Email notification'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'SMS notification'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Change product details'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'edit tax and discount and shipping'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Create Quotation with Stock'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Variant Name'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Variant cost'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Variant price'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Variant code'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Please wait until the product is loaded'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Choose SMS Gateway'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Notification Client'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Available Tags'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'Email Subject'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'Email body'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Notification Supplier'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'SMS body'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'SMS Templates'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Email Templates'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/es.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/es.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Espagnol

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Recibo',
  Pos_Settings: 'Configuración de punto de venta',
  Note_to_customer: 'Nota al cliente',
  Show_Note_to_customer: 'Mostrar nota al cliente',
  Show_barcode: 'Mostrar código de barras',
  Show_Tax_and_Discount: 'Mostrar impuestos, descuentos y envío',
  Show_Customer: 'Mostrar cliente',
  Show_Email: 'Mostrar correo electrónico',
  Show_Phone: 'Mostrar teléfono',
  Show_Address: 'Mostrar dirección',
  DefaultLanguage: 'Idioma predeterminado',
  footer: 'pie de página',
  Received_Amount: 'Cantidad recibida',
  Paying_Amount: 'Monto de pago',
  Change: 'cambiar',
  Paying_amount_is_greater_than_Received_amount: 'El monto a pagar es mayor que el monto recibido',
  Paying_amount_is_greater_than_Grand_Total: 'El monto a pagar es mayor que el total general',
  code_must_be_not_exist_already: 'el código no debe existir ya',
  You_will_find_your_backup_on: 'Encontrarás tu copia de seguridad en',
  and_save_it_to_your_pc: 'y guárdalo en tu pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Escanee su código de barras y seleccione la simbología correcta a continuación',
  Scan_Search_Product_by_Code_Name: 'Escanear / Buscar producto por nombre de código',
  Paper_size: 'Tamaño de papel',
  Clear_Cache: 'limpiar cache',
  Cache_cleared_successfully: 'Caché borrada con éxito',
  Failed_to_clear_cache: 'No se pudo borrar la caché',
  Scan_Barcode: 'Escáner de código de barras',
  Please_use_short_name_of_unit: 'Utilice el nombre corto de la unidad',
  DefaultCustomer: 'Cliente predeterminado',
  DefaultWarehouse: 'Almacén predeterminado',
  Payment_Gateway: 'Pasarela de pago',
  SMS_Configuration: 'Configuración de SMS',
  Gateway: 'Pasarela de pago',
  Choose_Gateway: 'Elija la pasarela de pago',
  Send_SMS: 'Mensaje enviado con éxito',
  sms_config_invalid: 'configuración de sms incorrecta no válida',
  Remove_Stripe_Key_Secret: 'Eliminar claves de API de Stripe',
  credit_card_account_not_available: 'Cuenta de tarjeta de crédito no disponible',
  Credit_Card_Info: 'Información de la tarjeta de crédito',
  developed_by: 'Desarrollado por',
  Unit_already_linked_with_sub_unit: 'Unidad ya vinculada con la subunidad',
  Total_Items_Quantity: 'Total de artículos y cantidad',
  Value_by_Cost_and_Price: 'Valor por costo y precio',
  Search_this_table: 'Buscar esta tabla',
  import_products: 'Importar productos',
  Field_optional: 'Campo opcional',
  Download_exemple: 'Descargar ejemplo',
  field_must_be_in_csv_format: 'El campo debe estar en formato csv',
  Successfully_Imported: 'Importada exitosamente',
  file_size_must_be_less_than_1_mega: 'El tamaño del archivo debe ser inferior a 1 mega',
  Please_follow_the_import_instructions: 'Siga las instrucciones de importación.',
  must_be_exist: 'la unidad ya debe estar creada',
  Import_Customers: 'Importar clientes',
  Import_Suppliers: 'Proveedores de importación',
  Recent_Sales: 'Ventas recientes',
  Create_Transfer: 'Crear transferencia',
  order_products: 'encargar artículos',
  Search_Product_by_Code_Name: 'Buscar producto por código o nombre',
  Reports_payments_Purchase_Return: 'Informes Pagos de devolución de compra',
  Reports_payments_Sale_Return: 'Informes Pagos de devolución de venta',
  payments_Sales_Return: 'pagos ventas Devolución',
  payments_Purchases_Return: 'pagos compras Devolución',
  CreateSaleReturn: 'Crear devolución de venta',
  EditSaleReturn: 'Editar devolución de venta Sale Return',
  SalesReturn: 'Devolución de ventas',
  CreatePurchaseReturn: 'Crear devolución de compra',
  EditPurchaseReturn: 'Editar devolución de compra',
  PurchasesReturn: 'Devolución de compras',
  Due: 'debido',
  Profit: 'Lucro',
  Revenue: 'Ingresos',
  Sales_today: 'Ventas hoy',
  People: 'Gente',
  Successfully_Created: 'Creado con éxito',
  Successfully_Updated: 'Actualizado exitosamente',
  Success: 'Éxito',
  Failed: 'fallido',
  Warning: 'Advertencia',
  Please_fill_the_form_correctly: 'Por favor complete el formulario correctamente',
  Field_is_required: 'Se requiere campo',
  Error: 'Error!',
  you_are_not_authorized: '¡Perdón! usted no está autorizado.',
  Go_back_to_home: 'Volver a la página principal',
  page_not_exist: '¡Perdón! La página que buscaba no existe.',
  Choose_Status: 'Elija estado',
  Choose_Method: 'Elija el método',
  Choose_Symbology: 'Elija simbología',
  Choose_Category: 'Elegir la categoría',
  Choose_Customer: 'Elija cliente',
  Choose_Supplier: 'Elija proveedor',
  Choose_Unit_Purchase: 'Elija unidad de compra',
  Choose_Sub_Category: 'Elija subcategoría',
  Choose_Brand: 'Elija marca',
  Choose_Warehouse: 'Elija Almacén',
  Choose_Unit_Sale: 'Elija la unidad de venta',
  Enter_Product_Cost: 'Ingrese el costo del producto',
  Enter_Stock_alert: 'Entrar alerta de stock',
  Choose_Unit_Product: 'Elija la unidad de producto',
  Enter_Product_Price: 'Ingrese el precio del producto',
  Enter_Name_Product: 'Ingrese el nombre del producto',
  Enter_Role_Name: 'Ingrese el nombre del rol',
  Enter_Role_Description: 'Ingrese la descripción del rol',
  Enter_name_category: 'Ingrese el nombre de la categoría',
  Enter_Code_category: 'Ingrese el código de la categoría',
  Enter_Name_Brand: 'Ingrese el nombre de la marca',
  Enter_Description_Brand: 'Ingrese la descripción de la marca',
  Enter_Code_Currency: 'Ingrese la moneda del código',
  Enter_name_Currency: 'Ingrese el nombre Moneda',
  Enter_Symbol_Currency: 'Ingrese la moneda del símbolo',
  Enter_Name_Unit: 'Ingrese el nombre de la unidad',
  Enter_ShortName_Unit: 'Introduzca la unidad de nombre corto',
  Choose_Base_Unit: 'Elija la unidad base',
  Choose_Operator: 'Elegir Operadora',
  Enter_Operation_Value: 'Ingrese el valor de la operación',
  Enter_Name_Warehouse: 'Ingrese el nombre del almacén',
  Enter_Phone_Warehouse: 'Ingrese el teléfono del almacén',
  Enter_Country_Warehouse: 'Ingrese el país del almacén',
  Enter_City_Warehouse: 'Ingrese la ciudad del almacén',
  Enter_Email_Warehouse: 'Ingrese el correo electrónico del almacén',
  Enter_ZipCode_Warehouse: 'Ingrese el código postal del almacén',
  Choose_Currency: 'Elegir Moneda',
  Thank_you_for_your_business: '¡Gracias por su negocios!',
  Cancel: 'Cancelar',
  New_Customer: 'Nueva cliente',
  Incorrect_Login: 'Inicio de sesión incorrecto',
  Successfully_Logged_In: 'Inicio de sesión exitoso',
  This_user_not_active: 'Esta usuaria no activa',
  SignIn: 'Registrarse',
  Create_an_account: 'Crea una cuenta',
  Forgot_Password: 'Has olvidado tu contraseña ?',
  Email_Address: 'Dirección de correo electrónico',
  SignUp: 'Inscribirse',
  Already_have_an_account: 'Ya tienes una cuenta ?',
  Reset_Password: 'Restablecer la contraseña',
  Failed_to_authenticate_on_SMTP_server: 'No se pudo autenticar en el servidor SMTP',
  We_cant_find_a_user_with_that_email_addres: 'No podemos encontrar un usuario con esa dirección de correo electrónico',
  We_have_emailed_your_password_reset_link: 'Hemos enviado su enlace de restablecimiento de contraseña por correo electrónico',
  Please_fill_the_Email_Adress: 'Por favor complete la dirección de correo electrónico',
  Confirm_password: 'Confirmar Contraseña',
  Your_Password_has_been_changed: 'Tu contraseña ha sido cambiada',
  The_password_confirmation_does_not_match: 'La confirmación de la contraseña no coincide',
  This_password_reset_token_is_invalid: 'Este token de restablecimiento de contraseña no es válido',
  Warehouse_report: 'Informe de almacén',
  All_Warehouses: 'Todos los almacenes',
  Expense_List: 'Lista de gastos',
  Expenses: 'Gastos',
  This_Week_Sales_Purchases: 'Ventas y compras de esta semana',
  Top_Selling_Products: 'Productos más vendidos',
  View_all: 'Ver todo',
  Payment_Sent_Received: 'Pago enviado y recibido',
  Filter: "Filtrar",
  Invoice_POS: "Factura POS",
  Invoice: "Factura",
  Customer_Info: "Información del cliente",
  Company_Info: "Información de la compañía",
  Invoice_Info: "Información de la factura",
  Order_Summary: "Resumen del pedido",
  Quote_Info: "Información de cotización",
  Del: "Eliminar",
  SuppliersPaiementsReport: "Informe de pagos a proveedores",
  Purchase_Info: "Información de compra",
  Supplier_Info: "Información del proveedor",
  Return_Info: "info de devolución",
  Expense_Category: "Categoría de gastos",
  Create_Expense: "Crear gasto",
  Details: "Detalles",
  Discount_Method: "Método de descuento",
  Net_Unit_Cost: "Costo unitario neto",
  Net_Unit_Price: "Precio unitario neto",
  Edit_Expense: "Editar gasto",
  All_Brand: "Toda la marca",
  All_Category: "Todas las categorías",
  ListExpenses: "Lista de gastos",
  Create_Permission: "Crear permiso",
  Edit_Permission: "Editar permiso",
  Reports_payments_Sales: "Reportes pagos Ventas",
  Reports_payments_Purchases: "Reporta pagos Compras",
  Reports_payments_Return_Customers: "Informes pagos Clientes devueltos",
  Reports_payments_Return_Suppliers: "Proveedores de vuelta de los pagos de los informes",
  stockyVersion: "No puede hacer esto en la versión de stockystración",
  Expense_Deleted: "Este gasto ha sido eliminado",
  Expense_Updated: "Este gasto se ha actualizado",
  Expense_Created: "Este gasto ha sido creado",
  Filesize: "Tamaño del archivo",
  GenerateBackup: "Generar respaldo",
  BackupDatabase: "Base de datos de respaldo",
  Backup: "Base de datos de respaldo",
  OrderStatistics: "Estadísticas de ventas",
  AlreadyAdd: "Este producto ya ha sido agregado",
  AddProductToList: "Agregue un producto a la lista",
  AddQuantity: "Agregue la cantidad",
  InvalidData: "Fecha inválida",
  LowStock: "la cantidad excede la cantidad disponible en stock",
  WarehouseIdentical: "Los almacenes no pueden ser iguales",
  VariantDuplicate: "Esta variante está duplicada",
  Paid: "Pagado",
  Unpaid: "No pagado",
  IncomeExpenses: "Ingresos y gastos",
  dailySalesPurchases: "Ventas y Compras diarias",
  ProductsExpired: "Productos caducados",
  Today: "hoy",
  Income: "Ingresos"
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", "Gastos"), _defineProperty(_Receipt$Pos_Settings, "Sale", "rebaja"), _defineProperty(_Receipt$Pos_Settings, "Actif", "Activo"), _defineProperty(_Receipt$Pos_Settings, "Inactif", "Inactivo"), _defineProperty(_Receipt$Pos_Settings, "Customers", "Clientes"), _defineProperty(_Receipt$Pos_Settings, "Phone", "Teléfono"), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", "Buscar por teléfono"), _defineProperty(_Receipt$Pos_Settings, "Suppliers", "Proveedores"), _defineProperty(_Receipt$Pos_Settings, "Quotations", "Citas"), _defineProperty(_Receipt$Pos_Settings, "Sales", "Ventas"), _defineProperty(_Receipt$Pos_Settings, "Purchases", "Compras"), _defineProperty(_Receipt$Pos_Settings, "Returns", "Devoluciones"), _defineProperty(_Receipt$Pos_Settings, "Settings", "Configuraciones"), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", "Ajustes del sistema"), _defineProperty(_Receipt$Pos_Settings, "Users", "Los usuarios"), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", "Permisos de grupo"), _defineProperty(_Receipt$Pos_Settings, "Currencies", "Monedas"), _defineProperty(_Receipt$Pos_Settings, "Warehouses", "Almacenes"), _defineProperty(_Receipt$Pos_Settings, "Units", "Unidades"), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", " Compra de unidades"), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", "Ventas de unidades"), _defineProperty(_Receipt$Pos_Settings, "Reports", "Informes"), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", "Informe de pagos"), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", "Compras de pagos"), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", "Venta de pagos"), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", "Devolución de pagos"), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", "Ganancia y perdida"), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", "Gráfico de acciones de almacén"), _defineProperty(_Receipt$Pos_Settings, "SalesReport", "Reporte de ventas"), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", "Informe de compras"), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", "Informe de clientes"), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", "Informe de proveedores"), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", "Informe del proveedor"), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", "Datos de ventas diarias"), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", "Datos de compras diarias"), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", "Últimos cinco registros"), _defineProperty(_Receipt$Pos_Settings, "Filters", "Filtros"), _defineProperty(_Receipt$Pos_Settings, "date", "fecha"), _defineProperty(_Receipt$Pos_Settings, "Reference", "Referencia"), _defineProperty(_Receipt$Pos_Settings, "Supplier", "Proveedor"), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", "Estado de pago"), _defineProperty(_Receipt$Pos_Settings, "Customer", "Cliente"), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", "Código de cliente"), _defineProperty(_Receipt$Pos_Settings, "Status", "Estado"), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", "Código de proveedor"), _defineProperty(_Receipt$Pos_Settings, "Categorie", "Categoría"), _defineProperty(_Receipt$Pos_Settings, "Categories", "Categorias"), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", "Transferencias de stock"), _defineProperty(_Receipt$Pos_Settings, "StockManagement", "Gestion de Stocks"), _defineProperty(_Receipt$Pos_Settings, "dashboard", "Tablero"), _defineProperty(_Receipt$Pos_Settings, "Products", "Productos"), _defineProperty(_Receipt$Pos_Settings, "productsList", "lista de productos"), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", "Gestion de producto"), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", "Alertas de cantidad de producto"), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", "Código de producto"), _defineProperty(_Receipt$Pos_Settings, "ProductTax", "Impuesto de producto"), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", "Subcategoría"), _defineProperty(_Receipt$Pos_Settings, "Name_product", "Designacion"), _defineProperty(_Receipt$Pos_Settings, "StockAlert", "Alerta de stock"), _defineProperty(_Receipt$Pos_Settings, "warehouse", "almacén"), _defineProperty(_Receipt$Pos_Settings, "Tax", "Impuesto"), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", "Precio de compra"), _defineProperty(_Receipt$Pos_Settings, "SellPrice", "Precio de venta"), _defineProperty(_Receipt$Pos_Settings, "Quantity", "Cantidad"), _defineProperty(_Receipt$Pos_Settings, "UnitSale", "Venta de unidades"), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", "Compra de unidad"), _defineProperty(_Receipt$Pos_Settings, "All", "todos"), _defineProperty(_Receipt$Pos_Settings, "EditProduct", "Editar producto"), _defineProperty(_Receipt$Pos_Settings, "AddProduct", "Añadir Producto"), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", "Buscar por código"), _defineProperty(_Receipt$Pos_Settings, "SearchByName", "Buscar por nombre"), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", "Detalles de producto"), _defineProperty(_Receipt$Pos_Settings, "CustomerName", "Nombre del cliente"), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", "Gestión de clientes"), _defineProperty(_Receipt$Pos_Settings, "Add", "Añadir"), _defineProperty(_Receipt$Pos_Settings, "add", "Añadir"), _defineProperty(_Receipt$Pos_Settings, "Edit", "Editar"), _defineProperty(_Receipt$Pos_Settings, "Close", "Cerrar"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", "Por favor seleccione"), _defineProperty(_Receipt$Pos_Settings, "Action", "Acción"), _defineProperty(_Receipt$Pos_Settings, "Email", "Email"), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", "Editar cliente"), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", "Agregar cliente"), _defineProperty(_Receipt$Pos_Settings, "Country", "País"), _defineProperty(_Receipt$Pos_Settings, "City", "Ciudad"), _defineProperty(_Receipt$Pos_Settings, "Adress", "Dirección"), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", "Detalles del cliente"), _defineProperty(_Receipt$Pos_Settings, "CustomersList", "Lista de clientes"), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", "Código de proveedor"), _defineProperty(_Receipt$Pos_Settings, "SupplierName", "Nombre del proveedor"), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", "Gerencia de Proveedores"), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", "Detalles del proveedor"), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", "Gestión de cotizaciones"), _defineProperty(_Receipt$Pos_Settings, "SubTotal", "Total parcial"), _defineProperty(_Receipt$Pos_Settings, "MontantReste", "Cantidad restante"), _defineProperty(_Receipt$Pos_Settings, "complete", "completar"), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", "pendiente"), _defineProperty(_Receipt$Pos_Settings, "Recu", "Recibido"), _defineProperty(_Receipt$Pos_Settings, "partial", "Parcial"), _defineProperty(_Receipt$Pos_Settings, "Retournee", "Regreso"), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", "Cotización detallada"), _defineProperty(_Receipt$Pos_Settings, "EditQuote", "Editar cotización"), _defineProperty(_Receipt$Pos_Settings, "CreateSale", "Crear venta"), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", "Descargar PDF"), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", "Presupuesto enviado por correo electrónico"), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", "Eliminar cotización"), _defineProperty(_Receipt$Pos_Settings, "AddQuote", "Agregar cotización"), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", "Seleccionar producto"), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", "Producto (Código - Nombre)"), _defineProperty(_Receipt$Pos_Settings, "Price", "Precio"), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", "Stock"), _defineProperty(_Receipt$Pos_Settings, "Total", "Total"), _defineProperty(_Receipt$Pos_Settings, "Num", "N°"), _defineProperty(_Receipt$Pos_Settings, "Unitcost", "Costo unitario"), _defineProperty(_Receipt$Pos_Settings, "to", "a"), _defineProperty(_Receipt$Pos_Settings, "Subject", "Sujeto"), _defineProperty(_Receipt$Pos_Settings, "Message", "Mensaje"), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", "Cliente de correo electrónico"), _defineProperty(_Receipt$Pos_Settings, "Sent", "Enviar"), _defineProperty(_Receipt$Pos_Settings, "Quote", "cotización"), _defineProperty(_Receipt$Pos_Settings, "Hello", "Hola"), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", "Encuentra el archivo adjunto para tu cotización"), _defineProperty(_Receipt$Pos_Settings, "AddProducts", "Agregar productos a la lista de pedidos"), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", "Por favor seleccione almacén"), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", "Seleccionar cliente"), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", "Gestión de ventas"), _defineProperty(_Receipt$Pos_Settings, "Balance", "saldo"), _defineProperty(_Receipt$Pos_Settings, "QtyBack", "regreso cantidad"), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", "Regreso total"), _defineProperty(_Receipt$Pos_Settings, "Amount", "monto"), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", "Detalle de venta"), _defineProperty(_Receipt$Pos_Settings, "EditSale", "Editar venta"), _defineProperty(_Receipt$Pos_Settings, "AddSale", "Añadir venta"), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", "Mostrar pagos"), _defineProperty(_Receipt$Pos_Settings, "AddPayment", "Agregar pago"), _defineProperty(_Receipt$Pos_Settings, "EditPayment", "Editar pago"), _defineProperty(_Receipt$Pos_Settings, "EmailSale", "Enviar venta en correo electrónico"), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", "Eliminar venta"), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", "Modo de pago"), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", "Opción de pago"), _defineProperty(_Receipt$Pos_Settings, "Note", "Nota"), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", "¡Pago completo!"), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", "Gestión de compras"), _defineProperty(_Receipt$Pos_Settings, "Ordered", "Ordenado"), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", "Eliminar compra"), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", "Enviar compra por correo electrónico"), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", "Editar compra"), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", "Detalle de compra"), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", "Añadir compra"), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", "Correo electrónico del proveedor"), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", "Compras pagos"), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", "Datos de pagos de compras"), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", "Pagos de ventas"), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", "Datos de pagos de ventas"), _defineProperty(_Receipt$Pos_Settings, "UserManagement", "gestión de usuarios"), _defineProperty(_Receipt$Pos_Settings, "Firstname", "Primer nombre"), _defineProperty(_Receipt$Pos_Settings, "lastname", "nombre de familia"), _defineProperty(_Receipt$Pos_Settings, "username", "NOMBRE DE USUARIO"), _defineProperty(_Receipt$Pos_Settings, "password", "CONTRASEÑA"), _defineProperty(_Receipt$Pos_Settings, "Newpassword", "Nueva contraseña"), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", "Cambiar avatar"), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", "Deje este campo en blanco si no lo ha cambiado."), _defineProperty(_Receipt$Pos_Settings, "type", "tipo"), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", "Permisos de usuarios"), _defineProperty(_Receipt$Pos_Settings, "RoleName", "Nombre de rol"), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", "Descripción del rol"), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", "Agregar permisos"), _defineProperty(_Receipt$Pos_Settings, "View", "Ver"), _defineProperty(_Receipt$Pos_Settings, "Del", "Eliminar"), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", "Nuevo ajuste"), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", "Editar ajuste"), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", "No puede restar productos que tienen stock 0"), _defineProperty(_Receipt$Pos_Settings, "Addition", "Adición"), _defineProperty(_Receipt$Pos_Settings, "Subtraction", "Sustracción"), _defineProperty(_Receipt$Pos_Settings, "profil", "perfil"), _defineProperty(_Receipt$Pos_Settings, "logout", "cerrar sesión"), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", "no puede modificar porque esta compra ya ha pagado"), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", "no puede modificar porque esta venta ya pagó"), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", "no se puede modificar porque esta devolución ya ha pagado"), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", "Este cotización ya ha generado ventas"), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", "Esta cita completa"), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", "Configuración del sitio"), _defineProperty(_Receipt$Pos_Settings, "Language", "Idioma"), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", "Moneda predeterminada"), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", "Captcha de inicio de sesión"), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", "Email predeterminado"), _defineProperty(_Receipt$Pos_Settings, "SiteName", "Nombre del sitio"), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", "Cambiar logo"), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", "Configuración SMTP"), _defineProperty(_Receipt$Pos_Settings, "HOST", "hueste"), _defineProperty(_Receipt$Pos_Settings, "PORT", "PUERTO"), _defineProperty(_Receipt$Pos_Settings, "encryption", "Cifrado"), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", "Configuración SMTP incorrecta"), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", "Devolver facturas"), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", "Devolver datos de factura"), _defineProperty(_Receipt$Pos_Settings, "ShowAll", "Mostrar todos los registros de todos los usuarios"), _defineProperty(_Receipt$Pos_Settings, "Discount", "Descuento"), _defineProperty(_Receipt$Pos_Settings, "OrderTax", "Impuesto de orden"), _defineProperty(_Receipt$Pos_Settings, "Shipping", "Envío"), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", "Monedas de gestión"), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", "Código de moneda"), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", "Nombre de moneda"), _defineProperty(_Receipt$Pos_Settings, "Symbol", "Símbolo"), _defineProperty(_Receipt$Pos_Settings, "CompanyName", "Nombre de empresa"), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", "Teléfono de la empresa"), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", "Dirección de la empresa"), _defineProperty(_Receipt$Pos_Settings, "Code", "Código"), _defineProperty(_Receipt$Pos_Settings, "image", "imagen"), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", "Imprimir código de barras"), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", "Devuelve ventas"), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", "Devoluciones de compras"), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", "facturas Ventas devolución"), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", "facturas devoluciones compras"), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", "Datos no disponibles"), _defineProperty(_Receipt$Pos_Settings, "ProductImage", "Imagen del producto"), _defineProperty(_Receipt$Pos_Settings, "Barcode", "Código de barras"), _defineProperty(_Receipt$Pos_Settings, "pointofsales", "puntos de venta"), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", "Subida personalizada"), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", "gestión punto de venta"), _defineProperty(_Receipt$Pos_Settings, "Adjustment", "Ajustamiento"), _defineProperty(_Receipt$Pos_Settings, "Updat", "Actualizar"), _defineProperty(_Receipt$Pos_Settings, "Reset", "Reiniciar"), _defineProperty(_Receipt$Pos_Settings, "print", "impresión"), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", "Buscar por correo "), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", "Elegir producto"), _defineProperty(_Receipt$Pos_Settings, "Qty", "Cantidad"), _defineProperty(_Receipt$Pos_Settings, "Items", "Artículos"), _defineProperty(_Receipt$Pos_Settings, "AmountHT", "monto HT"), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", "monto TTC"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", "Seleccione Proveedor"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", "seleccione estado"), _defineProperty(_Receipt$Pos_Settings, "PayeBy", "Pagado con"), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", "Elija Almacén"), _defineProperty(_Receipt$Pos_Settings, "payNow", "Pagar ahora"), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", "Lista de categoría"), _defineProperty(_Receipt$Pos_Settings, "Description", "Descripción"), _defineProperty(_Receipt$Pos_Settings, "submit", "guardar"), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", "Hubo un problema al crear esta factura. Inténtalo de nuevo"), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", "Hubo un problema con el pago. Inténtalo de nuevo"), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", "Crear ajuste"), _defineProperty(_Receipt$Pos_Settings, "Afewwords", "unas palabras sobre ..."), _defineProperty(_Receipt$Pos_Settings, "UserImage", "Imagen de usuario"), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", "Actualizar producto"), _defineProperty(_Receipt$Pos_Settings, "Brand", "Marca"), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", "Simbología de códigos de barras"), _defineProperty(_Receipt$Pos_Settings, "ProductCost", "Costo del producto"), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", "Precio del producto"), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", "Producto unitario"), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", "Método de impuestos"), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", "Imagen múltiple"), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", "El producto tiene múltiples variantes"), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", "El producto tiene promoción"), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", "Inicio de promoción"), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", "Fin de la promoción"), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", "Precio de promoción"), _defineProperty(_Receipt$Pos_Settings, "Price", "Precio"), _defineProperty(_Receipt$Pos_Settings, "Cost", "Costo"), _defineProperty(_Receipt$Pos_Settings, "Unit", "Unidad"), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", "Variante de producto"), _defineProperty(_Receipt$Pos_Settings, "Variant", "Variante"), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", "Precio unitario"), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", "Crear devolución de cliente"), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", "Editar devolución de cliente"), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", "Crear devolución de proveedor"), _defineProperty(_Receipt$Pos_Settings, "Documentation", "Documentación"), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", "Editar devolución de proveedor"), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", "De almacén"), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", "Al almacén"), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", "Editar transferencia"), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", "Detalle de transferencia"), _defineProperty(_Receipt$Pos_Settings, "Pending", "Pendiente"), _defineProperty(_Receipt$Pos_Settings, "Received", "Recibido"), _defineProperty(_Receipt$Pos_Settings, "Ordered", "Ordenado"), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", "Administrador de permisos"), _defineProperty(_Receipt$Pos_Settings, "BrandManager", "Gerente de marca"), _defineProperty(_Receipt$Pos_Settings, "BrandImage", "Imagen de marca"), _defineProperty(_Receipt$Pos_Settings, "BrandName", "Nombre de la marca"), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", "Descripción de marca"), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", "Unidad base"), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", "Unidades gestoras"), _defineProperty(_Receipt$Pos_Settings, "OperationValue", "Valor de operación"), _defineProperty(_Receipt$Pos_Settings, "Operator", "Operador"), _defineProperty(_Receipt$Pos_Settings, "Top5Products", "Los 5 mejores productos"), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", "Últimas 5 ventas"), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", "Lista de ajustes"), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", "Lista de transferencias"), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", "Crear transferencia"), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", "Gerente de pedidos"), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", "List Quotations"), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", "Lista de compras"), _defineProperty(_Receipt$Pos_Settings, "ListSales", "Lista de ventas"), _defineProperty(_Receipt$Pos_Settings, "ListReturns", "Lista de devoluciones"), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", "Gerente de personas"), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", "Lista de marcas"), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: "Estas seguro ?",
  Text: "¡No podrás revertir esto!",
  confirmButtonText: "Sí, bórralo!",
  cancelButtonText: "Cancelar",
  Deleted: "Eliminado!",
  Failed: "¡Ha fallado!",
  Therewassomethingwronge: "Algo andaba mal",
  CustomerDeleted: "Este cliente ha sido eliminado.",
  SupplierDeleted: "este proveedor ha sido eliminado.",
  QuoteDeleted: "esta cita ha sido eliminada.",
  SaleDeleted: "esta venta ha sido eliminada.",
  PaymentDeleted: "este pago ha sido eliminado.",
  PurchaseDeleted: "esta compra ha sido eliminada.",
  ReturnDeleted: "esta devolución ha sido eliminada.",
  ProductDeleted: "este producto ha sido eliminado.",
  ClientError: "Este cliente ya está vinculado con otra operación",
  ProviderError: "Este proveedor ya está vinculado con otra operación",
  UserDeleted: "Este usuario ha sido eliminado.",
  UnitDeleted: "Esta unidad ha sido eliminada.",
  RoleDeleted: "Este rol ha sido eliminado.",
  TaxeDeleted: "Este impuesto ha sido eliminado.",
  SubCatDeleted: "Esta subcategoría ha sido eliminada.",
  CatDeleted: "Esta categoría ha sido eliminada.",
  WarehouseDeleted: "Este almacén ha sido eliminado.",
  AlreadyLinked: "este producto ya está vinculado con otra Operación",
  AdjustDeleted: "Este ajuste ha sido eliminado.",
  TitleCurrency: "Esta moneda ha sido eliminada",
  TitleTransfer: "Transferir se ha eliminado correctamente",
  BackupDeleted: "La copia de seguridad se ha eliminado correctamente",
  TitleBrand: "Esta marca ha sido eliminada"
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleProfile: "Su perfil actualizado con éxito",
  TitleAdjust: "Ajuste actualizado con éxito",
  TitleRole: "Rol actualizado correctamente",
  TitleUnit: "Unidad actualizada con éxito",
  TitleUser: "Usuario actualizado con éxito",
  TitleCustomer: "Cliente actualizado con éxito",
  TitleQuote: "Presupuesto actualizado correctamente",
  TitleSale: "Venta actualizada con éxito",
  TitlePayment: "Pago actualizado correctamente",
  TitlePurchase: "Compra actualizada con éxito",
  TitleReturn: "Devolución actualizada con éxito",
  TitleProduct: "Producto actualizado con éxito",
  TitleSupplier: "Proveedor actualizado con éxito",
  TitleTaxe: "Impuesto actualizado con éxito",
  TitleCat: "Categoría actualizada con éxito",
  TitleWarhouse: "Almacén actualizado con éxito",
  TitleSetting: "Configuración  actualizado con éxito",
  TitleCurrency: "Esta moneda ha sido actualizada",
  TitleTransfer: "Transferir se actualizó correctamente",
  TitleBrand: "Esta marca ha sido actualizada"
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: "Esta marca ha sido creada",
  TitleTransfer: "Transferir se creó correctamente",
  TitleRole: "Rol creado con éxito",
  TitleUnit: "Unidad creada con éxito",
  TitleUser: "Usuario creado con éxito",
  TitleCustomer: "Cliente creado con éxito",
  TitleQuote: "Cita creada con éxito",
  TitleSale: "Venta creada con éxito",
  TitlePayment: "Pago creado con éxito",
  TitlePurchase: "Compra creada con éxito",
  TitleReturn: "retorno Creada con éxito",
  TitleProduct: "Producto creado con éxito",
  TitleSupplier: "Proveedor creado con éxito",
  TitleTaxe: "Impuesto creado con éxito",
  TitleCat: "Categoría creada con éxito",
  TitleWarhouse: "Almacén creado con éxito",
  TitleAdjust: "Ajuste creado con éxito",
  TitleCurrency: "Esta moneda ha sido creada"
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: "Enviar por correo electrónico con éxito"
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: "¡Esta venta ya está vinculada con una devolución!"
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", "Gestión de retorno"), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", "Detalle de retorno"), _defineProperty(_Receipt$Pos_Settings, "EditReturn", "Editar retorno"), _defineProperty(_Receipt$Pos_Settings, "AddReturn", "Agregar retorno"), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", "Enviar retorno en correo electrónico"), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", "Eliminar retorno"), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", "Recargo de retorno"), _defineProperty(_Receipt$Pos_Settings, "Laivrison", "entrega"), _defineProperty(_Receipt$Pos_Settings, "SelectSale", "Seleccionar venta"), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", "Puede eliminar el artículo o establecer la cantidad devuelta a cero si no se devuelve"), _defineProperty(_Receipt$Pos_Settings, "Return", "retorno"), _defineProperty(_Receipt$Pos_Settings, "Purchase", "Compra"), _defineProperty(_Receipt$Pos_Settings, "TotalSales", "Ventas totales"), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", "Compras totales"), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", "Devoluciones totales"), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", "Pagos Netos"), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", "Pagos enviados"), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", "Pagos recibidos"), _defineProperty(_Receipt$Pos_Settings, "Recieved", "Recibido"), _defineProperty(_Receipt$Pos_Settings, "Sent", "Expedido"), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", "Alertas de cantidad de producto"), _defineProperty(_Receipt$Pos_Settings, "ProductCode", "Código de producto"), _defineProperty(_Receipt$Pos_Settings, "ProductName", "nombre del producto"), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", "Cantidad de alerta"), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", "Gráfico de acciones de almacén"), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", "Productos totales"), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", "Cantidad total"), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", "Los 5 mejores clientes"), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", "monto total "), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", "Total pagado"), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", "Informe de ventas del cliente"), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", "Informe de pagos del cliente"), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", "Informe de cotizaciones de clientes"), _defineProperty(_Receipt$Pos_Settings, "Payments", "Pagos"), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", "Los 5 mejores proveedores"), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", "Informe de compras del proveedor"), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", "Informe de pagos a proveedores"), _defineProperty(_Receipt$Pos_Settings, "Name", "Nombre"), _defineProperty(_Receipt$Pos_Settings, "Code", "Código"), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", "Gestion de almacenes"), _defineProperty(_Receipt$Pos_Settings, "ZipCode", "Código postal"), _defineProperty(_Receipt$Pos_Settings, "managementCategories", "Gestión de categorías"), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", "Categoría de código"), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", "Categoría de nombre"), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", "Categoría principal"), _defineProperty(_Receipt$Pos_Settings, "managementTax", "Gestión fiscal"), _defineProperty(_Receipt$Pos_Settings, "TaxName", "Nombre fiscal"), _defineProperty(_Receipt$Pos_Settings, "TaxRate", "Tasa de impuesto"), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", "Gestión de la Unidad de Compras"), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", "Gerencia de Unidad de Ventas"), _defineProperty(_Receipt$Pos_Settings, "ShortName", "Nombre corto"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", "Seleccione estos antes de agregar cualquier producto"), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", "Ajuste de Stock"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", "Seleccione almacén antes de elegir cualquier producto"), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", "Transferencia de acciones"), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", "Seleccionar periodo"), _defineProperty(_Receipt$Pos_Settings, "ThisYear", "Este año"), _defineProperty(_Receipt$Pos_Settings, "ThisToday", "hoy"), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", "Este mes"), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", "Esta semana"), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", "Detalle de ajuste"), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", "Esta usuaria ha sido activada"), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", "Esta usuaria ha sido desactivada"), _defineProperty(_Receipt$Pos_Settings, "NotFound", "Página no encontrada."), _defineProperty(_Receipt$Pos_Settings, "oops", "¡error! Página no encontrada."), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", "No pudimos encontrar la página que estaba buscando."), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", "volver al tablero"), _defineProperty(_Receipt$Pos_Settings, "hrm", 'HRM'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'Empleados'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'Asistencia'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Dejar petición'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Tipo de licencia'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Compañía'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Departamentos'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'Designaciones'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Turno de oficina'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Días festivos'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Introduzca el nombre de la empresa'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Introduzca la dirección de correo electrónico'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Introduce el teléfono de la empresa'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Introduzca el país de la empresa'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Creado en con éxito'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Actualizado en con éxito'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Eliminado en con éxito'), _defineProperty(_Receipt$Pos_Settings, "department", 'Departamento'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Ingrese el nombre del departamento'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Elija empresa'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Jefe de departamento'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Elegir jefe de departamento'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Ingrese el nombre del turno'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Monday In'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tuesday In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'tuesday Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'Fiesta'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Introduce el título'), _defineProperty(_Receipt$Pos_Settings, "title", 'título'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Fecha de inicio'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Introduce la fecha de inicio'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Fecha de finalización'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Introduzca la fecha de finalización'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Proporcione cualquier detalle'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'asistencias'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Ingrese la fecha de asistencia'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'Elegir empleado'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'Empleado'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Duración del trabajo'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'Las hojas restantes son insuficientes'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Tipo de licencia'), _defineProperty(_Receipt$Pos_Settings, "Days", 'Días'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Departamento'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Elija el tipo de licencia'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'elegir estado'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Razón de dejar'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Ingrese el motivo de la licencia'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Agregar empleado'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'Primer nombre'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Ingrese el nombre'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Apellido'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Introduzca el apellido'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Género'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Elija género'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Ingrese la fecha de nacimiento'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Fecha de nacimiento'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Introducir país'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Ingresa número telefónico'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Dia de ingreso'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Introduce la fecha de incorporación'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'Elija Designación'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'Designacion'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Turno de oficina'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Elija turno de oficina'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Ingrese la fecha de salida'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Fecha de salida'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Vacaciones anuales'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Ingresar vacaciones anuales'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Licencia restante'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Detalles del empleado'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Información básica'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Estado familiar'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Elija el estado de la familia'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Tipo de empleo'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Seleccionar tipo de empleo'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Ingresar ciudad'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Provincia'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Entrar Provincia'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Ingresa la direccion'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Ingresa tu código postal'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Código postal'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Tarifa por hora'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Ingrese la tarifa por hora'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Salario base'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Ingrese salario base'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Medios de comunicación social'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skype'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Ingresa a Skype'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Ingresa a Facebook'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Ingresa a WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Ingresa a LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Ingresa a Twitter'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Experiencias'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'cuenta bancaria'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'nombre de empresa'), _defineProperty(_Receipt$Pos_Settings, "Location", 'Ubicación'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Introduce la ubicación'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Ingrese la descripción'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Nombre del banco'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Ingrese el nombre del banco'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Sucursal bancaria'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Ingresar Sucursal Bancaria'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Número de banco'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Ingrese el número de banco'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Almacenes asignados'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'mejores clientes'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Adjunto archivo'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'ver empleados'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'editar empleados'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'eliminar empleados'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Añadido por'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Añadir producto IMEI/número de serie'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'El producto tiene Imei/Número de serie'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'Envíos'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Entregado a'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Referencia de envío'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Referencia de venta'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Editar envío'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Lleno'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Enviado'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Entregado'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Cancelado'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Estado del envío'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Informe de usuarios'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'Informe de existencias'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Compras totales'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Cotizaciones totales'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Ventas de devolución total'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Compras de devolución total'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Transferencias totales'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Ajustes totales'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'Informe de usuario'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Stock actual'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'nombre del producto'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Deuda total'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Deuda total'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'algunos almacenes'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'Todos los Almacenes'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Costo del producto'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'Configuraciones de SMS'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'Ajustes de POS'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Pasarela de pago'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'Configuración de correo'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Puerta de enlace de SMS predeterminada'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Configuración del módulo'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Módulo habilitado con éxito'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Módulo deshabilitado con éxito'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Ajustes de actualización'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Por favor, suba el módulo correcto'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Cargado correctamente'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'Detalles del cliente'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Editar cliente'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Eliminar cliente'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'Pagar adeudado'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'El monto a pagar es mayor que el total adeudado'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Factura del cliente'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'Este producto no para la venta'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Bienvenido a tu Tablero'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Total por Pagar'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Elija Ref. de venta'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Seleccione Venta'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Referencia de venta'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'enumerar las devoluciones de productos'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'devolución de cantidad'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Elija la referencia de compra'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Referencia de compra'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Por favor seleccione Compra'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'La cantidad devuelta es mayor que la cantidad comprada'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'La cantidad devuelta es mayor que la cantidad vendida'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Cantidad vendida'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Cant. comprada'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Nombre del remitente'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'El módulo debe cargarse como archivo zip'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Subir módulo'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Todos los módulos instalados'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Versión actual'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'Ya tienes la última versión'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Actualización disponible'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Registro de actualización'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Actualizar ahora'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'Ver registro de cambios'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Pie de página de la factura'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'NOTA: Espere a que la actualización finalice por completo. No se recomienda cerrar el navegador o detener un proceso Actualizar'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Nota: asegúrese de hacer una copia de seguridad de su versión y base de datos actuales antes de ejecutar la actualización, para restaurarla si hay un error'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Zona horaria'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'Nota de pago'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'notas de venta'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Deuda total de venta'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Deuda total de devolución de venta'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'pagar todas las deudas de venta a la vez'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'pagar toda la deuda de devolución de venta a la vez'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Beneficio bruto'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'pagar toda la deuda de compra a la vez'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Eliminar proveedor'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Editar proveedor'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Detalles del proveedor'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Deuda total de compra'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Nota de crédito'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Nota de crédito'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Vender Retorno'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Devolución de compra'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Número de impuesto'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Por favor agregue la cantidad de devolución'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'Existe devolución para la Transacción'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'La devolución de cantidad es mayor que la cantidad restante'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Cualquier producto con una cantidad establecida en 0 no será reembolsado'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'pagar todas las devoluciones de compra adeudadas a la vez'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Deuda total de devolución de compra'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Deuda de devolución de compra'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'deuda de devolución de venta'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'informe de producto'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'informe de ventas de productos'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'informe de compras de productos'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'Cantidad vendida'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'cantidad comprada'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Filtrar por almacén'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Imprimir factura automáticamente'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'ver almacén'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Información de tarjeta de crédito'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Información de tarjeta de crédito guardada'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Tarjeta de crédito cambiada exitosamente'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Plantilla de notificación'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'Notificación por correo electrónico'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'Notificación por SMS'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Cambiar detalles del producto'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'Editar impuestos, descuentos y envío'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Crear cotización con stock'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Nombre de variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Costo de variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Precio de variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Código de variante'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Por favor, espere hasta que el producto se cargue'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Elegir gateway de SMS'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Notificación al cliente'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Etiquetas disponibles'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'Asunto del correo electrónico'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'Contenido del correo electrónico'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Notificación al proveedor'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'Contenido del SMS'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'Plantillas SMS'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Plantillas de correo electrónico'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/fr.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/fr.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Delete, _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Français

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Reçu',
  Pos_Settings: 'Paramètres du point de vente (Reçu)',
  Note_to_customer: 'Remarque au client',
  Show_Note_to_customer: 'Afficher la Remarque au client',
  Show_barcode: 'Afficher le code barre',
  Show_Tax_and_Discount: 'Afficher les taxes, les remises et les frais d\'expédition',
  Show_Customer: 'Afficher le client',
  Show_Email: 'Afficher l\'e-mail',
  Show_Phone: 'Afficher le téléphone',
  Show_Address: 'Afficher l\'adresse',
  DefaultLanguage: 'Langage par défaut',
  footer: 'bas de page',
  Received_Amount: 'Montant reçu',
  Paying_Amount: 'Montant à payer',
  Change: 'changement',
  Paying_amount_is_greater_than_Received_amount: 'Le montant à payer est supérieur au montant reçu',
  Paying_amount_is_greater_than_Grand_Total: 'Le montant à payer est supérieur au montant total',
  code_must_be_not_exist_already: 'le code ne doit pas déjà exister',
  You_will_find_your_backup_on: 'Vous trouverez votre sauvegarde sur',
  and_save_it_to_your_pc: 'et enregistrez-le sur votre pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scannez votre code-barres et sélectionnez la symbologie correcte ci-dessous',
  Scan_Search_Product_by_Code_Name: 'Scannez/recherchez un produit par nom ou code',
  Paper_size: 'Taille de papier',
  Clear_Cache: 'Vider le cache',
  Cache_cleared_successfully: 'Cache vidé avec succès',
  Failed_to_clear_cache: 'Échec de vider du cache',
  Scan_Barcode: 'Scanner de code-barres',
  Please_use_short_name_of_unit: 'Veuillez utiliser le nom abrégé de l\'unité',
  DefaultCustomer: 'Client par défaut',
  DefaultWarehouse: 'Entrepôt par défaut',
  Payment_Gateway: 'Passerelle de paiement',
  SMS_Configuration: 'Configuration SMS',
  Gateway: 'Passerelle de paiement',
  Choose_Gateway: 'Choisissez la passerelle de paiement',
  Send_SMS: 'message envoyé avec succès',
  sms_config_invalid: 'configuration sms invalide',
  Remove_Stripe_Key_Secret: 'Supprimer les clés d\'API Stripe',
  credit_card_account_not_available: 'Compte de carte de crédit non disponible',
  Credit_Card_Info: 'Informations sur la carte de crédit',
  developed_by: 'Développé par',
  Unit_already_linked_with_sub_unit: 'Unité déjà liée à la sous-unité',
  Total_Items_Quantity: 'Total des articles et quantité',
  Value_by_Cost_and_Price: 'Valeur par coût et prix',
  Search_this_table: 'Rechercher dans ce tableau',
  import_products: 'Importer des produits',
  Field_optional: 'Champ facultatif',
  Download_exemple: 'Télécharger l\'exemple',
  field_must_be_in_csv_format: 'Le champ doit être au format csv',
  Successfully_Imported: 'Importé avec succès',
  file_size_must_be_less_than_1_mega: 'La taille du fichier doit être inférieure à 1 méga',
  Please_follow_the_import_instructions: 'Veuillez suivre les instructions d\'importation',
  must_be_exist: 'l\'unité doit déjà être créée',
  Import_Customers: 'Importer des clients',
  Import_Suppliers: 'Importer des fournisseurs',
  Recent_Sales: 'Ventes récentes',
  Create_Transfer: 'Créer un transfert',
  order_products: 'Products commandés',
  Search_Product_by_Code_Name: 'Rechercher un produit par code ou par nom',
  Reports_payments_Purchase_Return: 'Rapports sur les paiements de retour d\'achat',
  Reports_payments_Sale_Return: 'Rapports sur les paiements de retour de vente',
  payments_Sales_Return: 'Paiements retour de vente',
  payments_Purchases_Return: 'Paiements retour d\'achats',
  CreateSaleReturn: 'Créer un retour de vente',
  EditSaleReturn: 'Modifier le retour de vente',
  SalesReturn: 'Retour des ventes',
  CreatePurchaseReturn: 'Créer un retour d\'achat',
  EditPurchaseReturn: 'Modifier le retour d\'achat',
  PurchasesReturn: 'Retour des achats',
  Due: 'Dû',
  Profit: 'Profit',
  Revenue: 'Revenu',
  Sales_today: 'Ventes aujourd\'hui',
  People: 'Gens',
  Successfully_Created: 'Créé avec succès',
  Successfully_Updated: 'Mise à jour réussie',
  Success: 'Succès',
  Failed: 'Échec',
  Warning: 'Alert',
  Error: 'Erreur!',
  you_are_not_authorized: 'Pardon! vous n\'êtes pas autorisé.',
  Go_back_to_home: 'Retournez à la page d\'accueil',
  page_not_exist: 'Pardon! La page que vous recherchez n\'existe pas.',
  Please_fill_the_form_correctly: 'Veuillez remplir le formulaire correctement',
  Field_is_required: 'Champ requis',
  Choose_Status: 'Choisissez le statut',
  Choose_Method: 'Choisissez la méthode',
  Choose_Symbology: 'Choisissez la symbologie',
  Choose_Category: 'Choisissez la catégorie',
  Choose_Customer: 'Choisissez le client',
  Choose_Supplier: 'Choisissez un fournisseur',
  Choose_Unit_Purchase: 'Choisissez l\'unité d\'achat',
  Choose_Sub_Category: 'Choisissez la sous-catégorie',
  Choose_Brand: 'Choisissez la marque',
  Choose_Warehouse: 'Choisissez l\'entrepôt',
  Choose_Unit_Sale: 'Choisissez l\'unité de vente',
  Enter_Product_Cost: 'Entrez le prix d\'achat',
  Enter_Stock_alert: 'Entrer l\'alerte de stock',
  Choose_Unit_Product: 'Choisissez l\'unité de produit',
  Enter_Product_Price: 'Entrez le prix de vente',
  Enter_Name_Product: 'Entrez le nom du produit',
  Enter_Role_Name: 'Entrez le nom du rôle',
  Enter_Role_Description: 'Entrez la description du rôle',
  Enter_name_category: 'Entrez le nom de la catégorie',
  Enter_Code_category: 'Entrez le code de la catégorie',
  Enter_Name_Brand: 'Entrez le nom de la marque',
  Enter_Description_Brand: 'Entrez la description de la marque',
  Enter_Code_Currency: 'Entrez le code de devise',
  Enter_name_Currency: 'Entrez le nom Devise',
  Enter_Symbol_Currency: 'Entrez le symbole de la devise',
  Enter_Name_Unit: 'Entrez le nom de l`\'unité',
  Enter_ShortName_Unit: 'Entrez le nom abrégé de l\'unité',
  Choose_Base_Unit: 'Choisissez l\'unité de base',
  Choose_Operator: 'Choisissez un opérateur',
  Enter_Operation_Value: 'Entrez la valeur de l\'opération',
  Enter_Name_Warehouse: 'Entrez le nom de l\'entrepôt',
  Enter_Phone_Warehouse: 'Entrez le téléphone de l\'entrepôt',
  Enter_Country_Warehouse: 'Entrez le pays de l\'entrepôt',
  Enter_City_Warehouse: 'Entrez la ville de l\'entrepôt',
  Enter_Email_Warehouse: 'Entrez  e-mail de l\'entrepôt',
  Enter_ZipCode_Warehouse: 'Entrez le code postal de l\'entrepôt',
  Choose_Currency: 'Choisir la devise',
  Thank_you_for_your_business: 'Merci de votre confiance!',
  Cancel: 'Annuler',
  New_Customer: 'Nouveau client',
  Incorrect_Login: 'Login incorrect',
  Successfully_Logged_In: 'Connexion réussie',
  This_user_not_active: 'Cet utilisateur n\'est pas actif',
  SignIn: 'S\'identifier',
  Create_an_account: 'Créer un compte',
  Forgot_Password: 'Mot de passe oublié ?',
  Email_Address: 'Adresse e-mail',
  SignUp: 'S\'inscrire',
  Already_have_an_account: 'Vous avez déjà un compte ?',
  Reset_Password: 'réinitialiser le mot de passe',
  Failed_to_authenticate_on_SMTP_server: 'Échec de l\'authentification sur le serveur SMTP',
  We_cant_find_a_user_with_that_email_addres: 'Nous ne pouvons pas trouver un utilisateur avec cette adresse e-mail',
  We_have_emailed_your_password_reset_link: 'Nous avons envoyé votre lien de réinitialisation de mot de passe par e-mail',
  Please_fill_the_Email_Adress: 'Veuillez remplir l\'adresse e-mail',
  Confirm_password: 'Confirmez le mot de passe',
  Your_Password_has_been_changed: 'Votre mot de passe a été changé',
  The_password_confirmation_does_not_match: 'La confirmation du mot de passe ne correspond pas',
  This_password_reset_token_is_invalid: 'Ce jeton de réinitialisation de mot de passe n\'est pas valide',
  Warehouse_report: 'Rapport d\'entrepôt',
  All_Warehouses: 'Tous les entrepôts',
  Expense_List: 'Liste de dépenses',
  Expenses: 'dépenses',
  This_Week_Sales_Purchases: 'Ventes et achats de cette semaine',
  Top_Selling_Products: 'Produits les plus vendus',
  View_all: 'Voir tout',
  Payment_Sent_Received: 'Paiement envoyé et reçu',
  Filter: 'Filtre',
  Invoice_POS: 'Facture POS',
  Invoice: 'Facture',
  Customer_Info: 'Infos client',
  Company_Info: 'Infos société',
  Invoice_Info: 'Infos facture',
  Order_Summary: 'Résumé de la commande',
  Quote_Info: 'Devis Infos',
  Del: 'Effacer',
  SuppliersPaiementsReport: 'Fournisseurs Rapport Paiements',
  Purchase_Info: 'Infos d\'achat',
  Supplier_Info: 'Info fournisseur',
  Return_Info: 'Info de retour',
  Expense_Category: 'Catégorie de dépenses',
  Create_Expense: 'Créer une dépense',
  Details: 'Détails',
  Discount_Method: 'Méthode de remise',
  Net_Unit_Cost: 'Coût unitaire net',
  Net_Unit_Price: 'Prix unitaire net',
  Edit_Expense: 'Modifier les dépenses',
  All_Brand: 'Toute marque',
  All_Category: 'All Category',
  ListExpenses: 'Liste des dépenses',
  Create_Permission: 'Créer une autorisation',
  Edit_Permission: 'Modifier l\'autorisation',
  Reports_payments_Sales: 'Rapports des paiements des ventes',
  Reports_payments_Purchases: 'Rapports des achats de paiements',
  Reports_payments_Return_Customers: 'Rapports de paiements Clients de retour',
  Reports_payments_Return_Suppliers: 'Rapports des paiements Retour Fournisseurs',
  Expense_Deleted: 'Cette dépense a été supprimée',
  Expense_Updated: 'Cette dépense a été mise à jour',
  Expense_Created: 'Cette dépense a été créée',
  DemoVersion: 'Vous ne pouvez pas faire cela dans la version de démonstration',
  OrderStatistics: 'Statistiques de ventes',
  AlreadyAdd: 'Ce produit est déjà ajouté !!',
  AddProductToList: 'Veuillez ajouter le produit à la liste !!',
  AddQuantity: 'Veuillez ajouter la quantité de produit !!',
  InvalidData: 'Données invalides !!',
  LowStock: 'la quantité dépasse la quantité disponible en stock',
  WarehouseIdentical: 'Les deux magasins ne peuvent pas être identiques !!',
  VariantDuplicate: 'Cette variable est redondante !!',
  Filesize: 'Taille du fichier',
  GenerateBackup: 'Générer une sauvegarde',
  BackupDatabase: 'Sauvegarde de la base de données',
  Backup: 'Sauvegarde DB',
  Paid: 'Payé',
  Unpaid: 'Non payé',
  IncomeExpenses: 'Revenus et dépenses',
  dailySalesPurchases: 'Ventes et achats quotidiens',
  ProductsExpired: 'Produits expirés',
  Today: 'Aujourd\'hui',
  Income: 'Revenu'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'Dépenses'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'Vente'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Télé'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Filter par Télé'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Active'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Inactive'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'Nom Client'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Gestion Du Stock'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Tableau de bord'), _defineProperty(_Receipt$Pos_Settings, "Products", 'Produits'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'Liste de produits'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'Stock Transfers'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'Clients'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Fournisseurs'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Devis'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'Ventes'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'Achats'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'Returns'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'Paramètres'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'Paramètres du système'), _defineProperty(_Receipt$Pos_Settings, "Users", 'Utilisateurs'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Autorisations de groupe'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'Devises'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Produits Taxe'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'Categories'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'Entrepôt'), _defineProperty(_Receipt$Pos_Settings, "Units", 'Unités'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'Unités Achats'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Unités Ventes'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'Rapports'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Paiements Rapports'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Paiements Achats'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Paiements Ventes'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Paiements Retours'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'Factures des retours'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'données des Factures de retours'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'Afficher tous les enregistrements de tous les utilisateurs'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Remise'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Taxe de commande'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'livraison'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Profit et perte'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Alertes de quantité'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Warehouse Stock Chart'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'Ventes Rapports'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Achats Rapports'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'Clients Rapports'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Fournisseurs Rapports'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Fournisseur Rapports'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'Ventes quotidiens'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'Achats quotidiens'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Dernières cinq records'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'Filtres'), _defineProperty(_Receipt$Pos_Settings, "date", 'Date'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Référence'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Fournisseur'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Statut de Paiement'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'Client'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'Client Code'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Statut'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Fournisseur Code'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Gestion des Produits'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Code Produit'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Catégorie'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'Sous-catégorie'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'Désignation'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Stock Alert'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'Magasin'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'Taxe'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Prix d\'achat'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Prix de vente'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'Quantité'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Action'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Unités de Vente'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'Unités d\'achat'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Détails Produit'), _defineProperty(_Receipt$Pos_Settings, "All", 'Tous'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Modifier Produit'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'Ajouter Produit'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Filter par Code'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Filter par Nom'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Ajouter'), _defineProperty(_Receipt$Pos_Settings, "add", 'Ajouter'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'Modifier'), _defineProperty(_Receipt$Pos_Settings, "Close", 'Fermer'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Veuillez sélectionner'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Gestion Du Clients'), _defineProperty(_Receipt$Pos_Settings, "Email", 'Email'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Modifier Client'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Ajouter Client'), _defineProperty(_Receipt$Pos_Settings, "Country", 'Pays'), _defineProperty(_Receipt$Pos_Settings, "City", 'Ville'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Adresse'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'Détails Client'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Liste Des Clients'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Code Fournisseur'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'Nom Fournisseur'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Gestion des Fournisseurs'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Détails Fournisseur'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Gestion des Devis'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Grand Total'), _defineProperty(_Receipt$Pos_Settings, "complete", 'completé'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'En attente'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Recu'), _defineProperty(_Receipt$Pos_Settings, "partial", 'partial'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Retournée'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Détail Devis'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Modifier Devis'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Créer une vente'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'Télécharger le PDF'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'Envoyé Devis sur Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Supprimé Devis'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'Ajouter Devis'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Sélectionnez un produit'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Produit (Code - Nom)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Prix'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'Stock'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Total'), _defineProperty(_Receipt$Pos_Settings, "Num", 'N°'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Cout unitaire'), _defineProperty(_Receipt$Pos_Settings, "to", 'à'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Sujet'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Message'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'Email Client'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Envoyer'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'Devis'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Bonjour'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Veuillez trouver la pièce jointe pour votre devis'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Ajouter les Produits sur la liste des commandes'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Sélectionner un entrepôt'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'Sélectionner un client'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Gestion  Des Ventes'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Balance'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Qté Retour'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Total Retour'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Montant reste'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Détail de la vente'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Modifier la vente'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Ajouter Vente'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Afficher les paiements'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'Ajouter un paiement'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Modifier le paiement'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Envoyer la vente par e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Supprimer la vente'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'Montant'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Mode de paiement'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Mode de règlement'), _defineProperty(_Receipt$Pos_Settings, "Note", 'Remarque'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Paiement compléte!'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'Gestion des utilisateurs'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'Prénom'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'Nom'), _defineProperty(_Receipt$Pos_Settings, "username", 'utilisateur'), _defineProperty(_Receipt$Pos_Settings, "type", 'Type'), _defineProperty(_Receipt$Pos_Settings, "password", 'Mot de Pass'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'Nouveau Mot Pass'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Changer d\'avatar'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Veuillez laisser ce champ vide si vous ne l\'avez pas changé'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Permissions des utilisateurs'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Nom Role'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Discription Role'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Ajouter des autorisations'), _defineProperty(_Receipt$Pos_Settings, "View", 'Afficher'), _defineProperty(_Receipt$Pos_Settings, "Del", 'Supprimer'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'Nouvel Ajustement'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Modifier Ajustement'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'Vous ne pouvez pas soustraire des produits en stock 0'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'Addition'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Soustraction'), _defineProperty(_Receipt$Pos_Settings, "profil", 'Profil'), _defineProperty(_Receipt$Pos_Settings, "logout", 'Se déconnecter'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'Vous ne pouvez pas modifier car cette Achat a déjà payé'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'Vous ne pouvez pas modifier car cette Vente a déjà payé'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'Vous ne pouvez pas modifier car cette Retour a déjà payé'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'Ce devis a déjà généré une vente'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'Cette Devis terminée'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Configuration du site'), _defineProperty(_Receipt$Pos_Settings, "Language", 'Langue'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Devise par défaut'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Captcha'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'Email par défaut'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Nom du site'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Changer le logo'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'Configuration SMTP'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'HÔTE'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'PORT'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'Chiffrement'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'Configuration SMTP incorrecte'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Gestion de devises'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Code de devise'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Nom de devise'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Symbole'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Nom de la société'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Tele de la société'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Adresse de la société'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), _defineProperty(_Receipt$Pos_Settings, "image", 'Image'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Imprimer le code-barres'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Retours de ventes'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Retours d\'achats'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'Facture Return Clients'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Facture Return Suppliers'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'Pas de données disponibles'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'Image du produit'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'Code-barre'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'Point de vente'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Téléchargement personnalisé'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'Gestion des points de vente'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Ajustement'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Mettre à jour'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Réinitialiser'), _defineProperty(_Receipt$Pos_Settings, "print", 'Impression'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Recherche par e-mail'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Choisissez un produit'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Qté'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Articles'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Montant HT'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'Montant TTC'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Veuillez sélectionner un fournisseur'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Veuillez sélectionner le statut'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'Payé avec'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Choisissez l\'entrepôt'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'Payez maintenant'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'Liste de la catégorie'), _defineProperty(_Receipt$Pos_Settings, "Description", 'Description'), _defineProperty(_Receipt$Pos_Settings, "submit", 'Soumettre'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'Un problème est survenu lors de la création de cette facture. Veuillez réessayer'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'Il y a eu un problème de paiement. Veuillez réessayer.'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'Créer un ajustement'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'Quelques mots sur ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'Image utilisateur'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Mettre à jour le produit'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'Marque'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'Symbologie des codes à barres'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'Prix d\'achat'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Prix de vente'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'Unité du Produit'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'Méthode fiscale'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'Image multiple'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'Le produit a plusieurs variantes'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'Le produit a une promotion'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Début de la promotion'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Fin de la promotion'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Prix de la promotion'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Prix'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'Coût'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'Unité'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'Variante de produit'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'Variante'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Prix unitaire'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'Créer un retour client'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Modifier le retour client'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'Créer le retour fournisseur'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'Doc'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'Modifier le retour fournisseur'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'De l\'entrepôt'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'vers l\'entrepôt'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'Modifier le transfert'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'Détail du transfert'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'En attente'), _defineProperty(_Receipt$Pos_Settings, "Received", 'Reçu'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Commandé'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'Gestion des autorisations'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'Gestion de la marque'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'Image de marque'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'Nom de marque'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'Description de la marque'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'Unité de base'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'Gestion des Unités'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Valeur d\'opération'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'Opération'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'Top 5 des produits'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", '5 dernières ventes'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'liste des Ajustements'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'Liste des transferts'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Créer un transfert'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'Gestion des commandes'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'Liste des quotes'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'Liste des achats'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'Liste des ventes'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'Liste des retours'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'Gestion des personnes'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'Liste des marques'), _defineProperty(_Receipt$Pos_Settings, "Delete", (_Delete = {
  Title: 'Êtes-vous sûr?',
  Text: 'Vous ne pourrez pas revenir en arrière!',
  confirmButtonText: 'Oui, supprimez-le!',
  cancelButtonText: 'Annuler',
  Deleted: 'Supprimé!',
  Failed: 'Échec!',
  Therewassomethingwronge: 'Il y avait quelque chose de mal',
  CustomerDeleted: 'Ce client a été supprimé.'
}, _defineProperty(_Delete, "CustomerDeleted", 'Cet utilisateur a été supprimé.'), _defineProperty(_Delete, "SupplierDeleted", 'Fournisseur a été supprimé'), _defineProperty(_Delete, "QuoteDeleted", 'Cette Devis a été supprimée.'), _defineProperty(_Delete, "SaleDeleted", 'Cette Vente a été supprimée.'), _defineProperty(_Delete, "PaymentDeleted", 'Cette Paiement a été supprimée.'), _defineProperty(_Delete, "PurchaseDeleted", 'Cette Achat a été supprimée.'), _defineProperty(_Delete, "ReturnDeleted", 'Cette Retour a été supprimée.'), _defineProperty(_Delete, "ProductDeleted", 'Ce produit a été supprimé'), _defineProperty(_Delete, "ClientError", 'Ce Client déja lié avec autre Opération'), _defineProperty(_Delete, "ProviderError", 'Ce fournisseur déja lié avec autre Opération'), _defineProperty(_Delete, "UnitDeleted", 'Cette unités a été supprimé'), _defineProperty(_Delete, "RoleDeleted", 'Ce Role a été supprimé'), _defineProperty(_Delete, "TaxeDeleted", 'Cette Taxe a été supprimé'), _defineProperty(_Delete, "SubCatDeleted", 'Cette sous Categorie a été supprimé'), _defineProperty(_Delete, "CatDeleted", 'Cette Categorie a été supprimé'), _defineProperty(_Delete, "WarehouseDeleted", 'Ce magasin a été supprimé'), _defineProperty(_Delete, "AlreadyLinked", 'Ce produit déja lié avec autre Opération'), _defineProperty(_Delete, "AdjustDeleted", 'Cet Ajustement a été supprimé'), _defineProperty(_Delete, "TitleCurrency", 'Cet Devise a été supprimé'), _defineProperty(_Delete, "TitleTransfer", 'Transfer a été supprimée avec succès'), _defineProperty(_Delete, "BackupDeleted", 'Sauvegarde a été supprimée avec succès'), _defineProperty(_Delete, "TitleBrand", 'Cette marque a été supprimée'), _Delete)), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleSetting: 'Paramétres mis à jour avec succès',
  TitleProfile: 'Profil mis à jour avec succès',
  TitleAdjust: 'Adjustement mis à jour avec succès',
  TitleRole: 'Role mis à jour avec succès',
  TitleUnit: 'Unités mis à jour avec succès',
  TitleUser: 'Utilisateur mis à jour avec succès',
  TitleProduct: 'Produit mis à jour avec succès',
  TitleCustomer: 'Client mis à jour avec succès',
  TitleQuote: 'Devis mis à jour  avec succès',
  TitleSale: 'Vente mis à jour  avec succès',
  TitlePayment: 'Paiement mis à jour  avec succès',
  TitlePurchase: 'Achat  mis à jour  avec succès',
  TitleReturn: 'Retour  mis à jour  avec succès',
  TitleSupplier: 'Fournisseur  mis à jour  avec succès',
  TitleTaxe: 'Taxe  mis à jour  avec succès',
  TitleCat: 'Categorie mis à jour avec succès',
  TitleWarhouse: 'Magasin mis à jour avec succès',
  TitleCurrency: 'Devise mis à jour avec succès',
  TitleTransfer: 'Transfer mis à jour avec succès',
  TitleBrand: 'Cette marque a été mise à jour'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'Cette marque a été créée',
  TitleTransfer: 'Transfer créé avec succès',
  TitleAdjust: 'Adjustement créé avec succès',
  TitleTaxe: 'Taxe créé avec succès',
  TitleRole: 'Role créé avec succès',
  TitleUnit: 'Unités créé avec succès',
  TitleUser: 'Utilisateur créé avec succès',
  TitleCustomer: 'Client créé avec succès',
  TitleQuote: 'Devis créé  avec succès',
  TitleSale: 'Vente créé  avec succès',
  TitlePayment: 'Paiement créé  avec succès',
  TitlePurchase: 'Achat créé  avec succès',
  TitleReturn: 'Retour créé  avec succès',
  TitleProduct: 'Produit créé avec succès',
  TitleSupplier: 'Fournisseur  créé  avec succès',
  TitleCat: 'Categorie  créé  avec succès',
  TitleWarhouse: 'Magasin créé avec succès',
  TitleCurrency: 'Devise créé avec succès'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email Envoyé avec succès'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'Cette vente déja liée avec un Retour!'
}), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Gestion des achats'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Commandé'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Supprimer l\'achat'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Envoyer l\'achat par e-mail'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'Modifier l\'achat'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'Détail d\'achat'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Ajouter d\'achat'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'Email Fournisseur'), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'Gestion des retours'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Détails du retour'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'Modifier le retour'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'Ajouter le retour'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'Envoyer le retour par e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Supprimer le retour'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'Return Surcharge'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'Laivrison'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Sélectionnez la vente'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'Vous pouvez supprimer l\'élément ou définir la quantité retournée à zéro si elle n\'est pas retournée'), _defineProperty(_Receipt$Pos_Settings, "Return", 'Retour'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'Achat'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Paiement des achats'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Données Paiement d\'achat'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoices", 'Paiement des ventes'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Données Paiement de vente'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'Ventes totales'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total des achats'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'Retours totaux'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'Paiement net'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'Paiements envoyés'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'Paiements reçus'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'Reçus'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Envoyés'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Alertes de quantité de produits'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Code produit'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'Produit'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'Quantité d\'alerte'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Graphique du stock d\'entrepôt'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'Total Produits'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'Total Quantity'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'Top 5 des clients'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Montant total'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'Total payé'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'Rapport des ventes'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Rapport des paiements'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'Rapport des Devis'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'Paiements'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'Top 5 Providers'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'Rapport des achats'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'Rapport des paiements'), _defineProperty(_Receipt$Pos_Settings, "Name", 'Nom'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'Gestion d\'entrepôt'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'Code postal'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Gestion des catégories'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'Code Catégorie'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'Name Catégorie'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'Parente Catégorie'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'Gestion fiscale'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'Nom de la taxe'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'Taux de taxe'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Gestion des unités d\'achats'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'Gestion des unités de vente'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'Nom court'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Veuillez les sélectionner avant d\'ajouter un produit'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'Ajustement des stocks'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'Veuillez les sélectionner magasin avant de choisir un produit'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'Transfert de stock'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'Sélectionnez la période'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'Cette année'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'Ce aujourd\'hui'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Ce mois-ci'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'Cette semaine'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'Détail d\'ajustement'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'Cet utilisateur a été activé'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'Cet utilisateur a été désactivé'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'Page non trouvée.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'Erreur! Page non trouvée.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'Nous n\'avons pas pu trouver la page que vous recherchiez.'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'Retour au tableau de bord'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'HRM'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'Employés'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'Présence'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Demande de congé'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Type de congé'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Compagnie'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Départements'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'Désignations'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Quart de bureau'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Vacances'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Entrez le nom de l\'entreprise'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Entrer l\'adresse e-mail'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Entrer le téléphone de l\'entreprise'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Saisir le pays de l\'entreprise'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Créé en avec succès'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Mis à jour avec succès'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Supprimé dans avec succès'), _defineProperty(_Receipt$Pos_Settings, "department", 'Département'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Entrez le nom du département'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Choisissez l\'entreprise'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Chef de département'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Choisissez le chef de département'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Entrer le nom du quart'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Monday In'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tuesday In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'Tuesday Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'Vacance'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Entrez le titre'), _defineProperty(_Receipt$Pos_Settings, "title", 'Titre'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Date de début'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Entrez la date de début'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Date de fin'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Entrez la date de fin'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Veuillez fournir des détails'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'Présences'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Entrez la date de présence'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'Choisissez l\'employé'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'Employée'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Durée du travail'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'Les Congés restantes sont insuffisantes'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Type de congé'), _defineProperty(_Receipt$Pos_Settings, "Days", 'Jours'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Département'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Choisissez le type de congé'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'Choisissez le statut'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Raison du congé'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Entrez la raison du congé'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Ajouter un employé'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'Prénom'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Entrez votre prénom'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Nom de famille'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Entrer le nom de famille'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Le sexe'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Choisissez le sexe'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Entrez la date de naissance'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Date de naissance'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Entrez le pays'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Entrez le numéro de téléphone'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Date d\'inscription'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Entrez la date d\'adhésion'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'Choisissez la désignation'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'La désignation'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Quart de bureau'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Choisissez le quart de travail'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Entrez la date de départ'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Date de départ'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Congé annuel'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Saisir les congés annuels'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Congé restant'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Détails de l\'employé'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Information basique'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Situation familiale'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Choisissez le statut familial'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Type d\'emploi'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Sélectionnez le type d\'emploi'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Entrez la ville'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Province'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Entrez la province'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Entrer l\'adresse'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Entrer le code postal'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Code postal'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Tarif horaire'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Entrez le taux horaire'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Salaire de base'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Entrez le salaire de base'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Réseaux sociaux'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skype'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Entrez Skype'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Entrez Facebook'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Entrez WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Entrez LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Entrez Twitter'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Expériences'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'compte bancaire'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Nom de l\'entreprise'), _defineProperty(_Receipt$Pos_Settings, "Location", 'l\'emplacement'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Entrez l\'emplacement'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Entrez la description'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Nom de banque'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Entrez le nom de la banque'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Agence bancaire'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Entrer l\'agence bancaire'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Numéro de banque'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Entrez le numéro de banque'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Entrepôts affectés'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'meilleurs clients'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Attachement'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'voir les employés'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'modifier les employés'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'supprimer des employés'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Ajouté par'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Ajouter le produit IMEI/numéro de série'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'Le produit a un numéro IMEI/série'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'Expéditions'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Livré à'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Réf d\'expédition'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Réf vente'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Modifier la livraison'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Emballé'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Expédié'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Livré'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Annulé'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Statut d\'envoi'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Rapport des utilisateurs'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'Rapport d\'inventaire'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total des achats'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Total des devis'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Total des retours de vente'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Total des retours d\'achat'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Total des transferts'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Total des ajustements'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'Rapport d\'utilisateur'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Stock actuel'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'Nom du produit'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Dette totale'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Dette totale'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Certains entrepôts'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'Tous les entrepôts'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Prix d\'achat'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'Paramètres SMS'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'Paramètres du point de vente'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Passerelle de paiement'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'Paramètres de messagerie'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Passerelle SMS par défaut'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Paramètres des modules'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Module activé avec succès'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Module désactivé avec succès'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Mettre à jour les paramètres'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Veuillez télécharger le bon module'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Importé avec succès'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'Détails du client'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Modifier le client'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Supprimer le client'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'payer dû'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'Le montant du paiement est supérieur au total dû'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Facture client'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'Ce produit n\'est pas à vendre'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Bienvenue sur votre tableau de bord'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Total à payer'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Choisissez la référence de la vente'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Veuillez sélectionner la vente'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Réf vente'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'list des retours de produits'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'Qté de retour'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Choisissez la référence d\'achat'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Réf d\'achat'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Veuillez sélectionner l\'achat'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'La quantité retournée est supérieure à la quantité achetée'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'La quantité retournée est supérieure à la quantité vendue'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Qté vendue'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Qté achetée'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Nom expéditeur'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'Le module doit être téléchargé sous forme de fichier zip'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Télécharger le module'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Tous les modules installés'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Version actuelle'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'Vous avez déjà la dernière version'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Mise à jour disponible'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Journal de mise à jour'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Mettez à jour maintenant'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Pied de facture'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'Voir la log des modifications'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'REMARQUE : Veuillez attendre que la mise à jour se termine complètement. Il n\'est pas recommandé de fermer le navigateur ou d\'arrêter un processus de mise à niveau'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Remarque : Assurez-vous de sauvegarder votre version actuelle et votre base de données avant d\'exécuter la mise à niveau, pour la restaurer en cas d\'erreur.'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Fuseau horaire'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'Paiement Remarque'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'notes de vente'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Vente totale dû'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Retour de vente total dû'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'payer toutes les dettes de vente à la fois'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'payer toutes les dettes de retour de vente à la fois'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Bénéfice brut'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'payer toutes les dettes d\'achat à la fois'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Supprimer le fournisseur'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Modifier le fournisseur'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Détails du fournisseur'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Dette d\'achat totale'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Note de crédit'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Note de crédit'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Retour de vente'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Retour d\'achat'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Numéro de TVA'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Veuillez ajouter la quantité de retour'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'Le retour existe pour la transaction'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'La quantité retournée est supérieure à la quantité restante'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Tous les produits dont la quantité est définie sur 0 ne seront pas remboursés'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'payer tous les retours d\'achat dus à la fois'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Total de la dette de retour d\'achat'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Retour d\'achat dû'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'Retour de vente dû'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'Rapport de produit'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'Rapport de vente de produits'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'Rapport d\'achat de produits'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'Qté vendue'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Qté achetée'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Filtrer par magasin'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Imprimer la facture automatiquement'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'voir l\'entrepôt'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Informations de carte de crédit'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Informations de carte de crédit enregistrées'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Carte de crédit changée avec succès'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Modèle de notification'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'Notification par email'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'Notification par SMS'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Modifier les détails du produit'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'Modifier les taxes, remises et livraison'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Créer une citation avec stock'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Nom de la variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Coût de la variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Prix de la variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Code de la variante'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Veuillez patienter jusqu\'à ce que le produit soit chargé'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Choisir la passerelle SMS'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Notification au client'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Tags disponibles'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'Objet de l\'email'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'Corps de l\'email'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Notification au fournisseur'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'Corps du SMS'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'Modèles de SMS'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Modèles d\'e-mails'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/hn.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/hn.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Hindi

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'रसीद',
  Pos_Settings: 'प्वाइंट डे वेंट सेटिंग्स',
  Note_to_customer: 'ग्राहक को नोट',
  Show_Note_to_customer: 'ग्राहक को नोट दिखाएं',
  Show_barcode: 'बरकोड़ दिखाओ',
  Show_Tax_and_Discount: 'टैक्स और छूट और शिपिंग दिखाएँ',
  Show_Customer: 'ग्राहक दिखाएँ',
  Show_Email: 'ईमेल दिखाएं',
  Show_Phone: 'फ़ोन दिखाएँ',
  Show_Address: 'पता दिखाएँ',
  DefaultLanguage: 'डिफ़ॉल्ट भाषा',
  footer: 'फ़ुटबाल',
  Received_Amount: 'प्राप्त राशि',
  Paying_Amount: 'भुगतान राशि',
  Change: 'परिवर्तन',
  Paying_amount_is_greater_than_Received_amount: 'भुगतान राशि प्राप्त राशि से अधिक है',
  Paying_amount_is_greater_than_Grand_Total: 'भुगतान राशि कुल योग से अधिक है',
  code_must_be_not_exist_already: 'कोड पहले से मौजूद नहीं होना चाहिए',
  You_will_find_your_backup_on: 'आपको अपना बैकअप इस पर मिलेगा',
  and_save_it_to_your_pc: 'और इसे अपने पीसी में सहेजें',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'अपना बारकोड स्कैन करें और नीचे सही सिम्बोलॉजी चुनें select',
  Scan_Search_Product_by_Code_Name: 'कोड नाम से उत्पाद स्कैन/खोजें',
  Paper_size: 'काग़ज़ का आकार',
  Clear_Cache: 'कैश को साफ़ करें',
  Cache_cleared_successfully: 'कैश सफलतापूर्वक साफ़ किया गया',
  Failed_to_clear_cache: 'कैशे साफ़ करने में विफल',
  Scan_Barcode: 'बारकोड स्कैनर',
  Please_use_short_name_of_unit: 'कृपया इकाई के संक्षिप्त नाम का प्रयोग करें',
  DefaultCustomer: 'डिफ़ॉल्ट ग्राहक',
  DefaultWarehouse: 'डिफ़ॉल्ट गोदाम',
  Payment_Gateway: 'अदायगी रास्ता',
  SMS_Configuration: 'एसएमएस कॉन्फ़िगरेशन',
  Gateway: 'अदायगी रास्ता',
  Choose_Gateway: 'पेमेंट गेटवे चुनें',
  Send_SMS: 'संदेश सफलतापूर्वक भेजा जा चुका है',
  sms_config_invalid: 'गलत sms कॉन्फिगर्ड अमान्य है',
  Remove_Stripe_Key_Secret: 'स्ट्राइप एपीआई कीज को डिलीट करें',
  credit_card_account_not_available: 'क्रेडिट कार्ड खाता उपलब्ध नहीं है',
  Credit_Card_Info: 'क्रेडिट कार्ड की जानकारी',
  developed_by: 'द्वारा विकसित',
  Unit_already_linked_with_sub_unit: 'यूनिट पहले से ही सब यूनिट के साथ जुड़ी हुई है',
  Total_Items_Quantity: 'कुल आइटम और मात्रा',
  Value_by_Cost_and_Price: 'मूल्य और मूल्य द्वारा मूल्य',
  Search_this_table: 'इस तालिका को खोजें',
  import_products: 'उत्पादों का आयात करें',
  Field_optional: 'क्षेत्र वैकल्पिक',
  Download_exemple: 'उदाहरण डाउनलोड करें',
  field_must_be_in_csv_format: 'फ़ील्ड सीएसवी प्रारूप में होनी चाहिए',
  Successfully_Imported: 'सफलतापूर्वक आयात किया गया',
  file_size_must_be_less_than_1_mega: 'फ़ाइल का आकार 1 मेगा से कम होना चाहिए',
  Please_follow_the_import_instructions: 'कृपया आयात निर्देशों का पालन करें',
  must_be_exist: 'इकाई पहले से ही बनाई जानी चाहिए',
  Import_Customers: 'ग्राहक आयात करें',
  Import_Suppliers: 'आयात आपूर्तिकर्ता',
  Recent_Sales: 'हाल की बिक्री',
  Create_Transfer: 'स्थानांतरण बनाएँ',
  order_products: 'चिजें मँगाओ',
  Search_Product_by_Code_Name: 'कोड या नाम से उत्पाद खोजें',
  Reports_payments_Purchase_Return: 'रिपोर्ट खरीद भुगतान',
  Reports_payments_Sale_Return: 'बिक्री विवरणी भुगतान रिपोर्ट',
  payments_Sales_Return: 'भुगतान बिक्री वापसी',
  payments_Purchases_Return: 'भुगतान खरीद वापसी',
  CreateSaleReturn: 'बिक्री वापसी बनाएँ',
  EditSaleReturn: 'बिक्री वापसी संपादित करें',
  SalesReturn: 'बिक्री वापसी',
  CreatePurchaseReturn: 'खरीद वापसी बनाएँ',
  EditPurchaseReturn: 'खरीद वापसी संपादित करें',
  PurchasesReturn: 'खरीद वापसी',
  Due: 'देय',
  Profit: 'फायदा',
  Revenue: 'राजस्व',
  Sales_today: 'आज बिक्री',
  People: 'लोग',
  Successfully_Created: 'सफलतापूर्वक बनाया गया',
  Successfully_Updated: 'सफलतापूर्वक उत्परिवर्तित',
  Success: 'सफलता',
  Failed: 'अनुत्तीर्ण होना',
  Warning: 'चेतावनी',
  Please_fill_the_form_correctly: 'कृपया फॉर्म सही से भरें',
  Field_is_required: 'ये स्थान भरा जाना है',
  Error: 'त्रुटि!',
  you_are_not_authorized: 'माफ़ करना! तुम अधिकृत नहीं हो।',
  Go_back_to_home: 'मुखपृष्ठ पर वापस जाएं',
  page_not_exist: 'माफ़ करना! जिस पृष्ठ को आप खोज रहे थे वह मौजूद नहीं है।',
  Choose_Status: 'स्थिति चुनें',
  Choose_Method: 'विधि चुनें',
  Choose_Symbology: 'सहजीवन चुनें',
  Choose_Category: 'वर्ग चुने',
  Choose_Customer: 'ग्राहक चुनें',
  Choose_Supplier: 'आपूर्तिकर्ता चुनें',
  Choose_Unit_Purchase: 'खरीद इकाई चुनें',
  Choose_Sub_Category: 'उपश्रेणी चुनें',
  Choose_Brand: 'ब्रांड चुनें',
  Choose_Warehouse: 'वेयरहाउस चुनें',
  Choose_Unit_Sale: 'बिक्री इकाई चुनें',
  Enter_Product_Cost: 'उत्पाद लागत दर्ज करें',
  Enter_Stock_alert: 'स्टॉक अलर्ट दर्ज करें',
  Choose_Unit_Product: 'उत्पाद इकाई चुनें',
  Enter_Product_Price: 'उत्पाद मूल्य दर्ज करें',
  Enter_Name_Product: 'नाम उत्पाद दर्ज करें',
  Enter_Role_Name: 'भूमिका का नाम दर्ज करें',
  Enter_Role_Description: 'भूमिका विवरण दर्ज करें',
  Enter_name_category: 'श्रेणी का नाम दर्ज करें',
  Enter_Code_category: 'श्रेणी कोड दर्ज करें',
  Enter_Name_Brand: 'नाम ब्रांड दर्ज करें',
  Enter_Description_Brand: 'विवरण ब्रांड दर्ज करें',
  Enter_Code_Currency: 'कोड करेंसी दर्ज करें',
  Enter_name_Currency: 'नाम दर्ज करें मुद्रा',
  Enter_Symbol_Currency: 'प्रतीक मुद्रा दर्ज करें',
  Enter_Name_Unit: 'इकाई का नाम दर्ज करें',
  Enter_ShortName_Unit: 'शॉर्टनेम यूनिट दर्ज करें',
  Choose_Base_Unit: 'बेस यूनिट चुनें',
  Choose_Operator: 'ऑपरेटर चुनें',
  Enter_Operation_Value: 'ऑपरेशन मान दर्ज करें',
  Enter_Name_Warehouse: 'वेयरहाउस का नाम दर्ज करें',
  Enter_Phone_Warehouse: 'वेयरहाउस फ़ोन दर्ज करें',
  Enter_Country_Warehouse: 'गोदाम देश दर्ज करें',
  Enter_City_Warehouse: 'वेयरहाउस सिटी दर्ज करें',
  Enter_Email_Warehouse: 'गोदाम ईमेल दर्ज करें',
  Enter_ZipCode_Warehouse: 'वेयरहाउस ज़िप कोड दर्ज करें',
  Choose_Currency: 'मुद्रा चुनिये',
  Thank_you_for_your_business: 'आपके व्यापार के लिए धन्यवाद!',
  Cancel: 'रद्द करना',
  New_Customer: 'नए ग्राहक',
  Incorrect_Login: 'गलत लॉगिन',
  Successfully_Logged_In: 'सफलतापूर्वक लॉग इन किया',
  This_user_not_active: 'यह उपयोगकर्ता सक्रिय नहीं है',
  SignIn: 'साइन इन करें',
  Create_an_account: 'खाता बनाएं',
  Forgot_Password: 'पासवर्ड भूल गए ?',
  Email_Address: 'ईमेल पता',
  SignUp: 'साइन अप करें',
  Already_have_an_account: 'क्या आपके पास पहले से एक खाता मौजूद है ?',
  Reset_Password: 'पासवर्ड रीसेट',
  Failed_to_authenticate_on_SMTP_server: 'SMTP सर्वर पर प्रमाणित करने में विफल',
  We_cant_find_a_user_with_that_email_addres: 'हमें उस ईमेल पते वाला उपयोगकर्ता नहीं मिल रहा है',
  We_have_emailed_your_password_reset_link: 'हमने आपका पासवर्ड रीसेट लिंक ई-मेल कर दिया है',
  Please_fill_the_Email_Adress: 'कृपया ईमेल पता भरें',
  Confirm_password: 'पासवर्ड की पुष्टि कीजिये',
  Your_Password_has_been_changed: 'आपका पासवर्ड बदल दिया गया है',
  The_password_confirmation_does_not_match: 'पासवर्ड की पुष्टि मेल नहीं खाती',
  This_password_reset_token_is_invalid: 'यह पासवर्ड रीसेट टोकन अमान्य है',
  Warehouse_report: 'वेयरहाउस की रिपोर्ट',
  All_Warehouses: 'सभी गोदाम',
  Expense_List: 'व्यय सूची',
  Expenses: 'व्यय',
  This_Week_Sales_Purchases: 'यह सप्ताह बिक्री और खरीद',
  Top_Selling_Products: 'शीर्ष बेचना उत्पाद',
  View_all: 'सभी देखें',
  Payment_Sent_Received: 'भुगतान भेजा और प्राप्त किया',
  Filter: 'फ़िल्टर',
  Invoice_POS: 'बीजक POS',
  Invoice: 'बीजक',
  Customer_Info: 'ग्राहक की जानकारी',
  Company_Info: 'कंपनी की जानकारी',
  Invoice_Info: 'चालान जानकारी',
  Order_Summary: 'आदेश सारांश',
  Quote_Info: 'उद्धरण जानकारी',
  Del: 'हटाएं',
  SuppliersPaiementsReport: 'आपूर्तिकर्ता भुगतान रिपोर्ट',
  Purchase_Info: 'खरीद जानकारी',
  Supplier_Info: 'आपूर्तिकर्ता जानकारी',
  Return_Info: 'वापसी की जानकारी',
  Expense_Category: 'व्यय की श्रेणी',
  Create_Expense: 'व्यय बनाएँ',
  Details: 'विवरण',
  Discount_Method: 'डिस्काउंट विधि',
  Net_Unit_Cost: 'नेट यूनिट लागत',
  Net_Unit_Price: 'शुद्ध इकाई मूल्य',
  Edit_Expense: 'व्यय संपादित करें',
  All_Brand: 'सभी ब्रांड',
  All_Category: 'सभी श्रेणी',
  ListExpenses: 'सूची व्यय',
  Create_Permission: 'अनुमति बनाएँ',
  Edit_Permission: 'अनुमति संपादित करें',
  Reports_payments_Sales: 'रिपोर्ट भुगतान बिक्री',
  Reports_payments_Purchases: 'रिपोर्ट भुगतान खरीद',
  Reports_payments_Return_Customers: 'रिपोर्ट भुगतान वापसी ग्राहकों',
  Reports_payments_Return_Suppliers: 'रिपोर्ट भुगतान वापसी आपूर्तिकर्ता',
  Expense_Deleted: 'यह व्यय हटा दिया गया है',
  Expense_Updated: 'यह व्यय अद्यतन किया गया है',
  Expense_Created: 'यह व्यय सृजित किया गया है',
  DemoVersion: 'आप डेमो संस्करण में ऐसा नहीं कर सकते',
  OrderStatistics: 'बिक्री के आँकड़े',
  AlreadyAdd: 'यह उत्पाद पहले से ही जोड़ा गया है',
  AddProductToList: 'कृपया सूची में उत्पाद जोड़ें',
  AddQuantity: 'कृपया विस्तार की मात्रा जोड़ें',
  InvalidData: 'अमान्य तथ्य',
  LowStock: 'मात्रा स्टॉक में उपलब्ध मात्रा से अधिक है',
  WarehouseIdentical: 'दो गोदाम समान नहीं हो सकते हैं',
  VariantDuplicate: 'ये वैरिएंट डुप्लीकेट है',
  Filesize: 'फाइल का आकार',
  GenerateBackup: 'बैकअप उत्पन्न करें',
  BackupDatabase: 'बैकअप डेटाबेस',
  Backup: 'बैकअप',
  Paid: 'भुगतान किया है',
  Unpaid: 'अवैतनिक',
  Today: 'आज',
  Income: 'आय'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'व्ययव्यय'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'बिक्री'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'सक्रिय'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'निष्क्रिय'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'ग्राहकों'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'फ़ोन'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'फ़ोन द्वारा खोजें'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'आपूर्तिकर्ता'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'कोटेशन'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'बिक्री'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'खरीद'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'रिटर्न'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'समायोजन'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'प्रणाली व्यवस्था'), _defineProperty(_Receipt$Pos_Settings, "Users", 'उपयोगकर्ता'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'समूह अनुमतियाँ'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'मुद्राओं'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'गोदामों'), _defineProperty(_Receipt$Pos_Settings, "Units", 'इकाइयों'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'इकाइयाँ खरीदता है'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'इकाइयों की बिक्री'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'भुगतान रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'भुगतान खरीद'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'भुगतान बिक्री'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'लाभ और हानि'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'गोदाम स्टॉक चार्ट'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'बिक्री रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'खरीद रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'ग्राहक रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'आपूर्तिकर्ता रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'आपूर्तिकर्ता रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'दैनिक बिक्री डेटा'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'दैनिक खरीद डेटा'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'पिछले पांच रिकॉर्ड'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'फिल्टर'), _defineProperty(_Receipt$Pos_Settings, "date", 'दिनांक'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'संदर्भ'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'प्रदायक'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'भुगतान की स्थिति'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'ग्राहक'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'ग्राहक क्रमांक'), _defineProperty(_Receipt$Pos_Settings, "Status", 'स्थिति'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'प्रदायक का कोड'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'वर्ग'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'श्रेणियाँ'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'स्टॉक ट्रांसफर'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'स्टाक प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'डैशबोर्ड'), _defineProperty(_Receipt$Pos_Settings, "Products", 'उत्पाद'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'उत्पादों की सूची'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'उत्पाद प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'उत्पाद मात्रा अलर्ट'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'कोड उत्पाद'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'उत्पाद कर'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'उपश्रेणी'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'पद'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'स्टॉक अलर्ट'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'गोदाम'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'कर'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'खरीद मूल्य'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'विक्रय मूल्य'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'मात्रा'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'इकाई बिक्री'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'यूनिट खरीद'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'मुद्रा प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'मुद्रा कोड'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'मुद्रा का नाम'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'प्रतीक'), _defineProperty(_Receipt$Pos_Settings, "All", 'सब'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'उत्पाद संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'कोड द्वारा खोजें'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'नाम से खोजें'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'उत्पाद विवरण'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'ग्राहक का नाम'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'ग्राहक प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "Add", 'सृजन करना'), _defineProperty(_Receipt$Pos_Settings, "add", 'सृजन करना'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "Close", 'बंद करे'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'कृपया चुने'), _defineProperty(_Receipt$Pos_Settings, "Action", 'कार्य'), _defineProperty(_Receipt$Pos_Settings, "Email", 'ईमेल'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'ग्राहक संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'ग्राहक बनाएं'), _defineProperty(_Receipt$Pos_Settings, "Country", 'देश'), _defineProperty(_Receipt$Pos_Settings, "City", 'शहर'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'पता'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'उपभोक्ता विवरण'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'ग्राहक सूची'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'प्रदायक का कोड'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'आपूर्तिकर्ता का नाम'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'आपूर्तिकर्ता प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'आपूर्तिकर्ता विवरण'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'उद्धरण प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'उप-योग'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'बची हुई राशि'), _defineProperty(_Receipt$Pos_Settings, "complete", 'पूरा कर लिया है'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'अपूर्ण'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'प्राप्त किया'), _defineProperty(_Receipt$Pos_Settings, "partial", 'आंशिक'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'वापसी'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'विस्तार उद्धरण'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'उद्धरण संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'बिक्री बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'डाउनलोड पीडीऍफ़'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'ईमेल पर भेजा गया उद्धरण'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'उद्धरण हटाएं'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'उद्धरण बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'उत्पाद का चयन करें'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'उत्पाद (कोड - नाम)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'कीमत'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'भण्डार'), _defineProperty(_Receipt$Pos_Settings, "Total", 'संपूर्ण'), _defineProperty(_Receipt$Pos_Settings, "Num", 'एन °'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'इकाई लागत'), _defineProperty(_Receipt$Pos_Settings, "to", 'सेवा'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'विषय'), _defineProperty(_Receipt$Pos_Settings, "Message", 'संदेश'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'ईमेल ग्राहक'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'संदेश'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'उद्धरण'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'नमस्कार'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'कृपया अपने उद्धरण के लिए अनुलग्नक ढूंढें'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'उत्पादों को ऑर्डर सूची में जोड़ें'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'कृपया गोदाम चुनें'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'कृपया ग्राहक चुनें'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'बिक्री प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'संतुलन'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'वापस मात्रा'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'कुल प्राप्ति'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'रकम'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'बिक्री विवरण'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'बिक्री संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'बिक्री बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'भुगतान दिखाएं'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'भुगतान बनाएं'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'भुगतान संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'ईमेल में बिक्री भेजें'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'बिक्री हटाएं'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'द्वारा भुगतान'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'भुगतान का विकल्प'), _defineProperty(_Receipt$Pos_Settings, "Note", 'ध्यान दें'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'भुगतान पूरा!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'खरीद प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'आदेश दिया'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'खरीद हटाएं'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'ईमेल में खरीद भेजें'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'खरीद संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'खरीद विवरण'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'खरीदारी बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'आपूर्तिकर्ता ईमेल'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'भुगतान खरीदता है'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'भुगतान डेटा खरीदता है'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'बिक्री भुगतान'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'बिक्री भुगतान डेटा'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'उपयोगकर्ता प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'पहला नाम'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'उपनाम'), _defineProperty(_Receipt$Pos_Settings, "username", 'उपयोगकर्ता नाम'), _defineProperty(_Receipt$Pos_Settings, "password", 'कुंजिका'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'नया पासवर्ड'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'अवतार परिवर्तन'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'यदि आपने इसे नहीं बदला है तो कृपया इस फ़ील्ड को खाली छोड़ दें'), _defineProperty(_Receipt$Pos_Settings, "type", 'प्रकार'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'उपयोगकर्ता अनुमतियाँ'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'भूमिका'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'भूमिका विवरण'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'अनुमतियाँ बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "View", 'राय'), _defineProperty(_Receipt$Pos_Settings, "Del", 'हटाएं'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'नया समायोजन'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'समायोजन संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'आप उन उत्पादों को घटा नहीं सकते जिनके पास स्टॉक 0 है'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'इसके अलावा'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'घटाव'), _defineProperty(_Receipt$Pos_Settings, "profil", 'प्रोफ़ाइल'), _defineProperty(_Receipt$Pos_Settings, "logout", 'लॉग आउट'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'आप संशोधित नहीं कर सकते क्योंकि यह खरीद पहले ही भुगतान कर चुकी है'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'आप संशोधित नहीं कर सकते क्योंकि यह बिक्री पहले ही भुगतान कर चुकी है'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'आप संशोधित नहीं कर सकते क्योंकि यह रिटर्न पहले ही भुगतान कर चुका है'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'यह उद्धरण पहले ही बिक्री उत्पन्न कर चुका है'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'उत्पाद बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'यह उद्धरण पूरा हुआ'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'साइट कॉन्फ़िगरेशन'), _defineProperty(_Receipt$Pos_Settings, "Language", 'भाषा: हिन्दी'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'डिफ़ॉल्ट मुद्रा'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'कैप्चा लॉगिन करें'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'डिफ़ॉल्ट ईमेल'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'साइट का नाम'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'लोगो बदलें'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'SMTP कॉन्फ़िगरेशन'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'मेज़बान'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'बंदरगाह'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'एन्क्रिप्शन'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'SMTP कॉन्फ़िगरेशन गलत है'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'भुगतान रिटर्न'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'चालान लौटाता है'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'चालान डेटा लौटाता है'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'Show all records of all Users'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'छूट'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'आदेश कर'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'शिपिंग'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'कंपनी का नाम'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Company Phone'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'कंपनी का पता'), _defineProperty(_Receipt$Pos_Settings, "Code", 'कोड'), _defineProperty(_Receipt$Pos_Settings, "image", 'छवि'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'प्रिंट बारकोड'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'ग्राहक लौटाता है'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'आपूर्तिकर्ता लौटाता है'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'ग्राहकों का चालान वापस करें'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'आपूर्तिकर्ता लौटें चालान'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'कोई डेटा उपलब्ध नहीं है'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'उत्पाद का चित्र'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'बारकोड'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'विक्रय पॉइंट'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'कस्टम अपलोड'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'बिक्री प्रबंधन का बिंदु'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'समायोजन'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'अपडेट करें'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'रीसेट'), _defineProperty(_Receipt$Pos_Settings, "print", 'छाप'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'ईमेल द्वारा खोजें'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'उत्पाद चुनें'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'मात्रा'), _defineProperty(_Receipt$Pos_Settings, "Items", 'आइटम'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'संपूर्ण'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'कुल रकम'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'कृपया आपूर्तिकर्ता का चयन करें'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'कृपया स्थिति चुनें'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'द्वारा भुगतान'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'वेयरहाउस चुनें'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'अब भुगतान करें'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'श्रेणी की सूची'), _defineProperty(_Receipt$Pos_Settings, "Description", 'विवरण'), _defineProperty(_Receipt$Pos_Settings, "submit", 'प्रस्तुत'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'इस चालान को बनाने में एक समस्या थी। कृपया पुन: प्रयास करें'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'भुगतान की समस्या थी। कृपया पुन: प्रयास करें।'), _defineProperty(_Receipt$Pos_Settings, "IncomeExpenses", 'आय और व्यय'), _defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'दैनिक बिक्री और खरीद'), _defineProperty(_Receipt$Pos_Settings, "ProductsExpired", 'उत्पाद समाप्त हो गए'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'सूची ब्रांड'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'समायोजन बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'कुछ शब्द ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'उपयोगकर्ता छवि'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'अद्यतन उत्पाद'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'ब्रांड'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'बारकोड सिम्बोलॉजी'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'सामान का मूल्य'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'उत्पाद की कीमत'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'यूनिट उत्पाद'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'कर विधि'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'एकाधिक छवि'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'उत्पाद में मल्टी वेरिएंट हैं'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'उत्पाद का प्रचार है'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'प्रमोशन शुरू'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'प्रमोशन का अंत'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'प्रोन्नति मूल्य'), _defineProperty(_Receipt$Pos_Settings, "Price", 'कीमत'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'लागत'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'इकाई'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'उत्पाद वेरिएंट'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'प्रकार'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'यूनिट मूल्य'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'ग्राहक बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'रिटर्न ग्राहक संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'रिटर्न सप्लायर बनाएं'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'प्रलेखन'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'रिटर्न प्रदायक संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'वेयरहाउस से'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'वेयरहाउस के लिए'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'स्थानांतरण संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'ट्रांसफर डिटेल'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'विचाराधीन'), _defineProperty(_Receipt$Pos_Settings, "Received", 'प्राप्त किया'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'आदेश दिया'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'अनुमतियाँ प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'ब्रांड'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'ब्रांड छवि'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'ब्रांड का नाम'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'ब्रांड विवरण'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'मूल इकाई'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'इकाइयाँ प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'ऑपरेशन मान'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'ऑपरेटर'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'शीर्ष पांच उत्पाद'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'पिछले पांच बिक्री'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'सूची समायोजन'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'सूची स्थानांतरण'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'स्थानांतरण बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'आदेश प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'सूची उद्धरण'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'सूची खरीद'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'सूची बिक्री'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'सूची रिटर्न'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'जन प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: 'क्या आपको यकीन है?',
  Text: 'आप इसे वापस नहीं कर पाएंगे!',
  confirmButtonText: 'हाँ, इसे हटा दें!',
  cancelButtonText: 'रद्द करना',
  Deleted: 'हटाए गए!',
  Failed: 'अनुत्तीर्ण होना!',
  Therewassomethingwronge: 'कुछ गड़बड़ थी',
  CustomerDeleted: 'इस ग्राहक को हटा दिया गया है।',
  SupplierDeleted: 'इस आपूर्तिकर्ता को हटा दिया गया है।',
  QuoteDeleted: 'यह उद्धरण हटा दिया गया है।',
  SaleDeleted: 'यह बिक्री हटा दी गई है।',
  PaymentDeleted: 'यह भुगतान हटा दिया गया है।',
  PurchaseDeleted: 'यह खरीद हटा दी गई है।',
  ReturnDeleted: 'यह रिटर्न हटा दिया गया है।',
  ProductDeleted: 'this Product has been deleted.',
  ClientError: 'यह क्लाइंट पहले से ही अन्य ऑपरेशन से जुड़ा हुआ है',
  ProviderError: 'यह आपूर्तिकर्ता पहले से ही अन्य ऑपरेशन से जुड़ा हुआ है',
  UserDeleted: 'यह उपयोगकर्ता हटा दिया गया है।',
  UnitDeleted: 'यह इकाई हटा दी गई है।',
  RoleDeleted: 'यह भूमिका हटा दी गई है।',
  TaxeDeleted: 'यह कर हटा दिया गया है।',
  SubCatDeleted: 'यह उप श्रेणी हटा दी गई है।',
  CatDeleted: 'यह श्रेणी हटा दी गई है।',
  WarehouseDeleted: 'यह वेयरहाउस हटा दिया गया है।',
  AlreadyLinked: 'यह उत्पाद पहले से ही अन्य ऑपरेशन से जुड़ा हुआ है',
  AdjustDeleted: 'यह समायोजन हटा दिया गया है।',
  TitleCurrency: 'यह मुद्रा हटा दी गई है।',
  TitleTransfer: 'स्थानांतरण सफलतापूर्वक हटा दिया गया है',
  BackupDeleted: 'बैकअप सफलतापूर्वक निकाल दिया गया है',
  TitleBrand: 'यह ब्रांड हटा दिया गया है'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleProfile: 'आपका प्रोफ़ाइल सफलतापूर्वक में अपडेट किया गया',
  TitleAdjust: 'समायोजन सफलतापूर्वक में अद्यतन किया गया',
  TitleRole: 'सफलतापूर्वक में भूमिका निभाई',
  TitleUnit: 'यूनिट को सफलतापूर्वक अपडेट किया गया',
  TitleUser: 'उपयोगकर्ता को सफलतापूर्वक अपडेट किया गया',
  TitleCustomer: 'सफलतापूर्वक ग्राहक अपडेट',
  TitleQuote: 'उद्धरण सफलतापूर्वक अपडेट किया गया',
  TitleSale: 'सफलतापूर्वक बिक्री की गई',
  TitlePayment: 'भुगतान सफलतापूर्वक में अपडेट किया गया',
  TitlePurchase: 'सफलतापूर्वक में अद्यतन किया गया',
  TitleReturn: 'सफलतापूर्वक में नवीनीकृत करें',
  TitleProduct: 'उत्पाद अद्यतन सफलतापूर्वक',
  TitleSupplier: 'आपूर्तिकर्ता सफलतापूर्वक में अद्यतन किया गया',
  TitleTaxe: 'कर अद्यतन सफलतापूर्वक',
  TitleCat: 'कर अद्यतन सफलतापूर्वक',
  TitleWarhouse: 'वेयरहाउस अद्यतन सफलतापूर्वक',
  TitleSetting: 'सेटिंग्स को सफलतापूर्वक में अपडेट किया गया',
  TitleCurrency: 'मुद्रा अद्यतन सफलतापूर्वक',
  TitleTransfer: 'सफलतापूर्वक में स्थानांतरण',
  TitleBrand: 'यह ब्रांड अद्यतन किया गया है'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'इस ब्रांड को बनाया गया है',
  TitleRole: 'भूमिका सफलतापूर्वक बनाई गई',
  TitleUnit: 'यूनिट सफलतापूर्वक बनाई गई',
  TitleUser: 'उपयोगकर्ता सफलतापूर्वक बनाया गया',
  TitleCustomer: 'सफलतापूर्वक बनाया गया ग्राहक',
  TitleQuote: 'उद्धरण सफलतापूर्वक बनाया गया',
  TitleSale: 'बिक्री सफलतापूर्वक बनाई गई',
  TitlePayment: 'भुगतान सफलतापूर्वक किया गया',
  TitlePurchase: 'सफलतापूर्वक खरीदी गई',
  TitleReturn: 'वापसी सफलतापूर्वक बनाई गई',
  TitleProduct: 'उत्पाद सफलतापूर्वक बनाया गया',
  TitleSupplier: 'आपूर्तिकर्ता सफलतापूर्वक बनाया गया',
  TitleTaxe: 'टैक्स सफलतापूर्वक बनाया गया',
  TitleCat: 'श्रेणी सफलतापूर्वक बनाई गई',
  TitleWarhouse: 'वेयरहाउस सफलतापूर्वक बनाया गया',
  TitleAdjust: 'समायोजन सफलतापूर्वक में बनाया गया',
  TitleCurrency: 'मुद्रा सफलतापूर्वक बनाई गई',
  TitleTransfer: 'सफलतापूर्वक में बनाया गया स्थानांतरण'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'ईमेल सफलतापूर्वक भेजें'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'यह बिक्री पहले ही एक रिटर्न के साथ जुड़ी हुई है!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'वापसी प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'विस्तार से लौटें'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'वापसी संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'रिटर्न बनाएँ'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'ईमेल में रिटर्न भेजें'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'रिटर्न डिलीट करें'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'सरचार्ज वापस करें'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'वितरण'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'बिक्री का चयन करें'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'आप आइटम को हटा सकते हैं या यदि वह वापस नहीं किया गया है तो शून्य पर वापस सेट की गई मात्रा सेट कर सकते हैं'), _defineProperty(_Receipt$Pos_Settings, "Return", 'वापसी'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'खरीद फरोख्त'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'संपूर्ण बिक्री'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'कुल खरीद'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'कुल रिटर्न'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'नेट भुगतान'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'भुगतान भेजा गया'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'भुगतान प्राप्त किया'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'प्राप्त किया'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'भेज दिया'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'उत्पाद मात्रा अलर्ट'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'कोड'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'उत्पाद'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'चेतावनी मात्रा'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'गोदाम स्टॉक चार्ट'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'कुल उत्पाद'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'कुल मात्रा'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'शीर्ष पांच ग्राहक'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'कुल रकम'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'कुल भुगतान हो गया'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'ग्राहक बिक्री रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'ग्राहक बिक्री रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'ग्राहक उद्धरण रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'भुगतान'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'शीर्ष पांच आपूर्तिकर्ता'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'आपूर्तिकर्ता खरीद रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'आपूर्तिकर्ता भुगतान रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "Name", 'नाम'), _defineProperty(_Receipt$Pos_Settings, "Code", 'कोड'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'गोदाम प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'पिन कोड'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'श्रेणियाँ प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'कोड श्रेणी'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'नाम श्रेणी'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'अभिभावक श्रेणी'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'कर प्रबंधन'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'कर का नाम'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'कर दर'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'क्रय इकाई'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'विक्रय इकाई'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'संक्षिप्त नाम'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'कृपया किसी भी उत्पाद को जोड़ने से पहले इनका चयन करें'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'स्टॉक समायोजन'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'कृपया किसी भी उत्पाद को चुनने से पहले गोदाम का चयन करें'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'स्टाक ट्रान्स्फ़र'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'अवधि का चयन करें'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'इस साल'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'यह आज'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'इस महीने'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'इस सप्ताह'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'समायोजन विवरण'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'इस उपयोगकर्ता को सक्रिय किया गया है'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'इस उपयोगकर्ता को निष्क्रिय कर दिया गया है'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'पृष्ठ नहीं मिला।'), _defineProperty(_Receipt$Pos_Settings, "oops", 'त्रुटि! पृष्ठ नहीं मिला।'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'आपको वह पृष्ठ नहीं मिला, जिसकी आप तलाश कर रहे थे। इसके अलावा, आप कर सकते हैं'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'डैशबोर्ड पर लौटें'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'एचआरएम'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'कर्मचारियों'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'उपस्थिति'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'छुट्टी का अनुरोध'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'छुट्टी का प्रकार'), _defineProperty(_Receipt$Pos_Settings, "Company", 'कंपनी'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'विभागों'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'पदनाम'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'कार्यालय शिफ्ट'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'छुट्टियां'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'कंपनी का नाम दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'ईमेल पता दर्ज'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'कंपनी फोन दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'कंपनी देश दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'सफलतापूर्वक बनाया गया'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'सफलतापूर्वक अपडेट किया गया'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'सफलतापूर्वक हटा दिया गया'), _defineProperty(_Receipt$Pos_Settings, "department", 'विभाग'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'विभाग का नाम दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'कंपनी चुनें'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'विभाग के प्रमुख'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'विभाग प्रमुख चुनें'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'शिफ्ट का नाम दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Monday In'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tuesday In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'tuesday Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'छुट्टी'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'शीर्षक दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "title", 'शीर्षक'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'आरंभ करने की तिथि'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'प्रारंभ तिथि दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'समाप्ति अवधि'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'समाप्ति तिथि दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'कृपया कोई विवरण प्रदान करें'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'उपस्थिति'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'उपस्थिति तिथि दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'कर्मचारी चुनें'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'कर्मचारी'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'कार्य अवधि'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'शेष पत्ते अपर्याप्त'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'छुट्टी का प्रकार'), _defineProperty(_Receipt$Pos_Settings, "Days", 'दिन'), _defineProperty(_Receipt$Pos_Settings, "Department", 'विभाग'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'छुट्टी का प्रकार चुनें'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'स्थिति चुनें'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'कारण छोड़ें'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'कारण छुट्टी दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'कर्मचारी जोड़ें'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'पहला नाम'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'प्रथम नाम दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'अंतिम नाम'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'अंतिम नाम दर्ज करो'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'लिंग'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'लिंग चुनें'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'जन्म तिथि दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'जन्म दिन'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'देश दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'फोन नंबर दर्ज'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'में शामिल होने की तारीख'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'शामिल होने की तिथि दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'पदनाम चुनें'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'पदनाम'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'कार्यालय शिफ्ट'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'ऑफिस शिफ्ट चुनें'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'प्रस्थान तिथि दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'प्रस्थान तिथि'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'वार्षिक छुट्टी'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'वार्षिक अवकाश दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'शेष छुट्टी'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'कर्मचारी विवरण'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'मूल जानकारी'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'पारिवारिक स्थिति'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'पारिवारिक स्थिति चुनें'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'रोजगार के प्रकार'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'रोजगार प्रकार चुनें'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'शहर दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Province", 'प्रांत'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'प्रांत दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'पता लिखिए'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'ज़िप कोड दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'पिन कोड'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'प्रति घंटा - दर'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'प्रति घंटा दर दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'मूल वेतन'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'मूल वेतन दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'सामाजिक मीडिया'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'स्काइप'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'स्काइप दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'फेसबुक'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'फेसबुक दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'व्हाट्सएप'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'व्हाट्सएप दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'लिंक्डइन'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'लिंक्डइन दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'ट्विटर'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'ट्विटर दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'अनुभवों'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'बैंक खाता'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'कंपनी का नाम'), _defineProperty(_Receipt$Pos_Settings, "Location", 'स्थान'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'स्थान दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'विवरण दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'बैंक का नाम'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'बैंक का नाम दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'बैंक शाखा'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'बैंक शाखा दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'बैंक नंबर'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'बैंक नंबर दर्ज करें'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'असाइन किए गए वेयरहाउस'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'शीर्ष ग्राहक'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'अटैचमेंट'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'कर्मचारियों को देखें'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'कर्मचारियों को संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'कर्मचारियों को हटाएं'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'द्वारा जोड़ा'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'उत्पाद IMEI/सीरियल नंबर जोड़ें'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'उत्पाद में Imei/सीरियल नंबर है'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'लदान'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'को पहुंचा दिया गया'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'शिपमेंट रेफरी'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'बिक्री संदर्भ'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'शिपिंग संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'पैक्ड'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'लादा गया'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'पहुंचा दिया'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'रद्द'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'शिपिंग की स्थिति'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'उपयोगकर्ता रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'स्टॉक रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'कुल खरीद'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'कुल कोटेशन'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'कुल वापसी बिक्री'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'कुल वापसी खरीद'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'कुल स्थानान्तरण'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'कुल समायोजन'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'उपयोगकर्ता रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'वर्तमान स्टॉक'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'प्रोडक्ट का नाम'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'कुल ऋण'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'कुल ऋण'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'कुछ गोदाम'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'सभी गोदाम'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'सामान का मूल्य'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'एसएमएस सेटिंग्स'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'पीओएस सेटिंग्स'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'भुगतान गेटवे'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'मेल सेटिंग्स'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'डिफ़ॉल्ट एसएमएस गेटवे'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'मॉड्यूल सेटिंग्स'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'मॉड्यूल सफलतापूर्वक सक्षम किया गया'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'मॉड्यूल सफलतापूर्वक अक्षम किया गया'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'सेटिंग अपडेट करें'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'कृपया सही मॉड्यूल अपलोड करें'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'सफलतापूर्वक अपलोड किया गया'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'ग्राहक विवरण'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'ग्राहक संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'ग्राहक हटाएं'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'बकाया भुगतान करें'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'भुगतान राशि कुल देय राशि से अधिक है'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'ग्राहक का बिल'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'यह उत्पाद बेचने के लिए नहीं'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'आपके डैशबोर्ड में आपका स्वागत है'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'कुल देय'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'बिक्री रेफरी चुनें'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'कृपया बिक्री का चयन करें'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'बिक्री संदर्भ'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'सूची उत्पाद रिटर्न'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'मात्रा वापसी'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'खरीद रेफरी चुनें'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'खरीद संदर्भ'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'कृपया खरीद का चयन करें'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'मात्रा वापसी खरीदी गई मात्रा से अधिक है'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'मात्रा वापसी बेची गई मात्रा से अधिक है'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'बेची गई मात्रा'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'खरीदी गई मात्रा'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'भेजने वाले का नाम'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'मॉड्यूल को ज़िप फ़ाइल के रूप में अपलोड किया जाना चाहिए'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'मॉड्यूल अपलोड करें'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'सभी मॉड्यूल स्थापित'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'वर्तमान संस्करण'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'आपके पास पहले से ही नवीनतम संस्करण है'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'उपलब्ध अद्यतन'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'लॉग अपडेट करें'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'अभी अद्यतन करें'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'परिवर्तन लॉग देखें'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'चालान पाद लेख'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'नोट: कृपया अपडेट के पूरी तरह से समाप्त होने की प्रतीक्षा करें। ब्राउज़र को बंद करने या किसी प्रक्रिया को रोकने की अनुशंसा नहीं की जाती है अपग्रेड'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'नोट: सुनिश्चित करें कि आप अपग्रेड चलाने से पहले अपने वर्तमान संस्करण और डेटाबेस का बैकअप लें, यदि कोई त्रुटि है तो इसे पुनर्स्थापित करने के लिए'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'समय क्षेत्र'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'भुगतान के नोट'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'बिक्री नोट'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'कुल बिक्री कर्ज'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'कुल बिक्री वापसी ऋण'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'एक बार में सभी बिक्री ऋण का भुगतान करें'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'एक बार में सभी बिक्री रिटर्न ऋण का भुगतान करें'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'सकल लाभ'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'एक बार में सभी खरीद ऋण का भुगतान करें'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'प्रदाता हटाएं'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'प्रदाता संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'प्रदाता विवरण'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'कुल खरीद कर्ज'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'क्रेडिट नोट'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'क्रेडिट नोट'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'वापसी बेचें'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'खरीद रिटर्न'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'कर संख्या'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'कृपया वापसी मात्रा जोड़ें'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'लेन-देन के लिए वापसी मौजूद है'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'मात्रा का रिटर्न शेष मात्रा से अधिक है'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", '0 पर सेट की गई मात्रा वाले किसी भी उत्पाद की धन-वापसी नहीं की जाएगी'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'एक बार में सभी खरीद रिटर्न ऋण का भुगतान करें'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'कुल खरीद वापसी ऋण'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'खरीद वापसी देय'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'रिटर्न कर्ज बेचें'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'उत्पाद रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'उत्पाद की बिक्री रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'उत्पाद खरीद रिपोर्ट'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'मात्रा बेची गई'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'खरीदी गई मात्रा'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'गोदाम द्वारा फ़िल्टर करें'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'चालान स्वचालित रूप से प्रिंट करें'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'गोदाम देखें'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'क्रेडिट कार्ड की जानकारी'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'सहेजी गई क्रेडिट कार्ड की जानकारी'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'क्रेडिट कार्ड सफलतापूर्वक बदल दिया गया'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'सूचना टेम्पलेट'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'ईमेल सूचना'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'एसएमएस सूचना'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'उत्पाद विवरण बदलें'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'टैक्स, डिस्काउंट और शिपिंग को संपादित करें'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'स्टॉक के साथ कोटेशन बनाएं'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'वेरिएंट का नाम'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'वेरिएंट का खर्च'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'वेरिएंट का मूल्य'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'वेरिएंट कोड'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'कृपया उत्पाद लोड होने तक प्रतीक्षा करें'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'एसएमएस गेटवे चुनें'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'ग्राहक को सूचित करना'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'उपलब्ध टैग'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'ईमेल विषय'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'ईमेल शरीर'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'आपूर्तिकर्ता को सूचित करना'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'एसएमएस शरीर'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'एसएमएस टेम्पलेट्स'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'ईमेल टेम्पलेट्स'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/it.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/it.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Italien

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Ricevuta',
  Pos_Settings: 'Impostazioni punto vendita',
  Note_to_customer: 'Nota per il cliente',
  Show_Note_to_customer: 'Mostra nota al cliente',
  Show_barcode: 'Mostra il codice a barre',
  Show_Tax_and_Discount: 'Mostra tasse e sconti e spedizione',
  Show_Customer: 'Mostra cliente',
  Show_Email: 'Mostra e-mail',
  Show_Phone: 'Mostra telefono',
  Show_Address: 'Mostra indirizzo',
  DefaultLanguage: 'Lingua di default',
  footer: 'piè di pagina',
  Received_Amount: 'Importo ricevuto',
  Paying_Amount: 'Importo da pagare',
  Change: 'Modificare',
  Paying_amount_is_greater_than_Received_amount: 'L\'importo del pagamento è maggiore dell\'importo ricevuto',
  Paying_amount_is_greater_than_Grand_Total: 'L\'importo del pagamento è maggiore del totale complessivo',
  code_must_be_not_exist_already: 'il codice non deve esistere già',
  You_will_find_your_backup_on: 'Troverai il tuo backup su',
  and_save_it_to_your_pc: 'e salvalo sul tuo pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scansiona il tuo codice a barre e seleziona la simbologia corretta di seguito',
  Scan_Search_Product_by_Code_Name: 'Scansione/ricerca prodotto per nome in codice',
  Paper_size: 'Dimensioni del foglio',
  Clear_Cache: 'Cancella cache',
  Cache_cleared_successfully: 'Cache cancellata con successo',
  Failed_to_clear_cache: 'Impossibile svuotare la cache',
  Scan_Barcode: 'Scanner di codici a barre',
  Please_use_short_name_of_unit: 'Si prega di utilizzare il nome breve dell\'unità',
  DefaultCustomer: 'Cliente predefinito',
  DefaultWarehouse: 'Magazzino predefinito',
  Payment_Gateway: 'Casello stradale',
  SMS_Configuration: 'Configurazione SMS',
  Gateway: 'Casello stradale',
  Choose_Gateway: 'Scegli Payment Gateway',
  Send_SMS: 'messaggio inviato con successo',
  sms_config_invalid: 'configurazione sms errata non valida',
  Remove_Stripe_Key_Secret: 'Elimina le chiavi API Stripe',
  credit_card_account_not_available: 'Conto della carta di credito non disponibile',
  Credit_Card_Info: 'Informazioni sulla carta di credito',
  developed_by: 'Sviluppato da',
  Unit_already_linked_with_sub_unit: 'Unità già abbinata a sottounità',
  Total_Items_Quantity: 'Articoli totali e quantità',
  Value_by_Cost_and_Price: 'Valore per costo e prezzo',
  Search_this_table: 'Cerca in questa tabella',
  import_products: 'Importa prodotti',
  Field_optional: 'Campo facoltativo',
  Download_exemple: 'Scarica esempio',
  field_must_be_in_csv_format: 'Il campo deve essere in formato csv',
  Successfully_Imported: 'Importato con successo',
  file_size_must_be_less_than_1_mega: 'La dimensione del file deve essere inferiore a 1 mega',
  Please_follow_the_import_instructions: 'Segui le istruzioni per l\'importazione',
  must_be_exist: 'l\'unità deve essere già creata',
  Import_Customers: 'Importa clienti',
  Import_Suppliers: 'Fornitori di importazione',
  Recent_Sales: 'Vendite recenti',
  Create_Transfer: 'Crea trasferimento',
  order_products: 'articoli dell\'ordine',
  Search_Product_by_Code_Name: 'Cerca prodotto per codice o nome',
  Reports_payments_Purchase_Return: 'Rapporti sui pagamenti dei resi di acquisto',
  Reports_payments_Sale_Return: 'Rapporti sui pagamenti dei resi di vendita',
  payments_Sales_Return: 'ritorno delle vendite dei pagamenti',
  payments_Purchases_Return: 'ritorno acquisti pagamenti',
  CreateSaleReturn: 'Crea reso vendita',
  EditSaleReturn: 'Modifica reso vendita',
  SalesReturn: 'Reso di vendita',
  CreatePurchaseReturn: 'Crea reso acquisto',
  EditPurchaseReturn: 'Modifica reso acquisto',
  PurchasesReturn: 'Restituzione acquisti',
  Due: 'dovuto',
  Profit: 'Profitto',
  Revenue: 'Reddito',
  Sales_today: 'Vendite oggi',
  People: 'Persone',
  Successfully_Created: 'Creato con successo',
  Successfully_Updated: 'Aggiornato con successo',
  Success: 'Successo',
  Failed: 'Fallito',
  Warning: 'avvertimento',
  Please_fill_the_form_correctly: 'Si prega di compilare correttamente il modulo',
  Field_is_required: 'Il campo è obbligatiorio',
  Error: 'Errore!',
  you_are_not_authorized: 'Scusate! non sei autorizzato.',
  Go_back_to_home: 'Torna alla home page',
  page_not_exist: 'Scusate! La pagina che stavi cercando non esiste.',
  Choose_Status: 'Scegli Stato',
  Choose_Method: 'Scegli il metodo',
  Choose_Symbology: 'Scegli la simbologia',
  Choose_Category: 'Scegli la categoria',
  Choose_Customer: 'Scegli cliente',
  Choose_Supplier: 'Scegli fornitore',
  Choose_Unit_Purchase: 'Scegli unità di acquisto',
  Choose_Sub_Category: 'Scegli Sottocategoria',
  Choose_Brand: 'Scegli il marchio',
  Choose_Warehouse: 'Scegli Magazzino',
  Choose_Unit_Sale: 'Scegli unità di vendita',
  Enter_Product_Cost: 'Immettere il costo del prodotto',
  Enter_Stock_alert: 'Inserisci avviso di stock',
  Choose_Unit_Product: 'Scegli unità di prodotto',
  Enter_Product_Price: 'Immettere il prezzo del prodotto',
  Enter_Name_Product: 'Immettere il nome del prodotto',
  Enter_Role_Name: 'Immettere il nome del ruolo',
  Enter_Role_Description: 'Immettere la descrizione del ruolo',
  Enter_name_category: 'Immettere il nome della categoria',
  Enter_Code_category: 'Immettere il codice della categoria',
  Enter_Name_Brand: 'Immettere il nome del marchio',
  Enter_Description_Brand: 'Immettere il marchio della descrizione',
  Enter_Code_Currency: 'Immettere la valuta del codice',
  Enter_name_Currency: 'Immettere il nome Valuta',
  Enter_Symbol_Currency: 'Immettere la valuta del simbolo',
  Enter_Name_Unit: 'Immettere il nome dell\'unità',
  Enter_ShortName_Unit: 'Immettere il nome abbreviato Unità',
  Choose_Base_Unit: 'Scegli unità base',
  Choose_Operator: 'Scegli operatore',
  Enter_Operation_Value: 'Immettere il valore dell\'operazione',
  Enter_Name_Warehouse: 'Immettere il nome del magazzino',
  Enter_Phone_Warehouse: 'Inserisci il numero di telefono del magazzino',
  Enter_Country_Warehouse: 'Immettere il Paese magazzino',
  Enter_City_Warehouse: 'Inserisci la città del magazzino',
  Enter_Email_Warehouse: 'Inserisci l\'email del magazzino',
  Enter_ZipCode_Warehouse: 'Inserisci il codice postale del magazzino',
  Choose_Currency: 'Scegli Valuta',
  Thank_you_for_your_business: 'Grazie per il tuo business!',
  Cancel: 'Annulla',
  New_Customer: 'Nuovo cliente',
  Incorrect_Login: 'Accesso errato',
  Successfully_Logged_In: 'Accesso eseguito con successo',
  This_user_not_active: 'Questo utente non è attivo',
  SignIn: 'Registrati',
  Create_an_account: 'Crea un account',
  Forgot_Password: 'Ha dimenticato la password ?',
  Email_Address: 'Indirizzo e-mail',
  SignUp: 'Iscriviti',
  Already_have_an_account: 'Hai già un account ?',
  Reset_Password: 'Resetta la password',
  Failed_to_authenticate_on_SMTP_server: 'Autenticazione sul server SMTP non riuscita',
  We_cant_find_a_user_with_that_email_addres: 'Non riusciamo a trovare un utente con quell\'indirizzo email',
  We_have_emailed_your_password_reset_link: 'Abbiamo inviato per e-mail il tuo link per la reimpostazione della password',
  Please_fill_the_Email_Adress: 'Si prega di compilare l\'indirizzo e-mail',
  Confirm_password: 'Conferma password',
  Your_Password_has_been_changed: 'La tua password è stata modificata',
  The_password_confirmation_does_not_match: 'La conferma della password non corrisponde',
  This_password_reset_token_is_invalid: 'Questo token di reimpostazione della password non è valido',
  Warehouse_report: 'Rapporto di magazzino',
  All_Warehouses: 'Tutti i magazzini',
  Expense_List: 'Lista delle spese',
  Expenses: 'Spese',
  This_Week_Sales_Purchases: 'Vendite e acquisti di questa settimana',
  Top_Selling_Products: 'Prodotti più venduti',
  View_all: 'Mostra tutto',
  Payment_Sent_Received: 'Pagamento inviato e ricevuto',
  Filter: 'Filtro',
  Invoice_POS: 'Fattura POS',
  Invoice: 'Fattura',
  Customer_Info: 'Info clienti',
  Company_Info: 'azienda Info',
  Invoice_Info: 'Info fattura',
  Order_Summary: 'Riepilogo ordine',
  Quote_Info: 'Info quotazione',
  Del: 'Elimina',
  SuppliersPaiementsReport: 'Report pagamenti fornitori',
  Purchase_Info: 'Informazioni sull\'acquisto',
  Supplier_Info: 'Informazioni sul fornitore',
  Return_Info: 'informazioni di ritorno',
  Expense_Category: 'Categoria di spesa',
  Create_Expense: 'Crea spesa',
  Details: 'Dettagli',
  Discount_Method: 'Metodo di sconto',
  Net_Unit_Cost: 'Costo unitario netto',
  Net_Unit_Price: 'Prezzo unitario netto',
  Edit_Expense: 'Modifica spesa',
  All_Brand: 'Tutto il marchio',
  All_Category: 'Tutte le categorie',
  ListExpenses: 'Elenco delle spese',
  Create_Permission: 'Crea autorizzazione',
  Edit_Permission: 'Modifica autorizzazione',
  Reports_payments_Sales: 'Segnala i pagamenti delle vendite',
  Reports_payments_Purchases: 'Segnala pagamenti acquisti',
  Reports_payments_Return_Customers: 'Segnala pagamenti Resi clienti',
  Reports_payments_Return_Suppliers: 'Segnala pagamenti Resi Fornitori',
  Expense_Deleted: 'Questa spesa è stata cancellata',
  Expense_Updated: 'Questa spesa è stata aggiornata',
  Expense_Created: 'Questa spesa è stata creata',
  DemoVersion: 'Non puoi farlo nella versione demo',
  Filesize: 'Dimensione del file',
  GenerateBackup: 'Genera backup',
  BackupDatabase: 'Backup del database',
  Backup: 'Backup del database',
  OrderStatistics: 'Statistiche di vendita',
  AlreadyAdd: 'Este producto ya está agregado',
  AddProductToList: 'Agregue el producto a la lista',
  AddQuantity: 'Por favor agregue la cantidad',
  InvalidData: 'Datos inválidos',
  LowStock: 'la quantità supera la quantità disponibile in magazzino',
  WarehouseIdentical: 'Los dos repositorios no pueden ser idénticos',
  VariantDuplicate: 'Esta variable es redundante',
  Paid: 'Pagato',
  Unpaid: 'Non pagato',
  IncomeExpenses: 'Entrate e uscite',
  dailySalesPurchases: 'Vendite e acquisti giornalieri',
  ProductsExpired: 'Prodotti scaduti',
  Today: 'oggi',
  Income: 'Reddito'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'Spese'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'Vendita'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Attivo'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Inattivo'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'I clienti'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Telefono'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Cerca per telefono'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Fornitori'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Quotazione'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'I saldi'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'acquisti'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'ritorna'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'impostazioni'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'Impostazioni di sistema'), _defineProperty(_Receipt$Pos_Settings, "Users", 'utenti'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Autorizzazioni di gruppo'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'valute'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'magazzini'), _defineProperty(_Receipt$Pos_Settings, "Units", 'unità'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'Acquisti di unità'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Vendite di unità'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'Rapporti'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Rapporto sui pagamenti'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Pagamenti Acquisti'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Vendite di pagamenti'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Profitti e perdite'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Grafico azioni magazzino'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'Rapporto delle vendite'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Rapporto d\'acquisto'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'Rapporto dei clienti'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Rapporto fornitori'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Rapporto del fornitore'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'Dati di vendita giornalieri'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'Dati di acquisto giornalieri'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Ultimi cinque record'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'filtri'), _defineProperty(_Receipt$Pos_Settings, "date", 'Data'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Riferimento'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Fornitore'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Stato del pagamento'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'Cliente'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'Codice Cliente'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Stato'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Codice fornitore'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Categoria'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'categorie'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'Trasferimenti di azioni'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Gestione delle scorte'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Pannello di controllo'), _defineProperty(_Receipt$Pos_Settings, "Products", 'Prodotti'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'Elenco prodotti'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Gestione del prodotto'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Avviso quantità prodotto'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Codice prodotto'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Imposta sul prodotto'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'sottocategoria'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'Designazione'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Avviso stock'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'magazzino'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'Imposta'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Prezzo d\'acquisto'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Prezzo di vendita'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'Quantità'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Vendita unitaria'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'Acquisto unitario'), _defineProperty(_Receipt$Pos_Settings, "All", 'Tutti'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Modifica prodotto'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'Aggiungi prodotto'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Cerca per codice'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Ricerca per nome'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Dettagli del prodotto'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'Nome del cliente'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Gestione clienti'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Inserisci'), _defineProperty(_Receipt$Pos_Settings, "add", 'Inserisci'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'modificare'), _defineProperty(_Receipt$Pos_Settings, "Close", 'Vicino'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Si prega di selezionare'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Azione'), _defineProperty(_Receipt$Pos_Settings, "Email", 'E-mail'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Modifica cliente'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Aggiungi cliente'), _defineProperty(_Receipt$Pos_Settings, "Country", 'Nazione'), _defineProperty(_Receipt$Pos_Settings, "City", 'Città'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Indirizzo'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'Dettagli cliente'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Elenco clienti'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Codice fornitore'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'Nome del fornitore'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Gestione dei fornitori'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Dettagli del fornitore'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Gestione delle quotazioni'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'totale parziale'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Importo rimasto'), _defineProperty(_Receipt$Pos_Settings, "complete", 'completare'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'in attesa di'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Ricevuto'), _defineProperty(_Receipt$Pos_Settings, "partial", 'Parziale'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Ritorno'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Quotazione di dettaglio'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Modifica Quotazione'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Crea vendita'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'Scarica il pdf'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'Preventivo inviato via e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Elimina Quotazione'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'Aggiungi Quotazione'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Seleziona prodotto'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Prodotto (Codice - Nome)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Prezzo'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'Scorta'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Totale'), _defineProperty(_Receipt$Pos_Settings, "Num", 'N°'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Costo unitario'), _defineProperty(_Receipt$Pos_Settings, "to", 'per'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Soggetto'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Messaggio'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'Email del cliente'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Spedire'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'Quotazione'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Ciao'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Si prega di trovare l\'allegato per il preventivo'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Aggiungi prodotti all\'elenco ordini'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Seleziona il magazzino'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'Seleziona cliente'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Direzione vendite'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Equilibrio'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Quantità ritorno'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Rendimento totale'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'somma'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Dettaglio di vendita'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Modifica vendita'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Aggiungi vendita'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Mostra pagamenti'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'Aggiungi pagamento'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Modifica pagamento'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Invia vendita via email'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Elimina vendita'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Modalità di pagamento'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Scelta di pagamento'), _defineProperty(_Receipt$Pos_Settings, "Note", 'Nota'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Pagamento completato!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Gestione degli acquisti'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Ordinato'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Elimina acquisto'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Invia acquisto via e-mail'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'Modifica acquisto'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'Dettaglio d\'acquisto'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Aggiungi acquisto'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'Email del fornitore'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Pagamenti acquisti'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Acquista i dati sui pagamenti'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'Pagamenti alle vendite'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Dati di pagamento delle vendite'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'gestione degli utenti'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'Nome di battesimo'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'cognome'), _defineProperty(_Receipt$Pos_Settings, "username", 'NOME UTENTE'), _defineProperty(_Receipt$Pos_Settings, "password", 'PASSWORD'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'Nuova password'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Cambia avatar'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Si prega di lasciare vuoto questo campo se non è stato modificato'), _defineProperty(_Receipt$Pos_Settings, "type", 'genere'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Autorizzazioni degli utenti'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Nome del ruolo'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Descrizione del ruolo'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Aggiungi autorizzazioni'), _defineProperty(_Receipt$Pos_Settings, "View", 'Visualizza'), _defineProperty(_Receipt$Pos_Settings, "Del", 'Elimina'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'Nuovo regolazione'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Modifica regolazione'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'Non è possibile sottrarre prodotti con stock 0'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'aggiunta'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Sottrazione'), _defineProperty(_Receipt$Pos_Settings, "profil", 'profilo'), _defineProperty(_Receipt$Pos_Settings, "logout", 'disconnettersi'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'non è possibile cambiare perché questo acquisto è già stato pagato'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'non puoi modificare perché questa vendita è già stata pagata'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'non puoi modificare perché questa Ritorno è già stata pagata'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'Questa citazione ha già generato vendita'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'Questa citazione è completa'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Configurazione del sito'), _defineProperty(_Receipt$Pos_Settings, "Language", 'linguaggio'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Valuta predefinita'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Accedi Captcha'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'Email predefinita'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Nome del sito'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Cambia logo'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'Configurazione SMTP'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'OSPITE'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'PORTA'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'crittografia'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'Configurazione SMTP errata'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Pagamenti di ritorno'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'fatture di ritorno'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'Dati di fatture di ritorno'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'Mostra tutti i record di tutti gli utenti'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Sconto'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Imposta sugli ordini'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'spedizione'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Valute di gestione'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Codice valuta'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Nome valuta'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Simbolo'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Nome della ditta'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Telefono aziendale'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Indirizzo aziendale'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Codice'), _defineProperty(_Receipt$Pos_Settings, "image", 'Immagine'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Stampa codice a barre'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Vendite di ritorno'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Restituire gli acquisti'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'fatture Vendite di reso'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'fatture Resi acquisti'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'Nessun dato disponibile'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'Immagine del prodotto'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'codice a barre'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'punto vendita'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Caricamento personalizzato'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'Gestione punto vendita'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Regolazione'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Aggiornare'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Ripristina'), _defineProperty(_Receipt$Pos_Settings, "print", 'Stampa'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Cerca per e-mail'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Scegli il prodotto'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Qtà'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Elementi'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'somma HT'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'somma TTC'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Seleziona il fornitore'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Seleziona lo stato'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'Pagato con'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Scegli Magazzino'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'paga ora'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'Elenco delle categorie'), _defineProperty(_Receipt$Pos_Settings, "Description", 'Descrizione'), _defineProperty(_Receipt$Pos_Settings, "submit", 'Invia'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'Si è verificato un problema durante la creazione di questa fattura. Per favore riprova'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'Si è verificato un problema con il pagamento. Per favore riprova.'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'Crea aggiustamento'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'qualche parola in merito...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'Immagine dell\'utente'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Aggiorna prodotto'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'Marca'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'Simbologia del codice a barre'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'costi del prodotto'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Prezzo del prodotto'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'Prodotto unitario'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'Metodo fiscale'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'Immagine multipla'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'Il prodotto ha più varianti'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'Il prodotto ha una promozione'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Inizia la promozione'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Fine promozione'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Prezzo promozionale'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Prezzo'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'Costo'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'Unità'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'Variante di prodotto'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'Variante'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Prezzo unitario'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'Crea cliente di reso'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Modifica cliente di reso'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'Crea fornitore di reso'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'Documentazione'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'Modifica fornitore di reso'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Dal magazzino'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'Al magazzino'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'Modifica trasferimento'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'Dettaglio trasferimento'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'in attesa di'), _defineProperty(_Receipt$Pos_Settings, "Received", 'Ricevuto'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Ordinato'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'Gestore delle autorizzazioni'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'Gestore di marchio'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'Immagine di marca'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'Nome di marca'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'Descrizione di marca'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'Unità base'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'Gestione delle unità'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Valore dell\'operazione'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'Operatore'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'I 5 migliori prodotti'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'Ultime 5 vendite'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'Elenca le regolazioni'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'Elenco trasferimenti'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Crea trasferimento'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'Gestione degli ordini'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'Elenco citazioni'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'Elenco acquisti'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'Elenco vendite'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'Elenco dei resi'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'manager del personale'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'Elenco dei marchi'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: 'Sei sicuro?',
  Text: 'Non sarai in grado di ripristinare questo!',
  confirmButtonText: 'Sì, cancellalo!',
  cancelButtonText: 'Annulla',
  Deleted: 'eliminare!',
  Failed: 'Mancato!',
  Therewassomethingwronge: 'C\'era qualcosa che non andava',
  CustomerDeleted: 'questo cliente è stato eliminato',
  SupplierDeleted: 'questo fornitore è stato eliminato',
  QuoteDeleted: 'questa citazione è stata eliminato',
  SaleDeleted: 'questa vendita è stata eliminata',
  PaymentDeleted: 'questo pagamento è stato eliminato',
  PurchaseDeleted: 'questo acquisto è stato eliminato',
  ReturnDeleted: 'questo ritorno è stato eliminato',
  ProductDeleted: 'questo prodotto è stato eliminato',
  ClientError: 'Questo cliente è già collegato ad altre operazioni',
  ProviderError: 'Questo fornitore è già collegato ad altre operazioni',
  UserDeleted: 'Questo utente è stato eliminato',
  UnitDeleted: 'Questa unità è stata eliminata',
  RoleDeleted: 'Questo ruolo è stato eliminato',
  TaxeDeleted: 'Questa imposta è stata eliminata',
  SubCatDeleted: 'Questa sottocategoria è stata eliminata',
  CatDeleted: 'Questa categoria è stata eliminata',
  WarehouseDeleted: 'Questo magazzino è stato eliminata',
  AlreadyLinked: 'questo prodotto è già collegato ad altre operazioni',
  AdjustDeleted: 'Questo adeguamento è stato eliminato',
  TitleCurrency: 'Questa valuta è stata eliminata',
  TitleTransfer: 'La trasferimento è stata rimossa con successo',
  BackupDeleted: 'Il backup è stato rimosso con successo',
  TitleBrand: 'Questo marchio è stato eliminato'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleBrand: 'Questo marchio è stato aggiornato',
  TitleProfile: 'Il tuo profilo è stato aggiornato con successo',
  TitleAdjust: 'Aggiustamento aggiornato con successo',
  TitleRole: 'Ruolo aggiornato con successo',
  TitleUnit: 'L\'unità è stata aggiornata con successo',
  TitleUser: 'Aggiornamento utente eseguito correttamente',
  TitleCustomer: 'Il cliente è stato aggiornato con successo',
  TitleQuote: 'Preventivo aggiornato con successo',
  TitleSale: 'Vendita aggiornata con successo',
  TitlePayment: 'Pagamento aggiornato con successo',
  TitlePurchase: 'Acquisto aggiornato con successo',
  TitleReturn: 'Ritorno Aggiornato con successo',
  TitleProduct: 'Prodotto aggiornato con successo',
  TitleSupplier: 'Il fornitore è stato aggiornato con successo',
  TitleTaxe: 'Imposte aggiornate con successo',
  TitleCat: 'Categoria aggiornata con successo',
  TitleWarhouse: 'Magazzino aggiornato con successo',
  TitleSetting: 'Impostazioni aggiornate con successo',
  TitleCurrency: 'Questa valuta è stata aggiornata',
  TitleTransfer: 'La trasferimento è stata aggiornata con successo'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'Questo marchio è stato creato',
  TitleTransfer: 'La trasferimento è stata aggiornata con successo',
  TitleRole: 'Ruolo creato con successo',
  TitleUnit: 'Unità creata con successo',
  TitleUser: 'Utente creato correttamente',
  TitleCustomer: 'Cliente creato con successo',
  TitleQuote: 'Citazione creata con successo',
  TitleSale: 'Vendita creata con successo',
  TitlePayment: 'Pagamento creato con successo',
  TitlePurchase: 'Acquisto creato con successo',
  TitleReturn: 'Ritorno Creato con successo',
  TitleProduct: 'Prodotto creato con successo',
  TitleSupplier: 'Fornitore creato con successo',
  TitleTaxe: 'Imposta creata con successo',
  TitleCat: 'Categoria creata con successo',
  TitleWarhouse: 'Magazzino creato con successo',
  TitleAdjust: 'Aggiustamento creato con successo',
  TitleCurrency: 'Questa valuta è stata creata'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email Invia correttamente'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'questa vendita già collegata con un ritorno!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'Gestione dei ritorna'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Dettagli di ritorno'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'Modifica ritorno'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'Aggiungi ritorno'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'Invia Ritorno in e-mail'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Elimina ritorno'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'Supplemento per restituzione'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'consegna'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Seleziona vendita'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'È possibile eliminare l\'articolo o impostare la quantità restituita su zero se non viene restituita'), _defineProperty(_Receipt$Pos_Settings, "Return", 'Ritorno'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'Acquista'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'Vendite totali'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Acquisti totali'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'Retorna totali'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'Pagamenti netti'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'Pagamenti inviati'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'Pagamenti ricevuti'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'ricevuti'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'inviati'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Avvisi quantità prodotto'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Codice prodotto'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'nome del prodotto'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'Quantità di avviso'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Grafico azioni magazzino'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'Totale prodotti'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'Quantità totale'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'I 5 migliori clienti'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Importo totale'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'Totale pagato'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'Rapporto sulle vendite dei clienti'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Rapporto sui pagamenti dei clienti'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'Rapporto sulle citazioni dei clienti'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'pagamenti'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'Primi 5 fornitori'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'Rapporto sugli acquisti dei fornitori'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'Rapporto sui pagamenti dei fornitori'), _defineProperty(_Receipt$Pos_Settings, "Name", 'Nome'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Codice'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'Gestione del magazzino'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'Cap'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Gestione delle categorie'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'Categoria di codice'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'Nome categoria'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'Categoria principale'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'Gestione fiscale'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'Nome fiscale'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'Aliquota fiscale'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Gestione dell\'unità acquisti'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'Gestione dell\'unità di vendita'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'Nome corto'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Seleziona questi prima di aggiungere qualsiasi prodotto'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'Adeguamento delle scorte'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'Seleziona il magazzino prima di scegliere qualsiasi prodotto'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'Trasferimento stock'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'Seleziona Periodo'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'Quest\'anno'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'Questo oggi'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Questo mese'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'Questa settimana'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'Dettaglio regolazione'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'Questo utente è stato attivato'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'Questo utente è stato disattivato'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'Pagina non trovata.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'errore! Pagina non trovata.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'Non siamo riusciti a trovare la pagina che stavi cercando. Nel frattempo, potresti'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'torna alla dashboard'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'HRM'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'Dipendenti'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'Presenze'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Lascia una richiesta'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Tipo di uscita'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Azienda'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Dipartimenti'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'Designazioni'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Turno d\'ufficio'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Vacanze'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Inserisci il nome dell\'azienda'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Inserisci l\'indirizzo email'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Inserisci il telefono aziendale'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Inserisci il paese dell\'azienda'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Creato con successo'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Aggiornato con successo'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Eliminato con successo'), _defineProperty(_Receipt$Pos_Settings, "department", 'Dipartimento'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Inserisci il nome del dipartimento'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Scegli Azienda'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Capo dipartimento'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Scegli Capo Dipartimento'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Inserisci il nome del turno'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'Monday In'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'Tuesday In'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'tuesday Out'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'Wednesday In'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'Wednesday Out'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'Thursday In'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'Thursday Out'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'Friday Out'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'Saturday In'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'Sunday In'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'Sunday Out'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'Vacanza'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Inserisci il titolo'), _defineProperty(_Receipt$Pos_Settings, "title", 'titolo'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Data d\'inizio'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Inserire la data di inizio'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Data di fine'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Inserisci la data di fine'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Si prega di fornire tutti i dettagli'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'Presenze'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Inserisci la data di presenza'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'Scegli Dipendente'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'Dipendente'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Durata del lavoro'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'Le foglie rimanenti sono insufficienti'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Tipo di uscita'), _defineProperty(_Receipt$Pos_Settings, "Days", 'Giorni'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Dipartimento'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Scegli il tipo di permesso'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'Scegli lo stato'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Lascia la ragione'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Inserisci Motivo Congedo'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Aggiungi dipendente'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'Nome di battesimo'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Inserisci il nome'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Cognome'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Inserisci il cognome'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Genere'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Scegli il genere'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Inserisci la data di nascita'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Data di nascita'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Inserisci Paese'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Inserisci il numero di telefono'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Data di adesione'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Inserisci la data di adesione'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'Scegli Designazione'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'Designazione'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Turno di Ufficio'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Scegli Turno d\'ufficio'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Inserisci la data di partenza'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Data di partenza'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Ferie annuali'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Entra in ferie annuali'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Congedo residuo'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Dettagli dei dipendenti'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Informazioni di base'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Stato familiare'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Scegli lo stato di famiglia'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Tipo di impiego'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Seleziona Tipo di impiego'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Entra in Città'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Provincia'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Entra in Provincia'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Inserisci indirizzo'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Inserisci il codice postale'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Cap'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Tariffa oraria'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Inserisci Tariffa oraria'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Salario di base'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Inserisci lo stipendio base'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Social media'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skype'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Inserisci un Skype'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Inserisci un Facebook'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Inserisci un WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Inserisci un LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Inserisci un Twitter'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Esperienze'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'conto bancario'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Nome della ditta'), _defineProperty(_Receipt$Pos_Settings, "Location", 'Posizione'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Inserisci posizione'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Immettere la descrizione'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Nome della banca'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Inserisci il nome della banca'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Filiale bancaria'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Entra in filiale della banca'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Numero di banca'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Immettere il numero di banca'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Magazzini assegnati'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'I migliori clienti'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Allegato'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'visualizzare i dipendenti'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'modificare i dipendenti'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'eliminare i dipendenti'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Aggiunto da'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Aggiungi IMEI/Numero di serie del prodotto'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", 'Il prodotto ha un numero Imei/di serie'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'Spedizioni'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Spedito a'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Spedizione Rif'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Vendita Rif'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Modifica spedizione'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Confezionato'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Spedito'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Consegnato'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Annullato'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Stato della spedizione'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Rapporto utenti'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'Rapporto sulle scorte'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Acquisti totali'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Citazioni totali'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Vendite di ritorno totale'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Totale acquisti di ritorno'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Trasferimenti totali'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Adeguamenti totali'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'Rapporto utente'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Scorta attuale'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'nome del prodotto'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Debito totale'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Debito totale'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Alcuni Magazzini'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'Tutti i Magazzini'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Prezzo del prodotto'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'Impostazioni SMS'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'Impostazioni POS'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Gateway di pagamento'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'Impostazioni di posta'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Gateway SMS predefinito'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Impostazioni del modulo'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Modulo abilitato con successo'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Modulo disabilitato con successo'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Aggiorna impostazioni'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Carica il modulo corretto'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Caricato con successo'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'Dettagli cliente'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Modifica cliente'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Elimina cliente'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'pagare dovuto'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'L\'importo del pagamento è superiore al totale dovuto'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Fattura del cliente'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'Questo prodotto non è in vendita'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Benvenuto nella tua dashboard'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Totale pagabile'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Scegli Rif. Vendita'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Si prega di selezionare Vendita'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Rif. Vendita'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'elenca i resi dei prodotti'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'qty di ritorno'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Scegli Acquisto Rif'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Acquisto Rif'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Seleziona Acquisto'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'La quantità restituita è maggiore della quantità acquistata'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'La quantità di ritorno è maggiore della quantità venduta'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Quantità venduta'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Quantità acquistata'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Nome mittente'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'Il modulo deve essere caricato come file zip'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Modulo di caricamento'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Tutti i moduli installati'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Versione attuale'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'Hai già l\'ultima versione'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Aggiornamento disponibile'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Aggiorna registro'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Aggiorna ora'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'Visualizza registro modifiche'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Piè di pagina della fattura'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'NOTA: attendere il completamento dell\'aggiornamento. Non è consigliabile chiudere il browser o interrompere un processo di aggiornamento'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Nota: assicurati di eseguire il backup della versione corrente e del database prima di eseguire l\'aggiornamento, per ripristinarlo in caso di errore'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Fuso orario'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'note di pagamento'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'note di vendita'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Totale vendita dovuta'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Totale vendita di ritorno dovuto'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'pagare tutte le vendite dovute alla volta'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'pagare tutti i resi di vendita dovuti alla volta'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Utile lordo'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'pagare tutti gli acquisti dovuti alla volta'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Elimina fornitore'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Modifica fornitore'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Dettagli del fornitore'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Totale acquisto dovuto'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Nota di credito'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Nota di credito'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Vendi Ritorno'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Acquisto di ritorno'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Codice Fiscale'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Si prega di aggiungere la quantità di reso'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'Esiste un ritorno per la transazione'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'La quantità restituita è maggiore della quantità rimanente'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Tutti i prodotti con una quantità impostata su 0 non verranno rimborsati'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'pagare tutti i resi di acquisto dovuti alla volta'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Totale acquisto reso dovuto'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Acquisto di ritorno dovuto'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'Vendi reso dovuto'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'Rapporto sul prodotto'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'rapporto di vendita del prodotto'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'Report acquisti prodotti'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'Qtà venduta'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Qtà acquistata'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Filtra per magazzino'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Stampa fattura automaticamente'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'visualizza magazzino'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Informazioni carta di credito'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Informazioni carta di credito salvate'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Carta di credito modificata con successo'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Modello di notifica'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'Notifica email'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'Notifica SMS'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Modifica dettagli prodotto'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'Modifica tasse, sconti e spedizione'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Crea preventivo con magazzino'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Nome variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Costo variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Prezzo variante'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Codice variante'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Attendere fino al caricamento del prodotto'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Scegli il gateway SMS'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Notifica al cliente'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Tag disponibili'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'Oggetto email'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'Corpo email'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Notifica al fornitore'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'Corpo SMS'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'SMS Templates'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Email Templates'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/kr.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/kr.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language coréen

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: '영수증',
  Pos_Settings: '판매 시점 구성',
  Note_to_customer: '고객참고',
  Show_Note_to_customer: '고객에게 참고 표시',
  Show_barcode: '바코드 표시',
  Show_Tax_and_Discount: '세금 및 할인 및 배송 표시',
  Show_Customer: '고객 표시',
  Show_Email: '이메일 표시',
  Show_Phone: '전화 표시',
  Show_Address: '주소 표시',
  DefaultLanguage: '기본 언어',
  footer: '풋터',
  Received_Amount: '받은 금액',
  Paying_Amount: '결제 금액',
  Change: '변화',
  Paying_amount_is_greater_than_Received_amount: '지급금액은 수령금액보다 크다',
  Paying_amount_is_greater_than_Grand_Total: '지급금액은 전체 총액보다 크다',
  code_must_be_not_exist_already: '코드가 더 이상 존재하지 않아야 합니다.',
  You_will_find_your_backup_on: '백업을 찾을 수 있습니다',
  and_save_it_to_your_pc: '그리고 당신의 PC에 저장',
  Scan_your_barcode_and_select_the_correct_symbology_below: '바코드를 스캔하고 아래의 올바른 상징을 선택하십시오.',
  Scan_Search_Product_by_Code_Name: '코드 이름으로 스캔/검색 제품',
  Paper_size: '종이 크기',
  Clear_Cache: '캐시 지우기',
  Cache_cleared_successfully: '캐시가 성공적으로 삭제',
  Failed_to_clear_cache: '캐시를 지울 수 없다',
  Scan_Barcode: '바코드 스캐너',
  Please_use_short_name_of_unit: '드라이브의 짧은 이름을 사용',
  DefaultCustomer: '기본 클라이언트',
  DefaultWarehouse: '기본 저장소',
  Payment_Gateway: '결제 게이트웨이',
  SMS_Configuration: 'SMS 설정',
  Gateway: '결제 게이트웨이',
  Choose_Gateway: '결제 게이트웨이 선택',
  Send_SMS: '성공적으로 보낸 메시지',
  sms_config_invalid: '잘못된 SMS 설정',
  Remove_Stripe_Key_Secret: '스트라이프 API 키 삭제',
  credit_card_account_not_available: '신용카드 계좌 이용 불가',
  Credit_Card_Info: '신용카드 정보',
  developed_by: '에 의해 개발',
  Unit_already_linked_with_sub_unit: '이미 하위 유닛에 연결된 유니티',
  Total_Items_Quantity: '총 품목 및 수량',
  Value_by_Cost_and_Price: '비용과 가격에 대한 가치',
  Search_this_table: '이 테이블 찾기',
  import_products: '수입 제품',
  Field_optional: '선택적 필드',
  Download_exemple: '예제 다운로드',
  field_must_be_in_csv_format: '필드는 csv 형식으로 해야 합니다.',
  Successfully_Imported: '성공적으로 가져오기',
  file_size_must_be_less_than_1_mega: '파일 크기는 1메가 미만이어야 한다',
  Please_follow_the_import_instructions: '가져오기 지침에 따라.',
  must_be_exist: '드라이브는 이미 만들어야 합니다.',
  Import_Customers: '고객 수입',
  Import_Suppliers: '수입 공급 업체',
  Recent_Sales: '최근 매출',
  Create_Transfer: '전송 만들기',
  order_products: '주문 아이템',
  Search_Product_by_Code_Name: '코드 나 이름으로 검색 제품',
  Reports_payments_Purchase_Return: '신고반지급',
  Reports_payments_Sale_Return: '판매 결제 신고',
  payments_Sales_Return: '결제 판매 반환',
  payments_Purchases_Return: '결제 는 반환 구매',
  CreateSaleReturn: '판매 관한 반품 만들기',
  EditSaleReturn: '판매 반품 수정',
  SalesReturn: '판매 반품',
  CreatePurchaseReturn: '반품 구매 만들기',
  EditPurchaseReturn: '반품 구매 편집',
  PurchasesReturn: '구매 반환',
  Due: '기한',
  Profit: '이익',
  Revenue: '소득',
  Sales_today: '오늘 판매',
  People: '사람들',
  Successfully_Created: '성공적으로 만든',
  Successfully_Updated: '성공적으로 업데이트',
  Success: '성공',
  Failed: '실패',
  Warning: '경고',
  Please_fill_the_form_correctly: '양식을 올바르게 작성하십시오',
  Field_is_required: '필드 필요',
  Error: '오류!',
  you_are_not_authorized: '죄송합니다 귀하는 권한이 없습니다.',
  Go_back_to_home: '메인 페이지로 돌아가기',
  page_not_exist: '죄송합니다! 원하는 페이지가 존재하지 않습니다.',
  Choose_Status: '상태 선택',
  Choose_Method: '방법을 선택',
  Choose_Symbology: '상징을 선택',
  Choose_Category: '카테고리 선택',
  Choose_Customer: '고객 선택',
  Choose_Supplier: '공급자 선택',
  Choose_Unit_Purchase: '구매 단위 선택',
  Choose_Sub_Category: '하위 카테고리 선택',
  Choose_Brand: '브랜드 선택',
  Choose_Warehouse: '창고 선택',
  Choose_Unit_Sale: '판매 단위를 선택',
  Enter_Product_Cost: '제품 비용 입력 제품 원가 입력',
  Enter_Stock_alert: '주식 경보 입력',
  Choose_Unit_Product: '제품 단위 선택',
  Enter_Product_Price: '상품의 가격을 입력',
  Enter_Name_Product: '상품의 이름을 입력',
  Enter_Role_Name: '역할의 이름을 입력',
  Enter_Role_Description: '역할 설명을 입력',
  Enter_name_category: '카테고리의 이름을 입력',
  Enter_Code_category: '카테고리 코드를 입력',
  Enter_Name_Brand: '브랜드 이름 입력',
  Enter_Description_Brand: '브랜드 설명 입력',
  Enter_Code_Currency: '코드의 통화를 입력',
  Enter_name_Currency: '통화 방식 입력',
  Enter_Symbol_Currency: '기호의 화폐를 입력',
  Enter_Name_Unit: '단위의 이름을 입력',
  Enter_ShortName_Unit: '짧은 이름 단위를 입력',
  Choose_Base_Unit: '베이스 유닛 선택',
  Choose_Operator: '연산자 선택',
  Enter_Operation_Value: '무역의 가치를 입력',
  Enter_Name_Warehouse: '창고의 이름을 입력',
  Enter_Phone_Warehouse: '창고 전화 입력',
  Enter_Country_Warehouse: '창고의 나라로 들어가라',
  Enter_City_Warehouse: '창고 도시 진입',
  Enter_Email_Warehouse: '창고 이메일 입력',
  Enter_ZipCode_Warehouse: '창고의 우편 번호를 입력',
  Choose_Currency: '통화 선택',
  Thank_you_for_your_business: '당신의 사업에 감사드립니다!',
  Cancel: '취소',
  New_Customer: '신규 고객',
  Incorrect_Login: '로그인 실패',
  Successfully_Logged_In: '성공적인 로그인',
  This_user_not_active: '이 사용자는 활성 상태가 아닙니다.',
  SignIn: '등록기 로그인 하세요',
  Create_an_account: '계정 만들기',
  Forgot_Password: '비밀번호를 잊어버렸나요?',
  Email_Address: '이메일 주소',
  SignUp: '가입',
  Already_have_an_account: '이미 계정이 있습니까?',
  Reset_Password: '암호 재설정',
  Failed_to_authenticate_on_SMTP_server: 'SMTP 서버로 인증할 수 없습니다.',
  We_cant_find_a_user_with_that_email_addres: '우리는 그 이메일 주소가있는 사용자를 찾을 수 없습니다',
  We_have_emailed_your_password_reset_link: '이메일을 통해 암호 재설정 링크를 보냈습니다.',
  Please_fill_the_Email_Adress: '이메일 주소를 기입해 주세요',
  Confirm_password: '비밀번호 확인',
  Your_Password_has_been_changed: '비밀번호가 변경되었습니다',
  The_password_confirmation_does_not_match: '암호 확인이 일치하지 않습니다',
  This_password_reset_token_is_invalid: '이 암호 재설정 토큰은 유효하지 않습니다.',
  Warehouse_report: '창고 보고서',
  All_Warehouses: '모든 창고',
  Expense_List: '경비 목록',
  Expenses: '비용 / 지출',
  This_Week_Sales_Purchases: '이번 주 매출 및 구매',
  Top_Selling_Products: '베스트 셀러 제품',
  View_all: '모두 보기',
  Payment_Sent_Received: '송수신된 결제 /결제 배송 받음 ',
  Filter: "필터",
  Invoice_POS: "POS 송장",
  Invoice: "송장 /영수증",
  Customer_Info: "고객 정보",
  Company_Info: "회사 정보",
  Invoice_Info: "송장 정보",
  Order_Summary: "주문 요약",
  Quote_Info: "견적 정보",
  Del: "삭제",
  SuppliersPaiementsReport: "공급업체 지불 보고서",
  Purchase_Info: "구매 정보",
  Supplier_Info: "공급업체 정보",
  Return_Info: "반송 정보",
  Expense_Category: "비용 범주",
  Create_Expense: "지출 창출",
  Details: "세부 사항",
  Discount_Method: "할인 방법",
  Net_Unit_Cost: "순 단가",
  Net_Unit_Price: "순 단가",
  Edit_Expense: "지출 편집",
  All_Brand: "전체 브랜드",
  All_Category: "모든 카테고리",
  ListExpenses: "비용 목록",
  Create_Permission: "권한 만들기",
  Edit_Permission: "권한 편집",
  Reports_payments_Sales: "판매 유료 보고서",
  Reports_payments_Purchases: "결제 신고",
  Reports_payments_Return_Customers: "고객반환 신고",
  Reports_payments_Return_Suppliers: "보고서 지불의 반환 공급자",
  stockyVersion: "당신은 스타킹 버전에서이 작업을 수행 할 수 없습니다",
  Expense_Deleted: "이 비용은 제거되었습니다.",
  Expense_Updated: "이 지출이 업데이트되었습니다",
  Expense_Created: "이 비용이 만들어졌습니다.",
  Filesize: "파일 크기",
  GenerateBackup: "백업 생성",
  BackupDatabase: "백업 데이터베이스",
  Backup: "백업 데이터베이스",
  OrderStatistics: "판매 통계",
  AlreadyAdd: "이 제품은 이미 추가되었습니다.",
  AddProductToList: "목록에 제품을 추가",
  AddQuantity: "수량 추가",
  InvalidData: "유효하지 않은 날짜",
  LowStock: "수량은 재고에서 사용할 수 있는 양을 초과",
  WarehouseIdentical: "창고는 동일할 수 없습니다.",
  VariantDuplicate: "이 변형은 중복됩니다.",
  Paid: "유료",
  Unpaid: "지불하지 않음",
  IncomeExpenses: "소득과 비용",
  dailySalesPurchases: "일일 판매 및 구매",
  ProductsExpired: "만료된 제품",
  Today: "오늘",
  Income: "소득"
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", "비용"), _defineProperty(_Receipt$Pos_Settings, "Sale", "리베이트"), _defineProperty(_Receipt$Pos_Settings, "Actif", "액티브"), _defineProperty(_Receipt$Pos_Settings, "Inactif", "비활성"), _defineProperty(_Receipt$Pos_Settings, "Customers", "클라이언트 /손님 / 고객"), _defineProperty(_Receipt$Pos_Settings, "Phone", "전화"), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", "전화로 검색"), _defineProperty(_Receipt$Pos_Settings, "Suppliers", "공급업체"), _defineProperty(_Receipt$Pos_Settings, "Quotations", "견적"), _defineProperty(_Receipt$Pos_Settings, "Sales", "판매"), _defineProperty(_Receipt$Pos_Settings, "Purchases", '쇼핑'), _defineProperty(_Receipt$Pos_Settings, "Returns", "반환"), _defineProperty(_Receipt$Pos_Settings, "Settings", "설정"), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", "시스템 설정"), _defineProperty(_Receipt$Pos_Settings, "Users", "사용자"), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", "그룹 사용 권한"), _defineProperty(_Receipt$Pos_Settings, "Currencies", "동전"), _defineProperty(_Receipt$Pos_Settings, "Warehouses", "창고"), _defineProperty(_Receipt$Pos_Settings, "Units", "단위"), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", '「단위 구매」'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", "단위 판매"), _defineProperty(_Receipt$Pos_Settings, "Reports", "보고서"), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", "지불 보고서"), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", "결제 구매"), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", "지불 의 판매"), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", "지불 의 환불"), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", "이익과 손실"), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", "창고 주식 차트"), _defineProperty(_Receipt$Pos_Settings, "SalesReport", "판매 보고서"), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", "구매 보고서"), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", "고객 보고서"), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", "공급업체 보고서"), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", "공급업체 보고서"), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", "일일 판매 데이터"), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", "일일 쇼핑 데이터"), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", "마지막 5개의 기록"), _defineProperty(_Receipt$Pos_Settings, "Filters", "필터"), _defineProperty(_Receipt$Pos_Settings, "date", "날짜"), _defineProperty(_Receipt$Pos_Settings, "Reference", "참조"), _defineProperty(_Receipt$Pos_Settings, "Supplier", "공급업체"), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", "지불 상태"), _defineProperty(_Receipt$Pos_Settings, "Customer", "고객"), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", "클라이언트 코드"), _defineProperty(_Receipt$Pos_Settings, "Status", "상태"), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", "공급업체 코드"), _defineProperty(_Receipt$Pos_Settings, "Categorie", "카테고리"), _defineProperty(_Receipt$Pos_Settings, "Categories", "카테고리"), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", "주식 송금"), _defineProperty(_Receipt$Pos_Settings, "StockManagement", "주식 관리"), _defineProperty(_Receipt$Pos_Settings, "dashboard", "보드"), _defineProperty(_Receipt$Pos_Settings, "Products", "제품"), _defineProperty(_Receipt$Pos_Settings, "productsList", "제품 목록"), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", "제품 관리"), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", "제품 수량 경고"), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", "제품 코드"), _defineProperty(_Receipt$Pos_Settings, "ProductTax", "제품세"), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", "하위 범주"), _defineProperty(_Receipt$Pos_Settings, "Name_product", "지정"), _defineProperty(_Receipt$Pos_Settings, "StockAlert", "주식 경보"), _defineProperty(_Receipt$Pos_Settings, "warehouse", "창고"), _defineProperty(_Receipt$Pos_Settings, "Tax", "세금"), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", '「구매 가격」'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", "판매 가격"), _defineProperty(_Receipt$Pos_Settings, "Quantity", "수량"), _defineProperty(_Receipt$Pos_Settings, "UnitSale", "단위의 판매"), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", '「단위 구매」'), _defineProperty(_Receipt$Pos_Settings, "All", "모두"), _defineProperty(_Receipt$Pos_Settings, "EditProduct", '「제품 편집」'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", "제품 추가"), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", "코드로 검색"), _defineProperty(_Receipt$Pos_Settings, "SearchByName", "이름으로 검색"), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", "제품 세부 사항"), _defineProperty(_Receipt$Pos_Settings, "CustomerName", "고객 이름"), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", "고객 관리"), _defineProperty(_Receipt$Pos_Settings, "Add", "더하다 추가"), _defineProperty(_Receipt$Pos_Settings, "add", "추가"), _defineProperty(_Receipt$Pos_Settings, "Edit", "편집"), _defineProperty(_Receipt$Pos_Settings, "Close", "닫기"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", "선택해 주세요"), _defineProperty(_Receipt$Pos_Settings, "Action", "액션"), _defineProperty(_Receipt$Pos_Settings, "Email", "이메일"), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", "클라이언트 편집  고객 수정"), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", "클라이언트 추가  고객 추가"), _defineProperty(_Receipt$Pos_Settings, "Country", "국가"), _defineProperty(_Receipt$Pos_Settings, "City", "도시"), _defineProperty(_Receipt$Pos_Settings, "Adress", "주소"), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", "고객 세부 사항"), _defineProperty(_Receipt$Pos_Settings, "CustomersList", "고객 목록"), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", "공급업체 코드"), _defineProperty(_Receipt$Pos_Settings, "SupplierName", "공급자 이름"), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", "공급업체 관리"), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", "공급업체 세부 정보"), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", "견적 관리"), _defineProperty(_Receipt$Pos_Settings, "SubTotal", "부분 합계"), _defineProperty(_Receipt$Pos_Settings, "MontantReste", "남은 수량"), _defineProperty(_Receipt$Pos_Settings, "complete", "완전"), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", "보류 중"), _defineProperty(_Receipt$Pos_Settings, "Recu", "수신"), _defineProperty(_Receipt$Pos_Settings, "partial", "부분"), _defineProperty(_Receipt$Pos_Settings, "Retournee", "반환"), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", "상세한 견적"), _defineProperty(_Receipt$Pos_Settings, "EditQuote", "견적 편집"), _defineProperty(_Receipt$Pos_Settings, "CreateSale", "판매 만들기"), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", "PDF 다운로드"), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", "이메일로 보낸 견적"), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", "견적 삭제"), _defineProperty(_Receipt$Pos_Settings, "AddQuote", "견적 추가"), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", '제품 선택'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", "제품(코드 - 이름)"), _defineProperty(_Receipt$Pos_Settings, "Price", "가격"), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", "주식 / 제고"), _defineProperty(_Receipt$Pos_Settings, "Total", "총"), _defineProperty(_Receipt$Pos_Settings, "Num", "N°"), _defineProperty(_Receipt$Pos_Settings, "Unitcost", "단가"), _defineProperty(_Receipt$Pos_Settings, "to", "a"), _defineProperty(_Receipt$Pos_Settings, "Subject", "주제"), _defineProperty(_Receipt$Pos_Settings, "Message", "메시지"), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", "이메일 클라이언트"), _defineProperty(_Receipt$Pos_Settings, "Sent", "보내기"), _defineProperty(_Receipt$Pos_Settings, "Quote", "견적"), _defineProperty(_Receipt$Pos_Settings, "Hello", "안녕하세요"), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", "견적첨부 파일 찾기"), _defineProperty(_Receipt$Pos_Settings, "AddProducts", "주문 목록에 제품을 추가"), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", "창고를 선택해 주세요"), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", "고객 선택"), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", "영업 관리"), _defineProperty(_Receipt$Pos_Settings, "Balance", "저울  순이익"), _defineProperty(_Receipt$Pos_Settings, "QtyBack", '반품 수량'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", "총 반환"), _defineProperty(_Receipt$Pos_Settings, "Amount", "금액"), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", '판매 상세'), _defineProperty(_Receipt$Pos_Settings, "EditSale", "판매 편집"), _defineProperty(_Receipt$Pos_Settings, "AddSale", "판매 추가"), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", "지불 표시"), _defineProperty(_Receipt$Pos_Settings, "AddPayment", "지불 추가"), _defineProperty(_Receipt$Pos_Settings, "EditPayment", "결제 편집"), _defineProperty(_Receipt$Pos_Settings, "EmailSale", "이메일로 판매 보내기"), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", "판매 제거"), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", "결제 방법"), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", "지불 옵션"), _defineProperty(_Receipt$Pos_Settings, "Note", "참고"), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", "완전 결제!"), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", "구매 관리"), _defineProperty(_Receipt$Pos_Settings, "Ordered", "깔끔한"), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", "구매 삭제"), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", '이메일로 구매 보내기'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", "구매 편집"), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", '구매 세부 사항'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", "구매 추가"), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", "공급자 이메일"), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", "유료 구매"), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", "구매 결제 데이터"), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", "판매 지불"), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", "판매 지불 데이터"), _defineProperty(_Receipt$Pos_Settings, "UserManagement", "사용자 관리"), _defineProperty(_Receipt$Pos_Settings, "Firstname", "이름"), _defineProperty(_Receipt$Pos_Settings, "lastname", "가족 이름"), _defineProperty(_Receipt$Pos_Settings, "username", "사용자 이름"), _defineProperty(_Receipt$Pos_Settings, "password", "암호"), _defineProperty(_Receipt$Pos_Settings, "Newpassword", "새 암호"), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", "아바타 변경"), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", "변경하지 않은 경우 이 필드를 비워 둡니다."), _defineProperty(_Receipt$Pos_Settings, "type", "유형"), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", "사용자 권한"), _defineProperty(_Receipt$Pos_Settings, "RoleName", "역할 이름"), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", "역할 설명"), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", "권한 추가"), _defineProperty(_Receipt$Pos_Settings, "View", "보다/보기"), _defineProperty(_Receipt$Pos_Settings, "Del", "삭제"), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", "새로운 설정"), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", "설정 편집"), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", "재고가 있는 제품을 빼는 것은 할 수 없습니다"), _defineProperty(_Receipt$Pos_Settings, "Addition", "추가"), _defineProperty(_Receipt$Pos_Settings, "Subtraction", "뺄셈"), _defineProperty(_Receipt$Pos_Settings, "profil", "프로필"), _defineProperty(_Receipt$Pos_Settings, "logout", "로그 아웃"), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", "이 구매가 이미 지불했기 때문에 수정할 수 없습니다"), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", "이 판매는 이미 지불했기 때문에 수정할 수 없습니다."), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", "이 환불은 이미 지불했기 때문에 수정할 수 없습니다."), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", "이 견적은 이미 매출을 창출했습니다."), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", "이 완전한 견적"), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", "사이트 설정"), _defineProperty(_Receipt$Pos_Settings, "Language", "언어"), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", "기본 통화"), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", "로그인 캡차"), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", "기본 이메일"), _defineProperty(_Receipt$Pos_Settings, "SiteName", "사이트 이름"), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", "로고 변경"), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", "SMTP 설정"), _defineProperty(_Receipt$Pos_Settings, "HOST", "호스트"), _defineProperty(_Receipt$Pos_Settings, "PORT", "포트"), _defineProperty(_Receipt$Pos_Settings, "encryption", "암호화"), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", "잘못된 SMTP 설정"), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", "리턴 송장"), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", "송장 데이터 반환"), _defineProperty(_Receipt$Pos_Settings, "ShowAll", "모든 사용자에 관한 정보  표시"), _defineProperty(_Receipt$Pos_Settings, "Discount", "할인"), _defineProperty(_Receipt$Pos_Settings, "OrderTax", "주문세"), _defineProperty(_Receipt$Pos_Settings, "Shipping", '「배송」'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", "관리 통화"), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", "통화 코드"), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", "통화 이름"), _defineProperty(_Receipt$Pos_Settings, "Symbol", "기호"), _defineProperty(_Receipt$Pos_Settings, "CompanyName", "회사 이름"), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", "회사 전화"), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", "회사 주소"), _defineProperty(_Receipt$Pos_Settings, "Code", "코드"), _defineProperty(_Receipt$Pos_Settings, "image", "이미지"), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", "바코드 인쇄"), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", "반품 판매"), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", "구매 수익"), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", "송장 판매 반환"), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", "송장은 구매를 반환합니다"), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", "사용할 수 없는 데이터"), _defineProperty(_Receipt$Pos_Settings, "ProductImage", "제품 이미지"), _defineProperty(_Receipt$Pos_Settings, "Barcode", "바코드"), _defineProperty(_Receipt$Pos_Settings, "pointofsales", "판매 지점"), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", "사용자 정의 업로드"), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", "판매 관리 지점"), _defineProperty(_Receipt$Pos_Settings, "Adjustment", "조정"), _defineProperty(_Receipt$Pos_Settings, "Updat", "업데이트"), _defineProperty(_Receipt$Pos_Settings, "Reset", "다시 시작"), _defineProperty(_Receipt$Pos_Settings, "print", "인쇄"), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", "우편으로 검색"), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", "제품 선택"), _defineProperty(_Receipt$Pos_Settings, "Qty", "양/장수"), _defineProperty(_Receipt$Pos_Settings, "Items", "기사"), _defineProperty(_Receipt$Pos_Settings, "AmountHT", "HT 금액"), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", "TTC 금액"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", "공급자 선택"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", "상태 선택"), _defineProperty(_Receipt$Pos_Settings, "PayeBy", "유료"), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", "창고 선택"), _defineProperty(_Receipt$Pos_Settings, "payNow", "지금 지불"), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", "카테고리 목록 /제품목록"), _defineProperty(_Receipt$Pos_Settings, "Description", "묘사 /제품설명"), _defineProperty(_Receipt$Pos_Settings, "submit", "구해내다 /저장/보관"), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", "이 송장을 만드는 데 문제가 있었습니다. 다시 시도해 주세요."), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", "지불에 문제가 있었습니다. 다시 시도해 주세요."), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", "맞춤 만들기"), _defineProperty(_Receipt$Pos_Settings, "Afewwords", "에 대한 몇 마디 ..."), _defineProperty(_Receipt$Pos_Settings, "UserImage", "사용자 이미지"), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", "제품 업데이트"), _defineProperty(_Receipt$Pos_Settings, "Brand", "낙인 /브렌드 /메이커"), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", "바코드 상징"), _defineProperty(_Receipt$Pos_Settings, "ProductCost", "제품 비용"), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", "제품 가격"), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", "단위 제품 은"), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", "세금 방법"), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", "여러 이미지"), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", "제품에는 여러 가지 변형이 있습니다"), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", "상품에 프로모션이 있습니다"), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", "프로모션 시작 /할인 시작"), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", "프로모션 종료 /할인종료"), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", "프로모션 가격 /할인가격"), _defineProperty(_Receipt$Pos_Settings, "Price", " 값"), _defineProperty(_Receipt$Pos_Settings, "Cost", "비용"), _defineProperty(_Receipt$Pos_Settings, "Unit", "단합"), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", "제품 변형"), _defineProperty(_Receipt$Pos_Settings, "Variant", "변형"), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", "단가"), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", "고객 반품 만들기"), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", "고객 반품 편집"), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", "공급업체 반환 만들기"), _defineProperty(_Receipt$Pos_Settings, "Documentation", "문서"), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", "공급업체 반환 편집"), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", "창고"), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", "창고에"), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", "전송 편집"), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", "전송 세부 사항"), _defineProperty(_Receipt$Pos_Settings, "Pending", "보류 중"), _defineProperty(_Receipt$Pos_Settings, "Received", "수신"), _defineProperty(_Receipt$Pos_Settings, "Ordered", "깔끔한"), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", "권한 관리자"), _defineProperty(_Receipt$Pos_Settings, "BrandManager", "브랜드 매니저"), _defineProperty(_Receipt$Pos_Settings, "BrandImage", "브랜드 이미지"), _defineProperty(_Receipt$Pos_Settings, "BrandName", "브랜드 이름"), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", "브랜드 설명"), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", "베이스 유닛"), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", "관리 단위"), _defineProperty(_Receipt$Pos_Settings, "OperationValue", "운영 가치"), _defineProperty(_Receipt$Pos_Settings, "Operator", "연산자"), _defineProperty(_Receipt$Pos_Settings, "Top5Products", "5 최고의 제품"), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", "마지막 5 판매"), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", "설정 목록"), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", "전송 목록"), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", "전송 만들기"), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", "주문 관리자"), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", "견적 목록"), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", "쇼핑 목록"), _defineProperty(_Receipt$Pos_Settings, "ListSales", "판매 목록"), _defineProperty(_Receipt$Pos_Settings, "ListReturns", "반환 목록"), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", "사람 관리자"), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", "브랜드 목록"), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: "확실한가요?",
  Text: "이것을 되돌릴 수 없습니다!",
  confirmButtonText: "예, 삭제!",
  cancelButtonText: "취소",
  Deleted: "제거!",
  Failed: "실패했습니다!",
  Therewassomethingwronge: "뭔가 잘못됐다.",
  CustomerDeleted: "이 고객님이 삭제되었습니다.",
  SupplierDeleted: "이 공급자가 제거되었습니다.",
  QuoteDeleted: "이 견적이 삭제되었습니다.",
  SaleDeleted: "이 판매는 제거되었습니다.",
  PaymentDeleted: "이 지불은 제거되었습니다.",
  PurchaseDeleted: "이 구매는 제거되었습니다.",
  ReturnDeleted: "이 반환이 제거되었습니다.",
  ProductDeleted: "이 쪽의 상품은 제거되었습니다.",
  ClientError: "이 고객은 이미 다른 작업에 연결되어 있습니다.",
  ProviderError: "이 공급자는 이미 다른 작업에 연결되어 있습니다.",
  UserDeleted: "이 사용자가 삭제되었습니다.",
  UnitDeleted: "이 유닛이 제거되었습니다.",
  RoleDeleted: "이 역할이 제거되었습니다.",
  TaxeDeleted: "이 세금은 제거되었습니다.",
  SubCatDeleted: "이 하위 범주가 제거되었습니다.",
  CatDeleted: "이 범주가 삭제되었습니다.",
  WarehouseDeleted: "이 창고가 제거되었습니다.",
  AlreadyLinked: "이 제품은 이미 다른 작업에 연결되어 있습니다",
  AdjustDeleted: "이 조정이 제거되었습니다.",
  TitleCurrency: "이 동전은 제거되었습니다.",
  TitleTransfer: "전송이 성공적으로 삭제되었습니다",
  BackupDeleted: "백업이 성공적으로 삭제되었습니다.",
  TitleBrand: "이 표시가 제거되었습니다."
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleProfile: "프로필이 성공적으로 업데이트되었습니다",
  TitleAdjust: "조정이 성공적으로 업데이트되었습니다",
  TitleRole: "역할이 성공적으로 업데이트되었습니다",
  TitleUnit: "유닛이 성공적으로 업데이트되었습니다",
  TitleUser: "성공적으로 업데이트 된 사용자",
  TitleCustomer: "고객이 성공적으로 업그레이드",
  TitleQuote: "예산이 올바르게 업데이트되었습니다",
  TitleSale: "판매가 성공적으로 업데이트되었습니다",
  TitlePayment: "결제가 성공적으로 업데이트되었습니다",
  TitlePurchase: "성공적으로 업데이트 된 구매",
  TitleReturn: "성공적으로 업데이트된 반환",
  TitleProduct: "제품이 성공적으로 업데이트되었습니다",
  TitleSupplier: "공급업체가 성공적으로 업데이트되었습니다",
  TitleTaxe: "세금이 성공적으로 업데이트되었습니다",
  TitleCat: "카테고리가 성공적으로 업데이트되었습니다",
  TitleWarhouse: "창고가 성공적으로 업데이트되었습니다",
  TitleSetting: "구성이 성공적으로 업데이트되었습니다",
  TitleCurrency: "이 동전이 업데이트되었습니다.",
  TitleTransfer: "전송이 성공적으로 업데이트되었습니다",
  TitleBrand: "이 브랜드는 업데이트되었습니다."
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: "이 브랜드는 만들어졌습니다",
  TitleTransfer: "전송이 성공적으로 만들어졌습니다",
  TitleRole: "역할이 성공적으로 만들어졌습니다",
  TitleUnit: "유닛이 성공적으로 만들어졌습니다",
  TitleUser: "성공적으로 만든 사용자",
  TitleCustomer: "고객이 성공적으로 창조",
  TitleQuote: "약속이 성공적으로 만들어졌습니다",
  TitleSale: "판매가 성공적으로 만들어졌습니다",
  TitlePayment: "결제가 성공적으로 만들어졌습니다",
  TitlePurchase: "성공적으로 만든 구매",
  TitleReturn: "성공적으로 만든 반환",
  TitleProduct: "성공적으로 만든 제품",
  TitleSupplier: "공급업체가 성공적으로 만들어졌습니다",
  TitleTaxe: "세금이 성공적으로 생성",
  TitleCat: "카테고리가 성공적으로 만들어졌습니다",
  TitleWarhouse: "창고가 성공적으로 만들어졌습니다",
  TitleAdjust: "성공적으로 맞춤 제작",
  TitleCurrency: "이 통화가 만들어졌습니다."
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: "타이틀 이메일"
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: "이 판매는 이미 반환에 연결되어 있습니다!"
}), _defineProperty(_Receipt$Pos_Settings, "RReturnManagement", "반품 관리"), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", "반품 세부 사항"), _defineProperty(_Receipt$Pos_Settings, "EditReturn", "반환 편집"), _defineProperty(_Receipt$Pos_Settings, "AddReturn", "반품 추가"), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", "이메일로 반품 보내기"), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", "반환 삭제"), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", "반납 할증료"), _defineProperty(_Receipt$Pos_Settings, "Laivrison", "배송"), _defineProperty(_Receipt$Pos_Settings, "SelectSale", "판매 선택"), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", "항목을 삭제하거나 반환되지 않은 경우 반환된 금액을 0으로 설정할 수 있습니다."), _defineProperty(_Receipt$Pos_Settings, "Return", "반환"), _defineProperty(_Receipt$Pos_Settings, "Purchase", "구매"), _defineProperty(_Receipt$Pos_Settings, "TotalSales", "총 판매"), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", "총 구매"), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", "총 반환"), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", "순 결제"), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", "전송된 결제"), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", "파이멘트 수령"), _defineProperty(_Receipt$Pos_Settings, "Recieved", "수신"), _defineProperty(_Receipt$Pos_Settings, "Sent", "발행"), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", "제품 수량 경고"), _defineProperty(_Receipt$Pos_Settings, "ProductCode", "제품 코드"), _defineProperty(_Receipt$Pos_Settings, "ProductName", "상품명"), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", "경고 금액"), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", "창고 주식 차트"), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", "총 제품"), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", "총 수량"), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", "5 최고의 고객"), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", "총 금액"), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", "총 지불"), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", "고객 판매 보고서"), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", "고객 지불 보고서"), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", "고객 견적 보고서"), _defineProperty(_Receipt$Pos_Settings, "Payments", "지불"), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", "상위 5개 공급업체"), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", "공급업체 구매 보고서"), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", "공급업체 지불 보고서"), _defineProperty(_Receipt$Pos_Settings, "Name", "이름"), _defineProperty(_Receipt$Pos_Settings, "Code", "코드"), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", "창고 관리"), _defineProperty(_Receipt$Pos_Settings, "ZipCode", "우편 번호"), _defineProperty(_Receipt$Pos_Settings, "managementCategories", "카테고리 관리"), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", "코드 범주"), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", "이름 카테고리"), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", "주요 카테고리"), _defineProperty(_Receipt$Pos_Settings, "managementTax", "재정 관리"), _defineProperty(_Receipt$Pos_Settings, "TaxName", "세금 이름"), _defineProperty(_Receipt$Pos_Settings, "TaxRate", "세율"), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", "구매 단위의 관리"), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", "영업 단위 관리"), _defineProperty(_Receipt$Pos_Settings, "ShortName", "짧은 이름"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", "제품을 추가하기 전에 선택하십시오."), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", "주식 조정"), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", "어떤 제품을 선택하기 전에 창고를 선택"), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", "주식 양도"), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", "기간 선택"), _defineProperty(_Receipt$Pos_Settings, "ThisYear", "금년"), _defineProperty(_Receipt$Pos_Settings, "ThisToday", "오늘"), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", "이번 달"), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", "이번 주"), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", "조정 세부 사항"), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", "이 사용자가 활성화되었습니다."), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", "이 사용자가 비활성화되었습니다."), _defineProperty(_Receipt$Pos_Settings, "NotFound", "페이지를 찾을 수 없습니다."), _defineProperty(_Receipt$Pos_Settings, "oops", "실수! 페이지를 찾을 수 없습니다."), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", "찾고 있던 페이지를 찾을 수 없었습니다."), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", "보드로 돌아가기"), _defineProperty(_Receipt$Pos_Settings, "hrm", '인적자원관리'), _defineProperty(_Receipt$Pos_Settings, "Employees", '직원'), _defineProperty(_Receipt$Pos_Settings, "Attendance", '출석'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", '탈퇴신청'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", '휴가 유형'), _defineProperty(_Receipt$Pos_Settings, "Company", '회사'), _defineProperty(_Receipt$Pos_Settings, "Departments", '부서'), _defineProperty(_Receipt$Pos_Settings, "Designations", '명칭'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", '사무실 교대'), _defineProperty(_Receipt$Pos_Settings, "Holidays", '긴 휴가'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", '회사명을 입력하세요'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", '이메일 주소 입력'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", '회사 전화번호 입력'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", '회사 국가 입력'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", '에 성공적으로 생성됨'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", '에 성공적으로 업데이트되었습니다.'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", '에 성공적으로 삭제되었습니다.'), _defineProperty(_Receipt$Pos_Settings, "department", '부서'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", '부서 이름 입력'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", '회사 선택'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", '부서장'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", '부서장 선택'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", '시프트 이름 입력'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", '월요일 인'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", '월요일 아웃'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", '화요일 인'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", '화요일 아웃'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", '수요일'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", '수요일 외출'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", '목요일 인'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", '목요일 아웃'), _defineProperty(_Receipt$Pos_Settings, "friday_in", '금요일 인'), _defineProperty(_Receipt$Pos_Settings, "friday_out", '금요일 아웃'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", '토요일 인'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", '토요일 아웃'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", '일요일 인'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", '일요일 외출'), _defineProperty(_Receipt$Pos_Settings, "Holiday", '휴일'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", '제목 입력'), _defineProperty(_Receipt$Pos_Settings, "title", '제목'), _defineProperty(_Receipt$Pos_Settings, "start_date", '시작일'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", '시작일 입력'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", '종료일'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", '종료일 입력'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", '세부정보를 제공하세요.'), _defineProperty(_Receipt$Pos_Settings, "Attendances", '출석'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", '출석일 입력'), _defineProperty(_Receipt$Pos_Settings, "Time_In", '타임 인'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", '타임아웃'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", '직원을 선택하십시오'), _defineProperty(_Receipt$Pos_Settings, "Employee", '직원'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", '작업 시간'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", '남은 잎사귀가 부족하다'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", '휴가 유형'), _defineProperty(_Receipt$Pos_Settings, "Days", '하루'), _defineProperty(_Receipt$Pos_Settings, "Department", '부서'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", '휴가 유형 선택'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", '상태를 선택하십시오'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", '이유를 남겨주세요'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", '휴직 사유 입력'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", '사원 추가'), _defineProperty(_Receipt$Pos_Settings, "FirstName", '이름'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", '이름을 입력하십시오'), _defineProperty(_Receipt$Pos_Settings, "LastName", '수리남'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", '성을 입력'), _defineProperty(_Receipt$Pos_Settings, "Gender", '성별'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", '성별 선택'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", '생년월일 입력'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", '생년월일'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", '국가 입력'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", '전화번호 입력'), _defineProperty(_Receipt$Pos_Settings, "joining_date", '가입 날짜'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", '가입 날짜 입력'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", '지정을 선택하십시오'), _defineProperty(_Receipt$Pos_Settings, "Designation", '명칭'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", '사무실 교대'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", '사무실 교대를 선택하십시오'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", '출발일 입력'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", '출발일'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", '연차 휴가'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", '연차휴가 입력'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", '남은 휴가'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", '직원 세부 정보'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", '기본 정보'), _defineProperty(_Receipt$Pos_Settings, "Family_status", '가족 상태'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", '가족 상태 선택'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", '고용 유형'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", '고용 유형 선택'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", '도시를 입력하십시오'), _defineProperty(_Receipt$Pos_Settings, "Province", '지방'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", '귀하의 지역을 입력하십시오'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", '주소를 입력하십시오'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", '우편 번호를 입력하세요'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", '우편 번호'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", '시간당 요금'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", '시간당 요금 입력'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", '기본 급여'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", '기본급을 입력하세요.'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", '소셜 미디어'), _defineProperty(_Receipt$Pos_Settings, "Skype", '스카이프'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", '스카이프를 입력하세요.'), _defineProperty(_Receipt$Pos_Settings, "Facebook", '페이스북'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", '당신의 페이스 북을 입력'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", '왓츠앱'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Whatsapp을 입력하십시오.'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", '링크드인'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", '링크드인을 입력하세요'), _defineProperty(_Receipt$Pos_Settings, "Twitter", '트위터'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", '귀하의 트위터를 입력'), _defineProperty(_Receipt$Pos_Settings, "Experiences", '경험담'), _defineProperty(_Receipt$Pos_Settings, "bank_account", '은행 계좌'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", '회사 명'), _defineProperty(_Receipt$Pos_Settings, "Location", '위치'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", '위치를 입력하십시오'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", '설명을 입력하십시오'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", '은행 이름'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", '은행 이름 입력'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", '은행 지점'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", '은행 지점 입력'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", '은행 번호'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", '은행 번호 입력'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", '지정된 창고'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", '상위 고객'), _defineProperty(_Receipt$Pos_Settings, "Attachment", '부착'), _defineProperty(_Receipt$Pos_Settings, "view_employee", '직원보기'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", '직원 편집'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", '직원 삭제'), _defineProperty(_Receipt$Pos_Settings, "Created_by", '추가한 사람'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", '제품 IMEI/일련번호 추가'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", '제품에 Imei/일련 번호가 있음'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", '배송'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", '배달'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", '배송 참조'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", '판매 참조'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", '배송 수정'), _defineProperty(_Receipt$Pos_Settings, "Packed", '포장 된'), _defineProperty(_Receipt$Pos_Settings, "Shipped", '배송됨'), _defineProperty(_Receipt$Pos_Settings, "Delivered", '배달됨'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", '취소 된'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", '배송 상태'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", '사용자 보고서'), _defineProperty(_Receipt$Pos_Settings, "stock_report", '주식 보고서'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", '총 구매'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", '총 견적'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", '총 반품 판매'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", '총 반품 구매'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", '총 이체'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", '총 조정'), _defineProperty(_Receipt$Pos_Settings, "User_report", '사용자 보고서'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", '현재 재고'), _defineProperty(_Receipt$Pos_Settings, "product_name", '상품명'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", '총 부채'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", '총 부채'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", '일부 창고'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", '모든 창고'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", '제품 비용'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'SMS 설정'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'POS 설정'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", '결제 게이트웨이'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", '메일 설정'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", '기본 SMS 게이트웨이'), _defineProperty(_Receipt$Pos_Settings, "module_settings", '모듈 설정'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", '모듈이 성공적으로 활성화되었습니다.'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", '모듈이 성공적으로 비활성화되었습니다.'), _defineProperty(_Receipt$Pos_Settings, "update_settings", '설정 업데이트'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", '올바른 모듈을 업로드하십시오'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", '에 성공적으로 업로드됨'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", '고객 세부 정보'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", '고객 편집'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", '삭제'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", '모든 납입금을 지불하다'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", '지불 금액이 총액보다 큽니다.'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", '고객 송장'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", '이 제품은 판매용이 아닙니다.'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", '대시보드에 오신 것을 환영합니다'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", '총액'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", '판매 참조를 선택하십시오'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", '세일을 선택해주세요'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", '판매 참고 자료'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", '제품 반품 나열'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", '반품 수량'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", '구매 참조 선택'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", '구매 참조'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", '구매를 선택해주세요'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", '반품 수량은 구매 수량보다 많습니다.'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", '반품 수량은 판매 수량보다 많습니다.'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", '판매 수량'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", '구매 수량'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", '보내는 사람 이름'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", '모듈은 zip 파일로 업로드해야 합니다.'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", '업로드 모듈'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", '설치된 모든 모듈'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", '현재 버전'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", '당신은 이미 최신 버전을 가지고 있습니다'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", '사용 가능한 업데이트'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", '업데이트 로그'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", '지금 업데이트'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", '변경 로그 보기'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", '인보이스 바닥글'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", '참고: 업데이트가 완전히 완료될 때까지 기다리십시오. 브라우저를 닫거나 프로세스를 중지하지 않는 것이 좋습니다. 업그레이드'), _defineProperty(_Receipt$Pos_Settings, "Note_update", '참고: 업그레이드를 실행하기 전에 현재 버전 및 데이터베이스를 백업했는지 확인하십시오. 오류가 있는 경우 복원하려면'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", '시간대'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", '지불 메모'), _defineProperty(_Receipt$Pos_Settings, "sale_note", '판매 노트'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", '총 판매 부채'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", '총 판매 반환 부채'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", '한 번에 모든 판매 부채를 지불'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", '한 번에 모든 판매 반환 부채를 지불'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", '총 이익'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", '한 번에 모든 구매 부채를 갚다'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", '공급자 삭제'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", '제공자 편집'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", '제공업체 세부정보'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", '총 구매 부채'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", '신용 노트'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", '신용 노트'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", '반품 판매'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", '구매 반품'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", '세금 번호'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", '반품 수량을 추가해주세요'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", '거래에 대한 반품이 있습니다.'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", '반품 수량은 남은 수량보다 큽니다.'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", '수량을 0으로 설정한 제품은 환불되지 않습니다.'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", '한 번에 모든 구매 반환을 지불'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", '총 구매 반환 부채'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", '반환 부채를 구입'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", '반환 부채를 팔다'), _defineProperty(_Receipt$Pos_Settings, "product_report", '제품 보고서'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", '제품 판매 보고서'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", '제품 구매 보고서'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", '판매 수량'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", '구입한 수량'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", '창고로 필터링'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", '인보이스 자동 인쇄'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", '보기 창고'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", '신용카드 정보'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", '저장된 신용카드 정보'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", '신용카드가 성공적으로 변경되었습니다'), _defineProperty(_Receipt$Pos_Settings, "notification_template", '알림 템플릿'), _defineProperty(_Receipt$Pos_Settings, "email_notification", '이메일 알림'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'SMS 알림'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", '제품 상세 정보 수정'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", '세금, 할인 및 배송 수정'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", '재고를 활용한 견적서 생성'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", '변형 이름'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", '변형 비용'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", '변형 가격'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", '변형 코드'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", '제품 로딩이 완료될 때까지 기다려주십시오'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'SMS 게이트웨이 선택'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", '고객 알림'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", '사용 가능한 태그'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", '이메일 제목'), _defineProperty(_Receipt$Pos_Settings, "Email_body", '이메일 본문'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", '공급 업체 알림'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'SMS 본문'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'SMS Templates'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Email Templates'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/mm.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/mm.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Anglais

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Receipt',
  Pos_Settings: 'Pos Settings (Receipt)',
  Note_to_customer: 'Note to customer',
  Show_Note_to_customer: 'Show Note to customer',
  Show_barcode: 'Show barcode',
  Show_Tax_and_Discount: 'Show Tax & Discount & Shipping',
  Show_Customer: 'Show Customer',
  Show_Email: 'Show Email',
  Show_Phone: 'Show Phone',
  Show_Address: 'Show Address',
  DefaultLanguage: 'Default Language',
  footer: 'footer',
  Received_Amount: 'ပေးငွေ',
  Paying_Amount: 'ကျသင့်ငွေ',
  Change: 'ပြန်အမ်းငွေ',
  Paying_amount_is_greater_than_Received_amount: 'Paying amount is greater than received amount',
  Paying_amount_is_greater_than_Grand_Total: 'Paying amount is greater than Grand Total',
  code_must_be_not_exist_already: 'code must be not exist already',
  You_will_find_your_backup_on: 'You will find your backup on',
  and_save_it_to_your_pc: 'and save it to your pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scan your barcode and select the correct symbology below',
  Scan_Search_Product_by_Code_Name: 'Scan/Search Product by Code Or Name',
  Paper_size: 'Paper size',
  Clear_Cache: 'Clear Cache',
  Cache_cleared_successfully: 'Cache cleared successfully',
  Failed_to_clear_cache: 'Failed to clear cache',
  Scan_Barcode: 'Barcode Scanner',
  Please_use_short_name_of_unit: 'Please use short name of unit',
  DefaultCustomer: 'Default Customer',
  DefaultWarehouse: 'Default Warehouse',
  Payment_Gateway: 'Payment Gateway',
  SMS_Configuration: 'SMS Configuration',
  Gateway: 'SMS Gateway',
  Choose_Gateway: 'Choose SMS Gateway',
  Send_SMS: 'Message sent successfully',
  sms_config_invalid: 'wrong sms config invalid',
  Remove_Stripe_Key_Secret: 'Delete Stripe API keys',
  credit_card_account_not_available: 'Credit card account not available',
  Credit_Card_Info: 'Credit Card Info',
  developed_by: 'Developed by',
  Unit_already_linked_with_sub_unit: 'Unit already linked with sub unit',
  Total_Items_Quantity: 'Total Items & Quantity',
  Value_by_Cost_and_Price: 'Value by Cost and Price',
  Search_this_table: 'Search this table',
  import_products: 'Import products',
  Field_optional: 'Field optional',
  Download_exemple: 'Download example',
  field_must_be_in_csv_format: 'Field must be in csv format',
  Successfully_Imported: 'Successfully Imported',
  file_size_must_be_less_than_1_mega: 'File size must be less than 1 mega',
  Please_follow_the_import_instructions: 'Please follow the import instructions',
  must_be_exist: 'unit must already be created',
  Import_Customers: 'Import Customers',
  Import_Suppliers: 'Import Suppliers',
  Recent_Sales: 'လတ်တလောရောင်းချစာရင်း',
  Create_Transfer: 'ကုန်ပစ္စည်းရွှေ့ခြင်း',
  order_products: 'Order items',
  Search_Product_by_Code_Name: 'Search Product by code or name',
  Reports_payments_Purchase_Return: 'Reports Purchase Return Payments',
  Reports_payments_Sale_Return: 'Reports Sale Return Payments',
  payments_Sales_Return: 'Payments Sales Return',
  payments_Purchases_Return: 'Payments Purchases Return',
  CreateSaleReturn: 'Create Sale Return',
  EditSaleReturn: 'Edit Sale Return',
  SalesReturn: 'Sales Return',
  CreatePurchaseReturn: 'Create Purchase Return',
  EditPurchaseReturn: 'Edit Purchase Return',
  PurchasesReturn: 'Purchases Return',
  Due: 'Due',
  Profit: 'Profit',
  Revenue: 'Revenue',
  Sales_today: 'Today Sales',
  People: 'People',
  Successfully_Created: 'Successfully Created',
  Successfully_Updated: 'Successfully Updated',
  Success: 'Success',
  Failed: 'Failed',
  Warning: 'Warning',
  Please_fill_the_form_correctly: 'Please fill the form correctly',
  Field_is_required: 'This Field is required',
  Error: 'Error!',
  you_are_not_authorized: 'Sorry! you are not authorized.',
  Go_back_to_home: 'Go back to homepage',
  page_not_exist: 'Sorry! The page you were looking for doesn\'t exist.',
  Choose_Status: 'Choose Status',
  Choose_Method: 'Choose Method',
  Choose_Symbology: 'Choose symbology',
  Choose_Category: 'Choose Category',
  Choose_Customer: 'Choose Customer',
  Choose_Supplier: 'Choose Supplier',
  Choose_Unit_Purchase: 'Choose Purchase Unit',
  Choose_Sub_Category: 'Choose SubCategory',
  Choose_Brand: 'Choose Brand',
  Choose_Warehouse: 'ဂိုထောင်ရွေးချယ်ရန်',
  Choose_Unit_Sale: 'Choose Sale Unit',
  Enter_Product_Cost: 'Enter Product Cost',
  Enter_Stock_alert: 'Enter Stock alert',
  Choose_Unit_Product: 'Choose Product Unit',
  Enter_Product_Price: 'Enter Product Price',
  Enter_Name_Product: 'Enter Name Product',
  Enter_Role_Name: 'Enter Role Name',
  Enter_Role_Description: 'Enter Role Description',
  Enter_name_category: 'Enter category Name',
  Enter_Code_category: 'Enter category Code',
  Enter_Name_Brand: 'Enter Name Brand',
  Enter_Description_Brand: 'Enter Description Brand',
  Enter_Code_Currency: 'Enter Code Currency',
  Enter_name_Currency: 'Enter name Currency',
  Enter_Symbol_Currency: 'Enter Symbol Currency',
  Enter_Name_Unit: 'Enter Unit Name',
  Enter_ShortName_Unit: 'Enter shortname Unit',
  Choose_Base_Unit: 'Choose Base Unit',
  Choose_Operator: 'Choose Operator',
  Enter_Operation_Value: 'Enter Operation Value',
  Enter_Name_Warehouse: 'Enter Warehouse Name',
  Enter_Phone_Warehouse: 'Enter Warehouse Phone',
  Enter_Country_Warehouse: 'Enter Warehouse Country',
  Enter_City_Warehouse: 'Enter Warehouse City',
  Enter_Email_Warehouse: 'Enter Warehouse Email',
  Enter_ZipCode_Warehouse: 'Enter Warehouse Zip Code',
  Choose_Currency: 'Choose Currency',
  Thank_you_for_your_business: 'Thank you for shopping with us . Please come again',
  Cancel: 'Cancel',
  New_Customer: 'New Customer',
  Incorrect_Login: 'Incorrect Login',
  Successfully_Logged_In: 'Successfully Logged In',
  This_user_not_active: 'This user not active',
  SignIn: 'Sign In',
  Create_an_account: 'Create an account',
  Forgot_Password: 'Forgot Password ?',
  Email_Address: 'Email Address',
  SignUp: 'Sign Up',
  Already_have_an_account: 'Already have an account ?',
  Reset_Password: 'Reset Password',
  Failed_to_authenticate_on_SMTP_server: 'Failed to authenticate on SMTP server',
  We_cant_find_a_user_with_that_email_addres: 'We can\'t find a user with that email addres',
  We_have_emailed_your_password_reset_link: 'We have e-mailed your password reset link',
  Please_fill_the_Email_Adress: 'Please fill the Email Address',
  Confirm_password: 'Confirm password',
  Your_Password_has_been_changed: 'Your Password has been changed',
  The_password_confirmation_does_not_match: 'The password confirmation does not match',
  This_password_reset_token_is_invalid: 'This password reset token is invalid',
  Warehouse_report: 'ဂိုထောင်အစီရင်ခံစာ',
  All_Warehouses: 'ဂိုထောင်အားလုံး',
  Expense_List: 'အသုံးစာရင်းအားလုံး',
  Expenses: 'အသုံးစာရင်းများ',
  This_Week_Sales_Purchases: 'တစ်ပါတ်အတွင်း ကုန်ဝယ်နှင့်ကုန်ရောင်း',
  Top_Selling_Products: 'ရောင်းအားအကောင်းဆုံးကုန်ပစ္စည်းစာရင်း',
  View_all: 'View all',
  Payment_Sent_Received: 'ပေးငွေ/ရငွေ',
  Filter: 'Filter',
  Invoice_POS: 'Invoice POS',
  Invoice: 'Invoice',
  Customer_Info: 'Customer Info',
  Company_Info: 'Company Info',
  Invoice_Info: 'Invoice Info',
  Order_Summary: 'Order Summary',
  Quote_Info: 'Quotation Info',
  Del: 'Delete',
  SuppliersPaiementsReport: 'Suppliers Payments Report',
  Purchase_Info: 'Purchase Info',
  Supplier_Info: 'Supplier Info',
  Return_Info: 'Info of Return',
  Expense_Category: 'Expense Category',
  Create_Expense: 'အသုံးစာရင်းထည့်သွင်းခြင်း',
  Details: 'အသေးစိတ်',
  Discount_Method: 'Discount Type',
  Net_Unit_Cost: 'Net Unit Cost',
  Net_Unit_Price: 'Net Unit Price',
  Edit_Expense: 'Edit Expense',
  All_Brand: 'All Brand',
  All_Category: 'All Category',
  ListExpenses: 'အသုံးစာရင်းအားလုံး',
  Create_Permission: 'Create Permission',
  Edit_Permission: 'Edit Permission',
  Reports_payments_Sales: 'Reports payments Sales',
  Reports_payments_Purchases: 'Reports payments Purchases',
  Reports_payments_Return_Customers: 'Payments Return Customers',
  Reports_payments_Return_Suppliers: 'Payments Return Suppliers',
  Expense_Deleted: 'This Expense has been deleted',
  Expense_Updated: 'This Expense has been Updated',
  Expense_Created: 'This Expense has been Created',
  DemoVersion: 'You cannot do this in the demo version',
  OrderStatistics: 'Sales Statistics',
  AlreadyAdd: 'This Product Already Added !!',
  AddProductToList: 'Please Add Product To List !!',
  AddQuantity: 'Please Add quantity of product !!',
  InvalidData: 'Invalid Data !!',
  LowStock: 'Quantity exceeds quantity available in stock',
  WarehouseIdentical: 'The two warehouses cannot be identical !!',
  VariantDuplicate: 'This Variant Is Duplicate !!',
  Filesize: 'File size',
  GenerateBackup: 'Generate Backup',
  BackupDatabase: 'Backup Database',
  Backup: 'Backup',
  Paid: 'Paid',
  Unpaid: 'Unpaid',
  Today: 'ယနေ့',
  Income: 'Income'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'အသုံးစာရင်း'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'Sale'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Active'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Inactive'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'Customers'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Phone'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Search by Phone'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Suppliers'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Quotations'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'ကုန်ရောင်းစာရင်း'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'ကုန်ဝယ်စာရင်း'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'Return'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'Settings'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'System Settings '), _defineProperty(_Receipt$Pos_Settings, "Users", 'Users'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Group Permissions'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'Currency'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'Warehouse'), _defineProperty(_Receipt$Pos_Settings, "Units", 'Unit'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'Purchases Units'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Sales Units'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'အစီရင်ခံစာများ'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Payments Report'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Payments Purchases'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Payments Sales'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'အရှုံးအမြတ်စာရင်း'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Warehouse Stock Chart'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'ကုန်ရောင်းစာရင်း'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'ကုန်ဝယ်စာရင်း'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'ဝယ်သူ Report'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Supplier Report'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Supplier Report'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'နေ့စဉ်အရောင်းစာရင်း'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'နေ့စဉ်ကုန်ဝယ်စာရင်း'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Last five records'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'Filters'), _defineProperty(_Receipt$Pos_Settings, "date", 'ရက်စွဲ'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Reference'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Supplier'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Payment Status'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'ဝယ်သူ'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'ဝယ်သူကုတ်နံပါတ်'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Status'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Supplier Code'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Category'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'Category'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'ကုန်ပစ္စည်းရွှေ့ခြင်း'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Stock Management'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Dashboard'), _defineProperty(_Receipt$Pos_Settings, "Products", 'ကုန်ပစ္စည်းများ'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'ကုန်ပစ္စည်းအားလုံး'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Product Management'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'ကုန်ခါနီးပစ္စည်းစာရင်း'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Code Product'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Product Tax'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'Sub Category'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'ကုန်ပစ္စည်းအမည်'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Alert Qty'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'ဂိုထောင်'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'Tax'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Buying price'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Sell price'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'အရေအတွက်'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Sale Unit'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'ကုန်ဝယ်ယူနစ်'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Currency Management'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Currency Code'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Currency Name'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Symbol'), _defineProperty(_Receipt$Pos_Settings, "All", 'All'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Edit Product'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Search by Code'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Search by Name'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Product Details'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'ဝယ်သူ အမည်'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'ဝယ်သူ စီမံခန့်ခွဲခြင်း'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Create'), _defineProperty(_Receipt$Pos_Settings, "add", 'Create'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'ပြင်ဆင်မည်'), _defineProperty(_Receipt$Pos_Settings, "Close", 'Close'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Please Select'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Action'), _defineProperty(_Receipt$Pos_Settings, "Email", 'Email'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Edit Customer'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Create Customer'), _defineProperty(_Receipt$Pos_Settings, "Country", 'Country'), _defineProperty(_Receipt$Pos_Settings, "City", 'City'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Address'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'ဝယ်သူအသေးစိတ်'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Customers'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Supplier Code'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'Supplier Name'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Suppliers Management'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Supplier Details'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Quotations Management'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Subtotal'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Amount left'), _defineProperty(_Receipt$Pos_Settings, "complete", 'Completed'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'Pending'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Received'), _defineProperty(_Receipt$Pos_Settings, "partial", 'Partial'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Return'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Detail Quotation'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Edit Quotation'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Create Sale'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'Download Pdf'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'Send Quotation on Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Delete Quotation'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'Create Quotation'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Select Product'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Product (Code - Name)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Price'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'Stock'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Grand Total'), _defineProperty(_Receipt$Pos_Settings, "Num", 'N°'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Unit cost'), _defineProperty(_Receipt$Pos_Settings, "to", 'To'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Subject'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Message'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'Email Customer'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Send'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'Quotation'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Hello'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Please find the attachment for your Quotation'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Add Products to the Order List'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'ဂိုထောင်ရွေးချယ်ပါ'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'ဝယ်သူရွေးချယ်ပါ'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Sales Management'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Balance'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Qty Back'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Total Return'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'Amount'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Sale Detail'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Edit Sale'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Create Sale'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Show Payments'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'ငွေရှင်းမည်'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Edit Payment'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Send Sale on Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Delete Sale'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Paid by'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Payment choice'), _defineProperty(_Receipt$Pos_Settings, "Note", 'မှတ်ချက်'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Payment complete!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Purchases Management'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Ordered'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Delete Purchase'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Send Purchase on Email'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'ကုန်ဝယ်စာရင်ပြင်ဆင်ခြင်း'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'ကုန်ဝယ်အသေးစိတ်'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'ကုန်ဝယ်စာရင်းထည့်သွင်းခြင်း'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'Supplier Email'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Purchases payments'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Purchases payments data'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'Sales payments'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Sales payments data'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'Users management'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'First name'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'Last name'), _defineProperty(_Receipt$Pos_Settings, "username", 'Username'), _defineProperty(_Receipt$Pos_Settings, "password", 'Password'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'New password'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Change Avatar'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Please leave this field blank if you haven\'t changed it'), _defineProperty(_Receipt$Pos_Settings, "type", 'Type'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Users Permissions'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Role'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Role Description'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Create Permissions'), _defineProperty(_Receipt$Pos_Settings, "View", 'View'), _defineProperty(_Receipt$Pos_Settings, "Del", 'Delete'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'New Adjustement'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Edit Adjustement'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'You cannot subtraction products which have stock 0'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'အရေအတွက်တိုးမည်'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'အရေအတွက်လျှော့မည်'), _defineProperty(_Receipt$Pos_Settings, "profil", 'Profile'), _defineProperty(_Receipt$Pos_Settings, "logout", 'Logout'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'You cannot modify because this Purchase already paid'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'You cannot modify because this Sale already paid'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'You cannot modify because this Return already paid'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'This quote already has generate sale'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'ကုန်ပစ္စည်းဖန်တီးခြင်း'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'This Quotation Complete'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Site Configuration'), _defineProperty(_Receipt$Pos_Settings, "Language", 'ဘာသာစကား'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'ပင်မအသုံးပြုသည့်ငွေကြေး'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Login Captcha'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'Default Email'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Site Name'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Change Logo'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'SMTP Configuration'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'MAIL_HOST'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'MAIL_PORT'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'MAIL_ENCRYPTION'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'SMTP Configuration Incorrect'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Payments Returns'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'Returns Invoices'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'Returns Invoices Data'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'View all records of all Users'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Discount'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Order Tax'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'သယ်ယူစရိတ်'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Company Name'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Company Phone'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Company Address'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), _defineProperty(_Receipt$Pos_Settings, "image", 'Image'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Print Labels'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Returns Customer'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Returns Supplier'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'Return Customer Invoice'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Return Supplier Invoice'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'No data Available'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'Product Image'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'Barcode'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'Point of Sales'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Custom Upload'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'Point of Sale Management'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Adjustment'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Update'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Reset'), _defineProperty(_Receipt$Pos_Settings, "print", 'Print'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Search By Email'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Choose Product'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Qty'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Items'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Amount HT'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'Amount TTC'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Please Select Supplier'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Please Select Status'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'Paid By'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'ဂိုဒေါင်ရွေးချယ်ရန်'), _defineProperty(_Receipt$Pos_Settings, "payNow", 'Pay Now'), _defineProperty(_Receipt$Pos_Settings, "ListofCategory", 'List of Category'), _defineProperty(_Receipt$Pos_Settings, "Description", 'Description'), _defineProperty(_Receipt$Pos_Settings, "submit", 'သိမ်းမည်'), _defineProperty(_Receipt$Pos_Settings, "ProblemCreatingThisInvoice", 'There was a problem creating this Invoice. Please try again'), _defineProperty(_Receipt$Pos_Settings, "ProblemPayment", 'There was a problem Payment. Please try again.'), _defineProperty(_Receipt$Pos_Settings, "IncomeExpenses", 'Income & Expenses'), _defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Daily Sales & Purchases'), _defineProperty(_Receipt$Pos_Settings, "ProductsExpired", 'Products Expired'), _defineProperty(_Receipt$Pos_Settings, "ListofBrand", 'Brands'), _defineProperty(_Receipt$Pos_Settings, "CreateAdjustment", 'Create Adjustment'), _defineProperty(_Receipt$Pos_Settings, "Afewwords", 'A few words ...'), _defineProperty(_Receipt$Pos_Settings, "UserImage", 'User Image'), _defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Update Product'), _defineProperty(_Receipt$Pos_Settings, "Brand", 'Brand'), _defineProperty(_Receipt$Pos_Settings, "BarcodeSymbology", 'Barcode Symbology'), _defineProperty(_Receipt$Pos_Settings, "ProductCost", 'ဝယ်ဈေး'), _defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'ရောင်းဈေး'), _defineProperty(_Receipt$Pos_Settings, "UnitProduct", 'ကုန်ပစ္စည်းယူနစ်'), _defineProperty(_Receipt$Pos_Settings, "TaxMethod", 'Tax Type'), _defineProperty(_Receipt$Pos_Settings, "MultipleImage", 'ဓါတ်ပုံထည့်သွင်းရန်'), _defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'This Product Has Multi Variants'), _defineProperty(_Receipt$Pos_Settings, "ProductHasPromotion", 'Product Has Promotion'), _defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Promotion Start'), _defineProperty(_Receipt$Pos_Settings, "PromotionEnd", 'Promotion End'), _defineProperty(_Receipt$Pos_Settings, "PromotionPrice", 'Promotion Price'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Price'), _defineProperty(_Receipt$Pos_Settings, "Cost", 'Cost'), _defineProperty(_Receipt$Pos_Settings, "Unit", 'Unit'), _defineProperty(_Receipt$Pos_Settings, "ProductVariant", 'Product Variant'), _defineProperty(_Receipt$Pos_Settings, "Variant", 'Variant'), _defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Unit Price'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnCustomer", 'Create Return Customer'), _defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Edit Return Customer'), _defineProperty(_Receipt$Pos_Settings, "CreateReturnSupplier", 'Create Return Supplier'), _defineProperty(_Receipt$Pos_Settings, "Documentation", 'Doc'), _defineProperty(_Receipt$Pos_Settings, "EditReturnSupplier", 'Edit Return Supplier'), _defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'ပေးပို့သည့်ဂိုထောင်'), _defineProperty(_Receipt$Pos_Settings, "ToWarehouse", 'လက်ခံသည့်ဂိုထောင်'), _defineProperty(_Receipt$Pos_Settings, "EditTransfer", 'Edit Transfer'), _defineProperty(_Receipt$Pos_Settings, "TransferDetail", 'Transfer Detail'), _defineProperty(_Receipt$Pos_Settings, "Pending", 'Pending'), _defineProperty(_Receipt$Pos_Settings, "Received", 'Received'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Ordered'), _defineProperty(_Receipt$Pos_Settings, "PermissionsManager", 'Permissions Management'), _defineProperty(_Receipt$Pos_Settings, "BrandManager", 'Brand'), _defineProperty(_Receipt$Pos_Settings, "BrandImage", 'Brand Image'), _defineProperty(_Receipt$Pos_Settings, "BrandName", 'Brand Name'), _defineProperty(_Receipt$Pos_Settings, "BrandDescription", 'Brand Description'), _defineProperty(_Receipt$Pos_Settings, "BaseUnit", 'Base Unit'), _defineProperty(_Receipt$Pos_Settings, "ManagerUnits", 'Units Management'), _defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Operation Value'), _defineProperty(_Receipt$Pos_Settings, "Operator", 'Operator'), _defineProperty(_Receipt$Pos_Settings, "Top5Products", 'ထိပ်ဆုံးကုန်ပစ္စည်း(၅)ခု'), _defineProperty(_Receipt$Pos_Settings, "Last5Sales", 'နောက်ဆုံးအရောင်း(၅)ခု'), _defineProperty(_Receipt$Pos_Settings, "ListAdjustments", 'All Adjustments'), _defineProperty(_Receipt$Pos_Settings, "ListTransfers", 'All Transfers'), _defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Create Transfer'), _defineProperty(_Receipt$Pos_Settings, "OrdersManager", 'Orders Management'), _defineProperty(_Receipt$Pos_Settings, "ListQuotations", 'All Quotations'), _defineProperty(_Receipt$Pos_Settings, "ListPurchases", 'ကုန်ဝယ်စာရင်းအားလုံး'), _defineProperty(_Receipt$Pos_Settings, "ListSales", 'ကုန်ရောင်းစာရင်းအားလုံး'), _defineProperty(_Receipt$Pos_Settings, "ListReturns", 'All Returns'), _defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'People Management'), _defineProperty(_Receipt$Pos_Settings, "Delete", {
  Title: 'သေချာပါသလား?',
  Text: 'You won\'t be able to revert this!',
  confirmButtonText: 'ဖျက်ပါမည်',
  cancelButtonText: 'Cancel',
  Deleted: 'Deleted!',
  Failed: 'Failed!',
  Therewassomethingwronge: 'There was something wronge',
  CustomerDeleted: 'This Client has been deleted.',
  SupplierDeleted: 'This Supplier has been deleted.',
  QuoteDeleted: 'This Quotation has been deleted.',
  SaleDeleted: 'This Sale has been deleted.',
  PaymentDeleted: 'This Payment has been deleted.',
  PurchaseDeleted: 'This Purchase has been deleted.',
  ReturnDeleted: 'This Return has been deleted.',
  ProductDeleted: 'This Product has been deleted.',
  ClientError: 'This Client already linked with other Operation',
  ProviderError: 'This Supplier already linked with other Operation',
  UserDeleted: 'This User has been deleted.',
  UnitDeleted: 'This Unit has been deleted.',
  RoleDeleted: 'This Role has been deleted.',
  TaxeDeleted: 'This Tax has been deleted.',
  SubCatDeleted: 'This Sub Category has been deleted.',
  CatDeleted: 'This Category has been deleted.',
  WarehouseDeleted: 'This Warehouse has been deleted.',
  AlreadyLinked: 'This product already linked with other Operation',
  AdjustDeleted: 'This Adjustement has been deleted.',
  TitleCurrency: 'This Currency has been deleted.',
  TitleTransfer: 'The Transfer has been removed successfully',
  BackupDeleted: 'Backup has been removed successfully',
  TitleBrand: 'This Brand has been deleted'
}), _defineProperty(_Receipt$Pos_Settings, "Update", {
  TitleBrand: 'This Brand has been Updated',
  TitleProfile: 'Your Profile Updated in successfully',
  TitleAdjust: 'Adjustement Updated in successfully',
  TitleRole: 'Role Updated in successfully',
  TitleUnit: 'Unit Updated in successfully',
  TitleUser: 'User Updated in successfully',
  TitleCustomer: 'Customer Updated in successfully',
  TitleQuote: 'Quotation Updated in successfully',
  TitleSale: 'Sale Updated in successfully',
  TitlePayment: 'Payment Updated in successfully',
  TitlePurchase: 'Purchase Updated in successfully',
  TitleReturn: 'Return Updated in successfully',
  TitleProduct: 'Product Updated in successfully',
  TitleSupplier: 'Supplier Updated in successfully',
  TitleTaxe: 'Tax Updated in successfully',
  TitleCat: 'Category Updated in successfully',
  TitleWarhouse: 'Warhouse Updated in successfully',
  TitleSetting: 'Settings Updated in successfully',
  TitleCurrency: 'Currency Updated in successfully',
  TitleTransfer: 'Transfer Updated in successfully'
}), _defineProperty(_Receipt$Pos_Settings, "Create", {
  TitleBrand: 'This Brand has been Created',
  TitleRole: 'Role Created in successfully',
  TitleUnit: 'Unit Created in successfully',
  TitleUser: 'User Created in successfully',
  TitleCustomer: 'Customer Created in successfully',
  TitleQuote: 'Quotation Created in successfully',
  TitleSale: 'Sale Created in successfully',
  TitlePayment: 'Payment Created in successfully',
  TitlePurchase: 'Purchase Created in successfully',
  TitleReturn: 'Return Created in successfully',
  TitleProduct: 'Product Created in successfully',
  TitleSupplier: 'Supplier Created in successfully',
  TitleTaxe: 'Tax Created in successfully',
  TitleCat: 'Category Created in successfully',
  TitleWarhouse: 'Warehouse Created in successfully',
  TitleAdjust: 'Adjustement Created in successfully',
  TitleCurrency: 'Currency Created in successfully',
  TitleTransfer: 'Transfer Created in successfully'
}), _defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email Send in successfully'
}), _defineProperty(_Receipt$Pos_Settings, "return", {
  TitleSale: 'This sale already linked with a Return!'
}), _defineProperty(_Receipt$Pos_Settings, "ReturnManagement", 'Return Management'), _defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Return Detail'), _defineProperty(_Receipt$Pos_Settings, "EditReturn", 'Edit Return'), _defineProperty(_Receipt$Pos_Settings, "AddReturn", 'Create Return'), _defineProperty(_Receipt$Pos_Settings, "EmailReturn", 'Send Return on Email'), _defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Delete Return'), _defineProperty(_Receipt$Pos_Settings, "Retoursurcharge", 'Return Surcharge'), _defineProperty(_Receipt$Pos_Settings, "Laivrison", 'Delivery'), _defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Select Sale'), _defineProperty(_Receipt$Pos_Settings, "ZeroPardefault", 'You can delete the item or set the quantity returned to zero if it is not returned'), _defineProperty(_Receipt$Pos_Settings, "Return", 'Return'), _defineProperty(_Receipt$Pos_Settings, "Purchase", 'Purchase'), _defineProperty(_Receipt$Pos_Settings, "TotalSales", 'Total Sales'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total Purchases'), _defineProperty(_Receipt$Pos_Settings, "TotalReturns", 'Total Returns'), _defineProperty(_Receipt$Pos_Settings, "PaiementsNet", 'Payments Net'), _defineProperty(_Receipt$Pos_Settings, "PaiementsSent", 'Payments Sent'), _defineProperty(_Receipt$Pos_Settings, "PaiementsReceived", 'Payments Received'), _defineProperty(_Receipt$Pos_Settings, "Recieved", 'Recieved'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'Sent'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Product Quantity Alerts'), _defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Code'), _defineProperty(_Receipt$Pos_Settings, "ProductName", 'Product'), _defineProperty(_Receipt$Pos_Settings, "AlertQuantity", 'Alert Quantity'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Warehouse Stock Chart'), _defineProperty(_Receipt$Pos_Settings, "TotalProducts", 'စုစုပေါင်းကုန်ပစ္စည်း'), _defineProperty(_Receipt$Pos_Settings, "TotalQuantity", 'စုစုပေါင်းအရေအတွက်'), _defineProperty(_Receipt$Pos_Settings, "TopCustomers", 'ထိပ်ဆုံး ဝယ်သူ(၅)ဦး'), _defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Total Amount'), _defineProperty(_Receipt$Pos_Settings, "TotalPaid", 'Total Paid'), _defineProperty(_Receipt$Pos_Settings, "CustomerSalesReport", 'Customer Sales Report'), _defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Customer Payments Report'), _defineProperty(_Receipt$Pos_Settings, "CustomerQuotationsReport", 'Customer Quotations Report'), _defineProperty(_Receipt$Pos_Settings, "Payments", 'Payments'), _defineProperty(_Receipt$Pos_Settings, "TopSuppliers", 'Top 5 Suppliers'), _defineProperty(_Receipt$Pos_Settings, "SupplierPurchasesReport", 'Supplier Purchases Report'), _defineProperty(_Receipt$Pos_Settings, "SupplierPaiementsReport", 'Supplier Payments Report'), _defineProperty(_Receipt$Pos_Settings, "Name", 'အမည်'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), _defineProperty(_Receipt$Pos_Settings, "ManagementWarehouse", 'Warehouse Management'), _defineProperty(_Receipt$Pos_Settings, "ZipCode", 'Zip Code'), _defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Categories management'), _defineProperty(_Receipt$Pos_Settings, "Codecategorie", 'Category Code'), _defineProperty(_Receipt$Pos_Settings, "Namecategorie", 'Category Name'), _defineProperty(_Receipt$Pos_Settings, "Parentcategorie", 'Parent category'), _defineProperty(_Receipt$Pos_Settings, "managementTax", 'Tax management'), _defineProperty(_Receipt$Pos_Settings, "TaxName", 'Tax Name'), _defineProperty(_Receipt$Pos_Settings, "TaxRate", 'Tax Rate'), _defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Purchases Unit'), _defineProperty(_Receipt$Pos_Settings, "managementUnitSales", 'Sales Unit'), _defineProperty(_Receipt$Pos_Settings, "ShortName", 'Short Name'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Please Select These before adding any product'), _defineProperty(_Receipt$Pos_Settings, "StockAdjustement", 'Adjustment'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectWarehouse", 'Please Select warehouse before choose any product'), _defineProperty(_Receipt$Pos_Settings, "StockTransfer", 'Stock Transfer'), _defineProperty(_Receipt$Pos_Settings, "SelectPeriod", 'Select Period'), _defineProperty(_Receipt$Pos_Settings, "ThisYear", 'This Year'), _defineProperty(_Receipt$Pos_Settings, "ThisToday", 'This Today'), _defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'This Month'), _defineProperty(_Receipt$Pos_Settings, "ThisWeek", 'This Week'), _defineProperty(_Receipt$Pos_Settings, "AdjustmentDetail", 'Adjustment Detail'), _defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'This User Has been Activated'), _defineProperty(_Receipt$Pos_Settings, "DisActivateUser", 'This User Has been Deactivated'), _defineProperty(_Receipt$Pos_Settings, "NotFound", 'Page not found.'), _defineProperty(_Receipt$Pos_Settings, "oops", 'Oops! Page not found.'), _defineProperty(_Receipt$Pos_Settings, "couldNotFind", 'We could not find the page you were looking for.Meanwhile, you may'), _defineProperty(_Receipt$Pos_Settings, "ReturnDashboard", 'Return to dashboard'), _defineProperty(_Receipt$Pos_Settings, "hrm", 'ဝန်ထမ်းစီမံခန့်ခွဲခြင်း'), _defineProperty(_Receipt$Pos_Settings, "Employees", 'ဝန်ထမ်းများ'), _defineProperty(_Receipt$Pos_Settings, "Attendance", 'ရုံးတက်/ရုံးဆင်း'), _defineProperty(_Receipt$Pos_Settings, "Leave_request", 'Leave Request'), _defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Leave Type'), _defineProperty(_Receipt$Pos_Settings, "Company", 'Company'), _defineProperty(_Receipt$Pos_Settings, "Departments", 'Departments'), _defineProperty(_Receipt$Pos_Settings, "Designations", 'ရာထူး'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Office Shift'), _defineProperty(_Receipt$Pos_Settings, "Holidays", 'Holidays'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Name", 'Enter company name'), _defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Enter email address'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Phone", 'Enter company phone'), _defineProperty(_Receipt$Pos_Settings, "Enter_Company_Country", 'Enter company country'), _defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Created in successfully'), _defineProperty(_Receipt$Pos_Settings, "Updated_in_successfully", 'Updated in successfully'), _defineProperty(_Receipt$Pos_Settings, "Deleted_in_successfully", 'Deleted in successfully'), _defineProperty(_Receipt$Pos_Settings, "department", 'Department'), _defineProperty(_Receipt$Pos_Settings, "Enter_Department_Name", 'Enter department name'), _defineProperty(_Receipt$Pos_Settings, "Choose_Company", 'Choose Company'), _defineProperty(_Receipt$Pos_Settings, "Department_Head", 'Department Head'), _defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Choose Department Head'), _defineProperty(_Receipt$Pos_Settings, "Enter_Shift_name", 'Enter Shift name'), _defineProperty(_Receipt$Pos_Settings, "Monday_In", 'တနင်္လာနေ့ ရုံးတက်ချိန်'), _defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'တနင်္လာနေ့ ရုံးဆင်းချိန်'), _defineProperty(_Receipt$Pos_Settings, "Tuesday_In", 'အင်္ဂါနေ့ ရုံးတက်ချိန်'), _defineProperty(_Receipt$Pos_Settings, "tuesday_out", 'အင်္ဂါနေ့ ရုံးဆင်းချိန်'), _defineProperty(_Receipt$Pos_Settings, "wednesday_in", 'ဗုဒ္ဓဟူးနေ့ ရုံးတက်ချိန်'), _defineProperty(_Receipt$Pos_Settings, "wednesday_out", 'ဗုဒ္ဓဟူးနေ့ ရုံးဆင်းချိန်'), _defineProperty(_Receipt$Pos_Settings, "thursday_in", 'ကြာသပတေးနေ့ ရုံးတက်ချိန်'), _defineProperty(_Receipt$Pos_Settings, "thursday_out", 'ကြာသပတေးနေ့ ရုံးဆင်းချိန်'), _defineProperty(_Receipt$Pos_Settings, "friday_in", 'သောကြာနေ့ ရုံးတက်ချိန်'), _defineProperty(_Receipt$Pos_Settings, "friday_out", 'သောကြာနေ့ ရုံးဆင်းချိန်'), _defineProperty(_Receipt$Pos_Settings, "saturday_in", 'စနေနေ့ ရုံးတက်ချိန်'), _defineProperty(_Receipt$Pos_Settings, "saturday_out", 'စနေနေ့ ရုံးဆင်းချိန်'), _defineProperty(_Receipt$Pos_Settings, "sunday_in", 'တနင်္ဂနွေနေ့ ရုံးတက်ချိန်'), _defineProperty(_Receipt$Pos_Settings, "sunday_out", 'တနင်္ဂနွေနေ့ ရုံးဆင်းချိန်'), _defineProperty(_Receipt$Pos_Settings, "Holiday", 'အားလပ်ရက်'), _defineProperty(_Receipt$Pos_Settings, "Enter_title", 'Enter title'), _defineProperty(_Receipt$Pos_Settings, "title", 'title'), _defineProperty(_Receipt$Pos_Settings, "start_date", 'Start date'), _defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Enter start date'), _defineProperty(_Receipt$Pos_Settings, "Finish_Date", 'Finish date'), _defineProperty(_Receipt$Pos_Settings, "Enter_Finish_date", 'Enter finish date'), _defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Please provide any details'), _defineProperty(_Receipt$Pos_Settings, "Attendances", 'Attendances'), _defineProperty(_Receipt$Pos_Settings, "Enter_Attendance_date", 'Enter attendance date'), _defineProperty(_Receipt$Pos_Settings, "Time_In", 'Time In'), _defineProperty(_Receipt$Pos_Settings, "Time_Out", 'Time Out'), _defineProperty(_Receipt$Pos_Settings, "Choose_Employee", 'ဝန်ထမ်းရွေးချယ်ပါ'), _defineProperty(_Receipt$Pos_Settings, "Employee", 'ဝန်ထမ်း'), _defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Work Duration'), _defineProperty(_Receipt$Pos_Settings, "remaining_leaves_are_insufficient", 'Remaining leaves are insufficient'), _defineProperty(_Receipt$Pos_Settings, "Leave_Type", 'Leave Type'), _defineProperty(_Receipt$Pos_Settings, "Days", 'Days'), _defineProperty(_Receipt$Pos_Settings, "Department", 'Department'), _defineProperty(_Receipt$Pos_Settings, "Choose_leave_type", 'Choose leave type'), _defineProperty(_Receipt$Pos_Settings, "Choose_status", 'Choose status'), _defineProperty(_Receipt$Pos_Settings, "Leave_Reason", 'Leave Reason'), _defineProperty(_Receipt$Pos_Settings, "Enter_Reason_Leave", 'Enter Reason Leave'), _defineProperty(_Receipt$Pos_Settings, "Add_Employee", 'Add Employee'), _defineProperty(_Receipt$Pos_Settings, "FirstName", 'First Name'), _defineProperty(_Receipt$Pos_Settings, "Enter_FirstName", 'Enter First Name'), _defineProperty(_Receipt$Pos_Settings, "LastName", 'Last Name'), _defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Enter Last Name'), _defineProperty(_Receipt$Pos_Settings, "Gender", 'Gender'), _defineProperty(_Receipt$Pos_Settings, "Choose_Gender", 'Choose Gender'), _defineProperty(_Receipt$Pos_Settings, "Enter_Birth_date", 'Enter birth date'), _defineProperty(_Receipt$Pos_Settings, "Birth_date", 'Birth date'), _defineProperty(_Receipt$Pos_Settings, "Enter_Country", 'Enter Country'), _defineProperty(_Receipt$Pos_Settings, "Enter_Phone_Number", 'Enter Phone Number'), _defineProperty(_Receipt$Pos_Settings, "joining_date", 'Joining date'), _defineProperty(_Receipt$Pos_Settings, "Enter_joining_date", 'Enter joining date'), _defineProperty(_Receipt$Pos_Settings, "Choose_Designation", 'ရာထူးရွေးချယ်ခြင်း'), _defineProperty(_Receipt$Pos_Settings, "Designation", 'ရာထူး'), _defineProperty(_Receipt$Pos_Settings, "Office_Shift", 'Office Shift'), _defineProperty(_Receipt$Pos_Settings, "Choose_Office_Shift", 'Choose Office Shift'), _defineProperty(_Receipt$Pos_Settings, "Enter_Leaving_Date", 'Enter Leaving Date'), _defineProperty(_Receipt$Pos_Settings, "Leaving_Date", 'Leaving Date'), _defineProperty(_Receipt$Pos_Settings, "Annual_Leave", 'Annual Leave'), _defineProperty(_Receipt$Pos_Settings, "Enter_Annual_Leave", 'Enter Annual Leave'), _defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Remaining leave'), _defineProperty(_Receipt$Pos_Settings, "Employee_Details", 'Employee Details'), _defineProperty(_Receipt$Pos_Settings, "Basic_Information", 'Basic Information'), _defineProperty(_Receipt$Pos_Settings, "Family_status", 'Family Status'), _defineProperty(_Receipt$Pos_Settings, "Choose_Family_status", 'Choose Family status'), _defineProperty(_Receipt$Pos_Settings, "Employment_type", 'Employment type'), _defineProperty(_Receipt$Pos_Settings, "Select_Employment_type", 'Select Employment type'), _defineProperty(_Receipt$Pos_Settings, "Enter_City", 'Enter City'), _defineProperty(_Receipt$Pos_Settings, "Province", 'Province'), _defineProperty(_Receipt$Pos_Settings, "Enter_Province", 'Enter Province'), _defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Enter Address'), _defineProperty(_Receipt$Pos_Settings, "Enter_Zip_code", 'Enter Zip code'), _defineProperty(_Receipt$Pos_Settings, "Zip_code", 'Zip code'), _defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Hourly rate'), _defineProperty(_Receipt$Pos_Settings, "Enter_Hourly_rate", 'Enter Hourly rate'), _defineProperty(_Receipt$Pos_Settings, "Basic_salary", 'Basic salary'), _defineProperty(_Receipt$Pos_Settings, "Enter_Basic_salary", 'Enter Basic salary'), _defineProperty(_Receipt$Pos_Settings, "Social_Media", 'Social Media'), _defineProperty(_Receipt$Pos_Settings, "Skype", 'Skype'), _defineProperty(_Receipt$Pos_Settings, "Enter_Skype", 'Enter Skype'), _defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), _defineProperty(_Receipt$Pos_Settings, "Enter_Facebook", 'Enter Facebook'), _defineProperty(_Receipt$Pos_Settings, "WhatsApp", 'WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Enter WhatsApp'), _defineProperty(_Receipt$Pos_Settings, "LinkedIn", 'LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Enter_LinkedIn", 'Enter LinkedIn'), _defineProperty(_Receipt$Pos_Settings, "Twitter", 'Twitter'), _defineProperty(_Receipt$Pos_Settings, "Enter_Twitter", 'Enter Twitter'), _defineProperty(_Receipt$Pos_Settings, "Experiences", 'Experiences'), _defineProperty(_Receipt$Pos_Settings, "bank_account", 'bank account'), _defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Company အမည်'), _defineProperty(_Receipt$Pos_Settings, "Location", 'Location'), _defineProperty(_Receipt$Pos_Settings, "Enter_location", 'Enter location'), _defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Enter Description'), _defineProperty(_Receipt$Pos_Settings, "Bank_Name", 'Bank Name'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Name", 'Enter Bank Name'), _defineProperty(_Receipt$Pos_Settings, "Bank_Branch", 'Bank Branch'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Branch", 'Enter Bank Branch'), _defineProperty(_Receipt$Pos_Settings, "Bank_Number", 'Bank Number'), _defineProperty(_Receipt$Pos_Settings, "Enter_Bank_Number", 'Enter Bank Number'), _defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Access warehouses'), _defineProperty(_Receipt$Pos_Settings, "Top_customers", 'Best customers'), _defineProperty(_Receipt$Pos_Settings, "Attachment", 'Attachment'), _defineProperty(_Receipt$Pos_Settings, "view_employee", 'view employee'), _defineProperty(_Receipt$Pos_Settings, "edit_employee", 'Edit employee'), _defineProperty(_Receipt$Pos_Settings, "delete_employee", 'Delete employee'), _defineProperty(_Receipt$Pos_Settings, "Created_by", 'Added by'), _defineProperty(_Receipt$Pos_Settings, "Add_product_IMEI_Serial_number", 'Add product IMEI/Serial Number'), _defineProperty(_Receipt$Pos_Settings, "Product_Has_Imei_Serial_number", ' Imei/Serial Number ပါဝင်သောပစ္စည်း'), _defineProperty(_Receipt$Pos_Settings, "IMEI_SN", 'IMEI/SN'), _defineProperty(_Receipt$Pos_Settings, "Shipments", 'Shipments'), _defineProperty(_Receipt$Pos_Settings, "delivered_to", 'Delivered To'), _defineProperty(_Receipt$Pos_Settings, "shipment_ref", 'Shipment Ref'), _defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Sale Ref'), _defineProperty(_Receipt$Pos_Settings, "Edit_Shipping", 'Edit Shipping'), _defineProperty(_Receipt$Pos_Settings, "Packed", 'Packed'), _defineProperty(_Receipt$Pos_Settings, "Shipped", 'Shipped'), _defineProperty(_Receipt$Pos_Settings, "Delivered", 'Delivered'), _defineProperty(_Receipt$Pos_Settings, "Cancelled", 'Cancelled'), _defineProperty(_Receipt$Pos_Settings, "Shipping_status", 'Shipping Status'), _defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Users Report'), _defineProperty(_Receipt$Pos_Settings, "stock_report", 'ကုန်လက်ကျန်စာရင်း'), _defineProperty(_Receipt$Pos_Settings, "TotalPurchases", 'Total Purchases'), _defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Total Quotations'), _defineProperty(_Receipt$Pos_Settings, "Total_return_sales", 'Total return sales'), _defineProperty(_Receipt$Pos_Settings, "Total_return_purchases", 'Total return purchases'), _defineProperty(_Receipt$Pos_Settings, "Total_transfers", 'Total transfers'), _defineProperty(_Receipt$Pos_Settings, "Total_adjustments", 'Total adjustments'), _defineProperty(_Receipt$Pos_Settings, "User_report", 'User Report'), _defineProperty(_Receipt$Pos_Settings, "Current_stock", 'Current Stock'), _defineProperty(_Receipt$Pos_Settings, "product_name", 'Product Name'), _defineProperty(_Receipt$Pos_Settings, "Total_Customers_Due", 'Total Debt'), _defineProperty(_Receipt$Pos_Settings, "Total_Suppliers_Due", 'Total Debt'), _defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Some Warehouses'), _defineProperty(_Receipt$Pos_Settings, "All_Warehouses", 'ဂိုထောင်အားလုံး'), _defineProperty(_Receipt$Pos_Settings, "Product_Cost", 'Product Cost'), _defineProperty(_Receipt$Pos_Settings, "sms_settings", 'Sms Settings'), _defineProperty(_Receipt$Pos_Settings, "pos_settings", 'POS Settings'), _defineProperty(_Receipt$Pos_Settings, "payment_gateway", 'Payment Gateway'), _defineProperty(_Receipt$Pos_Settings, "mail_settings", 'Mail Settings'), _defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), _defineProperty(_Receipt$Pos_Settings, "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_Receipt$Pos_Settings, "Default_SMS_Gateway", 'Default SMS Gateway'), _defineProperty(_Receipt$Pos_Settings, "module_settings", 'Module Settings'), _defineProperty(_Receipt$Pos_Settings, "Module_enabled_success", 'Module enabled successfully'), _defineProperty(_Receipt$Pos_Settings, "Module_Disabled_success", 'Module Disabled successfully'), _defineProperty(_Receipt$Pos_Settings, "update_settings", 'Upgrade'), _defineProperty(_Receipt$Pos_Settings, "Please_Upload_the_Correct_Module", 'Please Upload the Correct Module'), _defineProperty(_Receipt$Pos_Settings, "Uploaded_Success", 'Uploaded in successfully'), _defineProperty(_Receipt$Pos_Settings, "Customer_details", 'ဝယ်သူအကြောင်းအရာအ'), _defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Edit Customer'), _defineProperty(_Receipt$Pos_Settings, "Delete_Customer", 'Delete Customer'), _defineProperty(_Receipt$Pos_Settings, "Pay_Due", 'Pay Due'), _defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'Paying amount is greater than Total Due'), _defineProperty(_Receipt$Pos_Settings, "Customer_Invoice", 'Customer Invoice'), _defineProperty(_Receipt$Pos_Settings, "This_Product_Not_For_Selling", 'ရောင်းရန်မဟုတ်သည့်ကုန်ပစ္စည်း'), _defineProperty(_Receipt$Pos_Settings, "Welcome_to_your_Dashboard", 'Welcome to your Dashboard'), _defineProperty(_Receipt$Pos_Settings, "Total_Payable", 'Total Payable'), _defineProperty(_Receipt$Pos_Settings, "Choose_Sale_Ref", 'Choose Sale Ref'), _defineProperty(_Receipt$Pos_Settings, "Please_Select_Sale", 'Please Select Sale'), _defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Sale Ref'), _defineProperty(_Receipt$Pos_Settings, "list_product_returns", 'list product returns'), _defineProperty(_Receipt$Pos_Settings, "Qty_return", 'Qty return'), _defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Choose Purchase Ref'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Ref", 'Purchase Ref'), _defineProperty(_Receipt$Pos_Settings, "please_select_purchase", 'Please Select Purchase'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_purchased", 'Qty return is greater than Qty purchased'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_qty_sold", 'Qty return is greater than Qty sold'), _defineProperty(_Receipt$Pos_Settings, "Quantity_sold", 'Qty sold'), _defineProperty(_Receipt$Pos_Settings, "qty_purchased", 'Qty purchased'), _defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Sender Name'), _defineProperty(_Receipt$Pos_Settings, "The_module_must_be_uploaded_as_zip_file", 'The module must be uploaded as zip file'), _defineProperty(_Receipt$Pos_Settings, "Upload_Module", 'Upload Module'), _defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'All Modules Installed'), _defineProperty(_Receipt$Pos_Settings, "Current_Version", 'Current Version'), _defineProperty(_Receipt$Pos_Settings, "You_already_have_the_latest_version", 'You already have the latest version'), _defineProperty(_Receipt$Pos_Settings, "Update_Available", 'Update Available'), _defineProperty(_Receipt$Pos_Settings, "Update_Log", 'Update Log'), _defineProperty(_Receipt$Pos_Settings, "Update_Now", 'Update Now'), _defineProperty(_Receipt$Pos_Settings, "View_Change_Log", 'View Change Log'), _defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'NOTE:  Please Wait for the update to finish completely. It is not recommended to close the browser or stop a process Upgrade'), _defineProperty(_Receipt$Pos_Settings, "Note_update", 'Note : Make sure you backup your Current version & database before you run the Upgrade , To restore it if there is an error'), _defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Invoice footer'), _defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Time Zone'), _defineProperty(_Receipt$Pos_Settings, "Payment_note", 'Payment notes'), _defineProperty(_Receipt$Pos_Settings, "sale_note", 'Sale notes'), _defineProperty(_Receipt$Pos_Settings, "Total_Sale_Due", 'Total Sale Due'), _defineProperty(_Receipt$Pos_Settings, "Total_Sell_Return_Due", 'Total Sell Return Due'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_due_at_a_time", 'အကြွေးပေးချေမည်'), _defineProperty(_Receipt$Pos_Settings, "pay_all_sell_return_due_at_a_time", 'Sale Return အကြွေးပေးချေမည်'), _defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Gross Profit'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_due_at_a_time", 'pay all purchase due at a time'), _defineProperty(_Receipt$Pos_Settings, "Delete_Provider", 'Delete Provider'), _defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Edit Provider'), _defineProperty(_Receipt$Pos_Settings, "Provider_details", 'Provider details'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Due", 'Total Purchase Due'), _defineProperty(_Receipt$Pos_Settings, "Provider_Credit_Note", 'Provider Credit Note'), _defineProperty(_Receipt$Pos_Settings, "Customer_Credit_Note", 'Customer Credit Note'), _defineProperty(_Receipt$Pos_Settings, "Sell_Return", 'Sell Return'), _defineProperty(_Receipt$Pos_Settings, "Purchase_Return", 'Purchase Return'), _defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Tax Number'), _defineProperty(_Receipt$Pos_Settings, "Please_add_return_quantity", 'Please add return quantity'), _defineProperty(_Receipt$Pos_Settings, "Return_exist_for_the_Transaction", 'Return exist for the Transaction'), _defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'Qty return is greater than Quantity Remaining'), _defineProperty(_Receipt$Pos_Settings, "products_refunded_alert", 'Any products with a quantity set to 0 won\'t be refunded'), _defineProperty(_Receipt$Pos_Settings, "pay_all_purchase_return_due_at_a_time", 'pay all purchase return due at a time'), _defineProperty(_Receipt$Pos_Settings, "Total_Purchase_Return_Due", 'Total Purchase Return Due'), _defineProperty(_Receipt$Pos_Settings, "Purchase_return_due", 'Purchase return due'), _defineProperty(_Receipt$Pos_Settings, "Sell_return_due", 'Sell return due'), _defineProperty(_Receipt$Pos_Settings, "product_report", 'ကုန်ပစ္စည်းစာရင်း'), _defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'ကုန်ရောင်းအစီရင်ခံစာ'), _defineProperty(_Receipt$Pos_Settings, "Product_purchases_report", 'ကုန်ဝယ်အစီရင်ခံစာ'), _defineProperty(_Receipt$Pos_Settings, "Qty_sold", 'ရောင်းချပြီးအရေအတွက်'), _defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'ဝယ်ယူပြီးအရေအတွက်'), _defineProperty(_Receipt$Pos_Settings, "Filter_by_warehouse", 'Filter by warehouse'), _defineProperty(_Receipt$Pos_Settings, "Enable_Print_Invoice", 'Print Invoice automatically'), _defineProperty(_Receipt$Pos_Settings, "Show_Warehouse", 'Show warehouse'), _defineProperty(_Receipt$Pos_Settings, "credit_card_info", 'Credit card info'), _defineProperty(_Receipt$Pos_Settings, "Saved_Credit_Card_Info", 'Saved Credit Card Info'), _defineProperty(_Receipt$Pos_Settings, "Credit_card_changed_successfully", 'Credit card changed successfully'), _defineProperty(_Receipt$Pos_Settings, "notification_template", 'Notification Template'), _defineProperty(_Receipt$Pos_Settings, "email_notification", 'Email notification'), _defineProperty(_Receipt$Pos_Settings, "sms_notification", 'SMS notification'), _defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Change product details'), _defineProperty(_Receipt$Pos_Settings, "edit_tax_and_discount_and_shipping", 'edit tax and discount and shipping'), _defineProperty(_Receipt$Pos_Settings, "Create_Quotation_with_Stock", 'Create Quotation with Stock'), _defineProperty(_Receipt$Pos_Settings, "Variant_Name", 'Variant Name'), _defineProperty(_Receipt$Pos_Settings, "Variant_cost", 'Variant cost'), _defineProperty(_Receipt$Pos_Settings, "Variant_price", 'Variant price'), _defineProperty(_Receipt$Pos_Settings, "Variant_code", 'Variant code'), _defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Please wait until the product is loaded'), _defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Choose SMS Gateway'), _defineProperty(_Receipt$Pos_Settings, "Notification_Client", 'Notification Client'), _defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Available Tags'), _defineProperty(_Receipt$Pos_Settings, "Email_Subject", 'Email Subject'), _defineProperty(_Receipt$Pos_Settings, "Email_body", 'Email body'), _defineProperty(_Receipt$Pos_Settings, "Notification_Supplier", 'Notification Supplier'), _defineProperty(_Receipt$Pos_Settings, "sms_body", 'SMS body'), _defineProperty(_Receipt$Pos_Settings, "sms_templates", 'SMS Templates'), _defineProperty(_Receipt$Pos_Settings, "email_templates", 'Email Templates'), _Receipt$Pos_Settings);

/***/ }),

/***/ "./resources/src/translations/locales/ru.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/ru.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Russian

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Чек',
  Pos_Settings: 'Настройки точки продаж',
  Note_to_customer: 'Примечание для покупателя',
  Show_Note_to_customer: 'Показать заметку покупателю',
  Show_barcode: 'Показать штрих-код',
  Show_Tax_and_Discount: 'Показать налог, скидки и доставка',
  Show_Customer: 'Показать клиента',
  Show_Email: 'Показать электронную почту',
  Show_Phone: 'Показать телефон',
  Show_Address: 'Показать адрес',
  DefaultLanguage: 'Язык по умолчанию',
  footer: 'нижний колонтитул',
  Received_Amount: 'Полученная сумма',
  Paying_Amount: 'Сумма платежа',
  Change: 'Изменять',
  Paying_amount_is_greater_than_Received_amount: 'Сумма платежа больше полученной суммы',
  Paying_amount_is_greater_than_Grand_Total: 'Сумма платежа превышает общую сумму',
  code_must_be_not_exist_already: 'код уже не должен существовать',
  You_will_find_your_backup_on: 'Вы найдете резервную копию на',
  and_save_it_to_your_pc: 'и сохраните на свой компьютер',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Отсканируйте свой штрих-код и выберите правильную символику ниже',
  Scan_Search_Product_by_Code_Name: 'Сканирование / поиск продукта по кодовому названию',
  Paper_size: 'Размер бумаги',
  Clear_Cache: 'Очистить кэш',
  Cache_cleared_successfully: 'Кеш успешно очищен',
  Failed_to_clear_cache: 'Не удалось очистить кеш',
  Scan_Barcode: 'Сканер штрих-кода',
  Please_use_short_name_of_unit: 'Пожалуйста, используйте короткое название единицы',
  DefaultCustomer: 'Клиент по умолчанию',
  DefaultWarehouse: 'Склад по умолчанию',
  Payment_Gateway: 'Платежный шлюз',
  SMS_Configuration: 'Конфигурация SMS',
  Gateway: 'Платежный шлюз',
  Choose_Gateway: 'Выберите платежный шлюз',
  Send_SMS: 'Сообщение успешно отправлено',
  sms_config_invalid: 'неверная конфигурация смс недействительна',
  Remove_Stripe_Key_Secret: 'Удалить ключи API Stripe',
  credit_card_account_not_available: 'Счет кредитной карты недоступен',
  Credit_Card_Info: 'Информация о кредитной карте',
  developed_by: 'Разработан',
  Unit_already_linked_with_sub_unit: 'Объект уже связан с дополнительным блоком',
  Total_Items_Quantity: 'Итого и количество',
  Value_by_Cost_and_Price: 'Соотношение затрат и цен',
  Search_this_table: 'Искать в этой таблице',
  import_products: 'Импортные товары',
  Field_optional: 'Поле необязательно',
  Download_exemple: 'Скачать пример',
  field_must_be_in_csv_format: 'Поле должно быть в формате csv.',
  Successfully_Imported: 'Успешно импортировано',
  file_size_must_be_less_than_1_mega: 'Размер файла не должен превышать 1 мегабайт.',
  Please_follow_the_import_instructions: 'Следуйте инструкциям по импорту',
  must_be_exist: 'юнит уже должен быть создан',
  Import_Customers: 'Импортные клиенты',
  Import_Suppliers: 'Поставщики импорта',
  Recent_Sales: 'Последние продажи',
  Create_Transfer: 'Создать перевод',
  order_products: 'элементы заказа',
  Search_Product_by_Code_Name: 'Поиск продукта по коду или названию',
  Reports_payments_Purchase_Return: 'Отчеты о возвратных платежах за покупку',
  Reports_payments_Sale_Return: 'Отчеты о продажах и возвратах платежей',
  payments_Sales_Return: 'возврат платежей',
  payments_Purchases_Return: 'платежи покупки возврат',
  CreateSaleReturn: 'Создать возврат продажи',
  EditSaleReturn: 'Изменить возврат продажи',
  SalesReturn: 'Возвращение продаж',
  CreatePurchaseReturn: 'Создать возврат покупки',
  EditPurchaseReturn: 'Изменить возврат покупки',
  PurchasesReturn: 'Покупки Возврат',
  Due: 'должный',
  Profit: 'Выгода',
  Revenue: 'Доход',
  Sales_today: 'Продажи сегодня',
  People: 'Люди',
  Successfully_Created: 'Успешно создано',
  Successfully_Updated: 'Успешно обновлено',
  Success: 'Успех',
  Failed: 'Не удалось',
  Warning: 'Warning',
  Please_fill_the_form_correctly: 'Пожалуйста, заполните форму правильно',
  Field_is_required: 'Поле, обязательное для заполнения',
  Error: 'Ошибка!',
  you_are_not_authorized: 'Извини! вы не авторизованы.',
  Go_back_to_home: 'Вернуться на главную',
  page_not_exist: 'Извини! Страница, которую вы искали, не существует.',
  Choose_Status: 'Выберите статус',
  Choose_Method: 'Выберите метод',
  Choose_Symbology: 'Выберите символы',
  Choose_Category: 'Выберите категорию',
  Choose_Customer: 'Выберите клиента',
  Choose_Supplier: 'Выберите поставщика',
  Choose_Unit_Purchase: 'Выберите покупную единицу',
  Choose_Sub_Category: 'Выберите подкатегорию',
  Choose_Brand: 'Выберите марку',
  Choose_Warehouse: 'Выберите склад',
  Choose_Unit_Sale: 'Выберите единицу продажи',
  Enter_Product_Cost: 'Введите стоимость продукта',
  Enter_Stock_alert: 'Введите оповещение о наличии акций',
  Choose_Unit_Product: 'Выберите единицу продукции',
  Enter_Product_Price: 'Введите цену продукта',
  Enter_Name_Product: 'Введите название продукта',
  Enter_Role_Name: 'Введите имя роли',
  Enter_Role_Description: 'Введите описание роли',
  Enter_name_category: 'Введите название категории',
  Enter_Code_category: 'Введите код категории',
  Enter_Name_Brand: 'Введите название бренда',
  Enter_Description_Brand: 'Введите описание бренда',
  Enter_Code_Currency: 'Введите валюту кода',
  Enter_name_Currency: 'Введите имя Валюта',
  Enter_Symbol_Currency: 'Введите валюту символа',
  Enter_Name_Unit: 'Введите название объекта',
  Enter_ShortName_Unit: 'Введите короткое имя',
  Choose_Base_Unit: 'Выберите базовый блок',
  Choose_Operator: 'Выберите оператора',
  Enter_Operation_Value: 'Введите значение операции',
  Enter_Name_Warehouse: 'Введите название склада',
  Enter_Phone_Warehouse: 'Введите телефон склада',
  Enter_Country_Warehouse: 'Укажите страну склада',
  Enter_City_Warehouse: 'Введите город склада',
  Enter_Email_Warehouse: 'Введите адрес электронной почты склада',
  Enter_ZipCode_Warehouse: 'Введите почтовый индекс склада',
  Choose_Currency: 'Выберите Валюту',
  Thank_you_for_your_business: 'Спасибо за ваш бизнес!',
  Cancel: 'Отмена',
  New_Customer: 'Новый покупатель',
  Incorrect_Login: 'Неправильный логин',
  Successfully_Logged_In: 'Успешный вход в систему',
  This_user_not_active: 'Этот пользователь не активен',
  SignIn: 'Войти',
  Create_an_account: 'Завести аккаунт',
  Forgot_Password: 'Забыл пароль ?',
  Email_Address: 'Адрес электронной почты',
  SignUp: 'Зарегистрироваться',
  Already_have_an_account: 'Уже есть аккаунт?',
  Reset_Password: 'Сброс пароля',
  Failed_to_authenticate_on_SMTP_server: 'Не удалось пройти аутентификацию на SMTP-сервере',
  We_cant_find_a_user_with_that_email_addres: 'Мы не можем найти пользователя с таким адресом электронной почты',
  We_have_emailed_your_password_reset_link: 'Мы отправили вам ссылку для сброса пароля по электронной почте',
  Please_fill_the_Email_Adress: 'Пожалуйста, заполните адрес электронной почты',
  Confirm_password: 'Подтвердить Пароль',
  Your_Password_has_been_changed: 'Ваш пароль был изменен',
  The_password_confirmation_does_not_match: 'Подтверждение пароля не совпадает',
  This_password_reset_token_is_invalid: 'Этот токен сброса пароля недействителен',
  Warehouse_report: 'Отчет о складе',
  All_Warehouses: 'Все склады',
  Expense_List: 'Список расходов',
  Expenses: 'Затраты',
  This_Week_Sales_Purchases: 'Продажи и покупки на этой неделе',
  Top_Selling_Products: 'Самые продаваемые товары',
  View_all: 'Посмотреть все',
  Payment_Sent_Received: 'Платеж отправлен и получен',
  Filter: 'Фильтр',
  Invoice_POS: 'Счет-фактура POS',
  Invoice: 'Выставленный счет',
  Customer_Info: 'Информация о клиенте',
  Company_Info: 'информация о компании',
  Invoice_Info: 'Информация о счете',
  Order_Summary: 'итог заказа',
  Quote_Info: 'Ценовая информация',
  Del: 'удалять',
  SuppliersPaiementsReport: 'Отчет о платежах поставщикам',
  Purchase_Info: 'Информация о покупке',
  Supplier_Info: 'Информация о поставщиках',
  Return_Info: 'информация о возврате',
  Expense_Category: 'Категория расходов',
  Create_Expense: 'Создать расход',
  Details: 'Детали',
  Discount_Method: 'Метод скидки',
  Net_Unit_Cost: 'Чистая стоимость единицы',
  Net_Unit_Price: 'Чистая цена за единицу',
  Edit_Expense: 'Изменить расходы',
  All_Brand: 'Все марки',
  All_Category: 'Все категории',
  ListExpenses: 'Перечислить расходы',
  Create_Permission: 'Создать разрешение',
  Edit_Permission: 'Изменить разрешение',
  Reports_payments_Sales: 'Отчеты о платежах Продажи',
  Reports_payments_Purchases: 'Отчеты о платежах Покупки',
  Reports_payments_Return_Customers: 'Отчеты о платежах Возврат клиентов',
  Reports_payments_Return_Suppliers: 'Отчеты о платежах Возврат Поставщикам',
  Expense_Deleted: 'Этот расход был удален',
  Expense_Updated: 'Этот расход был обновлен',
  Expense_Created: 'Этот расход был создан',
  DemoVersion: 'Вы не можете этого сделать в демо-версии',
  OrderStatistics: 'Статистика продаж',
  AlreadyAdd: 'Этот продукт уже добавлен!',
  AddProductToList: 'Пожалуйста, добавьте товар в список!',
  AddQuantity: 'Пожалуйста, добавьте количество деталей !!',
  InvalidData: 'Неверные данные !!',
  LowStock: 'количество превышает количество на складе',
  WarehouseIdentical: 'Два склада не могут быть идентичными !!',
  VariantDuplicate: 'Этот вариант дублируется !!',
  Filesize: 'Размер файла',
  GenerateBackup: 'Создать резервную копию',
  BackupDatabase: 'Резервная база данных',
  Backup: 'резервное копирование',
  Paid: 'Платный',
  Unpaid: 'Неоплаченный',
  Today: 'Cегодня',
  Income: 'Доход'
}, _defineProperty(_Receipt$Pos_Settings, "Expenses", 'Затраты'), _defineProperty(_Receipt$Pos_Settings, "Sale", 'распродажа'), _defineProperty(_Receipt$Pos_Settings, "Actif", 'Активный'), _defineProperty(_Receipt$Pos_Settings, "Inactif", 'Неактивный'), _defineProperty(_Receipt$Pos_Settings, "Customers", 'Клиенты'), _defineProperty(_Receipt$Pos_Settings, "Phone", 'Телефон'), _defineProperty(_Receipt$Pos_Settings, "SearchByPhone", 'Поиск по телефону'), _defineProperty(_Receipt$Pos_Settings, "Suppliers", 'Поставщики'), _defineProperty(_Receipt$Pos_Settings, "Quotations", 'Котировки'), _defineProperty(_Receipt$Pos_Settings, "Sales", 'Продажи'), _defineProperty(_Receipt$Pos_Settings, "Purchases", 'Покупки'), _defineProperty(_Receipt$Pos_Settings, "Returns", 'Возврат'), _defineProperty(_Receipt$Pos_Settings, "Settings", 'Настройки'), _defineProperty(_Receipt$Pos_Settings, "SystemSettings", 'Системные настройки'), _defineProperty(_Receipt$Pos_Settings, "Users", 'Пользователи'), _defineProperty(_Receipt$Pos_Settings, "GroupPermissions", 'Групповые разрешения'), _defineProperty(_Receipt$Pos_Settings, "Currencies", 'Валюты'), _defineProperty(_Receipt$Pos_Settings, "Warehouses", 'Склады'), _defineProperty(_Receipt$Pos_Settings, "Units", 'Единицы'), _defineProperty(_Receipt$Pos_Settings, "UnitsPrchases", 'Покупка единиц'), _defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Единицы продаж'), _defineProperty(_Receipt$Pos_Settings, "Reports", 'Отчеты'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Отчет о платежах'), _defineProperty(_Receipt$Pos_Settings, "PaymentsPurchases", 'Платежи Покупки'), _defineProperty(_Receipt$Pos_Settings, "PaymentsSales", 'Платежи Продажи'), _defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Прибыль и убыток'), _defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'График складских запасов'), _defineProperty(_Receipt$Pos_Settings, "SalesReport", 'Отчет о продажах'), _defineProperty(_Receipt$Pos_Settings, "PurchasesReport", 'Отчет о закупках'), _defineProperty(_Receipt$Pos_Settings, "CustomersReport", 'Отчет клиентов'), _defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Отчет о поставщиках'), _defineProperty(_Receipt$Pos_Settings, "SupplierReport", 'Отчет поставщика'), _defineProperty(_Receipt$Pos_Settings, "DailySalesData", 'Ежедневные данные о продажах'), _defineProperty(_Receipt$Pos_Settings, "DailyPurchasesData", 'Данные о ежедневных покупках'), _defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Последние пять рекордов'), _defineProperty(_Receipt$Pos_Settings, "Filters", 'Фильтры'), _defineProperty(_Receipt$Pos_Settings, "date", 'Дата'), _defineProperty(_Receipt$Pos_Settings, "Reference", 'Справка'), _defineProperty(_Receipt$Pos_Settings, "Supplier", 'Поставщик'), _defineProperty(_Receipt$Pos_Settings, "PaymentStatus", 'Статус платежа'), _defineProperty(_Receipt$Pos_Settings, "Customer", 'Покупатель'), _defineProperty(_Receipt$Pos_Settings, "CustomerCode", 'Код клиента'), _defineProperty(_Receipt$Pos_Settings, "Status", 'Положение дел'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Код поставщиком'), _defineProperty(_Receipt$Pos_Settings, "Categorie", 'Категория'), _defineProperty(_Receipt$Pos_Settings, "Categories", 'Категории'), _defineProperty(_Receipt$Pos_Settings, "StockTransfers", 'Передача запасов'), _defineProperty(_Receipt$Pos_Settings, "StockManagement", 'Управление запасами'), _defineProperty(_Receipt$Pos_Settings, "dashboard", 'Щиток приборов'), _defineProperty(_Receipt$Pos_Settings, "Products", 'Товары'), _defineProperty(_Receipt$Pos_Settings, "productsList", 'Список продуктов'), _defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Управление продуктом'), _defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Оповещения о количестве товаров'), _defineProperty(_Receipt$Pos_Settings, "CodeProduct", 'Код продукта'), _defineProperty(_Receipt$Pos_Settings, "ProductTax", 'Налог на продукцию'), _defineProperty(_Receipt$Pos_Settings, "SubCategorie", 'Подкатегория'), _defineProperty(_Receipt$Pos_Settings, "Name_product", 'Обозначение'), _defineProperty(_Receipt$Pos_Settings, "StockAlert", 'Уведомление о наличии запасов'), _defineProperty(_Receipt$Pos_Settings, "warehouse", 'склад'), _defineProperty(_Receipt$Pos_Settings, "Tax", 'Налог'), _defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Цена покупки'), _defineProperty(_Receipt$Pos_Settings, "SellPrice", 'Цена продажи'), _defineProperty(_Receipt$Pos_Settings, "Quantity", 'Количество'), _defineProperty(_Receipt$Pos_Settings, "UnitSale", 'Продажа единиц'), _defineProperty(_Receipt$Pos_Settings, "UnitPurchase", 'Покупка единицы'), _defineProperty(_Receipt$Pos_Settings, "ManagementCurrencies", 'Валютный менеджмент'), _defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Код валюты'), _defineProperty(_Receipt$Pos_Settings, "CurrencyName", 'Название валюты'), _defineProperty(_Receipt$Pos_Settings, "Symbol", 'Символ'), _defineProperty(_Receipt$Pos_Settings, "All", 'Все'), _defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Редактировать продукт'), _defineProperty(_Receipt$Pos_Settings, "SearchByCode", 'Поиск по коду'), _defineProperty(_Receipt$Pos_Settings, "SearchByName", 'Поиск по имени'), _defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'информация о продукте'), _defineProperty(_Receipt$Pos_Settings, "CustomerName", 'Имя Клиента'), _defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Управление клиентами'), _defineProperty(_Receipt$Pos_Settings, "Add", 'Создайте'), _defineProperty(_Receipt$Pos_Settings, "add", 'Создайте'), _defineProperty(_Receipt$Pos_Settings, "Edit", 'редактировать'), _defineProperty(_Receipt$Pos_Settings, "Close", 'близко'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Пожалуйста выберите'), _defineProperty(_Receipt$Pos_Settings, "Action", 'Действие'), _defineProperty(_Receipt$Pos_Settings, "Email", 'Электронное письмо'), _defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Изменить клиента'), _defineProperty(_Receipt$Pos_Settings, "AddCustomer", 'Создать клиента'), _defineProperty(_Receipt$Pos_Settings, "Country", 'Страна'), _defineProperty(_Receipt$Pos_Settings, "City", 'город'), _defineProperty(_Receipt$Pos_Settings, "Adress", 'Адрес'), _defineProperty(_Receipt$Pos_Settings, "CustomerDetails", 'Детали клиента'), _defineProperty(_Receipt$Pos_Settings, "CustomersList", 'Список клиентов'), _defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Код поставщиком'), _defineProperty(_Receipt$Pos_Settings, "SupplierName", 'наименование поставщика'), _defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", 'Управление поставщиками'), _defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Детали поставщика'), _defineProperty(_Receipt$Pos_Settings, "QuotationsManagement", 'Управление котировками'), _defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Промежуточный итог'), _defineProperty(_Receipt$Pos_Settings, "MontantReste", 'Осталась сумма'), _defineProperty(_Receipt$Pos_Settings, "complete", 'завершено'), _defineProperty(_Receipt$Pos_Settings, "EnAttendant", 'в ожидании'), _defineProperty(_Receipt$Pos_Settings, "Recu", 'Получила'), _defineProperty(_Receipt$Pos_Settings, "partial", 'Частичное'), _defineProperty(_Receipt$Pos_Settings, "Retournee", 'Возвращение'), _defineProperty(_Receipt$Pos_Settings, "DetailQuote", 'Подробная цитата'), _defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Изменить цитату'), _defineProperty(_Receipt$Pos_Settings, "CreateSale", 'Создать распродажу'), _defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'Скачать Pdf'), _defineProperty(_Receipt$Pos_Settings, "QuoteEmail", 'Предложение отправлено по электронной почте'), _defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Удалить предложение'), _defineProperty(_Receipt$Pos_Settings, "AddQuote", 'Создать предложение'), _defineProperty(_Receipt$Pos_Settings, "SelectProduct", 'Выбрать продукт'), _defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Продукт (Код - Название)'), _defineProperty(_Receipt$Pos_Settings, "Price", 'Цена'), _defineProperty(_Receipt$Pos_Settings, "CurrentStock", 'Склад'), _defineProperty(_Receipt$Pos_Settings, "Total", 'Общее'), _defineProperty(_Receipt$Pos_Settings, "Num", '№'), _defineProperty(_Receipt$Pos_Settings, "Unitcost", 'стоимость единицы'), _defineProperty(_Receipt$Pos_Settings, "to", 'к'), _defineProperty(_Receipt$Pos_Settings, "Subject", 'Предмет'), _defineProperty(_Receipt$Pos_Settings, "Message", 'Сообщение'), _defineProperty(_Receipt$Pos_Settings, "EmailCustomer", 'Электронная почта клиента'), _defineProperty(_Receipt$Pos_Settings, "Sent", 'послать'), _defineProperty(_Receipt$Pos_Settings, "Quote", 'Цитата'), _defineProperty(_Receipt$Pos_Settings, "Hello", 'Здравствуйте'), _defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Пожалуйста, найдите приложение к вашему предложению'), _defineProperty(_Receipt$Pos_Settings, "AddProducts", 'Добавить товары в список заказов'), _defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Пожалуйста, выберите склад'), _defineProperty(_Receipt$Pos_Settings, "SelectCustomer", 'пожалуйста, выберите клиента'), _defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Управление продажами'), _defineProperty(_Receipt$Pos_Settings, "Balance", 'Остаток средств'), _defineProperty(_Receipt$Pos_Settings, "QtyBack", 'Назад Количество'), _defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Общий доход'), _defineProperty(_Receipt$Pos_Settings, "Amount", 'Количество'), _defineProperty(_Receipt$Pos_Settings, "SaleDetail", 'Детали продажи'), _defineProperty(_Receipt$Pos_Settings, "EditSale", 'Изменить распродажу'), _defineProperty(_Receipt$Pos_Settings, "AddSale", 'Создать распродажу'), _defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Показать платежи'), _defineProperty(_Receipt$Pos_Settings, "AddPayment", 'Создать платеж'), _defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Изменить платеж'), _defineProperty(_Receipt$Pos_Settings, "EmailSale", 'Отправить распродажу по электронной почте'), _defineProperty(_Receipt$Pos_Settings, "DeleteSale", 'Удалить распродажу'), _defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Оплачивается'), _defineProperty(_Receipt$Pos_Settings, "Paymentchoice", 'Выбор платежа'), _defineProperty(_Receipt$Pos_Settings, "Note", 'Заметка'), _defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Оплата завершена!'), _defineProperty(_Receipt$Pos_Settings, "PurchasesManagement", 'Управление закупками'), _defineProperty(_Receipt$Pos_Settings, "Ordered", 'Упорядоченный'), _defineProperty(_Receipt$Pos_Settings, "DeletePurchase", 'Удалить покупку'), _defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Отправить покупку по электронной почте'), _defineProperty(_Receipt$Pos_Settings, "EditPurchase", 'Изменить покупку'), _defineProperty(_Receipt$Pos_Settings, "PurchaseDetail", 'Детали покупки'), _defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Создать покупку'), _defineProperty(_Receipt$Pos_Settings, "EmailSupplier", 'Электронная почта поставщика'), _defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", 'Оплата покупок'), _defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Данные о платежах покупок'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoice", 'Платежи за продажу'), _defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Данные о продажах'), _defineProperty(_Receipt$Pos_Settings, "UserManagement", 'управление пользователями'), _defineProperty(_Receipt$Pos_Settings, "Firstname", 'Имя'), _defineProperty(_Receipt$Pos_Settings, "lastname", 'фамилия'), _defineProperty(_Receipt$Pos_Settings, "username", 'Имя пользователя'), _defineProperty(_Receipt$Pos_Settings, "password", 'пароль'), _defineProperty(_Receipt$Pos_Settings, "Newpassword", 'Новый пароль'), _defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", 'Сменить аватар'), _defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Оставьте это поле пустым, если вы его не меняли'), _defineProperty(_Receipt$Pos_Settings, "type", 'тип'), _defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Разрешения пользователей'), _defineProperty(_Receipt$Pos_Settings, "RoleName", 'Роль'), _defineProperty(_Receipt$Pos_Settings, "RoleDescription", 'Описание роли'), _defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Создать разрешения'), _defineProperty(_Receipt$Pos_Settings, "View", 'Посмотреть'), _defineProperty(_Receipt$Pos_Settings, "Del", 'удалять'), _defineProperty(_Receipt$Pos_Settings, "NewAdjustement", 'Новая корректировка'), _defineProperty(_Receipt$Pos_Settings, "EditAdjustement", 'Изменить настройку'), _defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'Вы не можете вычесть продукты, у которых есть запас 0'), _defineProperty(_Receipt$Pos_Settings, "Addition", 'Дополнение'), _defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Вычитание'), _defineProperty(_Receipt$Pos_Settings, "profil", 'профиль'), _defineProperty(_Receipt$Pos_Settings, "logout", 'выйти'), _defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'вы не можете изменить, потому что эта покупка уже оплачена'), _defineProperty(_Receipt$Pos_Settings, "SaleAlreadyPaid", 'вы не можете изменить, потому что эта Распродажа уже оплачена'), _defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'вы не можете изменить, потому что этот возврат уже оплачен'), _defineProperty(_Receipt$Pos_Settings, "QuoteAlready", 'Эта цитата уже привела к продаже'), _defineProperty(_Receipt$Pos_Settings, "AddProduct", 'Создать продукт'), _defineProperty(_Receipt$Pos_Settings, "QuotationComplete", 'Цитата завершена'), _defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Конфигурация сайта'), _defineProperty(_Receipt$Pos_Settings, "Language", 'Язык'), _defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Валюта по умолчанию'), _defineProperty(_Receipt$Pos_Settings, "LoginCaptcha", 'Войти Captcha'), _defineProperty(_Receipt$Pos_Settings, "DefaultEmail", 'Почта по умолчанию'), _defineProperty(_Receipt$Pos_Settings, "SiteName", 'Название сайта'), _defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Изменить логотип'), _defineProperty(_Receipt$Pos_Settings, "SMTPConfiguration", 'Конфигурация SMTP'), _defineProperty(_Receipt$Pos_Settings, "HOST", 'ВЕДУЩИЙ'), _defineProperty(_Receipt$Pos_Settings, "PORT", 'ПОРТ'), _defineProperty(_Receipt$Pos_Settings, "encryption", 'Шифрование'), _defineProperty(_Receipt$Pos_Settings, "SMTPIncorrect", 'Неправильная конфигурация SMTP'), _defineProperty(_Receipt$Pos_Settings, "PaymentsReturns", 'Платежи Возврат'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoices", 'Возврат счетов'), _defineProperty(_Receipt$Pos_Settings, "ReturnsInvoicesData", 'Возвращает данные счетов-фактур'), _defineProperty(_Receipt$Pos_Settings, "ShowAll", 'Показать все записи всех пользователей'), _defineProperty(_Receipt$Pos_Settings, "Discount", 'Скидка'), _defineProperty(_Receipt$Pos_Settings, "OrderTax", 'Налог на заказ'), _defineProperty(_Receipt$Pos_Settings, "Shipping", 'Перевозка'), _defineProperty(_Receipt$Pos_Settings, "CompanyName", 'Название компании'), _defineProperty(_Receipt$Pos_Settings, "CompanyPhone", 'Телефон компании'), _defineProperty(_Receipt$Pos_Settings, "CompanyAdress", 'Адрес компании'), _defineProperty(_Receipt$Pos_Settings, "Code", 'Код'), _defineProperty(_Receipt$Pos_Settings, "image", 'образ'), _defineProperty(_Receipt$Pos_Settings, "Printbarcode", 'Распечатать штрих-код'), _defineProperty(_Receipt$Pos_Settings, "ReturnsCustomers", 'Возвращает клиентов'), _defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Возврат Поставщикам'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnCustomers", 'Возврат счета-фактуры клиента'), _defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Счет-фактура возврата поставщика'), _defineProperty(_Receipt$Pos_Settings, "NodataAvailable", 'Данные недоступны'), _defineProperty(_Receipt$Pos_Settings, "ProductImage", 'Изображение продукта'), _defineProperty(_Receipt$Pos_Settings, "Barcode", 'Штрих-код'), _defineProperty(_Receipt$Pos_Settings, "pointofsales", 'Точка продаж'), _defineProperty(_Receipt$Pos_Settings, "CustomUpload", 'Пользовательская загрузка'), _defineProperty(_Receipt$Pos_Settings, "pointofsaleManagement", 'точка управления продажами'), _defineProperty(_Receipt$Pos_Settings, "Adjustment", 'Регулировка'), _defineProperty(_Receipt$Pos_Settings, "Updat", 'Обновить'), _defineProperty(_Receipt$Pos_Settings, "Reset", 'Сброс настроек'), _defineProperty(_Receipt$Pos_Settings, "print", 'Распечатать'), _defineProperty(_Receipt$Pos_Settings, "SearchByEmail", 'Поиск по почте'), _defineProperty(_Receipt$Pos_Settings, "ChooseProduct", 'Выберите продукт'), _defineProperty(_Receipt$Pos_Settings, "Qty", 'Кол-во'), _defineProperty(_Receipt$Pos_Settings, "Items", 'Предметы'), _defineProperty(_Receipt$Pos_Settings, "AmountHT", 'Количество'), _defineProperty(_Receipt$Pos_Settings, "AmountTTC", 'общая сумма'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectSupplier", 'Пожалуйста, выберите поставщика'), _defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Пожалуйста, выберите статус'), _defineProperty(_Receipt$Pos_Settings, "PayeBy", 'Оплачивается'), _defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Выберите склад'), _defineProperty(_Receipt$Pos_Settings, "payNo