<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <title>Client  : <?php echo e($client['client_name']); ?></title>
      <link rel="stylesheet" href="<?php echo e(asset('/css/pdf_style.css')); ?>" media="all" />
   </head>

   <body>
      <header class="clearfix">
         <div id="logo">
         <img src="<?php echo e(asset('/images/'.$setting['logo'])); ?>">
         </div>
        
         <div id="Title-heading">
               Client  : <?php echo e($client['client_name']); ?>

         </div>
         </div>
      </header>
      <main>
         <div id="details" class="clearfix">
            <div id="client">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Customer Details</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div><strong>Full Name:</strong> <?php echo e($client['client_name']); ?></div>
                           <div><strong>Phone:</strong> <?php echo e($client['phone']); ?></div>
                           <div><strong>Total Sales:</strong> <?php echo e($client['total_sales']); ?></div>
                           <div><strong>Total Amount:</strong> <?php echo e($symbol); ?> <?php echo e($client['total_amount']); ?></div>
                           <div><strong>Total Paid:</strong> <?php echo e($symbol); ?> <?php echo e($client['total_paid']); ?></div>
                           <div><strong>Total Sales Due:</strong> <?php echo e($symbol); ?> <?php echo e($client['due']); ?></div>
                           <div><strong>Total Sell Return Due:</strong> <?php echo e($symbol); ?> <?php echo e($client['return_Due']); ?></div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
            <div id="invoice">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Company Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div id="comp"><?php echo e($setting['CompanyName']); ?></div>
                           <div><strong>Address:</strong>  <?php echo e($setting['CompanyAdress']); ?></div>
                           <div><strong>Phone:</strong>  <?php echo e($setting['CompanyPhone']); ?></div>
                           <div><strong>Email:</strong>  <?php echo e($setting['email']); ?></div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
         </div>
         <div id="details_inv">
            <h3 style="margin-bottom:10px">
                  All Sales ( Unpaid/Partial )
            </h3>
            <table  class="table-sm">
               <thead>
                  <tr>
                     <th>DATE</th>
                     <th>REF</th>
                     <th>PAID</th>
                     <th>DUE</th>
                     <th>PAYMENT STATUS</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                     <td><?php echo e($sale['date']); ?> </td>
                     <td><?php echo e($sale['Ref']); ?></td>
                     <td><?php echo e($symbol); ?> <?php echo e($sale['paid_amount']); ?> </td>
                     <td><?php echo e($symbol); ?> <?php echo e($sale['due']); ?> </td>
                     <td><?php echo e($sale['payment_status']); ?> </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               </tbody>
            </table>
         </div>
      </main>
   </body>
</html>
<?php /**PATH /mnt/volume_sgp1_01/infotechpos/resources/views/pdf/report_client_pdf.blade.php ENDPATH**/ ?>