<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <title>Payment_<?php echo e($payment['Ref']); ?></title>
      <link rel="stylesheet" href="<?php echo e(asset('/css/pdf_style.css')); ?>" media="all" />
   </head>

   <body>
      <header class="clearfix">
         <div id="logo">
         <img src="<?php echo e(asset('/images/'.$setting['logo'])); ?>">
         </div>
         <div id="company">
            <div><strong> Date: </strong><?php echo e($payment['date']); ?></div>
            <div><strong> Number: </strong> <?php echo e($payment['Ref']); ?></div>
         </div>
         <div id="Title-heading">
           Payment  : <?php echo e($payment['Ref']); ?>

         </div>
         </div>
      </header>
      <main>
         <div id="details" class="clearfix">
            <div id="client">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Supplier Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div><strong>Name:</strong> <?php echo e($payment['supplier_name']); ?></div>
                           <div><strong>Phone:</strong> <?php echo e($payment['supplier_phone']); ?></div>
                           <div><strong>Adress:</strong> <?php echo e($payment['supplier_adr']); ?></div>
                           <div><strong>Email:</strong> <?php echo e($payment['supplier_email']); ?></div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
            <div id="invoice">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Company Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div id="comp"><?php echo e($setting['CompanyName']); ?></div>
                           <div><strong>Adress:</strong>  <?php echo e($setting['CompanyAdress']); ?></div>
                           <div><strong>Phone:</strong>  <?php echo e($setting['CompanyPhone']); ?></div>
                           <div><strong>Email:</strong>  <?php echo e($setting['email']); ?></div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
         </div>
         <div id="details_inv">
            <table class="table-sm">
               <thead>
                  <tr>
                     <th>Purchase</th>
                     <th>Paid By</th>
                     <th>Amount</th>
                  </tr>
               </thead>
               <tbody>
                  <tr>
                     <td><?php echo e($payment['purchase_Ref']); ?></td>
                     <td><?php echo e($payment['Reglement']); ?></td>
                     <td><?php echo e($symbol); ?> <?php echo e($payment['montant']); ?> </td>
                  </tr>
               </tbody>
            </table>
         </div>
         
         <div id="signature">
            <?php if($setting['is_invoice_footer'] && $setting['invoice_footer'] !==null): ?>
               <p><?php echo e($setting['invoice_footer']); ?></p>
            <?php endif; ?>
         </div>
      </main>
   </body>
</html><?php /**PATH /mnt/volume_sgp1_01/infotechpos/resources/views/pdf/payments_purchase.blade.php ENDPATH**/ ?>