<?php
/**
 * TfaApplicationConfiguration
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Model;

use ArrayAccess;
use Infobip\ObjectSerializer;

/**
 * TfaApplicationConfiguration Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TfaApplicationConfiguration implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TfaApplicationConfiguration';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'allowMultiplePinVerifications' => 'bool',
        'pinAttempts' => 'int',
        'pinTimeToLive' => 'string',
        'sendPinPerApplicationLimit' => 'string',
        'sendPinPerPhoneNumberLimit' => 'string',
        'verifyPinLimit' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'allowMultiplePinVerifications' => null,
        'pinAttempts' => 'int32',
        'pinTimeToLive' => null,
        'sendPinPerApplicationLimit' => null,
        'sendPinPerPhoneNumberLimit' => null,
        'verifyPinLimit' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'allowMultiplePinVerifications' => 'allowMultiplePinVerifications',
        'pinAttempts' => 'pinAttempts',
        'pinTimeToLive' => 'pinTimeToLive',
        'sendPinPerApplicationLimit' => 'sendPinPerApplicationLimit',
        'sendPinPerPhoneNumberLimit' => 'sendPinPerPhoneNumberLimit',
        'verifyPinLimit' => 'verifyPinLimit'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'allowMultiplePinVerifications' => 'setAllowMultiplePinVerifications',
        'pinAttempts' => 'setPinAttempts',
        'pinTimeToLive' => 'setPinTimeToLive',
        'sendPinPerApplicationLimit' => 'setSendPinPerApplicationLimit',
        'sendPinPerPhoneNumberLimit' => 'setSendPinPerPhoneNumberLimit',
        'verifyPinLimit' => 'setVerifyPinLimit'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'allowMultiplePinVerifications' => 'getAllowMultiplePinVerifications',
        'pinAttempts' => 'getPinAttempts',
        'pinTimeToLive' => 'getPinTimeToLive',
        'sendPinPerApplicationLimit' => 'getSendPinPerApplicationLimit',
        'sendPinPerPhoneNumberLimit' => 'getSendPinPerPhoneNumberLimit',
        'verifyPinLimit' => 'getVerifyPinLimit'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }





    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['allowMultiplePinVerifications'] = $data['allowMultiplePinVerifications'] ?? true;
        $this->container['pinAttempts'] = $data['pinAttempts'] ?? 10;
        $this->container['pinTimeToLive'] = $data['pinTimeToLive'] ?? '15m';
        $this->container['sendPinPerApplicationLimit'] = $data['sendPinPerApplicationLimit'] ?? '10000/1d';
        $this->container['sendPinPerPhoneNumberLimit'] = $data['sendPinPerPhoneNumberLimit'] ?? '3/1d';
        $this->container['verifyPinLimit'] = $data['verifyPinLimit'] ?? '1/3s';
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets allowMultiplePinVerifications
     *
     * @return bool|null
     */
    public function getAllowMultiplePinVerifications()
    {
        return $this->container['allowMultiplePinVerifications'];
    }

    /**
     * Sets allowMultiplePinVerifications
     *
     * @param bool|null $allowMultiplePinVerifications Indicates whether multiple PIN verification is allowed.
     *
     * @return self
     */
    public function setAllowMultiplePinVerifications($allowMultiplePinVerifications)
    {
        $this->container['allowMultiplePinVerifications'] = $allowMultiplePinVerifications;

        return $this;
    }

    /**
     * Gets pinAttempts
     *
     * @return int|null
     */
    public function getPinAttempts()
    {
        return $this->container['pinAttempts'];
    }

    /**
     * Sets pinAttempts
     *
     * @param int|null $pinAttempts Number of possible PIN attempts.
     *
     * @return self
     */
    public function setPinAttempts($pinAttempts)
    {
        $this->container['pinAttempts'] = $pinAttempts;

        return $this;
    }

    /**
     * Gets pinTimeToLive
     *
     * @return string|null
     */
    public function getPinTimeToLive()
    {
        return $this->container['pinTimeToLive'];
    }

    /**
     * Sets pinTimeToLive
     *
     * @param string|null $pinTimeToLive Validity period of PIN in specified time unit. Required format: `{timeLength}{timeUnit}`. `timeLength` is optional with a default value of 1. `timeUnit` can be set to: `ms`, `s`, `m`, `h` or `d` representing milliseconds, seconds, minutes, hours, and days respectively. Must not exceed one year, although much lower value is recommended.
     *
     * @return self
     */
    public function setPinTimeToLive($pinTimeToLive)
    {
        $this->container['pinTimeToLive'] = $pinTimeToLive;

        return $this;
    }

    /**
     * Gets sendPinPerApplicationLimit
     *
     * @return string|null
     */
    public function getSendPinPerApplicationLimit()
    {
        return $this->container['sendPinPerApplicationLimit'];
    }

    /**
     * Sets sendPinPerApplicationLimit
     *
     * @param string|null $sendPinPerApplicationLimit Overall number of requests over a specififed time period for generating a PIN and sending an SMS using a single application. Required format: `{attempts}/{timeLength}{timeUnit}`. `attempts` is mandatory and `timeLength` is optional with a default value of 1. `timeUnit` is one of: `ms`, `s`, `m`, `h` or `d` representing milliseconds, seconds, minutes, hours, and days respectively. Must not exceed one year, although much lower value is recommended.
     *
     * @return self
     */
    public function setSendPinPerApplicationLimit($sendPinPerApplicationLimit)
    {
        $this->container['sendPinPerApplicationLimit'] = $sendPinPerApplicationLimit;

        return $this;
    }

    /**
     * Gets sendPinPerPhoneNumberLimit
     *
     * @return string|null
     */
    public function getSendPinPerPhoneNumberLimit()
    {
        return $this->container['sendPinPerPhoneNumberLimit'];
    }

    /**
     * Sets sendPinPerPhoneNumberLimit
     *
     * @param string|null $sendPinPerPhoneNumberLimit Number of requests over a specififed time period for generating a PIN and sending an SMS to one phone number (MSISDN). Required format: `{attempts}/{timeLength}{timeUnit}`. `attempts` is mandatory and `timeLength` is optional with a default value of 1. `timeUnit` is one of: `ms`, `s`, `m`, `h` or `d` representing milliseconds, seconds, minutes, hours, and days respectively. Must not exceed one year, although much lower value is recommended.
     *
     * @return self
     */
    public function setSendPinPerPhoneNumberLimit($sendPinPerPhoneNumberLimit)
    {
        $this->container['sendPinPerPhoneNumberLimit'] = $sendPinPerPhoneNumberLimit;

        return $this;
    }

    /**
     * Gets verifyPinLimit
     *
     * @return string|null
     */
    public function getVerifyPinLimit()
    {
        return $this->container['verifyPinLimit'];
    }

    /**
     * Sets verifyPinLimit
     *
     * @param string|null $verifyPinLimit The number of PIN verification requests over a specififed time period from one phone number (MSISDN). Required format: `{attempts}/{timeLength}{timeUnit}`. `attempts` is mandatory and `timeLength` is optional with a default value of 1. `timeUnit` is one of: `ms`, `s`, `m`, `h` or `d` representing milliseconds, seconds, minutes, hours, and days respectively. Must not exceed one day, although much lower value is recommended.
     *
     * @return self
     */
    public function setVerifyPinLimit($verifyPinLimit)
    {
        $this->container['verifyPinLimit'] = $verifyPinLimit;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
