<?php
/**
 * WhatsAppTemplatePublicApiRequest
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Model;

use ArrayAccess;
use Infobip\ObjectSerializer;

/**
 * WhatsAppTemplatePublicApiRequest Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class WhatsAppTemplatePublicApiRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WhatsAppTemplatePublicApiRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'language' => 'string',
        'category' => 'string',
        'structure' => '\Infobip\Model\WhatsAppTemplateStructureApiData'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'language' => null,
        'category' => null,
        'structure' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'language' => 'language',
        'category' => 'category',
        'structure' => 'structure'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'language' => 'setLanguage',
        'category' => 'setCategory',
        'structure' => 'setStructure'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'language' => 'getLanguage',
        'category' => 'getCategory',
        'structure' => 'getStructure'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const LANGUAGE_AF = 'af';
    public const LANGUAGE_SQ = 'sq';
    public const LANGUAGE_AR = 'ar';
    public const LANGUAGE_AZ = 'az';
    public const LANGUAGE_BN = 'bn';
    public const LANGUAGE_BG = 'bg';
    public const LANGUAGE_CA = 'ca';
    public const LANGUAGE_ZH_CN = 'zh_CN';
    public const LANGUAGE_ZH_HK = 'zh_HK';
    public const LANGUAGE_ZH_TW = 'zh_TW';
    public const LANGUAGE_HR = 'hr';
    public const LANGUAGE_CS = 'cs';
    public const LANGUAGE_DA = 'da';
    public const LANGUAGE_NL = 'nl';
    public const LANGUAGE_EN = 'en';
    public const LANGUAGE_EN_GB = 'en_GB';
    public const LANGUAGE_EN_US = 'en_US';
    public const LANGUAGE_ET = 'et';
    public const LANGUAGE_FIL = 'fil';
    public const LANGUAGE_FI = 'fi';
    public const LANGUAGE_FR = 'fr';
    public const LANGUAGE_DE = 'de';
    public const LANGUAGE_EL = 'el';
    public const LANGUAGE_GU = 'gu';
    public const LANGUAGE_HA = 'ha';
    public const LANGUAGE_HE = 'he';
    public const LANGUAGE_HI = 'hi';
    public const LANGUAGE_HU = 'hu';
    public const LANGUAGE_ID = 'id';
    public const LANGUAGE_GA = 'ga';
    public const LANGUAGE_IT = 'it';
    public const LANGUAGE_JA = 'ja';
    public const LANGUAGE_KN = 'kn';
    public const LANGUAGE_KK = 'kk';
    public const LANGUAGE_KO = 'ko';
    public const LANGUAGE_LO = 'lo';
    public const LANGUAGE_LV = 'lv';
    public const LANGUAGE_LT = 'lt';
    public const LANGUAGE_MK = 'mk';
    public const LANGUAGE_MS = 'ms';
    public const LANGUAGE_ML = 'ml';
    public const LANGUAGE_MR = 'mr';
    public const LANGUAGE_NB = 'nb';
    public const LANGUAGE_FA = 'fa';
    public const LANGUAGE_PL = 'pl';
    public const LANGUAGE_PT_BR = 'pt_BR';
    public const LANGUAGE_PT_PT = 'pt_PT';
    public const LANGUAGE_PA = 'pa';
    public const LANGUAGE_RO = 'ro';
    public const LANGUAGE_RU = 'ru';
    public const LANGUAGE_SR = 'sr';
    public const LANGUAGE_SK = 'sk';
    public const LANGUAGE_SL = 'sl';
    public const LANGUAGE_ES = 'es';
    public const LANGUAGE_ES_AR = 'es_AR';
    public const LANGUAGE_ES_ES = 'es_ES';
    public const LANGUAGE_ES_MX = 'es_MX';
    public const LANGUAGE_SW = 'sw';
    public const LANGUAGE_SV = 'sv';
    public const LANGUAGE_TA = 'ta';
    public const LANGUAGE_TE = 'te';
    public const LANGUAGE_TH = 'th';
    public const LANGUAGE_TR = 'tr';
    public const LANGUAGE_UK = 'uk';
    public const LANGUAGE_UR = 'ur';
    public const LANGUAGE_UZ = 'uz';
    public const LANGUAGE_VI = 'vi';
    public const LANGUAGE_UNKNOWN = 'unknown';
    public const CATEGORY_ACCOUNT_UPDATE = 'ACCOUNT_UPDATE';
    public const CATEGORY_PAYMENT_UPDATE = 'PAYMENT_UPDATE';
    public const CATEGORY_PERSONAL_FINANCE_UPDATE = 'PERSONAL_FINANCE_UPDATE';
    public const CATEGORY_SHIPPING_UPDATE = 'SHIPPING_UPDATE';
    public const CATEGORY_RESERVATION_UPDATE = 'RESERVATION_UPDATE';
    public const CATEGORY_ISSUE_RESOLUTION = 'ISSUE_RESOLUTION';
    public const CATEGORY_APPOINTMENT_UPDATE = 'APPOINTMENT_UPDATE';
    public const CATEGORY_TRANSPORTATION_UPDATE = 'TRANSPORTATION_UPDATE';
    public const CATEGORY_TICKET_UPDATE = 'TICKET_UPDATE';
    public const CATEGORY_ALERT_UPDATE = 'ALERT_UPDATE';
    public const CATEGORY_AUTO_REPLY = 'AUTO_REPLY';



    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getLanguageAllowableValues()
    {
        return [
            self::LANGUAGE_AF,
            self::LANGUAGE_SQ,
            self::LANGUAGE_AR,
            self::LANGUAGE_AZ,
            self::LANGUAGE_BN,
            self::LANGUAGE_BG,
            self::LANGUAGE_CA,
            self::LANGUAGE_ZH_CN,
            self::LANGUAGE_ZH_HK,
            self::LANGUAGE_ZH_TW,
            self::LANGUAGE_HR,
            self::LANGUAGE_CS,
            self::LANGUAGE_DA,
            self::LANGUAGE_NL,
            self::LANGUAGE_EN,
            self::LANGUAGE_EN_GB,
            self::LANGUAGE_EN_US,
            self::LANGUAGE_ET,
            self::LANGUAGE_FIL,
            self::LANGUAGE_FI,
            self::LANGUAGE_FR,
            self::LANGUAGE_DE,
            self::LANGUAGE_EL,
            self::LANGUAGE_GU,
            self::LANGUAGE_HA,
            self::LANGUAGE_HE,
            self::LANGUAGE_HI,
            self::LANGUAGE_HU,
            self::LANGUAGE_ID,
            self::LANGUAGE_GA,
            self::LANGUAGE_IT,
            self::LANGUAGE_JA,
            self::LANGUAGE_KN,
            self::LANGUAGE_KK,
            self::LANGUAGE_KO,
            self::LANGUAGE_LO,
            self::LANGUAGE_LV,
            self::LANGUAGE_LT,
            self::LANGUAGE_MK,
            self::LANGUAGE_MS,
            self::LANGUAGE_ML,
            self::LANGUAGE_MR,
            self::LANGUAGE_NB,
            self::LANGUAGE_FA,
            self::LANGUAGE_PL,
            self::LANGUAGE_PT_BR,
            self::LANGUAGE_PT_PT,
            self::LANGUAGE_PA,
            self::LANGUAGE_RO,
            self::LANGUAGE_RU,
            self::LANGUAGE_SR,
            self::LANGUAGE_SK,
            self::LANGUAGE_SL,
            self::LANGUAGE_ES,
            self::LANGUAGE_ES_AR,
            self::LANGUAGE_ES_ES,
            self::LANGUAGE_ES_MX,
            self::LANGUAGE_SW,
            self::LANGUAGE_SV,
            self::LANGUAGE_TA,
            self::LANGUAGE_TE,
            self::LANGUAGE_TH,
            self::LANGUAGE_TR,
            self::LANGUAGE_UK,
            self::LANGUAGE_UR,
            self::LANGUAGE_UZ,
            self::LANGUAGE_VI,
            self::LANGUAGE_UNKNOWN,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCategoryAllowableValues()
    {
        return [
            self::CATEGORY_ACCOUNT_UPDATE,
            self::CATEGORY_PAYMENT_UPDATE,
            self::CATEGORY_PERSONAL_FINANCE_UPDATE,
            self::CATEGORY_SHIPPING_UPDATE,
            self::CATEGORY_RESERVATION_UPDATE,
            self::CATEGORY_ISSUE_RESOLUTION,
            self::CATEGORY_APPOINTMENT_UPDATE,
            self::CATEGORY_TRANSPORTATION_UPDATE,
            self::CATEGORY_TICKET_UPDATE,
            self::CATEGORY_ALERT_UPDATE,
            self::CATEGORY_AUTO_REPLY,
        ];
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = $data['name'] ?? null;
        $this->container['language'] = $data['language'] ?? null;
        $this->container['category'] = $data['category'] ?? null;
        $this->container['structure'] = $data['structure'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['language'] === null) {
            $invalidProperties[] = "'language' can't be null";
        }
        $allowedValues = $this->getLanguageAllowableValues();
        if (!is_null($this->container['language']) && !in_array($this->container['language'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'language', must be one of '%s'",
                $this->container['language'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['category'] === null) {
            $invalidProperties[] = "'category' can't be null";
        }
        $allowedValues = $this->getCategoryAllowableValues();
        if (!is_null($this->container['category']) && !in_array($this->container['category'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'category', must be one of '%s'",
                $this->container['category'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['structure'] === null) {
            $invalidProperties[] = "'structure' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Template name. Must only contain lowercase alphanumeric characters and underscores.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string $language The language code or locale to use. Multiple templates with different language codes can be registered under the same template name.
     *
     * @return self
     */
    public function setLanguage($language)
    {
        $allowedValues = $this->getLanguageAllowableValues();
        if (!in_array($language, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'language', must be one of '%s'",
                    $language,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string $category Category of the template.
     *
     * @return self
     */
    public function setCategory($category)
    {
        $allowedValues = $this->getCategoryAllowableValues();
        if (!in_array($category, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'category', must be one of '%s'",
                    $category,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets structure
     *
     * @return \Infobip\Model\WhatsAppTemplateStructureApiData
     */
    public function getStructure()
    {
        return $this->container['structure'];
    }

    /**
     * Sets structure
     *
     * @param \Infobip\Model\WhatsAppTemplateStructureApiData $structure structure
     *
     * @return self
     */
    public function setStructure($structure)
    {
        $this->container['structure'] = $structure;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
